/*
 * Decompiled with CFR 0.152.
 */
package Zookeeper;

import Coordinator_Worker.Worker;
import Zookeeper.OnElectionCallback;
import Zookeeper.ServiceRegistry;
import grpc.server.grpcServer;
import org.apache.zookeeper.KeeperException;

public class OnElectionAction
implements OnElectionCallback {
    private final ServiceRegistry serviceRegistry;
    private final int port;

    public OnElectionAction(ServiceRegistry serviceRegistry, int port) {
        this.serviceRegistry = serviceRegistry;
        this.port = port;
    }

    @Override
    public void onElectedToBeLeader() {
        this.serviceRegistry.unregisterFromCluster();
        this.serviceRegistry.registerForUpdates();
        Runnable task = () -> {
            try {
                grpcServer.startGrpcServer();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        Thread thread = new Thread(task);
        thread.start();
    }

    @Override
    public void onWorker() {
        try {
            String username = System.getProperty("user.name");
            String currentServerAddress = "192.168.56.116," + username + "," + this.port;
            this.serviceRegistry.registerToCluster(currentServerAddress);
            Runnable task = () -> Worker.startWorker();
            Thread thread = new Thread(task);
            thread.start();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
    }
}

