/*
 * Decompiled with CFR 0.152.
 */
package Coordinator_Worker;

import Coordinator_Worker.Communication;
import Coordinator_Worker.DataObject;
import Coordinator_Worker.Document;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Worker {
    private static final int PORT = 12363;
    private String nodeName;
    private String ipAddress;
    private String userName;

    public Worker(String fullPathNode) {
        this.nodeName = fullPathNode;
    }

    /*
     * Loose catch block
     */
    public static void startWorker() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(12363);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (true) {
            try {
                while (true) {
                    System.out.println("Waiting Request");
                    Socket coordinatorSocket = serverSocket.accept();
                    DataObject data = Communication.receiveData(coordinatorSocket);
                    System.out.println("Received data from coordinator: " + data.getDataString() + ", " + data.getFileNames());
                    ConcurrentLinkedQueue<Document> response = new ConcurrentLinkedQueue<Document>();
                    response.addAll(Worker.IDF(data));
                    Communication.sendResult(coordinatorSocket, response);
                    coordinatorSocket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static ConcurrentLinkedQueue<Document> IDF(DataObject data) {
        ConcurrentLinkedQueue<Document> documents = new ConcurrentLinkedQueue<Document>();
        String searchQuery = data.getDataString();
        String[] terms = searchQuery.split("\\s+");
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            for (String fileName : data.getFileNames()) {
                File file = new File("C:\\Users\\Abdullah\\Downloads\\network-communication-master\\Cordinator_Worker\\src\\main\\resources\\files\\" + fileName);
                Runnable task = () -> Worker.processFile(file, terms, documents);
                executorService.submit(task);
            }
            executorService.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            executorService.shutdown();
        }
        return documents;
    }

    private static void processFile(File file, String[] terms, ConcurrentLinkedQueue<Document> documents) {
        Document document = new Document(file.getName());
        double totalWords = 0.0;
        try {
            String content = new String(Files.readAllBytes(file.toPath()));
            String[] words = content.split("\\s+");
            for (String term : terms) {
                double frequency = 0.0;
                for (String word : words) {
                    if (word.equals(term)) {
                        frequency += 1.0;
                    }
                    totalWords += 1.0;
                }
                Double d = frequency / totalWords;
                document.setTf(term, d);
                documents.offer(document);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public static List<String> getIpAddress(List<Worker> workers) {
        ArrayList<String> allAddress = new ArrayList<String>();
        for (Worker worker : workers) {
            allAddress.add(worker.ipAddress);
        }
        return allAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getUserName() {
        return this.userName;
    }
}

