/*
 * Decompiled with CFR 0.152.
 */
package Coordinator_Worker;

import Coordinator_Worker.Communication;
import Coordinator_Worker.Document;
import Coordinator_Worker.Term;
import Coordinator_Worker.Worker;
import Zookeeper.ServiceRegistry;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Coordinator {
    private static final int PORT = 12363;

    public static TreeMap<String, Double> startCoordinator(String dataString) {
        ConcurrentLinkedQueue workersResult = new ConcurrentLinkedQueue();
        TreeMap<String, Double> IDF = new TreeMap<String, Double>();
        try {
            String[] parts = dataString.split("\\s");
            ArrayList<Term> terms = new ArrayList<Term>();
            for (String part : parts) {
                terms.add(new Term(part));
            }
            TreeMap response = new TreeMap();
            List<String> fileNames = Coordinator.getFileNamesInDirectory("src/main/resources/files");
            int eachWorkerFiles = fileNames.size() / ServiceRegistry.getWorkers().size();
            int mode = fileNames.size() % ServiceRegistry.getWorkers().size();
            int index = 0;
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            if (ServiceRegistry.getWorkers() != null) {
                for (Worker worker : ServiceRegistry.getWorkers()) {
                    ArrayList<String> workerFilesList = new ArrayList<String>();
                    for (int i = 0; i < eachWorkerFiles; ++i) {
                        workerFilesList.add(fileNames.get(index));
                        if (mode == 0 || ++index == fileNames.size()) continue;
                        workerFilesList.add(fileNames.get(index));
                        ++index;
                    }
                    Socket workerSocket = new Socket("127.0.0.1", 12363);
                    Runnable task = () -> Coordinator.processRequest(workerSocket, workerFilesList, dataString, workersResult);
                    executorService.submit(task);
                }
                executorService.awaitTermination(5L, TimeUnit.SECONDS);
                for (int i = 0; i < terms.size(); ++i) {
                    for (Document document : workersResult) {
                        Map<String, Double> tf = document.getTf();
                        if (!(tf.get(((Term)terms.get(i)).getTermName()) > 0.0)) continue;
                        ((Term)terms.get(i)).increase();
                    }
                }
                for (Document document : workersResult) {
                    document.setTerms(terms);
                    document.CalculateIDF(fileNames.size());
                    IDF.put(document.getName(), document.getIDF());
                }
                System.out.println("IDF Files: " + IDF);
                executorService.shutdown();
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            return IDF;
        }
    }

    public static List<String> getFileNamesInDirectory(String directoryPath) {
        ArrayList<String> arrayList;
        block9: {
            Path directory = Paths.get(directoryPath, new String[0]);
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);
            try {
                ArrayList<String> fileNames = new ArrayList<String>();
                for (Path path : directoryStream) {
                    fileNames.add(path.getFileName().toString());
                }
                arrayList = fileNames;
                if (directoryStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
            directoryStream.close();
        }
        return arrayList;
    }

    private static void processRequest(Socket clientSocket, List<String> fileNames, String dataString, ConcurrentLinkedQueue<Document> documents) {
        try {
            Communication.sendData(clientSocket, dataString, fileNames);
            ConcurrentLinkedQueue<Document> d = Communication.receiveResult(clientSocket);
            documents.addAll(d);
            clientSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

