package Coordinator_Worker;

import java.io.Serializable;
import java.util.List;

// Serializable class to represent the data being sent between Coordinator and Worker
class DataObject implements Serializable {
    private String dataString;  // String data to be processed
    private List<String> fileNames;  // List of file names associated with the data

    // Constructor to initialize DataObject with dataString and fileNames
    public DataObject(String dataString, List<String> fileNames) {
        this.dataString = dataString;
        this.fileNames = fileNames;
    }

    // Getter method to retrieve the dataString
    public String getDataString() {
        return dataString;
    }

    // Getter method to retrieve the list of file names
    public List<String> getFileNames() {
        return fileNames;
    }
}
