package Coordinator_Worker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Serializable class to represent a document with term frequency (TF) and inverse document frequency (IDF)
public class Document implements Serializable {
    private String name;  // Name of the document
    private Map<String, Double> tf = new HashMap<>();  // Term Frequency (TF) for each term in the document
    private List<Term> terms;  // List of terms in the document
    private Double IDF = 0.0;  // Inverse Document Frequency (IDF) for the document

    // Constructor to initialize a Document with a name
    public Document(String name) {
        this.name = name;
        this.terms = new ArrayList<>();  // Initialize the terms list
    }

    // Getter method to retrieve the name of the document
    public String getName() {
        return name;
    }

    // Getter method to retrieve the Term Frequency (TF) map for the document
    public Map<String, Double> getTf() {
        return tf;
    }

    // Setter method to set the terms for the document
    public void setTerms(List<Term> terms) {
        this.terms.addAll(terms);
    }

    // Setter method to set the Term Frequency (TF) for a specific term in the document
    public void setTf(String termName, Double value) {
        this.tf.put(termName, value);
    }

    // Getter method to retrieve the Inverse Document Frequency (IDF) for the document
    public Double getIDF() {
        return IDF;
    }

    // Method to calculate the Inverse Document Frequency (IDF) for the document
    public void CalculateIDF(int totalNumFiles) {
        for (int i = 0; i < terms.size(); i++) {
            Term term = terms.get(i);
            IDF += Math.log(term.getNumOfFile() / (double) totalNumFiles) * tf.get(term.getTermName());
        }
    }
}
