import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.TreeMap;

public class ClientHttp {
    public static void main(String[] args) {
        try {
            // Replace with your server URL
            String serverUrl = "http://localhost:7777/search";

            // Replace with your input string
            String inputString = "the_car";

            // Create a request object with the input string
            HttpRequest request = HttpRequest.newBuilder()
                    .uri(URI.create(serverUrl + "?inputString=" + inputString))
                    .build();

            // Create an HTTP client
            HttpClient httpClient = HttpClient.newHttpClient();

            // Send the request and get the response
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());

            // Check if the request was successful (status code 200)
            if (response.statusCode() == 200) {
                // Parse the JSON response into a TreeMap
                ObjectMapper objectMapper = new ObjectMapper();
                Map<String, Double> outputMap = objectMapper.readValue(response.body(), TreeMap.class);

                // Use the outputMap as needed
                System.out.println("Received TreeMap from server: " + outputMap);
            } else {
                System.out.println("Error: " + response.statusCode() + ", " + response.body());
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
