package Coordinator_Worker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Document implements Serializable {
    private String name;
    private Map<String,Double> tf;
    private List<Term> terms;
    private Double IDF=0.0;
    public Document(String name)
    {
        this.name = name;
    }
    public String getName() {
        return name;
    }

    public Map<String, Double> getTf() {
        return tf;
    }

    public void setTerms(List<Term> terms) {
        this.terms.addAll(terms);
    }

    public void setTf(String fileName, Double value ) {
        this.tf.put(fileName,value);
    }

    public Double getIDF() {
        return IDF;
    }

    public void CalculateIDF(int totalNumFiles){
        for(int i=0; i < terms.size();i++) {
            Term term = terms.get(i);
            IDF += Math.log(term.getNumOfFile() / totalNumFiles) * tf.get(term.getTermName());
        }
    }
}
