package Coordinator_Worker;

import Zookeeper.ServiceRegistry;

import java.io.IOException;
import java.net.Socket;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;
import java.util.concurrent.*;

public class Coordinator {
    private static final int PORT = 4444;

    public static void startCoordinator() {
        try {
            List<Future<List<Document>>> futures = new ArrayList<>();
            List<Document> resultFromAllWorkers=new ArrayList<>();
            String dataString = "the car";

            String [] parts = dataString.split("\\s");
            List<Term> terms = new ArrayList<>();
            for (String part:parts) {
                terms.add(new Term(part));
            }

            TreeMap<String,Double> response= new TreeMap<>();

            List<String> fileNames = getFileNamesInDirectory("src/main/resources");

            int eachWorkerFiles = fileNames.size() / ServiceRegistry.getWorkers().size();

            int mode = fileNames.size() % ServiceRegistry.getWorkers().size();

            int index = 0;

            List<CoordinatorHandler> handlerList = new ArrayList<>();
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            if(ServiceRegistry.getWorkers().size()==1){
                // Connect to worker
                Socket workerSocket = new Socket("127.0.0.1", PORT);
                // Create a CoordinatorHandler instance for each worker
                CoordinatorHandler handler = new CoordinatorHandler(dataString,workerSocket, fileNames);
                handlerList.add(handler);
                // Start the CoordinatorHandler thread
                futures.add(executorService.submit(handler));
            }else {
                for (Worker worker : ServiceRegistry.getWorkers()) {
                    List<String> workerFilesList = new ArrayList<>();
                    for (int i = 0; i < eachWorkerFiles; i++) {
                        workerFilesList.add(fileNames.get(index));
                        index++;

                        if (mode != 0) {
                            if (index != fileNames.size()) {
                                workerFilesList.add(fileNames.get(index));
                                index++;
                            }
                        }
                        // Connect to worker
                        Socket workerSocket = new Socket("127.0.0.1", PORT);
                        // Create a CoordinatorHandler instance for each worker
                        CoordinatorHandler handler = new CoordinatorHandler(dataString, workerSocket, workerFilesList);
                        handlerList.add(handler);
                        // Start the CoordinatorHandler thread
                        futures.add(executorService.submit(handler));
                    }
                }
            }
            for (Future<List<Document>> future : futures) {
                try {
                    List<Document> documents = future.get();
                    resultFromAllWorkers.addAll(documents);
                } catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            executorService.awaitTermination(5,TimeUnit.MICROSECONDS);

            // Shut down the executor after all tasks are submitted
            executorService.shutdown();

            for (int i=0 ; i<terms.size();i++) {
            for (Document document:resultFromAllWorkers) {
                Map<String,Double> tf = document.getTf();
                    if(tf.get(terms.get(i))>0);
                         terms.get(i).increase();
                }
            }
            TreeMap<String,Double> IDF = new TreeMap<>();
            for (Document document: resultFromAllWorkers) {
                document.setTerms(terms);
                document.CalculateIDF(fileNames.size());
                IDF.put(document.getName(),document.getIDF());
            }
            System.out.println("IDF Files: "+ IDF);

        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getFileNamesInDirectory(String directoryPath) {
        try {
            // Create a Path object for the specified directory
            Path directory = Paths.get(directoryPath);

            // Use try-with-resources to open a DirectoryStream and iterate over the files
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory)) {
                // Create a list to store file names
                List<String> fileNames = new ArrayList<>();

                // Iterate over the files in the directory
                for (Path path : directoryStream) {
                    // Get the file name and add it to the list
                    fileNames.add(path.getFileName().toString());
                }

                // Return the list of file names
                return fileNames;
            }
        } catch (IOException e) {
            // Handle exceptions, e.g., directory not found
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    static class CoordinatorHandler implements Callable<List<Document>> {
        private Socket clientSocket;

        private List<String> fileNames = new ArrayList<>();
      //  private List<Document> result = new ArrayList<>();

        String dataString= "";

        public CoordinatorHandler(String dataString,Socket socket, List<String> fileNames) {
            this.clientSocket = socket;
            this.fileNames.addAll(fileNames);
            this.dataString=dataString;
        }

        @Override
        public List<Document> call() {
            List<Document> result=new ArrayList<>();
            try {
                // Assume the coordinator sends a string and a list of file names


                // Send data to worker
                Communication.sendData(clientSocket, dataString, fileNames);

                // Receive results from worker
                result = Communication.receiveResult(clientSocket);
                System.out.println("Received result from worker: " + result);
                clientSocket.close();

            } catch (IOException e) {
                e.printStackTrace();
            } catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            } finally {
                return result;
            }
        }

//        public List<Document> getResult() {
//            return result;
//        }
    }
}
