package Coordinator_Worker;

import java.io.*;
import java.net.Socket;
import java.util.List;
import java.util.Map;

public class Communication {
    public static void sendData(Socket socket, String dataString, List<String> fileNames) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
        objectOutputStream.writeObject(new DataObject(dataString, fileNames));
    }
    public static List<Document> receiveResult(Socket socket) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
        return (List<Document>) objectInputStream.readObject();
    }
    public static DataObject receiveData(Socket socket) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
        return (DataObject) objectInputStream.readObject();
    }

    public static void sendResult(Socket socket, List<Document> response) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
        objectOutputStream.writeObject(response);
    }
}
