/*
 * Decompiled with CFR 0.152.
 */
package Zookeeper;

import Coordinator_Worker.Coordinator;
import Coordinator_Worker.Worker;
import Zookeeper.OnElectionCallback;
import Zookeeper.ServiceRegistry;
import org.apache.zookeeper.KeeperException;

public class OnElectionAction
implements OnElectionCallback {
    private final ServiceRegistry serviceRegistry;
    private final int port;

    public OnElectionAction(ServiceRegistry serviceRegistry, int port) {
        this.serviceRegistry = serviceRegistry;
        this.port = port;
    }

    @Override
    public void onElectedToBeLeader() throws InterruptedException, KeeperException {
        this.serviceRegistry.unregisterFromCluster();
        this.serviceRegistry.registerForUpdates();
        Thread.sleep(30000L);
        Coordinator.startCoordinator();
    }

    @Override
    public void onWorker() {
        try {
            String username = System.getProperty("user.name");
            String currentServerAddress = "192.168.56.116," + username + "," + this.port;
            this.serviceRegistry.registerToCluster(currentServerAddress);
            Worker.startWorker();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
    }
}

