/*
 * Decompiled with CFR 0.152.
 */
package Zookeeper;

import Zookeeper.OnElectionCallback;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class LeaderElection
implements Watcher {
    private static final String ELECTION_NAMESPACE = "/election";
    private String currentZnodeName;
    private ZooKeeper zooKeeper;
    private OnElectionCallback onElectionCallback;

    public LeaderElection(ZooKeeper zooKeeper, OnElectionCallback onElectionCallback) {
        this.zooKeeper = zooKeeper;
        this.onElectionCallback = onElectionCallback;
    }

    public void volunteerForLeadership() throws InterruptedException, KeeperException {
        String znodePrefix = "/election/c_";
        String znodeFullPath = this.zooKeeper.create(znodePrefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        System.out.println(znodeFullPath);
        this.currentZnodeName = znodeFullPath.replace("/election/", "");
    }

    public void reelectLeader() throws InterruptedException, KeeperException {
        String predecessorName = "";
        Stat predecessorStat = null;
        while (predecessorStat == null) {
            List<String> children = this.zooKeeper.getChildren(ELECTION_NAMESPACE, false);
            Collections.sort(children);
            String smallestChild = children.get(0);
            if (smallestChild.equals(this.currentZnodeName)) {
                System.out.println("I'm a leader");
                this.onElectionCallback.onElectedToBeLeader();
                return;
            }
            System.out.println("I'm not a leader");
            int predecessorIndex = children.indexOf(this.currentZnodeName) - 1;
            predecessorName = children.get(predecessorIndex);
            predecessorStat = this.zooKeeper.exists("/election/" + predecessorName, this);
        }
        this.onElectionCallback.onWorker();
        System.out.println("Watching znode " + predecessorName);
        System.out.println();
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case NodeDeleted: {
                try {
                    this.reelectLeader();
                    break;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (KeeperException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

