/*
 * Decompiled with CFR 0.152.
 */
package Coordinator_Worker;

import Coordinator_Worker.Communication;
import Coordinator_Worker.DataObject;
import Coordinator_Worker.Document;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Worker {
    private static final int PORT = 4444;
    private String nodeName;
    private String ipAddress;
    private String userName;
    private static List<Document> documents = new ArrayList<Document>();

    public Worker(String fullPathNode) {
        this.nodeName = fullPathNode;
    }

    /*
     * Loose catch block
     */
    public static void startWorker() {
        while (true) {
            try {
                while (true) {
                    ServerSocket serverSocket = new ServerSocket(4444);
                    Socket coordinatorSocket = serverSocket.accept();
                    DataObject data = Communication.receiveData(coordinatorSocket);
                    System.out.println("Received data from coordinator: " + data.getDataString() + ", " + data.getFileNames());
                    List<Document> response = Worker.IDF(data);
                    Communication.sendResult(coordinatorSocket, response);
                    coordinatorSocket.close();
                    serverSocket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Document> IDF(DataObject data) {
        String searchQuery = data.getDataString();
        ArrayList<Document> r = new ArrayList<Document>();
        String[] terms = searchQuery.split("\\s+");
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            ArrayList<Callable<Document>> tasks = new ArrayList<Callable<Document>>();
            ArrayList<Future<Document>> futures = new ArrayList<Future<Document>>();
            for (String string : data.getFileNames()) {
                File file = new File("C:\\Users\\Abdullah\\Downloads\\network-communication-master\\Cordinator_Worker\\src\\main\\resources\\" + string);
                Callable<Document> task = () -> Worker.processFile(file, terms);
                tasks.add(task);
                futures.add(executorService.submit(task));
            }
            executorService.awaitTermination(2L, TimeUnit.MILLISECONDS);
            for (Future future : futures) {
                try {
                    Document document = (Document)future.get();
                    r.add(document);
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            executorService.shutdown();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document processFile(File file, String[] terms) {
        Document document = new Document(file.getName());
        int totalWords = 0;
        try {
            String content = new String(Files.readAllBytes(file.toPath()));
            String[] words = content.split("\\s+");
            for (String term : terms) {
                int frequency = 0;
                for (String word : words) {
                    if (word.equals(term)) {
                        ++frequency;
                    }
                    ++totalWords;
                }
                document.getTf().put(term, Double.valueOf(frequency / totalWords));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return document;
        }
    }

    private static synchronized void addToDocuments(Document document) {
        documents.add(document);
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public static List<String> getIpAddress(List<Worker> workers) {
        ArrayList<String> allAddress = new ArrayList<String>();
        for (Worker worker : workers) {
            allAddress.add(worker.ipAddress);
        }
        return allAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getUserName() {
        return this.userName;
    }
}

