/*
 * Decompiled with CFR 0.152.
 */
package Coordinator_Worker;

import Coordinator_Worker.Communication;
import Coordinator_Worker.Document;
import Coordinator_Worker.Term;
import Coordinator_Worker.Worker;
import Zookeeper.ServiceRegistry;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Coordinator {
    private static final int PORT = 4444;

    /*
     * WARNING - void declaration
     */
    public static void startCoordinator() {
        try {
            void var12_21;
            String dataString = "the car";
            String[] parts = dataString.split("\\s");
            ArrayList<Term> terms = new ArrayList<Term>();
            for (String part : parts) {
                terms.add(new Term(part));
            }
            TreeMap response = new TreeMap();
            List<String> fileNames = Coordinator.getFileNamesInDirectory("src/main/resources");
            int eachWorkerFiles = fileNames.size() / ServiceRegistry.getWorkers().size();
            int mode = fileNames.size() % ServiceRegistry.getWorkers().size();
            int index = 0;
            ArrayList<CoordinatorHandler> handlerList = new ArrayList<CoordinatorHandler>();
            CountDownLatch latch = new CountDownLatch(ServiceRegistry.getWorkers().size());
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            if (ServiceRegistry.getWorkers().size() == 1) {
                Socket workerSocket = new Socket("127.0.0.1", 4444);
                CoordinatorHandler coordinatorHandler = new CoordinatorHandler(dataString, workerSocket, fileNames, latch);
                handlerList.add(coordinatorHandler);
                executorService.submit(coordinatorHandler);
            } else {
                for (Worker worker : ServiceRegistry.getWorkers()) {
                    ArrayList<String> workerFilesList = new ArrayList<String>();
                    for (int i = 0; i < eachWorkerFiles; ++i) {
                        workerFilesList.add(fileNames.get(index));
                        if (mode != 0 && ++index != fileNames.size()) {
                            workerFilesList.add(fileNames.get(index));
                            ++index;
                        }
                        Socket workerSocket = new Socket("127.0.0.1", 4444);
                        CoordinatorHandler handler = new CoordinatorHandler(dataString, workerSocket, workerFilesList, latch);
                        handlerList.add(handler);
                        executorService.submit(handler);
                    }
                }
            }
            executorService.shutdown();
            latch.await();
            ArrayList<Document> resultFromAllWorkers = new ArrayList<Document>();
            for (CoordinatorHandler handler : handlerList) {
                resultFromAllWorkers.addAll(handler.getResult());
            }
            boolean bl = false;
            while (var12_21 < terms.size()) {
                for (Document document : resultFromAllWorkers) {
                    Map<String, Double> tf = document.getTf();
                    if (tf.get(terms.get((int)var12_21)) > 0.0) {
                        // empty if block
                    }
                    ((Term)terms.get((int)var12_21)).increase();
                }
                ++var12_21;
            }
            TreeMap<String, Double> treeMap = new TreeMap<String, Double>();
            for (Document document : resultFromAllWorkers) {
                document.setTerms(terms);
                document.CalculateIDF(fileNames.size());
                treeMap.put(document.getName(), document.getIDF());
            }
            System.out.println("IDF Files: " + treeMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getFileNamesInDirectory(String directoryPath) {
        ArrayList<String> arrayList;
        block9: {
            Path directory = Paths.get(directoryPath, new String[0]);
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);
            try {
                ArrayList<String> fileNames = new ArrayList<String>();
                for (Path path : directoryStream) {
                    fileNames.add(path.getFileName().toString());
                }
                arrayList = fileNames;
                if (directoryStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
            directoryStream.close();
        }
        return arrayList;
    }

    static class CoordinatorHandler
    implements Runnable {
        private Socket clientSocket;
        private List<String> fileNames = new ArrayList<String>();
        private List<Document> result = new ArrayList<Document>();
        String dataString = "";

        public CoordinatorHandler(String dataString, Socket socket, List<String> fileNames, CountDownLatch latch) {
            this.clientSocket = socket;
            this.fileNames.addAll(fileNames);
            this.dataString = dataString;
        }

        @Override
        public void run() {
            try {
                Communication.sendData(this.clientSocket, this.dataString, this.fileNames);
                List<Document> result = Communication.receiveResult(this.clientSocket);
                System.out.println("Received result from worker: " + result);
                this.result.addAll(result);
                this.clientSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public List<Document> getResult() {
            return this.result;
        }
    }
}

