/*
 * Decompiled with CFR 0.152.
 */
import Zookeeper.LeaderElection;
import Zookeeper.OnElectionAction;
import Zookeeper.ServiceRegistry;
import ch.qos.logback.classic.Logger;
import java.io.IOException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.LoggerFactory;

public class Application
implements Watcher {
    private static final Logger logger = (Logger)LoggerFactory.getLogger(Application.class);
    private static final String address = "192.168.56.115:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final int DEFAULT_PORT = 8080;
    private ZooKeeper zooKeeper;

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {
        int currentServerPort = args.length == 1 ? Integer.parseInt(args[0]) : 8080;
        Application application = new Application();
        ZooKeeper zooKeeper = application.connectToZookeeper();
        ServiceRegistry serviceRegistry = new ServiceRegistry(zooKeeper);
        OnElectionAction onElectionAction = new OnElectionAction(serviceRegistry, currentServerPort);
        LeaderElection leaderElection = new LeaderElection(zooKeeper, onElectionAction);
        leaderElection.volunteerForLeadership();
        leaderElection.reelectLeader();
        application.run();
        application.close();
    }

    public ZooKeeper connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(address, 3000, this);
        return this.zooKeeper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            this.zooKeeper.wait();
        }
    }

    private void close() throws InterruptedException {
        this.zooKeeper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case None: {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    logger.info("Successfully connected to Zookeeper");
                    break;
                }
                if (watchedEvent.getState() == Watcher.Event.KeeperState.Disconnected) {
                    ZooKeeper zooKeeper = this.zooKeeper;
                    synchronized (zooKeeper) {
                        logger.error("Disconnected from Zookeeper");
                        this.zooKeeper.notifyAll();
                        break;
                    }
                }
                if (watchedEvent.getState() != Watcher.Event.KeeperState.Closed) break;
                logger.error("Closed Successfully");
            }
        }
    }
}

