package com.ali.notificationsvc.models;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;
@Entity
@Data
@Builder
public class Notification {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)

    private int id;
    private int jobId;
    private int companyId;
    private int jobseekerId;
    private String details;
    private boolean isRead;
    private boolean toCompany;
    private LocalDateTime createdAt;

    public Notification(int id, int jobId, int companyId, int jobseekerId, String details, boolean isRead, boolean toCompany, LocalDateTime createdAt) {
        this.id = id;
        this.jobId = jobId;
        this.companyId = companyId;
        this.jobseekerId = jobseekerId;
        this.details = details;
        this.isRead = isRead;
        this.toCompany = toCompany;
        this.createdAt = createdAt;
    }

    public Notification() {
    }
}
