package com.ali.notificationsvc.repositories;

import com.ali.notificationsvc.models.Notification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface INotificationRepository extends JpaRepository<Notification, Integer> {
    @Query("SELECT i FROM Notification i WHERE i.companyId = :companyId AND i.toCompany = true")
    List<Notification> findNotificationsByCompanyId(@Param("companyId") int companyId);
    @Query("SELECT i FROM Notification i WHERE i.jobseekerId = :jobseekerId AND i.toCompany = false")
    List<Notification> findNotificationsByJobseekerId(@Param("jobseekerId") int jobseekerId);

    @Query("SELECT i FROM Notification i WHERE i.jobseekerId = :jobseekerId AND i.isRead = false AND i.toCompany = false")
    List<Notification> findUnreadNotificationsByJobseekerId(@Param("jobseekerId") int jobseekerId);

    @Query("SELECT i FROM Notification i WHERE i.companyId = :companyId AND i.isRead = false AND i.toCompany = true")
    List<Notification> findUnreadNotificationsByCompanyId(@Param("companyId") int companyId);
}
