/*
 * Decompiled with CFR 0.152.
 */
package com.ali.notificationsvc.services;

import com.ali.notificationsvc.dtos.CreateNotificationDto;
import com.ali.notificationsvc.dtos.NotificationDto;
import com.ali.notificationsvc.models.Notification;
import com.ali.notificationsvc.repositories.INotificationRepository;
import com.ali.notificationsvc.services.INotificationService;
import com.ali.notificationsvc.status.RequestStatus;
import java.util.ArrayList;
import java.util.List;
import org.modelmapper.Conditions;
import org.modelmapper.ModelMapper;
import org.modelmapper.config.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationService
implements INotificationService {
    @Autowired
    INotificationRepository iNotificationRepository;
    private ModelMapper modelMapper = new ModelMapper();

    NotificationService(INotificationRepository iNotificationRepository) {
        this.iNotificationRepository = iNotificationRepository;
    }

    public NotificationDto getById(int notificationId) {
        NotificationDto notificationDto = new NotificationDto();
        notificationDto = (NotificationDto)this.modelMapper.map(this.iNotificationRepository.getById((Object)notificationId), NotificationDto.class);
        return notificationDto;
    }

    public List<NotificationDto> getAll() {
        List notifications = this.iNotificationRepository.findAll();
        ArrayList<NotificationDto> notificationDtos = new ArrayList<NotificationDto>();
        for (Notification notification : notifications) {
            NotificationDto notificationDto = (NotificationDto)this.modelMapper.map((Object)notification, NotificationDto.class);
            notificationDtos.add(notificationDto);
        }
        return notificationDtos;
    }

    public List<NotificationDto> getNotificationByJobseekerId(int jobseekerId) {
        List notifications = this.iNotificationRepository.findNotificationsByJobseekerId(jobseekerId);
        ArrayList<NotificationDto> notificationDtos = new ArrayList<NotificationDto>();
        for (Notification notification : notifications) {
            notification.setRead(true);
            NotificationDto notificationDto = (NotificationDto)this.modelMapper.map((Object)notification, NotificationDto.class);
            notificationDtos.add(notificationDto);
        }
        this.iNotificationRepository.saveAll((Iterable)notifications);
        return notificationDtos;
    }

    public List<NotificationDto> getNotificationByCompanyId(int companyId) {
        List notifications = this.iNotificationRepository.findNotificationsByCompanyId(companyId);
        ArrayList<NotificationDto> notificationDtos = new ArrayList<NotificationDto>();
        for (Notification notification : notifications) {
            notification.setRead(true);
            NotificationDto notificationDto = (NotificationDto)this.modelMapper.map((Object)notification, NotificationDto.class);
            notificationDtos.add(notificationDto);
        }
        this.iNotificationRepository.saveAll((Iterable)notifications);
        return notificationDtos;
    }

    public RequestStatus create(CreateNotificationDto cNotificationDto) {
        RequestStatus status = new RequestStatus();
        this.ignoreIdMapping(this.modelMapper);
        try {
            System.out.println(cNotificationDto.toString());
            Notification notification = (Notification)this.modelMapper.map((Object)cNotificationDto, Notification.class);
            System.out.println(notification.toString());
            this.iNotificationRepository.save((Object)notification);
            status.setStatus(true);
            status.setDescribtion("created successfully");
            return status;
        }
        catch (Exception e) {
            status.setStatus(false);
            status.setDescribtion(e.getMessage().toString());
            return status;
        }
    }

    public RequestStatus update(NotificationDto notificationDto) {
        RequestStatus status = new RequestStatus();
        try {
            Notification notification = new Notification();
            notification = (Notification)this.modelMapper.map((Object)notificationDto, Notification.class);
            this.iNotificationRepository.save((Object)notification);
            status.setStatus(true);
            status.setDescribtion("updated successfully");
            return status;
        }
        catch (Exception e) {
            status.setStatus(false);
            status.setDescribtion("failed to update");
            return status;
        }
    }

    public RequestStatus delete(int notificationId) {
        RequestStatus status = new RequestStatus();
        if (this.iNotificationRepository.existsById((Object)notificationId)) {
            this.iNotificationRepository.deleteById((Object)notificationId);
            status.setStatus(true);
            status.setDescribtion("deleted successfully");
            return status;
        }
        status.setStatus(false);
        status.setDescribtion("failed to delete, cv does not exist");
        return status;
    }

    public boolean existById(int notificationId) {
        return this.iNotificationRepository.existsById((Object)notificationId);
    }

    public int getUnReadNotificationsNumberByJobseekerId(int jobseekerId) {
        return this.iNotificationRepository.findUnreadNotificationsByJobseekerId(jobseekerId).size();
    }

    public int getUnReadNotificationsNumberByCompanyId(int companyId) {
        return this.iNotificationRepository.findUnreadNotificationsByCompanyId(companyId).size();
    }

    private void ignoreIdMapping(ModelMapper modelMapper) {
        modelMapper.getConfiguration().setPropertyCondition(Conditions.isNotNull()).setFieldMatchingEnabled(true).setFieldAccessLevel(Configuration.AccessLevel.PRIVATE).setSkipNullEnabled(true).setAmbiguityIgnored(true);
        modelMapper.typeMap(CreateNotificationDto.class, Notification.class).addMappings(mapper -> mapper.skip(Notification::setId));
    }
}

