/*
 * Decompiled with CFR 0.152.
 */
package com.ali.notificationsvc.kafkalisteners;

import com.ali.notificationsvc.dtos.CreateNotificationDto;
import com.ali.notificationsvc.services.INotificationService;
import com.ali.notificationsvc.status.RequestStatus;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
public class NotificationKafkaListener {
    @Autowired
    private INotificationService notificationService;

    public NotificationKafkaListener(INotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @KafkaListener(topics={"${spring.kafka.topic.name}"}, groupId="${spring.kafka.consumer.group-id}", containerFactory="notificationFactory")
    void listener(ConsumerRecord<Long, CreateNotificationDto> data) {
        CreateNotificationDto createNotificationDto = (CreateNotificationDto)data.value();
        System.out.println("Key: " + data.key());
        System.out.println("Received: " + createNotificationDto.toString());
        RequestStatus requestStatus = this.notificationService.create(createNotificationDto);
        System.out.println(requestStatus.isStatus());
        System.out.println(requestStatus.getDescribtion());
    }
}

