/*
 * Decompiled with CFR 0.152.
 */
package com.ali.notificationsvc.controllers;

import com.ali.notificationsvc.dtos.CreateNotificationDto;
import com.ali.notificationsvc.dtos.NotificationDto;
import com.ali.notificationsvc.services.INotificationService;
import com.ali.notificationsvc.status.RequestStatus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notifications"})
public class NotificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationController.class);
    @Autowired
    INotificationService notificationService;

    public NotificationController(INotificationService iNotificationService) {
        this.notificationService = iNotificationService;
    }

    @GetMapping(value={"getById/{id}"})
    public ResponseEntity<NotificationDto> getById(@PathVariable(value="id") int id) {
        LOGGER.info(String.format("get notification details by %s id", id));
        NotificationDto notificationDto = new NotificationDto();
        notificationDto = this.notificationService.getById(id);
        return ResponseEntity.ok((Object)notificationDto);
    }

    @GetMapping(value={"getAll"})
    public ResponseEntity<List<NotificationDto>> getAllNotifications() {
        LOGGER.info(String.format("get all notification", new Object[0]));
        List notificationDtos = this.notificationService.getAll();
        return ResponseEntity.ok((Object)notificationDtos);
    }

    @GetMapping(value={"getAllByCompanyId/{id}"})
    public ResponseEntity<List<NotificationDto>> getAllByCompanyId(@PathVariable(value="id") int companyId) {
        LOGGER.info(String.format("get all notification by company id: %s", companyId));
        List notificationDtos = this.notificationService.getNotificationByCompanyId(companyId);
        return ResponseEntity.ok((Object)notificationDtos);
    }

    @GetMapping(value={"getAllByJobseekerId/{id}"})
    public ResponseEntity<List<NotificationDto>> getAllByJobseekerId(@PathVariable(value="id") int jobseekerId) {
        LOGGER.info(String.format("get all notification by jobseeker id: %s", jobseekerId));
        List notificationDtos = this.notificationService.getNotificationByJobseekerId(jobseekerId);
        return ResponseEntity.ok((Object)notificationDtos);
    }

    @GetMapping(value={"isExist/{id}"})
    public ResponseEntity<Boolean> isExist(@PathVariable(value="id") int notificationId) {
        LOGGER.info(String.format("check if notification is exist where id: %s", notificationId));
        boolean isExist = this.notificationService.existById(notificationId);
        return ResponseEntity.ok((Object)isExist);
    }

    @GetMapping(value={"getUnReadNotificationNumForJobseeker/{id}"})
    public ResponseEntity<Integer> getUnReadNotificationNumForJobseeker(@PathVariable(value="id") int jobseekerId) {
        LOGGER.info(String.format("get all un read notifications for jobseeker id: %s", jobseekerId));
        int num = this.notificationService.getUnReadNotificationsNumberByJobseekerId(jobseekerId);
        return ResponseEntity.ok((Object)num);
    }

    @GetMapping(value={"getUnReadNotificationNumForCompany/{id}"})
    public ResponseEntity<Integer> getUnReadNotificationNumForCompany(@PathVariable(value="id") int companyId) {
        LOGGER.info(String.format("get all un read notifications for company id: %s", companyId));
        int num = this.notificationService.getUnReadNotificationsNumberByCompanyId(companyId);
        return ResponseEntity.ok((Object)num);
    }

    @PostMapping(value={"create"})
    public ResponseEntity<RequestStatus> createNotification(@RequestBody CreateNotificationDto createNotificationDto) {
        LOGGER.info(String.format("create new notification in synchronized way", new Object[0]));
        RequestStatus status = this.notificationService.create(createNotificationDto);
        if (status.isStatus()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)status);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)status);
    }

    @PutMapping(value={"update"})
    public ResponseEntity<RequestStatus> updateNotification(@RequestBody NotificationDto notificationDto) {
        LOGGER.info(String.format("update notification where id is: %s", notificationDto.getId()));
        RequestStatus status = this.notificationService.update(notificationDto);
        if (status.isStatus()) {
            return ResponseEntity.ok((Object)status);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)status);
    }

    @DeleteMapping(value={"delete/{id}"})
    public ResponseEntity<RequestStatus> deleteNotification(@PathVariable(value="id") int id) {
        LOGGER.info(String.format("delete notification where id is: %s", id));
        RequestStatus status = this.notificationService.delete(id);
        if (status.isStatus()) {
            return ResponseEntity.ok((Object)status);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)status);
    }
}

