/*
 * Decompiled with CFR 0.152.
 */
package com.ali.notificationsvc.config;

import com.ali.notificationsvc.deserialization.NotificationDeserializer;
import com.ali.notificationsvc.dtos.CreateNotificationDto;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

@Configuration
public class NotificationKafkaConsumer {
    @Value(value="${spring.kafka.bootstrap-servers}")
    private String bootstrapServers;
    @Value(value="${spring.kafka.properties.security.protocol}")
    private String securityProtocol;
    @Value(value="${spring.kafka.properties.sasl.mechanism}")
    private String saslMechanism;
    @Value(value="${spring.kafka.properties.sasl.jaas.config}")
    private String saslJaasConfig;

    @Bean
    public Map<String, Object> notificationConsumerConfig() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("key.deserializer", LongDeserializer.class);
        props.put("value.deserializer", NotificationDeserializer.class);
        props.put("security.protocol", this.securityProtocol);
        props.put("sasl.mechanism", this.saslMechanism);
        props.put("sasl.jaas.config", this.saslJaasConfig);
        return props;
    }

    @Bean
    public ConsumerFactory<Long, CreateNotificationDto> notificationConsumerFactory() {
        return new DefaultKafkaConsumerFactory(this.notificationConsumerConfig());
    }

    @Bean
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Long, CreateNotificationDto>> notificationFactory(ConsumerFactory<Long, CreateNotificationDto> notificationConsumerFactory) {
        ConcurrentKafkaListenerContainerFactory notificationFactory = new ConcurrentKafkaListenerContainerFactory();
        notificationFactory.setConsumerFactory(notificationConsumerFactory);
        notificationFactory.getContainerProperties().setAckMode(ContainerProperties.AckMode.MANUAL);
        notificationFactory.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler((BackOff)new FixedBackOff(1000L, 5L)));
        return notificationFactory;
    }
}

