package com.ali.notificationsvc.services;

import com.ali.notificationsvc.dtos.CreateNotificationDto;
import com.ali.notificationsvc.dtos.NotificationDto;
import com.ali.notificationsvc.models.Notification;
import com.ali.notificationsvc.repositories.INotificationRepository;
import com.ali.notificationsvc.status.RequestStatus;
import org.modelmapper.Conditions;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.List;

@Service
public class NotificationService implements INotificationService {
    @Autowired
    INotificationRepository iNotificationRepository;

    private ModelMapper modelMapper = new ModelMapper();


    NotificationService(INotificationRepository iNotificationRepository){
        this.iNotificationRepository = iNotificationRepository;
    }
    @Override
    public NotificationDto getById(int notificationId) {
        NotificationDto notificationDto = new NotificationDto();
        notificationDto = modelMapper.map(iNotificationRepository.getById(notificationId), NotificationDto.class);
        return notificationDto;
    }

    @Override
    public List<NotificationDto> getAll() {
        List<Notification> notifications = iNotificationRepository.findAll();
        List<NotificationDto> notificationDtos = new ArrayList<>();
        for(Notification notification : notifications){
            NotificationDto notificationDto = modelMapper.map(notification, NotificationDto.class);
            notificationDtos.add(notificationDto);
        }
        return notificationDtos;
    }

    @Override
    public List<NotificationDto> getNotificationByJobseekerId(int jobseekerId) {
        List<Notification> notifications = iNotificationRepository.findNotificationsByJobseekerId(jobseekerId);
        List<NotificationDto> notificationDtos = new ArrayList<>();
        for(Notification notification : notifications){
            NotificationDto notificationDto = modelMapper.map(notification, NotificationDto.class);
            notificationDtos.add(notificationDto);
        }
        return notificationDtos;
    }

    @Override
    public List<NotificationDto> getNotificationByCompanyId(int companyId) {
        List<Notification> notifications = iNotificationRepository.findNotificationsByCompanyId(companyId);
        List<NotificationDto> notificationDtos = new ArrayList<>();
        for(Notification notification : notifications){
            NotificationDto notificationDto = modelMapper.map(notification, NotificationDto.class);
            notificationDtos.add(notificationDto);
        }
        return notificationDtos;
    }

    @Override
    public RequestStatus create(CreateNotificationDto cNotificationDto) {
        RequestStatus status = new RequestStatus();
        ignoreIdMapping(modelMapper);
        try {
            System.out.println(cNotificationDto.toString());
            Notification notification = modelMapper.map(cNotificationDto, Notification.class);
            System.out.println(notification.toString());
            iNotificationRepository.save(notification);
            status.setStatus(true);
            status.setDescribtion("created successfully");
            return status;
        }catch (Exception e){
            status.setStatus(false);
            status.setDescribtion(e.getMessage().toString());
            return status;
        }
    }

    @Override
    public RequestStatus update(NotificationDto notificationDto) {
        RequestStatus status = new RequestStatus();
        try {

            Notification notification = new Notification();
            notification = modelMapper.map(notificationDto,Notification.class);
            iNotificationRepository.save(notification);
            status.setStatus(true);
            status.setDescribtion("updated successfully");
            return status;
        }catch (Exception e){
            status.setStatus(false);
            status.setDescribtion("failed to update");
            return status;
        }
    }

    @Override
    public RequestStatus delete(int notificationId) {
        RequestStatus status = new RequestStatus();
        if(iNotificationRepository.existsById(notificationId)){
            iNotificationRepository.deleteById(notificationId);
            status.setStatus(true);
            status.setDescribtion("deleted successfully");
            return status;
        }else {
            status.setStatus(false);
            status.setDescribtion("failed to delete, cv does not exist");
            return status;
        }
    }

    @Override
    public boolean existById(int notificationId) {
        return iNotificationRepository.existsById(notificationId);
    }
    private void ignoreIdMapping(ModelMapper modelMapper){
        modelMapper.getConfiguration()
                .setPropertyCondition(Conditions.isNotNull())
                .setFieldMatchingEnabled(true)
                .setFieldAccessLevel(org.modelmapper.config.Configuration.AccessLevel.PRIVATE)
                .setSkipNullEnabled(true)
                .setAmbiguityIgnored(true);
        modelMapper.typeMap(CreateNotificationDto.class, Notification.class)
                .addMappings(mapper -> {
                    mapper.skip(Notification::setId);
                });
    }
}
