package com.ali.notificationsvc.repositories;

import com.ali.notificationsvc.models.Notification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface INotificationRepository extends JpaRepository<Notification, Integer> {
    @Query("SELECT i FROM Notification i WHERE i.companyId = :companyId")
    List<Notification> findNotificationsByCompanyId(@Param("companyId") int companyId);
    @Query("SELECT i FROM Notification i WHERE i.jobseekerId = :jobseekerId")
    List<Notification> findNotificationsByJobseekerId(@Param("jobseekerId") int jobseekerId);

}
