package com.ali.notificationsvc.controllers;

import com.ali.notificationsvc.dtos.CreateNotificationDto;
import com.ali.notificationsvc.dtos.NotificationDto;
import com.ali.notificationsvc.services.INotificationService;
import com.ali.notificationsvc.status.RequestStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/notifications")
public class NotificationController {

    @Autowired
    INotificationService notificationService;

    public NotificationController(INotificationService iNotificationService) {
        this.notificationService = iNotificationService;
    }
    @GetMapping("getById/{id}")
    public ResponseEntity<NotificationDto> getById(@PathVariable("id") int id) {
        NotificationDto notificationDto = new NotificationDto();
        notificationDto = notificationService.getById(id);
        return ResponseEntity.ok(notificationDto);
    }
    @GetMapping("getAll")
    public ResponseEntity<List<NotificationDto>> getAllNotifications() {
        List<NotificationDto> notificationDtos = notificationService.getAll();
        return ResponseEntity.ok(notificationDtos);
    }
    @GetMapping("getAllByCompanyId/{id}")
    public ResponseEntity<List<NotificationDto>> getAllByCompanyId(@PathVariable("id") int companyId) {
        List<NotificationDto> notificationDtos = notificationService.getNotificationByCompanyId(companyId);
        return ResponseEntity.ok(notificationDtos);
    }
    @GetMapping("getAllByJobseekerId/{id}")
    public ResponseEntity<List<NotificationDto>> getAllByJobseekerId(@PathVariable("id") int jobseekerId) {
        List<NotificationDto> notificationDtos = notificationService.getNotificationByJobseekerId(jobseekerId);
        return ResponseEntity.ok(notificationDtos);
    }
    @GetMapping("isExist/{id}")
    public ResponseEntity<Boolean> isExist(@PathVariable("id") int notificationId) {
        boolean isExist = notificationService.existById(notificationId);
        return ResponseEntity.ok(isExist);
    }

    @PostMapping("create")
    public ResponseEntity<RequestStatus> createNotification(@RequestBody CreateNotificationDto createNotificationDto) {
        RequestStatus status = notificationService.create(createNotificationDto);
        if (status.isStatus()) {
            return ResponseEntity.status(HttpStatus.CREATED).body(status);
        } else {
            return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(status);
        }
    }
    @PutMapping("update")
    public ResponseEntity<RequestStatus> updateNotification(@RequestBody NotificationDto notificationDto) {
        RequestStatus status = notificationService.update(notificationDto);
        if (status.isStatus()) {
            return ResponseEntity.ok(status);
        } else {
            return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(status);
        }
    }
    @DeleteMapping("delete/{id}")
    public ResponseEntity<RequestStatus> deleteNotification(@PathVariable("id") int id) {
        RequestStatus status = notificationService.delete(id);
        if (status.isStatus()) {
            return ResponseEntity.ok(status);
        } else {
            return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(status);
        }
    }
}
