package com.ali.notificationsvc.deserialization;

import com.ali.notificationsvc.dtos.CreateNotificationDto;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.common.serialization.Deserializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;

public class NotificationDeserializer implements Deserializer<CreateNotificationDto> {
    private ObjectMapper objectMapper;
    public NotificationDeserializer() {
        this.objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
    }

    @Override
    public CreateNotificationDto deserialize(String s, byte[] bytes) {
        try {
            return objectMapper.readValue(bytes, CreateNotificationDto.class);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}


