import java.util.ArrayList;
import java.util.List;

public class PrimeNumberService implements Runnable {
    private  int start;
    private  int end;
    private List <Integer> primeNumbers;

    public PrimeNumberService() {
    }

    public PrimeNumberService(int start, int end) {

        this.start = start;
        this.end = end;
        primeNumbers = new ArrayList<Integer>();
    }

    public int getStart() {
        return start;
    }

    public int getEnd() {
        return end;
    }

    public List<Integer> getPrimeNumbers() {
        return primeNumbers;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public boolean isPrime (int num){
        if (num <= 1) {
            return false;
        }

        for (int i = 2; i <= Math.sqrt(num); i++) {
            if (num % i == 0) {
                return false;
            }
        }

        return true;
    }
    public List<Integer> FindPrimeNumbersInRange(){
        List <Integer> range_primeNumbers= new ArrayList<>();
        for (int num = start; num <= end; num++) {
            if (isPrime(num)) {
                range_primeNumbers.add(num);
            }
        }
        return range_primeNumbers;
    }

    @Override
    public void run() {
        primeNumbers.addAll(FindPrimeNumbersInRange());
    }
}
