import java.util.ArrayList;
import java.util.List;
//Abdullah Alsoleman
public class Main {
    public static void main(String[] args) throws InterruptedException {
        int startRange = 1;
        int endRange = 100_000_000;

        int numThreads = 4;

        int chunkSize = (endRange - startRange + 1) / numThreads;

        List<Thread> threads = new ArrayList<>();
        List<PrimeNumberService> allChunks_PrimeNumbers = new ArrayList<PrimeNumberService>();

        for (int i = 0; i < numThreads; i++) {
            int start = startRange + i * chunkSize;
            int end = start + chunkSize - 1;
            if (i == numThreads - 1) {
                end = endRange;
            }

            PrimeNumberService chunk_primeNumber = new PrimeNumberService(start, end);
            Thread thread = new Thread(chunk_primeNumber);
            threads.add(thread);
            allChunks_PrimeNumbers.add(chunk_primeNumber);
            thread.start();
        }

        long startTime = System.currentTimeMillis();

        for (Thread thread : threads) {
            thread.join();
        }

        long endTime = System.currentTimeMillis();

        List<Integer> allPrimeNumbers = new ArrayList<>();

        for (PrimeNumberService primeNumbers : allChunks_PrimeNumbers) {
            allPrimeNumbers.addAll(primeNumbers.getPrimeNumbers());
        }

        System.out.println("Total prime numbers found: " + allPrimeNumbers.size());
        System.out.println("Execution time: " + (endTime - startTime) + " milliseconds");
    }


}
