import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;

public class ChatServiceImpl extends UnicastRemoteObject implements ChatService {
    static final private List<User> users = new ArrayList<>();
    static final private List<Room> rooms = new ArrayList<>();


    public ChatServiceImpl() throws RemoteException {
        super();
    }

    @Override
    public String addRoom(String roomName, String ownerName) throws RemoteException {
        User owner =new User();
        for (User user:users
             ) {
            if(user.getUerName().equals(ownerName)){
                owner=user;
                break;
            }else {
                return "User name of owner is not exist";
            }

        }
        Room room =new Room(roomName,owner);
        rooms.add(room);
        owner.getRooms().add(room);
        return roomName + " is created by "+ ownerName;
    }

    @Override
    public void removeRoom(String roomName) throws RemoteException {
        for (Room room:rooms
             ) {
            if(room.getName().equals(roomName)){
                rooms.remove(room);
                break;
            }

        }

    }

    @Override
    public String signUp(String username, String password, String firstName, String lastName) throws RemoteException {
        System.out.println("A new client has Registered ");
        User user = new User(username, password, firstName, lastName);
        users.add(user);
        String message = "Your account has been registered in the system";
        return message;

    }

    @Override
    public String signInSystem(String username, String password) throws RemoteException {
        String message = "";
        for (User user : users) {
            if (user.getUerName().equals(username)) {
                if (user.getPassword().equals(password)) {
                    message = "You are logged in";
                } else {
                    message = "password is wrong";
                }
                return message;
            }
        }
        message = "User name not found. you must register in System then log in it";
        return message;

    }

    @Override
    public String signIn(String username, String password, String room) throws RemoteException {
        return "";
    }

    @Override
    public String signOut() throws RemoteException {
        return "";

    }


}