import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;

public class ChatServiceImpl extends UnicastRemoteObject implements IServerChat {
    static final private List<IClientChat> registerClients = new ArrayList<>();
    static final private List<IClientChat> loginClients = new ArrayList<>();

    static final private List<Room> rooms = new ArrayList<>();


    public ChatServiceImpl() throws RemoteException {
        super();
    }

    @Override
    public boolean addRoom(String roomName) throws RemoteException {

        Room room = new Room(roomName);
        rooms.add(room);
        return true;
    }

    @Override
    public boolean removeRoom(String roomName) throws RemoteException {

        for (Room room : rooms
        ) {
            if (room.getName().equals(roomName)) {
                rooms.remove(room);
                return true;
            }

        }

        return false;

    }

    @Override
    public boolean signUp(IClientChat clientChat) throws RemoteException {
        registerClients.add(clientChat);
        return true;

    }

    @Override
    public boolean signInSystem(String username, char[] password) throws RemoteException {
        for ( int i =0 ; i<registerClients.size(); i++) {
            String s =registerClients.get(i).getName();
            boolean b =registerClients.get(i).getName().equals(username);
            if (b) {
                char[] ss = registerClients.get(i).getPassword();
                boolean bb = true;
                for(int j =0 ; j<password.length;j++){
                    if(password[j]!=ss[j]){
                        bb=false;
                        break;
                    }
                }
                if (bb) {
                    for (IClientChat c: loginClients
                         ) {
                        if(c.getName()==registerClients.get(i).getName()){
                            loginClients.remove(registerClients.get(i));
                            loginClients.add(registerClients.get(i));
                        }
                    }
                    loginClients.add(registerClients.get(i));
                    return true;
                }
            }
        }
        return false;
    }


    @Override
    public boolean signIn(IClientChat client, String room) throws RemoteException {
        for (Room r : rooms) {
            if (r.getName().equals(room)) {
                r.getClients().add(client);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean signOut(IClientChat client, String room) throws RemoteException {
        for (Room r : rooms) {
            if (r.getName().equals(room)) {
                r.getClients().remove(client);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> showAllRoom() throws RemoteException {
        List<String> room =new ArrayList<>();
        for (Room r:rooms
             ) {
            room.add(r.getName());
        }
        return room;
    }

    @Override
    public List<String> showMyRoom(IClientChat clientChat) throws RemoteException {
        List<String> room = new ArrayList<>();
        for (Room r:rooms
             ) {
            for (IClientChat c: r.getClients()
                 ) {
                if(c.getName().equals(clientChat.getName()))
                    room.add(c.getName());
            }

        }
        return room;
    }

    @Override
    public void sendRoom(String user, String room, String message) throws RemoteException {
        for (Room r: rooms
             ) {
            if (r.getName().equals(room)) {
                for (int i=0; i< r.getClients().size(); i++){
                    r.getClients().get(i).receiveMsg(message,user);
                }
            }
        }
    }

    @Override
    public void sendChatRoom(IClientChat clientChat) {
        for(int i=0; i<loginClients.size();i++){
            try {
                boolean b=clientChat.getName().equals(loginClients.get(i).getName());
                if(b){
                    clientChat.setFirstName(loginClients.get(i).getFirstName());
                    loginClients.remove(loginClients.get(i));
                    loginClients.add(clientChat);
                    break;
                }
            } catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

    }

    @Override
    public IClientChat getClient(String user) {
        for (IClientChat c : registerClients) {
            try {
                if(user.equals(c.getName())){
                    return c;
                }
            } catch (RemoteException e) {
                throw new RuntimeException(e);
            }

        }
        return null;
    }
}


