import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import java.awt.*;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ShowRooms extends JFrame{
    private JPanel rooms;
    private JList roomList;
    private JScrollPane scroll;


    public ShowRooms(IServerChat serverChat, IClientChat clientChat) {
        setContentPane(rooms);
        setSize(800,700);
        setTitle("My room");
        try {
            String [] s= new String[1000];
            List<String> st= new ArrayList<>();
            st.addAll(serverChat.showAllRoom());
            for(int i=0; i< st.size(); i++){
                s[i]=st.get(i);
            }

            roomList=new JList<>(s);
            roomList.addListSelectionListener(new ListSelectionListener() {
                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        // Get the selected item from the list
                        String selectedRoom = (String) roomList.getSelectedValue();
                        // Perform your action here
                        performAction(selectedRoom,serverChat,clientChat);
                    }
                }
            });

            scroll = new JScrollPane(roomList);

            // Set up the main layout
            setLayout(new BorderLayout());
            add(scroll, BorderLayout.CENTER);
            // Display the window
            pack();
            setLocationRelativeTo(null);
        } catch (RemoteException e) {
            throw new RuntimeException(e);
        }

        setVisible(true);
    }
    private void performAction(String selectedRoom, IServerChat serverChat,IClientChat clientChat) {
        dispose();
        Services_Room s = new Services_Room(serverChat,clientChat,selectedRoom);
    }

}
