import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import java.awt.*;
import java.rmi.RemoteException;

public class ShowMyRoom extends JFrame implements ListSelectionListener {
    private JPanel rooms;
    private JList roomList;
    private JScrollPane scroll;

    public ShowMyRoom(IServerChat serverChat, IClientChat clientChat) {
        setContentPane(rooms);
        setSize(800,700);
        setTitle("All rooms");
        try {
            roomList=new JList<>((ListModel) serverChat.showMyRoom(clientChat));

            roomList.addListSelectionListener(this);
            scroll = new JScrollPane(roomList);

            // Set up the main layout
            setLayout(new BorderLayout());
            add(scroll, BorderLayout.CENTER);

            // Display the window
            pack();
            setLocationRelativeTo(null);
        } catch (RemoteException e) {
            throw new RuntimeException(e);
        }

        setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {

    }
}
