import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;

public class Services_Room extends JFrame {
    private JPanel services_room;
    private JButton joinButton;
    private JButton cancelButton;



    public Services_Room(IServerChat serverChat,IClientChat clientChat,String room) {
        setContentPane(services_room);
        setSize(800,700);
        setTitle("Join");
        joinButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if(serverChat.signIn(clientChat,room))
                        JOptionPane.showMessageDialog(services_room, "Mission Complete", "Message", JOptionPane.INFORMATION_MESSAGE);
                        dispose();
                        Chat_room chat_room = new Chat_room(serverChat,clientChat.getName(),room);
                        ClientChatImp clientChatImp = new ClientChatImp(clientChat.getName(),clientChat.getPassword(),clientChat.getFirstName()
                            ,clientChat.getLastName(), chat_room);

                        serverChat.sendChatRoom(clientChatImp);
                } catch (RemoteException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        cancelButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                Services s = new Services(serverChat,clientChat);
            }
        });
        setVisible(true);
    }

}
