import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;

public interface IServerChat extends Remote {

    boolean addRoom(String roomName) throws RemoteException;

    boolean removeRoom(String roomName) throws RemoteException;

    boolean signUp(IClientChat clientChat) throws RemoteException;

    boolean signIn(IClientChat client, String room) throws RemoteException;

    boolean signInSystem(String username, char[] password) throws RemoteException;

    boolean signOut(IClientChat client, String room) throws RemoteException;
    List<String>  showAllRoom() throws RemoteException;
    List<String>  showMyRoom(IClientChat clientChat) throws RemoteException;
    void sendRoom(String user,String room, String message ) throws RemoteException;
    void sendChatRoom(IClientChat clientChat) throws RemoteException;
    IClientChat getClient(String user) throws RemoteException;

}