import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.rmi.RemoteException;

public class RegisterForm extends JFrame  {
    private JPanel SsignUp;
    private JTextField firstName;
    private JTextField lastName;
    private JButton signUpButton;
    private JTextField name;
    private JPasswordField passwordField1;
    private JButton cancelButton;

    public RegisterForm(IServerChat serverChat) {

        setContentPane(SsignUp);
        setSize(800,700);
        setTitle("Register");
        setVisible(true);



        signUpButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                 IClientChat clientChat = new ClientChatImp(name.getText(),passwordField1.getPassword(),firstName.getText(),lastName.getText());
                   if (serverChat.signUp(clientChat));
                    JOptionPane.showMessageDialog(SsignUp, "Mission Complete", "Message", JOptionPane.INFORMATION_MESSAGE);

                    dispose();
                    LoginForm login =new LoginForm(serverChat);
                } catch (RemoteException ex) {
                    throw new RuntimeException(ex);
                }


            }
        });
        cancelButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                LoginForm login =new LoginForm(serverChat);
            }
        });

    }

}
