import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class ClientChatImp extends UnicastRemoteObject implements IClientChat, Serializable {

   private String name;
   private char[] password;
   private String firstName;
   private String lastName;

   private Chat chat;
    public void setChat(ClientChatImp clientChatImp) {
        this.chat = clientChatImp.chat;
    }


    protected ClientChatImp(String name, char[] password, String firstName, String lastName, Chat chat) throws RemoteException {
        this.name=name;
        this.password=password;
        this.firstName=firstName;
        this.lastName=lastName;
        this.chat=chat;
    }
    protected ClientChatImp(String name, char[] password, String firstName, String lastName) throws RemoteException {
        this.name=name;
        this.password=password;
        this.firstName=firstName;
        this.lastName=lastName;
        this.chat=null;
    }

    public ClientChatImp(String name, char[] password) throws RemoteException {
        this.name = name;
        this.password = password;
    }

    @Override
    public String receiveMsg(String msg, String userName) throws RemoteException {
        try {
            this.chat.setTextArea(userName+": "+msg);
        }catch (Exception e){
        }
        return null;
    }

    @Override
    public String getName() throws RemoteException {
        return name;
    }

    public ClientChatImp() throws RemoteException {
    }

    @Override
    public char[] getPassword() throws RemoteException {
        return password;
    }

    @Override
    public String getFirstName() throws RemoteException {
        return firstName;
    }

    @Override
    public String getLastName() throws RemoteException {
        return lastName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName=firstName;
    }


}
