import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;

public class Chat_room extends Chat{
    private JPanel chatRoom;
    private JTextArea allMessages;
    private JTextField message;
    private JButton send;
    private JButton Cancel;

    public Chat_room(IServerChat serverChat,String user,String room) {
        setContentPane(chatRoom);
        setSize(800, 700);
        setTitle("Login");
        allMessages.setEditable(false);
        send.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    serverChat.sendRoom(user,room,message.getText());
                } catch (RemoteException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        Cancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dispose();
                IClientChat clientChat= null;
                try {
                    clientChat = serverChat.getClient(user);
                } catch (RemoteException ex) {
                    throw new RuntimeException(ex);
                }
                Services_Room services_room = new Services_Room(serverChat,clientChat,room);
            }
        });
        setVisible(true);

    }

    @Override
    public void setTextArea(String msg) {
        allMessages.append("\n"+msg);
    }
}
