// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'message.dart';

/// A request for a string representation of the render tree.
class GetRenderTree implements Command {
  @override
  final String kind = 'get_render_tree';

  /// Deserializes the command from JSON generated by [serialize].
  static GetRenderTree deserialize(Map<String, String> json) => new GetRenderTree();

  @override
  Map<String, String> serialize() => const <String, String>{};
}

/// A string representation of the render tree.
class RenderTree extends Result {
  /// Creates a [RenderTree] object with the given string representation.
  RenderTree(this.tree);

  /// Deserializes the result from JSON.
  static RenderTree fromJson(Map<String, dynamic> json) {
    return new RenderTree(json['tree']);
  }

  /// String representation of the render tree.
  final String tree;

  @override
  Map<String, dynamic> toJson() => <String, dynamic>{
    'tree': tree
  };
}

