// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated. Please do not edit it manually.
// To regenerate the file, use:
// dart dev/tools/gen_localizations.dart --overwrite

import 'dart:collection';

import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart' as intl;

import '../material_localizations.dart';

// The classes defined here encode all of the translations found in the
// `flutter_localizations/lib/src/l10n/*.arb` files.
//
// These classes are constructed by the [getTranslation] method at the bottom of
// this file, and used by the [_MaterialLocalizationsDelegate.load] method defined
// in `flutter_localizations/lib/src/material_localizations.dart`.

/// The translations for Arabic (`ar`).
class MaterialLocalizationAr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Arabic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAr({
    String localeName = 'ar',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'حول "$applicationName"';

  @override
  String get alertDialogLabel => r'مربع حوار التنبيه';

  @override
  String get anteMeridiemAbbreviation => r'ص';

  @override
  String get backButtonTooltip => r'رجوع';

  @override
  String get cancelButtonLabel => r'إلغاء';

  @override
  String get closeButtonLabel => r'إغلاق';

  @override
  String get closeButtonTooltip => r'إغلاق';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'متابعة';

  @override
  String get copyButtonLabel => r'نسخ';

  @override
  String get cutButtonLabel => r'قص';

  @override
  String get deleteButtonTooltip => r'حذف';

  @override
  String get dialogLabel => r'مربع حوار';

  @override
  String get drawerLabel => r'قائمة تنقل';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'إخفاء الحسابات';

  @override
  String get licensesPageTitle => r'التراخيص';

  @override
  String get modalBarrierDismissLabel => r'رفض';

  @override
  String get nextMonthTooltip => r'الشهر التالي';

  @override
  String get nextPageTooltip => r'الصفحة التالية';

  @override
  String get okButtonLabel => r'حسنًا';

  @override
  String get openAppDrawerTooltip => r'فتح قائمة التنقل';

  @override
  String get pageRowsInfoTitleRaw => r'من $firstRow إلى $lastRow من إجمالي $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'من $firstRow إلى $lastRow من إجمالي $rowCount تقريبًا';

  @override
  String get pasteButtonLabel => r'لصق';

  @override
  String get popupMenuLabel => r'قائمة منبثقة';

  @override
  String get postMeridiemAbbreviation => r'م';

  @override
  String get previousMonthTooltip => r'الشهر السابق';

  @override
  String get previousPageTooltip => r'الصفحة السابقة';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'عدد الصفوف في الصفحة:';

  @override
  String get scriptCategory => r'tall';

  @override
  String get searchFieldLabel => r'بحث';

  @override
  String get selectAllButtonLabel => r'اختيار الكل';

  @override
  String get selectedRowCountTitleFew => r'تم اختيار $selectedRowCount عنصر';

  @override
  String get selectedRowCountTitleMany => r'تم اختيار $selectedRowCount عنصرًا';

  @override
  String get selectedRowCountTitleOne => r'تم اختيار عنصر واحد';

  @override
  String get selectedRowCountTitleOther => r'تم اختيار $selectedRowCount عنصر';

  @override
  String get selectedRowCountTitleTwo => r'تم اختيار عنصرين ($selectedRowCount)';

  @override
  String get selectedRowCountTitleZero => r'لم يتم اختيار أي عنصر';

  @override
  String get showAccountsLabel => r'إظهار الحسابات';

  @override
  String get showMenuTooltip => r'عرض القائمة';

  @override
  String get signedInLabel => r'تم تسجيل الدخول';

  @override
  String get tabLabelRaw => r'علامة التبويب $tabIndex من $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'اختيار الساعات';

  @override
  String get timePickerMinuteModeAnnouncement => r'اختيار الدقائق';

  @override
  String get viewLicensesButtonLabel => r'الاطّلاع على التراخيص';
}

/// The translations for Bulgarian (`bg`).
class MaterialLocalizationBg extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Bulgarian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBg({
    String localeName = 'bg',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Всичко за $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'ОТКАЗ';

  @override
  String get closeButtonLabel => r'ЗАТВАРЯНЕ';

  @override
  String get closeButtonTooltip => r'Затваряне';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'НАПРЕД';

  @override
  String get copyButtonLabel => r'КОПИРАНЕ';

  @override
  String get cutButtonLabel => r'ИЗРЯЗВАНЕ';

  @override
  String get deleteButtonTooltip => r'Изтриване';

  @override
  String get dialogLabel => r'Диалогов прозорец';

  @override
  String get drawerLabel => r'Меню за навигация';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Скриване на профилите';

  @override
  String get licensesPageTitle => r'Лицензи';

  @override
  String get modalBarrierDismissLabel => r'Отхвърляне';

  @override
  String get nextMonthTooltip => r'Следващият месец';

  @override
  String get nextPageTooltip => r'Следващата страница';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Отваряне на менюто за навигация';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow от $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow от около $rowCount';

  @override
  String get pasteButtonLabel => r'ПОСТАВЯНЕ';

  @override
  String get popupMenuLabel => r'Изскачащо меню';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Предишният месец';

  @override
  String get previousPageTooltip => r'Предишната страница';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Редове на страница:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'ИЗБИРАНЕ НА ВСИЧКО';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Избран е 1 елемент';

  @override
  String get selectedRowCountTitleOther => r'Избрани са $selectedRowCount елемента';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Показване на профилите';

  @override
  String get showMenuTooltip => r'Показване на менюто';

  @override
  String get signedInLabel => r'В профила си сте';

  @override
  String get tabLabelRaw => r'Раздел $tabIndex от $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Избиране на часове';

  @override
  String get timePickerMinuteModeAnnouncement => r'Избиране на минути';

  @override
  String get viewLicensesButtonLabel => r'ПРЕГЛЕД НА ЛИЦЕНЗИТЕ';
}

/// The translations for Bosnian (`bs`).
class MaterialLocalizationBs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Bosnian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBs({
    String localeName = 'bs',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'prijepodne';

  @override
  String get backButtonTooltip => r'Natrag';

  @override
  String get cancelButtonLabel => r'ODUSTANI';

  @override
  String get closeButtonLabel => r'ZATVORI';

  @override
  String get closeButtonTooltip => r'Zatvaranje';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'NASTAVI';

  @override
  String get copyButtonLabel => r'KOPIRAJ';

  @override
  String get cutButtonLabel => r'IZREŽI';

  @override
  String get deleteButtonTooltip => r'Brisanje';

  @override
  String get dialogLabel => r'Dijalog';

  @override
  String get drawerLabel => r'Navigacijski izbornik';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Sakrijte račune';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get modalBarrierDismissLabel => r'Odbaci';

  @override
  String get nextMonthTooltip => r'Sljedeći mjesec';

  @override
  String get nextPageTooltip => r'Sljedeća stranica';

  @override
  String get okButtonLabel => r'U REDU';

  @override
  String get openAppDrawerTooltip => r'Otvaranje izbornika za navigaciju';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow od otprilike $rowCount';

  @override
  String get pasteButtonLabel => r'ZALIJEPI';

  @override
  String get popupMenuLabel => r'Skočni izbornik';

  @override
  String get postMeridiemAbbreviation => r'popodne';

  @override
  String get previousMonthTooltip => r'Prethodni mjesec';

  @override
  String get previousPageTooltip => r'Prethodna stranica';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Redaka po stranici:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'ODABERI SVE';

  @override
  String get selectedRowCountTitleFew => r'Odabrane su $selectedRowCount stavke';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Odabrana je jedna stavka';

  @override
  String get selectedRowCountTitleOther => r'Odabrano je $selectedRowCount stavki';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Prikažite račune';

  @override
  String get showMenuTooltip => r'Prikaz izbornika';

  @override
  String get signedInLabel => r'Prijavljeni korisnik';

  @override
  String get tabLabelRaw => r'Kartica $tabIndex od $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Odaberite sate';

  @override
  String get timePickerMinuteModeAnnouncement => r'Odaberite minute';

  @override
  String get viewLicensesButtonLabel => r'PRIKAŽI LICENCE';
}

/// The translations for Catalan Valencian (`ca`).
class MaterialLocalizationCa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Catalan Valencian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationCa({
    String localeName = 'ca',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Sobre $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Enrere';

  @override
  String get cancelButtonLabel => r'CANCEL·LA';

  @override
  String get closeButtonLabel => r'TANCA';

  @override
  String get closeButtonTooltip => r'Tanca';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'CONTINUA';

  @override
  String get copyButtonLabel => r'COPIA';

  @override
  String get cutButtonLabel => r'RETALLA';

  @override
  String get deleteButtonTooltip => r'Suprimeix';

  @override
  String get dialogLabel => r'Diàleg';

  @override
  String get drawerLabel => r'Menú de navegació';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Amaga els comptes';

  @override
  String get licensesPageTitle => r'Llicències';

  @override
  String get modalBarrierDismissLabel => r'Ignora';

  @override
  String get nextMonthTooltip => r'Mes següent';

  @override
  String get nextPageTooltip => r'Pàgina següent';

  @override
  String get okButtonLabel => r'D' "'" r'ACORD';

  @override
  String get openAppDrawerTooltip => r'Obre el menú de navegació';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow d' "'" r'aproximadament $rowCount';

  @override
  String get pasteButtonLabel => r'ENGANXA';

  @override
  String get popupMenuLabel => r'Menú emergent';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Mes anterior';

  @override
  String get previousPageTooltip => r'Pàgina anterior';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Files per pàgina:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'SELECCIONA-HO TOT';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'S' "'" r'ha seleccionat 1 element';

  @override
  String get selectedRowCountTitleOther => r'S' "'" r'han seleccionat $selectedRowCount elements';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Mostra els comptes';

  @override
  String get showMenuTooltip => r'Mostra el menú';

  @override
  String get signedInLabel => r'Sessió iniciada';

  @override
  String get tabLabelRaw => r'Pestanya $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Selecciona les hores';

  @override
  String get timePickerMinuteModeAnnouncement => r'Selecciona els minuts';

  @override
  String get viewLicensesButtonLabel => r'MOSTRA LES LLICÈNCIES';
}

/// The translations for Czech (`cs`).
class MaterialLocalizationCs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Czech.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationCs({
    String localeName = 'cs',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaci $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Zpět';

  @override
  String get cancelButtonLabel => r'ZRUŠIT';

  @override
  String get closeButtonLabel => r'ZAVŘÍT';

  @override
  String get closeButtonTooltip => r'Zavřít';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'POKRAČOVAT';

  @override
  String get copyButtonLabel => r'KOPÍROVAT';

  @override
  String get cutButtonLabel => r'VYJMOUT';

  @override
  String get deleteButtonTooltip => r'Smazat';

  @override
  String get dialogLabel => r'Dialogové okno';

  @override
  String get drawerLabel => r'Navigační nabídka';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Skrýt účty';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get modalBarrierDismissLabel => r'Zavřít';

  @override
  String get nextMonthTooltip => r'Další měsíc';

  @override
  String get nextPageTooltip => r'Další stránka';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Otevřít navigační nabídku';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow z $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow z asi $rowCount';

  @override
  String get pasteButtonLabel => r'VLOŽIT';

  @override
  String get popupMenuLabel => r'Vyskakovací nabídka';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Předchozí měsíc';

  @override
  String get previousPageTooltip => r'Předchozí stránka';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Počet řádků na stránku:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'VYBRAT VŠE';

  @override
  String get selectedRowCountTitleFew => r'Jsou vybrány $selectedRowCount položky';

  @override
  String get selectedRowCountTitleMany => r'Je vybráno $selectedRowCount položky';

  @override
  String get selectedRowCountTitleOne => r'Je vybrána 1 položka';

  @override
  String get selectedRowCountTitleOther => r'Je vybráno $selectedRowCount položek';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Zobrazit účty';

  @override
  String get showMenuTooltip => r'Zobrazit nabídku';

  @override
  String get signedInLabel => r'Uživatel přihlášen';

  @override
  String get tabLabelRaw => r'Karta $tabIndex z $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Vyberte hodiny';

  @override
  String get timePickerMinuteModeAnnouncement => r'Vyberte minuty';

  @override
  String get viewLicensesButtonLabel => r'ZOBRAZIT LICENCE';
}

/// The translations for Danish (`da`).
class MaterialLocalizationDa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Danish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationDa({
    String localeName = 'da',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Tilbage';

  @override
  String get cancelButtonLabel => r'ANNULLER';

  @override
  String get closeButtonLabel => r'LUK';

  @override
  String get closeButtonTooltip => r'Luk';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'FORTSÆT';

  @override
  String get copyButtonLabel => r'KOPIÉR';

  @override
  String get cutButtonLabel => r'KLIP';

  @override
  String get deleteButtonTooltip => r'Slet';

  @override
  String get dialogLabel => r'Dialogboks';

  @override
  String get drawerLabel => r'Navigationsmenu';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Skjul konti';

  @override
  String get licensesPageTitle => r'Licenser';

  @override
  String get modalBarrierDismissLabel => r'Afvis';

  @override
  String get nextMonthTooltip => r'Næste måned';

  @override
  String get nextPageTooltip => r'Næste side';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Åbn navigationsmenuen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow af $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow af ca. $rowCount';

  @override
  String get pasteButtonLabel => r'SÆT IND';

  @override
  String get popupMenuLabel => r'Pop op-menu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Forrige måned';

  @override
  String get previousPageTooltip => r'Forrige side';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Rækker pr. side:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'VÆLG ALLE';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 element er valgt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementer er valgt';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Vis konti';

  @override
  String get showMenuTooltip => r'Vis menu';

  @override
  String get signedInLabel => r'Logget ind';

  @override
  String get tabLabelRaw => r'Fane $tabIndex af $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Vælg timer';

  @override
  String get timePickerMinuteModeAnnouncement => r'Vælg minutter';

  @override
  String get viewLicensesButtonLabel => r'SE LICENSER';
}

/// The translations for German (`de`).
class MaterialLocalizationDe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for German.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationDe({
    String localeName = 'de',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Über $applicationName';

  @override
  String get alertDialogLabel => r'Aufmerksam';

  @override
  String get anteMeridiemAbbreviation => r'VORM.';

  @override
  String get backButtonTooltip => r'Zurück';

  @override
  String get cancelButtonLabel => r'ABBRECHEN';

  @override
  String get closeButtonLabel => r'SCHLIEẞEN';

  @override
  String get closeButtonTooltip => r'Schließen';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'WEITER';

  @override
  String get copyButtonLabel => r'KOPIEREN';

  @override
  String get cutButtonLabel => r'AUSSCHNEIDEN';

  @override
  String get deleteButtonTooltip => r'Löschen';

  @override
  String get dialogLabel => r'Dialogfeld';

  @override
  String get drawerLabel => r'Navigationsmenü';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Konten ausblenden';

  @override
  String get licensesPageTitle => r'Lizenzen';

  @override
  String get modalBarrierDismissLabel => r'Schließen';

  @override
  String get nextMonthTooltip => r'Nächster Monat';

  @override
  String get nextPageTooltip => r'Nächste Seite';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Navigationsmenü öffnen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow von $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow von etwa $rowCount';

  @override
  String get pasteButtonLabel => r'EINFÜGEN';

  @override
  String get popupMenuLabel => r'Pop-up-Menü';

  @override
  String get postMeridiemAbbreviation => r'NACHM.';

  @override
  String get previousMonthTooltip => r'Vorheriger Monat';

  @override
  String get previousPageTooltip => r'Vorherige Seite';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Zeilen pro Seite:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Suchen';

  @override
  String get selectAllButtonLabel => r'ALLE AUSWÄHLEN';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 Element ausgewählt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount Elemente ausgewählt';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Keine Objekte ausgewählt';

  @override
  String get showAccountsLabel => r'Konten anzeigen';

  @override
  String get showMenuTooltip => r'Menü anzeigen';

  @override
  String get signedInLabel => r'Angemeldet';

  @override
  String get tabLabelRaw => r'Tab $tabIndex von $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Stunden auswählen';

  @override
  String get timePickerMinuteModeAnnouncement => r'Minuten auswählen';

  @override
  String get viewLicensesButtonLabel => r'LIZENZEN ANZEIGEN';
}

/// The translations for German, as used in Switzerland (`de_CH`).
class MaterialLocalizationDeCh extends MaterialLocalizationDe {
  /// Create an instance of the translation bundle for German, as used in Switzerland.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationDeCh({
    String localeName = 'de_CH',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get closeButtonTooltip => r'Schliessen';

  @override
  String get modalBarrierDismissLabel => r'Schliessen';
}

/// The translations for Modern Greek (`el`).
class MaterialLocalizationEl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Modern Greek.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEl({
    String localeName = 'el',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Σχετικά με την εφαρμογή $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'π.μ.';

  @override
  String get backButtonTooltip => r'Πίσω';

  @override
  String get cancelButtonLabel => r'ΑΚΥΡΩΣΗ';

  @override
  String get closeButtonLabel => r'ΚΛΕΙΣΙΜΟ';

  @override
  String get closeButtonTooltip => r'Κλείσιμο';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'ΣΥΝΕΧΕΙΑ';

  @override
  String get copyButtonLabel => r'ΑΝΤΙΓΡΑΦΗ';

  @override
  String get cutButtonLabel => r'ΑΠΟΚΟΠΗ';

  @override
  String get deleteButtonTooltip => r'Διαγραφή';

  @override
  String get dialogLabel => r'Παράθυρο διαλόγου';

  @override
  String get drawerLabel => r'Μενού πλοήγησης';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Απόκρυψη λογαριασμών';

  @override
  String get licensesPageTitle => r'Άδειες';

  @override
  String get modalBarrierDismissLabel => r'Παράβλεψη';

  @override
  String get nextMonthTooltip => r'Επόμενος μήνας';

  @override
  String get nextPageTooltip => r'Επόμενη σελίδα';

  @override
  String get okButtonLabel => r'ΟΚ';

  @override
  String get openAppDrawerTooltip => r'Άνοιγμα μενού πλοήγησης';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow από $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow από περίπου $rowCount';

  @override
  String get pasteButtonLabel => r'ΕΠΙΚΟΛΛΗΣΗ';

  @override
  String get popupMenuLabel => r'Αναδυόμενο μενού';

  @override
  String get postMeridiemAbbreviation => r'μ.μ.';

  @override
  String get previousMonthTooltip => r'Προηγούμενος μήνας';

  @override
  String get previousPageTooltip => r'Προηγούμενη σελίδα';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Σειρές ανά σελίδα:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'ΕΠΙΛΟΓΗ ΟΛΩΝ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Επιλέχθηκε 1 στοιχείο';

  @override
  String get selectedRowCountTitleOther => r'Επιλέχθηκαν $selectedRowCount στοιχεία';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Εμφάνιση λογαριασμών';

  @override
  String get showMenuTooltip => r'Εμφάνιση μενού';

  @override
  String get signedInLabel => r'Σε σύνδεση';

  @override
  String get tabLabelRaw => r'Καρτέλα $tabIndex από $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Επιλογή ωρών';

  @override
  String get timePickerMinuteModeAnnouncement => r'Επιλογή λεπτών';

  @override
  String get viewLicensesButtonLabel => r'ΠΡΟΒΟΛΗ ΑΔΕΙΩΝ';
}

/// The translations for English (`en`).
class MaterialLocalizationEn extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for English.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEn({
    String localeName = 'en',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'About $applicationName';

  @override
  String get alertDialogLabel => r'Alert';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Back';

  @override
  String get cancelButtonLabel => r'CANCEL';

  @override
  String get closeButtonLabel => r'CLOSE';

  @override
  String get closeButtonTooltip => r'Close';

  @override
  String get collapsedIconTapHint => r'Expand';

  @override
  String get continueButtonLabel => r'CONTINUE';

  @override
  String get copyButtonLabel => r'COPY';

  @override
  String get cutButtonLabel => r'CUT';

  @override
  String get deleteButtonTooltip => r'Delete';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Navigation menu';

  @override
  String get expandedIconTapHint => r'Collapse';

  @override
  String get hideAccountsLabel => r'Hide accounts';

  @override
  String get licensesPageTitle => r'Licenses';

  @override
  String get modalBarrierDismissLabel => r'Dismiss';

  @override
  String get nextMonthTooltip => r'Next month';

  @override
  String get nextPageTooltip => r'Next page';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Open navigation menu';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow of $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow of about $rowCount';

  @override
  String get pasteButtonLabel => r'PASTE';

  @override
  String get popupMenuLabel => r'Popup menu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Previous month';

  @override
  String get previousPageTooltip => r'Previous page';

  @override
  String get remainingTextFieldCharacterCountOne => r'1 character remaining';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount characters remaining';

  @override
  String get remainingTextFieldCharacterCountZero => r'No characters remaining';

  @override
  String get reorderItemDown => r'Move down';

  @override
  String get reorderItemLeft => r'Move left';

  @override
  String get reorderItemRight => r'Move right';

  @override
  String get reorderItemToEnd => r'Move to the end';

  @override
  String get reorderItemToStart => r'Move to the start';

  @override
  String get reorderItemUp => r'Move up';

  @override
  String get rowsPerPageTitle => r'Rows per page:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Search';

  @override
  String get selectAllButtonLabel => r'SELECT ALL';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item selected';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount items selected';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'No items selected';

  @override
  String get showAccountsLabel => r'Show accounts';

  @override
  String get showMenuTooltip => r'Show menu';

  @override
  String get signedInLabel => r'Signed in';

  @override
  String get tabLabelRaw => r'Tab $tabIndex of $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'Select hours';

  @override
  String get timePickerMinuteModeAnnouncement => r'Select minutes';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENSES';
}

/// The translations for English, as used in Australia (`en_AU`).
class MaterialLocalizationEnAu extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Australia.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnAu({
    String localeName = 'en_AU',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';
}

/// The translations for English, as used in Canada (`en_CA`).
class MaterialLocalizationEnCa extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Canada.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnCa({
    String localeName = 'en_CA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';
}

/// The translations for English, as used in the United Kingdom (`en_GB`).
class MaterialLocalizationEnGb extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in the United Kingdom.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnGb({
    String localeName = 'en_GB',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';
}

/// The translations for English, as used in Ireland (`en_IE`).
class MaterialLocalizationEnIe extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Ireland.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnIe({
    String localeName = 'en_IE',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';
}

/// The translations for English, as used in India (`en_IN`).
class MaterialLocalizationEnIn extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in India.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnIn({
    String localeName = 'en_IN',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';
}

/// The translations for English, as used in Singapore (`en_SG`).
class MaterialLocalizationEnSg extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Singapore.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnSg({
    String localeName = 'en_SG',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';
}

/// The translations for English, as used in South Africa (`en_ZA`).
class MaterialLocalizationEnZa extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in South Africa.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnZa({
    String localeName = 'en_ZA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';
}

/// The translations for Spanish Castilian (`es`).
class MaterialLocalizationEs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Spanish Castilian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEs({
    String localeName = 'es',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Sobre $applicationName';

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'A.M.';

  @override
  String get backButtonTooltip => r'Atrás';

  @override
  String get cancelButtonLabel => r'CANCELAR';

  @override
  String get closeButtonLabel => r'CERRAR';

  @override
  String get closeButtonTooltip => r'Cerrar';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'CONTINUAR';

  @override
  String get copyButtonLabel => r'COPIAR';

  @override
  String get cutButtonLabel => r'CORTAR';

  @override
  String get deleteButtonTooltip => r'Eliminar';

  @override
  String get dialogLabel => r'Cuadro de diálogo';

  @override
  String get drawerLabel => r'Menú de navegación';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Ocultar cuentas';

  @override
  String get licensesPageTitle => r'Licencias';

  @override
  String get modalBarrierDismissLabel => r'Ignorar';

  @override
  String get nextMonthTooltip => r'Mes siguiente';

  @override
  String get nextPageTooltip => r'Página siguiente';

  @override
  String get okButtonLabel => r'ACEPTAR';

  @override
  String get openAppDrawerTooltip => r'Abrir el menú de navegación';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow‑$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow‑$lastRow de aproximadamente $rowCount';

  @override
  String get pasteButtonLabel => r'PEGAR';

  @override
  String get popupMenuLabel => r'Menú emergente';

  @override
  String get postMeridiemAbbreviation => r'P.M.';

  @override
  String get previousMonthTooltip => r'Mes anterior';

  @override
  String get previousPageTooltip => r'Página anterior';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Filas por página:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Buscar';

  @override
  String get selectAllButtonLabel => r'SELECCIONAR TODO';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 elemento seleccionado';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementos seleccionados';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'No se han seleccionado elementos';

  @override
  String get showAccountsLabel => r'Mostrar cuentas';

  @override
  String get showMenuTooltip => r'Mostrar menú';

  @override
  String get signedInLabel => r'Sesión iniciada';

  @override
  String get tabLabelRaw => r'Pestaña $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Seleccionar horas';

  @override
  String get timePickerMinuteModeAnnouncement => r'Seleccionar minutos';

  @override
  String get viewLicensesButtonLabel => r'VER LICENCIAS';
}

/// The translations for Spanish Castilian, as used in Latin America and the Caribbean (`es_419`).
class MaterialLocalizationEs419 extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Latin America and the Caribbean.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEs419({
    String localeName = 'es_419',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Argentina (`es_AR`).
class MaterialLocalizationEsAr extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Argentina.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsAr({
    String localeName = 'es_AR',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Bolivia (`es_BO`).
class MaterialLocalizationEsBo extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Bolivia.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsBo({
    String localeName = 'es_BO',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Chile (`es_CL`).
class MaterialLocalizationEsCl extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Chile.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsCl({
    String localeName = 'es_CL',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Colombia (`es_CO`).
class MaterialLocalizationEsCo extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Colombia.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsCo({
    String localeName = 'es_CO',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Costa Rica (`es_CR`).
class MaterialLocalizationEsCr extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Costa Rica.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsCr({
    String localeName = 'es_CR',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in the Dominican Republic (`es_DO`).
class MaterialLocalizationEsDo extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in the Dominican Republic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsDo({
    String localeName = 'es_DO',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Ecuador (`es_EC`).
class MaterialLocalizationEsEc extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Ecuador.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsEc({
    String localeName = 'es_EC',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Guatemala (`es_GT`).
class MaterialLocalizationEsGt extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Guatemala.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsGt({
    String localeName = 'es_GT',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Honduras (`es_HN`).
class MaterialLocalizationEsHn extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Honduras.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsHn({
    String localeName = 'es_HN',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Mexico (`es_MX`).
class MaterialLocalizationEsMx extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Mexico.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsMx({
    String localeName = 'es_MX',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Nicaragua (`es_NI`).
class MaterialLocalizationEsNi extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Nicaragua.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsNi({
    String localeName = 'es_NI',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Panama (`es_PA`).
class MaterialLocalizationEsPa extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Panama.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPa({
    String localeName = 'es_PA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Peru (`es_PE`).
class MaterialLocalizationEsPe extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Peru.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPe({
    String localeName = 'es_PE',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Puerto Rico (`es_PR`).
class MaterialLocalizationEsPr extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Puerto Rico.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPr({
    String localeName = 'es_PR',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Paraguay (`es_PY`).
class MaterialLocalizationEsPy extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Paraguay.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPy({
    String localeName = 'es_PY',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in El Salvador (`es_SV`).
class MaterialLocalizationEsSv extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in El Salvador.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsSv({
    String localeName = 'es_SV',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in the United States (`es_US`).
class MaterialLocalizationEsUs extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in the United States.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsUs({
    String localeName = 'es_US',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Uruguay (`es_UY`).
class MaterialLocalizationEsUy extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Uruguay.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsUy({
    String localeName = 'es_UY',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Spanish Castilian, as used in Venezuela (`es_VE`).
class MaterialLocalizationEsVe extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Venezuela.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsVe({
    String localeName = 'es_VE',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';
}

/// The translations for Estonian (`et`).
class MaterialLocalizationEt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Estonian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEt({
    String localeName = 'et',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Teave rakenduse $applicationName kohta';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Tagasi';

  @override
  String get cancelButtonLabel => r'TÜHISTA';

  @override
  String get closeButtonLabel => r'SULE';

  @override
  String get closeButtonTooltip => r'Sule';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'JÄTKA';

  @override
  String get copyButtonLabel => r'KOPEERI';

  @override
  String get cutButtonLabel => r'LÕIKA';

  @override
  String get deleteButtonTooltip => r'Kustuta';

  @override
  String get dialogLabel => r'Dialoog';

  @override
  String get drawerLabel => r'Navigeerimismenüü';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Peida kontod';

  @override
  String get licensesPageTitle => r'Litsentsid';

  @override
  String get modalBarrierDismissLabel => r'Loobu';

  @override
  String get nextMonthTooltip => r'Järgmine kuu';

  @override
  String get nextPageTooltip => r'Järgmine leht';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Ava navigeerimismenüü';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow $rowCount-st';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow umbes $rowCount-st';

  @override
  String get pasteButtonLabel => r'KLEEBI';

  @override
  String get popupMenuLabel => r'Hüpikmenüü';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Eelmine kuu';

  @override
  String get previousPageTooltip => r'Eelmine leht';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Ridu lehe kohta:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'VALI KÕIK';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Valitud on 1 üksus';

  @override
  String get selectedRowCountTitleOther => r'Valitud on $selectedRowCount üksust';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Kuva kontod';

  @override
  String get showMenuTooltip => r'Kuva menüü';

  @override
  String get signedInLabel => r'Sisse logitud';

  @override
  String get tabLabelRaw => r'$tabIndex. vahekaart $tabCount-st';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Tundide valimine';

  @override
  String get timePickerMinuteModeAnnouncement => r'Minutite valimine';

  @override
  String get viewLicensesButtonLabel => r'KUVA LITSENTSID';
}

/// The translations for Persian (`fa`).
class MaterialLocalizationFa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Persian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFa({
    String localeName = 'fa',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'درباره $applicationName';

  @override
  String get alertDialogLabel => r'هشدار';

  @override
  String get anteMeridiemAbbreviation => r'ق.ظ.';

  @override
  String get backButtonTooltip => r'برگشت';

  @override
  String get cancelButtonLabel => r'لغو';

  @override
  String get closeButtonLabel => r'بستن';

  @override
  String get closeButtonTooltip => r'بستن';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'ادامه';

  @override
  String get copyButtonLabel => r'کپی';

  @override
  String get cutButtonLabel => r'برش';

  @override
  String get deleteButtonTooltip => r'حذف';

  @override
  String get dialogLabel => r'کادر گفتگو';

  @override
  String get drawerLabel => r'منوی پیمایش';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'پنهان کردن حساب‌ها';

  @override
  String get licensesPageTitle => r'مجوزها';

  @override
  String get modalBarrierDismissLabel => r'نپذیرفتن';

  @override
  String get nextMonthTooltip => r'ماه بعد';

  @override
  String get nextPageTooltip => r'صفحه بعد';

  @override
  String get okButtonLabel => r'تأیید';

  @override
  String get openAppDrawerTooltip => r'باز کردن منوی پیمایش';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow از $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow از حدود $rowCount';

  @override
  String get pasteButtonLabel => r'جای‌گذاری';

  @override
  String get popupMenuLabel => r'منوی بازشو';

  @override
  String get postMeridiemAbbreviation => r'ب.ظ.';

  @override
  String get previousMonthTooltip => r'ماه قبل';

  @override
  String get previousPageTooltip => r'صفحه قبل';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'ردیف در هر صفحه:';

  @override
  String get scriptCategory => r'tall';

  @override
  String get searchFieldLabel => r'جستجو کردن';

  @override
  String get selectAllButtonLabel => r'انتخاب همه';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'۱ مورد انتخاب شد';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount مورد انتخاب شدند';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'نشان دادن حساب‌ها';

  @override
  String get showMenuTooltip => r'نمایش منو';

  @override
  String get signedInLabel => r'واردشده به سیستم';

  @override
  String get tabLabelRaw => r'برگه $tabIndex از $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'انتخاب ساعت';

  @override
  String get timePickerMinuteModeAnnouncement => r'انتخاب دقیقه';

  @override
  String get viewLicensesButtonLabel => r'مشاهده مجوزها';
}

/// The translations for Finnish (`fi`).
class MaterialLocalizationFi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Finnish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFi({
    String localeName = 'fi',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tietoja sovelluksesta $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'ap';

  @override
  String get backButtonTooltip => r'Takaisin';

  @override
  String get cancelButtonLabel => r'PERUUTA';

  @override
  String get closeButtonLabel => r'SULJE';

  @override
  String get closeButtonTooltip => r'Sulje';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'JATKA';

  @override
  String get copyButtonLabel => r'COPY';

  @override
  String get cutButtonLabel => r'LEIKKAA';

  @override
  String get deleteButtonTooltip => r'Poista';

  @override
  String get dialogLabel => r'Valintaikkuna';

  @override
  String get drawerLabel => r'Navigointivalikko';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Piilota tilit';

  @override
  String get licensesPageTitle => r'Lisenssit';

  @override
  String get modalBarrierDismissLabel => r'Ohita';

  @override
  String get nextMonthTooltip => r'Seuraava kuukausi';

  @override
  String get nextPageTooltip => r'Seuraava sivu';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Avaa navigointivalikko';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow/$rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow/~$rowCount';

  @override
  String get pasteButtonLabel => r'LIITÄ';

  @override
  String get popupMenuLabel => r'Ponnahdusvalikko';

  @override
  String get postMeridiemAbbreviation => r'ip';

  @override
  String get previousMonthTooltip => r'Edellinen kuukausi';

  @override
  String get previousPageTooltip => r'Edellinen sivu';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Riviä/sivu:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'VALITSE KAIKKI';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 kohde valittu';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount kohdetta valittu';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Näytä tilit';

  @override
  String get showMenuTooltip => r'Näytä valikko';

  @override
  String get signedInLabel => r'Kirjautunut sisään';

  @override
  String get tabLabelRaw => r'Välilehti $tabIndex/$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Valitse tunnit';

  @override
  String get timePickerMinuteModeAnnouncement => r'Valitse minuutit';

  @override
  String get viewLicensesButtonLabel => r'NÄYTÄ KÄYTTÖOIKEUDET';
}

/// The translations for Filipino Pilipino (`fil`).
class MaterialLocalizationFil extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Filipino Pilipino.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFil({
    String localeName = 'fil',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tungkol sa $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Bumalik';

  @override
  String get cancelButtonLabel => r'KANSELAHIN';

  @override
  String get closeButtonLabel => r'ISARA';

  @override
  String get closeButtonTooltip => r'Isara';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'MAGPATULOY';

  @override
  String get copyButtonLabel => r'KOPYAHIN';

  @override
  String get cutButtonLabel => r'I-CUT';

  @override
  String get deleteButtonTooltip => r'I-delete';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Menu ng navigation';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Itago ang mga account';

  @override
  String get licensesPageTitle => r'Mga Lisensya';

  @override
  String get modalBarrierDismissLabel => r'I-dismiss';

  @override
  String get nextMonthTooltip => r'Susunod na buwan';

  @override
  String get nextPageTooltip => r'Susunod na page';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Buksan ang menu ng navigation';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ng $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ng humigit kumulang $rowCount';

  @override
  String get pasteButtonLabel => r'I-PASTE';

  @override
  String get popupMenuLabel => r'Popup na menu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Nakaraang buwan';

  @override
  String get previousPageTooltip => r'Nakaraang page';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Mga row bawat page:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'PILIIN LAHAT';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item ang napili';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount na item ang napili';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Ipakita ang mga account';

  @override
  String get showMenuTooltip => r'Ipakita ang menu';

  @override
  String get signedInLabel => r'Naka-sign in';

  @override
  String get tabLabelRaw => r'Tab $tabIndex ng $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Pumili ng mga oras';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pumili ng mga minuto';

  @override
  String get viewLicensesButtonLabel => r'TINGNAN ANG MGA LISENSYA';
}

/// The translations for French (`fr`).
class MaterialLocalizationFr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for French.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFr({
    String localeName = 'fr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'À propos de $applicationName';

  @override
  String get alertDialogLabel => r'Alerte';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Retour';

  @override
  String get cancelButtonLabel => r'ANNULER';

  @override
  String get closeButtonLabel => r'FERMER';

  @override
  String get closeButtonTooltip => r'Fermer';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'CONTINUER';

  @override
  String get copyButtonLabel => r'COPIER';

  @override
  String get cutButtonLabel => r'COUPER';

  @override
  String get deleteButtonTooltip => r'Supprimer';

  @override
  String get dialogLabel => r'Boîte de dialogue';

  @override
  String get drawerLabel => r'Menu de navigation';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Masquer les comptes';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get modalBarrierDismissLabel => r'Ignorer';

  @override
  String get nextMonthTooltip => r'Mois suivant';

  @override
  String get nextPageTooltip => r'Page suivante';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Ouvrir le menu de navigation';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow sur $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow sur environ $rowCount';

  @override
  String get pasteButtonLabel => r'COLLER';

  @override
  String get popupMenuLabel => r'Menu contextuel';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Mois précédent';

  @override
  String get previousPageTooltip => r'Page précédente';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Lignes par page :';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Chercher';

  @override
  String get selectAllButtonLabel => r'TOUT SÉLECTIONNER';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 élément sélectionné';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount éléments sélectionnés';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Aucun élément sélectionné';

  @override
  String get showAccountsLabel => r'Afficher les comptes';

  @override
  String get showMenuTooltip => r'Afficher le menu';

  @override
  String get signedInLabel => r'Connecté';

  @override
  String get tabLabelRaw => r'Onglet $tabIndex sur $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Sélectionner une heure';

  @override
  String get timePickerMinuteModeAnnouncement => r'Sélectionner des minutes';

  @override
  String get viewLicensesButtonLabel => r'AFFICHER LES LICENCES';
}

/// The translations for French, as used in Canada (`fr_CA`).
class MaterialLocalizationFrCa extends MaterialLocalizationFr {
  /// Create an instance of the translation bundle for French, as used in Canada.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFrCa({
    String localeName = 'fr_CA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.frenchCanadian;
}

/// The translations for Swiss German Alemannic Alsatian (`gsw`).
class MaterialLocalizationGsw extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Swiss German Alemannic Alsatian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationGsw({
    String localeName = 'gsw',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Über $applicationName';

  @override
  String get alertDialogLabel => r'Aufmerksam';

  @override
  String get anteMeridiemAbbreviation => r'VORM.';

  @override
  String get backButtonTooltip => r'Zurück';

  @override
  String get cancelButtonLabel => r'ABBRECHEN';

  @override
  String get closeButtonLabel => r'SCHLIEẞEN';

  @override
  String get closeButtonTooltip => r'Schließen';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'WEITER';

  @override
  String get copyButtonLabel => r'KOPIEREN';

  @override
  String get cutButtonLabel => r'AUSSCHNEIDEN';

  @override
  String get deleteButtonTooltip => r'Löschen';

  @override
  String get dialogLabel => r'Dialogfeld';

  @override
  String get drawerLabel => r'Navigationsmenü';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Konten ausblenden';

  @override
  String get licensesPageTitle => r'Lizenzen';

  @override
  String get modalBarrierDismissLabel => r'Schließen';

  @override
  String get nextMonthTooltip => r'Nächster Monat';

  @override
  String get nextPageTooltip => r'Nächste Seite';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Navigationsmenü öffnen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow von $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow von etwa $rowCount';

  @override
  String get pasteButtonLabel => r'EINFÜGEN';

  @override
  String get popupMenuLabel => r'Pop-up-Menü';

  @override
  String get postMeridiemAbbreviation => r'NACHM.';

  @override
  String get previousMonthTooltip => r'Vorheriger Monat';

  @override
  String get previousPageTooltip => r'Vorherige Seite';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Zeilen pro Seite:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Suchen';

  @override
  String get selectAllButtonLabel => r'ALLE AUSWÄHLEN';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 Element ausgewählt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount Elemente ausgewählt';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Konten anzeigen';

  @override
  String get showMenuTooltip => r'Menü anzeigen';

  @override
  String get signedInLabel => r'Angemeldet';

  @override
  String get tabLabelRaw => r'Tab $tabIndex von $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Stunden auswählen';

  @override
  String get timePickerMinuteModeAnnouncement => r'Minuten auswählen';

  @override
  String get viewLicensesButtonLabel => r'LIZENZEN ANZEIGEN';
}

/// The translations for Hebrew (`he`).
class MaterialLocalizationHe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Hebrew.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHe({
    String localeName = 'he',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'מידע על $applicationName';

  @override
  String get alertDialogLabel => r'עֵרָנִי';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'הקודם';

  @override
  String get cancelButtonLabel => r'ביטול';

  @override
  String get closeButtonLabel => r'סגירה';

  @override
  String get closeButtonTooltip => r'סגירה';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'המשך';

  @override
  String get copyButtonLabel => r'העתקה';

  @override
  String get cutButtonLabel => r'גזירה';

  @override
  String get deleteButtonTooltip => r'מחיקה';

  @override
  String get dialogLabel => r'תיבת דו-שיח';

  @override
  String get drawerLabel => r'תפריט ניווט';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'הסתרת החשבונות';

  @override
  String get licensesPageTitle => r'רישיונות';

  @override
  String get modalBarrierDismissLabel => r'סגירה';

  @override
  String get nextMonthTooltip => r'החודש הבא';

  @override
  String get nextPageTooltip => r'הדף הבא';

  @override
  String get okButtonLabel => r'אישור';

  @override
  String get openAppDrawerTooltip => r'פתיחה של תפריט הניווט';

  @override
  String get pageRowsInfoTitleRaw => r'$lastRow–$firstRow מתוך $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$lastRow–$firstRow מתוך כ-$rowCount';

  @override
  String get pasteButtonLabel => r'הדבקה';

  @override
  String get popupMenuLabel => r'תפריט קופץ';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'החודש הקודם';

  @override
  String get previousPageTooltip => r'הדף הקודם';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'שורות בכל דף:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'לחפש';

  @override
  String get selectAllButtonLabel => r'בחירת הכול';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => r'$selectedRowCount פריטים נבחרו';

  @override
  String get selectedRowCountTitleOne => r'פריט אחד נבחר';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount פריטים נבחרו';

  @override
  String get selectedRowCountTitleTwo => r'$selectedRowCount פריטים נבחרו';

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'הצגת החשבונות';

  @override
  String get showMenuTooltip => r'הצגת התפריט';

  @override
  String get signedInLabel => r'מחובר';

  @override
  String get tabLabelRaw => r'כרטיסייה $tabIndex מתוך $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'בחירת שעות';

  @override
  String get timePickerMinuteModeAnnouncement => r'בחירת דקות';

  @override
  String get viewLicensesButtonLabel => r'הצגת הרישיונות';
}

/// The translations for Hindi (`hi`).
class MaterialLocalizationHi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Hindi.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHi({
    String localeName = 'hi',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName के बारे में जानकारी';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'वापस जाएं';

  @override
  String get cancelButtonLabel => r'रद्द करें';

  @override
  String get closeButtonLabel => r'बंद करें';

  @override
  String get closeButtonTooltip => r'बंद करें';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'जारी रखें';

  @override
  String get copyButtonLabel => r'कॉपी करें';

  @override
  String get cutButtonLabel => r'कट करें';

  @override
  String get deleteButtonTooltip => r'मिटाएं';

  @override
  String get dialogLabel => r'संवाद';

  @override
  String get drawerLabel => r'नेविगेशन मेन्यू';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'खाते छिपाएं';

  @override
  String get licensesPageTitle => r'लाइसेंस';

  @override
  String get modalBarrierDismissLabel => r'खारिज करें';

  @override
  String get nextMonthTooltip => r'अगला महीना';

  @override
  String get nextPageTooltip => r'अगला पेज';

  @override
  String get okButtonLabel => r'ठीक है';

  @override
  String get openAppDrawerTooltip => r'नेविगेशन मेन्यू खोलें';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount का $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCount में से करीब $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'चिपकाएं';

  @override
  String get popupMenuLabel => r'पॉपअप मेन्यू';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'पिछला महीना';

  @override
  String get previousPageTooltip => r'पिछला पेज';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'हर पेज में पंक्तियों की संख्या:';

  @override
  String get scriptCategory => r'dense';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'सभी चुनें';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 चीज़ चुनी गई';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount चीज़ें चुनी गईं';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'खाते दिखाएं';

  @override
  String get showMenuTooltip => r'मेन्यू दिखाएं';

  @override
  String get signedInLabel => r'साइन इन किया हुआ है';

  @override
  String get tabLabelRaw => r'$tabCount का टैब $tabIndex';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'घंटे के हिसाब से समय चुनें';

  @override
  String get timePickerMinuteModeAnnouncement => r'मिनट के हिसाब से समय चुनें';

  @override
  String get viewLicensesButtonLabel => r'लाइसेंस देखें';
}

/// The translations for Croatian (`hr`).
class MaterialLocalizationHr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Croatian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHr({
    String localeName = 'hr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'prijepodne';

  @override
  String get backButtonTooltip => r'Natrag';

  @override
  String get cancelButtonLabel => r'ODUSTANI';

  @override
  String get closeButtonLabel => r'ZATVORI';

  @override
  String get closeButtonTooltip => r'Zatvaranje';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'NASTAVI';

  @override
  String get copyButtonLabel => r'KOPIRAJ';

  @override
  String get cutButtonLabel => r'IZREŽI';

  @override
  String get deleteButtonTooltip => r'Brisanje';

  @override
  String get dialogLabel => r'Dijalog';

  @override
  String get drawerLabel => r'Navigacijski izbornik';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Sakrijte račune';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get modalBarrierDismissLabel => r'Odbaci';

  @override
  String get nextMonthTooltip => r'Sljedeći mjesec';

  @override
  String get nextPageTooltip => r'Sljedeća stranica';

  @override
  String get okButtonLabel => r'U REDU';

  @override
  String get openAppDrawerTooltip => r'Otvaranje izbornika za navigaciju';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow od otprilike $rowCount';

  @override
  String get pasteButtonLabel => r'ZALIJEPI';

  @override
  String get popupMenuLabel => r'Skočni izbornik';

  @override
  String get postMeridiemAbbreviation => r'popodne';

  @override
  String get previousMonthTooltip => r'Prethodni mjesec';

  @override
  String get previousPageTooltip => r'Prethodna stranica';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Redaka po stranici:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'ODABERI SVE';

  @override
  String get selectedRowCountTitleFew => r'Odabrane su $selectedRowCount stavke';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Odabrana je jedna stavka';

  @override
  String get selectedRowCountTitleOther => r'Odabrano je $selectedRowCount stavki';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Prikažite račune';

  @override
  String get showMenuTooltip => r'Prikaz izbornika';

  @override
  String get signedInLabel => r'Prijavljeni korisnik';

  @override
  String get tabLabelRaw => r'Kartica $tabIndex od $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Odaberite sate';

  @override
  String get timePickerMinuteModeAnnouncement => r'Odaberite minute';

  @override
  String get viewLicensesButtonLabel => r'PRIKAŽI LICENCE';
}

/// The translations for Hungarian (`hu`).
class MaterialLocalizationHu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Hungarian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHu({
    String localeName = 'hu',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'A(z) $applicationName névjegye';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'de.';

  @override
  String get backButtonTooltip => r'Vissza';

  @override
  String get cancelButtonLabel => r'MÉGSE';

  @override
  String get closeButtonLabel => r'BEZÁRÁS';

  @override
  String get closeButtonTooltip => r'Bezárás';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'TOVÁBB';

  @override
  String get copyButtonLabel => r'MÁSOLÁS';

  @override
  String get cutButtonLabel => r'KIVÁGÁS';

  @override
  String get deleteButtonTooltip => r'Törlés';

  @override
  String get dialogLabel => r'Párbeszédablak';

  @override
  String get drawerLabel => r'Navigációs menü';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Fiókok elrejtése';

  @override
  String get licensesPageTitle => r'Licencek';

  @override
  String get modalBarrierDismissLabel => r'Elvetés';

  @override
  String get nextMonthTooltip => r'Következő hónap';

  @override
  String get nextPageTooltip => r'Következő oldal';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Navigációs menü megnyitása';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount/$firstRow–$lastRow.';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'Körülbelül $rowCount/$firstRow–$lastRow.';

  @override
  String get pasteButtonLabel => r'BEILLESZTÉS';

  @override
  String get popupMenuLabel => r'Előugró menü';

  @override
  String get postMeridiemAbbreviation => r'du.';

  @override
  String get previousMonthTooltip => r'Előző hónap';

  @override
  String get previousPageTooltip => r'Előző oldal';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Oldalankénti sorszám:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'AZ ÖSSZES KIJELÖLÉSE';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 elem kiválasztva';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elem kiválasztva';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Fiókok megjelenítése';

  @override
  String get showMenuTooltip => r'Menü megjelenítése';

  @override
  String get signedInLabel => r'Bejelentkezve';

  @override
  String get tabLabelRaw => r'$tabCount/$tabIndex. lap';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Óra kiválasztása';

  @override
  String get timePickerMinuteModeAnnouncement => r'Perc kiválasztása';

  @override
  String get viewLicensesButtonLabel => r'LICENCEK MEGTEKINTÉSE';
}

/// The translations for Indonesian (`id`).
class MaterialLocalizationId extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Indonesian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationId({
    String localeName = 'id',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tentang $applicationName';

  @override
  String get alertDialogLabel => r'Waspada';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Kembali';

  @override
  String get cancelButtonLabel => r'BATAL';

  @override
  String get closeButtonLabel => r'TUTUP';

  @override
  String get closeButtonTooltip => r'Tutup';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'LANJUTKAN';

  @override
  String get copyButtonLabel => r'SALIN';

  @override
  String get cutButtonLabel => r'POTONG';

  @override
  String get deleteButtonTooltip => r'Hapus';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Menu navigasi';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Sembunyikan akun';

  @override
  String get licensesPageTitle => r'Lisensi';

  @override
  String get modalBarrierDismissLabel => r'Tutup';

  @override
  String get nextMonthTooltip => r'Bulan berikutnya';

  @override
  String get nextPageTooltip => r'Halaman berikutnya';

  @override
  String get okButtonLabel => r'Oke';

  @override
  String get openAppDrawerTooltip => r'Buka menu navigasi';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow dari $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow dari kira-kira $rowCount';

  @override
  String get pasteButtonLabel => r'TEMPEL';

  @override
  String get popupMenuLabel => r'Menu pop-up';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Bulan sebelumnya';

  @override
  String get previousPageTooltip => r'Halaman sebelumnya';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Baris per halaman:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Pencarian';

  @override
  String get selectAllButtonLabel => r'PILIH SEMUA';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item dipilih';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount item dipilih';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Tampilkan akun';

  @override
  String get showMenuTooltip => r'Tampilkan menu';

  @override
  String get signedInLabel => r'Telah login';

  @override
  String get tabLabelRaw => r'Tab $tabIndex dari $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Pilih jam';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pilih menit';

  @override
  String get viewLicensesButtonLabel => r'LIHAT LISENSI';
}

/// The translations for Italian (`it`).
class MaterialLocalizationIt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Italian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationIt({
    String localeName = 'it',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Informazioni su $applicationName';

  @override
  String get alertDialogLabel => r'Mettere in guardia';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Indietro';

  @override
  String get cancelButtonLabel => r'ANNULLA';

  @override
  String get closeButtonLabel => r'CHIUDI';

  @override
  String get closeButtonTooltip => r'Chiudi';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'CONTINUA';

  @override
  String get copyButtonLabel => r'COPIA';

  @override
  String get cutButtonLabel => r'TAGLIA';

  @override
  String get deleteButtonTooltip => r'Elimina';

  @override
  String get dialogLabel => r'Finestra di dialogo';

  @override
  String get drawerLabel => r'Menu di navigazione';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Nascondi account';

  @override
  String get licensesPageTitle => r'Licenze';

  @override
  String get modalBarrierDismissLabel => r'Ignora';

  @override
  String get nextMonthTooltip => r'Mese successivo';

  @override
  String get nextPageTooltip => r'Pagina successiva';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Apri il menu di navigazione';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow di $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow di circa $rowCount';

  @override
  String get pasteButtonLabel => r'INCOLLA';

  @override
  String get popupMenuLabel => r'Menu popup';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Mese precedente';

  @override
  String get previousPageTooltip => r'Pagina precedente';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Righe per pagina:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Ricerca';

  @override
  String get selectAllButtonLabel => r'SELEZIONA TUTTO';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 elemento selezionato';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementi selezionati';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Mostra account';

  @override
  String get showMenuTooltip => r'Mostra il menu';

  @override
  String get signedInLabel => r'Connesso';

  @override
  String get tabLabelRaw => r'Scheda $tabIndex di $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Seleziona le ore';

  @override
  String get timePickerMinuteModeAnnouncement => r'Seleziona i minuti';

  @override
  String get viewLicensesButtonLabel => r'VISUALIZZA LICENZE';
}

/// The translations for Japanese (`ja`).
class MaterialLocalizationJa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Japanese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationJa({
    String localeName = 'ja',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName について';

  @override
  String get alertDialogLabel => r'アラート';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'戻る';

  @override
  String get cancelButtonLabel => r'キャンセル';

  @override
  String get closeButtonLabel => r'閉じる';

  @override
  String get closeButtonTooltip => r'閉じる';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'続行';

  @override
  String get copyButtonLabel => r'コピー';

  @override
  String get cutButtonLabel => r'切り取り';

  @override
  String get deleteButtonTooltip => r'削除';

  @override
  String get dialogLabel => r'ダイアログ';

  @override
  String get drawerLabel => r'ナビゲーション メニュー';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'アカウントを非表示';

  @override
  String get licensesPageTitle => r'ライセンス';

  @override
  String get modalBarrierDismissLabel => r'閉じる';

  @override
  String get nextMonthTooltip => r'来月';

  @override
  String get nextPageTooltip => r'次のページ';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'ナビゲーション メニューを開く';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow - $lastRow 行（合計 $rowCount 行）';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow 行（合計約 $rowCount 行）';

  @override
  String get pasteButtonLabel => r'貼り付け';

  @override
  String get popupMenuLabel => r'ポップアップ メニュー';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'前月';

  @override
  String get previousPageTooltip => r'前のページ';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'ページあたりの行数:';

  @override
  String get scriptCategory => r'dense';

  @override
  String get searchFieldLabel => r'サーチ';

  @override
  String get selectAllButtonLabel => r'すべて選択';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 件のアイテムを選択中';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount 件のアイテムを選択中';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'アカウントを表示';

  @override
  String get showMenuTooltip => r'メニューを表示';

  @override
  String get signedInLabel => r'ログイン中';

  @override
  String get tabLabelRaw => r'タブ: $tabIndex/$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'時間を選択';

  @override
  String get timePickerMinuteModeAnnouncement => r'分を選択';

  @override
  String get viewLicensesButtonLabel => r'ライセンスを表示';
}

/// The translations for Korean (`ko`).
class MaterialLocalizationKo extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Korean.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKo({
    String localeName = 'ko',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName 정보';

  @override
  String get alertDialogLabel => r'경보';

  @override
  String get anteMeridiemAbbreviation => r'오전';

  @override
  String get backButtonTooltip => r'뒤로';

  @override
  String get cancelButtonLabel => r'취소';

  @override
  String get closeButtonLabel => r'닫기';

  @override
  String get closeButtonTooltip => r'닫기';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'계속';

  @override
  String get copyButtonLabel => r'복사';

  @override
  String get cutButtonLabel => r'잘라내기';

  @override
  String get deleteButtonTooltip => r'삭제';

  @override
  String get dialogLabel => r'대화상자';

  @override
  String get drawerLabel => r'탐색 메뉴';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'계정 숨기기';

  @override
  String get licensesPageTitle => r'라이선스';

  @override
  String get modalBarrierDismissLabel => r'닫기';

  @override
  String get nextMonthTooltip => r'다음 달';

  @override
  String get nextPageTooltip => r'다음 페이지';

  @override
  String get okButtonLabel => r'확인';

  @override
  String get openAppDrawerTooltip => r'탐색 메뉴 열기';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount행 중 $firstRow~$lastRow행';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'약 $rowCount행 중 $firstRow~$lastRow행';

  @override
  String get pasteButtonLabel => r'붙여넣기';

  @override
  String get popupMenuLabel => r'팝업 메뉴';

  @override
  String get postMeridiemAbbreviation => r'오후';

  @override
  String get previousMonthTooltip => r'지난달';

  @override
  String get previousPageTooltip => r'이전 페이지';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'페이지당 행 수:';

  @override
  String get scriptCategory => r'dense';

  @override
  String get searchFieldLabel => r'수색';

  @override
  String get selectAllButtonLabel => r'전체 선택';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'항목 1개 선택됨';

  @override
  String get selectedRowCountTitleOther => r'항목 $selectedRowCount개 선택됨';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'계정 표시';

  @override
  String get showMenuTooltip => r'메뉴 표시';

  @override
  String get signedInLabel => r'로그인됨';

  @override
  String get tabLabelRaw => r'탭 $tabCount개 중 $tabIndex번째';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'시간 선택';

  @override
  String get timePickerMinuteModeAnnouncement => r'분 선택';

  @override
  String get viewLicensesButtonLabel => r'라이선스 보기';
}

/// The translations for Lithuanian (`lt`).
class MaterialLocalizationLt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Lithuanian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationLt({
    String localeName = 'lt',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Apie „$applicationName“';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'priešpiet';

  @override
  String get backButtonTooltip => r'Atgal';

  @override
  String get cancelButtonLabel => r'ATŠAUKTI';

  @override
  String get closeButtonLabel => r'UŽDARYTI';

  @override
  String get closeButtonTooltip => r'Uždaryti';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'TĘSTI';

  @override
  String get copyButtonLabel => r'KOPIJUOTI';

  @override
  String get cutButtonLabel => r'IŠKIRPTI';

  @override
  String get deleteButtonTooltip => r'Ištrinti';

  @override
  String get dialogLabel => r'Dialogo langas';

  @override
  String get drawerLabel => r'Naršymo meniu';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Slėpti paskyras';

  @override
  String get licensesPageTitle => r'Licencijos';

  @override
  String get modalBarrierDismissLabel => r'Atsisakyti';

  @override
  String get nextMonthTooltip => r'Kitas mėnuo';

  @override
  String get nextPageTooltip => r'Kitas puslapis';

  @override
  String get okButtonLabel => r'GERAI';

  @override
  String get openAppDrawerTooltip => r'Atidaryti naršymo meniu';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow iš $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow iš maždaug $rowCount';

  @override
  String get pasteButtonLabel => r'ĮKLIJUOTI';

  @override
  String get popupMenuLabel => r'Iššokantysis meniu';

  @override
  String get postMeridiemAbbreviation => r'popiet';

  @override
  String get previousMonthTooltip => r'Ankstesnis mėnuo';

  @override
  String get previousPageTooltip => r'Ankstesnis puslapis';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Eilučių puslapyje:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'PASIRINKTI VISKĄ';

  @override
  String get selectedRowCountTitleFew => r'Pasirinkti $selectedRowCount elementai';

  @override
  String get selectedRowCountTitleMany => r'Pasirinkta $selectedRowCount elemento';

  @override
  String get selectedRowCountTitleOne => r'Pasirinktas 1 elementas';

  @override
  String get selectedRowCountTitleOther => r'Pasirinkta $selectedRowCount elementų';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Rodyti paskyras';

  @override
  String get showMenuTooltip => r'Rodyti meniu';

  @override
  String get signedInLabel => r'Prisijungta';

  @override
  String get tabLabelRaw => r'$tabIndex skirtukas iš $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Pasirinkite valandas';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pasirinkite minutes';

  @override
  String get viewLicensesButtonLabel => r'PERŽIŪRĖTI LICENCIJAS';
}

/// The translations for Latvian (`lv`).
class MaterialLocalizationLv extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Latvian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationLv({
    String localeName = 'lv',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Par $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'priekšpusdienā';

  @override
  String get backButtonTooltip => r'Atpakaļ';

  @override
  String get cancelButtonLabel => r'ATCELT';

  @override
  String get closeButtonLabel => r'AIZVĒRT';

  @override
  String get closeButtonTooltip => r'Aizvērt';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'TURPINĀT';

  @override
  String get copyButtonLabel => r'KOPĒT';

  @override
  String get cutButtonLabel => r'IZGRIEZT';

  @override
  String get deleteButtonTooltip => r'Dzēst';

  @override
  String get dialogLabel => r'Dialoglodziņš';

  @override
  String get drawerLabel => r'Navigācijas izvēlne';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Slēpt kontus';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get modalBarrierDismissLabel => r'Nerādīt';

  @override
  String get nextMonthTooltip => r'Nākamais mēnesis';

  @override
  String get nextPageTooltip => r'Nākamā lapa';

  @override
  String get okButtonLabel => r'LABI';

  @override
  String get openAppDrawerTooltip => r'Atvērt navigācijas izvēlni';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow.–$lastRow. no $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow.–$lastRow. no aptuveni $rowCount';

  @override
  String get pasteButtonLabel => r'IELĪMĒT';

  @override
  String get popupMenuLabel => r'Uznirstošā izvēlne';

  @override
  String get postMeridiemAbbreviation => r'pēcpusdienā';

  @override
  String get previousMonthTooltip => r'Iepriekšējais mēnesis';

  @override
  String get previousPageTooltip => r'Iepriekšējā lapa';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Rindas lapā:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'ATLASĪT VISU';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Atlasīts 1 vienums';

  @override
  String get selectedRowCountTitleOther => r'Atlasīti $selectedRowCount vienumi';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Nav atlasītu vienumu';

  @override
  String get showAccountsLabel => r'Rādīt kontus';

  @override
  String get showMenuTooltip => r'Rādīt izvēlni';

  @override
  String get signedInLabel => r'Esat pierakstījies';

  @override
  String get tabLabelRaw => r'$tabIndex. cilne no $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Atlasiet stundas';

  @override
  String get timePickerMinuteModeAnnouncement => r'Atlasiet minūtes';

  @override
  String get viewLicensesButtonLabel => r'SKATĪT LICENCES';
}

/// The translations for Malay (`ms`).
class MaterialLocalizationMs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Malay.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMs({
    String localeName = 'ms',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Perihal $applicationName';

  @override
  String get alertDialogLabel => r'Amaran';

  @override
  String get anteMeridiemAbbreviation => r'PG';

  @override
  String get backButtonTooltip => r'Kembali';

  @override
  String get cancelButtonLabel => r'BATAL';

  @override
  String get closeButtonLabel => r'TUTUP';

  @override
  String get closeButtonTooltip => r'Tutup';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'TERUSKAN';

  @override
  String get copyButtonLabel => r'SALIN';

  @override
  String get cutButtonLabel => r'POTONG';

  @override
  String get deleteButtonTooltip => r'Padam';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Menu navigasi';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Sembunyikan akaun';

  @override
  String get licensesPageTitle => r'Lesen';

  @override
  String get modalBarrierDismissLabel => r'Tolak';

  @override
  String get nextMonthTooltip => r'Bulan depan';

  @override
  String get nextPageTooltip => r'Halaman seterusnya';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Buka menu navigasi';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow dari $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow dari kira-kira $rowCount';

  @override
  String get pasteButtonLabel => r'TAMPAL';

  @override
  String get popupMenuLabel => r'Menu pop timbul';

  @override
  String get postMeridiemAbbreviation => r'PTG';

  @override
  String get previousMonthTooltip => r'Bulan sebelumnya';

  @override
  String get previousPageTooltip => r'Halaman sebelumnya';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Baris setiap halaman:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Carian';

  @override
  String get selectAllButtonLabel => r'PILIH SEMUA';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item dipilih';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount item dipilih';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Tiada item dipilih';

  @override
  String get showAccountsLabel => r'Tunjukkan akaun';

  @override
  String get showMenuTooltip => r'Tunjukkan menu';

  @override
  String get signedInLabel => r'Dilog masuk';

  @override
  String get tabLabelRaw => r'Tab $tabIndex dari $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'Pilih jam';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pilih minit';

  @override
  String get viewLicensesButtonLabel => r'LIHAT LESEN';
}

/// The translations for Norwegian Bokmål (`nb`).
class MaterialLocalizationNb extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Norwegian Bokmål.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationNb({
    String localeName = 'nb',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => r'Varsling';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Tilbake';

  @override
  String get cancelButtonLabel => r'AVBRYT';

  @override
  String get closeButtonLabel => r'LUKK';

  @override
  String get closeButtonTooltip => r'Lukk';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'FORTSETT';

  @override
  String get copyButtonLabel => r'KOPIÉR';

  @override
  String get cutButtonLabel => r'KLIPP UT';

  @override
  String get deleteButtonTooltip => r'Slett';

  @override
  String get dialogLabel => r'Dialogboks';

  @override
  String get drawerLabel => r'Navigasjonsmeny';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Skjul kontoer';

  @override
  String get licensesPageTitle => r'Lisenser';

  @override
  String get modalBarrierDismissLabel => r'Avvis';

  @override
  String get nextMonthTooltip => r'Neste måned';

  @override
  String get nextPageTooltip => r'Neste side';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Åpne navigasjonsmenyen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow av $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow av omtrent $rowCount';

  @override
  String get pasteButtonLabel => r'LIM INN';

  @override
  String get popupMenuLabel => r'Forgrunnsmeny';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Forrige måned';

  @override
  String get previousPageTooltip => r'Forrige side';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Rader per side:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Søke';

  @override
  String get selectAllButtonLabel => r'VELG ALLE';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 element er valgt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementer er valgt';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Vis kontoer';

  @override
  String get showMenuTooltip => r'Vis meny';

  @override
  String get signedInLabel => r'Pålogget';

  @override
  String get tabLabelRaw => r'Fane $tabIndex av $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Angi timer';

  @override
  String get timePickerMinuteModeAnnouncement => r'Angi minutter';

  @override
  String get viewLicensesButtonLabel => r'SE LISENSER';
}

/// The translations for Dutch Flemish (`nl`).
class MaterialLocalizationNl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Dutch Flemish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationNl({
    String localeName = 'nl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Over $applicationName';

  @override
  String get alertDialogLabel => r'Alarm';

  @override
  String get anteMeridiemAbbreviation => r'am';

  @override
  String get backButtonTooltip => r'Terug';

  @override
  String get cancelButtonLabel => r'ANNULEREN';

  @override
  String get closeButtonLabel => r'SLUITEN';

  @override
  String get closeButtonTooltip => r'Sluiten';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'DOORGAAN';

  @override
  String get copyButtonLabel => r'KOPIËREN';

  @override
  String get cutButtonLabel => r'KNIPPEN';

  @override
  String get deleteButtonTooltip => r'Verwijderen';

  @override
  String get dialogLabel => r'Dialoogvenster';

  @override
  String get drawerLabel => r'Navigatiemenu';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Accounts verbergen';

  @override
  String get licensesPageTitle => r'Licenties';

  @override
  String get modalBarrierDismissLabel => r'Sluiten';

  @override
  String get nextMonthTooltip => r'Volgende maand';

  @override
  String get nextPageTooltip => r'Volgende pagina';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Navigatiemenu openen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow van $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow van ongeveer $rowCount';

  @override
  String get pasteButtonLabel => r'PLAKKEN';

  @override
  String get popupMenuLabel => r'Pop-upmenu';

  @override
  String get postMeridiemAbbreviation => r'pm';

  @override
  String get previousMonthTooltip => r'Vorige maand';

  @override
  String get previousPageTooltip => r'Vorige pagina';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Rijen per pagina:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Zoeken';

  @override
  String get selectAllButtonLabel => r'ALLES SELECTEREN';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item geselecteerd';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount items geselecteerd';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Accounts weergeven';

  @override
  String get showMenuTooltip => r'Menu weergeven';

  @override
  String get signedInLabel => r'Ingelogd';

  @override
  String get tabLabelRaw => r'Tabblad $tabIndex van $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Uren selecteren';

  @override
  String get timePickerMinuteModeAnnouncement => r'Minuten selecteren';

  @override
  String get viewLicensesButtonLabel => r'LICENTIES BEKIJKEN';
}

/// The translations for Polish (`pl`).
class MaterialLocalizationPl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Polish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPl({
    String localeName = 'pl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName – informacje';

  @override
  String get alertDialogLabel => r'Alarm';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Wstecz';

  @override
  String get cancelButtonLabel => r'ANULUJ';

  @override
  String get closeButtonLabel => r'ZAMKNIJ';

  @override
  String get closeButtonTooltip => r'Zamknij';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'DALEJ';

  @override
  String get copyButtonLabel => r'KOPIUJ';

  @override
  String get cutButtonLabel => r'WYTNIJ';

  @override
  String get deleteButtonTooltip => r'Usuń';

  @override
  String get dialogLabel => r'Okno dialogowe';

  @override
  String get drawerLabel => r'Menu nawigacyjne';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Ukryj konta';

  @override
  String get licensesPageTitle => r'Licencje';

  @override
  String get modalBarrierDismissLabel => r'Zamknij';

  @override
  String get nextMonthTooltip => r'Następny miesiąc';

  @override
  String get nextPageTooltip => r'Następna strona';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Otwórz menu nawigacyjne';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow z $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow z około $rowCount';

  @override
  String get pasteButtonLabel => r'WKLEJ';

  @override
  String get popupMenuLabel => r'Wyskakujące menu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Poprzedni miesiąc';

  @override
  String get previousPageTooltip => r'Poprzednia strona';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Wiersze na stronie:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Szukaj';

  @override
  String get selectAllButtonLabel => r'ZAZNACZ WSZYSTKO';

  @override
  String get selectedRowCountTitleFew => r'$selectedRowCount wybrane elementy';

  @override
  String get selectedRowCountTitleMany => r'$selectedRowCount wybranych elementów';

  @override
  String get selectedRowCountTitleOne => r'1 wybrany element';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount wybranego elementu';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Pokaż konta';

  @override
  String get showMenuTooltip => r'Pokaż menu';

  @override
  String get signedInLabel => r'Zalogowani użytkownicy';

  @override
  String get tabLabelRaw => r'Karta $tabIndex z $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Wybierz godziny';

  @override
  String get timePickerMinuteModeAnnouncement => r'Wybierz minuty';

  @override
  String get viewLicensesButtonLabel => r'WYŚWIETL LICENCJE';
}

/// The translations for Pushto Pashto (`ps`).
class MaterialLocalizationPs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Pushto Pashto.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPs({
    String localeName = 'ps',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'د $applicationName په اړه';

  @override
  String get alertDialogLabel => r'خبرتیا';

  @override
  String get anteMeridiemAbbreviation => null;

  @override
  String get backButtonTooltip => r'شاته';

  @override
  String get cancelButtonLabel => r'لغوه کول';

  @override
  String get closeButtonLabel => r'تړل';

  @override
  String get closeButtonTooltip => r'بنده';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'منځپانګې';

  @override
  String get copyButtonLabel => r'کاپی';

  @override
  String get cutButtonLabel => r'کم کړئ';

  @override
  String get deleteButtonTooltip => r'';

  @override
  String get dialogLabel => r'خبرې اترې';

  @override
  String get drawerLabel => r'د نیویگیشن مینو';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'حسابونه پټ کړئ';

  @override
  String get licensesPageTitle => r'جوازونه';

  @override
  String get modalBarrierDismissLabel => r'رد کړه';

  @override
  String get nextMonthTooltip => r'بله میاشت';

  @override
  String get nextPageTooltip => r'بله پاڼه';

  @override
  String get okButtonLabel => r'سمه ده';

  @override
  String get openAppDrawerTooltip => r'د پرانیستی نیینګ مینو';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow د $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow څخه $rowCount د';

  @override
  String get pasteButtonLabel => r'پیټ کړئ';

  @override
  String get popupMenuLabel => r'د پاپ اپ مینو';

  @override
  String get postMeridiemAbbreviation => null;

  @override
  String get previousMonthTooltip => r'تیره میاشت';

  @override
  String get previousPageTooltip => r'مخکینی مخ';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'د هرې پاڼې پاڼې:';

  @override
  String get scriptCategory => r'tall';

  @override
  String get searchFieldLabel => r'لټون';

  @override
  String get selectAllButtonLabel => r'غوره کړئ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => null;

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount توکي غوره شوي';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'حسابونه ښکاره کړئ';

  @override
  String get showMenuTooltip => r'غورنۍ ښودل';

  @override
  String get signedInLabel => r'ننوتل';

  @override
  String get tabLabelRaw => r'$tabIndex د $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'وختونه وټاکئ';

  @override
  String get timePickerMinuteModeAnnouncement => r'منې غوره کړئ';

  @override
  String get viewLicensesButtonLabel => r'لیدلس وګورئ';
}

/// The translations for Portuguese (`pt`).
class MaterialLocalizationPt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Portuguese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPt({
    String localeName = 'pt',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Sobre o app $applicationName';

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'Manhã';

  @override
  String get backButtonTooltip => r'Voltar';

  @override
  String get cancelButtonLabel => r'CANCELAR';

  @override
  String get closeButtonLabel => r'FECHAR';

  @override
  String get closeButtonTooltip => r'Fechar';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'CONTINUAR';

  @override
  String get copyButtonLabel => r'COPIAR';

  @override
  String get cutButtonLabel => r'RECORTAR';

  @override
  String get deleteButtonTooltip => r'Excluir';

  @override
  String get dialogLabel => r'Caixa de diálogo';

  @override
  String get drawerLabel => r'Menu de navegação';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Ocultar contas';

  @override
  String get licensesPageTitle => r'Licenças';

  @override
  String get modalBarrierDismissLabel => r'Dispensar';

  @override
  String get nextMonthTooltip => r'Próximo mês';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get okButtonLabel => r'Ok';

  @override
  String get openAppDrawerTooltip => r'Abrir menu de navegação';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow de aproximadamente $rowCount';

  @override
  String get pasteButtonLabel => r'COLAR';

  @override
  String get popupMenuLabel => r'Menu pop-up';

  @override
  String get postMeridiemAbbreviation => r'Tarde/noite';

  @override
  String get previousMonthTooltip => r'Mês anterior';

  @override
  String get previousPageTooltip => r'Página anterior';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Linhas por página:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Pesquisa';

  @override
  String get selectAllButtonLabel => r'SELECIONAR TUDO';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item selecionado';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount itens selecionados';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Mostrar contas';

  @override
  String get showMenuTooltip => r'Mostrar menu';

  @override
  String get signedInLabel => r'Conectado a';

  @override
  String get tabLabelRaw => r'Guia $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Selecione as horas';

  @override
  String get timePickerMinuteModeAnnouncement => r'Selecione os minutos';

  @override
  String get viewLicensesButtonLabel => r'VER LICENÇAS';
}

/// The translations for Portuguese, as used in Portugal (`pt_PT`).
class MaterialLocalizationPtPt extends MaterialLocalizationPt {
  /// Create an instance of the translation bundle for Portuguese, as used in Portugal.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPtPt({
    String localeName = 'pt_PT',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get tabLabelRaw => r'Separador $tabIndex de $tabCount';

  @override
  String get signedInLabel => r'Com sessão iniciada';

  @override
  String get timePickerMinuteModeAnnouncement => r'Selecionar minutos';

  @override
  String get timePickerHourModeAnnouncement => r'Selecionar horas';

  @override
  String get deleteButtonTooltip => r'Eliminar';

  @override
  String get nextMonthTooltip => r'Mês seguinte';

  @override
  String get nextPageTooltip => r'Página seguinte';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow a $lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow a $lastRow de cerca de $rowCount';

  @override
  String get cutButtonLabel => r'CORTAR';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get modalBarrierDismissLabel => r'Ignorar';
}

/// The translations for Romanian Moldavian Moldovan (`ro`).
class MaterialLocalizationRo extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Romanian Moldavian Moldovan.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationRo({
    String localeName = 'ro',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Despre $applicationName';

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get backButtonTooltip => r'Înapoi';

  @override
  String get cancelButtonLabel => r'ANULAȚI';

  @override
  String get closeButtonLabel => r'ÎNCHIDEȚI';

  @override
  String get closeButtonTooltip => r'Închideți';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'CONTINUAȚI';

  @override
  String get copyButtonLabel => r'COPIAȚI';

  @override
  String get cutButtonLabel => r'DECUPAȚI';

  @override
  String get deleteButtonTooltip => r'Ștergeți';

  @override
  String get dialogLabel => r'Casetă de dialog';

  @override
  String get drawerLabel => r'Meniu de navigare';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Ascundeți conturile';

  @override
  String get licensesPageTitle => r'Licențe';

  @override
  String get modalBarrierDismissLabel => r'Închideți';

  @override
  String get nextMonthTooltip => r'Luna viitoare';

  @override
  String get nextPageTooltip => r'Pagina următoare';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Deschideți meniul de navigare';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow din $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow din aproximativ $rowCount';

  @override
  String get pasteButtonLabel => r'INSERAȚI';

  @override
  String get popupMenuLabel => r'Meniu pop-up';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get previousMonthTooltip => r'Luna trecută';

  @override
  String get previousPageTooltip => r'Pagina anterioară';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Rânduri pe pagină:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Căutare';

  @override
  String get selectAllButtonLabel => r'SELECTAȚI TOATE';

  @override
  String get selectedRowCountTitleFew => r'$selectedRowCount articole selectate';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Un articol selectat';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount de articole selectate';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Nu există elemente selectate';

  @override
  String get showAccountsLabel => r'Afișați conturile';

  @override
  String get showMenuTooltip => r'Afișați meniul';

  @override
  String get signedInLabel => r'V-ați conectat';

  @override
  String get tabLabelRaw => r'Fila $tabIndex din $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Selectați orele';

  @override
  String get timePickerMinuteModeAnnouncement => r'Selectați minutele';

  @override
  String get viewLicensesButtonLabel => r'VEDEȚI LICENȚELE';
}

/// The translations for Russian (`ru`).
class MaterialLocalizationRu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Russian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationRu({
    String localeName = 'ru',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName: сведения';

  @override
  String get alertDialogLabel => r'бдительный';

  @override
  String get anteMeridiemAbbreviation => r'АМ';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'ОТМЕНА';

  @override
  String get closeButtonLabel => r'ЗАКРЫТЬ';

  @override
  String get closeButtonTooltip => r'Закрыть';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'ПРОДОЛЖИТЬ';

  @override
  String get copyButtonLabel => r'КОПИРОВАТЬ';

  @override
  String get cutButtonLabel => r'ВЫРЕЗАТЬ';

  @override
  String get deleteButtonTooltip => r'Удалить';

  @override
  String get dialogLabel => r'Диалоговое окно';

  @override
  String get drawerLabel => r'Меню навигации';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Скрыть аккаунты';

  @override
  String get licensesPageTitle => r'Лицензии';

  @override
  String get modalBarrierDismissLabel => r'Закрыть';

  @override
  String get nextMonthTooltip => r'Следующий месяц';

  @override
  String get nextPageTooltip => r'Следующая страница';

  @override
  String get okButtonLabel => r'ОК';

  @override
  String get openAppDrawerTooltip => r'Открыть меню навигации';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow из $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow из примерно $rowCount';

  @override
  String get pasteButtonLabel => r'ВСТАВИТЬ';

  @override
  String get popupMenuLabel => r'Всплывающее меню';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Предыдущий месяц';

  @override
  String get previousPageTooltip => r'Предыдущая страница';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Строк на странице:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Поиск';

  @override
  String get selectAllButtonLabel => r'ВЫБРАТЬ ВСЕ';

  @override
  String get selectedRowCountTitleFew => r'Выбрано $selectedRowCount объекта';

  @override
  String get selectedRowCountTitleMany => r'Выбрано $selectedRowCount объектов';

  @override
  String get selectedRowCountTitleOne => r'Выбран 1 объект';

  @override
  String get selectedRowCountTitleOther => r'Выбрано $selectedRowCount объекта';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Строки не выбраны';

  @override
  String get showAccountsLabel => r'Показать аккаунты';

  @override
  String get showMenuTooltip => r'Показать меню';

  @override
  String get signedInLabel => r'Вход выполнен';

  @override
  String get tabLabelRaw => r'Вкладка $tabIndex из $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Выберите часы';

  @override
  String get timePickerMinuteModeAnnouncement => r'Выберите минуты';

  @override
  String get viewLicensesButtonLabel => r'ЛИЦЕНЗИИ';
}

/// The translations for Slovak (`sk`).
class MaterialLocalizationSk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Slovak.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSk({
    String localeName = 'sk',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName – informácie';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Späť';

  @override
  String get cancelButtonLabel => r'ZRUŠIŤ';

  @override
  String get closeButtonLabel => r'ZAVRIEŤ';

  @override
  String get closeButtonTooltip => r'Zavrieť';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'POKRAČOVAŤ';

  @override
  String get copyButtonLabel => r'KOPÍROVAŤ';

  @override
  String get cutButtonLabel => r'VYSTRIHNÚŤ';

  @override
  String get deleteButtonTooltip => r'Odstrániť';

  @override
  String get dialogLabel => r'Dialógové okno';

  @override
  String get drawerLabel => r'Navigačná ponuka';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Skryť účty';

  @override
  String get licensesPageTitle => r'Licencie';

  @override
  String get modalBarrierDismissLabel => r'Odmietnuť';

  @override
  String get nextMonthTooltip => r'Budúci mesiac';

  @override
  String get nextPageTooltip => r'Ďalšia strana';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Otvoriť navigačnú ponuku';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow z $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow z približne $rowCount';

  @override
  String get pasteButtonLabel => r'PRILEPIŤ';

  @override
  String get popupMenuLabel => r'Kontextová ponuka';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Predošlý mesiac';

  @override
  String get previousPageTooltip => r'Predchádzajúca stránka';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Počet riadkov na stránku:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'VYBRAŤ VŠETKO';

  @override
  String get selectedRowCountTitleFew => r'$selectedRowCount vybraté položky';

  @override
  String get selectedRowCountTitleMany => r'$selectedRowCount items selected';

  @override
  String get selectedRowCountTitleOne => r'1 vybratá položka';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount vybratých položiek';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Zobraziť účty';

  @override
  String get showMenuTooltip => r'Zobraziť ponuku';

  @override
  String get signedInLabel => r'Prihlásili ste sa';

  @override
  String get tabLabelRaw => r'Karta $tabIndex z $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Vybrať hodiny';

  @override
  String get timePickerMinuteModeAnnouncement => r'Vybrať minúty';

  @override
  String get viewLicensesButtonLabel => r'ZOBRAZIŤ LICENCIE';
}

/// The translations for Slovenian (`sl`).
class MaterialLocalizationSl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Slovenian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSl({
    String localeName = 'sl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'DOP.';

  @override
  String get backButtonTooltip => r'Nazaj';

  @override
  String get cancelButtonLabel => r'PREKLIČI';

  @override
  String get closeButtonLabel => r'ZAPRI';

  @override
  String get closeButtonTooltip => r'Zapiranje';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'NAPREJ';

  @override
  String get copyButtonLabel => r'KOPIRAJ';

  @override
  String get cutButtonLabel => r'IZREŽI';

  @override
  String get deleteButtonTooltip => r'Brisanje';

  @override
  String get dialogLabel => r'Pogovorno okno';

  @override
  String get drawerLabel => r'Meni za krmarjenje';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Skrivanje računov';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get modalBarrierDismissLabel => r'Opusti';

  @override
  String get nextMonthTooltip => r'Naslednji mesec';

  @override
  String get nextPageTooltip => r'Naslednja stran';

  @override
  String get okButtonLabel => r'V REDU';

  @override
  String get openAppDrawerTooltip => r'Odpiranje menija za krmarjenje';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow od približno $rowCount';

  @override
  String get pasteButtonLabel => r'PRILEPI';

  @override
  String get popupMenuLabel => r'Pojavni meni';

  @override
  String get postMeridiemAbbreviation => r'POP.';

  @override
  String get previousMonthTooltip => r'Prejšnji mesec';

  @override
  String get previousPageTooltip => r'Prejšnja stran';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Vrstice na stran:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'IZBERI VSE';

  @override
  String get selectedRowCountTitleFew => r'Izbrani so $selectedRowCount elementi';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Izbran je 1 element';

  @override
  String get selectedRowCountTitleOther => r'Izbranih je $selectedRowCount elementov';

  @override
  String get selectedRowCountTitleTwo => r'Izbrana sta $selectedRowCount elementa';

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Prikaz računov';

  @override
  String get showMenuTooltip => r'Prikaz menija';

  @override
  String get signedInLabel => r'Prijavljen';

  @override
  String get tabLabelRaw => r'Zavihek $tabIndex od $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Izberite ure';

  @override
  String get timePickerMinuteModeAnnouncement => r'Izberite minute';

  @override
  String get viewLicensesButtonLabel => r'PRIKAŽI LICENCE';
}

/// The translations for Serbian (`sr`).
class MaterialLocalizationSr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Serbian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSr({
    String localeName = 'sr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'О апликацији $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'пре подне';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'ОТКАЖИ';

  @override
  String get closeButtonLabel => r'ЗАТВОРИ';

  @override
  String get closeButtonTooltip => r'Затворите';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'НАСТАВИ';

  @override
  String get copyButtonLabel => r'КОПИРАЈ';

  @override
  String get cutButtonLabel => r'ИСЕЦИ';

  @override
  String get deleteButtonTooltip => r'Избришите';

  @override
  String get dialogLabel => r'Дијалог';

  @override
  String get drawerLabel => r'Мени за навигацију';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Сакриј налоге';

  @override
  String get licensesPageTitle => r'Лиценце';

  @override
  String get modalBarrierDismissLabel => r'Одбаци';

  @override
  String get nextMonthTooltip => r'Следећи месец';

  @override
  String get nextPageTooltip => r'Следећа страница';

  @override
  String get okButtonLabel => r'Потврди';

  @override
  String get openAppDrawerTooltip => r'Отворите мени за навигацију';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow oд $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow oд приближно $rowCount';

  @override
  String get pasteButtonLabel => r'НАЛЕПИ';

  @override
  String get popupMenuLabel => r'Искачући мени';

  @override
  String get postMeridiemAbbreviation => r'по подне';

  @override
  String get previousMonthTooltip => r'Претходни месец';

  @override
  String get previousPageTooltip => r'Претходна страница';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Редова по страници:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'ИЗАБЕРИ СВЕ';

  @override
  String get selectedRowCountTitleFew => r'Изабране су $selectedRowCount ставке';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Изабрана је 1 ставка';

  @override
  String get selectedRowCountTitleOther => r'Изабрано је $selectedRowCount ставки';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Прикажи налоге';

  @override
  String get showMenuTooltip => r'Прикажи мени';

  @override
  String get signedInLabel => r'Пријављени сте';

  @override
  String get tabLabelRaw => r'$tabIndex. картица од $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Изаберите сате';

  @override
  String get timePickerMinuteModeAnnouncement => r'Изаберите минуте';

  @override
  String get viewLicensesButtonLabel => r'ПРИКАЖИ ЛИЦЕНЦЕ';
}

/// The translations for Serbian, using the Latin script (`sr_Latn`).
class MaterialLocalizationSrLatn extends MaterialLocalizationSr {
  /// Create an instance of the translation bundle for Serbian, using the Latin script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSrLatn({
    String localeName = 'sr_Latn',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get selectedRowCountTitleFew => r'Izabrane su $selectedRowCount stavke';

  @override
  String get openAppDrawerTooltip => r'Otvorite meni za navigaciju';

  @override
  String get backButtonTooltip => r'Nazad';

  @override
  String get closeButtonTooltip => r'Zatvorite';

  @override
  String get deleteButtonTooltip => r'Izbrišite';

  @override
  String get nextMonthTooltip => r'Sledeći mesec';

  @override
  String get previousMonthTooltip => r'Prethodni mesec';

  @override
  String get nextPageTooltip => r'Sledeća stranica';

  @override
  String get previousPageTooltip => r'Prethodna stranica';

  @override
  String get showMenuTooltip => r'Prikaži meni';

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow od približno $rowCount';

  @override
  String get rowsPerPageTitle => r'Redova po stranici:';

  @override
  String get tabLabelRaw => r'$tabIndex. kartica od $tabCount';

  @override
  String get selectedRowCountTitleOne => r'Izabrana je 1 stavka';

  @override
  String get selectedRowCountTitleOther => r'Izabrano je $selectedRowCount stavki';

  @override
  String get cancelButtonLabel => r'OTKAŽI';

  @override
  String get closeButtonLabel => r'ZATVORI';

  @override
  String get continueButtonLabel => r'NASTAVI';

  @override
  String get copyButtonLabel => r'KOPIRAJ';

  @override
  String get cutButtonLabel => r'ISECI';

  @override
  String get okButtonLabel => r'Potvrdi';

  @override
  String get pasteButtonLabel => r'NALEPI';

  @override
  String get selectAllButtonLabel => r'IZABERI SVE';

  @override
  String get viewLicensesButtonLabel => r'PRIKAŽI LICENCE';

  @override
  String get anteMeridiemAbbreviation => r'pre podne';

  @override
  String get postMeridiemAbbreviation => r'po podne';

  @override
  String get timePickerHourModeAnnouncement => r'Izaberite sate';

  @override
  String get timePickerMinuteModeAnnouncement => r'Izaberite minute';

  @override
  String get modalBarrierDismissLabel => r'Odbaci';

  @override
  String get signedInLabel => r'Prijavljeni ste';

  @override
  String get hideAccountsLabel => r'Sakrij naloge';

  @override
  String get showAccountsLabel => r'Prikaži naloge';

  @override
  String get drawerLabel => r'Meni za navigaciju';

  @override
  String get popupMenuLabel => r'Iskačući meni';

  @override
  String get dialogLabel => r'Dijalog';
}

/// The translations for Swedish (`sv`).
class MaterialLocalizationSv extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Swedish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSv({
    String localeName = 'sv',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'FM';

  @override
  String get backButtonTooltip => r'Tillbaka';

  @override
  String get cancelButtonLabel => r'AVBRYT';

  @override
  String get closeButtonLabel => r'STÄNG';

  @override
  String get closeButtonTooltip => r'Stäng';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'FORTSÄTT';

  @override
  String get copyButtonLabel => r'KOPIERA';

  @override
  String get cutButtonLabel => r'KLIPP UT';

  @override
  String get deleteButtonTooltip => r'Radera';

  @override
  String get dialogLabel => r'Dialogruta';

  @override
  String get drawerLabel => r'Navigeringsmeny';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Dölj konton';

  @override
  String get licensesPageTitle => r'Licenser';

  @override
  String get modalBarrierDismissLabel => r'Stäng';

  @override
  String get nextMonthTooltip => r'Nästa månad';

  @override
  String get nextPageTooltip => r'Nästa sida';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Öppna navigeringsmenyn';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow av $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow av ungefär $rowCount';

  @override
  String get pasteButtonLabel => r'KLISTRA IN';

  @override
  String get popupMenuLabel => r'Popup-meny';

  @override
  String get postMeridiemAbbreviation => r'EM';

  @override
  String get previousMonthTooltip => r'Föregående månad';

  @override
  String get previousPageTooltip => r'Föregående sida';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Rader per sida:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'MARKERA ALLA';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 objekt har markerats';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount objekt har markerats';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Visa konton';

  @override
  String get showMenuTooltip => r'Visa meny';

  @override
  String get signedInLabel => r'Inloggad';

  @override
  String get tabLabelRaw => r'Flik $tabIndex av $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Välj timmar';

  @override
  String get timePickerMinuteModeAnnouncement => r'Välj minuter';

  @override
  String get viewLicensesButtonLabel => r'VISA LICENSER';
}

/// The translations for Thai (`th`).
class MaterialLocalizationTh extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Thai.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTh({
    String localeName = 'th',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'เกี่ยวกับ $applicationName';

  @override
  String get alertDialogLabel => r'เตือนภัย';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'กลับ';

  @override
  String get cancelButtonLabel => r'ยกเลิก';

  @override
  String get closeButtonLabel => r'ปิด';

  @override
  String get closeButtonTooltip => r'ปิด';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'ต่อไป';

  @override
  String get copyButtonLabel => r'คัดลอก';

  @override
  String get cutButtonLabel => r'ตัด';

  @override
  String get deleteButtonTooltip => r'ลบ';

  @override
  String get dialogLabel => r'กล่องโต้ตอบ';

  @override
  String get drawerLabel => r'เมนูการนำทาง';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'ซ่อนบัญชี';

  @override
  String get licensesPageTitle => r'ใบอนุญาต';

  @override
  String get modalBarrierDismissLabel => r'ปิด';

  @override
  String get nextMonthTooltip => r'เดือนหน้า';

  @override
  String get nextPageTooltip => r'หน้าถัดไป';

  @override
  String get okButtonLabel => r'ตกลง';

  @override
  String get openAppDrawerTooltip => r'เปิดเมนูการนำทาง';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow จาก $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow จากประมาณ $rowCount';

  @override
  String get pasteButtonLabel => r'วาง';

  @override
  String get popupMenuLabel => r'เมนูป๊อปอัป';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'เดือนที่แล้ว';

  @override
  String get previousPageTooltip => r'หน้าก่อน';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'แถวต่อหน้า:';

  @override
  String get scriptCategory => r'tall';

  @override
  String get searchFieldLabel => r'ค้นหา';

  @override
  String get selectAllButtonLabel => r'เลือกทั้งหมด';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'เลือกแล้ว 1 รายการ';

  @override
  String get selectedRowCountTitleOther => r'เลือกแล้ว $selectedRowCount รายการ';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'แสดงบัญชี';

  @override
  String get showMenuTooltip => r'แสดงเมนู';

  @override
  String get signedInLabel => r'ลงชื่อเข้าใช้';

  @override
  String get tabLabelRaw => r'แท็บที่ $tabIndex จาก $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'เลือกชั่วโมง';

  @override
  String get timePickerMinuteModeAnnouncement => r'เลือกนาที';

  @override
  String get viewLicensesButtonLabel => r'ดูใบอนุญาต';
}

/// The translations for Tagalog (`tl`).
class MaterialLocalizationTl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Tagalog.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTl({
    String localeName = 'tl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tungkol sa $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Bumalik';

  @override
  String get cancelButtonLabel => r'KANSELAHIN';

  @override
  String get closeButtonLabel => r'ISARA';

  @override
  String get closeButtonTooltip => r'Isara';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'MAGPATULOY';

  @override
  String get copyButtonLabel => r'KOPYAHIN';

  @override
  String get cutButtonLabel => r'I-CUT';

  @override
  String get deleteButtonTooltip => r'I-delete';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Menu ng navigation';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Itago ang mga account';

  @override
  String get licensesPageTitle => r'Mga Lisensya';

  @override
  String get modalBarrierDismissLabel => r'I-dismiss';

  @override
  String get nextMonthTooltip => r'Susunod na buwan';

  @override
  String get nextPageTooltip => r'Susunod na page';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Buksan ang menu ng navigation';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ng $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ng humigit kumulang $rowCount';

  @override
  String get pasteButtonLabel => r'I-PASTE';

  @override
  String get popupMenuLabel => r'Popup na menu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Nakaraang buwan';

  @override
  String get previousPageTooltip => r'Nakaraang page';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Mga row bawat page:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'PILIIN LAHAT';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item ang napili';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount na item ang napili';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Ipakita ang mga account';

  @override
  String get showMenuTooltip => r'Ipakita ang menu';

  @override
  String get signedInLabel => r'Naka-sign in';

  @override
  String get tabLabelRaw => r'Tab $tabIndex ng $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Pumili ng mga oras';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pumili ng mga minuto';

  @override
  String get viewLicensesButtonLabel => r'TINGNAN ANG MGA LISENSYA';
}

/// The translations for Turkish (`tr`).
class MaterialLocalizationTr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Turkish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTr({
    String localeName = 'tr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName Hakkında';

  @override
  String get alertDialogLabel => r'Alarm';

  @override
  String get anteMeridiemAbbreviation => r'ÖÖ';

  @override
  String get backButtonTooltip => r'Geri';

  @override
  String get cancelButtonLabel => r'İPTAL';

  @override
  String get closeButtonLabel => r'KAPAT';

  @override
  String get closeButtonTooltip => r'Kapat';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'DEVAM';

  @override
  String get copyButtonLabel => r'KOPYALA';

  @override
  String get cutButtonLabel => r'KES';

  @override
  String get deleteButtonTooltip => r'Sil';

  @override
  String get dialogLabel => r'İletişim kutusu';

  @override
  String get drawerLabel => r'Gezinme menüsü';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Hesapları gizle';

  @override
  String get licensesPageTitle => r'Lisanslar';

  @override
  String get modalBarrierDismissLabel => r'Kapat';

  @override
  String get nextMonthTooltip => r'Gelecek ay';

  @override
  String get nextPageTooltip => r'Sonraki sayfa';

  @override
  String get okButtonLabel => r'Tamam';

  @override
  String get openAppDrawerTooltip => r'Gezinme menüsünü aç';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow / $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow / $rowCount';

  @override
  String get pasteButtonLabel => r'YAPIŞTIR';

  @override
  String get popupMenuLabel => r'Popup menü';

  @override
  String get postMeridiemAbbreviation => r'ÖS';

  @override
  String get previousMonthTooltip => r'Önceki ay';

  @override
  String get previousPageTooltip => r'Önceki sayfa';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Sayfa başına satır sayısı:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Arama';

  @override
  String get selectAllButtonLabel => r'TÜMÜNÜ SEÇ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 öğe seçildi';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount öğe seçildi';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Hesapları göster';

  @override
  String get showMenuTooltip => r'Menüyü göster';

  @override
  String get signedInLabel => r'Oturum açıldı';

  @override
  String get tabLabelRaw => r'Sekme $tabIndex / $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Saati seçin';

  @override
  String get timePickerMinuteModeAnnouncement => r'Dakikayı seçin';

  @override
  String get viewLicensesButtonLabel => r'LİSANLARI GÖSTER';
}

/// The translations for Ukrainian (`uk`).
class MaterialLocalizationUk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Ukrainian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationUk({
    String localeName = 'uk',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Про додаток $applicationName';

  @override
  String get alertDialogLabel => r'TBD';

  @override
  String get anteMeridiemAbbreviation => r'дп';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'СКАСУВАТИ';

  @override
  String get closeButtonLabel => r'ЗАКРИТИ';

  @override
  String get closeButtonTooltip => r'Закрити';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'ПРОДОВЖИТИ';

  @override
  String get copyButtonLabel => r'КОПІЮВАТИ';

  @override
  String get cutButtonLabel => r'ВИРІЗАТИ';

  @override
  String get deleteButtonTooltip => r'Видалити';

  @override
  String get dialogLabel => r'Вікно';

  @override
  String get drawerLabel => r'Меню навігації';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Сховати облікові записи';

  @override
  String get licensesPageTitle => r'Ліцензії';

  @override
  String get modalBarrierDismissLabel => r'Усунути';

  @override
  String get nextMonthTooltip => r'Наступний місяць';

  @override
  String get nextPageTooltip => r'Наступна сторінка';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Відкрити меню навігації';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow з $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow з приблизно $rowCount';

  @override
  String get pasteButtonLabel => r'ВСТАВИТИ';

  @override
  String get popupMenuLabel => r'Спливаюче меню';

  @override
  String get postMeridiemAbbreviation => r'пп';

  @override
  String get previousMonthTooltip => r'Попередній місяць';

  @override
  String get previousPageTooltip => r'Попередня сторінка';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Рядків на сторінці:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'TBD';

  @override
  String get selectAllButtonLabel => r'ВИБРАТИ ВСІ';

  @override
  String get selectedRowCountTitleFew => r'Вибрано $selectedRowCount елементи';

  @override
  String get selectedRowCountTitleMany => r'Вибрано $selectedRowCount елементів';

  @override
  String get selectedRowCountTitleOne => r'Вибрано 1 елемент';

  @override
  String get selectedRowCountTitleOther => r'Вибрано $selectedRowCount елемента';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Показати облікові записи';

  @override
  String get showMenuTooltip => r'Показати меню';

  @override
  String get signedInLabel => r'Ви ввійшли';

  @override
  String get tabLabelRaw => r'Вкладка $tabIndex з $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Виберіть години';

  @override
  String get timePickerMinuteModeAnnouncement => r'Виберіть хвилини';

  @override
  String get viewLicensesButtonLabel => r'ПЕРЕГЛЯНУТИ ЛІЦЕНЗІЇ';
}

/// The translations for Urdu (`ur`).
class MaterialLocalizationUr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Urdu.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationUr({
    String localeName = 'ur',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName کے بارے میں';

  @override
  String get alertDialogLabel => r'انتباہ';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'پیچھے';

  @override
  String get cancelButtonLabel => r'منسوخ کریں';

  @override
  String get closeButtonLabel => r'بند کریں';

  @override
  String get closeButtonTooltip => r'بند کریں';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'جاری رکھیں';

  @override
  String get copyButtonLabel => r'کاپی کریں';

  @override
  String get cutButtonLabel => r'کٹ کریں';

  @override
  String get deleteButtonTooltip => r'حذف کریں';

  @override
  String get dialogLabel => r'ڈائلاگ';

  @override
  String get drawerLabel => r'نیویگیشن مینو';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'اکاؤنٹس چھپائیں';

  @override
  String get licensesPageTitle => r'لائسنسز';

  @override
  String get modalBarrierDismissLabel => r'برخاست کریں';

  @override
  String get nextMonthTooltip => r'اگلا مہینہ';

  @override
  String get nextPageTooltip => r'اگلا صفحہ';

  @override
  String get okButtonLabel => r'ٹھیک ہے';

  @override
  String get openAppDrawerTooltip => r'نیویگیشن مینو کھولیں';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow از $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow $rowCount میں سے تقریباً';

  @override
  String get pasteButtonLabel => r'پیسٹ کریں';

  @override
  String get popupMenuLabel => r'پاپ اپ مینو';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'پچھلا مہینہ';

  @override
  String get previousPageTooltip => r'گزشتہ صفحہ';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'قطاریں فی صفحہ:';

  @override
  String get scriptCategory => r'tall';

  @override
  String get searchFieldLabel => r'تلاش کریں';

  @override
  String get selectAllButtonLabel => r'سبھی منتخب کریں';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 آئٹم منتخب کیا گیا';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount آئٹمز منتخب کیے گئے';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'اکاؤنٹس دکھائیں';

  @override
  String get showMenuTooltip => r'مینو دکھائیں';

  @override
  String get signedInLabel => r'سائن ان کردہ ہے';

  @override
  String get tabLabelRaw => r'$tabCount میں سے $tabIndex ٹیب';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'گھنٹے منتخب کریں';

  @override
  String get timePickerMinuteModeAnnouncement => r'منٹ منتخب کریں';

  @override
  String get viewLicensesButtonLabel => r'لائسنسز دیکھیں';
}

/// The translations for Vietnamese (`vi`).
class MaterialLocalizationVi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Vietnamese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationVi({
    String localeName = 'vi',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Giới thiệu về $applicationName';

  @override
  String get alertDialogLabel => r'Hộp thoại';

  @override
  String get anteMeridiemAbbreviation => r'SÁNG';

  @override
  String get backButtonTooltip => r'Quay lại';

  @override
  String get cancelButtonLabel => r'HỦY';

  @override
  String get closeButtonLabel => r'ĐÓNG';

  @override
  String get closeButtonTooltip => r'Đóng';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'TIẾP TỤC';

  @override
  String get copyButtonLabel => r'SAO CHÉP';

  @override
  String get cutButtonLabel => r'CẮT';

  @override
  String get deleteButtonTooltip => r'Xóa';

  @override
  String get dialogLabel => r'Hộp thoại';

  @override
  String get drawerLabel => r'Menu di chuyển';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'Ẩn tài khoản';

  @override
  String get licensesPageTitle => r'Giấy phép';

  @override
  String get modalBarrierDismissLabel => r'Bỏ qua';

  @override
  String get nextMonthTooltip => r'Tháng sau';

  @override
  String get nextPageTooltip => r'Trang tiếp theo';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Mở menu di chuyển';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow trong tổng số $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow trong tổng số khoảng $rowCount';

  @override
  String get pasteButtonLabel => r'DÁN';

  @override
  String get popupMenuLabel => r'Menu bật lên';

  @override
  String get postMeridiemAbbreviation => r'CHIỀU';

  @override
  String get previousMonthTooltip => r'Tháng trước';

  @override
  String get previousPageTooltip => r'Trang trước';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'Số hàng mỗi trang:';

  @override
  String get scriptCategory => r'English-like';

  @override
  String get searchFieldLabel => r'Tìm kiếm';

  @override
  String get selectAllButtonLabel => r'CHỌN TẤT CẢ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Đã chọn 1 mục';

  @override
  String get selectedRowCountTitleOther => r'Đã chọn $selectedRowCount mục';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Hiển thị tài khoản';

  @override
  String get showMenuTooltip => r'Hiển thị menu';

  @override
  String get signedInLabel => r'Đã đăng nhập';

  @override
  String get tabLabelRaw => r'Tab $tabIndex trong tổng số $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Chọn giờ';

  @override
  String get timePickerMinuteModeAnnouncement => r'Chọn phút';

  @override
  String get viewLicensesButtonLabel => r'XEM GIẤY PHÉP';
}

/// The translations for Chinese (`zh`).
class MaterialLocalizationZh extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Chinese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZh({
    String localeName = 'zh',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'关于$applicationName';

  @override
  String get alertDialogLabel => r'警报';

  @override
  String get anteMeridiemAbbreviation => r'上午';

  @override
  String get backButtonTooltip => r'返回';

  @override
  String get cancelButtonLabel => r'取消';

  @override
  String get closeButtonLabel => r'关闭';

  @override
  String get closeButtonTooltip => r'关闭';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'继续';

  @override
  String get copyButtonLabel => r'复制';

  @override
  String get cutButtonLabel => r'剪切';

  @override
  String get deleteButtonTooltip => r'删除';

  @override
  String get dialogLabel => r'对话框';

  @override
  String get drawerLabel => r'导航菜单';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'隐藏帐号';

  @override
  String get licensesPageTitle => r'许可';

  @override
  String get modalBarrierDismissLabel => r'关闭';

  @override
  String get nextMonthTooltip => r'下个月';

  @override
  String get nextPageTooltip => r'下一页';

  @override
  String get okButtonLabel => r'确定';

  @override
  String get openAppDrawerTooltip => r'打开导航菜单';

  @override
  String get pageRowsInfoTitleRaw => r'第 $firstRow-$lastRow 行（共 $rowCount 行）';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'第 $firstRow-$lastRow 行（共约 $rowCount 行）';

  @override
  String get pasteButtonLabel => r'粘贴';

  @override
  String get popupMenuLabel => r'弹出菜单';

  @override
  String get postMeridiemAbbreviation => r'下午';

  @override
  String get previousMonthTooltip => r'上个月';

  @override
  String get previousPageTooltip => r'上一页';

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'每页行数：';

  @override
  String get scriptCategory => r'dense';

  @override
  String get searchFieldLabel => r'搜索';

  @override
  String get selectAllButtonLabel => r'全选';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'已选择 1 项内容';

  @override
  String get selectedRowCountTitleOther => r'已选择 $selectedRowCount 项内容';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'显示帐号';

  @override
  String get showMenuTooltip => r'显示菜单';

  @override
  String get signedInLabel => r'已登录';

  @override
  String get tabLabelRaw => r'第 $tabIndex 个标签，共 $tabCount 个';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'选择小时';

  @override
  String get timePickerMinuteModeAnnouncement => r'选择分钟';

  @override
  String get viewLicensesButtonLabel => r'查看许可';
}

/// The translations for Chinese, as used in Hong Kong (`zh_HK`).
class MaterialLocalizationZhHk extends MaterialLocalizationZh {
  /// Create an instance of the translation bundle for Chinese, as used in Hong Kong.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhHk({
    String localeName = 'zh_HK',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get tabLabelRaw => r'第 $tabIndex 個分頁 (共 $tabCount 個)';

  @override
  String get showAccountsLabel => r'顯示帳戶';

  @override
  String get modalBarrierDismissLabel => r'關閉';

  @override
  String get hideAccountsLabel => r'隱藏帳戶';

  @override
  String get signedInLabel => r'已登入帳戶';

  @override
  String get openAppDrawerTooltip => r'開啟導覽選單';

  @override
  String get closeButtonTooltip => r'關閉';

  @override
  String get deleteButtonTooltip => r'刪除';

  @override
  String get nextMonthTooltip => r'下個月';

  @override
  String get previousMonthTooltip => r'上個月';

  @override
  String get nextPageTooltip => r'下一頁';

  @override
  String get previousPageTooltip => r'上一頁';

  @override
  String get showMenuTooltip => r'顯示選單';

  @override
  String get aboutListTileTitleRaw => r'關於「$applicationName」';

  @override
  String get licensesPageTitle => r'授權';

  @override
  String get pageRowsInfoTitleRaw => r'第 $firstRow - $lastRow 列 (總共 $rowCount 列)';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'第 $firstRow - $lastRow 列 (總共約 $rowCount 列)';

  @override
  String get rowsPerPageTitle => r'每頁列數：';

  @override
  String get selectedRowCountTitleOne => r'已選取 1 個項目';

  @override
  String get selectedRowCountTitleOther => r'已選取 $selectedRowCount 個項目';

  @override
  String get closeButtonLabel => r'關閉';

  @override
  String get continueButtonLabel => r'繼續';

  @override
  String get copyButtonLabel => r'複製';

  @override
  String get cutButtonLabel => r'剪下';

  @override
  String get okButtonLabel => r'確定';

  @override
  String get pasteButtonLabel => r'貼上';

  @override
  String get selectAllButtonLabel => r'全選';

  @override
  String get viewLicensesButtonLabel => r'查看授權';

  @override
  String get timePickerHourModeAnnouncement => r'選取小時數';

  @override
  String get timePickerMinuteModeAnnouncement => r'選取分鐘數';

  @override
  String get drawerLabel => r'導覽選單';

  @override
  String get popupMenuLabel => r'彈出式選單';

  @override
  String get dialogLabel => r'對話方塊';
}

/// The translations for Chinese, as used in Taiwan (`zh_TW`).
class MaterialLocalizationZhTw extends MaterialLocalizationZh {
  /// Create an instance of the translation bundle for Chinese, as used in Taiwan.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhTw({
    String localeName = 'zh_TW',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get tabLabelRaw => r'第 $tabIndex 個分頁 (共 $tabCount 個)';

  @override
  String get showAccountsLabel => r'顯示帳戶';

  @override
  String get modalBarrierDismissLabel => r'關閉';

  @override
  String get hideAccountsLabel => r'隱藏帳戶';

  @override
  String get signedInLabel => r'已登入帳戶';

  @override
  String get openAppDrawerTooltip => r'開啟導覽選單';

  @override
  String get closeButtonTooltip => r'關閉';

  @override
  String get deleteButtonTooltip => r'刪除';

  @override
  String get nextMonthTooltip => r'下個月';

  @override
  String get previousMonthTooltip => r'上個月';

  @override
  String get nextPageTooltip => r'下一頁';

  @override
  String get previousPageTooltip => r'上一頁';

  @override
  String get showMenuTooltip => r'顯示選單';

  @override
  String get aboutListTileTitleRaw => r'關於「$applicationName」';

  @override
  String get licensesPageTitle => r'授權';

  @override
  String get pageRowsInfoTitleRaw => r'第 $firstRow - $lastRow 列 (總共 $rowCount 列)';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'第 $firstRow - $lastRow 列 (總共約 $rowCount 列)';

  @override
  String get rowsPerPageTitle => r'每頁列數：';

  @override
  String get selectedRowCountTitleOne => r'已選取 1 個項目';

  @override
  String get selectedRowCountTitleOther => r'已選取 $selectedRowCount 個項目';

  @override
  String get closeButtonLabel => r'關閉';

  @override
  String get continueButtonLabel => r'繼續';

  @override
  String get copyButtonLabel => r'複製';

  @override
  String get cutButtonLabel => r'剪下';

  @override
  String get okButtonLabel => r'確定';

  @override
  String get pasteButtonLabel => r'貼上';

  @override
  String get selectAllButtonLabel => r'全選';

  @override
  String get viewLicensesButtonLabel => r'查看授權';

  @override
  String get timePickerHourModeAnnouncement => r'選取小時數';

  @override
  String get timePickerMinuteModeAnnouncement => r'選取分鐘數';

  @override
  String get drawerLabel => r'導覽選單';

  @override
  String get popupMenuLabel => r'彈出式選單';

  @override
  String get dialogLabel => r'對話方塊';
}

/// The set of supported languages, as language code strings.
///
/// The [GlobalMaterialLocalizations.delegate] can generate localizations for
/// any [Locale] with a language code from this set, regardless of the region.
/// Some regions have specific support (e.g. `de` covers all forms of German,
/// but there is support for `de-CH` specifically to override some of the
/// translations for Switzerland).
///
/// See also:
///
///  * [getTranslation], whose documentation describes these values.
final Set<String> kSupportedLanguages = new HashSet<String>.from(const <String>[
  'ar', // Arabic
  'bg', // Bulgarian
  'bs', // Bosnian
  'ca', // Catalan Valencian
  'cs', // Czech
  'da', // Danish
  'de', // German
  'el', // Modern Greek
  'en', // English
  'es', // Spanish Castilian
  'et', // Estonian
  'fa', // Persian
  'fi', // Finnish
  'fil', // Filipino Pilipino
  'fr', // French
  'gsw', // Swiss German Alemannic Alsatian
  'he', // Hebrew
  'hi', // Hindi
  'hr', // Croatian
  'hu', // Hungarian
  'id', // Indonesian
  'it', // Italian
  'ja', // Japanese
  'ko', // Korean
  'lt', // Lithuanian
  'lv', // Latvian
  'ms', // Malay
  'nb', // Norwegian Bokmål
  'nl', // Dutch Flemish
  'pl', // Polish
  'ps', // Pushto Pashto
  'pt', // Portuguese
  'ro', // Romanian Moldavian Moldovan
  'ru', // Russian
  'sk', // Slovak
  'sl', // Slovenian
  'sr', // Serbian
  'sv', // Swedish
  'th', // Thai
  'tl', // Tagalog
  'tr', // Turkish
  'uk', // Ukrainian
  'ur', // Urdu
  'vi', // Vietnamese
  'zh', // Chinese
]);

/// Creates a [GlobalMaterialLocalizations] instance for the given `locale`.
///
/// All of the function's arguments except `locale` will be passed to the [new
/// GlobalMaterialLocalizations] constructor. (The `localeName` argument of that
/// constructor is specified by the actual subclass constructor by this
/// function.)
///
/// The following locales are supported by this package:
///
/// {@template flutter.localizations.languages}
///  * `ar` - Arabic
///  * `bg` - Bulgarian
///  * `bs` - Bosnian
///  * `ca` - Catalan Valencian
///  * `cs` - Czech
///  * `da` - Danish
///  * `de` - German (plus one variant)
///  * `el` - Modern Greek
///  * `en` - English (plus 7 variants)
///  * `es` - Spanish Castilian (plus 20 variants)
///  * `et` - Estonian
///  * `fa` - Persian
///  * `fi` - Finnish
///  * `fil` - Filipino Pilipino
///  * `fr` - French (plus one variant)
///  * `gsw` - Swiss German Alemannic Alsatian
///  * `he` - Hebrew
///  * `hi` - Hindi
///  * `hr` - Croatian
///  * `hu` - Hungarian
///  * `id` - Indonesian
///  * `it` - Italian
///  * `ja` - Japanese
///  * `ko` - Korean
///  * `lt` - Lithuanian
///  * `lv` - Latvian
///  * `ms` - Malay
///  * `nb` - Norwegian Bokmål
///  * `nl` - Dutch Flemish
///  * `pl` - Polish
///  * `ps` - Pushto Pashto
///  * `pt` - Portuguese (plus one variant)
///  * `ro` - Romanian Moldavian Moldovan
///  * `ru` - Russian
///  * `sk` - Slovak
///  * `sl` - Slovenian
///  * `sr` - Serbian (plus one variant)
///  * `sv` - Swedish
///  * `th` - Thai
///  * `tl` - Tagalog
///  * `tr` - Turkish
///  * `uk` - Ukrainian
///  * `ur` - Urdu
///  * `vi` - Vietnamese
///  * `zh` - Chinese (plus 2 variants)
/// {@endtemplate}
///
/// Generally speaking, this method is only intended to be used by
/// [GlobalMaterialLocalizations.delegate].
GlobalMaterialLocalizations getTranslation(
  Locale locale,
  intl.DateFormat fullYearFormat,
  intl.DateFormat mediumDateFormat,
  intl.DateFormat longDateFormat,
  intl.DateFormat yearMonthFormat,
  intl.NumberFormat decimalFormat,
  intl.NumberFormat twoDigitZeroPaddedFormat,
) {
  switch (locale.languageCode) {
    case 'ar':
      return new MaterialLocalizationAr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'bg':
      return new MaterialLocalizationBg(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'bs':
      return new MaterialLocalizationBs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ca':
      return new MaterialLocalizationCa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'cs':
      return new MaterialLocalizationCs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'da':
      return new MaterialLocalizationDa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'de': {
      switch (locale.countryCode) {
        case 'CH':
          return new MaterialLocalizationDeCh(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return new MaterialLocalizationDe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'el':
      return new MaterialLocalizationEl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'en': {
      switch (locale.countryCode) {
        case 'AU':
          return new MaterialLocalizationEnAu(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CA':
          return new MaterialLocalizationEnCa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'GB':
          return new MaterialLocalizationEnGb(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'IE':
          return new MaterialLocalizationEnIe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'IN':
          return new MaterialLocalizationEnIn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'SG':
          return new MaterialLocalizationEnSg(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'ZA':
          return new MaterialLocalizationEnZa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return new MaterialLocalizationEn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'es': {
      switch (locale.countryCode) {
        case '419':
          return new MaterialLocalizationEs419(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'AR':
          return new MaterialLocalizationEsAr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'BO':
          return new MaterialLocalizationEsBo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CL':
          return new MaterialLocalizationEsCl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CO':
          return new MaterialLocalizationEsCo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CR':
          return new MaterialLocalizationEsCr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'DO':
          return new MaterialLocalizationEsDo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'EC':
          return new MaterialLocalizationEsEc(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'GT':
          return new MaterialLocalizationEsGt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'HN':
          return new MaterialLocalizationEsHn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'MX':
          return new MaterialLocalizationEsMx(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'NI':
          return new MaterialLocalizationEsNi(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PA':
          return new MaterialLocalizationEsPa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PE':
          return new MaterialLocalizationEsPe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PR':
          return new MaterialLocalizationEsPr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PY':
          return new MaterialLocalizationEsPy(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'SV':
          return new MaterialLocalizationEsSv(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'US':
          return new MaterialLocalizationEsUs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'UY':
          return new MaterialLocalizationEsUy(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'VE':
          return new MaterialLocalizationEsVe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return new MaterialLocalizationEs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'et':
      return new MaterialLocalizationEt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fa':
      return new MaterialLocalizationFa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fi':
      return new MaterialLocalizationFi(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fil':
      return new MaterialLocalizationFil(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fr': {
      switch (locale.countryCode) {
        case 'CA':
          return new MaterialLocalizationFrCa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return new MaterialLocalizationFr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'gsw':
      return new MaterialLocalizationGsw(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'he':
      return new MaterialLocalizationHe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hi':
      return new MaterialLocalizationHi(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hr':
      return new MaterialLocalizationHr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hu':
      return new MaterialLocalizationHu(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'id':
      return new MaterialLocalizationId(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'it':
      return new MaterialLocalizationIt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ja':
      return new MaterialLocalizationJa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ko':
      return new MaterialLocalizationKo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'lt':
      return new MaterialLocalizationLt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'lv':
      return new MaterialLocalizationLv(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ms':
      return new MaterialLocalizationMs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'nb':
      return new MaterialLocalizationNb(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'nl':
      return new MaterialLocalizationNl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'pl':
      return new MaterialLocalizationPl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ps':
      return new MaterialLocalizationPs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'pt': {
      switch (locale.countryCode) {
        case 'PT':
          return new MaterialLocalizationPtPt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return new MaterialLocalizationPt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'ro':
      return new MaterialLocalizationRo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ru':
      return new MaterialLocalizationRu(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sk':
      return new MaterialLocalizationSk(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sl':
      return new MaterialLocalizationSl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sr': {
      switch (locale.countryCode) {
        case 'Latn':
          return new MaterialLocalizationSrLatn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return new MaterialLocalizationSr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'sv':
      return new MaterialLocalizationSv(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'th':
      return new MaterialLocalizationTh(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'tl':
      return new MaterialLocalizationTl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'tr':
      return new MaterialLocalizationTr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'uk':
      return new MaterialLocalizationUk(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ur':
      return new MaterialLocalizationUr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'vi':
      return new MaterialLocalizationVi(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'zh': {
      switch (locale.countryCode) {
        case 'HK':
          return new MaterialLocalizationZhHk(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'TW':
          return new MaterialLocalizationZhTw(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return new MaterialLocalizationZh(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
  }
  assert(false, 'getTranslation() called for unsupported locale "$locale"');
  return null;
}
