// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated. Please do not edit it manually.
// To regenerate run (omit -w to print to console instead of the file):
// dart --enable-asserts dev/tools/gen_date_localizations.dart --overwrite

// ignore_for_file: public_member_api_docs

const Map<String, dynamic> dateSymbols = const <String, dynamic>{
  'ar': const <String, dynamic>{
    'NAME': r'''ar''',
    'ERAS': const <dynamic>[r'''ق.م''', r'''م'''],
    'ERANAMES': const <dynamic>[r'''قبل الميلاد''', r'''ميلادي'''],
    'NARROWMONTHS': const <dynamic>[
      r'''ي''',
      r'''ف''',
      r'''م''',
      r'''أ''',
      r'''و''',
      r'''ن''',
      r'''ل''',
      r'''غ''',
      r'''س''',
      r'''ك''',
      r'''ب''',
      r'''د'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''ي''',
      r'''ف''',
      r'''م''',
      r'''أ''',
      r'''و''',
      r'''ن''',
      r'''ل''',
      r'''غ''',
      r'''س''',
      r'''ك''',
      r'''ب''',
      r'''د'''
    ],
    'MONTHS': const <dynamic>[
      r'''يناير''',
      r'''فبراير''',
      r'''مارس''',
      r'''أبريل''',
      r'''مايو''',
      r'''يونيو''',
      r'''يوليو''',
      r'''أغسطس''',
      r'''سبتمبر''',
      r'''أكتوبر''',
      r'''نوفمبر''',
      r'''ديسمبر'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''يناير''',
      r'''فبراير''',
      r'''مارس''',
      r'''أبريل''',
      r'''مايو''',
      r'''يونيو''',
      r'''يوليو''',
      r'''أغسطس''',
      r'''سبتمبر''',
      r'''أكتوبر''',
      r'''نوفمبر''',
      r'''ديسمبر'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''يناير''',
      r'''فبراير''',
      r'''مارس''',
      r'''أبريل''',
      r'''مايو''',
      r'''يونيو''',
      r'''يوليو''',
      r'''أغسطس''',
      r'''سبتمبر''',
      r'''أكتوبر''',
      r'''نوفمبر''',
      r'''ديسمبر'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''يناير''',
      r'''فبراير''',
      r'''مارس''',
      r'''أبريل''',
      r'''مايو''',
      r'''يونيو''',
      r'''يوليو''',
      r'''أغسطس''',
      r'''سبتمبر''',
      r'''أكتوبر''',
      r'''نوفمبر''',
      r'''ديسمبر'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''الأحد''',
      r'''الاثنين''',
      r'''الثلاثاء''',
      r'''الأربعاء''',
      r'''الخميس''',
      r'''الجمعة''',
      r'''السبت'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''الأحد''',
      r'''الاثنين''',
      r'''الثلاثاء''',
      r'''الأربعاء''',
      r'''الخميس''',
      r'''الجمعة''',
      r'''السبت'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''الأحد''',
      r'''الاثنين''',
      r'''الثلاثاء''',
      r'''الأربعاء''',
      r'''الخميس''',
      r'''الجمعة''',
      r'''السبت'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''الأحد''',
      r'''الاثنين''',
      r'''الثلاثاء''',
      r'''الأربعاء''',
      r'''الخميس''',
      r'''الجمعة''',
      r'''السبت'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''ح''',
      r'''ن''',
      r'''ث''',
      r'''ر''',
      r'''خ''',
      r'''ج''',
      r'''س'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''ح''',
      r'''ن''',
      r'''ث''',
      r'''ر''',
      r'''خ''',
      r'''ج''',
      r'''س'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''الربع الأول''',
      r'''الربع الثاني''',
      r'''الربع الثالث''',
      r'''الربع الرابع'''
    ],
    'QUARTERS': const <dynamic>[
      r'''الربع الأول''',
      r'''الربع الثاني''',
      r'''الربع الثالث''',
      r'''الربع الرابع'''
    ],
    'AMPMS': const <dynamic>[r'''ص''', r'''م'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE، d MMMM، y''',
      r'''d MMMM، y''',
      r'''dd‏/MM‏/y''',
      r'''d‏/M‏/y'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 5,
    'WEEKENDRANGE': const <dynamic>[4, 5],
    'FIRSTWEEKCUTOFFDAY': 4,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
    'ZERODIGIT': r'''٠''',
  },
  'de': const <String, dynamic>{
    'NAME': r'''de''',
    'ERAS': const <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'ERANAMES': const <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'NARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''August''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Dezember'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''August''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Dezember'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''Jan.''',
      r'''Feb.''',
      r'''März''',
      r'''Apr.''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''Aug.''',
      r'''Sep.''',
      r'''Okt.''',
      r'''Nov.''',
      r'''Dez.'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mär''',
      r'''Apr''',
      r'''Mai''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Dez'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''Sonntag''',
      r'''Montag''',
      r'''Dienstag''',
      r'''Mittwoch''',
      r'''Donnerstag''',
      r'''Freitag''',
      r'''Samstag'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''Sonntag''',
      r'''Montag''',
      r'''Dienstag''',
      r'''Mittwoch''',
      r'''Donnerstag''',
      r'''Freitag''',
      r'''Samstag'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''So.''',
      r'''Mo.''',
      r'''Di.''',
      r'''Mi.''',
      r'''Do.''',
      r'''Fr.''',
      r'''Sa.'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''So''',
      r'''Mo''',
      r'''Di''',
      r'''Mi''',
      r'''Do''',
      r'''Fr''',
      r'''Sa'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''Q1''',
      r'''Q2''',
      r'''Q3''',
      r'''Q4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1. Quartal''',
      r'''2. Quartal''',
      r'''3. Quartal''',
      r'''4. Quartal'''
    ],
    'AMPMS': const <dynamic>[r'''vorm.''', r'''nachm.'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE, d. MMMM y''',
      r'''d. MMMM y''',
      r'''dd.MM.y''',
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': const <dynamic>[
      r"""{1} 'um' {0}""",
      r"""{1} 'um' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'en': const <String, dynamic>{
    'NAME': r'''en''',
    'ERAS': const <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': const <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''Q1''',
      r'''Q2''',
      r'''Q3''',
      r'''Q4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1st quarter''',
      r'''2nd quarter''',
      r'''3rd quarter''',
      r'''4th quarter'''
    ],
    'AMPMS': const <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE, MMMM d, y''',
      r'''MMMM d, y''',
      r'''MMM d, y''',
      r'''M/d/yy'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': const <dynamic>[
      r"""{1} 'at' {0}""",
      r"""{1} 'at' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'es': const <String, dynamic>{
    'NAME': r'''es''',
    'ERAS': const <dynamic>[r'''a. C.''', r'''d. C.'''],
    'ERANAMES': const <dynamic>[
      r'''antes de Cristo''',
      r'''después de Cristo'''
    ],
    'NARROWMONTHS': const <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''ene.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''may.''',
      r'''jun.''',
      r'''jul.''',
      r'''ago.''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''dic.'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''ene.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''may.''',
      r'''jun.''',
      r'''jul.''',
      r'''ago.''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''dic.'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''X''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''X''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''T1''',
      r'''T2''',
      r'''T3''',
      r'''T4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1.er trimestre''',
      r'''2.º trimestre''',
      r'''3.er trimestre''',
      r'''4.º trimestre'''
    ],
    'AMPMS': const <dynamic>[r'''a. m.''', r'''p. m.'''],
    'DATEFORMATS': const <dynamic>[
      r"""EEEE, d 'de' MMMM 'de' y""",
      r"""d 'de' MMMM 'de' y""",
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''H:mm:ss (zzzz)''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'fa': const <String, dynamic>{
    'NAME': r'''fa''',
    'ERAS': const <dynamic>[r'''ق.م.''', r'''م.'''],
    'ERANAMES': const <dynamic>[r'''قبل از میلاد''', r'''میلادی'''],
    'NARROWMONTHS': const <dynamic>[
      r'''ژ''',
      r'''ف''',
      r'''م''',
      r'''آ''',
      r'''م''',
      r'''ژ''',
      r'''ژ''',
      r'''ا''',
      r'''س''',
      r'''ا''',
      r'''ن''',
      r'''د'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''ژ''',
      r'''ف''',
      r'''م''',
      r'''آ''',
      r'''م''',
      r'''ژ''',
      r'''ژ''',
      r'''ا''',
      r'''س''',
      r'''ا''',
      r'''ن''',
      r'''د'''
    ],
    'MONTHS': const <dynamic>[
      r'''ژانویهٔ''',
      r'''فوریهٔ''',
      r'''مارس''',
      r'''آوریل''',
      r'''مهٔ''',
      r'''ژوئن''',
      r'''ژوئیهٔ''',
      r'''اوت''',
      r'''سپتامبر''',
      r'''اکتبر''',
      r'''نوامبر''',
      r'''دسامبر'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''ژانویه''',
      r'''فوریه''',
      r'''مارس''',
      r'''آوریل''',
      r'''مه''',
      r'''ژوئن''',
      r'''ژوئیه''',
      r'''اوت''',
      r'''سپتامبر''',
      r'''اکتبر''',
      r'''نوامبر''',
      r'''دسامبر'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''ژانویهٔ''',
      r'''فوریهٔ''',
      r'''مارس''',
      r'''آوریل''',
      r'''مهٔ''',
      r'''ژوئن''',
      r'''ژوئیهٔ''',
      r'''اوت''',
      r'''سپتامبر''',
      r'''اکتبر''',
      r'''نوامبر''',
      r'''دسامبر'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''ژانویه''',
      r'''فوریه''',
      r'''مارس''',
      r'''آوریل''',
      r'''مه''',
      r'''ژوئن''',
      r'''ژوئیه''',
      r'''اوت''',
      r'''سپتامبر''',
      r'''اکتبر''',
      r'''نوامبر''',
      r'''دسامبر'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''ی''',
      r'''د''',
      r'''س''',
      r'''چ''',
      r'''پ''',
      r'''ج''',
      r'''ش'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''ی''',
      r'''د''',
      r'''س''',
      r'''چ''',
      r'''پ''',
      r'''ج''',
      r'''ش'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''س‌م۱''',
      r'''س‌م۲''',
      r'''س‌م۳''',
      r'''س‌م۴'''
    ],
    'QUARTERS': const <dynamic>[
      r'''سه‌ماههٔ اول''',
      r'''سه‌ماههٔ دوم''',
      r'''سه‌ماههٔ سوم''',
      r'''سه‌ماههٔ چهارم'''
    ],
    'AMPMS': const <dynamic>[r'''قبل‌ازظهر''', r'''بعدازظهر'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''y/M/d'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''H:mm:ss (zzzz)''',
      r'''H:mm:ss (z)''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 5,
    'WEEKENDRANGE': const <dynamic>[4, 4],
    'FIRSTWEEKCUTOFFDAY': 4,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1}، ساعت {0}''',
      r'''{1}، ساعت {0}''',
      r'''{1}،‏ {0}''',
      r'''{1}،‏ {0}'''
    ],
    'ZERODIGIT': r'''۰''',
  },
  'fr': const <String, dynamic>{
    'NAME': r'''fr''',
    'ERAS': const <dynamic>[r'''av. J.-C.''', r'''ap. J.-C.'''],
    'ERANAMES': const <dynamic>[
      r'''avant Jésus-Christ''',
      r'''après Jésus-Christ'''
    ],
    'NARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''janvier''',
      r'''février''',
      r'''mars''',
      r'''avril''',
      r'''mai''',
      r'''juin''',
      r'''juillet''',
      r'''août''',
      r'''septembre''',
      r'''octobre''',
      r'''novembre''',
      r'''décembre'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''janvier''',
      r'''février''',
      r'''mars''',
      r'''avril''',
      r'''mai''',
      r'''juin''',
      r'''juillet''',
      r'''août''',
      r'''septembre''',
      r'''octobre''',
      r'''novembre''',
      r'''décembre'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''janv.''',
      r'''févr.''',
      r'''mars''',
      r'''avr.''',
      r'''mai''',
      r'''juin''',
      r'''juil.''',
      r'''août''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''déc.'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''janv.''',
      r'''févr.''',
      r'''mars''',
      r'''avr.''',
      r'''mai''',
      r'''juin''',
      r'''juil.''',
      r'''août''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''déc.'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''dimanche''',
      r'''lundi''',
      r'''mardi''',
      r'''mercredi''',
      r'''jeudi''',
      r'''vendredi''',
      r'''samedi'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''dimanche''',
      r'''lundi''',
      r'''mardi''',
      r'''mercredi''',
      r'''jeudi''',
      r'''vendredi''',
      r'''samedi'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''dim.''',
      r'''lun.''',
      r'''mar.''',
      r'''mer.''',
      r'''jeu.''',
      r'''ven.''',
      r'''sam.'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''dim.''',
      r'''lun.''',
      r'''mar.''',
      r'''mer.''',
      r'''jeu.''',
      r'''ven.''',
      r'''sam.'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''T1''',
      r'''T2''',
      r'''T3''',
      r'''T4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1er trimestre''',
      r'''2e trimestre''',
      r'''3e trimestre''',
      r'''4e trimestre'''
    ],
    'AMPMS': const <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd/MM/y'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': const <dynamic>[
      r"""{1} 'à' {0}""",
      r"""{1} 'à' {0}""",
      r"""{1} 'à' {0}""",
      r'''{1} {0}'''
    ],
  },
  'gsw': const <String, dynamic>{
    'NAME': r'''gsw''',
    'ERAS': const <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'ERANAMES': const <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'NARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''Auguscht''',
      r'''Septämber''',
      r'''Oktoober''',
      r'''Novämber''',
      r'''Dezämber'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''Auguscht''',
      r'''Septämber''',
      r'''Oktoober''',
      r'''Novämber''',
      r'''Dezämber'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mär''',
      r'''Apr''',
      r'''Mai''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Dez'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mär''',
      r'''Apr''',
      r'''Mai''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Dez'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''Sunntig''',
      r'''Määntig''',
      r'''Ziischtig''',
      r'''Mittwuch''',
      r'''Dunschtig''',
      r'''Friitig''',
      r'''Samschtig'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''Sunntig''',
      r'''Määntig''',
      r'''Ziischtig''',
      r'''Mittwuch''',
      r'''Dunschtig''',
      r'''Friitig''',
      r'''Samschtig'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''Su.''',
      r'''Mä.''',
      r'''Zi.''',
      r'''Mi.''',
      r'''Du.''',
      r'''Fr.''',
      r'''Sa.'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''Su.''',
      r'''Mä.''',
      r'''Zi.''',
      r'''Mi.''',
      r'''Du.''',
      r'''Fr.''',
      r'''Sa.'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''Q1''',
      r'''Q2''',
      r'''Q3''',
      r'''Q4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1. Quartal''',
      r'''2. Quartal''',
      r'''3. Quartal''',
      r'''4. Quartal'''
    ],
    'AMPMS': const <dynamic>[r'''am Vormittag''', r'''am Namittag'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE, d. MMMM y''',
      r'''d. MMMM y''',
      r'''dd.MM.y''',
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'he': const <String, dynamic>{
    'NAME': r'''he''',
    'ERAS': const <dynamic>[r'''לפנה״ס''', r'''לספירה'''],
    'ERANAMES': const <dynamic>[r'''לפני הספירה''', r'''לספירה'''],
    'NARROWMONTHS': const <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': const <dynamic>[
      r'''ינואר''',
      r'''פברואר''',
      r'''מרץ''',
      r'''אפריל''',
      r'''מאי''',
      r'''יוני''',
      r'''יולי''',
      r'''אוגוסט''',
      r'''ספטמבר''',
      r'''אוקטובר''',
      r'''נובמבר''',
      r'''דצמבר'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''ינואר''',
      r'''פברואר''',
      r'''מרץ''',
      r'''אפריל''',
      r'''מאי''',
      r'''יוני''',
      r'''יולי''',
      r'''אוגוסט''',
      r'''ספטמבר''',
      r'''אוקטובר''',
      r'''נובמבר''',
      r'''דצמבר'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''ינו׳''',
      r'''פבר׳''',
      r'''מרץ''',
      r'''אפר׳''',
      r'''מאי''',
      r'''יוני''',
      r'''יולי''',
      r'''אוג׳''',
      r'''ספט׳''',
      r'''אוק׳''',
      r'''נוב׳''',
      r'''דצמ׳'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''ינו׳''',
      r'''פבר׳''',
      r'''מרץ''',
      r'''אפר׳''',
      r'''מאי''',
      r'''יוני''',
      r'''יולי''',
      r'''אוג׳''',
      r'''ספט׳''',
      r'''אוק׳''',
      r'''נוב׳''',
      r'''דצמ׳'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''יום ראשון''',
      r'''יום שני''',
      r'''יום שלישי''',
      r'''יום רביעי''',
      r'''יום חמישי''',
      r'''יום שישי''',
      r'''יום שבת'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''יום ראשון''',
      r'''יום שני''',
      r'''יום שלישי''',
      r'''יום רביעי''',
      r'''יום חמישי''',
      r'''יום שישי''',
      r'''יום שבת'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''יום א׳''',
      r'''יום ב׳''',
      r'''יום ג׳''',
      r'''יום ד׳''',
      r'''יום ה׳''',
      r'''יום ו׳''',
      r'''שבת'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''יום א׳''',
      r'''יום ב׳''',
      r'''יום ג׳''',
      r'''יום ד׳''',
      r'''יום ה׳''',
      r'''יום ו׳''',
      r'''שבת'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''א׳''',
      r'''ב׳''',
      r'''ג׳''',
      r'''ד׳''',
      r'''ה׳''',
      r'''ו׳''',
      r'''ש׳'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''א׳''',
      r'''ב׳''',
      r'''ג׳''',
      r'''ד׳''',
      r'''ה׳''',
      r'''ו׳''',
      r'''ש׳'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''Q1''',
      r'''Q2''',
      r'''Q3''',
      r'''Q4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''רבעון 1''',
      r'''רבעון 2''',
      r'''רבעון 3''',
      r'''רבעון 4'''
    ],
    'AMPMS': const <dynamic>[r'''לפנה״צ''', r'''אחה״צ'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE, d בMMMM y''',
      r'''d בMMMM y''',
      r'''d בMMM y''',
      r'''d.M.y'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''H:mm:ss zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': const <dynamic>[4, 5],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} בשעה {0}''',
      r'''{1} בשעה {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'it': const <String, dynamic>{
    'NAME': r'''it''',
    'ERAS': const <dynamic>[r'''a.C.''', r'''d.C.'''],
    'ERANAMES': const <dynamic>[r'''avanti Cristo''', r'''dopo Cristo'''],
    'NARROWMONTHS': const <dynamic>[
      r'''G''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''G''',
      r'''L''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''G''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''G''',
      r'''L''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''gennaio''',
      r'''febbraio''',
      r'''marzo''',
      r'''aprile''',
      r'''maggio''',
      r'''giugno''',
      r'''luglio''',
      r'''agosto''',
      r'''settembre''',
      r'''ottobre''',
      r'''novembre''',
      r'''dicembre'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''gennaio''',
      r'''febbraio''',
      r'''marzo''',
      r'''aprile''',
      r'''maggio''',
      r'''giugno''',
      r'''luglio''',
      r'''agosto''',
      r'''settembre''',
      r'''ottobre''',
      r'''novembre''',
      r'''dicembre'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''gen''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''mag''',
      r'''giu''',
      r'''lug''',
      r'''ago''',
      r'''set''',
      r'''ott''',
      r'''nov''',
      r'''dic'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''gen''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''mag''',
      r'''giu''',
      r'''lug''',
      r'''ago''',
      r'''set''',
      r'''ott''',
      r'''nov''',
      r'''dic'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''domenica''',
      r'''lunedì''',
      r'''martedì''',
      r'''mercoledì''',
      r'''giovedì''',
      r'''venerdì''',
      r'''sabato'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''domenica''',
      r'''lunedì''',
      r'''martedì''',
      r'''mercoledì''',
      r'''giovedì''',
      r'''venerdì''',
      r'''sabato'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''dom''',
      r'''lun''',
      r'''mar''',
      r'''mer''',
      r'''gio''',
      r'''ven''',
      r'''sab'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''dom''',
      r'''lun''',
      r'''mar''',
      r'''mer''',
      r'''gio''',
      r'''ven''',
      r'''sab'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''G''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''G''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''T1''',
      r'''T2''',
      r'''T3''',
      r'''T4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1º trimestre''',
      r'''2º trimestre''',
      r'''3º trimestre''',
      r'''4º trimestre'''
    ],
    'AMPMS': const <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''dd MMM y''',
      r'''dd/MM/yy'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'ja': const <String, dynamic>{
    'NAME': r'''ja''',
    'ERAS': const <dynamic>[r'''紀元前''', r'''西暦'''],
    'ERANAMES': const <dynamic>[r'''紀元前''', r'''西暦'''],
    'NARROWMONTHS': const <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': const <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''日曜日''',
      r'''月曜日''',
      r'''火曜日''',
      r'''水曜日''',
      r'''木曜日''',
      r'''金曜日''',
      r'''土曜日'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''日曜日''',
      r'''月曜日''',
      r'''火曜日''',
      r'''水曜日''',
      r'''木曜日''',
      r'''金曜日''',
      r'''土曜日'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''日''',
      r'''月''',
      r'''火''',
      r'''水''',
      r'''木''',
      r'''金''',
      r'''土'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''日''',
      r'''月''',
      r'''火''',
      r'''水''',
      r'''木''',
      r'''金''',
      r'''土'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''日''',
      r'''月''',
      r'''火''',
      r'''水''',
      r'''木''',
      r'''金''',
      r'''土'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''日''',
      r'''月''',
      r'''火''',
      r'''水''',
      r'''木''',
      r'''金''',
      r'''土'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''Q1''',
      r'''Q2''',
      r'''Q3''',
      r'''Q4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''第1四半期''',
      r'''第2四半期''',
      r'''第3四半期''',
      r'''第4四半期'''
    ],
    'AMPMS': const <dynamic>[r'''午前''', r'''午後'''],
    'DATEFORMATS': const <dynamic>[
      r'''y年M月d日EEEE''',
      r'''y年M月d日''',
      r'''y/MM/dd''',
      r'''y/MM/dd'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''H時mm分ss秒 zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'ko': const <String, dynamic>{
    'NAME': r'''ko''',
    'ERAS': const <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': const <dynamic>[r'''기원전''', r'''서기'''],
    'NARROWMONTHS': const <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'MONTHS': const <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''일요일''',
      r'''월요일''',
      r'''화요일''',
      r'''수요일''',
      r'''목요일''',
      r'''금요일''',
      r'''토요일'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''일요일''',
      r'''월요일''',
      r'''화요일''',
      r'''수요일''',
      r'''목요일''',
      r'''금요일''',
      r'''토요일'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''일''',
      r'''월''',
      r'''화''',
      r'''수''',
      r'''목''',
      r'''금''',
      r'''토'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''일''',
      r'''월''',
      r'''화''',
      r'''수''',
      r'''목''',
      r'''금''',
      r'''토'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''일''',
      r'''월''',
      r'''화''',
      r'''수''',
      r'''목''',
      r'''금''',
      r'''토'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''일''',
      r'''월''',
      r'''화''',
      r'''수''',
      r'''목''',
      r'''금''',
      r'''토'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''1분기''',
      r'''2분기''',
      r'''3분기''',
      r'''4분기'''
    ],
    'QUARTERS': const <dynamic>[
      r'''제 1/4분기''',
      r'''제 2/4분기''',
      r'''제 3/4분기''',
      r'''제 4/4분기'''
    ],
    'AMPMS': const <dynamic>[r'''오전''', r'''오후'''],
    'DATEFORMATS': const <dynamic>[
      r'''y년 M월 d일 EEEE''',
      r'''y년 M월 d일''',
      r'''y. M. d.''',
      r'''yy. M. d.'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''a h시 m분 s초 zzzz''',
      r'''a h시 m분 s초 z''',
      r'''a h:mm:ss''',
      r'''a h:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'nl': const <String, dynamic>{
    'NAME': r'''nl''',
    'ERAS': const <dynamic>[r'''v.Chr.''', r'''n.Chr.'''],
    'ERANAMES': const <dynamic>[r'''voor Christus''', r'''na Christus'''],
    'NARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''januari''',
      r'''februari''',
      r'''maart''',
      r'''april''',
      r'''mei''',
      r'''juni''',
      r'''juli''',
      r'''augustus''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''januari''',
      r'''februari''',
      r'''maart''',
      r'''april''',
      r'''mei''',
      r'''juni''',
      r'''juli''',
      r'''augustus''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mrt.''',
      r'''apr.''',
      r'''mei''',
      r'''jun.''',
      r'''jul.''',
      r'''aug.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mrt.''',
      r'''apr.''',
      r'''mei''',
      r'''jun.''',
      r'''jul.''',
      r'''aug.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''zondag''',
      r'''maandag''',
      r'''dinsdag''',
      r'''woensdag''',
      r'''donderdag''',
      r'''vrijdag''',
      r'''zaterdag'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''zondag''',
      r'''maandag''',
      r'''dinsdag''',
      r'''woensdag''',
      r'''donderdag''',
      r'''vrijdag''',
      r'''zaterdag'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''zo''',
      r'''ma''',
      r'''di''',
      r'''wo''',
      r'''do''',
      r'''vr''',
      r'''za'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''zo''',
      r'''ma''',
      r'''di''',
      r'''wo''',
      r'''do''',
      r'''vr''',
      r'''za'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''Z''',
      r'''M''',
      r'''D''',
      r'''W''',
      r'''D''',
      r'''V''',
      r'''Z'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''Z''',
      r'''M''',
      r'''D''',
      r'''W''',
      r'''D''',
      r'''V''',
      r'''Z'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''K1''',
      r'''K2''',
      r'''K3''',
      r'''K4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1e kwartaal''',
      r'''2e kwartaal''',
      r'''3e kwartaal''',
      r'''4e kwartaal'''
    ],
    'AMPMS': const <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd-MM-yy'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': const <dynamic>[
      r"""{1} 'om' {0}""",
      r"""{1} 'om' {0}""",
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'pl': const <String, dynamic>{
    'NAME': r'''pl''',
    'ERAS': const <dynamic>[r'''p.n.e.''', r'''n.e.'''],
    'ERANAMES': const <dynamic>[r'''przed naszą erą''', r'''naszej ery'''],
    'NARROWMONTHS': const <dynamic>[
      r'''s''',
      r'''l''',
      r'''m''',
      r'''k''',
      r'''m''',
      r'''c''',
      r'''l''',
      r'''s''',
      r'''w''',
      r'''p''',
      r'''l''',
      r'''g'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''S''',
      r'''L''',
      r'''M''',
      r'''K''',
      r'''M''',
      r'''C''',
      r'''L''',
      r'''S''',
      r'''W''',
      r'''P''',
      r'''L''',
      r'''G'''
    ],
    'MONTHS': const <dynamic>[
      r'''stycznia''',
      r'''lutego''',
      r'''marca''',
      r'''kwietnia''',
      r'''maja''',
      r'''czerwca''',
      r'''lipca''',
      r'''sierpnia''',
      r'''września''',
      r'''października''',
      r'''listopada''',
      r'''grudnia'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''styczeń''',
      r'''luty''',
      r'''marzec''',
      r'''kwiecień''',
      r'''maj''',
      r'''czerwiec''',
      r'''lipiec''',
      r'''sierpień''',
      r'''wrzesień''',
      r'''październik''',
      r'''listopad''',
      r'''grudzień'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''sty''',
      r'''lut''',
      r'''mar''',
      r'''kwi''',
      r'''maj''',
      r'''cze''',
      r'''lip''',
      r'''sie''',
      r'''wrz''',
      r'''paź''',
      r'''lis''',
      r'''gru'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''sty''',
      r'''lut''',
      r'''mar''',
      r'''kwi''',
      r'''maj''',
      r'''cze''',
      r'''lip''',
      r'''sie''',
      r'''wrz''',
      r'''paź''',
      r'''lis''',
      r'''gru'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''niedziela''',
      r'''poniedziałek''',
      r'''wtorek''',
      r'''środa''',
      r'''czwartek''',
      r'''piątek''',
      r'''sobota'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''niedziela''',
      r'''poniedziałek''',
      r'''wtorek''',
      r'''środa''',
      r'''czwartek''',
      r'''piątek''',
      r'''sobota'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''niedz.''',
      r'''pon.''',
      r'''wt.''',
      r'''śr.''',
      r'''czw.''',
      r'''pt.''',
      r'''sob.'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''niedz.''',
      r'''pon.''',
      r'''wt.''',
      r'''śr.''',
      r'''czw.''',
      r'''pt.''',
      r'''sob.'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''n''',
      r'''p''',
      r'''w''',
      r'''ś''',
      r'''c''',
      r'''p''',
      r'''s'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''N''',
      r'''P''',
      r'''W''',
      r'''Ś''',
      r'''C''',
      r'''P''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''I kw.''',
      r'''II kw.''',
      r'''III kw.''',
      r'''IV kw.'''
    ],
    'QUARTERS': const <dynamic>[
      r'''I kwartał''',
      r'''II kwartał''',
      r'''III kwartał''',
      r'''IV kwartał'''
    ],
    'AMPMS': const <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd.MM.y'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'ps': const <String, dynamic>{
    'NAME': r'''ps''',
    'ERAS': const <dynamic>[r'''له میلاد وړاندې''', r'''م.'''],
    'ERANAMES': const <dynamic>[
      r'''له میلاد څخه وړاندې''',
      r'''له میلاد څخه وروسته'''
    ],
    'NARROWMONTHS': const <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': const <dynamic>[
      r'''جنوري''',
      r'''فبروري''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مۍ''',
      r'''جون''',
      r'''جولای''',
      r'''اګست''',
      r'''سپتمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''جنوري''',
      r'''فبروري''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مۍ''',
      r'''جون''',
      r'''جولای''',
      r'''اګست''',
      r'''سپتمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''جنوري''',
      r'''فبروري''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مۍ''',
      r'''جون''',
      r'''جولای''',
      r'''اګست''',
      r'''سپتمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''جنوري''',
      r'''فبروري''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مۍ''',
      r'''جون''',
      r'''جولای''',
      r'''اګست''',
      r'''سپتمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''لومړۍ ربعه''',
      r'''۲مه ربعه''',
      r'''۳مه ربعه''',
      r'''۴مه ربعه'''
    ],
    'QUARTERS': const <dynamic>[
      r'''لومړۍ ربعه''',
      r'''۲مه ربعه''',
      r'''۳مه ربعه''',
      r'''۴مه ربعه'''
    ],
    'AMPMS': const <dynamic>[r'''غ.م.''', r'''غ.و.'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE د y د MMMM d''',
      r'''د y د MMMM d''',
      r'''y MMM d''',
      r'''y/M/d'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''H:mm:ss (zzzz)''',
      r'''H:mm:ss (z)''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 5,
    'WEEKENDRANGE': const <dynamic>[3, 4],
    'FIRSTWEEKCUTOFFDAY': 4,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
    'ZERODIGIT': r'''۰''',
  },
  'pt': const <String, dynamic>{
    'NAME': r'''pt''',
    'ERAS': const <dynamic>[r'''a.C.''', r'''d.C.'''],
    'ERANAMES': const <dynamic>[
      r'''antes de Cristo''',
      r'''depois de Cristo'''
    ],
    'NARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''janeiro''',
      r'''fevereiro''',
      r'''março''',
      r'''abril''',
      r'''maio''',
      r'''junho''',
      r'''julho''',
      r'''agosto''',
      r'''setembro''',
      r'''outubro''',
      r'''novembro''',
      r'''dezembro'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''janeiro''',
      r'''fevereiro''',
      r'''março''',
      r'''abril''',
      r'''maio''',
      r'''junho''',
      r'''julho''',
      r'''agosto''',
      r'''setembro''',
      r'''outubro''',
      r'''novembro''',
      r'''dezembro'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''jan''',
      r'''fev''',
      r'''mar''',
      r'''abr''',
      r'''mai''',
      r'''jun''',
      r'''jul''',
      r'''ago''',
      r'''set''',
      r'''out''',
      r'''nov''',
      r'''dez'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''jan''',
      r'''fev''',
      r'''mar''',
      r'''abr''',
      r'''mai''',
      r'''jun''',
      r'''jul''',
      r'''ago''',
      r'''set''',
      r'''out''',
      r'''nov''',
      r'''dez'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''domingo''',
      r'''segunda-feira''',
      r'''terça-feira''',
      r'''quarta-feira''',
      r'''quinta-feira''',
      r'''sexta-feira''',
      r'''sábado'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''domingo''',
      r'''segunda-feira''',
      r'''terça-feira''',
      r'''quarta-feira''',
      r'''quinta-feira''',
      r'''sexta-feira''',
      r'''sábado'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''dom''',
      r'''seg''',
      r'''ter''',
      r'''qua''',
      r'''qui''',
      r'''sex''',
      r'''sáb'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''dom''',
      r'''seg''',
      r'''ter''',
      r'''qua''',
      r'''qui''',
      r'''sex''',
      r'''sáb'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''S''',
      r'''T''',
      r'''Q''',
      r'''Q''',
      r'''S''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''S''',
      r'''T''',
      r'''Q''',
      r'''Q''',
      r'''S''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''T1''',
      r'''T2''',
      r'''T3''',
      r'''T4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1º trimestre''',
      r'''2º trimestre''',
      r'''3º trimestre''',
      r'''4º trimestre'''
    ],
    'AMPMS': const <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': const <dynamic>[
      r"""EEEE, d 'de' MMMM 'de' y""",
      r"""d 'de' MMMM 'de' y""",
      r"""d 'de' MMM 'de' y""",
      r'''dd/MM/y'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'ro': const <String, dynamic>{
    'NAME': r'''ro''',
    'ERAS': const <dynamic>[r'''î.Hr.''', r'''d.Hr.'''],
    'ERANAMES': const <dynamic>[r'''înainte de Hristos''', r'''după Hristos'''],
    'NARROWMONTHS': const <dynamic>[
      r'''I''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''I''',
      r'''I''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''I''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''I''',
      r'''I''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''ianuarie''',
      r'''februarie''',
      r'''martie''',
      r'''aprilie''',
      r'''mai''',
      r'''iunie''',
      r'''iulie''',
      r'''august''',
      r'''septembrie''',
      r'''octombrie''',
      r'''noiembrie''',
      r'''decembrie'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''ianuarie''',
      r'''februarie''',
      r'''martie''',
      r'''aprilie''',
      r'''mai''',
      r'''iunie''',
      r'''iulie''',
      r'''august''',
      r'''septembrie''',
      r'''octombrie''',
      r'''noiembrie''',
      r'''decembrie'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''ian.''',
      r'''feb.''',
      r'''mar.''',
      r'''apr.''',
      r'''mai''',
      r'''iun.''',
      r'''iul.''',
      r'''aug.''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''ian.''',
      r'''feb.''',
      r'''mar.''',
      r'''apr.''',
      r'''mai''',
      r'''iun.''',
      r'''iul.''',
      r'''aug.''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''duminică''',
      r'''luni''',
      r'''marți''',
      r'''miercuri''',
      r'''joi''',
      r'''vineri''',
      r'''sâmbătă'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''duminică''',
      r'''luni''',
      r'''marți''',
      r'''miercuri''',
      r'''joi''',
      r'''vineri''',
      r'''sâmbătă'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''dum.''',
      r'''lun.''',
      r'''mar.''',
      r'''mie.''',
      r'''joi''',
      r'''vin.''',
      r'''sâm.'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''dum.''',
      r'''lun.''',
      r'''mar.''',
      r'''mie.''',
      r'''joi''',
      r'''vin.''',
      r'''sâm.'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''trim. I''',
      r'''trim. II''',
      r'''trim. III''',
      r'''trim. IV'''
    ],
    'QUARTERS': const <dynamic>[
      r'''trimestrul I''',
      r'''trimestrul al II-lea''',
      r'''trimestrul al III-lea''',
      r'''trimestrul al IV-lea'''
    ],
    'AMPMS': const <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd.MM.y'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'ru': const <String, dynamic>{
    'NAME': r'''ru''',
    'ERAS': const <dynamic>[r'''до н. э.''', r'''н. э.'''],
    'ERANAMES': const <dynamic>[
      r'''до Рождества Христова''',
      r'''от Рождества Христова'''
    ],
    'NARROWMONTHS': const <dynamic>[
      r'''Я''',
      r'''Ф''',
      r'''М''',
      r'''А''',
      r'''М''',
      r'''И''',
      r'''И''',
      r'''А''',
      r'''С''',
      r'''О''',
      r'''Н''',
      r'''Д'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''Я''',
      r'''Ф''',
      r'''М''',
      r'''А''',
      r'''М''',
      r'''И''',
      r'''И''',
      r'''А''',
      r'''С''',
      r'''О''',
      r'''Н''',
      r'''Д'''
    ],
    'MONTHS': const <dynamic>[
      r'''января''',
      r'''февраля''',
      r'''марта''',
      r'''апреля''',
      r'''мая''',
      r'''июня''',
      r'''июля''',
      r'''августа''',
      r'''сентября''',
      r'''октября''',
      r'''ноября''',
      r'''декабря'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''январь''',
      r'''февраль''',
      r'''март''',
      r'''апрель''',
      r'''май''',
      r'''июнь''',
      r'''июль''',
      r'''август''',
      r'''сентябрь''',
      r'''октябрь''',
      r'''ноябрь''',
      r'''декабрь'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''янв.''',
      r'''февр.''',
      r'''мар.''',
      r'''апр.''',
      r'''мая''',
      r'''июн.''',
      r'''июл.''',
      r'''авг.''',
      r'''сент.''',
      r'''окт.''',
      r'''нояб.''',
      r'''дек.'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''янв.''',
      r'''февр.''',
      r'''март''',
      r'''апр.''',
      r'''май''',
      r'''июнь''',
      r'''июль''',
      r'''авг.''',
      r'''сент.''',
      r'''окт.''',
      r'''нояб.''',
      r'''дек.'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''воскресенье''',
      r'''понедельник''',
      r'''вторник''',
      r'''среда''',
      r'''четверг''',
      r'''пятница''',
      r'''суббота'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''воскресенье''',
      r'''понедельник''',
      r'''вторник''',
      r'''среда''',
      r'''четверг''',
      r'''пятница''',
      r'''суббота'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''вс''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''вс''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''вс''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''В''',
      r'''П''',
      r'''В''',
      r'''С''',
      r'''Ч''',
      r'''П''',
      r'''С'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''1-й кв.''',
      r'''2-й кв.''',
      r'''3-й кв.''',
      r'''4-й кв.'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1-й квартал''',
      r'''2-й квартал''',
      r'''3-й квартал''',
      r'''4-й квартал'''
    ],
    'AMPMS': const <dynamic>[r'''ДП''', r'''ПП'''],
    'DATEFORMATS': const <dynamic>[
      r"""EEEE, d MMMM y 'г'.""",
      r"""d MMMM y 'г'.""",
      r"""d MMM y 'г'.""",
      r'''dd.MM.y'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''H:mm:ss zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'th': const <String, dynamic>{
    'NAME': r'''th''',
    'ERAS': const <dynamic>[r'''ปีก่อน ค.ศ.''', r'''ค.ศ.'''],
    'ERANAMES': const <dynamic>[r'''ปีก่อนคริสต์ศักราช''', r'''คริสต์ศักราช'''],
    'NARROWMONTHS': const <dynamic>[
      r'''ม.ค.''',
      r'''ก.พ.''',
      r'''มี.ค.''',
      r'''เม.ย.''',
      r'''พ.ค.''',
      r'''มิ.ย.''',
      r'''ก.ค.''',
      r'''ส.ค.''',
      r'''ก.ย.''',
      r'''ต.ค.''',
      r'''พ.ย.''',
      r'''ธ.ค.'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''ม.ค.''',
      r'''ก.พ.''',
      r'''มี.ค.''',
      r'''เม.ย.''',
      r'''พ.ค.''',
      r'''มิ.ย.''',
      r'''ก.ค.''',
      r'''ส.ค.''',
      r'''ก.ย.''',
      r'''ต.ค.''',
      r'''พ.ย.''',
      r'''ธ.ค.'''
    ],
    'MONTHS': const <dynamic>[
      r'''มกราคม''',
      r'''กุมภาพันธ์''',
      r'''มีนาคม''',
      r'''เมษายน''',
      r'''พฤษภาคม''',
      r'''มิถุนายน''',
      r'''กรกฎาคม''',
      r'''สิงหาคม''',
      r'''กันยายน''',
      r'''ตุลาคม''',
      r'''พฤศจิกายน''',
      r'''ธันวาคม'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''มกราคม''',
      r'''กุมภาพันธ์''',
      r'''มีนาคม''',
      r'''เมษายน''',
      r'''พฤษภาคม''',
      r'''มิถุนายน''',
      r'''กรกฎาคม''',
      r'''สิงหาคม''',
      r'''กันยายน''',
      r'''ตุลาคม''',
      r'''พฤศจิกายน''',
      r'''ธันวาคม'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''ม.ค.''',
      r'''ก.พ.''',
      r'''มี.ค.''',
      r'''เม.ย.''',
      r'''พ.ค.''',
      r'''มิ.ย.''',
      r'''ก.ค.''',
      r'''ส.ค.''',
      r'''ก.ย.''',
      r'''ต.ค.''',
      r'''พ.ย.''',
      r'''ธ.ค.'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''ม.ค.''',
      r'''ก.พ.''',
      r'''มี.ค.''',
      r'''เม.ย.''',
      r'''พ.ค.''',
      r'''มิ.ย.''',
      r'''ก.ค.''',
      r'''ส.ค.''',
      r'''ก.ย.''',
      r'''ต.ค.''',
      r'''พ.ย.''',
      r'''ธ.ค.'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''วันอาทิตย์''',
      r'''วันจันทร์''',
      r'''วันอังคาร''',
      r'''วันพุธ''',
      r'''วันพฤหัสบดี''',
      r'''วันศุกร์''',
      r'''วันเสาร์'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''วันอาทิตย์''',
      r'''วันจันทร์''',
      r'''วันอังคาร''',
      r'''วันพุธ''',
      r'''วันพฤหัสบดี''',
      r'''วันศุกร์''',
      r'''วันเสาร์'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''อา.''',
      r'''จ.''',
      r'''อ.''',
      r'''พ.''',
      r'''พฤ.''',
      r'''ศ.''',
      r'''ส.'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''อา.''',
      r'''จ.''',
      r'''อ.''',
      r'''พ.''',
      r'''พฤ.''',
      r'''ศ.''',
      r'''ส.'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''อา''',
      r'''จ''',
      r'''อ''',
      r'''พ''',
      r'''พฤ''',
      r'''ศ''',
      r'''ส'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''อา''',
      r'''จ''',
      r'''อ''',
      r'''พ''',
      r'''พฤ''',
      r'''ศ''',
      r'''ส'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''ไตรมาส 1''',
      r'''ไตรมาส 2''',
      r'''ไตรมาส 3''',
      r'''ไตรมาส 4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''ไตรมาส 1''',
      r'''ไตรมาส 2''',
      r'''ไตรมาส 3''',
      r'''ไตรมาส 4'''
    ],
    'AMPMS': const <dynamic>[r'''ก่อนเที่ยง''', r'''หลังเที่ยง'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEEที่ d MMMM G y''',
      r'''d MMMM G y''',
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''H นาฬิกา mm นาที ss วินาที zzzz''',
      r'''H นาฬิกา mm นาที ss วินาที z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'tr': const <String, dynamic>{
    'NAME': r'''tr''',
    'ERAS': const <dynamic>[r'''MÖ''', r'''MS'''],
    'ERANAMES': const <dynamic>[r'''Milattan Önce''', r'''Milattan Sonra'''],
    'NARROWMONTHS': const <dynamic>[
      r'''O''',
      r'''Ş''',
      r'''M''',
      r'''N''',
      r'''M''',
      r'''H''',
      r'''T''',
      r'''A''',
      r'''E''',
      r'''E''',
      r'''K''',
      r'''A'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''O''',
      r'''Ş''',
      r'''M''',
      r'''N''',
      r'''M''',
      r'''H''',
      r'''T''',
      r'''A''',
      r'''E''',
      r'''E''',
      r'''K''',
      r'''A'''
    ],
    'MONTHS': const <dynamic>[
      r'''Ocak''',
      r'''Şubat''',
      r'''Mart''',
      r'''Nisan''',
      r'''Mayıs''',
      r'''Haziran''',
      r'''Temmuz''',
      r'''Ağustos''',
      r'''Eylül''',
      r'''Ekim''',
      r'''Kasım''',
      r'''Aralık'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''Ocak''',
      r'''Şubat''',
      r'''Mart''',
      r'''Nisan''',
      r'''Mayıs''',
      r'''Haziran''',
      r'''Temmuz''',
      r'''Ağustos''',
      r'''Eylül''',
      r'''Ekim''',
      r'''Kasım''',
      r'''Aralık'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''Oca''',
      r'''Şub''',
      r'''Mar''',
      r'''Nis''',
      r'''May''',
      r'''Haz''',
      r'''Tem''',
      r'''Ağu''',
      r'''Eyl''',
      r'''Eki''',
      r'''Kas''',
      r'''Ara'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''Oca''',
      r'''Şub''',
      r'''Mar''',
      r'''Nis''',
      r'''May''',
      r'''Haz''',
      r'''Tem''',
      r'''Ağu''',
      r'''Eyl''',
      r'''Eki''',
      r'''Kas''',
      r'''Ara'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''Pazar''',
      r'''Pazartesi''',
      r'''Salı''',
      r'''Çarşamba''',
      r'''Perşembe''',
      r'''Cuma''',
      r'''Cumartesi'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''Pazar''',
      r'''Pazartesi''',
      r'''Salı''',
      r'''Çarşamba''',
      r'''Perşembe''',
      r'''Cuma''',
      r'''Cumartesi'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''Paz''',
      r'''Pzt''',
      r'''Sal''',
      r'''Çar''',
      r'''Per''',
      r'''Cum''',
      r'''Cmt'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''Paz''',
      r'''Pzt''',
      r'''Sal''',
      r'''Çar''',
      r'''Per''',
      r'''Cum''',
      r'''Cmt'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''P''',
      r'''P''',
      r'''S''',
      r'''Ç''',
      r'''P''',
      r'''C''',
      r'''C'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''P''',
      r'''P''',
      r'''S''',
      r'''Ç''',
      r'''P''',
      r'''C''',
      r'''C'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''Ç1''',
      r'''Ç2''',
      r'''Ç3''',
      r'''Ç4'''
    ],
    'QUARTERS': const <dynamic>[
      r'''1. çeyrek''',
      r'''2. çeyrek''',
      r'''3. çeyrek''',
      r'''4. çeyrek'''
    ],
    'AMPMS': const <dynamic>[r'''ÖÖ''', r'''ÖS'''],
    'DATEFORMATS': const <dynamic>[
      r'''d MMMM y EEEE''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''d.MM.y'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'ur': const <String, dynamic>{
    'NAME': r'''ur''',
    'ERAS': const <dynamic>[r'''قبل مسیح''', r'''عیسوی'''],
    'ERANAMES': const <dynamic>[r'''قبل مسیح''', r'''عیسوی'''],
    'NARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': const <dynamic>[
      r'''جنوری''',
      r'''فروری''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مئی''',
      r'''جون''',
      r'''جولائی''',
      r'''اگست''',
      r'''ستمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''جنوری''',
      r'''فروری''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مئی''',
      r'''جون''',
      r'''جولائی''',
      r'''اگست''',
      r'''ستمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''جنوری''',
      r'''فروری''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مئی''',
      r'''جون''',
      r'''جولائی''',
      r'''اگست''',
      r'''ستمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''جنوری''',
      r'''فروری''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مئی''',
      r'''جون''',
      r'''جولائی''',
      r'''اگست''',
      r'''ستمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''اتوار''',
      r'''سوموار''',
      r'''منگل''',
      r'''بدھ''',
      r'''جمعرات''',
      r'''جمعہ''',
      r'''ہفتہ'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''اتوار''',
      r'''سوموار''',
      r'''منگل''',
      r'''بدھ''',
      r'''جمعرات''',
      r'''جمعہ''',
      r'''ہفتہ'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''اتوار''',
      r'''سوموار''',
      r'''منگل''',
      r'''بدھ''',
      r'''جمعرات''',
      r'''جمعہ''',
      r'''ہفتہ'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''اتوار''',
      r'''سوموار''',
      r'''منگل''',
      r'''بدھ''',
      r'''جمعرات''',
      r'''جمعہ''',
      r'''ہفتہ'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''پہلی سہ ماہی''',
      r'''دوسری سہ ماہی''',
      r'''تیسری سہ ماہی''',
      r'''چوتهی سہ ماہی'''
    ],
    'QUARTERS': const <dynamic>[
      r'''پہلی سہ ماہی''',
      r'''دوسری سہ ماہی''',
      r'''تیسری سہ ماہی''',
      r'''چوتهی سہ ماہی'''
    ],
    'AMPMS': const <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': const <dynamic>[
      r'''EEEE، d MMMM، y''',
      r'''d MMMM، y''',
      r'''y MMM d''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'zh': const <String, dynamic>{
    'NAME': r'''zh''',
    'ERAS': const <dynamic>[r'''公元前''', r'''公元'''],
    'ERANAMES': const <dynamic>[r'''公元前''', r'''公元'''],
    'NARROWMONTHS': const <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': const <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': const <dynamic>[
      r'''一月''',
      r'''二月''',
      r'''三月''',
      r'''四月''',
      r'''五月''',
      r'''六月''',
      r'''七月''',
      r'''八月''',
      r'''九月''',
      r'''十月''',
      r'''十一月''',
      r'''十二月'''
    ],
    'STANDALONEMONTHS': const <dynamic>[
      r'''一月''',
      r'''二月''',
      r'''三月''',
      r'''四月''',
      r'''五月''',
      r'''六月''',
      r'''七月''',
      r'''八月''',
      r'''九月''',
      r'''十月''',
      r'''十一月''',
      r'''十二月'''
    ],
    'SHORTMONTHS': const <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONESHORTMONTHS': const <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'WEEKDAYS': const <dynamic>[
      r'''星期日''',
      r'''星期一''',
      r'''星期二''',
      r'''星期三''',
      r'''星期四''',
      r'''星期五''',
      r'''星期六'''
    ],
    'STANDALONEWEEKDAYS': const <dynamic>[
      r'''星期日''',
      r'''星期一''',
      r'''星期二''',
      r'''星期三''',
      r'''星期四''',
      r'''星期五''',
      r'''星期六'''
    ],
    'SHORTWEEKDAYS': const <dynamic>[
      r'''周日''',
      r'''周一''',
      r'''周二''',
      r'''周三''',
      r'''周四''',
      r'''周五''',
      r'''周六'''
    ],
    'STANDALONESHORTWEEKDAYS': const <dynamic>[
      r'''周日''',
      r'''周一''',
      r'''周二''',
      r'''周三''',
      r'''周四''',
      r'''周五''',
      r'''周六'''
    ],
    'NARROWWEEKDAYS': const <dynamic>[
      r'''日''',
      r'''一''',
      r'''二''',
      r'''三''',
      r'''四''',
      r'''五''',
      r'''六'''
    ],
    'STANDALONENARROWWEEKDAYS': const <dynamic>[
      r'''日''',
      r'''一''',
      r'''二''',
      r'''三''',
      r'''四''',
      r'''五''',
      r'''六'''
    ],
    'SHORTQUARTERS': const <dynamic>[
      r'''1季度''',
      r'''2季度''',
      r'''3季度''',
      r'''4季度'''
    ],
    'QUARTERS': const <dynamic>[
      r'''第一季度''',
      r'''第二季度''',
      r'''第三季度''',
      r'''第四季度'''
    ],
    'AMPMS': const <dynamic>[r'''上午''', r'''下午'''],
    'DATEFORMATS': const <dynamic>[
      r'''y年M月d日EEEE''',
      r'''y年M月d日''',
      r'''y年M月d日''',
      r'''y/M/d'''
    ],
    'TIMEFORMATS': const <dynamic>[
      r'''zzzz ah:mm:ss''',
      r'''z ah:mm:ss''',
      r'''ah:mm:ss''',
      r'''ah:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': const <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': const <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
};
const Map<String, Map<String, String>> datePatterns =
    const <String, Map<String, String>>{
  'ar': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/‏M''',
    'MEd': r'''EEE، d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE، d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE، d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M‏/y''',
    'yMd': r'''d‏/M‏/y''',
    'yMEd': r'''EEE، d/‏M/‏y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM، y''',
    'yMMMEd': r'''EEE، d MMM، y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM، y''',
    'yMMMMEEEEd': r'''EEEE، d MMMM، y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'de': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE, d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE, d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M.y''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE, d.M.y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d. MMM y''',
    'yMMMEd': r'''EEE, d. MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r"""HH 'Uhr'""",
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r"""HH 'Uhr'""",
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r"""HH 'Uhr' z""",
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'en': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''M/d''',
    'MEd': r'''EEE, M/d''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d''',
    'MMMEd': r'''EEE, MMM d''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d''',
    'MMMMEEEEd': r'''EEEE, MMMM d''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''M/d/y''',
    'yMEd': r'''EEE, M/d/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''MMM d, y''',
    'yMMMEd': r'''EEE, MMM d, y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''MMMM d, y''',
    'yMMMMEEEEd': r'''EEEE, MMMM d, y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'es': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r"""d 'de' MMMM""",
    'MMMMEEEEd': r"""EEEE, d 'de' MMMM""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r"""MMMM 'de' y""",
    'yMMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d 'de' MMMM 'de' y""",
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r"""QQQQ 'de' y""",
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'fa': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''M/d''',
    'MEd': r'''EEE M/d''',
    'MMM': r'''LLL''',
    'MMMd': r'''d LLL''',
    'MMMEd': r'''EEE d LLL''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d LLLL''',
    'MMMMEEEEd': r'''EEEE d LLLL''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y/M''',
    'yMd': r'''y/M/d''',
    'yMEd': r'''EEE y/M/d''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm (z)''',
    'jz': r'''H (z)''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'fr': const <String, String>{
    'd': r'''d''',
    'E': r'''EEE''',
    'EEEE': r'''EEEE''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd/MM''',
    'MEd': r'''EEE dd/MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd/MM/y''',
    'yMEd': r'''EEE dd/MM/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r"""HH 'h'""",
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r"""HH 'h'""",
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r"""HH 'h' z""",
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'gsw': const <String, String>{
    'd': r'''d''',
    'E': r'''EEE''',
    'EEEE': r'''EEEE''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE, d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y-M''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE, y-M-d''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''y MMM d''',
    'yMMMEd': r'''EEE, d. MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''H''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'he': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M''',
    'MEd': r'''EEE, d.M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d בMMM''',
    'MMMEd': r'''EEE, d בMMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d בMMMM''',
    'MMMMEEEEd': r'''EEEE, d בMMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M.y''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE, d.M.y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d בMMM y''',
    'yMMMEd': r'''EEE, d בMMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d בMMMM y''',
    'yMMMMEEEEd': r'''EEEE, d בMMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'it': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ja': const <String, String>{
    'd': r'''d日''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''M月''',
    'LLLL': r'''M月''',
    'M': r'''M月''',
    'Md': r'''M/d''',
    'MEd': r'''M/d(EEE)''',
    'MMM': r'''M月''',
    'MMMd': r'''M月d日''',
    'MMMEd': r'''M月d日(EEE)''',
    'MMMM': r'''M月''',
    'MMMMd': r'''M月d日''',
    'MMMMEEEEd': r'''M月d日EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y年''',
    'yM': r'''y/M''',
    'yMd': r'''y/M/d''',
    'yMEd': r'''y/M/d(EEE)''',
    'yMMM': r'''y年M月''',
    'yMMMd': r'''y年M月d日''',
    'yMMMEd': r'''y年M月d日(EEE)''',
    'yMMMM': r'''y年M月''',
    'yMMMMd': r'''y年M月d日''',
    'yMMMMEEEEd': r'''y年M月d日EEEE''',
    'yQQQ': r'''y/QQQ''',
    'yQQQQ': r'''y年QQQQ''',
    'H': r'''H時''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H時''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''H時 z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ko': const <String, String>{
    'd': r'''d일''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''M월''',
    'Md': r'''M. d.''',
    'MEd': r'''M. d. (EEE)''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d일''',
    'MMMEd': r'''MMM d일 (EEE)''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d일''',
    'MMMMEEEEd': r'''MMMM d일 EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y년''',
    'yM': r'''y. M.''',
    'yMd': r'''y. M. d.''',
    'yMEd': r'''y. M. d. (EEE)''',
    'yMMM': r'''y년 MMM''',
    'yMMMd': r'''y년 MMM d일''',
    'yMMMEd': r'''y년 MMM d일 (EEE)''',
    'yMMMM': r'''y년 MMMM''',
    'yMMMMd': r'''y년 MMMM d일''',
    'yMMMMEEEEd': r'''y년 MMMM d일 EEEE''',
    'yQQQ': r'''y년 QQQ''',
    'yQQQQ': r'''y년 QQQQ''',
    'H': r'''H시''',
    'Hm': r'''HH:mm''',
    'Hms': r'''H시 m분 s초''',
    'j': r'''a h시''',
    'jm': r'''a h:mm''',
    'jms': r'''a h:mm:ss''',
    'jmv': r'''a h:mm v''',
    'jmz': r'''a h:mm z''',
    'jz': r'''a h시 z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'nl': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d-M''',
    'MEd': r'''EEE d-M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M-y''',
    'yMd': r'''d-M-y''',
    'yMEd': r'''EEE d-M-y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'pl': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.MM''',
    'MEd': r'''EEE, d.MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM.y''',
    'yMd': r'''d.MM.y''',
    'yMEd': r'''EEE, d.MM.y''',
    'yMMM': r'''LLL y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''LLLL y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ps': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''M/d''',
    'MEd': r'''MM-dd, EEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d''',
    'MMMEd': r'''MMM d, EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''MMMM d, EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y/M''',
    'yMd': r'''y-MM-dd''',
    'yMEd': r'''y-MM-dd, EEE''',
    'yMMM': r'''y MMM''',
    'yMMMd': r'''y MMM d''',
    'yMMMEd': r'''y MMM d, EEE''',
    'yMMMM': r'''د y د MMMM''',
    'yMMMMd': r'''د y د MMMM d''',
    'yMMMMEEEEd': r'''EEEE د y د MMMM d''',
    'yQQQ': r'''y QQQ''',
    'yQQQQ': r'''y QQQQ''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''H (z)''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'pt': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, dd/MM''',
    'MMM': r'''LLL''',
    'MMMd': r"""d 'de' MMM""",
    'MMMEd': r"""EEE, d 'de' MMM""",
    'MMMM': r'''LLLL''',
    'MMMMd': r"""d 'de' MMMM""",
    'MMMMEEEEd': r"""EEEE, d 'de' MMMM""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd/MM/y''',
    'yMEd': r'''EEE, dd/MM/y''',
    'yMMM': r"""MMM 'de' y""",
    'yMMMd': r"""d 'de' MMM 'de' y""",
    'yMMMEd': r"""EEE, d 'de' MMM 'de' y""",
    'yMMMM': r"""MMMM 'de' y""",
    'yMMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d 'de' MMMM 'de' y""",
    'yQQQ': r"""QQQ 'de' y""",
    'yQQQQ': r"""QQQQ 'de' y""",
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ro': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd.MM''',
    'MEd': r'''EEE, dd.MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM.y''',
    'yMd': r'''dd.MM.y''',
    'yMEd': r'''EEE, dd.MM.y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ru': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd.MM''',
    'MEd': r'''EEE, dd.MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''ccc, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''cccc, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM.y''',
    'yMd': r'''dd.MM.y''',
    'yMEd': r"""ccc, d.MM.y 'г'.""",
    'yMMM': r"""LLL y 'г'.""",
    'yMMMd': r"""d MMM y 'г'.""",
    'yMMMEd': r"""EEE, d MMM y 'г'.""",
    'yMMMM': r"""LLLL y 'г'.""",
    'yMMMMd': r"""d MMMM y 'г'.""",
    'yMMMMEEEEd': r"""EEEE, d MMMM y 'г'.""",
    'yQQQ': r"""QQQ y 'г'.""",
    'yQQQQ': r"""QQQQ y 'г'.""",
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'th': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEEที่ d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM G y''',
    'yMMMMd': r'''d MMMM G y''',
    'yMMMMEEEEd': r'''EEEEที่ d MMMM G y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ G y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm น.''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm น.''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'tr': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''d/MM EEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''d MMMM EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''d MMMM EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd.MM.y''',
    'yMEd': r'''d.M.y EEE''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''d MMM y EEE''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''d MMMM y EEEE''',
    'yQQQ': r'''y QQQ''',
    'yQQQQ': r'''y QQQQ''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ur': const <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE، d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE، d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d''',
    'MMMMEEEEd': r'''EEEE، d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE، d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM، y''',
    'yMMMEd': r'''EEE، d MMM، y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM، y''',
    'yMMMMEEEEd': r'''EEEE، d MMMM، y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'zh': const <String, String>{
    'd': r'''d日''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''M月''',
    'Md': r'''M/d''',
    'MEd': r'''M/dEEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''M月d日''',
    'MMMEd': r'''M月d日EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''M月d日''',
    'MMMMEEEEd': r'''M月d日EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y年''',
    'yM': r'''y年M月''',
    'yMd': r'''y/M/d''',
    'yMEd': r'''y/M/dEEE''',
    'yMMM': r'''y年M月''',
    'yMMMd': r'''y年M月d日''',
    'yMMMEd': r'''y年M月d日EEE''',
    'yMMMM': r'''y年M月''',
    'yMMMMd': r'''y年M月d日''',
    'yMMMMEEEEd': r'''y年M月d日EEEE''',
    'yQQQ': r'''y年第Q季度''',
    'yQQQQ': r'''y年第Q季度''',
    'H': r'''H时''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''ah时''',
    'jm': r'''ah:mm''',
    'jms': r'''ah:mm:ss''',
    'jmv': r'''v ah:mm''',
    'jmz': r'''z ah:mm''',
    'jz': r'''zah时''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
};
