// Copyright 2014 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'package:flutter/foundation.dart' show defaultTargetPlatform;
import 'package:flutter/widgets.dart';

// ignore_for_file: non_constant_identifier_names
class _PlatformAdaptiveIcons {
  static bool _isCupertino() {
    switch (defaultTargetPlatform) {
      case TargetPlatform.android:
      case TargetPlatform.fuchsia:
      case TargetPlatform.linux:
      case TargetPlatform.windows:
        return false;
      case TargetPlatform.iOS:
      case TargetPlatform.macOS:
        return true;
    }
  }

  // Generated code: do not hand-edit.
  // See https://github.com/flutter/flutter/wiki/Updating-Material-Design-Fonts
  // BEGIN GENERATED PLATFORM ADAPTIVE ICONS

  /// Platform-adaptive icon for <i class="material-icons md-36">arrow_back</i> &#x2014; material icon named "arrow back" and <i class="material-icons md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios".;
  IconData get arrow_back => !_isCupertino() ? Icons.arrow_back : Icons.arrow_back_ios;

  /// Platform-adaptive icon for <i class="material-icons-outlined md-36">arrow_back</i> &#x2014; material icon named "arrow back outlined" and <i class="material-icons-outlined md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios outlined".;
  IconData get arrow_back_outlined => !_isCupertino() ? Icons.arrow_back_outlined : Icons.arrow_back_ios_outlined;

  /// Platform-adaptive icon for <i class="material-icons-round md-36">arrow_back</i> &#x2014; material icon named "arrow back rounded" and <i class="material-icons-round md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios rounded".;
  IconData get arrow_back_rounded => !_isCupertino() ? Icons.arrow_back_rounded : Icons.arrow_back_ios_rounded;

  /// Platform-adaptive icon for <i class="material-icons-sharp md-36">arrow_back</i> &#x2014; material icon named "arrow back sharp" and <i class="material-icons-sharp md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios sharp".;
  IconData get arrow_back_sharp => !_isCupertino() ? Icons.arrow_back_sharp : Icons.arrow_back_ios_sharp;

  /// Platform-adaptive icon for <i class="material-icons md-36">arrow_forward</i> &#x2014; material icon named "arrow forward" and <i class="material-icons md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios".;
  IconData get arrow_forward => !_isCupertino() ? Icons.arrow_forward : Icons.arrow_forward_ios;

  /// Platform-adaptive icon for <i class="material-icons-outlined md-36">arrow_forward</i> &#x2014; material icon named "arrow forward outlined" and <i class="material-icons-outlined md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios outlined".;
  IconData get arrow_forward_outlined => !_isCupertino() ? Icons.arrow_forward_outlined : Icons.arrow_forward_ios_outlined;

  /// Platform-adaptive icon for <i class="material-icons-round md-36">arrow_forward</i> &#x2014; material icon named "arrow forward rounded" and <i class="material-icons-round md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios rounded".;
  IconData get arrow_forward_rounded => !_isCupertino() ? Icons.arrow_forward_rounded : Icons.arrow_forward_ios_rounded;

  /// Platform-adaptive icon for <i class="material-icons-sharp md-36">arrow_forward</i> &#x2014; material icon named "arrow forward sharp" and <i class="material-icons-sharp md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios sharp".;
  IconData get arrow_forward_sharp => !_isCupertino() ? Icons.arrow_forward_sharp : Icons.arrow_forward_ios_sharp;

  /// Platform-adaptive icon for <i class="material-icons md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android" and <i class="material-icons md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios".;
  IconData get flip_camera => !_isCupertino() ? Icons.flip_camera_android : Icons.flip_camera_ios;

  /// Platform-adaptive icon for <i class="material-icons-outlined md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android outlined" and <i class="material-icons-outlined md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios outlined".;
  IconData get flip_camera_outlined => !_isCupertino() ? Icons.flip_camera_android_outlined : Icons.flip_camera_ios_outlined;

  /// Platform-adaptive icon for <i class="material-icons-round md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android rounded" and <i class="material-icons-round md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios rounded".;
  IconData get flip_camera_rounded => !_isCupertino() ? Icons.flip_camera_android_rounded : Icons.flip_camera_ios_rounded;

  /// Platform-adaptive icon for <i class="material-icons-sharp md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android sharp" and <i class="material-icons-sharp md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios sharp".;
  IconData get flip_camera_sharp => !_isCupertino() ? Icons.flip_camera_android_sharp : Icons.flip_camera_ios_sharp;

  /// Platform-adaptive icon for <i class="material-icons md-36">more_vert</i> &#x2014; material icon named "more vert" and <i class="material-icons md-36">more_horiz</i> &#x2014; material icon named "more horiz".;
  IconData get more => !_isCupertino() ? Icons.more_vert : Icons.more_horiz;

  /// Platform-adaptive icon for <i class="material-icons-outlined md-36">more_vert</i> &#x2014; material icon named "more vert outlined" and <i class="material-icons-outlined md-36">more_horiz</i> &#x2014; material icon named "more horiz outlined".;
  IconData get more_outlined => !_isCupertino() ? Icons.more_vert_outlined : Icons.more_horiz_outlined;

  /// Platform-adaptive icon for <i class="material-icons-round md-36">more_vert</i> &#x2014; material icon named "more vert rounded" and <i class="material-icons-round md-36">more_horiz</i> &#x2014; material icon named "more horiz rounded".;
  IconData get more_rounded => !_isCupertino() ? Icons.more_vert_rounded : Icons.more_horiz_rounded;

  /// Platform-adaptive icon for <i class="material-icons-sharp md-36">more_vert</i> &#x2014; material icon named "more vert sharp" and <i class="material-icons-sharp md-36">more_horiz</i> &#x2014; material icon named "more horiz sharp".;
  IconData get more_sharp => !_isCupertino() ? Icons.more_vert_sharp : Icons.more_horiz_sharp;

  /// Platform-adaptive icon for <i class="material-icons md-36">share</i> &#x2014; material icon named "share" and <i class="material-icons md-36">ios_share</i> &#x2014; material icon named "ios share".;
  IconData get share => !_isCupertino() ? Icons.share : Icons.ios_share;
  // END GENERATED PLATFORM ADAPTIVE ICONS
}

/// Identifiers for the supported material design icons.
///
/// Use with the [Icon] class to show specific icons.
///
/// Icons are identified by their name as listed below.
///
/// To use this class, make sure you set `uses-material-design: true` in your
/// project's `pubspec.yaml` file in the `flutter` section. This ensures that
/// the MaterialIcons font is included in your application. This font is used to
/// display the icons. For example:
///
/// ```yaml
/// name: my_awesome_application
/// flutter:
///   uses-material-design: true
/// ```
///
/// {@tool snippet}
/// This example shows how to create a [Row] of [Icon]s in different colors and
/// sizes. The first [Icon] uses a [Icon.semanticLabel] to announce in accessibility
/// modes like TalkBack and VoiceOver.
///
/// ![A row of icons representing a pink heart, a green musical note, and a blue umbrella](https://flutter.github.io/assets-for-api-docs/assets/widgets/icon.png)
///
/// ```dart
/// Row(
///   mainAxisAlignment: MainAxisAlignment.spaceAround,
///   children: const <Widget>[
///     Icon(
///       Icons.favorite,
///       color: Colors.pink,
///       size: 24.0,
///       semanticLabel: 'Text to announce in accessibility modes',
///     ),
///     Icon(
///       Icons.audiotrack,
///       color: Colors.green,
///       size: 30.0,
///     ),
///     Icon(
///       Icons.beach_access,
///       color: Colors.blue,
///       size: 36.0,
///     ),
///   ],
/// )
/// ```
/// {@end-tool}
///
/// See also:
///
///  * [Icon]
///  * [IconButton]
///  * <https://design.google.com/icons/>
class Icons {
  // This class is not meant to be instantiated or extended; this constructor
  // prevents instantiation and extension.
  // ignore: unused_element
  Icons._();

  /// A set of platform-adaptive material design icons.
  ///
  /// Provides a convenient way to show a certain set of platform-appropriate
  /// icons on Apple platforms.
  ///
  /// Use with the [Icon] class to show specific icons.
  ///
  /// {@tool snippet}
  /// This example shows how to create a share icon that uses the material icon
  /// named "share" on non-Apple platforms, and the icon named "ios share" on
  /// Apple platforms.
  ///
  /// ```dart
  /// Icon(
  ///   Icons.adaptive.share,
  /// )
  /// ```
  /// {@end-tool}
  ///
  /// See also:
  ///
  ///  * [Icon]
  ///  * [IconButton]
  ///  * <https://design.google.com/icons/>
  static _PlatformAdaptiveIcons get adaptive => _PlatformAdaptiveIcons();

  // Generated code: do not hand-edit.
  // See https://github.com/flutter/flutter/wiki/Updating-Material-Design-Fonts
  // BEGIN GENERATED ICONS

  /// <i class="material-icons md-36">10k</i> &#x2014; material icon named "10k".
  static const IconData ten_k = IconData(0xe52a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">10mp</i> &#x2014; material icon named "10mp".
  static const IconData ten_mp = IconData(0xe52b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">11mp</i> &#x2014; material icon named "11mp".
  static const IconData eleven_mp = IconData(0xe52c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">12mp</i> &#x2014; material icon named "12mp".
  static const IconData twelve_mp = IconData(0xe52d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">13mp</i> &#x2014; material icon named "13mp".
  static const IconData thirteen_mp = IconData(0xe52e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">14mp</i> &#x2014; material icon named "14mp".
  static const IconData fourteen_mp = IconData(0xe52f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">15mp</i> &#x2014; material icon named "15mp".
  static const IconData fifteen_mp = IconData(0xe530, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">16mp</i> &#x2014; material icon named "16mp".
  static const IconData sixteen_mp = IconData(0xe531, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">17mp</i> &#x2014; material icon named "17mp".
  static const IconData seventeen_mp = IconData(0xe532, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">18mp</i> &#x2014; material icon named "18mp".
  static const IconData eighteen_mp = IconData(0xe533, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">19mp</i> &#x2014; material icon named "19mp".
  static const IconData nineteen_mp = IconData(0xe534, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">1k</i> &#x2014; material icon named "1k".
  static const IconData one_k = IconData(0xe535, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">1k_plus</i> &#x2014; material icon named "1k plus".
  static const IconData one_k_plus = IconData(0xe536, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">20mp</i> &#x2014; material icon named "20mp".
  static const IconData twenty_mp = IconData(0xe537, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">21mp</i> &#x2014; material icon named "21mp".
  static const IconData twenty_one_mp = IconData(0xe538, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">22mp</i> &#x2014; material icon named "22mp".
  static const IconData twenty_two_mp = IconData(0xe539, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">23mp</i> &#x2014; material icon named "23mp".
  static const IconData twenty_three_mp = IconData(0xe53a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">24mp</i> &#x2014; material icon named "24mp".
  static const IconData twenty_four_mp = IconData(0xe53b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">2k</i> &#x2014; material icon named "2k".
  static const IconData two_k = IconData(0xe53c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">2k_plus</i> &#x2014; material icon named "2k plus".
  static const IconData two_k_plus = IconData(0xe53d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">2mp</i> &#x2014; material icon named "2mp".
  static const IconData two_mp = IconData(0xe53e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">360</i> &#x2014; material icon named "360".
  static const IconData threesixty = IconData(0xe53f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">360</i> &#x2014; material icon named "360 outlined".
  static const IconData threesixty_outlined = IconData(0xe000, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">360</i> &#x2014; material icon named "360 rounded".
  static const IconData threesixty_rounded = IconData(0xf02e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">360</i> &#x2014; material icon named "360 sharp".
  static const IconData threesixty_sharp = IconData(0xeb00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3d_rotation</i> &#x2014; material icon named "3d rotation".
  static const IconData threed_rotation = IconData(0xe540, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">3d_rotation</i> &#x2014; material icon named "3d rotation outlined".
  static const IconData threed_rotation_outlined = IconData(0xe001, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">3d_rotation</i> &#x2014; material icon named "3d rotation rounded".
  static const IconData threed_rotation_rounded = IconData(0xf02f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">3d_rotation</i> &#x2014; material icon named "3d rotation sharp".
  static const IconData threed_rotation_sharp = IconData(0xeb01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3k</i> &#x2014; material icon named "3k".
  static const IconData three_k = IconData(0xe541, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3k_plus</i> &#x2014; material icon named "3k plus".
  static const IconData three_k_plus = IconData(0xe542, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3mp</i> &#x2014; material icon named "3mp".
  static const IconData three_mp = IconData(0xe543, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">4k</i> &#x2014; material icon named "4k".
  static const IconData four_k = IconData(0xe544, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">4k</i> &#x2014; material icon named "4k outlined".
  static const IconData four_k_outlined = IconData(0xe002, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">4k_plus</i> &#x2014; material icon named "4k plus".
  static const IconData four_k_plus = IconData(0xe545, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">4k</i> &#x2014; material icon named "4k rounded".
  static const IconData four_k_rounded = IconData(0xf030, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">4k</i> &#x2014; material icon named "4k sharp".
  static const IconData four_k_sharp = IconData(0xeb02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">4mp</i> &#x2014; material icon named "4mp".
  static const IconData four_mp = IconData(0xe546, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">5g</i> &#x2014; material icon named "5g".
  static const IconData five_g = IconData(0xe547, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">5g</i> &#x2014; material icon named "5g outlined".
  static const IconData five_g_outlined = IconData(0xe003, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">5g</i> &#x2014; material icon named "5g rounded".
  static const IconData five_g_rounded = IconData(0xf031, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">5g</i> &#x2014; material icon named "5g sharp".
  static const IconData five_g_sharp = IconData(0xeb03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">5k</i> &#x2014; material icon named "5k".
  static const IconData five_k = IconData(0xe548, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">5k_plus</i> &#x2014; material icon named "5k plus".
  static const IconData five_k_plus = IconData(0xe549, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">5mp</i> &#x2014; material icon named "5mp".
  static const IconData five_mp = IconData(0xe54a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">6_ft_apart</i> &#x2014; material icon named "6 ft apart".
  static const IconData six_ft_apart = IconData(0xe54b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">6_ft_apart</i> &#x2014; material icon named "6 ft apart outlined".
  static const IconData six_ft_apart_outlined = IconData(0xe004, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">6_ft_apart</i> &#x2014; material icon named "6 ft apart rounded".
  static const IconData six_ft_apart_rounded = IconData(0xf032, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">6_ft_apart</i> &#x2014; material icon named "6 ft apart sharp".
  static const IconData six_ft_apart_sharp = IconData(0xeb04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">6k</i> &#x2014; material icon named "6k".
  static const IconData six_k = IconData(0xe54c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">6k_plus</i> &#x2014; material icon named "6k plus".
  static const IconData six_k_plus = IconData(0xe54d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">6mp</i> &#x2014; material icon named "6mp".
  static const IconData six_mp = IconData(0xe54e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">7k</i> &#x2014; material icon named "7k".
  static const IconData seven_k = IconData(0xe54f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">7k_plus</i> &#x2014; material icon named "7k plus".
  static const IconData seven_k_plus = IconData(0xe550, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">7mp</i> &#x2014; material icon named "7mp".
  static const IconData seven_mp = IconData(0xe551, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">8k</i> &#x2014; material icon named "8k".
  static const IconData eight_k = IconData(0xe552, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">8k_plus</i> &#x2014; material icon named "8k plus".
  static const IconData eight_k_plus = IconData(0xe553, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">8mp</i> &#x2014; material icon named "8mp".
  static const IconData eight_mp = IconData(0xe554, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">9k</i> &#x2014; material icon named "9k".
  static const IconData nine_k = IconData(0xe555, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">9k_plus</i> &#x2014; material icon named "9k plus".
  static const IconData nine_k_plus = IconData(0xe556, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">9mp</i> &#x2014; material icon named "9mp".
  static const IconData nine_mp = IconData(0xe557, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ac_unit</i> &#x2014; material icon named "ac unit".
  static const IconData ac_unit = IconData(0xe558, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ac_unit</i> &#x2014; material icon named "ac unit outlined".
  static const IconData ac_unit_outlined = IconData(0xe005, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ac_unit</i> &#x2014; material icon named "ac unit rounded".
  static const IconData ac_unit_rounded = IconData(0xf033, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ac_unit</i> &#x2014; material icon named "ac unit sharp".
  static const IconData ac_unit_sharp = IconData(0xeb05, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_alarm</i> &#x2014; material icon named "access alarm".
  static const IconData access_alarm = IconData(0xe559, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">access_alarm</i> &#x2014; material icon named "access alarm outlined".
  static const IconData access_alarm_outlined = IconData(0xe006, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">access_alarm</i> &#x2014; material icon named "access alarm rounded".
  static const IconData access_alarm_rounded = IconData(0xf034, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">access_alarm</i> &#x2014; material icon named "access alarm sharp".
  static const IconData access_alarm_sharp = IconData(0xeb06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_alarms</i> &#x2014; material icon named "access alarms".
  static const IconData access_alarms = IconData(0xe55a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">access_alarms</i> &#x2014; material icon named "access alarms outlined".
  static const IconData access_alarms_outlined = IconData(0xe007, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">access_alarms</i> &#x2014; material icon named "access alarms rounded".
  static const IconData access_alarms_rounded = IconData(0xf035, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">access_alarms</i> &#x2014; material icon named "access alarms sharp".
  static const IconData access_alarms_sharp = IconData(0xeb07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_time</i> &#x2014; material icon named "access time".
  static const IconData access_time = IconData(0xe55b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">access_time</i> &#x2014; material icon named "access time outlined".
  static const IconData access_time_outlined = IconData(0xe008, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">access_time</i> &#x2014; material icon named "access time rounded".
  static const IconData access_time_rounded = IconData(0xf036, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">access_time</i> &#x2014; material icon named "access time sharp".
  static const IconData access_time_sharp = IconData(0xeb08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessibility</i> &#x2014; material icon named "accessibility".
  static const IconData accessibility = IconData(0xe55c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessibility_new</i> &#x2014; material icon named "accessibility new".
  static const IconData accessibility_new = IconData(0xe55d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">accessibility_new</i> &#x2014; material icon named "accessibility new outlined".
  static const IconData accessibility_new_outlined = IconData(0xe009, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">accessibility_new</i> &#x2014; material icon named "accessibility new rounded".
  static const IconData accessibility_new_rounded = IconData(0xf037, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">accessibility_new</i> &#x2014; material icon named "accessibility new sharp".
  static const IconData accessibility_new_sharp = IconData(0xeb09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">accessibility</i> &#x2014; material icon named "accessibility outlined".
  static const IconData accessibility_outlined = IconData(0xe00a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">accessibility</i> &#x2014; material icon named "accessibility rounded".
  static const IconData accessibility_rounded = IconData(0xf038, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">accessibility</i> &#x2014; material icon named "accessibility sharp".
  static const IconData accessibility_sharp = IconData(0xeb0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessible</i> &#x2014; material icon named "accessible".
  static const IconData accessible = IconData(0xe55e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessible_forward</i> &#x2014; material icon named "accessible forward".
  static const IconData accessible_forward = IconData(0xe55f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">accessible_forward</i> &#x2014; material icon named "accessible forward outlined".
  static const IconData accessible_forward_outlined = IconData(0xe00b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">accessible_forward</i> &#x2014; material icon named "accessible forward rounded".
  static const IconData accessible_forward_rounded = IconData(0xf039, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">accessible_forward</i> &#x2014; material icon named "accessible forward sharp".
  static const IconData accessible_forward_sharp = IconData(0xeb0b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">accessible</i> &#x2014; material icon named "accessible outlined".
  static const IconData accessible_outlined = IconData(0xe00c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">accessible</i> &#x2014; material icon named "accessible rounded".
  static const IconData accessible_rounded = IconData(0xf03a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">accessible</i> &#x2014; material icon named "accessible sharp".
  static const IconData accessible_sharp = IconData(0xeb0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_balance</i> &#x2014; material icon named "account balance".
  static const IconData account_balance = IconData(0xe560, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_balance</i> &#x2014; material icon named "account balance outlined".
  static const IconData account_balance_outlined = IconData(0xe00d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_balance</i> &#x2014; material icon named "account balance rounded".
  static const IconData account_balance_rounded = IconData(0xf03b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_balance</i> &#x2014; material icon named "account balance sharp".
  static const IconData account_balance_sharp = IconData(0xeb0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_balance_wallet</i> &#x2014; material icon named "account balance wallet".
  static const IconData account_balance_wallet = IconData(0xe561, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_balance_wallet</i> &#x2014; material icon named "account balance wallet outlined".
  static const IconData account_balance_wallet_outlined = IconData(0xe00e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_balance_wallet</i> &#x2014; material icon named "account balance wallet rounded".
  static const IconData account_balance_wallet_rounded = IconData(0xf03c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_balance_wallet</i> &#x2014; material icon named "account balance wallet sharp".
  static const IconData account_balance_wallet_sharp = IconData(0xeb0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_box</i> &#x2014; material icon named "account box".
  static const IconData account_box = IconData(0xe562, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_box</i> &#x2014; material icon named "account box outlined".
  static const IconData account_box_outlined = IconData(0xe00f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_box</i> &#x2014; material icon named "account box rounded".
  static const IconData account_box_rounded = IconData(0xf03d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_box</i> &#x2014; material icon named "account box sharp".
  static const IconData account_box_sharp = IconData(0xeb0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_circle</i> &#x2014; material icon named "account circle".
  static const IconData account_circle = IconData(0xe563, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_circle</i> &#x2014; material icon named "account circle outlined".
  static const IconData account_circle_outlined = IconData(0xe010, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_circle</i> &#x2014; material icon named "account circle rounded".
  static const IconData account_circle_rounded = IconData(0xf03e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_circle</i> &#x2014; material icon named "account circle sharp".
  static const IconData account_circle_sharp = IconData(0xeb10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_tree</i> &#x2014; material icon named "account tree".
  static const IconData account_tree = IconData(0xe564, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_tree</i> &#x2014; material icon named "account tree outlined".
  static const IconData account_tree_outlined = IconData(0xe011, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_tree</i> &#x2014; material icon named "account tree rounded".
  static const IconData account_tree_rounded = IconData(0xf03f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_tree</i> &#x2014; material icon named "account tree sharp".
  static const IconData account_tree_sharp = IconData(0xeb11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ad_units</i> &#x2014; material icon named "ad units".
  static const IconData ad_units = IconData(0xe565, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ad_units</i> &#x2014; material icon named "ad units outlined".
  static const IconData ad_units_outlined = IconData(0xe012, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ad_units</i> &#x2014; material icon named "ad units rounded".
  static const IconData ad_units_rounded = IconData(0xf040, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ad_units</i> &#x2014; material icon named "ad units sharp".
  static const IconData ad_units_sharp = IconData(0xeb12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">adb</i> &#x2014; material icon named "adb".
  static const IconData adb = IconData(0xe566, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">adb</i> &#x2014; material icon named "adb outlined".
  static const IconData adb_outlined = IconData(0xe013, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">adb</i> &#x2014; material icon named "adb rounded".
  static const IconData adb_rounded = IconData(0xf041, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">adb</i> &#x2014; material icon named "adb sharp".
  static const IconData adb_sharp = IconData(0xeb13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add</i> &#x2014; material icon named "add".
  static const IconData add = IconData(0xe567, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_a_photo</i> &#x2014; material icon named "add a photo".
  static const IconData add_a_photo = IconData(0xe568, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_a_photo</i> &#x2014; material icon named "add a photo outlined".
  static const IconData add_a_photo_outlined = IconData(0xe014, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_a_photo</i> &#x2014; material icon named "add a photo rounded".
  static const IconData add_a_photo_rounded = IconData(0xf042, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_a_photo</i> &#x2014; material icon named "add a photo sharp".
  static const IconData add_a_photo_sharp = IconData(0xeb14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_alarm</i> &#x2014; material icon named "add alarm".
  static const IconData add_alarm = IconData(0xe569, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_alarm</i> &#x2014; material icon named "add alarm outlined".
  static const IconData add_alarm_outlined = IconData(0xe015, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_alarm</i> &#x2014; material icon named "add alarm rounded".
  static const IconData add_alarm_rounded = IconData(0xf043, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_alarm</i> &#x2014; material icon named "add alarm sharp".
  static const IconData add_alarm_sharp = IconData(0xeb15, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_alert</i> &#x2014; material icon named "add alert".
  static const IconData add_alert = IconData(0xe56a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_alert</i> &#x2014; material icon named "add alert outlined".
  static const IconData add_alert_outlined = IconData(0xe016, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_alert</i> &#x2014; material icon named "add alert rounded".
  static const IconData add_alert_rounded = IconData(0xf044, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_alert</i> &#x2014; material icon named "add alert sharp".
  static const IconData add_alert_sharp = IconData(0xeb16, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_box</i> &#x2014; material icon named "add box".
  static const IconData add_box = IconData(0xe56b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_box</i> &#x2014; material icon named "add box outlined".
  static const IconData add_box_outlined = IconData(0xe017, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_box</i> &#x2014; material icon named "add box rounded".
  static const IconData add_box_rounded = IconData(0xf045, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_box</i> &#x2014; material icon named "add box sharp".
  static const IconData add_box_sharp = IconData(0xeb17, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_business</i> &#x2014; material icon named "add business".
  static const IconData add_business = IconData(0xe56c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_business</i> &#x2014; material icon named "add business outlined".
  static const IconData add_business_outlined = IconData(0xe018, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_business</i> &#x2014; material icon named "add business rounded".
  static const IconData add_business_rounded = IconData(0xf046, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_business</i> &#x2014; material icon named "add business sharp".
  static const IconData add_business_sharp = IconData(0xeb18, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_call</i> &#x2014; material icon named "add call".
  static const IconData add_call = IconData(0xe56d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_chart</i> &#x2014; material icon named "add chart".
  static const IconData add_chart = IconData(0xe56e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_circle</i> &#x2014; material icon named "add circle".
  static const IconData add_circle = IconData(0xe56f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_circle_outline</i> &#x2014; material icon named "add circle outline".
  static const IconData add_circle_outline = IconData(0xe570, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_circle_outline</i> &#x2014; material icon named "add circle outline outlined".
  static const IconData add_circle_outline_outlined = IconData(0xe019, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_circle_outline</i> &#x2014; material icon named "add circle outline rounded".
  static const IconData add_circle_outline_rounded = IconData(0xf047, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_circle_outline</i> &#x2014; material icon named "add circle outline sharp".
  static const IconData add_circle_outline_sharp = IconData(0xeb19, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_circle</i> &#x2014; material icon named "add circle outlined".
  static const IconData add_circle_outlined = IconData(0xe01a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_circle</i> &#x2014; material icon named "add circle rounded".
  static const IconData add_circle_rounded = IconData(0xf048, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_circle</i> &#x2014; material icon named "add circle sharp".
  static const IconData add_circle_sharp = IconData(0xeb1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_comment</i> &#x2014; material icon named "add comment".
  static const IconData add_comment = IconData(0xe571, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_comment</i> &#x2014; material icon named "add comment outlined".
  static const IconData add_comment_outlined = IconData(0xe01b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_comment</i> &#x2014; material icon named "add comment rounded".
  static const IconData add_comment_rounded = IconData(0xf049, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_comment</i> &#x2014; material icon named "add comment sharp".
  static const IconData add_comment_sharp = IconData(0xeb1b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_ic_call</i> &#x2014; material icon named "add ic call".
  static const IconData add_ic_call = IconData(0xe572, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_ic_call</i> &#x2014; material icon named "add ic call outlined".
  static const IconData add_ic_call_outlined = IconData(0xe01c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_ic_call</i> &#x2014; material icon named "add ic call rounded".
  static const IconData add_ic_call_rounded = IconData(0xf04a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_ic_call</i> &#x2014; material icon named "add ic call sharp".
  static const IconData add_ic_call_sharp = IconData(0xeb1c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_link</i> &#x2014; material icon named "add link".
  static const IconData add_link = IconData(0xe573, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_location</i> &#x2014; material icon named "add location".
  static const IconData add_location = IconData(0xe574, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_location_alt</i> &#x2014; material icon named "add location alt".
  static const IconData add_location_alt = IconData(0xe575, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_location_alt</i> &#x2014; material icon named "add location alt outlined".
  static const IconData add_location_alt_outlined = IconData(0xe01d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_location_alt</i> &#x2014; material icon named "add location alt rounded".
  static const IconData add_location_alt_rounded = IconData(0xf04b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_location_alt</i> &#x2014; material icon named "add location alt sharp".
  static const IconData add_location_alt_sharp = IconData(0xeb1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_location</i> &#x2014; material icon named "add location outlined".
  static const IconData add_location_outlined = IconData(0xe01e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_location</i> &#x2014; material icon named "add location rounded".
  static const IconData add_location_rounded = IconData(0xf04c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_location</i> &#x2014; material icon named "add location sharp".
  static const IconData add_location_sharp = IconData(0xeb1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_moderator</i> &#x2014; material icon named "add moderator".
  static const IconData add_moderator = IconData(0xe576, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add</i> &#x2014; material icon named "add outlined".
  static const IconData add_outlined = IconData(0xe01f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_photo_alternate</i> &#x2014; material icon named "add photo alternate".
  static const IconData add_photo_alternate = IconData(0xe577, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_photo_alternate</i> &#x2014; material icon named "add photo alternate outlined".
  static const IconData add_photo_alternate_outlined = IconData(0xe020, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_photo_alternate</i> &#x2014; material icon named "add photo alternate rounded".
  static const IconData add_photo_alternate_rounded = IconData(0xf04d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_photo_alternate</i> &#x2014; material icon named "add photo alternate sharp".
  static const IconData add_photo_alternate_sharp = IconData(0xeb1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_road</i> &#x2014; material icon named "add road".
  static const IconData add_road = IconData(0xe578, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_road</i> &#x2014; material icon named "add road outlined".
  static const IconData add_road_outlined = IconData(0xe021, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_road</i> &#x2014; material icon named "add road rounded".
  static const IconData add_road_rounded = IconData(0xf04e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_road</i> &#x2014; material icon named "add road sharp".
  static const IconData add_road_sharp = IconData(0xeb20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add</i> &#x2014; material icon named "add rounded".
  static const IconData add_rounded = IconData(0xf04f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add</i> &#x2014; material icon named "add sharp".
  static const IconData add_sharp = IconData(0xeb21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_shopping_cart</i> &#x2014; material icon named "add shopping cart".
  static const IconData add_shopping_cart = IconData(0xe579, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_shopping_cart</i> &#x2014; material icon named "add shopping cart outlined".
  static const IconData add_shopping_cart_outlined = IconData(0xe022, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_shopping_cart</i> &#x2014; material icon named "add shopping cart rounded".
  static const IconData add_shopping_cart_rounded = IconData(0xf050, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_shopping_cart</i> &#x2014; material icon named "add shopping cart sharp".
  static const IconData add_shopping_cart_sharp = IconData(0xeb22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_drive</i> &#x2014; material icon named "add to drive".
  static const IconData add_to_drive = IconData(0xe57a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_home_screen</i> &#x2014; material icon named "add to home screen".
  static const IconData add_to_home_screen = IconData(0xe57b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_to_home_screen</i> &#x2014; material icon named "add to home screen outlined".
  static const IconData add_to_home_screen_outlined = IconData(0xe023, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_to_home_screen</i> &#x2014; material icon named "add to home screen rounded".
  static const IconData add_to_home_screen_rounded = IconData(0xf051, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_to_home_screen</i> &#x2014; material icon named "add to home screen sharp".
  static const IconData add_to_home_screen_sharp = IconData(0xeb23, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_photos</i> &#x2014; material icon named "add to photos".
  static const IconData add_to_photos = IconData(0xe57c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_to_photos</i> &#x2014; material icon named "add to photos outlined".
  static const IconData add_to_photos_outlined = IconData(0xe024, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_to_photos</i> &#x2014; material icon named "add to photos rounded".
  static const IconData add_to_photos_rounded = IconData(0xf052, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_to_photos</i> &#x2014; material icon named "add to photos sharp".
  static const IconData add_to_photos_sharp = IconData(0xeb24, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_queue</i> &#x2014; material icon named "add to queue".
  static const IconData add_to_queue = IconData(0xe57d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_to_queue</i> &#x2014; material icon named "add to queue outlined".
  static const IconData add_to_queue_outlined = IconData(0xe025, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_to_queue</i> &#x2014; material icon named "add to queue rounded".
  static const IconData add_to_queue_rounded = IconData(0xf053, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_to_queue</i> &#x2014; material icon named "add to queue sharp".
  static const IconData add_to_queue_sharp = IconData(0xeb25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">addchart</i> &#x2014; material icon named "addchart".
  static const IconData addchart = IconData(0xe57e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">addchart</i> &#x2014; material icon named "addchart outlined".
  static const IconData addchart_outlined = IconData(0xe026, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">addchart</i> &#x2014; material icon named "addchart rounded".
  static const IconData addchart_rounded = IconData(0xf054, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">addchart</i> &#x2014; material icon named "addchart sharp".
  static const IconData addchart_sharp = IconData(0xeb26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">adjust</i> &#x2014; material icon named "adjust".
  static const IconData adjust = IconData(0xe57f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">adjust</i> &#x2014; material icon named "adjust outlined".
  static const IconData adjust_outlined = IconData(0xe027, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">adjust</i> &#x2014; material icon named "adjust rounded".
  static const IconData adjust_rounded = IconData(0xf055, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">adjust</i> &#x2014; material icon named "adjust sharp".
  static const IconData adjust_sharp = IconData(0xeb27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">admin_panel_settings</i> &#x2014; material icon named "admin panel settings".
  static const IconData admin_panel_settings = IconData(0xe580, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">admin_panel_settings</i> &#x2014; material icon named "admin panel settings outlined".
  static const IconData admin_panel_settings_outlined = IconData(0xe028, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">admin_panel_settings</i> &#x2014; material icon named "admin panel settings rounded".
  static const IconData admin_panel_settings_rounded = IconData(0xf056, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">admin_panel_settings</i> &#x2014; material icon named "admin panel settings sharp".
  static const IconData admin_panel_settings_sharp = IconData(0xeb28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">agriculture</i> &#x2014; material icon named "agriculture".
  static const IconData agriculture = IconData(0xe581, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">agriculture</i> &#x2014; material icon named "agriculture outlined".
  static const IconData agriculture_outlined = IconData(0xe029, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">agriculture</i> &#x2014; material icon named "agriculture rounded".
  static const IconData agriculture_rounded = IconData(0xf057, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">agriculture</i> &#x2014; material icon named "agriculture sharp".
  static const IconData agriculture_sharp = IconData(0xeb29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_flat</i> &#x2014; material icon named "airline seat flat".
  static const IconData airline_seat_flat = IconData(0xe582, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_flat_angled</i> &#x2014; material icon named "airline seat flat angled".
  static const IconData airline_seat_flat_angled = IconData(0xe583, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_flat_angled</i> &#x2014; material icon named "airline seat flat angled outlined".
  static const IconData airline_seat_flat_angled_outlined = IconData(0xe02a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_flat_angled</i> &#x2014; material icon named "airline seat flat angled rounded".
  static const IconData airline_seat_flat_angled_rounded = IconData(0xf058, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_flat_angled</i> &#x2014; material icon named "airline seat flat angled sharp".
  static const IconData airline_seat_flat_angled_sharp = IconData(0xeb2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_flat</i> &#x2014; material icon named "airline seat flat outlined".
  static const IconData airline_seat_flat_outlined = IconData(0xe02b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_flat</i> &#x2014; material icon named "airline seat flat rounded".
  static const IconData airline_seat_flat_rounded = IconData(0xf059, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_flat</i> &#x2014; material icon named "airline seat flat sharp".
  static const IconData airline_seat_flat_sharp = IconData(0xeb2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_individual_suite</i> &#x2014; material icon named "airline seat individual suite".
  static const IconData airline_seat_individual_suite = IconData(0xe584, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_individual_suite</i> &#x2014; material icon named "airline seat individual suite outlined".
  static const IconData airline_seat_individual_suite_outlined = IconData(0xe02c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_individual_suite</i> &#x2014; material icon named "airline seat individual suite rounded".
  static const IconData airline_seat_individual_suite_rounded = IconData(0xf05a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_individual_suite</i> &#x2014; material icon named "airline seat individual suite sharp".
  static const IconData airline_seat_individual_suite_sharp = IconData(0xeb2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_legroom_extra</i> &#x2014; material icon named "airline seat legroom extra".
  static const IconData airline_seat_legroom_extra = IconData(0xe585, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_legroom_extra</i> &#x2014; material icon named "airline seat legroom extra outlined".
  static const IconData airline_seat_legroom_extra_outlined = IconData(0xe02d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_legroom_extra</i> &#x2014; material icon named "airline seat legroom extra rounded".
  static const IconData airline_seat_legroom_extra_rounded = IconData(0xf05b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_legroom_extra</i> &#x2014; material icon named "airline seat legroom extra sharp".
  static const IconData airline_seat_legroom_extra_sharp = IconData(0xeb2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_legroom_normal</i> &#x2014; material icon named "airline seat legroom normal".
  static const IconData airline_seat_legroom_normal = IconData(0xe586, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_legroom_normal</i> &#x2014; material icon named "airline seat legroom normal outlined".
  static const IconData airline_seat_legroom_normal_outlined = IconData(0xe02e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_legroom_normal</i> &#x2014; material icon named "airline seat legroom normal rounded".
  static const IconData airline_seat_legroom_normal_rounded = IconData(0xf05c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_legroom_normal</i> &#x2014; material icon named "airline seat legroom normal sharp".
  static const IconData airline_seat_legroom_normal_sharp = IconData(0xeb2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_legroom_reduced</i> &#x2014; material icon named "airline seat legroom reduced".
  static const IconData airline_seat_legroom_reduced = IconData(0xe587, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_legroom_reduced</i> &#x2014; material icon named "airline seat legroom reduced outlined".
  static const IconData airline_seat_legroom_reduced_outlined = IconData(0xe02f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_legroom_reduced</i> &#x2014; material icon named "airline seat legroom reduced rounded".
  static const IconData airline_seat_legroom_reduced_rounded = IconData(0xf05d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_legroom_reduced</i> &#x2014; material icon named "airline seat legroom reduced sharp".
  static const IconData airline_seat_legroom_reduced_sharp = IconData(0xeb2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_recline_extra</i> &#x2014; material icon named "airline seat recline extra".
  static const IconData airline_seat_recline_extra = IconData(0xe588, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_recline_extra</i> &#x2014; material icon named "airline seat recline extra outlined".
  static const IconData airline_seat_recline_extra_outlined = IconData(0xe030, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_recline_extra</i> &#x2014; material icon named "airline seat recline extra rounded".
  static const IconData airline_seat_recline_extra_rounded = IconData(0xf05e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_recline_extra</i> &#x2014; material icon named "airline seat recline extra sharp".
  static const IconData airline_seat_recline_extra_sharp = IconData(0xeb30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_recline_normal</i> &#x2014; material icon named "airline seat recline normal".
  static const IconData airline_seat_recline_normal = IconData(0xe589, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_recline_normal</i> &#x2014; material icon named "airline seat recline normal outlined".
  static const IconData airline_seat_recline_normal_outlined = IconData(0xe031, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_recline_normal</i> &#x2014; material icon named "airline seat recline normal rounded".
  static const IconData airline_seat_recline_normal_rounded = IconData(0xf05f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_recline_normal</i> &#x2014; material icon named "airline seat recline normal sharp".
  static const IconData airline_seat_recline_normal_sharp = IconData(0xeb31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_active</i> &#x2014; material icon named "airplanemode active".
  static const IconData airplanemode_active = IconData(0xe58a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplanemode_active</i> &#x2014; material icon named "airplanemode active outlined".
  static const IconData airplanemode_active_outlined = IconData(0xe032, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplanemode_active</i> &#x2014; material icon named "airplanemode active rounded".
  static const IconData airplanemode_active_rounded = IconData(0xf060, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplanemode_active</i> &#x2014; material icon named "airplanemode active sharp".
  static const IconData airplanemode_active_sharp = IconData(0xeb32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_inactive</i> &#x2014; material icon named "airplanemode inactive".
  static const IconData airplanemode_inactive = IconData(0xe58b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplanemode_inactive</i> &#x2014; material icon named "airplanemode inactive outlined".
  static const IconData airplanemode_inactive_outlined = IconData(0xe033, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplanemode_inactive</i> &#x2014; material icon named "airplanemode inactive rounded".
  static const IconData airplanemode_inactive_rounded = IconData(0xf061, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplanemode_inactive</i> &#x2014; material icon named "airplanemode inactive sharp".
  static const IconData airplanemode_inactive_sharp = IconData(0xeb33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_off</i> &#x2014; material icon named "airplanemode off".
  static const IconData airplanemode_off = IconData(0xe58b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplanemode_off</i> &#x2014; material icon named "airplanemode off outlined".
  static const IconData airplanemode_off_outlined = IconData(0xe033, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplanemode_off</i> &#x2014; material icon named "airplanemode off rounded".
  static const IconData airplanemode_off_rounded = IconData(0xf061, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplanemode_off</i> &#x2014; material icon named "airplanemode off sharp".
  static const IconData airplanemode_off_sharp = IconData(0xeb33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_on</i> &#x2014; material icon named "airplanemode on".
  static const IconData airplanemode_on = IconData(0xe58a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplanemode_on</i> &#x2014; material icon named "airplanemode on outlined".
  static const IconData airplanemode_on_outlined = IconData(0xe032, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplanemode_on</i> &#x2014; material icon named "airplanemode on rounded".
  static const IconData airplanemode_on_rounded = IconData(0xf060, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplanemode_on</i> &#x2014; material icon named "airplanemode on sharp".
  static const IconData airplanemode_on_sharp = IconData(0xeb32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplay</i> &#x2014; material icon named "airplay".
  static const IconData airplay = IconData(0xe58c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplay</i> &#x2014; material icon named "airplay outlined".
  static const IconData airplay_outlined = IconData(0xe034, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplay</i> &#x2014; material icon named "airplay rounded".
  static const IconData airplay_rounded = IconData(0xf062, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplay</i> &#x2014; material icon named "airplay sharp".
  static const IconData airplay_sharp = IconData(0xeb34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airport_shuttle</i> &#x2014; material icon named "airport shuttle".
  static const IconData airport_shuttle = IconData(0xe58d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airport_shuttle</i> &#x2014; material icon named "airport shuttle outlined".
  static const IconData airport_shuttle_outlined = IconData(0xe035, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airport_shuttle</i> &#x2014; material icon named "airport shuttle rounded".
  static const IconData airport_shuttle_rounded = IconData(0xf063, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airport_shuttle</i> &#x2014; material icon named "airport shuttle sharp".
  static const IconData airport_shuttle_sharp = IconData(0xeb35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm</i> &#x2014; material icon named "alarm".
  static const IconData alarm = IconData(0xe58e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm_add</i> &#x2014; material icon named "alarm add".
  static const IconData alarm_add = IconData(0xe58f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alarm_add</i> &#x2014; material icon named "alarm add outlined".
  static const IconData alarm_add_outlined = IconData(0xe036, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alarm_add</i> &#x2014; material icon named "alarm add rounded".
  static const IconData alarm_add_rounded = IconData(0xf064, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alarm_add</i> &#x2014; material icon named "alarm add sharp".
  static const IconData alarm_add_sharp = IconData(0xeb36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm_off</i> &#x2014; material icon named "alarm off".
  static const IconData alarm_off = IconData(0xe590, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alarm_off</i> &#x2014; material icon named "alarm off outlined".
  static const IconData alarm_off_outlined = IconData(0xe037, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alarm_off</i> &#x2014; material icon named "alarm off rounded".
  static const IconData alarm_off_rounded = IconData(0xf065, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alarm_off</i> &#x2014; material icon named "alarm off sharp".
  static const IconData alarm_off_sharp = IconData(0xeb37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm_on</i> &#x2014; material icon named "alarm on".
  static const IconData alarm_on = IconData(0xe591, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alarm_on</i> &#x2014; material icon named "alarm on outlined".
  static const IconData alarm_on_outlined = IconData(0xe038, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alarm_on</i> &#x2014; material icon named "alarm on rounded".
  static const IconData alarm_on_rounded = IconData(0xf066, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alarm_on</i> &#x2014; material icon named "alarm on sharp".
  static const IconData alarm_on_sharp = IconData(0xeb38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alarm</i> &#x2014; material icon named "alarm outlined".
  static const IconData alarm_outlined = IconData(0xe039, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alarm</i> &#x2014; material icon named "alarm rounded".
  static const IconData alarm_rounded = IconData(0xf067, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alarm</i> &#x2014; material icon named "alarm sharp".
  static const IconData alarm_sharp = IconData(0xeb39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">album</i> &#x2014; material icon named "album".
  static const IconData album = IconData(0xe592, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">album</i> &#x2014; material icon named "album outlined".
  static const IconData album_outlined = IconData(0xe03a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">album</i> &#x2014; material icon named "album rounded".
  static const IconData album_rounded = IconData(0xf068, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">album</i> &#x2014; material icon named "album sharp".
  static const IconData album_sharp = IconData(0xeb3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">all_inbox</i> &#x2014; material icon named "all inbox".
  static const IconData all_inbox = IconData(0xe593, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">all_inbox</i> &#x2014; material icon named "all inbox outlined".
  static const IconData all_inbox_outlined = IconData(0xe03b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">all_inbox</i> &#x2014; material icon named "all inbox rounded".
  static const IconData all_inbox_rounded = IconData(0xf069, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">all_inbox</i> &#x2014; material icon named "all inbox sharp".
  static const IconData all_inbox_sharp = IconData(0xeb3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">all_inclusive</i> &#x2014; material icon named "all inclusive".
  static const IconData all_inclusive = IconData(0xe594, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">all_inclusive</i> &#x2014; material icon named "all inclusive outlined".
  static const IconData all_inclusive_outlined = IconData(0xe03c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">all_inclusive</i> &#x2014; material icon named "all inclusive rounded".
  static const IconData all_inclusive_rounded = IconData(0xf06a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">all_inclusive</i> &#x2014; material icon named "all inclusive sharp".
  static const IconData all_inclusive_sharp = IconData(0xeb3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">all_out</i> &#x2014; material icon named "all out".
  static const IconData all_out = IconData(0xe595, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">all_out</i> &#x2014; material icon named "all out outlined".
  static const IconData all_out_outlined = IconData(0xe03d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">all_out</i> &#x2014; material icon named "all out rounded".
  static const IconData all_out_rounded = IconData(0xf06b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">all_out</i> &#x2014; material icon named "all out sharp".
  static const IconData all_out_sharp = IconData(0xeb3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alt_route</i> &#x2014; material icon named "alt route".
  static const IconData alt_route = IconData(0xe596, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alt_route</i> &#x2014; material icon named "alt route outlined".
  static const IconData alt_route_outlined = IconData(0xe03e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alt_route</i> &#x2014; material icon named "alt route rounded".
  static const IconData alt_route_rounded = IconData(0xf06c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alt_route</i> &#x2014; material icon named "alt route sharp".
  static const IconData alt_route_sharp = IconData(0xeb3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alternate_email</i> &#x2014; material icon named "alternate email".
  static const IconData alternate_email = IconData(0xe597, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alternate_email</i> &#x2014; material icon named "alternate email outlined".
  static const IconData alternate_email_outlined = IconData(0xe03f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alternate_email</i> &#x2014; material icon named "alternate email rounded".
  static const IconData alternate_email_rounded = IconData(0xf06d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alternate_email</i> &#x2014; material icon named "alternate email sharp".
  static const IconData alternate_email_sharp = IconData(0xeb3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">amp_stories</i> &#x2014; material icon named "amp stories".
  static const IconData amp_stories = IconData(0xe598, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">amp_stories</i> &#x2014; material icon named "amp stories outlined".
  static const IconData amp_stories_outlined = IconData(0xe040, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">amp_stories</i> &#x2014; material icon named "amp stories rounded".
  static const IconData amp_stories_rounded = IconData(0xf06e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">amp_stories</i> &#x2014; material icon named "amp stories sharp".
  static const IconData amp_stories_sharp = IconData(0xeb40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">analytics</i> &#x2014; material icon named "analytics".
  static const IconData analytics = IconData(0xe599, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">analytics</i> &#x2014; material icon named "analytics outlined".
  static const IconData analytics_outlined = IconData(0xe041, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">analytics</i> &#x2014; material icon named "analytics rounded".
  static const IconData analytics_rounded = IconData(0xf06f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">analytics</i> &#x2014; material icon named "analytics sharp".
  static const IconData analytics_sharp = IconData(0xeb41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">anchor</i> &#x2014; material icon named "anchor".
  static const IconData anchor = IconData(0xe59a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">anchor</i> &#x2014; material icon named "anchor outlined".
  static const IconData anchor_outlined = IconData(0xe042, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">anchor</i> &#x2014; material icon named "anchor rounded".
  static const IconData anchor_rounded = IconData(0xf070, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">anchor</i> &#x2014; material icon named "anchor sharp".
  static const IconData anchor_sharp = IconData(0xeb42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">android</i> &#x2014; material icon named "android".
  static const IconData android = IconData(0xe59b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">android</i> &#x2014; material icon named "android outlined".
  static const IconData android_outlined = IconData(0xe043, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">android</i> &#x2014; material icon named "android rounded".
  static const IconData android_rounded = IconData(0xf071, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">android</i> &#x2014; material icon named "android sharp".
  static const IconData android_sharp = IconData(0xeb43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">animation</i> &#x2014; material icon named "animation".
  static const IconData animation = IconData(0xe59c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">announcement</i> &#x2014; material icon named "announcement".
  static const IconData announcement = IconData(0xe59d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">announcement</i> &#x2014; material icon named "announcement outlined".
  static const IconData announcement_outlined = IconData(0xe044, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">announcement</i> &#x2014; material icon named "announcement rounded".
  static const IconData announcement_rounded = IconData(0xf072, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">announcement</i> &#x2014; material icon named "announcement sharp".
  static const IconData announcement_sharp = IconData(0xeb44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">apartment</i> &#x2014; material icon named "apartment".
  static const IconData apartment = IconData(0xe59e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">apartment</i> &#x2014; material icon named "apartment outlined".
  static const IconData apartment_outlined = IconData(0xe045, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">apartment</i> &#x2014; material icon named "apartment rounded".
  static const IconData apartment_rounded = IconData(0xf073, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">apartment</i> &#x2014; material icon named "apartment sharp".
  static const IconData apartment_sharp = IconData(0xeb45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">api</i> &#x2014; material icon named "api".
  static const IconData api = IconData(0xe59f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">api</i> &#x2014; material icon named "api outlined".
  static const IconData api_outlined = IconData(0xe046, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">api</i> &#x2014; material icon named "api rounded".
  static const IconData api_rounded = IconData(0xf074, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">api</i> &#x2014; material icon named "api sharp".
  static const IconData api_sharp = IconData(0xeb46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">app_blocking</i> &#x2014; material icon named "app blocking".
  static const IconData app_blocking = IconData(0xe5a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">app_blocking</i> &#x2014; material icon named "app blocking outlined".
  static const IconData app_blocking_outlined = IconData(0xe047, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">app_blocking</i> &#x2014; material icon named "app blocking rounded".
  static const IconData app_blocking_rounded = IconData(0xf075, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">app_blocking</i> &#x2014; material icon named "app blocking sharp".
  static const IconData app_blocking_sharp = IconData(0xeb47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">app_registration</i> &#x2014; material icon named "app registration".
  static const IconData app_registration = IconData(0xe5a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">app_settings_alt</i> &#x2014; material icon named "app settings alt".
  static const IconData app_settings_alt = IconData(0xe5a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">app_settings_alt</i> &#x2014; material icon named "app settings alt outlined".
  static const IconData app_settings_alt_outlined = IconData(0xe048, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">app_settings_alt</i> &#x2014; material icon named "app settings alt rounded".
  static const IconData app_settings_alt_rounded = IconData(0xf076, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">app_settings_alt</i> &#x2014; material icon named "app settings alt sharp".
  static const IconData app_settings_alt_sharp = IconData(0xeb48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">approval</i> &#x2014; material icon named "approval".
  static const IconData approval = IconData(0xe5a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">apps</i> &#x2014; material icon named "apps".
  static const IconData apps = IconData(0xe5a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">apps</i> &#x2014; material icon named "apps outlined".
  static const IconData apps_outlined = IconData(0xe049, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">apps</i> &#x2014; material icon named "apps rounded".
  static const IconData apps_rounded = IconData(0xf077, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">apps</i> &#x2014; material icon named "apps sharp".
  static const IconData apps_sharp = IconData(0xeb49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">architecture</i> &#x2014; material icon named "architecture".
  static const IconData architecture = IconData(0xe5a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">architecture</i> &#x2014; material icon named "architecture outlined".
  static const IconData architecture_outlined = IconData(0xe04a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">architecture</i> &#x2014; material icon named "architecture rounded".
  static const IconData architecture_rounded = IconData(0xf078, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">architecture</i> &#x2014; material icon named "architecture sharp".
  static const IconData architecture_sharp = IconData(0xeb4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">archive</i> &#x2014; material icon named "archive".
  static const IconData archive = IconData(0xe5a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">archive</i> &#x2014; material icon named "archive outlined".
  static const IconData archive_outlined = IconData(0xe04b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">archive</i> &#x2014; material icon named "archive rounded".
  static const IconData archive_rounded = IconData(0xf079, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">archive</i> &#x2014; material icon named "archive sharp".
  static const IconData archive_sharp = IconData(0xeb4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_back</i> &#x2014; material icon named "arrow back".
  static const IconData arrow_back = IconData(0xe5a7, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios".
  static const IconData arrow_back_ios = IconData(0xe5a8, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios outlined".
  static const IconData arrow_back_ios_outlined = IconData(0xe04c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios rounded".
  static const IconData arrow_back_ios_rounded = IconData(0xf07a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios sharp".
  static const IconData arrow_back_ios_sharp = IconData(0xeb4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_back</i> &#x2014; material icon named "arrow back outlined".
  static const IconData arrow_back_outlined = IconData(0xe04d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_back</i> &#x2014; material icon named "arrow back rounded".
  static const IconData arrow_back_rounded = IconData(0xf07b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_back</i> &#x2014; material icon named "arrow back sharp".
  static const IconData arrow_back_sharp = IconData(0xeb4d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_circle_down</i> &#x2014; material icon named "arrow circle down".
  static const IconData arrow_circle_down = IconData(0xe5a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_circle_down</i> &#x2014; material icon named "arrow circle down outlined".
  static const IconData arrow_circle_down_outlined = IconData(0xe04e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_circle_down</i> &#x2014; material icon named "arrow circle down rounded".
  static const IconData arrow_circle_down_rounded = IconData(0xf07c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_circle_down</i> &#x2014; material icon named "arrow circle down sharp".
  static const IconData arrow_circle_down_sharp = IconData(0xeb4e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_circle_up</i> &#x2014; material icon named "arrow circle up".
  static const IconData arrow_circle_up = IconData(0xe5aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_circle_up</i> &#x2014; material icon named "arrow circle up outlined".
  static const IconData arrow_circle_up_outlined = IconData(0xe04f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_circle_up</i> &#x2014; material icon named "arrow circle up rounded".
  static const IconData arrow_circle_up_rounded = IconData(0xf07d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_circle_up</i> &#x2014; material icon named "arrow circle up sharp".
  static const IconData arrow_circle_up_sharp = IconData(0xeb4f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_downward</i> &#x2014; material icon named "arrow downward".
  static const IconData arrow_downward = IconData(0xe5ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_downward</i> &#x2014; material icon named "arrow downward outlined".
  static const IconData arrow_downward_outlined = IconData(0xe050, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_downward</i> &#x2014; material icon named "arrow downward rounded".
  static const IconData arrow_downward_rounded = IconData(0xf07e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_downward</i> &#x2014; material icon named "arrow downward sharp".
  static const IconData arrow_downward_sharp = IconData(0xeb50, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_drop_down</i> &#x2014; material icon named "arrow drop down".
  static const IconData arrow_drop_down = IconData(0xe5ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_drop_down_circle</i> &#x2014; material icon named "arrow drop down circle".
  static const IconData arrow_drop_down_circle = IconData(0xe5ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_drop_down_circle</i> &#x2014; material icon named "arrow drop down circle outlined".
  static const IconData arrow_drop_down_circle_outlined = IconData(0xe051, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_drop_down_circle</i> &#x2014; material icon named "arrow drop down circle rounded".
  static const IconData arrow_drop_down_circle_rounded = IconData(0xf07f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_drop_down_circle</i> &#x2014; material icon named "arrow drop down circle sharp".
  static const IconData arrow_drop_down_circle_sharp = IconData(0xeb51, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_drop_down</i> &#x2014; material icon named "arrow drop down outlined".
  static const IconData arrow_drop_down_outlined = IconData(0xe052, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_drop_down</i> &#x2014; material icon named "arrow drop down rounded".
  static const IconData arrow_drop_down_rounded = IconData(0xf080, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_drop_down</i> &#x2014; material icon named "arrow drop down sharp".
  static const IconData arrow_drop_down_sharp = IconData(0xeb52, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_drop_up</i> &#x2014; material icon named "arrow drop up".
  static const IconData arrow_drop_up = IconData(0xe5ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_drop_up</i> &#x2014; material icon named "arrow drop up outlined".
  static const IconData arrow_drop_up_outlined = IconData(0xe053, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_drop_up</i> &#x2014; material icon named "arrow drop up rounded".
  static const IconData arrow_drop_up_rounded = IconData(0xf081, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_drop_up</i> &#x2014; material icon named "arrow drop up sharp".
  static const IconData arrow_drop_up_sharp = IconData(0xeb53, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_forward</i> &#x2014; material icon named "arrow forward".
  static const IconData arrow_forward = IconData(0xe5af, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios".
  static const IconData arrow_forward_ios = IconData(0xe5b0, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios outlined".
  static const IconData arrow_forward_ios_outlined = IconData(0xe054, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios rounded".
  static const IconData arrow_forward_ios_rounded = IconData(0xf082, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios sharp".
  static const IconData arrow_forward_ios_sharp = IconData(0xeb54, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_forward</i> &#x2014; material icon named "arrow forward outlined".
  static const IconData arrow_forward_outlined = IconData(0xe055, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_forward</i> &#x2014; material icon named "arrow forward rounded".
  static const IconData arrow_forward_rounded = IconData(0xf083, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_forward</i> &#x2014; material icon named "arrow forward sharp".
  static const IconData arrow_forward_sharp = IconData(0xeb55, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_left</i> &#x2014; material icon named "arrow left".
  static const IconData arrow_left = IconData(0xe5b1, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">arrow_left</i> &#x2014; material icon named "arrow left outlined".
  static const IconData arrow_left_outlined = IconData(0xe056, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_left</i> &#x2014; material icon named "arrow left rounded".
  static const IconData arrow_left_rounded = IconData(0xf084, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_left</i> &#x2014; material icon named "arrow left sharp".
  static const IconData arrow_left_sharp = IconData(0xeb56, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_right</i> &#x2014; material icon named "arrow right".
  static const IconData arrow_right = IconData(0xe5b2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_right_alt</i> &#x2014; material icon named "arrow right alt".
  static const IconData arrow_right_alt = IconData(0xe5b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_right_alt</i> &#x2014; material icon named "arrow right alt outlined".
  static const IconData arrow_right_alt_outlined = IconData(0xe057, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_right_alt</i> &#x2014; material icon named "arrow right alt rounded".
  static const IconData arrow_right_alt_rounded = IconData(0xf085, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_right_alt</i> &#x2014; material icon named "arrow right alt sharp".
  static const IconData arrow_right_alt_sharp = IconData(0xeb57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_right</i> &#x2014; material icon named "arrow right outlined".
  static const IconData arrow_right_outlined = IconData(0xe058, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_right</i> &#x2014; material icon named "arrow right rounded".
  static const IconData arrow_right_rounded = IconData(0xf086, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_right</i> &#x2014; material icon named "arrow right sharp".
  static const IconData arrow_right_sharp = IconData(0xeb58, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_upward</i> &#x2014; material icon named "arrow upward".
  static const IconData arrow_upward = IconData(0xe5b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_upward</i> &#x2014; material icon named "arrow upward outlined".
  static const IconData arrow_upward_outlined = IconData(0xe059, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_upward</i> &#x2014; material icon named "arrow upward rounded".
  static const IconData arrow_upward_rounded = IconData(0xf087, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_upward</i> &#x2014; material icon named "arrow upward sharp".
  static const IconData arrow_upward_sharp = IconData(0xeb59, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">art_track</i> &#x2014; material icon named "art track".
  static const IconData art_track = IconData(0xe5b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">art_track</i> &#x2014; material icon named "art track outlined".
  static const IconData art_track_outlined = IconData(0xe05a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">art_track</i> &#x2014; material icon named "art track rounded".
  static const IconData art_track_rounded = IconData(0xf088, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">art_track</i> &#x2014; material icon named "art track sharp".
  static const IconData art_track_sharp = IconData(0xeb5a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">article</i> &#x2014; material icon named "article".
  static const IconData article = IconData(0xe5b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">article</i> &#x2014; material icon named "article outlined".
  static const IconData article_outlined = IconData(0xe05b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">article</i> &#x2014; material icon named "article rounded".
  static const IconData article_rounded = IconData(0xf089, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">article</i> &#x2014; material icon named "article sharp".
  static const IconData article_sharp = IconData(0xeb5b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">aspect_ratio</i> &#x2014; material icon named "aspect ratio".
  static const IconData aspect_ratio = IconData(0xe5b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">aspect_ratio</i> &#x2014; material icon named "aspect ratio outlined".
  static const IconData aspect_ratio_outlined = IconData(0xe05c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">aspect_ratio</i> &#x2014; material icon named "aspect ratio rounded".
  static const IconData aspect_ratio_rounded = IconData(0xf08a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">aspect_ratio</i> &#x2014; material icon named "aspect ratio sharp".
  static const IconData aspect_ratio_sharp = IconData(0xeb5c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assessment</i> &#x2014; material icon named "assessment".
  static const IconData assessment = IconData(0xe5b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assessment</i> &#x2014; material icon named "assessment outlined".
  static const IconData assessment_outlined = IconData(0xe05d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assessment</i> &#x2014; material icon named "assessment rounded".
  static const IconData assessment_rounded = IconData(0xf08b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assessment</i> &#x2014; material icon named "assessment sharp".
  static const IconData assessment_sharp = IconData(0xeb5d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment</i> &#x2014; material icon named "assignment".
  static const IconData assignment = IconData(0xe5b9, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">assignment_ind</i> &#x2014; material icon named "assignment ind".
  static const IconData assignment_ind = IconData(0xe5ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assignment_ind</i> &#x2014; material icon named "assignment ind outlined".
  static const IconData assignment_ind_outlined = IconData(0xe05e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment_ind</i> &#x2014; material icon named "assignment ind rounded".
  static const IconData assignment_ind_rounded = IconData(0xf08c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment_ind</i> &#x2014; material icon named "assignment ind sharp".
  static const IconData assignment_ind_sharp = IconData(0xeb5e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_late</i> &#x2014; material icon named "assignment late".
  static const IconData assignment_late = IconData(0xe5bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assignment_late</i> &#x2014; material icon named "assignment late outlined".
  static const IconData assignment_late_outlined = IconData(0xe05f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment_late</i> &#x2014; material icon named "assignment late rounded".
  static const IconData assignment_late_rounded = IconData(0xf08d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment_late</i> &#x2014; material icon named "assignment late sharp".
  static const IconData assignment_late_sharp = IconData(0xeb5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assignment</i> &#x2014; material icon named "assignment outlined".
  static const IconData assignment_outlined = IconData(0xe060, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_return</i> &#x2014; material icon named "assignment return".
  static const IconData assignment_return = IconData(0xe5bc, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">assignment_return</i> &#x2014; material icon named "assignment return outlined".
  static const IconData assignment_return_outlined = IconData(0xe061, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment_return</i> &#x2014; material icon named "assignment return rounded".
  static const IconData assignment_return_rounded = IconData(0xf08e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment_return</i> &#x2014; material icon named "assignment return sharp".
  static const IconData assignment_return_sharp = IconData(0xeb60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_returned</i> &#x2014; material icon named "assignment returned".
  static const IconData assignment_returned = IconData(0xe5bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assignment_returned</i> &#x2014; material icon named "assignment returned outlined".
  static const IconData assignment_returned_outlined = IconData(0xe062, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment_returned</i> &#x2014; material icon named "assignment returned rounded".
  static const IconData assignment_returned_rounded = IconData(0xf08f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment_returned</i> &#x2014; material icon named "assignment returned sharp".
  static const IconData assignment_returned_sharp = IconData(0xeb61, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment</i> &#x2014; material icon named "assignment rounded".
  static const IconData assignment_rounded = IconData(0xf090, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment</i> &#x2014; material icon named "assignment sharp".
  static const IconData assignment_sharp = IconData(0xeb62, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_turned_in</i> &#x2014; material icon named "assignment turned in".
  static const IconData assignment_turned_in = IconData(0xe5be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assignment_turned_in</i> &#x2014; material icon named "assignment turned in outlined".
  static const IconData assignment_turned_in_outlined = IconData(0xe063, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment_turned_in</i> &#x2014; material icon named "assignment turned in rounded".
  static const IconData assignment_turned_in_rounded = IconData(0xf091, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment_turned_in</i> &#x2014; material icon named "assignment turned in sharp".
  static const IconData assignment_turned_in_sharp = IconData(0xeb63, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant</i> &#x2014; material icon named "assistant".
  static const IconData assistant = IconData(0xe5bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant_direction</i> &#x2014; material icon named "assistant direction".
  static const IconData assistant_direction = IconData(0xe5c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant_navigation</i> &#x2014; material icon named "assistant navigation".
  static const IconData assistant_navigation = IconData(0xe5c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assistant</i> &#x2014; material icon named "assistant outlined".
  static const IconData assistant_outlined = IconData(0xe064, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant_photo</i> &#x2014; material icon named "assistant photo".
  static const IconData assistant_photo = IconData(0xe5c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assistant_photo</i> &#x2014; material icon named "assistant photo outlined".
  static const IconData assistant_photo_outlined = IconData(0xe065, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assistant_photo</i> &#x2014; material icon named "assistant photo rounded".
  static const IconData assistant_photo_rounded = IconData(0xf092, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assistant_photo</i> &#x2014; material icon named "assistant photo sharp".
  static const IconData assistant_photo_sharp = IconData(0xeb64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assistant</i> &#x2014; material icon named "assistant rounded".
  static const IconData assistant_rounded = IconData(0xf093, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assistant</i> &#x2014; material icon named "assistant sharp".
  static const IconData assistant_sharp = IconData(0xeb65, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">atm</i> &#x2014; material icon named "atm".
  static const IconData atm = IconData(0xe5c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">atm</i> &#x2014; material icon named "atm outlined".
  static const IconData atm_outlined = IconData(0xe066, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">atm</i> &#x2014; material icon named "atm rounded".
  static const IconData atm_rounded = IconData(0xf094, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">atm</i> &#x2014; material icon named "atm sharp".
  static const IconData atm_sharp = IconData(0xeb66, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attach_email</i> &#x2014; material icon named "attach email".
  static const IconData attach_email = IconData(0xe5c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attach_email</i> &#x2014; material icon named "attach email outlined".
  static const IconData attach_email_outlined = IconData(0xe067, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attach_email</i> &#x2014; material icon named "attach email rounded".
  static const IconData attach_email_rounded = IconData(0xf095, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attach_email</i> &#x2014; material icon named "attach email sharp".
  static const IconData attach_email_sharp = IconData(0xeb67, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attach_file</i> &#x2014; material icon named "attach file".
  static const IconData attach_file = IconData(0xe5c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attach_file</i> &#x2014; material icon named "attach file outlined".
  static const IconData attach_file_outlined = IconData(0xe068, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attach_file</i> &#x2014; material icon named "attach file rounded".
  static const IconData attach_file_rounded = IconData(0xf096, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attach_file</i> &#x2014; material icon named "attach file sharp".
  static const IconData attach_file_sharp = IconData(0xeb68, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attach_money</i> &#x2014; material icon named "attach money".
  static const IconData attach_money = IconData(0xe5c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attach_money</i> &#x2014; material icon named "attach money outlined".
  static const IconData attach_money_outlined = IconData(0xe069, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attach_money</i> &#x2014; material icon named "attach money rounded".
  static const IconData attach_money_rounded = IconData(0xf097, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attach_money</i> &#x2014; material icon named "attach money sharp".
  static const IconData attach_money_sharp = IconData(0xeb69, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attachment</i> &#x2014; material icon named "attachment".
  static const IconData attachment = IconData(0xe5c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attachment</i> &#x2014; material icon named "attachment outlined".
  static const IconData attachment_outlined = IconData(0xe06a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attachment</i> &#x2014; material icon named "attachment rounded".
  static const IconData attachment_rounded = IconData(0xf098, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attachment</i> &#x2014; material icon named "attachment sharp".
  static const IconData attachment_sharp = IconData(0xeb6a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attractions</i> &#x2014; material icon named "attractions".
  static const IconData attractions = IconData(0xe5c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attribution</i> &#x2014; material icon named "attribution outlined".
  static const IconData attribution_outlined = IconData(0xe06b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attribution</i> &#x2014; material icon named "attribution rounded".
  static const IconData attribution_rounded = IconData(0xf099, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attribution</i> &#x2014; material icon named "attribution sharp".
  static const IconData attribution_sharp = IconData(0xeb6b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">audiotrack</i> &#x2014; material icon named "audiotrack".
  static const IconData audiotrack = IconData(0xe5c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">audiotrack</i> &#x2014; material icon named "audiotrack outlined".
  static const IconData audiotrack_outlined = IconData(0xe06c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">audiotrack</i> &#x2014; material icon named "audiotrack rounded".
  static const IconData audiotrack_rounded = IconData(0xf09a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">audiotrack</i> &#x2014; material icon named "audiotrack sharp".
  static const IconData audiotrack_sharp = IconData(0xeb6c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_awesome</i> &#x2014; material icon named "auto awesome".
  static const IconData auto_awesome = IconData(0xe5ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_awesome_mosaic</i> &#x2014; material icon named "auto awesome mosaic".
  static const IconData auto_awesome_mosaic = IconData(0xe5cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_awesome_motion</i> &#x2014; material icon named "auto awesome motion".
  static const IconData auto_awesome_motion = IconData(0xe5cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_delete</i> &#x2014; material icon named "auto delete".
  static const IconData auto_delete = IconData(0xe5cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_delete</i> &#x2014; material icon named "auto delete outlined".
  static const IconData auto_delete_outlined = IconData(0xe06d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_delete</i> &#x2014; material icon named "auto delete rounded".
  static const IconData auto_delete_rounded = IconData(0xf09b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_delete</i> &#x2014; material icon named "auto delete sharp".
  static const IconData auto_delete_sharp = IconData(0xeb6d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_fix_high</i> &#x2014; material icon named "auto fix high".
  static const IconData auto_fix_high = IconData(0xe5ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_fix_normal</i> &#x2014; material icon named "auto fix normal".
  static const IconData auto_fix_normal = IconData(0xe5cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_fix_off</i> &#x2014; material icon named "auto fix off".
  static const IconData auto_fix_off = IconData(0xe5d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_stories</i> &#x2014; material icon named "auto stories".
  static const IconData auto_stories = IconData(0xe5d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">autorenew</i> &#x2014; material icon named "autorenew".
  static const IconData autorenew = IconData(0xe5d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">autorenew</i> &#x2014; material icon named "autorenew outlined".
  static const IconData autorenew_outlined = IconData(0xe06e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">autorenew</i> &#x2014; material icon named "autorenew rounded".
  static const IconData autorenew_rounded = IconData(0xf09c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">autorenew</i> &#x2014; material icon named "autorenew sharp".
  static const IconData autorenew_sharp = IconData(0xeb6e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">av_timer</i> &#x2014; material icon named "av timer".
  static const IconData av_timer = IconData(0xe5d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">av_timer</i> &#x2014; material icon named "av timer outlined".
  static const IconData av_timer_outlined = IconData(0xe06f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">av_timer</i> &#x2014; material icon named "av timer rounded".
  static const IconData av_timer_rounded = IconData(0xf09d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">av_timer</i> &#x2014; material icon named "av timer sharp".
  static const IconData av_timer_sharp = IconData(0xeb6f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">baby_changing_station</i> &#x2014; material icon named "baby changing station".
  static const IconData baby_changing_station = IconData(0xe5d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">baby_changing_station</i> &#x2014; material icon named "baby changing station outlined".
  static const IconData baby_changing_station_outlined = IconData(0xe070, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">baby_changing_station</i> &#x2014; material icon named "baby changing station rounded".
  static const IconData baby_changing_station_rounded = IconData(0xf09e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">baby_changing_station</i> &#x2014; material icon named "baby changing station sharp".
  static const IconData baby_changing_station_sharp = IconData(0xeb70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">backpack</i> &#x2014; material icon named "backpack".
  static const IconData backpack = IconData(0xe5d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">backpack</i> &#x2014; material icon named "backpack outlined".
  static const IconData backpack_outlined = IconData(0xe071, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">backpack</i> &#x2014; material icon named "backpack rounded".
  static const IconData backpack_rounded = IconData(0xf09f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">backpack</i> &#x2014; material icon named "backpack sharp".
  static const IconData backpack_sharp = IconData(0xeb71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">backspace</i> &#x2014; material icon named "backspace".
  static const IconData backspace = IconData(0xe5d6, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">backspace</i> &#x2014; material icon named "backspace outlined".
  static const IconData backspace_outlined = IconData(0xe072, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">backspace</i> &#x2014; material icon named "backspace rounded".
  static const IconData backspace_rounded = IconData(0xf0a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">backspace</i> &#x2014; material icon named "backspace sharp".
  static const IconData backspace_sharp = IconData(0xeb72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">backup</i> &#x2014; material icon named "backup".
  static const IconData backup = IconData(0xe5d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">backup</i> &#x2014; material icon named "backup outlined".
  static const IconData backup_outlined = IconData(0xe073, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">backup</i> &#x2014; material icon named "backup rounded".
  static const IconData backup_rounded = IconData(0xf0a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">backup</i> &#x2014; material icon named "backup sharp".
  static const IconData backup_sharp = IconData(0xeb73, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">backup_table</i> &#x2014; material icon named "backup table".
  static const IconData backup_table = IconData(0xe5d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">backup_table</i> &#x2014; material icon named "backup table outlined".
  static const IconData backup_table_outlined = IconData(0xe074, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">backup_table</i> &#x2014; material icon named "backup table rounded".
  static const IconData backup_table_rounded = IconData(0xf0a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">backup_table</i> &#x2014; material icon named "backup table sharp".
  static const IconData backup_table_sharp = IconData(0xeb74, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">badge</i> &#x2014; material icon named "badge".
  static const IconData badge = IconData(0xe5d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bakery_dining</i> &#x2014; material icon named "bakery dining".
  static const IconData bakery_dining = IconData(0xe5da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ballot</i> &#x2014; material icon named "ballot".
  static const IconData ballot = IconData(0xe5db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ballot</i> &#x2014; material icon named "ballot outlined".
  static const IconData ballot_outlined = IconData(0xe075, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ballot</i> &#x2014; material icon named "ballot rounded".
  static const IconData ballot_rounded = IconData(0xf0a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ballot</i> &#x2014; material icon named "ballot sharp".
  static const IconData ballot_sharp = IconData(0xeb75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bar_chart</i> &#x2014; material icon named "bar chart".
  static const IconData bar_chart = IconData(0xe5dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bar_chart</i> &#x2014; material icon named "bar chart outlined".
  static const IconData bar_chart_outlined = IconData(0xe076, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bar_chart</i> &#x2014; material icon named "bar chart rounded".
  static const IconData bar_chart_rounded = IconData(0xf0a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bar_chart</i> &#x2014; material icon named "bar chart sharp".
  static const IconData bar_chart_sharp = IconData(0xeb76, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">batch_prediction</i> &#x2014; material icon named "batch prediction".
  static const IconData batch_prediction = IconData(0xe5dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">batch_prediction</i> &#x2014; material icon named "batch prediction outlined".
  static const IconData batch_prediction_outlined = IconData(0xe077, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">batch_prediction</i> &#x2014; material icon named "batch prediction rounded".
  static const IconData batch_prediction_rounded = IconData(0xf0a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">batch_prediction</i> &#x2014; material icon named "batch prediction sharp".
  static const IconData batch_prediction_sharp = IconData(0xeb77, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bathtub</i> &#x2014; material icon named "bathtub".
  static const IconData bathtub = IconData(0xe5de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bathtub</i> &#x2014; material icon named "bathtub outlined".
  static const IconData bathtub_outlined = IconData(0xe078, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bathtub</i> &#x2014; material icon named "bathtub rounded".
  static const IconData bathtub_rounded = IconData(0xf0a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bathtub</i> &#x2014; material icon named "bathtub sharp".
  static const IconData bathtub_sharp = IconData(0xeb78, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_alert</i> &#x2014; material icon named "battery alert".
  static const IconData battery_alert = IconData(0xe5df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">battery_alert</i> &#x2014; material icon named "battery alert outlined".
  static const IconData battery_alert_outlined = IconData(0xe079, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_alert</i> &#x2014; material icon named "battery alert rounded".
  static const IconData battery_alert_rounded = IconData(0xf0a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_alert</i> &#x2014; material icon named "battery alert sharp".
  static const IconData battery_alert_sharp = IconData(0xeb79, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_charging_full</i> &#x2014; material icon named "battery charging full".
  static const IconData battery_charging_full = IconData(0xe5e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">battery_charging_full</i> &#x2014; material icon named "battery charging full outlined".
  static const IconData battery_charging_full_outlined = IconData(0xe07a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_charging_full</i> &#x2014; material icon named "battery charging full rounded".
  static const IconData battery_charging_full_rounded = IconData(0xf0a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_charging_full</i> &#x2014; material icon named "battery charging full sharp".
  static const IconData battery_charging_full_sharp = IconData(0xeb7a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_full</i> &#x2014; material icon named "battery full".
  static const IconData battery_full = IconData(0xe5e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">battery_full</i> &#x2014; material icon named "battery full outlined".
  static const IconData battery_full_outlined = IconData(0xe07b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_full</i> &#x2014; material icon named "battery full rounded".
  static const IconData battery_full_rounded = IconData(0xf0a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_full</i> &#x2014; material icon named "battery full sharp".
  static const IconData battery_full_sharp = IconData(0xeb7b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_std</i> &#x2014; material icon named "battery std".
  static const IconData battery_std = IconData(0xe5e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">battery_std</i> &#x2014; material icon named "battery std outlined".
  static const IconData battery_std_outlined = IconData(0xe07c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_std</i> &#x2014; material icon named "battery std rounded".
  static const IconData battery_std_rounded = IconData(0xf0aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_std</i> &#x2014; material icon named "battery std sharp".
  static const IconData battery_std_sharp = IconData(0xeb7c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_unknown</i> &#x2014; material icon named "battery unknown".
  static const IconData battery_unknown = IconData(0xe5e3, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">battery_unknown</i> &#x2014; material icon named "battery unknown outlined".
  static const IconData battery_unknown_outlined = IconData(0xe07d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_unknown</i> &#x2014; material icon named "battery unknown rounded".
  static const IconData battery_unknown_rounded = IconData(0xf0ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_unknown</i> &#x2014; material icon named "battery unknown sharp".
  static const IconData battery_unknown_sharp = IconData(0xeb7d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">beach_access</i> &#x2014; material icon named "beach access".
  static const IconData beach_access = IconData(0xe5e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">beach_access</i> &#x2014; material icon named "beach access outlined".
  static const IconData beach_access_outlined = IconData(0xe07e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">beach_access</i> &#x2014; material icon named "beach access rounded".
  static const IconData beach_access_rounded = IconData(0xf0ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">beach_access</i> &#x2014; material icon named "beach access sharp".
  static const IconData beach_access_sharp = IconData(0xeb7e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bedtime</i> &#x2014; material icon named "bedtime".
  static const IconData bedtime = IconData(0xe5e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bedtime</i> &#x2014; material icon named "bedtime outlined".
  static const IconData bedtime_outlined = IconData(0xe07f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bedtime</i> &#x2014; material icon named "bedtime rounded".
  static const IconData bedtime_rounded = IconData(0xf0ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bedtime</i> &#x2014; material icon named "bedtime sharp".
  static const IconData bedtime_sharp = IconData(0xeb7f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">beenhere</i> &#x2014; material icon named "beenhere".
  static const IconData beenhere = IconData(0xe5e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">beenhere</i> &#x2014; material icon named "beenhere outlined".
  static const IconData beenhere_outlined = IconData(0xe080, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">beenhere</i> &#x2014; material icon named "beenhere rounded".
  static const IconData beenhere_rounded = IconData(0xf0ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">beenhere</i> &#x2014; material icon named "beenhere sharp".
  static const IconData beenhere_sharp = IconData(0xeb80, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bento</i> &#x2014; material icon named "bento".
  static const IconData bento = IconData(0xe5e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bento</i> &#x2014; material icon named "bento outlined".
  static const IconData bento_outlined = IconData(0xe081, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bento</i> &#x2014; material icon named "bento rounded".
  static const IconData bento_rounded = IconData(0xf0af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bento</i> &#x2014; material icon named "bento sharp".
  static const IconData bento_sharp = IconData(0xeb81, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bike_scooter</i> &#x2014; material icon named "bike scooter".
  static const IconData bike_scooter = IconData(0xe5e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bike_scooter</i> &#x2014; material icon named "bike scooter outlined".
  static const IconData bike_scooter_outlined = IconData(0xe082, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bike_scooter</i> &#x2014; material icon named "bike scooter rounded".
  static const IconData bike_scooter_rounded = IconData(0xf0b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bike_scooter</i> &#x2014; material icon named "bike scooter sharp".
  static const IconData bike_scooter_sharp = IconData(0xeb82, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">biotech</i> &#x2014; material icon named "biotech".
  static const IconData biotech = IconData(0xe5e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">biotech</i> &#x2014; material icon named "biotech outlined".
  static const IconData biotech_outlined = IconData(0xe083, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">biotech</i> &#x2014; material icon named "biotech rounded".
  static const IconData biotech_rounded = IconData(0xf0b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">biotech</i> &#x2014; material icon named "biotech sharp".
  static const IconData biotech_sharp = IconData(0xeb83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">block</i> &#x2014; material icon named "block".
  static const IconData block = IconData(0xe5ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">block_flipped</i> &#x2014; material icon named "block flipped".
  static const IconData block_flipped = IconData(0xe5eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">block</i> &#x2014; material icon named "block outlined".
  static const IconData block_outlined = IconData(0xe084, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">block</i> &#x2014; material icon named "block rounded".
  static const IconData block_rounded = IconData(0xf0b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">block</i> &#x2014; material icon named "block sharp".
  static const IconData block_sharp = IconData(0xeb84, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth</i> &#x2014; material icon named "bluetooth".
  static const IconData bluetooth = IconData(0xe5ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_audio</i> &#x2014; material icon named "bluetooth audio".
  static const IconData bluetooth_audio = IconData(0xe5ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth_audio</i> &#x2014; material icon named "bluetooth audio outlined".
  static const IconData bluetooth_audio_outlined = IconData(0xe085, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth_audio</i> &#x2014; material icon named "bluetooth audio rounded".
  static const IconData bluetooth_audio_rounded = IconData(0xf0b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth_audio</i> &#x2014; material icon named "bluetooth audio sharp".
  static const IconData bluetooth_audio_sharp = IconData(0xeb85, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_connected</i> &#x2014; material icon named "bluetooth connected".
  static const IconData bluetooth_connected = IconData(0xe5ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth_connected</i> &#x2014; material icon named "bluetooth connected outlined".
  static const IconData bluetooth_connected_outlined = IconData(0xe086, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth_connected</i> &#x2014; material icon named "bluetooth connected rounded".
  static const IconData bluetooth_connected_rounded = IconData(0xf0b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth_connected</i> &#x2014; material icon named "bluetooth connected sharp".
  static const IconData bluetooth_connected_sharp = IconData(0xeb86, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_disabled</i> &#x2014; material icon named "bluetooth disabled".
  static const IconData bluetooth_disabled = IconData(0xe5ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth_disabled</i> &#x2014; material icon named "bluetooth disabled outlined".
  static const IconData bluetooth_disabled_outlined = IconData(0xe087, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth_disabled</i> &#x2014; material icon named "bluetooth disabled rounded".
  static const IconData bluetooth_disabled_rounded = IconData(0xf0b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth_disabled</i> &#x2014; material icon named "bluetooth disabled sharp".
  static const IconData bluetooth_disabled_sharp = IconData(0xeb87, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth</i> &#x2014; material icon named "bluetooth outlined".
  static const IconData bluetooth_outlined = IconData(0xe088, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth</i> &#x2014; material icon named "bluetooth rounded".
  static const IconData bluetooth_rounded = IconData(0xf0b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_searching</i> &#x2014; material icon named "bluetooth searching".
  static const IconData bluetooth_searching = IconData(0xe5f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth_searching</i> &#x2014; material icon named "bluetooth searching outlined".
  static const IconData bluetooth_searching_outlined = IconData(0xe089, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth_searching</i> &#x2014; material icon named "bluetooth searching rounded".
  static const IconData bluetooth_searching_rounded = IconData(0xf0b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth_searching</i> &#x2014; material icon named "bluetooth searching sharp".
  static const IconData bluetooth_searching_sharp = IconData(0xeb88, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth</i> &#x2014; material icon named "bluetooth sharp".
  static const IconData bluetooth_sharp = IconData(0xeb89, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_circular</i> &#x2014; material icon named "blur circular".
  static const IconData blur_circular = IconData(0xe5f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">blur_circular</i> &#x2014; material icon named "blur circular outlined".
  static const IconData blur_circular_outlined = IconData(0xe08a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">blur_circular</i> &#x2014; material icon named "blur circular rounded".
  static const IconData blur_circular_rounded = IconData(0xf0b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">blur_circular</i> &#x2014; material icon named "blur circular sharp".
  static const IconData blur_circular_sharp = IconData(0xeb8a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_linear</i> &#x2014; material icon named "blur linear".
  static const IconData blur_linear = IconData(0xe5f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">blur_linear</i> &#x2014; material icon named "blur linear outlined".
  static const IconData blur_linear_outlined = IconData(0xe08b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">blur_linear</i> &#x2014; material icon named "blur linear rounded".
  static const IconData blur_linear_rounded = IconData(0xf0b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">blur_linear</i> &#x2014; material icon named "blur linear sharp".
  static const IconData blur_linear_sharp = IconData(0xeb8b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_off</i> &#x2014; material icon named "blur off".
  static const IconData blur_off = IconData(0xe5f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">blur_off</i> &#x2014; material icon named "blur off outlined".
  static const IconData blur_off_outlined = IconData(0xe08c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">blur_off</i> &#x2014; material icon named "blur off rounded".
  static const IconData blur_off_rounded = IconData(0xf0ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">blur_off</i> &#x2014; material icon named "blur off sharp".
  static const IconData blur_off_sharp = IconData(0xeb8c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_on</i> &#x2014; material icon named "blur on".
  static const IconData blur_on = IconData(0xe5f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">blur_on</i> &#x2014; material icon named "blur on outlined".
  static const IconData blur_on_outlined = IconData(0xe08d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">blur_on</i> &#x2014; material icon named "blur on rounded".
  static const IconData blur_on_rounded = IconData(0xf0bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">blur_on</i> &#x2014; material icon named "blur on sharp".
  static const IconData blur_on_sharp = IconData(0xeb8d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bolt</i> &#x2014; material icon named "bolt".
  static const IconData bolt = IconData(0xe5f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">book</i> &#x2014; material icon named "book".
  static const IconData book = IconData(0xe5f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">book_online</i> &#x2014; material icon named "book online".
  static const IconData book_online = IconData(0xe5f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">book_online</i> &#x2014; material icon named "book online outlined".
  static const IconData book_online_outlined = IconData(0xe08e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">book_online</i> &#x2014; material icon named "book online rounded".
  static const IconData book_online_rounded = IconData(0xf0bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">book_online</i> &#x2014; material icon named "book online sharp".
  static const IconData book_online_sharp = IconData(0xeb8e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">book</i> &#x2014; material icon named "book outlined".
  static const IconData book_outlined = IconData(0xe08f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">book</i> &#x2014; material icon named "book rounded".
  static const IconData book_rounded = IconData(0xf0bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">book</i> &#x2014; material icon named "book sharp".
  static const IconData book_sharp = IconData(0xeb8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark</i> &#x2014; material icon named "bookmark".
  static const IconData bookmark = IconData(0xe5f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark_border</i> &#x2014; material icon named "bookmark border".
  static const IconData bookmark_border = IconData(0xe5f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmark_border</i> &#x2014; material icon named "bookmark border outlined".
  static const IconData bookmark_border_outlined = IconData(0xe090, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmark_border</i> &#x2014; material icon named "bookmark border rounded".
  static const IconData bookmark_border_rounded = IconData(0xf0be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmark_border</i> &#x2014; material icon named "bookmark border sharp".
  static const IconData bookmark_border_sharp = IconData(0xeb90, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark_outline</i> &#x2014; material icon named "bookmark outline".
  static const IconData bookmark_outline = IconData(0xe5f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmark_outline</i> &#x2014; material icon named "bookmark outline outlined".
  static const IconData bookmark_outline_outlined = IconData(0xe090, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmark_outline</i> &#x2014; material icon named "bookmark outline rounded".
  static const IconData bookmark_outline_rounded = IconData(0xf0be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmark_outline</i> &#x2014; material icon named "bookmark outline sharp".
  static const IconData bookmark_outline_sharp = IconData(0xeb90, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmark</i> &#x2014; material icon named "bookmark outlined".
  static const IconData bookmark_outlined = IconData(0xe091, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmark</i> &#x2014; material icon named "bookmark rounded".
  static const IconData bookmark_rounded = IconData(0xf0bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmark</i> &#x2014; material icon named "bookmark sharp".
  static const IconData bookmark_sharp = IconData(0xeb91, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmarks</i> &#x2014; material icon named "bookmarks".
  static const IconData bookmarks = IconData(0xe5fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmarks</i> &#x2014; material icon named "bookmarks outlined".
  static const IconData bookmarks_outlined = IconData(0xe092, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmarks</i> &#x2014; material icon named "bookmarks rounded".
  static const IconData bookmarks_rounded = IconData(0xf0c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmarks</i> &#x2014; material icon named "bookmarks sharp".
  static const IconData bookmarks_sharp = IconData(0xeb92, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_all</i> &#x2014; material icon named "border all".
  static const IconData border_all = IconData(0xe5fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_all</i> &#x2014; material icon named "border all outlined".
  static const IconData border_all_outlined = IconData(0xe093, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_all</i> &#x2014; material icon named "border all rounded".
  static const IconData border_all_rounded = IconData(0xf0c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_all</i> &#x2014; material icon named "border all sharp".
  static const IconData border_all_sharp = IconData(0xeb93, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_bottom</i> &#x2014; material icon named "border bottom".
  static const IconData border_bottom = IconData(0xe5fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_bottom</i> &#x2014; material icon named "border bottom outlined".
  static const IconData border_bottom_outlined = IconData(0xe094, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_bottom</i> &#x2014; material icon named "border bottom rounded".
  static const IconData border_bottom_rounded = IconData(0xf0c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_bottom</i> &#x2014; material icon named "border bottom sharp".
  static const IconData border_bottom_sharp = IconData(0xeb94, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_clear</i> &#x2014; material icon named "border clear".
  static const IconData border_clear = IconData(0xe5fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_clear</i> &#x2014; material icon named "border clear outlined".
  static const IconData border_clear_outlined = IconData(0xe095, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_clear</i> &#x2014; material icon named "border clear rounded".
  static const IconData border_clear_rounded = IconData(0xf0c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_clear</i> &#x2014; material icon named "border clear sharp".
  static const IconData border_clear_sharp = IconData(0xeb95, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_color</i> &#x2014; material icon named "border color".
  static const IconData border_color = IconData(0xe5fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_horizontal</i> &#x2014; material icon named "border horizontal".
  static const IconData border_horizontal = IconData(0xe5ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_horizontal</i> &#x2014; material icon named "border horizontal outlined".
  static const IconData border_horizontal_outlined = IconData(0xe096, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_horizontal</i> &#x2014; material icon named "border horizontal rounded".
  static const IconData border_horizontal_rounded = IconData(0xf0c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_horizontal</i> &#x2014; material icon named "border horizontal sharp".
  static const IconData border_horizontal_sharp = IconData(0xeb96, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_inner</i> &#x2014; material icon named "border inner".
  static const IconData border_inner = IconData(0xe600, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_inner</i> &#x2014; material icon named "border inner outlined".
  static const IconData border_inner_outlined = IconData(0xe097, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_inner</i> &#x2014; material icon named "border inner rounded".
  static const IconData border_inner_rounded = IconData(0xf0c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_inner</i> &#x2014; material icon named "border inner sharp".
  static const IconData border_inner_sharp = IconData(0xeb97, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_left</i> &#x2014; material icon named "border left".
  static const IconData border_left = IconData(0xe601, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_left</i> &#x2014; material icon named "border left outlined".
  static const IconData border_left_outlined = IconData(0xe098, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_left</i> &#x2014; material icon named "border left rounded".
  static const IconData border_left_rounded = IconData(0xf0c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_left</i> &#x2014; material icon named "border left sharp".
  static const IconData border_left_sharp = IconData(0xeb98, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_outer</i> &#x2014; material icon named "border outer".
  static const IconData border_outer = IconData(0xe602, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_outer</i> &#x2014; material icon named "border outer outlined".
  static const IconData border_outer_outlined = IconData(0xe099, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_outer</i> &#x2014; material icon named "border outer rounded".
  static const IconData border_outer_rounded = IconData(0xf0c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_outer</i> &#x2014; material icon named "border outer sharp".
  static const IconData border_outer_sharp = IconData(0xeb99, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_right</i> &#x2014; material icon named "border right".
  static const IconData border_right = IconData(0xe603, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_right</i> &#x2014; material icon named "border right outlined".
  static const IconData border_right_outlined = IconData(0xe09a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_right</i> &#x2014; material icon named "border right rounded".
  static const IconData border_right_rounded = IconData(0xf0c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_right</i> &#x2014; material icon named "border right sharp".
  static const IconData border_right_sharp = IconData(0xeb9a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_style</i> &#x2014; material icon named "border style".
  static const IconData border_style = IconData(0xe604, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_style</i> &#x2014; material icon named "border style outlined".
  static const IconData border_style_outlined = IconData(0xe09b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_style</i> &#x2014; material icon named "border style rounded".
  static const IconData border_style_rounded = IconData(0xf0c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_style</i> &#x2014; material icon named "border style sharp".
  static const IconData border_style_sharp = IconData(0xeb9b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_top</i> &#x2014; material icon named "border top".
  static const IconData border_top = IconData(0xe605, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_top</i> &#x2014; material icon named "border top outlined".
  static const IconData border_top_outlined = IconData(0xe09c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_top</i> &#x2014; material icon named "border top rounded".
  static const IconData border_top_rounded = IconData(0xf0ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_top</i> &#x2014; material icon named "border top sharp".
  static const IconData border_top_sharp = IconData(0xeb9c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_vertical</i> &#x2014; material icon named "border vertical".
  static const IconData border_vertical = IconData(0xe606, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_vertical</i> &#x2014; material icon named "border vertical outlined".
  static const IconData border_vertical_outlined = IconData(0xe09d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_vertical</i> &#x2014; material icon named "border vertical rounded".
  static const IconData border_vertical_rounded = IconData(0xf0cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_vertical</i> &#x2014; material icon named "border vertical sharp".
  static const IconData border_vertical_sharp = IconData(0xeb9d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">branding_watermark</i> &#x2014; material icon named "branding watermark".
  static const IconData branding_watermark = IconData(0xe607, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">branding_watermark</i> &#x2014; material icon named "branding watermark outlined".
  static const IconData branding_watermark_outlined = IconData(0xe09e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">branding_watermark</i> &#x2014; material icon named "branding watermark rounded".
  static const IconData branding_watermark_rounded = IconData(0xf0cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">branding_watermark</i> &#x2014; material icon named "branding watermark sharp".
  static const IconData branding_watermark_sharp = IconData(0xeb9e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">breakfast_dining</i> &#x2014; material icon named "breakfast dining".
  static const IconData breakfast_dining = IconData(0xe608, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_1</i> &#x2014; material icon named "brightness 1".
  static const IconData brightness_1 = IconData(0xe609, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_1</i> &#x2014; material icon named "brightness 1 outlined".
  static const IconData brightness_1_outlined = IconData(0xe09f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_1</i> &#x2014; material icon named "brightness 1 rounded".
  static const IconData brightness_1_rounded = IconData(0xf0cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_1</i> &#x2014; material icon named "brightness 1 sharp".
  static const IconData brightness_1_sharp = IconData(0xeb9f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_2</i> &#x2014; material icon named "brightness 2".
  static const IconData brightness_2 = IconData(0xe60a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_2</i> &#x2014; material icon named "brightness 2 outlined".
  static const IconData brightness_2_outlined = IconData(0xe0a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_2</i> &#x2014; material icon named "brightness 2 rounded".
  static const IconData brightness_2_rounded = IconData(0xf0ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_2</i> &#x2014; material icon named "brightness 2 sharp".
  static const IconData brightness_2_sharp = IconData(0xeba0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_3</i> &#x2014; material icon named "brightness 3".
  static const IconData brightness_3 = IconData(0xe60b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_3</i> &#x2014; material icon named "brightness 3 outlined".
  static const IconData brightness_3_outlined = IconData(0xe0a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_3</i> &#x2014; material icon named "brightness 3 rounded".
  static const IconData brightness_3_rounded = IconData(0xf0cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_3</i> &#x2014; material icon named "brightness 3 sharp".
  static const IconData brightness_3_sharp = IconData(0xeba1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_4</i> &#x2014; material icon named "brightness 4".
  static const IconData brightness_4 = IconData(0xe60c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_4</i> &#x2014; material icon named "brightness 4 outlined".
  static const IconData brightness_4_outlined = IconData(0xe0a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_4</i> &#x2014; material icon named "brightness 4 rounded".
  static const IconData brightness_4_rounded = IconData(0xf0d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_4</i> &#x2014; material icon named "brightness 4 sharp".
  static const IconData brightness_4_sharp = IconData(0xeba2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_5</i> &#x2014; material icon named "brightness 5".
  static const IconData brightness_5 = IconData(0xe60d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_5</i> &#x2014; material icon named "brightness 5 outlined".
  static const IconData brightness_5_outlined = IconData(0xe0a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_5</i> &#x2014; material icon named "brightness 5 rounded".
  static const IconData brightness_5_rounded = IconData(0xf0d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_5</i> &#x2014; material icon named "brightness 5 sharp".
  static const IconData brightness_5_sharp = IconData(0xeba3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_6</i> &#x2014; material icon named "brightness 6".
  static const IconData brightness_6 = IconData(0xe60e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_6</i> &#x2014; material icon named "brightness 6 outlined".
  static const IconData brightness_6_outlined = IconData(0xe0a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_6</i> &#x2014; material icon named "brightness 6 rounded".
  static const IconData brightness_6_rounded = IconData(0xf0d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_6</i> &#x2014; material icon named "brightness 6 sharp".
  static const IconData brightness_6_sharp = IconData(0xeba4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_7</i> &#x2014; material icon named "brightness 7".
  static const IconData brightness_7 = IconData(0xe60f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_7</i> &#x2014; material icon named "brightness 7 outlined".
  static const IconData brightness_7_outlined = IconData(0xe0a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_7</i> &#x2014; material icon named "brightness 7 rounded".
  static const IconData brightness_7_rounded = IconData(0xf0d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_7</i> &#x2014; material icon named "brightness 7 sharp".
  static const IconData brightness_7_sharp = IconData(0xeba5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_auto</i> &#x2014; material icon named "brightness auto".
  static const IconData brightness_auto = IconData(0xe610, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_auto</i> &#x2014; material icon named "brightness auto outlined".
  static const IconData brightness_auto_outlined = IconData(0xe0a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_auto</i> &#x2014; material icon named "brightness auto rounded".
  static const IconData brightness_auto_rounded = IconData(0xf0d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_auto</i> &#x2014; material icon named "brightness auto sharp".
  static const IconData brightness_auto_sharp = IconData(0xeba6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_high</i> &#x2014; material icon named "brightness high".
  static const IconData brightness_high = IconData(0xe611, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_high</i> &#x2014; material icon named "brightness high outlined".
  static const IconData brightness_high_outlined = IconData(0xe0a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_high</i> &#x2014; material icon named "brightness high rounded".
  static const IconData brightness_high_rounded = IconData(0xf0d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_high</i> &#x2014; material icon named "brightness high sharp".
  static const IconData brightness_high_sharp = IconData(0xeba7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_low</i> &#x2014; material icon named "brightness low".
  static const IconData brightness_low = IconData(0xe612, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_low</i> &#x2014; material icon named "brightness low outlined".
  static const IconData brightness_low_outlined = IconData(0xe0a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_low</i> &#x2014; material icon named "brightness low rounded".
  static const IconData brightness_low_rounded = IconData(0xf0d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_low</i> &#x2014; material icon named "brightness low sharp".
  static const IconData brightness_low_sharp = IconData(0xeba8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_medium</i> &#x2014; material icon named "brightness medium".
  static const IconData brightness_medium = IconData(0xe613, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_medium</i> &#x2014; material icon named "brightness medium outlined".
  static const IconData brightness_medium_outlined = IconData(0xe0a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_medium</i> &#x2014; material icon named "brightness medium rounded".
  static const IconData brightness_medium_rounded = IconData(0xf0d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_medium</i> &#x2014; material icon named "brightness medium sharp".
  static const IconData brightness_medium_sharp = IconData(0xeba9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">broken_image</i> &#x2014; material icon named "broken image".
  static const IconData broken_image = IconData(0xe614, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">broken_image</i> &#x2014; material icon named "broken image outlined".
  static const IconData broken_image_outlined = IconData(0xe0aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">broken_image</i> &#x2014; material icon named "broken image rounded".
  static const IconData broken_image_rounded = IconData(0xf0d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">broken_image</i> &#x2014; material icon named "broken image sharp".
  static const IconData broken_image_sharp = IconData(0xebaa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">browser_not_supported</i> &#x2014; material icon named "browser not supported".
  static const IconData browser_not_supported = IconData(0xe615, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">browser_not_supported</i> &#x2014; material icon named "browser not supported outlined".
  static const IconData browser_not_supported_outlined = IconData(0xe0ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">browser_not_supported</i> &#x2014; material icon named "browser not supported rounded".
  static const IconData browser_not_supported_rounded = IconData(0xf0d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">browser_not_supported</i> &#x2014; material icon named "browser not supported sharp".
  static const IconData browser_not_supported_sharp = IconData(0xebab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brunch_dining</i> &#x2014; material icon named "brunch dining".
  static const IconData brunch_dining = IconData(0xe616, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brush</i> &#x2014; material icon named "brush".
  static const IconData brush = IconData(0xe617, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brush</i> &#x2014; material icon named "brush outlined".
  static const IconData brush_outlined = IconData(0xe0ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brush</i> &#x2014; material icon named "brush rounded".
  static const IconData brush_rounded = IconData(0xf0da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brush</i> &#x2014; material icon named "brush sharp".
  static const IconData brush_sharp = IconData(0xebac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bubble_chart</i> &#x2014; material icon named "bubble chart".
  static const IconData bubble_chart = IconData(0xe618, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bubble_chart</i> &#x2014; material icon named "bubble chart outlined".
  static const IconData bubble_chart_outlined = IconData(0xe0ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bubble_chart</i> &#x2014; material icon named "bubble chart rounded".
  static const IconData bubble_chart_rounded = IconData(0xf0db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bubble_chart</i> &#x2014; material icon named "bubble chart sharp".
  static const IconData bubble_chart_sharp = IconData(0xebad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bug_report</i> &#x2014; material icon named "bug report".
  static const IconData bug_report = IconData(0xe619, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bug_report</i> &#x2014; material icon named "bug report outlined".
  static const IconData bug_report_outlined = IconData(0xe0ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bug_report</i> &#x2014; material icon named "bug report rounded".
  static const IconData bug_report_rounded = IconData(0xf0dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bug_report</i> &#x2014; material icon named "bug report sharp".
  static const IconData bug_report_sharp = IconData(0xebae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">build</i> &#x2014; material icon named "build".
  static const IconData build = IconData(0xe61a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">build_circle</i> &#x2014; material icon named "build circle".
  static const IconData build_circle = IconData(0xe61b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">build_circle</i> &#x2014; material icon named "build circle outlined".
  static const IconData build_circle_outlined = IconData(0xe0af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">build_circle</i> &#x2014; material icon named "build circle rounded".
  static const IconData build_circle_rounded = IconData(0xf0dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">build_circle</i> &#x2014; material icon named "build circle sharp".
  static const IconData build_circle_sharp = IconData(0xebaf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">build</i> &#x2014; material icon named "build outlined".
  static const IconData build_outlined = IconData(0xe0b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">build</i> &#x2014; material icon named "build rounded".
  static const IconData build_rounded = IconData(0xf0de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">build</i> &#x2014; material icon named "build sharp".
  static const IconData build_sharp = IconData(0xebb0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">burst_mode</i> &#x2014; material icon named "burst mode".
  static const IconData burst_mode = IconData(0xe61c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">burst_mode</i> &#x2014; material icon named "burst mode outlined".
  static const IconData burst_mode_outlined = IconData(0xe0b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">burst_mode</i> &#x2014; material icon named "burst mode rounded".
  static const IconData burst_mode_rounded = IconData(0xf0df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">burst_mode</i> &#x2014; material icon named "burst mode sharp".
  static const IconData burst_mode_sharp = IconData(0xebb1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bus_alert</i> &#x2014; material icon named "bus alert".
  static const IconData bus_alert = IconData(0xe61d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">business</i> &#x2014; material icon named "business".
  static const IconData business = IconData(0xe61e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">business_center</i> &#x2014; material icon named "business center".
  static const IconData business_center = IconData(0xe61f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">business_center</i> &#x2014; material icon named "business center outlined".
  static const IconData business_center_outlined = IconData(0xe0b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">business_center</i> &#x2014; material icon named "business center rounded".
  static const IconData business_center_rounded = IconData(0xf0e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">business_center</i> &#x2014; material icon named "business center sharp".
  static const IconData business_center_sharp = IconData(0xebb2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">business</i> &#x2014; material icon named "business outlined".
  static const IconData business_outlined = IconData(0xe0b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">business</i> &#x2014; material icon named "business rounded".
  static const IconData business_rounded = IconData(0xf0e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">business</i> &#x2014; material icon named "business sharp".
  static const IconData business_sharp = IconData(0xebb3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cached</i> &#x2014; material icon named "cached".
  static const IconData cached = IconData(0xe620, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cached</i> &#x2014; material icon named "cached outlined".
  static const IconData cached_outlined = IconData(0xe0b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cached</i> &#x2014; material icon named "cached rounded".
  static const IconData cached_rounded = IconData(0xf0e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cached</i> &#x2014; material icon named "cached sharp".
  static const IconData cached_sharp = IconData(0xebb4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cake</i> &#x2014; material icon named "cake".
  static const IconData cake = IconData(0xe621, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cake</i> &#x2014; material icon named "cake outlined".
  static const IconData cake_outlined = IconData(0xe0b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cake</i> &#x2014; material icon named "cake rounded".
  static const IconData cake_rounded = IconData(0xf0e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cake</i> &#x2014; material icon named "cake sharp".
  static const IconData cake_sharp = IconData(0xebb5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calculate</i> &#x2014; material icon named "calculate".
  static const IconData calculate = IconData(0xe622, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">calculate</i> &#x2014; material icon named "calculate outlined".
  static const IconData calculate_outlined = IconData(0xe0b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">calculate</i> &#x2014; material icon named "calculate rounded".
  static const IconData calculate_rounded = IconData(0xf0e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">calculate</i> &#x2014; material icon named "calculate sharp".
  static const IconData calculate_sharp = IconData(0xebb6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calendar_today</i> &#x2014; material icon named "calendar today".
  static const IconData calendar_today = IconData(0xe623, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">calendar_today</i> &#x2014; material icon named "calendar today outlined".
  static const IconData calendar_today_outlined = IconData(0xe0b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">calendar_today</i> &#x2014; material icon named "calendar today rounded".
  static const IconData calendar_today_rounded = IconData(0xf0e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">calendar_today</i> &#x2014; material icon named "calendar today sharp".
  static const IconData calendar_today_sharp = IconData(0xebb7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calendar_view_day</i> &#x2014; material icon named "calendar view day".
  static const IconData calendar_view_day = IconData(0xe624, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">calendar_view_day</i> &#x2014; material icon named "calendar view day outlined".
  static const IconData calendar_view_day_outlined = IconData(0xe0b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">calendar_view_day</i> &#x2014; material icon named "calendar view day rounded".
  static const IconData calendar_view_day_rounded = IconData(0xf0e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">calendar_view_day</i> &#x2014; material icon named "calendar view day sharp".
  static const IconData calendar_view_day_sharp = IconData(0xebb8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call</i> &#x2014; material icon named "call".
  static const IconData call = IconData(0xe625, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_end</i> &#x2014; material icon named "call end".
  static const IconData call_end = IconData(0xe626, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">call_end</i> &#x2014; material icon named "call end outlined".
  static const IconData call_end_outlined = IconData(0xe0b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_end</i> &#x2014; material icon named "call end rounded".
  static const IconData call_end_rounded = IconData(0xf0e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_end</i> &#x2014; material icon named "call end sharp".
  static const IconData call_end_sharp = IconData(0xebb9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_made</i> &#x2014; material icon named "call made".
  static const IconData call_made = IconData(0xe627, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_made</i> &#x2014; material icon named "call made outlined".
  static const IconData call_made_outlined = IconData(0xe0ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_made</i> &#x2014; material icon named "call made rounded".
  static const IconData call_made_rounded = IconData(0xf0e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_made</i> &#x2014; material icon named "call made sharp".
  static const IconData call_made_sharp = IconData(0xebba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_merge</i> &#x2014; material icon named "call merge".
  static const IconData call_merge = IconData(0xe628, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_merge</i> &#x2014; material icon named "call merge outlined".
  static const IconData call_merge_outlined = IconData(0xe0bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_merge</i> &#x2014; material icon named "call merge rounded".
  static const IconData call_merge_rounded = IconData(0xf0e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_merge</i> &#x2014; material icon named "call merge sharp".
  static const IconData call_merge_sharp = IconData(0xebbb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_missed</i> &#x2014; material icon named "call missed".
  static const IconData call_missed = IconData(0xe629, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_missed_outgoing</i> &#x2014; material icon named "call missed outgoing".
  static const IconData call_missed_outgoing = IconData(0xe62a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_missed_outgoing</i> &#x2014; material icon named "call missed outgoing outlined".
  static const IconData call_missed_outgoing_outlined = IconData(0xe0bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_missed_outgoing</i> &#x2014; material icon named "call missed outgoing rounded".
  static const IconData call_missed_outgoing_rounded = IconData(0xf0ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_missed_outgoing</i> &#x2014; material icon named "call missed outgoing sharp".
  static const IconData call_missed_outgoing_sharp = IconData(0xebbc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">call_missed</i> &#x2014; material icon named "call missed outlined".
  static const IconData call_missed_outlined = IconData(0xe0bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_missed</i> &#x2014; material icon named "call missed rounded".
  static const IconData call_missed_rounded = IconData(0xf0eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_missed</i> &#x2014; material icon named "call missed sharp".
  static const IconData call_missed_sharp = IconData(0xebbd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">call</i> &#x2014; material icon named "call outlined".
  static const IconData call_outlined = IconData(0xe0be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_received</i> &#x2014; material icon named "call received".
  static const IconData call_received = IconData(0xe62b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_received</i> &#x2014; material icon named "call received outlined".
  static const IconData call_received_outlined = IconData(0xe0bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_received</i> &#x2014; material icon named "call received rounded".
  static const IconData call_received_rounded = IconData(0xf0ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_received</i> &#x2014; material icon named "call received sharp".
  static const IconData call_received_sharp = IconData(0xebbe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call</i> &#x2014; material icon named "call rounded".
  static const IconData call_rounded = IconData(0xf0ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call</i> &#x2014; material icon named "call sharp".
  static const IconData call_sharp = IconData(0xebbf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_split</i> &#x2014; material icon named "call split".
  static const IconData call_split = IconData(0xe62c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_split</i> &#x2014; material icon named "call split outlined".
  static const IconData call_split_outlined = IconData(0xe0c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_split</i> &#x2014; material icon named "call split rounded".
  static const IconData call_split_rounded = IconData(0xf0ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_split</i> &#x2014; material icon named "call split sharp".
  static const IconData call_split_sharp = IconData(0xebc0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_to_action</i> &#x2014; material icon named "call to action".
  static const IconData call_to_action = IconData(0xe62d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">call_to_action</i> &#x2014; material icon named "call to action outlined".
  static const IconData call_to_action_outlined = IconData(0xe0c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_to_action</i> &#x2014; material icon named "call to action rounded".
  static const IconData call_to_action_rounded = IconData(0xf0ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_to_action</i> &#x2014; material icon named "call to action sharp".
  static const IconData call_to_action_sharp = IconData(0xebc1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera</i> &#x2014; material icon named "camera".
  static const IconData camera = IconData(0xe62e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_alt</i> &#x2014; material icon named "camera alt".
  static const IconData camera_alt = IconData(0xe62f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_alt</i> &#x2014; material icon named "camera alt outlined".
  static const IconData camera_alt_outlined = IconData(0xe0c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_alt</i> &#x2014; material icon named "camera alt rounded".
  static const IconData camera_alt_rounded = IconData(0xf0f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_alt</i> &#x2014; material icon named "camera alt sharp".
  static const IconData camera_alt_sharp = IconData(0xebc2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_enhance</i> &#x2014; material icon named "camera enhance".
  static const IconData camera_enhance = IconData(0xe630, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_enhance</i> &#x2014; material icon named "camera enhance outlined".
  static const IconData camera_enhance_outlined = IconData(0xe0c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_enhance</i> &#x2014; material icon named "camera enhance rounded".
  static const IconData camera_enhance_rounded = IconData(0xf0f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_enhance</i> &#x2014; material icon named "camera enhance sharp".
  static const IconData camera_enhance_sharp = IconData(0xebc3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_front</i> &#x2014; material icon named "camera front".
  static const IconData camera_front = IconData(0xe631, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_front</i> &#x2014; material icon named "camera front outlined".
  static const IconData camera_front_outlined = IconData(0xe0c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_front</i> &#x2014; material icon named "camera front rounded".
  static const IconData camera_front_rounded = IconData(0xf0f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_front</i> &#x2014; material icon named "camera front sharp".
  static const IconData camera_front_sharp = IconData(0xebc4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera</i> &#x2014; material icon named "camera outlined".
  static const IconData camera_outlined = IconData(0xe0c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_rear</i> &#x2014; material icon named "camera rear".
  static const IconData camera_rear = IconData(0xe632, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_rear</i> &#x2014; material icon named "camera rear outlined".
  static const IconData camera_rear_outlined = IconData(0xe0c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_rear</i> &#x2014; material icon named "camera rear rounded".
  static const IconData camera_rear_rounded = IconData(0xf0f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_rear</i> &#x2014; material icon named "camera rear sharp".
  static const IconData camera_rear_sharp = IconData(0xebc5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_roll</i> &#x2014; material icon named "camera roll".
  static const IconData camera_roll = IconData(0xe633, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_roll</i> &#x2014; material icon named "camera roll outlined".
  static const IconData camera_roll_outlined = IconData(0xe0c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_roll</i> &#x2014; material icon named "camera roll rounded".
  static const IconData camera_roll_rounded = IconData(0xf0f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_roll</i> &#x2014; material icon named "camera roll sharp".
  static const IconData camera_roll_sharp = IconData(0xebc6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera</i> &#x2014; material icon named "camera rounded".
  static const IconData camera_rounded = IconData(0xf0f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera</i> &#x2014; material icon named "camera sharp".
  static const IconData camera_sharp = IconData(0xebc7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">campaign</i> &#x2014; material icon named "campaign".
  static const IconData campaign = IconData(0xe634, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">campaign</i> &#x2014; material icon named "campaign outlined".
  static const IconData campaign_outlined = IconData(0xe0c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">campaign</i> &#x2014; material icon named "campaign rounded".
  static const IconData campaign_rounded = IconData(0xf0f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">campaign</i> &#x2014; material icon named "campaign sharp".
  static const IconData campaign_sharp = IconData(0xebc8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cancel</i> &#x2014; material icon named "cancel".
  static const IconData cancel = IconData(0xe635, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cancel</i> &#x2014; material icon named "cancel outlined".
  static const IconData cancel_outlined = IconData(0xe0c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cancel_presentation</i> &#x2014; material icon named "cancel presentation".
  static const IconData cancel_presentation = IconData(0xe636, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cancel_presentation</i> &#x2014; material icon named "cancel presentation outlined".
  static const IconData cancel_presentation_outlined = IconData(0xe0ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cancel_presentation</i> &#x2014; material icon named "cancel presentation rounded".
  static const IconData cancel_presentation_rounded = IconData(0xf0f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cancel_presentation</i> &#x2014; material icon named "cancel presentation sharp".
  static const IconData cancel_presentation_sharp = IconData(0xebc9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cancel</i> &#x2014; material icon named "cancel rounded".
  static const IconData cancel_rounded = IconData(0xf0f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cancel_schedule_send</i> &#x2014; material icon named "cancel schedule send".
  static const IconData cancel_schedule_send = IconData(0xe637, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cancel_schedule_send</i> &#x2014; material icon named "cancel schedule send outlined".
  static const IconData cancel_schedule_send_outlined = IconData(0xe0cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cancel_schedule_send</i> &#x2014; material icon named "cancel schedule send rounded".
  static const IconData cancel_schedule_send_rounded = IconData(0xf0f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cancel_schedule_send</i> &#x2014; material icon named "cancel schedule send sharp".
  static const IconData cancel_schedule_send_sharp = IconData(0xebca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cancel</i> &#x2014; material icon named "cancel sharp".
  static const IconData cancel_sharp = IconData(0xebcb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">car_rental</i> &#x2014; material icon named "car rental".
  static const IconData car_rental = IconData(0xe638, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">car_repair</i> &#x2014; material icon named "car repair".
  static const IconData car_repair = IconData(0xe639, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">card_giftcard</i> &#x2014; material icon named "card giftcard".
  static const IconData card_giftcard = IconData(0xe63a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">card_giftcard</i> &#x2014; material icon named "card giftcard outlined".
  static const IconData card_giftcard_outlined = IconData(0xe0cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">card_giftcard</i> &#x2014; material icon named "card giftcard rounded".
  static const IconData card_giftcard_rounded = IconData(0xf0fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">card_giftcard</i> &#x2014; material icon named "card giftcard sharp".
  static const IconData card_giftcard_sharp = IconData(0xebcc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">card_membership</i> &#x2014; material icon named "card membership".
  static const IconData card_membership = IconData(0xe63b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">card_membership</i> &#x2014; material icon named "card membership outlined".
  static const IconData card_membership_outlined = IconData(0xe0cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">card_membership</i> &#x2014; material icon named "card membership rounded".
  static const IconData card_membership_rounded = IconData(0xf0fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">card_membership</i> &#x2014; material icon named "card membership sharp".
  static const IconData card_membership_sharp = IconData(0xebcd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">card_travel</i> &#x2014; material icon named "card travel".
  static const IconData card_travel = IconData(0xe63c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">card_travel</i> &#x2014; material icon named "card travel outlined".
  static const IconData card_travel_outlined = IconData(0xe0ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">card_travel</i> &#x2014; material icon named "card travel rounded".
  static const IconData card_travel_rounded = IconData(0xf0fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">card_travel</i> &#x2014; material icon named "card travel sharp".
  static const IconData card_travel_sharp = IconData(0xebce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">carpenter</i> &#x2014; material icon named "carpenter".
  static const IconData carpenter = IconData(0xe63d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">carpenter</i> &#x2014; material icon named "carpenter outlined".
  static const IconData carpenter_outlined = IconData(0xe0cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">carpenter</i> &#x2014; material icon named "carpenter rounded".
  static const IconData carpenter_rounded = IconData(0xf0fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">carpenter</i> &#x2014; material icon named "carpenter sharp".
  static const IconData carpenter_sharp = IconData(0xebcf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cases</i> &#x2014; material icon named "cases".
  static const IconData cases = IconData(0xe63e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">casino</i> &#x2014; material icon named "casino".
  static const IconData casino = IconData(0xe63f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">casino</i> &#x2014; material icon named "casino outlined".
  static const IconData casino_outlined = IconData(0xe0d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">casino</i> &#x2014; material icon named "casino rounded".
  static const IconData casino_rounded = IconData(0xf0fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">casino</i> &#x2014; material icon named "casino sharp".
  static const IconData casino_sharp = IconData(0xebd0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cast</i> &#x2014; material icon named "cast".
  static const IconData cast = IconData(0xe640, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cast_connected</i> &#x2014; material icon named "cast connected".
  static const IconData cast_connected = IconData(0xe641, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cast_connected</i> &#x2014; material icon named "cast connected outlined".
  static const IconData cast_connected_outlined = IconData(0xe0d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cast_connected</i> &#x2014; material icon named "cast connected rounded".
  static const IconData cast_connected_rounded = IconData(0xf0ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cast_connected</i> &#x2014; material icon named "cast connected sharp".
  static const IconData cast_connected_sharp = IconData(0xebd1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cast_for_education</i> &#x2014; material icon named "cast for education".
  static const IconData cast_for_education = IconData(0xe642, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cast_for_education</i> &#x2014; material icon named "cast for education outlined".
  static const IconData cast_for_education_outlined = IconData(0xe0d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cast_for_education</i> &#x2014; material icon named "cast for education rounded".
  static const IconData cast_for_education_rounded = IconData(0xf100, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cast_for_education</i> &#x2014; material icon named "cast for education sharp".
  static const IconData cast_for_education_sharp = IconData(0xebd2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cast</i> &#x2014; material icon named "cast outlined".
  static const IconData cast_outlined = IconData(0xe0d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cast</i> &#x2014; material icon named "cast rounded".
  static const IconData cast_rounded = IconData(0xf101, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cast</i> &#x2014; material icon named "cast sharp".
  static const IconData cast_sharp = IconData(0xebd3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">category</i> &#x2014; material icon named "category".
  static const IconData category = IconData(0xe643, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">category</i> &#x2014; material icon named "category outlined".
  static const IconData category_outlined = IconData(0xe0d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">category</i> &#x2014; material icon named "category rounded".
  static const IconData category_rounded = IconData(0xf102, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">category</i> &#x2014; material icon named "category sharp".
  static const IconData category_sharp = IconData(0xebd4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">celebration</i> &#x2014; material icon named "celebration".
  static const IconData celebration = IconData(0xe644, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">center_focus_strong</i> &#x2014; material icon named "center focus strong".
  static const IconData center_focus_strong = IconData(0xe645, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">center_focus_strong</i> &#x2014; material icon named "center focus strong outlined".
  static const IconData center_focus_strong_outlined = IconData(0xe0d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">center_focus_strong</i> &#x2014; material icon named "center focus strong rounded".
  static const IconData center_focus_strong_rounded = IconData(0xf103, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">center_focus_strong</i> &#x2014; material icon named "center focus strong sharp".
  static const IconData center_focus_strong_sharp = IconData(0xebd5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">center_focus_weak</i> &#x2014; material icon named "center focus weak".
  static const IconData center_focus_weak = IconData(0xe646, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">center_focus_weak</i> &#x2014; material icon named "center focus weak outlined".
  static const IconData center_focus_weak_outlined = IconData(0xe0d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">center_focus_weak</i> &#x2014; material icon named "center focus weak rounded".
  static const IconData center_focus_weak_rounded = IconData(0xf104, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">center_focus_weak</i> &#x2014; material icon named "center focus weak sharp".
  static const IconData center_focus_weak_sharp = IconData(0xebd6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">change_history</i> &#x2014; material icon named "change history".
  static const IconData change_history = IconData(0xe647, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">change_history</i> &#x2014; material icon named "change history outlined".
  static const IconData change_history_outlined = IconData(0xe0d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">change_history</i> &#x2014; material icon named "change history rounded".
  static const IconData change_history_rounded = IconData(0xf105, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">change_history</i> &#x2014; material icon named "change history sharp".
  static const IconData change_history_sharp = IconData(0xebd7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">charging_station</i> &#x2014; material icon named "charging station".
  static const IconData charging_station = IconData(0xe648, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">charging_station</i> &#x2014; material icon named "charging station outlined".
  static const IconData charging_station_outlined = IconData(0xe0d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">charging_station</i> &#x2014; material icon named "charging station rounded".
  static const IconData charging_station_rounded = IconData(0xf106, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">charging_station</i> &#x2014; material icon named "charging station sharp".
  static const IconData charging_station_sharp = IconData(0xebd8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chat</i> &#x2014; material icon named "chat".
  static const IconData chat = IconData(0xe649, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chat_bubble</i> &#x2014; material icon named "chat bubble".
  static const IconData chat_bubble = IconData(0xe64a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chat_bubble_outline</i> &#x2014; material icon named "chat bubble outline".
  static const IconData chat_bubble_outline = IconData(0xe64b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">chat_bubble_outline</i> &#x2014; material icon named "chat bubble outline outlined".
  static const IconData chat_bubble_outline_outlined = IconData(0xe0d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chat_bubble_outline</i> &#x2014; material icon named "chat bubble outline rounded".
  static const IconData chat_bubble_outline_rounded = IconData(0xf107, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chat_bubble_outline</i> &#x2014; material icon named "chat bubble outline sharp".
  static const IconData chat_bubble_outline_sharp = IconData(0xebd9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">chat_bubble</i> &#x2014; material icon named "chat bubble outlined".
  static const IconData chat_bubble_outlined = IconData(0xe0da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chat_bubble</i> &#x2014; material icon named "chat bubble rounded".
  static const IconData chat_bubble_rounded = IconData(0xf108, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chat_bubble</i> &#x2014; material icon named "chat bubble sharp".
  static const IconData chat_bubble_sharp = IconData(0xebda, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">chat</i> &#x2014; material icon named "chat outlined".
  static const IconData chat_outlined = IconData(0xe0db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chat</i> &#x2014; material icon named "chat rounded".
  static const IconData chat_rounded = IconData(0xf109, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chat</i> &#x2014; material icon named "chat sharp".
  static const IconData chat_sharp = IconData(0xebdb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check</i> &#x2014; material icon named "check".
  static const IconData check = IconData(0xe64c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_box</i> &#x2014; material icon named "check box".
  static const IconData check_box = IconData(0xe64d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_box_outline_blank</i> &#x2014; material icon named "check box outline blank".
  static const IconData check_box_outline_blank = IconData(0xe64e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check_box_outline_blank</i> &#x2014; material icon named "check box outline blank outlined".
  static const IconData check_box_outline_blank_outlined = IconData(0xe0dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check_box_outline_blank</i> &#x2014; material icon named "check box outline blank rounded".
  static const IconData check_box_outline_blank_rounded = IconData(0xf10a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check_box_outline_blank</i> &#x2014; material icon named "check box outline blank sharp".
  static const IconData check_box_outline_blank_sharp = IconData(0xebdc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check_box</i> &#x2014; material icon named "check box outlined".
  static const IconData check_box_outlined = IconData(0xe0dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check_box</i> &#x2014; material icon named "check box rounded".
  static const IconData check_box_rounded = IconData(0xf10b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check_box</i> &#x2014; material icon named "check box sharp".
  static const IconData check_box_sharp = IconData(0xebdd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_circle</i> &#x2014; material icon named "check circle".
  static const IconData check_circle = IconData(0xe64f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_circle_outline</i> &#x2014; material icon named "check circle outline".
  static const IconData check_circle_outline = IconData(0xe650, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check_circle_outline</i> &#x2014; material icon named "check circle outline outlined".
  static const IconData check_circle_outline_outlined = IconData(0xe0de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check_circle_outline</i> &#x2014; material icon named "check circle outline rounded".
  static const IconData check_circle_outline_rounded = IconData(0xf10c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check_circle_outline</i> &#x2014; material icon named "check circle outline sharp".
  static const IconData check_circle_outline_sharp = IconData(0xebde, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check_circle</i> &#x2014; material icon named "check circle outlined".
  static const IconData check_circle_outlined = IconData(0xe0df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check_circle</i> &#x2014; material icon named "check circle rounded".
  static const IconData check_circle_rounded = IconData(0xf10d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check_circle</i> &#x2014; material icon named "check circle sharp".
  static const IconData check_circle_sharp = IconData(0xebdf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check</i> &#x2014; material icon named "check outlined".
  static const IconData check_outlined = IconData(0xe0e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check</i> &#x2014; material icon named "check rounded".
  static const IconData check_rounded = IconData(0xf10e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check</i> &#x2014; material icon named "check sharp".
  static const IconData check_sharp = IconData(0xebe0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">checkroom</i> &#x2014; material icon named "checkroom".
  static const IconData checkroom = IconData(0xe651, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">checkroom</i> &#x2014; material icon named "checkroom outlined".
  static const IconData checkroom_outlined = IconData(0xe0e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">checkroom</i> &#x2014; material icon named "checkroom rounded".
  static const IconData checkroom_rounded = IconData(0xf10f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">checkroom</i> &#x2014; material icon named "checkroom sharp".
  static const IconData checkroom_sharp = IconData(0xebe1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chevron_left</i> &#x2014; material icon named "chevron left".
  static const IconData chevron_left = IconData(0xe652, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">chevron_left</i> &#x2014; material icon named "chevron left outlined".
  static const IconData chevron_left_outlined = IconData(0xe0e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chevron_left</i> &#x2014; material icon named "chevron left rounded".
  static const IconData chevron_left_rounded = IconData(0xf110, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chevron_left</i> &#x2014; material icon named "chevron left sharp".
  static const IconData chevron_left_sharp = IconData(0xebe2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chevron_right</i> &#x2014; material icon named "chevron right".
  static const IconData chevron_right = IconData(0xe653, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">chevron_right</i> &#x2014; material icon named "chevron right outlined".
  static const IconData chevron_right_outlined = IconData(0xe0e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chevron_right</i> &#x2014; material icon named "chevron right rounded".
  static const IconData chevron_right_rounded = IconData(0xf111, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chevron_right</i> &#x2014; material icon named "chevron right sharp".
  static const IconData chevron_right_sharp = IconData(0xebe3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">child_care</i> &#x2014; material icon named "child care".
  static const IconData child_care = IconData(0xe654, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">child_care</i> &#x2014; material icon named "child care outlined".
  static const IconData child_care_outlined = IconData(0xe0e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">child_care</i> &#x2014; material icon named "child care rounded".
  static const IconData child_care_rounded = IconData(0xf112, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">child_care</i> &#x2014; material icon named "child care sharp".
  static const IconData child_care_sharp = IconData(0xebe4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">child_friendly</i> &#x2014; material icon named "child friendly".
  static const IconData child_friendly = IconData(0xe655, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">child_friendly</i> &#x2014; material icon named "child friendly outlined".
  static const IconData child_friendly_outlined = IconData(0xe0e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">child_friendly</i> &#x2014; material icon named "child friendly rounded".
  static const IconData child_friendly_rounded = IconData(0xf113, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">child_friendly</i> &#x2014; material icon named "child friendly sharp".
  static const IconData child_friendly_sharp = IconData(0xebe5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chrome_reader_mode</i> &#x2014; material icon named "chrome reader mode".
  static const IconData chrome_reader_mode = IconData(0xe656, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">chrome_reader_mode</i> &#x2014; material icon named "chrome reader mode outlined".
  static const IconData chrome_reader_mode_outlined = IconData(0xe0e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chrome_reader_mode</i> &#x2014; material icon named "chrome reader mode rounded".
  static const IconData chrome_reader_mode_rounded = IconData(0xf114, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chrome_reader_mode</i> &#x2014; material icon named "chrome reader mode sharp".
  static const IconData chrome_reader_mode_sharp = IconData(0xebe6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">circle</i> &#x2014; material icon named "circle".
  static const IconData circle = IconData(0xe657, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">circle_notifications</i> &#x2014; material icon named "circle notifications".
  static const IconData circle_notifications = IconData(0xe658, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">class</i> &#x2014; material icon named "class".
  static const IconData class_ = IconData(0xe659, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">class</i> &#x2014; material icon named "class outlined".
  static const IconData class__outlined = IconData(0xe0e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">class</i> &#x2014; material icon named "class rounded".
  static const IconData class__rounded = IconData(0xf115, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">class</i> &#x2014; material icon named "class sharp".
  static const IconData class__sharp = IconData(0xebe7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">clean_hands</i> &#x2014; material icon named "clean hands".
  static const IconData clean_hands = IconData(0xe65a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">clean_hands</i> &#x2014; material icon named "clean hands outlined".
  static const IconData clean_hands_outlined = IconData(0xe0e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">clean_hands</i> &#x2014; material icon named "clean hands rounded".
  static const IconData clean_hands_rounded = IconData(0xf116, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">clean_hands</i> &#x2014; material icon named "clean hands sharp".
  static const IconData clean_hands_sharp = IconData(0xebe8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cleaning_services</i> &#x2014; material icon named "cleaning services".
  static const IconData cleaning_services = IconData(0xe65b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cleaning_services</i> &#x2014; material icon named "cleaning services outlined".
  static const IconData cleaning_services_outlined = IconData(0xe0e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cleaning_services</i> &#x2014; material icon named "cleaning services rounded".
  static const IconData cleaning_services_rounded = IconData(0xf117, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cleaning_services</i> &#x2014; material icon named "cleaning services sharp".
  static const IconData cleaning_services_sharp = IconData(0xebe9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">clear</i> &#x2014; material icon named "clear".
  static const IconData clear = IconData(0xe65c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">clear_all</i> &#x2014; material icon named "clear all".
  static const IconData clear_all = IconData(0xe65d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">clear_all</i> &#x2014; material icon named "clear all outlined".
  static const IconData clear_all_outlined = IconData(0xe0ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">clear_all</i> &#x2014; material icon named "clear all rounded".
  static const IconData clear_all_rounded = IconData(0xf118, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">clear_all</i> &#x2014; material icon named "clear all sharp".
  static const IconData clear_all_sharp = IconData(0xebea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">clear</i> &#x2014; material icon named "clear outlined".
  static const IconData clear_outlined = IconData(0xe0eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">clear</i> &#x2014; material icon named "clear rounded".
  static const IconData clear_rounded = IconData(0xf119, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">clear</i> &#x2014; material icon named "clear sharp".
  static const IconData clear_sharp = IconData(0xebeb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">close</i> &#x2014; material icon named "close".
  static const IconData close = IconData(0xe65e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">close_fullscreen</i> &#x2014; material icon named "close fullscreen".
  static const IconData close_fullscreen = IconData(0xe65f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">close_fullscreen</i> &#x2014; material icon named "close fullscreen outlined".
  static const IconData close_fullscreen_outlined = IconData(0xe0ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">close_fullscreen</i> &#x2014; material icon named "close fullscreen rounded".
  static const IconData close_fullscreen_rounded = IconData(0xf11a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">close_fullscreen</i> &#x2014; material icon named "close fullscreen sharp".
  static const IconData close_fullscreen_sharp = IconData(0xebec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">close</i> &#x2014; material icon named "close outlined".
  static const IconData close_outlined = IconData(0xe0ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">close</i> &#x2014; material icon named "close rounded".
  static const IconData close_rounded = IconData(0xf11b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">close</i> &#x2014; material icon named "close sharp".
  static const IconData close_sharp = IconData(0xebed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">closed_caption</i> &#x2014; material icon named "closed caption".
  static const IconData closed_caption = IconData(0xe660, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">closed_caption_disabled</i> &#x2014; material icon named "closed caption disabled".
  static const IconData closed_caption_disabled = IconData(0xe661, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">closed_caption_disabled</i> &#x2014; material icon named "closed caption disabled outlined".
  static const IconData closed_caption_disabled_outlined = IconData(0xe0ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">closed_caption_disabled</i> &#x2014; material icon named "closed caption disabled rounded".
  static const IconData closed_caption_disabled_rounded = IconData(0xf11c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">closed_caption_disabled</i> &#x2014; material icon named "closed caption disabled sharp".
  static const IconData closed_caption_disabled_sharp = IconData(0xebee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">closed_caption_off</i> &#x2014; material icon named "closed caption off".
  static const IconData closed_caption_off = IconData(0xe662, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">closed_caption</i> &#x2014; material icon named "closed caption outlined".
  static const IconData closed_caption_outlined = IconData(0xe0ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">closed_caption</i> &#x2014; material icon named "closed caption rounded".
  static const IconData closed_caption_rounded = IconData(0xf11d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">closed_caption</i> &#x2014; material icon named "closed caption sharp".
  static const IconData closed_caption_sharp = IconData(0xebef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud</i> &#x2014; material icon named "cloud".
  static const IconData cloud = IconData(0xe663, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_circle</i> &#x2014; material icon named "cloud circle".
  static const IconData cloud_circle = IconData(0xe664, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_circle</i> &#x2014; material icon named "cloud circle outlined".
  static const IconData cloud_circle_outlined = IconData(0xe0f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_circle</i> &#x2014; material icon named "cloud circle rounded".
  static const IconData cloud_circle_rounded = IconData(0xf11e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_circle</i> &#x2014; material icon named "cloud circle sharp".
  static const IconData cloud_circle_sharp = IconData(0xebf0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_done</i> &#x2014; material icon named "cloud done".
  static const IconData cloud_done = IconData(0xe665, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_done</i> &#x2014; material icon named "cloud done outlined".
  static const IconData cloud_done_outlined = IconData(0xe0f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_done</i> &#x2014; material icon named "cloud done rounded".
  static const IconData cloud_done_rounded = IconData(0xf11f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_done</i> &#x2014; material icon named "cloud done sharp".
  static const IconData cloud_done_sharp = IconData(0xebf1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_download</i> &#x2014; material icon named "cloud download".
  static const IconData cloud_download = IconData(0xe666, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_download</i> &#x2014; material icon named "cloud download outlined".
  static const IconData cloud_download_outlined = IconData(0xe0f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_download</i> &#x2014; material icon named "cloud download rounded".
  static const IconData cloud_download_rounded = IconData(0xf120, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_download</i> &#x2014; material icon named "cloud download sharp".
  static const IconData cloud_download_sharp = IconData(0xebf2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_off</i> &#x2014; material icon named "cloud off".
  static const IconData cloud_off = IconData(0xe667, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_off</i> &#x2014; material icon named "cloud off outlined".
  static const IconData cloud_off_outlined = IconData(0xe0f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_off</i> &#x2014; material icon named "cloud off rounded".
  static const IconData cloud_off_rounded = IconData(0xf121, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_off</i> &#x2014; material icon named "cloud off sharp".
  static const IconData cloud_off_sharp = IconData(0xebf3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud</i> &#x2014; material icon named "cloud outlined".
  static const IconData cloud_outlined = IconData(0xe0f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_queue</i> &#x2014; material icon named "cloud queue".
  static const IconData cloud_queue = IconData(0xe668, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_queue</i> &#x2014; material icon named "cloud queue outlined".
  static const IconData cloud_queue_outlined = IconData(0xe0f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_queue</i> &#x2014; material icon named "cloud queue rounded".
  static const IconData cloud_queue_rounded = IconData(0xf122, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_queue</i> &#x2014; material icon named "cloud queue sharp".
  static const IconData cloud_queue_sharp = IconData(0xebf4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud</i> &#x2014; material icon named "cloud rounded".
  static const IconData cloud_rounded = IconData(0xf123, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud</i> &#x2014; material icon named "cloud sharp".
  static const IconData cloud_sharp = IconData(0xebf5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_upload</i> &#x2014; material icon named "cloud upload".
  static const IconData cloud_upload = IconData(0xe669, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_upload</i> &#x2014; material icon named "cloud upload outlined".
  static const IconData cloud_upload_outlined = IconData(0xe0f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_upload</i> &#x2014; material icon named "cloud upload rounded".
  static const IconData cloud_upload_rounded = IconData(0xf124, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_upload</i> &#x2014; material icon named "cloud upload sharp".
  static const IconData cloud_upload_sharp = IconData(0xebf6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">code</i> &#x2014; material icon named "code".
  static const IconData code = IconData(0xe66a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">code</i> &#x2014; material icon named "code outlined".
  static const IconData code_outlined = IconData(0xe0f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">code</i> &#x2014; material icon named "code rounded".
  static const IconData code_rounded = IconData(0xf125, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">code</i> &#x2014; material icon named "code sharp".
  static const IconData code_sharp = IconData(0xebf7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">collections</i> &#x2014; material icon named "collections".
  static const IconData collections = IconData(0xe66b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">collections_bookmark</i> &#x2014; material icon named "collections bookmark".
  static const IconData collections_bookmark = IconData(0xe66c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">collections_bookmark</i> &#x2014; material icon named "collections bookmark outlined".
  static const IconData collections_bookmark_outlined = IconData(0xe0f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">collections_bookmark</i> &#x2014; material icon named "collections bookmark rounded".
  static const IconData collections_bookmark_rounded = IconData(0xf126, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">collections_bookmark</i> &#x2014; material icon named "collections bookmark sharp".
  static const IconData collections_bookmark_sharp = IconData(0xebf8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">collections</i> &#x2014; material icon named "collections outlined".
  static const IconData collections_outlined = IconData(0xe0f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">collections</i> &#x2014; material icon named "collections rounded".
  static const IconData collections_rounded = IconData(0xf127, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">collections</i> &#x2014; material icon named "collections sharp".
  static const IconData collections_sharp = IconData(0xebf9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">color_lens</i> &#x2014; material icon named "color lens".
  static const IconData color_lens = IconData(0xe66d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">color_lens</i> &#x2014; material icon named "color lens outlined".
  static const IconData color_lens_outlined = IconData(0xe0fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">color_lens</i> &#x2014; material icon named "color lens rounded".
  static const IconData color_lens_rounded = IconData(0xf128, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">color_lens</i> &#x2014; material icon named "color lens sharp".
  static const IconData color_lens_sharp = IconData(0xebfa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">colorize</i> &#x2014; material icon named "colorize".
  static const IconData colorize = IconData(0xe66e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">colorize</i> &#x2014; material icon named "colorize outlined".
  static const IconData colorize_outlined = IconData(0xe0fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">colorize</i> &#x2014; material icon named "colorize rounded".
  static const IconData colorize_rounded = IconData(0xf129, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">colorize</i> &#x2014; material icon named "colorize sharp".
  static const IconData colorize_sharp = IconData(0xebfb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">comment</i> &#x2014; material icon named "comment".
  static const IconData comment = IconData(0xe66f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">comment_bank</i> &#x2014; material icon named "comment bank".
  static const IconData comment_bank = IconData(0xe670, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">comment_bank</i> &#x2014; material icon named "comment bank outlined".
  static const IconData comment_bank_outlined = IconData(0xe0fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">comment_bank</i> &#x2014; material icon named "comment bank rounded".
  static const IconData comment_bank_rounded = IconData(0xf12a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">comment_bank</i> &#x2014; material icon named "comment bank sharp".
  static const IconData comment_bank_sharp = IconData(0xebfc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">comment</i> &#x2014; material icon named "comment outlined".
  static const IconData comment_outlined = IconData(0xe0fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">comment</i> &#x2014; material icon named "comment rounded".
  static const IconData comment_rounded = IconData(0xf12b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">comment</i> &#x2014; material icon named "comment sharp".
  static const IconData comment_sharp = IconData(0xebfd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">commute</i> &#x2014; material icon named "commute".
  static const IconData commute = IconData(0xe671, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">commute</i> &#x2014; material icon named "commute outlined".
  static const IconData commute_outlined = IconData(0xe0fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">commute</i> &#x2014; material icon named "commute rounded".
  static const IconData commute_rounded = IconData(0xf12c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">commute</i> &#x2014; material icon named "commute sharp".
  static const IconData commute_sharp = IconData(0xebfe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compare</i> &#x2014; material icon named "compare".
  static const IconData compare = IconData(0xe672, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compare_arrows</i> &#x2014; material icon named "compare arrows".
  static const IconData compare_arrows = IconData(0xe673, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">compare_arrows</i> &#x2014; material icon named "compare arrows outlined".
  static const IconData compare_arrows_outlined = IconData(0xe0ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">compare_arrows</i> &#x2014; material icon named "compare arrows rounded".
  static const IconData compare_arrows_rounded = IconData(0xf12d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">compare_arrows</i> &#x2014; material icon named "compare arrows sharp".
  static const IconData compare_arrows_sharp = IconData(0xebff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">compare</i> &#x2014; material icon named "compare outlined".
  static const IconData compare_outlined = IconData(0xe100, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">compare</i> &#x2014; material icon named "compare rounded".
  static const IconData compare_rounded = IconData(0xf12e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">compare</i> &#x2014; material icon named "compare sharp".
  static const IconData compare_sharp = IconData(0xec00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compass_calibration</i> &#x2014; material icon named "compass calibration".
  static const IconData compass_calibration = IconData(0xe674, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">compass_calibration</i> &#x2014; material icon named "compass calibration outlined".
  static const IconData compass_calibration_outlined = IconData(0xe101, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">compass_calibration</i> &#x2014; material icon named "compass calibration rounded".
  static const IconData compass_calibration_rounded = IconData(0xf12f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">compass_calibration</i> &#x2014; material icon named "compass calibration sharp".
  static const IconData compass_calibration_sharp = IconData(0xec01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compress</i> &#x2014; material icon named "compress".
  static const IconData compress = IconData(0xe675, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">computer</i> &#x2014; material icon named "computer".
  static const IconData computer = IconData(0xe676, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">computer</i> &#x2014; material icon named "computer outlined".
  static const IconData computer_outlined = IconData(0xe102, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">computer</i> &#x2014; material icon named "computer rounded".
  static const IconData computer_rounded = IconData(0xf130, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">computer</i> &#x2014; material icon named "computer sharp".
  static const IconData computer_sharp = IconData(0xec02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">confirmation_num</i> &#x2014; material icon named "confirmation num".
  static const IconData confirmation_num = IconData(0xe677, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">confirmation_num</i> &#x2014; material icon named "confirmation num outlined".
  static const IconData confirmation_num_outlined = IconData(0xe103, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">confirmation_num</i> &#x2014; material icon named "confirmation num rounded".
  static const IconData confirmation_num_rounded = IconData(0xf131, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">confirmation_num</i> &#x2014; material icon named "confirmation num sharp".
  static const IconData confirmation_num_sharp = IconData(0xec03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">confirmation_number</i> &#x2014; material icon named "confirmation number".
  static const IconData confirmation_number = IconData(0xe677, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">confirmation_number</i> &#x2014; material icon named "confirmation number outlined".
  static const IconData confirmation_number_outlined = IconData(0xe103, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">confirmation_number</i> &#x2014; material icon named "confirmation number rounded".
  static const IconData confirmation_number_rounded = IconData(0xf131, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">confirmation_number</i> &#x2014; material icon named "confirmation number sharp".
  static const IconData confirmation_number_sharp = IconData(0xec03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">connect_without_contact</i> &#x2014; material icon named "connect without contact".
  static const IconData connect_without_contact = IconData(0xe678, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">connect_without_contact</i> &#x2014; material icon named "connect without contact outlined".
  static const IconData connect_without_contact_outlined = IconData(0xe104, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">connect_without_contact</i> &#x2014; material icon named "connect without contact rounded".
  static const IconData connect_without_contact_rounded = IconData(0xf132, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">connect_without_contact</i> &#x2014; material icon named "connect without contact sharp".
  static const IconData connect_without_contact_sharp = IconData(0xec04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">connected_tv</i> &#x2014; material icon named "connected tv".
  static const IconData connected_tv = IconData(0xe679, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">construction</i> &#x2014; material icon named "construction".
  static const IconData construction = IconData(0xe67a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">construction</i> &#x2014; material icon named "construction outlined".
  static const IconData construction_outlined = IconData(0xe105, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">construction</i> &#x2014; material icon named "construction rounded".
  static const IconData construction_rounded = IconData(0xf133, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">construction</i> &#x2014; material icon named "construction sharp".
  static const IconData construction_sharp = IconData(0xec05, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_mail</i> &#x2014; material icon named "contact mail".
  static const IconData contact_mail = IconData(0xe67b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contact_mail</i> &#x2014; material icon named "contact mail outlined".
  static const IconData contact_mail_outlined = IconData(0xe106, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contact_mail</i> &#x2014; material icon named "contact mail rounded".
  static const IconData contact_mail_rounded = IconData(0xf134, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contact_mail</i> &#x2014; material icon named "contact mail sharp".
  static const IconData contact_mail_sharp = IconData(0xec06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_page</i> &#x2014; material icon named "contact page".
  static const IconData contact_page = IconData(0xe67c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contact_page</i> &#x2014; material icon named "contact page outlined".
  static const IconData contact_page_outlined = IconData(0xe107, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contact_page</i> &#x2014; material icon named "contact page rounded".
  static const IconData contact_page_rounded = IconData(0xf135, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contact_page</i> &#x2014; material icon named "contact page sharp".
  static const IconData contact_page_sharp = IconData(0xec07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_phone</i> &#x2014; material icon named "contact phone".
  static const IconData contact_phone = IconData(0xe67d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contact_phone</i> &#x2014; material icon named "contact phone outlined".
  static const IconData contact_phone_outlined = IconData(0xe108, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contact_phone</i> &#x2014; material icon named "contact phone rounded".
  static const IconData contact_phone_rounded = IconData(0xf136, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contact_phone</i> &#x2014; material icon named "contact phone sharp".
  static const IconData contact_phone_sharp = IconData(0xec08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_support</i> &#x2014; material icon named "contact support".
  static const IconData contact_support = IconData(0xe67e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contact_support</i> &#x2014; material icon named "contact support outlined".
  static const IconData contact_support_outlined = IconData(0xe109, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contact_support</i> &#x2014; material icon named "contact support rounded".
  static const IconData contact_support_rounded = IconData(0xf137, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contact_support</i> &#x2014; material icon named "contact support sharp".
  static const IconData contact_support_sharp = IconData(0xec09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contactless</i> &#x2014; material icon named "contactless".
  static const IconData contactless = IconData(0xe67f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contactless</i> &#x2014; material icon named "contactless outlined".
  static const IconData contactless_outlined = IconData(0xe10a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contactless</i> &#x2014; material icon named "contactless rounded".
  static const IconData contactless_rounded = IconData(0xf138, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contactless</i> &#x2014; material icon named "contactless sharp".
  static const IconData contactless_sharp = IconData(0xec0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contacts</i> &#x2014; material icon named "contacts".
  static const IconData contacts = IconData(0xe680, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contacts</i> &#x2014; material icon named "contacts outlined".
  static const IconData contacts_outlined = IconData(0xe10b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contacts</i> &#x2014; material icon named "contacts rounded".
  static const IconData contacts_rounded = IconData(0xf139, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contacts</i> &#x2014; material icon named "contacts sharp".
  static const IconData contacts_sharp = IconData(0xec0b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_copy</i> &#x2014; material icon named "content copy".
  static const IconData content_copy = IconData(0xe681, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">content_copy</i> &#x2014; material icon named "content copy outlined".
  static const IconData content_copy_outlined = IconData(0xe10c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">content_copy</i> &#x2014; material icon named "content copy rounded".
  static const IconData content_copy_rounded = IconData(0xf13a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">content_copy</i> &#x2014; material icon named "content copy sharp".
  static const IconData content_copy_sharp = IconData(0xec0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_cut</i> &#x2014; material icon named "content cut".
  static const IconData content_cut = IconData(0xe682, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">content_cut</i> &#x2014; material icon named "content cut outlined".
  static const IconData content_cut_outlined = IconData(0xe10d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">content_cut</i> &#x2014; material icon named "content cut rounded".
  static const IconData content_cut_rounded = IconData(0xf13b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">content_cut</i> &#x2014; material icon named "content cut sharp".
  static const IconData content_cut_sharp = IconData(0xec0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_paste</i> &#x2014; material icon named "content paste".
  static const IconData content_paste = IconData(0xe683, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">content_paste</i> &#x2014; material icon named "content paste outlined".
  static const IconData content_paste_outlined = IconData(0xe10e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">content_paste</i> &#x2014; material icon named "content paste rounded".
  static const IconData content_paste_rounded = IconData(0xf13c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">content_paste</i> &#x2014; material icon named "content paste sharp".
  static const IconData content_paste_sharp = IconData(0xec0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">control_camera</i> &#x2014; material icon named "control camera".
  static const IconData control_camera = IconData(0xe684, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">control_camera</i> &#x2014; material icon named "control camera outlined".
  static const IconData control_camera_outlined = IconData(0xe10f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">control_camera</i> &#x2014; material icon named "control camera rounded".
  static const IconData control_camera_rounded = IconData(0xf13d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">control_camera</i> &#x2014; material icon named "control camera sharp".
  static const IconData control_camera_sharp = IconData(0xec0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">control_point</i> &#x2014; material icon named "control point".
  static const IconData control_point = IconData(0xe685, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">control_point_duplicate</i> &#x2014; material icon named "control point duplicate".
  static const IconData control_point_duplicate = IconData(0xe686, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">control_point_duplicate</i> &#x2014; material icon named "control point duplicate outlined".
  static const IconData control_point_duplicate_outlined = IconData(0xe110, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">control_point_duplicate</i> &#x2014; material icon named "control point duplicate rounded".
  static const IconData control_point_duplicate_rounded = IconData(0xf13e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">control_point_duplicate</i> &#x2014; material icon named "control point duplicate sharp".
  static const IconData control_point_duplicate_sharp = IconData(0xec10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">control_point</i> &#x2014; material icon named "control point outlined".
  static const IconData control_point_outlined = IconData(0xe111, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">control_point</i> &#x2014; material icon named "control point rounded".
  static const IconData control_point_rounded = IconData(0xf13f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">control_point</i> &#x2014; material icon named "control point sharp".
  static const IconData control_point_sharp = IconData(0xec11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">copy</i> &#x2014; material icon named "copy".
  static const IconData copy = IconData(0xe681, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">copy</i> &#x2014; material icon named "copy outlined".
  static const IconData copy_outlined = IconData(0xe10c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">copy</i> &#x2014; material icon named "copy rounded".
  static const IconData copy_rounded = IconData(0xf13a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">copy</i> &#x2014; material icon named "copy sharp".
  static const IconData copy_sharp = IconData(0xec0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">copyright</i> &#x2014; material icon named "copyright".
  static const IconData copyright = IconData(0xe687, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">copyright</i> &#x2014; material icon named "copyright outlined".
  static const IconData copyright_outlined = IconData(0xe112, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">copyright</i> &#x2014; material icon named "copyright rounded".
  static const IconData copyright_rounded = IconData(0xf140, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">copyright</i> &#x2014; material icon named "copyright sharp".
  static const IconData copyright_sharp = IconData(0xec12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">coronavirus</i> &#x2014; material icon named "coronavirus".
  static const IconData coronavirus = IconData(0xe688, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">coronavirus</i> &#x2014; material icon named "coronavirus outlined".
  static const IconData coronavirus_outlined = IconData(0xe113, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">coronavirus</i> &#x2014; material icon named "coronavirus rounded".
  static const IconData coronavirus_rounded = IconData(0xf141, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">coronavirus</i> &#x2014; material icon named "coronavirus sharp".
  static const IconData coronavirus_sharp = IconData(0xec13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">corporate_fare</i> &#x2014; material icon named "corporate fare".
  static const IconData corporate_fare = IconData(0xe689, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">corporate_fare</i> &#x2014; material icon named "corporate fare outlined".
  static const IconData corporate_fare_outlined = IconData(0xe114, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">corporate_fare</i> &#x2014; material icon named "corporate fare rounded".
  static const IconData corporate_fare_rounded = IconData(0xf142, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">corporate_fare</i> &#x2014; material icon named "corporate fare sharp".
  static const IconData corporate_fare_sharp = IconData(0xec14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">countertops</i> &#x2014; material icon named "countertops".
  static const IconData countertops = IconData(0xe68a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">countertops</i> &#x2014; material icon named "countertops outlined".
  static const IconData countertops_outlined = IconData(0xe115, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">countertops</i> &#x2014; material icon named "countertops rounded".
  static const IconData countertops_rounded = IconData(0xf143, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">countertops</i> &#x2014; material icon named "countertops sharp".
  static const IconData countertops_sharp = IconData(0xec15, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">create</i> &#x2014; material icon named "create".
  static const IconData create = IconData(0xe68b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">create_new_folder</i> &#x2014; material icon named "create new folder".
  static const IconData create_new_folder = IconData(0xe68c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">create_new_folder</i> &#x2014; material icon named "create new folder outlined".
  static const IconData create_new_folder_outlined = IconData(0xe116, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">create_new_folder</i> &#x2014; material icon named "create new folder rounded".
  static const IconData create_new_folder_rounded = IconData(0xf144, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">create_new_folder</i> &#x2014; material icon named "create new folder sharp".
  static const IconData create_new_folder_sharp = IconData(0xec16, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">create</i> &#x2014; material icon named "create outlined".
  static const IconData create_outlined = IconData(0xe117, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">create</i> &#x2014; material icon named "create rounded".
  static const IconData create_rounded = IconData(0xf145, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">create</i> &#x2014; material icon named "create sharp".
  static const IconData create_sharp = IconData(0xec17, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">credit_card</i> &#x2014; material icon named "credit card".
  static const IconData credit_card = IconData(0xe68d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">credit_card</i> &#x2014; material icon named "credit card outlined".
  static const IconData credit_card_outlined = IconData(0xe118, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">credit_card</i> &#x2014; material icon named "credit card rounded".
  static const IconData credit_card_rounded = IconData(0xf146, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">credit_card</i> &#x2014; material icon named "credit card sharp".
  static const IconData credit_card_sharp = IconData(0xec18, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop</i> &#x2014; material icon named "crop".
  static const IconData crop = IconData(0xe68e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_16_9</i> &#x2014; material icon named "crop 16 9".
  static const IconData crop_16_9 = IconData(0xe68f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_16_9</i> &#x2014; material icon named "crop 16 9 outlined".
  static const IconData crop_16_9_outlined = IconData(0xe119, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_16_9</i> &#x2014; material icon named "crop 16 9 rounded".
  static const IconData crop_16_9_rounded = IconData(0xf147, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_16_9</i> &#x2014; material icon named "crop 16 9 sharp".
  static const IconData crop_16_9_sharp = IconData(0xec19, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_3_2</i> &#x2014; material icon named "crop 3 2".
  static const IconData crop_3_2 = IconData(0xe690, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_3_2</i> &#x2014; material icon named "crop 3 2 outlined".
  static const IconData crop_3_2_outlined = IconData(0xe11a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_3_2</i> &#x2014; material icon named "crop 3 2 rounded".
  static const IconData crop_3_2_rounded = IconData(0xf148, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_3_2</i> &#x2014; material icon named "crop 3 2 sharp".
  static const IconData crop_3_2_sharp = IconData(0xec1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_5_4</i> &#x2014; material icon named "crop 5 4".
  static const IconData crop_5_4 = IconData(0xe691, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_5_4</i> &#x2014; material icon named "crop 5 4 outlined".
  static const IconData crop_5_4_outlined = IconData(0xe11b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_5_4</i> &#x2014; material icon named "crop 5 4 rounded".
  static const IconData crop_5_4_rounded = IconData(0xf149, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_5_4</i> &#x2014; material icon named "crop 5 4 sharp".
  static const IconData crop_5_4_sharp = IconData(0xec1b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_7_5</i> &#x2014; material icon named "crop 7 5".
  static const IconData crop_7_5 = IconData(0xe692, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_7_5</i> &#x2014; material icon named "crop 7 5 outlined".
  static const IconData crop_7_5_outlined = IconData(0xe11c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_7_5</i> &#x2014; material icon named "crop 7 5 rounded".
  static const IconData crop_7_5_rounded = IconData(0xf14a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_7_5</i> &#x2014; material icon named "crop 7 5 sharp".
  static const IconData crop_7_5_sharp = IconData(0xec1c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_din</i> &#x2014; material icon named "crop din".
  static const IconData crop_din = IconData(0xe693, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_din</i> &#x2014; material icon named "crop din outlined".
  static const IconData crop_din_outlined = IconData(0xe11d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_din</i> &#x2014; material icon named "crop din rounded".
  static const IconData crop_din_rounded = IconData(0xf14b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_din</i> &#x2014; material icon named "crop din sharp".
  static const IconData crop_din_sharp = IconData(0xec1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_free</i> &#x2014; material icon named "crop free".
  static const IconData crop_free = IconData(0xe694, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_free</i> &#x2014; material icon named "crop free outlined".
  static const IconData crop_free_outlined = IconData(0xe11e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_free</i> &#x2014; material icon named "crop free rounded".
  static const IconData crop_free_rounded = IconData(0xf14c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_free</i> &#x2014; material icon named "crop free sharp".
  static const IconData crop_free_sharp = IconData(0xec1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_landscape</i> &#x2014; material icon named "crop landscape".
  static const IconData crop_landscape = IconData(0xe695, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_landscape</i> &#x2014; material icon named "crop landscape outlined".
  static const IconData crop_landscape_outlined = IconData(0xe11f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_landscape</i> &#x2014; material icon named "crop landscape rounded".
  static const IconData crop_landscape_rounded = IconData(0xf14d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_landscape</i> &#x2014; material icon named "crop landscape sharp".
  static const IconData crop_landscape_sharp = IconData(0xec1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_original</i> &#x2014; material icon named "crop original".
  static const IconData crop_original = IconData(0xe696, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_original</i> &#x2014; material icon named "crop original outlined".
  static const IconData crop_original_outlined = IconData(0xe120, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_original</i> &#x2014; material icon named "crop original rounded".
  static const IconData crop_original_rounded = IconData(0xf14e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_original</i> &#x2014; material icon named "crop original sharp".
  static const IconData crop_original_sharp = IconData(0xec20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop</i> &#x2014; material icon named "crop outlined".
  static const IconData crop_outlined = IconData(0xe121, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_portrait</i> &#x2014; material icon named "crop portrait".
  static const IconData crop_portrait = IconData(0xe697, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_portrait</i> &#x2014; material icon named "crop portrait outlined".
  static const IconData crop_portrait_outlined = IconData(0xe122, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_portrait</i> &#x2014; material icon named "crop portrait rounded".
  static const IconData crop_portrait_rounded = IconData(0xf14f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_portrait</i> &#x2014; material icon named "crop portrait sharp".
  static const IconData crop_portrait_sharp = IconData(0xec21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_rotate</i> &#x2014; material icon named "crop rotate".
  static const IconData crop_rotate = IconData(0xe698, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_rotate</i> &#x2014; material icon named "crop rotate outlined".
  static const IconData crop_rotate_outlined = IconData(0xe123, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_rotate</i> &#x2014; material icon named "crop rotate rounded".
  static const IconData crop_rotate_rounded = IconData(0xf150, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_rotate</i> &#x2014; material icon named "crop rotate sharp".
  static const IconData crop_rotate_sharp = IconData(0xec22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop</i> &#x2014; material icon named "crop rounded".
  static const IconData crop_rounded = IconData(0xf151, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop</i> &#x2014; material icon named "crop sharp".
  static const IconData crop_sharp = IconData(0xec23, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_square</i> &#x2014; material icon named "crop square".
  static const IconData crop_square = IconData(0xe699, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_square</i> &#x2014; material icon named "crop square outlined".
  static const IconData crop_square_outlined = IconData(0xe124, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_square</i> &#x2014; material icon named "crop square rounded".
  static const IconData crop_square_rounded = IconData(0xf152, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_square</i> &#x2014; material icon named "crop square sharp".
  static const IconData crop_square_sharp = IconData(0xec24, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cut</i> &#x2014; material icon named "cut".
  static const IconData cut = IconData(0xe682, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cut</i> &#x2014; material icon named "cut outlined".
  static const IconData cut_outlined = IconData(0xe10d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cut</i> &#x2014; material icon named "cut rounded".
  static const IconData cut_rounded = IconData(0xf13b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cut</i> &#x2014; material icon named "cut sharp".
  static const IconData cut_sharp = IconData(0xec0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dangerous</i> &#x2014; material icon named "dangerous".
  static const IconData dangerous = IconData(0xe69a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dashboard</i> &#x2014; material icon named "dashboard".
  static const IconData dashboard = IconData(0xe69b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dashboard_customize</i> &#x2014; material icon named "dashboard customize".
  static const IconData dashboard_customize = IconData(0xe69c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dashboard</i> &#x2014; material icon named "dashboard outlined".
  static const IconData dashboard_outlined = IconData(0xe125, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dashboard</i> &#x2014; material icon named "dashboard rounded".
  static const IconData dashboard_rounded = IconData(0xf153, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dashboard</i> &#x2014; material icon named "dashboard sharp".
  static const IconData dashboard_sharp = IconData(0xec25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">data_usage</i> &#x2014; material icon named "data usage".
  static const IconData data_usage = IconData(0xe69d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">data_usage</i> &#x2014; material icon named "data usage outlined".
  static const IconData data_usage_outlined = IconData(0xe126, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">data_usage</i> &#x2014; material icon named "data usage rounded".
  static const IconData data_usage_rounded = IconData(0xf154, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">data_usage</i> &#x2014; material icon named "data usage sharp".
  static const IconData data_usage_sharp = IconData(0xec26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">date_range</i> &#x2014; material icon named "date range".
  static const IconData date_range = IconData(0xe69e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">date_range</i> &#x2014; material icon named "date range outlined".
  static const IconData date_range_outlined = IconData(0xe127, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">date_range</i> &#x2014; material icon named "date range rounded".
  static const IconData date_range_rounded = IconData(0xf155, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">date_range</i> &#x2014; material icon named "date range sharp".
  static const IconData date_range_sharp = IconData(0xec27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">deck</i> &#x2014; material icon named "deck".
  static const IconData deck = IconData(0xe69f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">deck</i> &#x2014; material icon named "deck outlined".
  static const IconData deck_outlined = IconData(0xe128, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">deck</i> &#x2014; material icon named "deck rounded".
  static const IconData deck_rounded = IconData(0xf156, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">deck</i> &#x2014; material icon named "deck sharp".
  static const IconData deck_sharp = IconData(0xec28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dehaze</i> &#x2014; material icon named "dehaze".
  static const IconData dehaze = IconData(0xe6a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dehaze</i> &#x2014; material icon named "dehaze outlined".
  static const IconData dehaze_outlined = IconData(0xe129, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dehaze</i> &#x2014; material icon named "dehaze rounded".
  static const IconData dehaze_rounded = IconData(0xf157, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dehaze</i> &#x2014; material icon named "dehaze sharp".
  static const IconData dehaze_sharp = IconData(0xec29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete</i> &#x2014; material icon named "delete".
  static const IconData delete = IconData(0xe6a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete_forever</i> &#x2014; material icon named "delete forever".
  static const IconData delete_forever = IconData(0xe6a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">delete_forever</i> &#x2014; material icon named "delete forever outlined".
  static const IconData delete_forever_outlined = IconData(0xe12a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">delete_forever</i> &#x2014; material icon named "delete forever rounded".
  static const IconData delete_forever_rounded = IconData(0xf158, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">delete_forever</i> &#x2014; material icon named "delete forever sharp".
  static const IconData delete_forever_sharp = IconData(0xec2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete_outline</i> &#x2014; material icon named "delete outline".
  static const IconData delete_outline = IconData(0xe6a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">delete_outline</i> &#x2014; material icon named "delete outline outlined".
  static const IconData delete_outline_outlined = IconData(0xe12b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">delete_outline</i> &#x2014; material icon named "delete outline rounded".
  static const IconData delete_outline_rounded = IconData(0xf159, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">delete_outline</i> &#x2014; material icon named "delete outline sharp".
  static const IconData delete_outline_sharp = IconData(0xec2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">delete</i> &#x2014; material icon named "delete outlined".
  static const IconData delete_outlined = IconData(0xe12c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">delete</i> &#x2014; material icon named "delete rounded".
  static const IconData delete_rounded = IconData(0xf15a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">delete</i> &#x2014; material icon named "delete sharp".
  static const IconData delete_sharp = IconData(0xec2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete_sweep</i> &#x2014; material icon named "delete sweep".
  static const IconData delete_sweep = IconData(0xe6a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">delete_sweep</i> &#x2014; material icon named "delete sweep outlined".
  static const IconData delete_sweep_outlined = IconData(0xe12d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">delete_sweep</i> &#x2014; material icon named "delete sweep rounded".
  static const IconData delete_sweep_rounded = IconData(0xf15b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">delete_sweep</i> &#x2014; material icon named "delete sweep sharp".
  static const IconData delete_sweep_sharp = IconData(0xec2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delivery_dining</i> &#x2014; material icon named "delivery dining".
  static const IconData delivery_dining = IconData(0xe6a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">departure_board</i> &#x2014; material icon named "departure board".
  static const IconData departure_board = IconData(0xe6a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">departure_board</i> &#x2014; material icon named "departure board outlined".
  static const IconData departure_board_outlined = IconData(0xe12e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">departure_board</i> &#x2014; material icon named "departure board rounded".
  static const IconData departure_board_rounded = IconData(0xf15c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">departure_board</i> &#x2014; material icon named "departure board sharp".
  static const IconData departure_board_sharp = IconData(0xec2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">description</i> &#x2014; material icon named "description".
  static const IconData description = IconData(0xe6a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">description</i> &#x2014; material icon named "description outlined".
  static const IconData description_outlined = IconData(0xe12f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">description</i> &#x2014; material icon named "description rounded".
  static const IconData description_rounded = IconData(0xf15d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">description</i> &#x2014; material icon named "description sharp".
  static const IconData description_sharp = IconData(0xec2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">design_services</i> &#x2014; material icon named "design services".
  static const IconData design_services = IconData(0xe6a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">design_services</i> &#x2014; material icon named "design services outlined".
  static const IconData design_services_outlined = IconData(0xe130, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">design_services</i> &#x2014; material icon named "design services rounded".
  static const IconData design_services_rounded = IconData(0xf15e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">design_services</i> &#x2014; material icon named "design services sharp".
  static const IconData design_services_sharp = IconData(0xec30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">desktop_access_disabled</i> &#x2014; material icon named "desktop access disabled".
  static const IconData desktop_access_disabled = IconData(0xe6a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">desktop_access_disabled</i> &#x2014; material icon named "desktop access disabled outlined".
  static const IconData desktop_access_disabled_outlined = IconData(0xe131, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">desktop_access_disabled</i> &#x2014; material icon named "desktop access disabled rounded".
  static const IconData desktop_access_disabled_rounded = IconData(0xf15f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">desktop_access_disabled</i> &#x2014; material icon named "desktop access disabled sharp".
  static const IconData desktop_access_disabled_sharp = IconData(0xec31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">desktop_mac</i> &#x2014; material icon named "desktop mac".
  static const IconData desktop_mac = IconData(0xe6aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">desktop_mac</i> &#x2014; material icon named "desktop mac outlined".
  static const IconData desktop_mac_outlined = IconData(0xe132, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">desktop_mac</i> &#x2014; material icon named "desktop mac rounded".
  static const IconData desktop_mac_rounded = IconData(0xf160, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">desktop_mac</i> &#x2014; material icon named "desktop mac sharp".
  static const IconData desktop_mac_sharp = IconData(0xec32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">desktop_windows</i> &#x2014; material icon named "desktop windows".
  static const IconData desktop_windows = IconData(0xe6ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">desktop_windows</i> &#x2014; material icon named "desktop windows outlined".
  static const IconData desktop_windows_outlined = IconData(0xe133, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">desktop_windows</i> &#x2014; material icon named "desktop windows rounded".
  static const IconData desktop_windows_rounded = IconData(0xf161, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">desktop_windows</i> &#x2014; material icon named "desktop windows sharp".
  static const IconData desktop_windows_sharp = IconData(0xec33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">details</i> &#x2014; material icon named "details".
  static const IconData details = IconData(0xe6ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">details</i> &#x2014; material icon named "details outlined".
  static const IconData details_outlined = IconData(0xe134, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">details</i> &#x2014; material icon named "details rounded".
  static const IconData details_rounded = IconData(0xf162, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">details</i> &#x2014; material icon named "details sharp".
  static const IconData details_sharp = IconData(0xec34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">developer_board</i> &#x2014; material icon named "developer board".
  static const IconData developer_board = IconData(0xe6ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">developer_board</i> &#x2014; material icon named "developer board outlined".
  static const IconData developer_board_outlined = IconData(0xe135, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">developer_board</i> &#x2014; material icon named "developer board rounded".
  static const IconData developer_board_rounded = IconData(0xf163, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">developer_board</i> &#x2014; material icon named "developer board sharp".
  static const IconData developer_board_sharp = IconData(0xec35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">developer_mode</i> &#x2014; material icon named "developer mode".
  static const IconData developer_mode = IconData(0xe6ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">developer_mode</i> &#x2014; material icon named "developer mode outlined".
  static const IconData developer_mode_outlined = IconData(0xe136, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">developer_mode</i> &#x2014; material icon named "developer mode rounded".
  static const IconData developer_mode_rounded = IconData(0xf164, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">developer_mode</i> &#x2014; material icon named "developer mode sharp".
  static const IconData developer_mode_sharp = IconData(0xec36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">device_hub</i> &#x2014; material icon named "device hub".
  static const IconData device_hub = IconData(0xe6af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">device_hub</i> &#x2014; material icon named "device hub outlined".
  static const IconData device_hub_outlined = IconData(0xe137, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">device_hub</i> &#x2014; material icon named "device hub rounded".
  static const IconData device_hub_rounded = IconData(0xf165, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">device_hub</i> &#x2014; material icon named "device hub sharp".
  static const IconData device_hub_sharp = IconData(0xec37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">device_thermostat</i> &#x2014; material icon named "device thermostat".
  static const IconData device_thermostat = IconData(0xe6b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">device_unknown</i> &#x2014; material icon named "device unknown".
  static const IconData device_unknown = IconData(0xe6b1, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">device_unknown</i> &#x2014; material icon named "device unknown outlined".
  static const IconData device_unknown_outlined = IconData(0xe138, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">device_unknown</i> &#x2014; material icon named "device unknown rounded".
  static const IconData device_unknown_rounded = IconData(0xf166, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">device_unknown</i> &#x2014; material icon named "device unknown sharp".
  static const IconData device_unknown_sharp = IconData(0xec38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">devices</i> &#x2014; material icon named "devices".
  static const IconData devices = IconData(0xe6b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">devices_other</i> &#x2014; material icon named "devices other".
  static const IconData devices_other = IconData(0xe6b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">devices_other</i> &#x2014; material icon named "devices other outlined".
  static const IconData devices_other_outlined = IconData(0xe139, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">devices_other</i> &#x2014; material icon named "devices other rounded".
  static const IconData devices_other_rounded = IconData(0xf167, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">devices_other</i> &#x2014; material icon named "devices other sharp".
  static const IconData devices_other_sharp = IconData(0xec39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">devices</i> &#x2014; material icon named "devices outlined".
  static const IconData devices_outlined = IconData(0xe13a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">devices</i> &#x2014; material icon named "devices rounded".
  static const IconData devices_rounded = IconData(0xf168, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">devices</i> &#x2014; material icon named "devices sharp".
  static const IconData devices_sharp = IconData(0xec3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dialer_sip</i> &#x2014; material icon named "dialer sip".
  static const IconData dialer_sip = IconData(0xe6b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dialer_sip</i> &#x2014; material icon named "dialer sip outlined".
  static const IconData dialer_sip_outlined = IconData(0xe13b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dialer_sip</i> &#x2014; material icon named "dialer sip rounded".
  static const IconData dialer_sip_rounded = IconData(0xf169, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dialer_sip</i> &#x2014; material icon named "dialer sip sharp".
  static const IconData dialer_sip_sharp = IconData(0xec3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dialpad</i> &#x2014; material icon named "dialpad".
  static const IconData dialpad = IconData(0xe6b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dialpad</i> &#x2014; material icon named "dialpad outlined".
  static const IconData dialpad_outlined = IconData(0xe13c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dialpad</i> &#x2014; material icon named "dialpad rounded".
  static const IconData dialpad_rounded = IconData(0xf16a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dialpad</i> &#x2014; material icon named "dialpad sharp".
  static const IconData dialpad_sharp = IconData(0xec3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dinner_dining</i> &#x2014; material icon named "dinner dining".
  static const IconData dinner_dining = IconData(0xe6b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions</i> &#x2014; material icon named "directions".
  static const IconData directions = IconData(0xe6b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_bike</i> &#x2014; material icon named "directions bike".
  static const IconData directions_bike = IconData(0xe6b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_bike</i> &#x2014; material icon named "directions bike outlined".
  static const IconData directions_bike_outlined = IconData(0xe13d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_bike</i> &#x2014; material icon named "directions bike rounded".
  static const IconData directions_bike_rounded = IconData(0xf16b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_bike</i> &#x2014; material icon named "directions bike sharp".
  static const IconData directions_bike_sharp = IconData(0xec3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_boat</i> &#x2014; material icon named "directions boat".
  static const IconData directions_boat = IconData(0xe6b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_boat</i> &#x2014; material icon named "directions boat outlined".
  static const IconData directions_boat_outlined = IconData(0xe13e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_boat</i> &#x2014; material icon named "directions boat rounded".
  static const IconData directions_boat_rounded = IconData(0xf16c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_boat</i> &#x2014; material icon named "directions boat sharp".
  static const IconData directions_boat_sharp = IconData(0xec3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_bus</i> &#x2014; material icon named "directions bus".
  static const IconData directions_bus = IconData(0xe6ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_bus</i> &#x2014; material icon named "directions bus outlined".
  static const IconData directions_bus_outlined = IconData(0xe13f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_bus</i> &#x2014; material icon named "directions bus rounded".
  static const IconData directions_bus_rounded = IconData(0xf16d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_bus</i> &#x2014; material icon named "directions bus sharp".
  static const IconData directions_bus_sharp = IconData(0xec3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_car</i> &#x2014; material icon named "directions car".
  static const IconData directions_car = IconData(0xe6bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_car</i> &#x2014; material icon named "directions car outlined".
  static const IconData directions_car_outlined = IconData(0xe140, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_car</i> &#x2014; material icon named "directions car rounded".
  static const IconData directions_car_rounded = IconData(0xf16e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_car</i> &#x2014; material icon named "directions car sharp".
  static const IconData directions_car_sharp = IconData(0xec40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_ferry</i> &#x2014; material icon named "directions ferry".
  static const IconData directions_ferry = IconData(0xe6b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_ferry</i> &#x2014; material icon named "directions ferry outlined".
  static const IconData directions_ferry_outlined = IconData(0xe13e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_ferry</i> &#x2014; material icon named "directions ferry rounded".
  static const IconData directions_ferry_rounded = IconData(0xf16c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_ferry</i> &#x2014; material icon named "directions ferry sharp".
  static const IconData directions_ferry_sharp = IconData(0xec3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_off</i> &#x2014; material icon named "directions off".
  static const IconData directions_off = IconData(0xe6bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_off</i> &#x2014; material icon named "directions off outlined".
  static const IconData directions_off_outlined = IconData(0xe141, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_off</i> &#x2014; material icon named "directions off rounded".
  static const IconData directions_off_rounded = IconData(0xf16f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_off</i> &#x2014; material icon named "directions off sharp".
  static const IconData directions_off_sharp = IconData(0xec41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions</i> &#x2014; material icon named "directions outlined".
  static const IconData directions_outlined = IconData(0xe142, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_railway</i> &#x2014; material icon named "directions railway".
  static const IconData directions_railway = IconData(0xe6bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_railway</i> &#x2014; material icon named "directions railway outlined".
  static const IconData directions_railway_outlined = IconData(0xe143, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_railway</i> &#x2014; material icon named "directions railway rounded".
  static const IconData directions_railway_rounded = IconData(0xf170, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_railway</i> &#x2014; material icon named "directions railway sharp".
  static const IconData directions_railway_sharp = IconData(0xec42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions</i> &#x2014; material icon named "directions rounded".
  static const IconData directions_rounded = IconData(0xf171, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_run</i> &#x2014; material icon named "directions run".
  static const IconData directions_run = IconData(0xe6be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_run</i> &#x2014; material icon named "directions run outlined".
  static const IconData directions_run_outlined = IconData(0xe144, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_run</i> &#x2014; material icon named "directions run rounded".
  static const IconData directions_run_rounded = IconData(0xf172, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_run</i> &#x2014; material icon named "directions run sharp".
  static const IconData directions_run_sharp = IconData(0xec43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions</i> &#x2014; material icon named "directions sharp".
  static const IconData directions_sharp = IconData(0xec44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_subway</i> &#x2014; material icon named "directions subway".
  static const IconData directions_subway = IconData(0xe6bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_subway</i> &#x2014; material icon named "directions subway outlined".
  static const IconData directions_subway_outlined = IconData(0xe145, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_subway</i> &#x2014; material icon named "directions subway rounded".
  static const IconData directions_subway_rounded = IconData(0xf173, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_subway</i> &#x2014; material icon named "directions subway sharp".
  static const IconData directions_subway_sharp = IconData(0xec45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_train</i> &#x2014; material icon named "directions train".
  static const IconData directions_train = IconData(0xe6bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_train</i> &#x2014; material icon named "directions train outlined".
  static const IconData directions_train_outlined = IconData(0xe143, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_train</i> &#x2014; material icon named "directions train rounded".
  static const IconData directions_train_rounded = IconData(0xf170, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_train</i> &#x2014; material icon named "directions train sharp".
  static const IconData directions_train_sharp = IconData(0xec42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_transit</i> &#x2014; material icon named "directions transit".
  static const IconData directions_transit = IconData(0xe6c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_transit</i> &#x2014; material icon named "directions transit outlined".
  static const IconData directions_transit_outlined = IconData(0xe146, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_transit</i> &#x2014; material icon named "directions transit rounded".
  static const IconData directions_transit_rounded = IconData(0xf174, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_transit</i> &#x2014; material icon named "directions transit sharp".
  static const IconData directions_transit_sharp = IconData(0xec46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_walk</i> &#x2014; material icon named "directions walk".
  static const IconData directions_walk = IconData(0xe6c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_walk</i> &#x2014; material icon named "directions walk outlined".
  static const IconData directions_walk_outlined = IconData(0xe147, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_walk</i> &#x2014; material icon named "directions walk rounded".
  static const IconData directions_walk_rounded = IconData(0xf175, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_walk</i> &#x2014; material icon named "directions walk sharp".
  static const IconData directions_walk_sharp = IconData(0xec47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dirty_lens</i> &#x2014; material icon named "dirty lens".
  static const IconData dirty_lens = IconData(0xe6c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">disc_full</i> &#x2014; material icon named "disc full".
  static const IconData disc_full = IconData(0xe6c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">disc_full</i> &#x2014; material icon named "disc full outlined".
  static const IconData disc_full_outlined = IconData(0xe148, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">disc_full</i> &#x2014; material icon named "disc full rounded".
  static const IconData disc_full_rounded = IconData(0xf176, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">disc_full</i> &#x2014; material icon named "disc full sharp".
  static const IconData disc_full_sharp = IconData(0xec48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dnd_forwardslash</i> &#x2014; material icon named "dnd forwardslash".
  static const IconData dnd_forwardslash = IconData(0xe6c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dns</i> &#x2014; material icon named "dns".
  static const IconData dns = IconData(0xe6c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dns</i> &#x2014; material icon named "dns outlined".
  static const IconData dns_outlined = IconData(0xe149, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dns</i> &#x2014; material icon named "dns rounded".
  static const IconData dns_rounded = IconData(0xf177, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dns</i> &#x2014; material icon named "dns sharp".
  static const IconData dns_sharp = IconData(0xec49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_disturb_alt</i> &#x2014; material icon named "do disturb alt outlined".
  static const IconData do_disturb_alt_outlined = IconData(0xe14a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_disturb_alt</i> &#x2014; material icon named "do disturb alt rounded".
  static const IconData do_disturb_alt_rounded = IconData(0xf178, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_disturb_alt</i> &#x2014; material icon named "do disturb alt sharp".
  static const IconData do_disturb_alt_sharp = IconData(0xec4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_disturb_off</i> &#x2014; material icon named "do disturb off outlined".
  static const IconData do_disturb_off_outlined = IconData(0xe14b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_disturb_off</i> &#x2014; material icon named "do disturb off rounded".
  static const IconData do_disturb_off_rounded = IconData(0xf179, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_disturb_off</i> &#x2014; material icon named "do disturb off sharp".
  static const IconData do_disturb_off_sharp = IconData(0xec4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_disturb_on</i> &#x2014; material icon named "do disturb on outlined".
  static const IconData do_disturb_on_outlined = IconData(0xe14c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_disturb_on</i> &#x2014; material icon named "do disturb on rounded".
  static const IconData do_disturb_on_rounded = IconData(0xf17a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_disturb_on</i> &#x2014; material icon named "do disturb on sharp".
  static const IconData do_disturb_on_sharp = IconData(0xec4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_disturb</i> &#x2014; material icon named "do disturb outlined".
  static const IconData do_disturb_outlined = IconData(0xe14d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_disturb</i> &#x2014; material icon named "do disturb rounded".
  static const IconData do_disturb_rounded = IconData(0xf17b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_disturb</i> &#x2014; material icon named "do disturb sharp".
  static const IconData do_disturb_sharp = IconData(0xec4d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb</i> &#x2014; material icon named "do not disturb".
  static const IconData do_not_disturb = IconData(0xe6c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_alt</i> &#x2014; material icon named "do not disturb alt".
  static const IconData do_not_disturb_alt = IconData(0xe6c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_off</i> &#x2014; material icon named "do not disturb off".
  static const IconData do_not_disturb_off = IconData(0xe6c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_on</i> &#x2014; material icon named "do not disturb on".
  static const IconData do_not_disturb_on = IconData(0xe6c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_step</i> &#x2014; material icon named "do not step".
  static const IconData do_not_step = IconData(0xe6c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_not_step</i> &#x2014; material icon named "do not step outlined".
  static const IconData do_not_step_outlined = IconData(0xe14e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_not_step</i> &#x2014; material icon named "do not step rounded".
  static const IconData do_not_step_rounded = IconData(0xf17c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_not_step</i> &#x2014; material icon named "do not step sharp".
  static const IconData do_not_step_sharp = IconData(0xec4e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_touch</i> &#x2014; material icon named "do not touch".
  static const IconData do_not_touch = IconData(0xe6ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_not_touch</i> &#x2014; material icon named "do not touch outlined".
  static const IconData do_not_touch_outlined = IconData(0xe14f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_not_touch</i> &#x2014; material icon named "do not touch rounded".
  static const IconData do_not_touch_rounded = IconData(0xf17d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_not_touch</i> &#x2014; material icon named "do not touch sharp".
  static const IconData do_not_touch_sharp = IconData(0xec4f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dock</i> &#x2014; material icon named "dock".
  static const IconData dock = IconData(0xe6cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dock</i> &#x2014; material icon named "dock outlined".
  static const IconData dock_outlined = IconData(0xe150, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dock</i> &#x2014; material icon named "dock rounded".
  static const IconData dock_rounded = IconData(0xf17e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dock</i> &#x2014; material icon named "dock sharp".
  static const IconData dock_sharp = IconData(0xec50, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">domain</i> &#x2014; material icon named "domain".
  static const IconData domain = IconData(0xe6cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">domain_disabled</i> &#x2014; material icon named "domain disabled".
  static const IconData domain_disabled = IconData(0xe6cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">domain_disabled</i> &#x2014; material icon named "domain disabled outlined".
  static const IconData domain_disabled_outlined = IconData(0xe151, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">domain_disabled</i> &#x2014; material icon named "domain disabled rounded".
  static const IconData domain_disabled_rounded = IconData(0xf17f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">domain_disabled</i> &#x2014; material icon named "domain disabled sharp".
  static const IconData domain_disabled_sharp = IconData(0xec51, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">domain</i> &#x2014; material icon named "domain outlined".
  static const IconData domain_outlined = IconData(0xe152, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">domain</i> &#x2014; material icon named "domain rounded".
  static const IconData domain_rounded = IconData(0xf180, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">domain</i> &#x2014; material icon named "domain sharp".
  static const IconData domain_sharp = IconData(0xec52, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">domain_verification</i> &#x2014; material icon named "domain verification".
  static const IconData domain_verification = IconData(0xe6ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">domain_verification</i> &#x2014; material icon named "domain verification outlined".
  static const IconData domain_verification_outlined = IconData(0xe153, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">domain_verification</i> &#x2014; material icon named "domain verification rounded".
  static const IconData domain_verification_rounded = IconData(0xf181, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">domain_verification</i> &#x2014; material icon named "domain verification sharp".
  static const IconData domain_verification_sharp = IconData(0xec53, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">done</i> &#x2014; material icon named "done".
  static const IconData done = IconData(0xe6cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">done_all</i> &#x2014; material icon named "done all".
  static const IconData done_all = IconData(0xe6d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">done_all</i> &#x2014; material icon named "done all outlined".
  static const IconData done_all_outlined = IconData(0xe154, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">done_all</i> &#x2014; material icon named "done all rounded".
  static const IconData done_all_rounded = IconData(0xf182, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">done_all</i> &#x2014; material icon named "done all sharp".
  static const IconData done_all_sharp = IconData(0xec54, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">done_outline</i> &#x2014; material icon named "done outline".
  static const IconData done_outline = IconData(0xe6d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">done_outline</i> &#x2014; material icon named "done outline outlined".
  static const IconData done_outline_outlined = IconData(0xe155, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">done_outline</i> &#x2014; material icon named "done outline rounded".
  static const IconData done_outline_rounded = IconData(0xf183, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">done_outline</i> &#x2014; material icon named "done outline sharp".
  static const IconData done_outline_sharp = IconData(0xec55, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">done</i> &#x2014; material icon named "done outlined".
  static const IconData done_outlined = IconData(0xe156, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">done</i> &#x2014; material icon named "done rounded".
  static const IconData done_rounded = IconData(0xf184, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">done</i> &#x2014; material icon named "done sharp".
  static const IconData done_sharp = IconData(0xec56, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">donut_large</i> &#x2014; material icon named "donut large".
  static const IconData donut_large = IconData(0xe6d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">donut_large</i> &#x2014; material icon named "donut large outlined".
  static const IconData donut_large_outlined = IconData(0xe157, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">donut_large</i> &#x2014; material icon named "donut large rounded".
  static const IconData donut_large_rounded = IconData(0xf185, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">donut_large</i> &#x2014; material icon named "donut large sharp".
  static const IconData donut_large_sharp = IconData(0xec57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">donut_small</i> &#x2014; material icon named "donut small".
  static const IconData donut_small = IconData(0xe6d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">donut_small</i> &#x2014; material icon named "donut small outlined".
  static const IconData donut_small_outlined = IconData(0xe158, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">donut_small</i> &#x2014; material icon named "donut small rounded".
  static const IconData donut_small_rounded = IconData(0xf186, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">donut_small</i> &#x2014; material icon named "donut small sharp".
  static const IconData donut_small_sharp = IconData(0xec58, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">double_arrow</i> &#x2014; material icon named "double arrow".
  static const IconData double_arrow = IconData(0xe6d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">double_arrow</i> &#x2014; material icon named "double arrow outlined".
  static const IconData double_arrow_outlined = IconData(0xe159, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">double_arrow</i> &#x2014; material icon named "double arrow rounded".
  static const IconData double_arrow_rounded = IconData(0xf187, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">double_arrow</i> &#x2014; material icon named "double arrow sharp".
  static const IconData double_arrow_sharp = IconData(0xec59, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">download_done</i> &#x2014; material icon named "download done outlined".
  static const IconData download_done_outlined = IconData(0xe15a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">download_done</i> &#x2014; material icon named "download done rounded".
  static const IconData download_done_rounded = IconData(0xf188, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">download_done</i> &#x2014; material icon named "download done sharp".
  static const IconData download_done_sharp = IconData(0xec5a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">download</i> &#x2014; material icon named "download outlined".
  static const IconData download_outlined = IconData(0xe15b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">download</i> &#x2014; material icon named "download rounded".
  static const IconData download_rounded = IconData(0xf189, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">download</i> &#x2014; material icon named "download sharp".
  static const IconData download_sharp = IconData(0xec5b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drafts</i> &#x2014; material icon named "drafts".
  static const IconData drafts = IconData(0xe6d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drafts</i> &#x2014; material icon named "drafts outlined".
  static const IconData drafts_outlined = IconData(0xe15c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drafts</i> &#x2014; material icon named "drafts rounded".
  static const IconData drafts_rounded = IconData(0xf18a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drafts</i> &#x2014; material icon named "drafts sharp".
  static const IconData drafts_sharp = IconData(0xec5c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drag_handle</i> &#x2014; material icon named "drag handle".
  static const IconData drag_handle = IconData(0xe6d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drag_handle</i> &#x2014; material icon named "drag handle outlined".
  static const IconData drag_handle_outlined = IconData(0xe15d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drag_handle</i> &#x2014; material icon named "drag handle rounded".
  static const IconData drag_handle_rounded = IconData(0xf18b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drag_handle</i> &#x2014; material icon named "drag handle sharp".
  static const IconData drag_handle_sharp = IconData(0xec5d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drag_indicator</i> &#x2014; material icon named "drag indicator".
  static const IconData drag_indicator = IconData(0xe6d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drag_indicator</i> &#x2014; material icon named "drag indicator outlined".
  static const IconData drag_indicator_outlined = IconData(0xe15e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drag_indicator</i> &#x2014; material icon named "drag indicator rounded".
  static const IconData drag_indicator_rounded = IconData(0xf18c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drag_indicator</i> &#x2014; material icon named "drag indicator sharp".
  static const IconData drag_indicator_sharp = IconData(0xec5e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_eta</i> &#x2014; material icon named "drive eta".
  static const IconData drive_eta = IconData(0xe6d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drive_eta</i> &#x2014; material icon named "drive eta outlined".
  static const IconData drive_eta_outlined = IconData(0xe15f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drive_eta</i> &#x2014; material icon named "drive eta rounded".
  static const IconData drive_eta_rounded = IconData(0xf18d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drive_eta</i> &#x2014; material icon named "drive eta sharp".
  static const IconData drive_eta_sharp = IconData(0xec5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_file_move</i> &#x2014; material icon named "drive file move".
  static const IconData drive_file_move = IconData(0xe6d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_file_move_outline</i> &#x2014; material icon named "drive file move outline".
  static const IconData drive_file_move_outline = IconData(0xe6da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_file_rename_outline</i> &#x2014; material icon named "drive file rename outline".
  static const IconData drive_file_rename_outline = IconData(0xe6db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_folder_upload</i> &#x2014; material icon named "drive folder upload".
  static const IconData drive_folder_upload = IconData(0xe6dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dry</i> &#x2014; material icon named "dry".
  static const IconData dry = IconData(0xe6dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dry_cleaning</i> &#x2014; material icon named "dry cleaning".
  static const IconData dry_cleaning = IconData(0xe6de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dry</i> &#x2014; material icon named "dry outlined".
  static const IconData dry_outlined = IconData(0xe160, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dry</i> &#x2014; material icon named "dry rounded".
  static const IconData dry_rounded = IconData(0xf18e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dry</i> &#x2014; material icon named "dry sharp".
  static const IconData dry_sharp = IconData(0xec60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">duo</i> &#x2014; material icon named "duo".
  static const IconData duo = IconData(0xe6df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">duo</i> &#x2014; material icon named "duo outlined".
  static const IconData duo_outlined = IconData(0xe161, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">duo</i> &#x2014; material icon named "duo rounded".
  static const IconData duo_rounded = IconData(0xf18f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">duo</i> &#x2014; material icon named "duo sharp".
  static const IconData duo_sharp = IconData(0xec61, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dvr</i> &#x2014; material icon named "dvr".
  static const IconData dvr = IconData(0xe6e0, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">dvr</i> &#x2014; material icon named "dvr outlined".
  static const IconData dvr_outlined = IconData(0xe162, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dvr</i> &#x2014; material icon named "dvr rounded".
  static const IconData dvr_rounded = IconData(0xf190, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dvr</i> &#x2014; material icon named "dvr sharp".
  static const IconData dvr_sharp = IconData(0xec62, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dynamic_feed</i> &#x2014; material icon named "dynamic feed".
  static const IconData dynamic_feed = IconData(0xe6e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dynamic_feed</i> &#x2014; material icon named "dynamic feed outlined".
  static const IconData dynamic_feed_outlined = IconData(0xe163, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dynamic_feed</i> &#x2014; material icon named "dynamic feed rounded".
  static const IconData dynamic_feed_rounded = IconData(0xf191, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dynamic_feed</i> &#x2014; material icon named "dynamic feed sharp".
  static const IconData dynamic_feed_sharp = IconData(0xec63, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dynamic_form</i> &#x2014; material icon named "dynamic form".
  static const IconData dynamic_form = IconData(0xe6e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dynamic_form</i> &#x2014; material icon named "dynamic form outlined".
  static const IconData dynamic_form_outlined = IconData(0xe164, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dynamic_form</i> &#x2014; material icon named "dynamic form rounded".
  static const IconData dynamic_form_rounded = IconData(0xf192, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dynamic_form</i> &#x2014; material icon named "dynamic form sharp".
  static const IconData dynamic_form_sharp = IconData(0xec64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">east</i> &#x2014; material icon named "east".
  static const IconData east = IconData(0xe6e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">east</i> &#x2014; material icon named "east outlined".
  static const IconData east_outlined = IconData(0xe165, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">east</i> &#x2014; material icon named "east rounded".
  static const IconData east_rounded = IconData(0xf193, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">east</i> &#x2014; material icon named "east sharp".
  static const IconData east_sharp = IconData(0xec65, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">eco</i> &#x2014; material icon named "eco".
  static const IconData eco = IconData(0xe6e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">eco</i> &#x2014; material icon named "eco outlined".
  static const IconData eco_outlined = IconData(0xe166, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">eco</i> &#x2014; material icon named "eco rounded".
  static const IconData eco_rounded = IconData(0xf194, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">eco</i> &#x2014; material icon named "eco sharp".
  static const IconData eco_sharp = IconData(0xec66, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit</i> &#x2014; material icon named "edit".
  static const IconData edit = IconData(0xe6e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_attributes</i> &#x2014; material icon named "edit attributes".
  static const IconData edit_attributes = IconData(0xe6e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit_attributes</i> &#x2014; material icon named "edit attributes outlined".
  static const IconData edit_attributes_outlined = IconData(0xe167, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit_attributes</i> &#x2014; material icon named "edit attributes rounded".
  static const IconData edit_attributes_rounded = IconData(0xf195, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit_attributes</i> &#x2014; material icon named "edit attributes sharp".
  static const IconData edit_attributes_sharp = IconData(0xec67, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_location</i> &#x2014; material icon named "edit location".
  static const IconData edit_location = IconData(0xe6e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit_location</i> &#x2014; material icon named "edit location outlined".
  static const IconData edit_location_outlined = IconData(0xe168, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit_location</i> &#x2014; material icon named "edit location rounded".
  static const IconData edit_location_rounded = IconData(0xf196, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit_location</i> &#x2014; material icon named "edit location sharp".
  static const IconData edit_location_sharp = IconData(0xec68, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_off</i> &#x2014; material icon named "edit off".
  static const IconData edit_off = IconData(0xe6e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit</i> &#x2014; material icon named "edit outlined".
  static const IconData edit_outlined = IconData(0xe169, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_road</i> &#x2014; material icon named "edit road".
  static const IconData edit_road = IconData(0xe6e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit_road</i> &#x2014; material icon named "edit road outlined".
  static const IconData edit_road_outlined = IconData(0xe16a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit_road</i> &#x2014; material icon named "edit road rounded".
  static const IconData edit_road_rounded = IconData(0xf197, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit_road</i> &#x2014; material icon named "edit road sharp".
  static const IconData edit_road_sharp = IconData(0xec69, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit</i> &#x2014; material icon named "edit rounded".
  static const IconData edit_rounded = IconData(0xf198, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit</i> &#x2014; material icon named "edit sharp".
  static const IconData edit_sharp = IconData(0xec6a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">eject</i> &#x2014; material icon named "eject".
  static const IconData eject = IconData(0xe6ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">eject</i> &#x2014; material icon named "eject outlined".
  static const IconData eject_outlined = IconData(0xe16b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">eject</i> &#x2014; material icon named "eject rounded".
  static const IconData eject_rounded = IconData(0xf199, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">eject</i> &#x2014; material icon named "eject sharp".
  static const IconData eject_sharp = IconData(0xec6b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">elderly</i> &#x2014; material icon named "elderly".
  static const IconData elderly = IconData(0xe6eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">elderly</i> &#x2014; material icon named "elderly outlined".
  static const IconData elderly_outlined = IconData(0xe16c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">elderly</i> &#x2014; material icon named "elderly rounded".
  static const IconData elderly_rounded = IconData(0xf19a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">elderly</i> &#x2014; material icon named "elderly sharp".
  static const IconData elderly_sharp = IconData(0xec6c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_bike</i> &#x2014; material icon named "electric bike".
  static const IconData electric_bike = IconData(0xe6ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electric_bike</i> &#x2014; material icon named "electric bike outlined".
  static const IconData electric_bike_outlined = IconData(0xe16d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_bike</i> &#x2014; material icon named "electric bike rounded".
  static const IconData electric_bike_rounded = IconData(0xf19b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_bike</i> &#x2014; material icon named "electric bike sharp".
  static const IconData electric_bike_sharp = IconData(0xec6d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_car</i> &#x2014; material icon named "electric car".
  static const IconData electric_car = IconData(0xe6ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electric_car</i> &#x2014; material icon named "electric car outlined".
  static const IconData electric_car_outlined = IconData(0xe16e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_car</i> &#x2014; material icon named "electric car rounded".
  static const IconData electric_car_rounded = IconData(0xf19c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_car</i> &#x2014; material icon named "electric car sharp".
  static const IconData electric_car_sharp = IconData(0xec6e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_moped</i> &#x2014; material icon named "electric moped".
  static const IconData electric_moped = IconData(0xe6ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electric_moped</i> &#x2014; material icon named "electric moped outlined".
  static const IconData electric_moped_outlined = IconData(0xe16f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_moped</i> &#x2014; material icon named "electric moped rounded".
  static const IconData electric_moped_rounded = IconData(0xf19d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_moped</i> &#x2014; material icon named "electric moped sharp".
  static const IconData electric_moped_sharp = IconData(0xec6f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_rickshaw</i> &#x2014; material icon named "electric rickshaw".
  static const IconData electric_rickshaw = IconData(0xe6ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_rickshaw</i> &#x2014; material icon named "electric rickshaw rounded".
  static const IconData electric_rickshaw_rounded = IconData(0xf19e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_rickshaw</i> &#x2014; material icon named "electric rickshaw sharp".
  static const IconData electric_rickshaw_sharp = IconData(0xec70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_scooter</i> &#x2014; material icon named "electric scooter".
  static const IconData electric_scooter = IconData(0xe6f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electric_scooter</i> &#x2014; material icon named "electric scooter outlined".
  static const IconData electric_scooter_outlined = IconData(0xe170, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_scooter</i> &#x2014; material icon named "electric scooter rounded".
  static const IconData electric_scooter_rounded = IconData(0xf19f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_scooter</i> &#x2014; material icon named "electric scooter sharp".
  static const IconData electric_scooter_sharp = IconData(0xec71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electrical_services</i> &#x2014; material icon named "electrical services".
  static const IconData electrical_services = IconData(0xe6f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electrical_services</i> &#x2014; material icon named "electrical services outlined".
  static const IconData electrical_services_outlined = IconData(0xe171, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electrical_services</i> &#x2014; material icon named "electrical services rounded".
  static const IconData electrical_services_rounded = IconData(0xf1a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electrical_services</i> &#x2014; material icon named "electrical services sharp".
  static const IconData electrical_services_sharp = IconData(0xec72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">elevator</i> &#x2014; material icon named "elevator".
  static const IconData elevator = IconData(0xe6f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">elevator</i> &#x2014; material icon named "elevator outlined".
  static const IconData elevator_outlined = IconData(0xe172, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">elevator</i> &#x2014; material icon named "elevator rounded".
  static const IconData elevator_rounded = IconData(0xf1a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">elevator</i> &#x2014; material icon named "elevator sharp".
  static const IconData elevator_sharp = IconData(0xec73, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">email</i> &#x2014; material icon named "email".
  static const IconData email = IconData(0xe6f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">email</i> &#x2014; material icon named "email outlined".
  static const IconData email_outlined = IconData(0xe173, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">email</i> &#x2014; material icon named "email rounded".
  static const IconData email_rounded = IconData(0xf1a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">email</i> &#x2014; material icon named "email sharp".
  static const IconData email_sharp = IconData(0xec74, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_emotions</i> &#x2014; material icon named "emoji emotions".
  static const IconData emoji_emotions = IconData(0xe6f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_emotions</i> &#x2014; material icon named "emoji emotions outlined".
  static const IconData emoji_emotions_outlined = IconData(0xe174, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_emotions</i> &#x2014; material icon named "emoji emotions rounded".
  static const IconData emoji_emotions_rounded = IconData(0xf1a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_emotions</i> &#x2014; material icon named "emoji emotions sharp".
  static const IconData emoji_emotions_sharp = IconData(0xec75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_events</i> &#x2014; material icon named "emoji events".
  static const IconData emoji_events = IconData(0xe6f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_events</i> &#x2014; material icon named "emoji events outlined".
  static const IconData emoji_events_outlined = IconData(0xe175, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_events</i> &#x2014; material icon named "emoji events rounded".
  static const IconData emoji_events_rounded = IconData(0xf1a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_events</i> &#x2014; material icon named "emoji events sharp".
  static const IconData emoji_events_sharp = IconData(0xec76, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_flags</i> &#x2014; material icon named "emoji flags".
  static const IconData emoji_flags = IconData(0xe6f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_flags</i> &#x2014; material icon named "emoji flags outlined".
  static const IconData emoji_flags_outlined = IconData(0xe176, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_flags</i> &#x2014; material icon named "emoji flags rounded".
  static const IconData emoji_flags_rounded = IconData(0xf1a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_flags</i> &#x2014; material icon named "emoji flags sharp".
  static const IconData emoji_flags_sharp = IconData(0xec77, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_food_beverage</i> &#x2014; material icon named "emoji food beverage".
  static const IconData emoji_food_beverage = IconData(0xe6f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_food_beverage</i> &#x2014; material icon named "emoji food beverage outlined".
  static const IconData emoji_food_beverage_outlined = IconData(0xe177, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_food_beverage</i> &#x2014; material icon named "emoji food beverage rounded".
  static const IconData emoji_food_beverage_rounded = IconData(0xf1a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_food_beverage</i> &#x2014; material icon named "emoji food beverage sharp".
  static const IconData emoji_food_beverage_sharp = IconData(0xec78, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_nature</i> &#x2014; material icon named "emoji nature".
  static const IconData emoji_nature = IconData(0xe6f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_nature</i> &#x2014; material icon named "emoji nature outlined".
  static const IconData emoji_nature_outlined = IconData(0xe178, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_nature</i> &#x2014; material icon named "emoji nature rounded".
  static const IconData emoji_nature_rounded = IconData(0xf1a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_nature</i> &#x2014; material icon named "emoji nature sharp".
  static const IconData emoji_nature_sharp = IconData(0xec79, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_objects</i> &#x2014; material icon named "emoji objects".
  static const IconData emoji_objects = IconData(0xe6f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_objects</i> &#x2014; material icon named "emoji objects outlined".
  static const IconData emoji_objects_outlined = IconData(0xe179, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_objects</i> &#x2014; material icon named "emoji objects rounded".
  static const IconData emoji_objects_rounded = IconData(0xf1a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_objects</i> &#x2014; material icon named "emoji objects sharp".
  static const IconData emoji_objects_sharp = IconData(0xec7a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_people</i> &#x2014; material icon named "emoji people".
  static const IconData emoji_people = IconData(0xe6fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_people</i> &#x2014; material icon named "emoji people outlined".
  static const IconData emoji_people_outlined = IconData(0xe17a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_people</i> &#x2014; material icon named "emoji people rounded".
  static const IconData emoji_people_rounded = IconData(0xf1a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_people</i> &#x2014; material icon named "emoji people sharp".
  static const IconData emoji_people_sharp = IconData(0xec7b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_symbols</i> &#x2014; material icon named "emoji symbols".
  static const IconData emoji_symbols = IconData(0xe6fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_symbols</i> &#x2014; material icon named "emoji symbols outlined".
  static const IconData emoji_symbols_outlined = IconData(0xe17b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_symbols</i> &#x2014; material icon named "emoji symbols rounded".
  static const IconData emoji_symbols_rounded = IconData(0xf1aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_symbols</i> &#x2014; material icon named "emoji symbols sharp".
  static const IconData emoji_symbols_sharp = IconData(0xec7c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_transportation</i> &#x2014; material icon named "emoji transportation".
  static const IconData emoji_transportation = IconData(0xe6fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_transportation</i> &#x2014; material icon named "emoji transportation outlined".
  static const IconData emoji_transportation_outlined = IconData(0xe17c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_transportation</i> &#x2014; material icon named "emoji transportation rounded".
  static const IconData emoji_transportation_rounded = IconData(0xf1ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_transportation</i> &#x2014; material icon named "emoji transportation sharp".
  static const IconData emoji_transportation_sharp = IconData(0xec7d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">engineering</i> &#x2014; material icon named "engineering".
  static const IconData engineering = IconData(0xe6fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">engineering</i> &#x2014; material icon named "engineering outlined".
  static const IconData engineering_outlined = IconData(0xe17d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">engineering</i> &#x2014; material icon named "engineering rounded".
  static const IconData engineering_rounded = IconData(0xf1ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">engineering</i> &#x2014; material icon named "engineering sharp".
  static const IconData engineering_sharp = IconData(0xec7e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">enhance_photo_translate</i> &#x2014; material icon named "enhance photo translate".
  static const IconData enhance_photo_translate = IconData(0xe630, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">enhance_photo_translate</i> &#x2014; material icon named "enhance photo translate outlined".
  static const IconData enhance_photo_translate_outlined = IconData(0xe0c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">enhance_photo_translate</i> &#x2014; material icon named "enhance photo translate rounded".
  static const IconData enhance_photo_translate_rounded = IconData(0xf0f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">enhance_photo_translate</i> &#x2014; material icon named "enhance photo translate sharp".
  static const IconData enhance_photo_translate_sharp = IconData(0xebc3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">enhanced_encryption</i> &#x2014; material icon named "enhanced encryption".
  static const IconData enhanced_encryption = IconData(0xe6fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">enhanced_encryption</i> &#x2014; material icon named "enhanced encryption outlined".
  static const IconData enhanced_encryption_outlined = IconData(0xe17e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">enhanced_encryption</i> &#x2014; material icon named "enhanced encryption rounded".
  static const IconData enhanced_encryption_rounded = IconData(0xf1ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">enhanced_encryption</i> &#x2014; material icon named "enhanced encryption sharp".
  static const IconData enhanced_encryption_sharp = IconData(0xec7f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">equalizer</i> &#x2014; material icon named "equalizer".
  static const IconData equalizer = IconData(0xe6ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">equalizer</i> &#x2014; material icon named "equalizer outlined".
  static const IconData equalizer_outlined = IconData(0xe17f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">equalizer</i> &#x2014; material icon named "equalizer rounded".
  static const IconData equalizer_rounded = IconData(0xf1ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">equalizer</i> &#x2014; material icon named "equalizer sharp".
  static const IconData equalizer_sharp = IconData(0xec80, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">error</i> &#x2014; material icon named "error".
  static const IconData error = IconData(0xe700, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">error_outline</i> &#x2014; material icon named "error outline".
  static const IconData error_outline = IconData(0xe701, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">error_outline</i> &#x2014; material icon named "error outline outlined".
  static const IconData error_outline_outlined = IconData(0xe180, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">error_outline</i> &#x2014; material icon named "error outline rounded".
  static const IconData error_outline_rounded = IconData(0xf1af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">error_outline</i> &#x2014; material icon named "error outline sharp".
  static const IconData error_outline_sharp = IconData(0xec81, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">error</i> &#x2014; material icon named "error outlined".
  static const IconData error_outlined = IconData(0xe181, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">error</i> &#x2014; material icon named "error rounded".
  static const IconData error_rounded = IconData(0xf1b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">error</i> &#x2014; material icon named "error sharp".
  static const IconData error_sharp = IconData(0xec82, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">escalator</i> &#x2014; material icon named "escalator".
  static const IconData escalator = IconData(0xe702, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">escalator</i> &#x2014; material icon named "escalator outlined".
  static const IconData escalator_outlined = IconData(0xe182, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">escalator</i> &#x2014; material icon named "escalator rounded".
  static const IconData escalator_rounded = IconData(0xf1b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">escalator</i> &#x2014; material icon named "escalator sharp".
  static const IconData escalator_sharp = IconData(0xec83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">escalator_warning</i> &#x2014; material icon named "escalator warning".
  static const IconData escalator_warning = IconData(0xe703, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">escalator_warning</i> &#x2014; material icon named "escalator warning outlined".
  static const IconData escalator_warning_outlined = IconData(0xe183, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">escalator_warning</i> &#x2014; material icon named "escalator warning rounded".
  static const IconData escalator_warning_rounded = IconData(0xf1b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">escalator_warning</i> &#x2014; material icon named "escalator warning sharp".
  static const IconData escalator_warning_sharp = IconData(0xec84, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">euro</i> &#x2014; material icon named "euro".
  static const IconData euro = IconData(0xe704, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">euro</i> &#x2014; material icon named "euro outlined".
  static const IconData euro_outlined = IconData(0xe184, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">euro</i> &#x2014; material icon named "euro rounded".
  static const IconData euro_rounded = IconData(0xf1b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">euro</i> &#x2014; material icon named "euro sharp".
  static const IconData euro_sharp = IconData(0xec85, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">euro_symbol</i> &#x2014; material icon named "euro symbol".
  static const IconData euro_symbol = IconData(0xe705, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">euro_symbol</i> &#x2014; material icon named "euro symbol outlined".
  static const IconData euro_symbol_outlined = IconData(0xe185, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">euro_symbol</i> &#x2014; material icon named "euro symbol rounded".
  static const IconData euro_symbol_rounded = IconData(0xf1b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">euro_symbol</i> &#x2014; material icon named "euro symbol sharp".
  static const IconData euro_symbol_sharp = IconData(0xec86, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ev_station</i> &#x2014; material icon named "ev station".
  static const IconData ev_station = IconData(0xe706, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ev_station</i> &#x2014; material icon named "ev station outlined".
  static const IconData ev_station_outlined = IconData(0xe186, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ev_station</i> &#x2014; material icon named "ev station rounded".
  static const IconData ev_station_rounded = IconData(0xf1b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ev_station</i> &#x2014; material icon named "ev station sharp".
  static const IconData ev_station_sharp = IconData(0xec87, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event</i> &#x2014; material icon named "event".
  static const IconData event = IconData(0xe707, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_available</i> &#x2014; material icon named "event available".
  static const IconData event_available = IconData(0xe708, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">event_available</i> &#x2014; material icon named "event available outlined".
  static const IconData event_available_outlined = IconData(0xe187, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">event_available</i> &#x2014; material icon named "event available rounded".
  static const IconData event_available_rounded = IconData(0xf1b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">event_available</i> &#x2014; material icon named "event available sharp".
  static const IconData event_available_sharp = IconData(0xec88, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_busy</i> &#x2014; material icon named "event busy".
  static const IconData event_busy = IconData(0xe709, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">event_busy</i> &#x2014; material icon named "event busy outlined".
  static const IconData event_busy_outlined = IconData(0xe188, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">event_busy</i> &#x2014; material icon named "event busy rounded".
  static const IconData event_busy_rounded = IconData(0xf1b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">event_busy</i> &#x2014; material icon named "event busy sharp".
  static const IconData event_busy_sharp = IconData(0xec89, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_note</i> &#x2014; material icon named "event note".
  static const IconData event_note = IconData(0xe70a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">event_note</i> &#x2014; material icon named "event note outlined".
  static const IconData event_note_outlined = IconData(0xe189, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">event_note</i> &#x2014; material icon named "event note rounded".
  static const IconData event_note_rounded = IconData(0xf1b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">event_note</i> &#x2014; material icon named "event note sharp".
  static const IconData event_note_sharp = IconData(0xec8a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">event</i> &#x2014; material icon named "event outlined".
  static const IconData event_outlined = IconData(0xe18a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">event</i> &#x2014; material icon named "event rounded".
  static const IconData event_rounded = IconData(0xf1b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_seat</i> &#x2014; material icon named "event seat".
  static const IconData event_seat = IconData(0xe70b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">event_seat</i> &#x2014; material icon named "event seat outlined".
  static const IconData event_seat_outlined = IconData(0xe18b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">event_seat</i> &#x2014; material icon named "event seat rounded".
  static const IconData event_seat_rounded = IconData(0xf1ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">event_seat</i> &#x2014; material icon named "event seat sharp".
  static const IconData event_seat_sharp = IconData(0xec8b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">event</i> &#x2014; material icon named "event sharp".
  static const IconData event_sharp = IconData(0xec8c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exit_to_app</i> &#x2014; material icon named "exit to app".
  static const IconData exit_to_app = IconData(0xe70c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exit_to_app</i> &#x2014; material icon named "exit to app outlined".
  static const IconData exit_to_app_outlined = IconData(0xe18c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exit_to_app</i> &#x2014; material icon named "exit to app rounded".
  static const IconData exit_to_app_rounded = IconData(0xf1bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exit_to_app</i> &#x2014; material icon named "exit to app sharp".
  static const IconData exit_to_app_sharp = IconData(0xec8d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">expand</i> &#x2014; material icon named "expand".
  static const IconData expand = IconData(0xe70d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">expand_less</i> &#x2014; material icon named "expand less".
  static const IconData expand_less = IconData(0xe70e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">expand_less</i> &#x2014; material icon named "expand less outlined".
  static const IconData expand_less_outlined = IconData(0xe18d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">expand_less</i> &#x2014; material icon named "expand less rounded".
  static const IconData expand_less_rounded = IconData(0xf1bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">expand_less</i> &#x2014; material icon named "expand less sharp".
  static const IconData expand_less_sharp = IconData(0xec8e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">expand_more</i> &#x2014; material icon named "expand more".
  static const IconData expand_more = IconData(0xe70f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">expand_more</i> &#x2014; material icon named "expand more outlined".
  static const IconData expand_more_outlined = IconData(0xe18e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">expand_more</i> &#x2014; material icon named "expand more rounded".
  static const IconData expand_more_rounded = IconData(0xf1bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">expand_more</i> &#x2014; material icon named "expand more sharp".
  static const IconData expand_more_sharp = IconData(0xec8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">explicit</i> &#x2014; material icon named "explicit".
  static const IconData explicit = IconData(0xe710, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">explicit</i> &#x2014; material icon named "explicit outlined".
  static const IconData explicit_outlined = IconData(0xe18f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">explicit</i> &#x2014; material icon named "explicit rounded".
  static const IconData explicit_rounded = IconData(0xf1be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">explicit</i> &#x2014; material icon named "explicit sharp".
  static const IconData explicit_sharp = IconData(0xec90, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">explore</i> &#x2014; material icon named "explore".
  static const IconData explore = IconData(0xe711, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">explore_off</i> &#x2014; material icon named "explore off".
  static const IconData explore_off = IconData(0xe712, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">explore_off</i> &#x2014; material icon named "explore off outlined".
  static const IconData explore_off_outlined = IconData(0xe190, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">explore_off</i> &#x2014; material icon named "explore off rounded".
  static const IconData explore_off_rounded = IconData(0xf1bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">explore_off</i> &#x2014; material icon named "explore off sharp".
  static const IconData explore_off_sharp = IconData(0xec91, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">explore</i> &#x2014; material icon named "explore outlined".
  static const IconData explore_outlined = IconData(0xe191, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">explore</i> &#x2014; material icon named "explore rounded".
  static const IconData explore_rounded = IconData(0xf1c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">explore</i> &#x2014; material icon named "explore sharp".
  static const IconData explore_sharp = IconData(0xec92, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure</i> &#x2014; material icon named "exposure".
  static const IconData exposure = IconData(0xe713, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_minus_1</i> &#x2014; material icon named "exposure minus 1".
  static const IconData exposure_minus_1 = IconData(0xe714, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_minus_1</i> &#x2014; material icon named "exposure minus 1 outlined".
  static const IconData exposure_minus_1_outlined = IconData(0xe192, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_minus_1</i> &#x2014; material icon named "exposure minus 1 rounded".
  static const IconData exposure_minus_1_rounded = IconData(0xf1c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_minus_1</i> &#x2014; material icon named "exposure minus 1 sharp".
  static const IconData exposure_minus_1_sharp = IconData(0xec93, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_minus_2</i> &#x2014; material icon named "exposure minus 2".
  static const IconData exposure_minus_2 = IconData(0xe715, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_minus_2</i> &#x2014; material icon named "exposure minus 2 outlined".
  static const IconData exposure_minus_2_outlined = IconData(0xe193, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_minus_2</i> &#x2014; material icon named "exposure minus 2 rounded".
  static const IconData exposure_minus_2_rounded = IconData(0xf1c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_minus_2</i> &#x2014; material icon named "exposure minus 2 sharp".
  static const IconData exposure_minus_2_sharp = IconData(0xec94, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_neg_1</i> &#x2014; material icon named "exposure neg 1".
  static const IconData exposure_neg_1 = IconData(0xe714, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_neg_1</i> &#x2014; material icon named "exposure neg 1 outlined".
  static const IconData exposure_neg_1_outlined = IconData(0xe192, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_neg_1</i> &#x2014; material icon named "exposure neg 1 rounded".
  static const IconData exposure_neg_1_rounded = IconData(0xf1c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_neg_1</i> &#x2014; material icon named "exposure neg 1 sharp".
  static const IconData exposure_neg_1_sharp = IconData(0xec93, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_neg_2</i> &#x2014; material icon named "exposure neg 2".
  static const IconData exposure_neg_2 = IconData(0xe715, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_neg_2</i> &#x2014; material icon named "exposure neg 2 outlined".
  static const IconData exposure_neg_2_outlined = IconData(0xe193, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_neg_2</i> &#x2014; material icon named "exposure neg 2 rounded".
  static const IconData exposure_neg_2_rounded = IconData(0xf1c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_neg_2</i> &#x2014; material icon named "exposure neg 2 sharp".
  static const IconData exposure_neg_2_sharp = IconData(0xec94, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure</i> &#x2014; material icon named "exposure outlined".
  static const IconData exposure_outlined = IconData(0xe194, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_plus_1</i> &#x2014; material icon named "exposure plus 1".
  static const IconData exposure_plus_1 = IconData(0xe716, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_plus_1</i> &#x2014; material icon named "exposure plus 1 outlined".
  static const IconData exposure_plus_1_outlined = IconData(0xe195, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_plus_1</i> &#x2014; material icon named "exposure plus 1 rounded".
  static const IconData exposure_plus_1_rounded = IconData(0xf1c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_plus_1</i> &#x2014; material icon named "exposure plus 1 sharp".
  static const IconData exposure_plus_1_sharp = IconData(0xec95, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_plus_2</i> &#x2014; material icon named "exposure plus 2".
  static const IconData exposure_plus_2 = IconData(0xe717, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_plus_2</i> &#x2014; material icon named "exposure plus 2 outlined".
  static const IconData exposure_plus_2_outlined = IconData(0xe196, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_plus_2</i> &#x2014; material icon named "exposure plus 2 rounded".
  static const IconData exposure_plus_2_rounded = IconData(0xf1c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_plus_2</i> &#x2014; material icon named "exposure plus 2 sharp".
  static const IconData exposure_plus_2_sharp = IconData(0xec96, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure</i> &#x2014; material icon named "exposure rounded".
  static const IconData exposure_rounded = IconData(0xf1c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure</i> &#x2014; material icon named "exposure sharp".
  static const IconData exposure_sharp = IconData(0xec97, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_zero</i> &#x2014; material icon named "exposure zero".
  static const IconData exposure_zero = IconData(0xe718, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_zero</i> &#x2014; material icon named "exposure zero outlined".
  static const IconData exposure_zero_outlined = IconData(0xe197, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_zero</i> &#x2014; material icon named "exposure zero rounded".
  static const IconData exposure_zero_rounded = IconData(0xf1c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_zero</i> &#x2014; material icon named "exposure zero sharp".
  static const IconData exposure_zero_sharp = IconData(0xec98, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">extension</i> &#x2014; material icon named "extension".
  static const IconData extension = IconData(0xe719, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">extension</i> &#x2014; material icon named "extension outlined".
  static const IconData extension_outlined = IconData(0xe198, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">extension</i> &#x2014; material icon named "extension rounded".
  static const IconData extension_rounded = IconData(0xf1c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">extension</i> &#x2014; material icon named "extension sharp".
  static const IconData extension_sharp = IconData(0xec99, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">face</i> &#x2014; material icon named "face".
  static const IconData face = IconData(0xe71a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">face</i> &#x2014; material icon named "face outlined".
  static const IconData face_outlined = IconData(0xe199, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">face_retouching_natural</i> &#x2014; material icon named "face retouching natural".
  static const IconData face_retouching_natural = IconData(0xe71b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">face</i> &#x2014; material icon named "face rounded".
  static const IconData face_rounded = IconData(0xf1c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">face</i> &#x2014; material icon named "face sharp".
  static const IconData face_sharp = IconData(0xec9a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">face_unlock</i> &#x2014; material icon named "face unlock outlined".
  static const IconData face_unlock_outlined = IconData(0xe19a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">face_unlock</i> &#x2014; material icon named "face unlock rounded".
  static const IconData face_unlock_rounded = IconData(0xf1c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">face_unlock</i> &#x2014; material icon named "face unlock sharp".
  static const IconData face_unlock_sharp = IconData(0xec9b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fact_check</i> &#x2014; material icon named "fact check".
  static const IconData fact_check = IconData(0xe71c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fact_check</i> &#x2014; material icon named "fact check outlined".
  static const IconData fact_check_outlined = IconData(0xe19b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fact_check</i> &#x2014; material icon named "fact check rounded".
  static const IconData fact_check_rounded = IconData(0xf1ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fact_check</i> &#x2014; material icon named "fact check sharp".
  static const IconData fact_check_sharp = IconData(0xec9c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">family_restroom</i> &#x2014; material icon named "family restroom".
  static const IconData family_restroom = IconData(0xe71d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">family_restroom</i> &#x2014; material icon named "family restroom outlined".
  static const IconData family_restroom_outlined = IconData(0xe19c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">family_restroom</i> &#x2014; material icon named "family restroom rounded".
  static const IconData family_restroom_rounded = IconData(0xf1cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">family_restroom</i> &#x2014; material icon named "family restroom sharp".
  static const IconData family_restroom_sharp = IconData(0xec9d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fast_forward</i> &#x2014; material icon named "fast forward".
  static const IconData fast_forward = IconData(0xe71e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fast_forward</i> &#x2014; material icon named "fast forward outlined".
  static const IconData fast_forward_outlined = IconData(0xe19d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fast_forward</i> &#x2014; material icon named "fast forward rounded".
  static const IconData fast_forward_rounded = IconData(0xf1cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fast_forward</i> &#x2014; material icon named "fast forward sharp".
  static const IconData fast_forward_sharp = IconData(0xec9e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fast_rewind</i> &#x2014; material icon named "fast rewind".
  static const IconData fast_rewind = IconData(0xe71f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fast_rewind</i> &#x2014; material icon named "fast rewind outlined".
  static const IconData fast_rewind_outlined = IconData(0xe19e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fast_rewind</i> &#x2014; material icon named "fast rewind rounded".
  static const IconData fast_rewind_rounded = IconData(0xf1cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fast_rewind</i> &#x2014; material icon named "fast rewind sharp".
  static const IconData fast_rewind_sharp = IconData(0xec9f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fastfood</i> &#x2014; material icon named "fastfood".
  static const IconData fastfood = IconData(0xe720, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fastfood</i> &#x2014; material icon named "fastfood outlined".
  static const IconData fastfood_outlined = IconData(0xe19f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fastfood</i> &#x2014; material icon named "fastfood rounded".
  static const IconData fastfood_rounded = IconData(0xf1ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fastfood</i> &#x2014; material icon named "fastfood sharp".
  static const IconData fastfood_sharp = IconData(0xeca0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">favorite</i> &#x2014; material icon named "favorite".
  static const IconData favorite = IconData(0xe721, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">favorite_border</i> &#x2014; material icon named "favorite border".
  static const IconData favorite_border = IconData(0xe722, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">favorite_border</i> &#x2014; material icon named "favorite border outlined".
  static const IconData favorite_border_outlined = IconData(0xe1a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">favorite_border</i> &#x2014; material icon named "favorite border rounded".
  static const IconData favorite_border_rounded = IconData(0xf1cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">favorite_border</i> &#x2014; material icon named "favorite border sharp".
  static const IconData favorite_border_sharp = IconData(0xeca1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">favorite_outline</i> &#x2014; material icon named "favorite outline".
  static const IconData favorite_outline = IconData(0xe722, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">favorite_outline</i> &#x2014; material icon named "favorite outline outlined".
  static const IconData favorite_outline_outlined = IconData(0xe1a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">favorite_outline</i> &#x2014; material icon named "favorite outline rounded".
  static const IconData favorite_outline_rounded = IconData(0xf1cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">favorite_outline</i> &#x2014; material icon named "favorite outline sharp".
  static const IconData favorite_outline_sharp = IconData(0xeca1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">favorite</i> &#x2014; material icon named "favorite outlined".
  static const IconData favorite_outlined = IconData(0xe1a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">favorite</i> &#x2014; material icon named "favorite rounded".
  static const IconData favorite_rounded = IconData(0xf1d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">favorite</i> &#x2014; material icon named "favorite sharp".
  static const IconData favorite_sharp = IconData(0xeca2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">featured_play_list</i> &#x2014; material icon named "featured play list".
  static const IconData featured_play_list = IconData(0xe723, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">featured_play_list</i> &#x2014; material icon named "featured play list outlined".
  static const IconData featured_play_list_outlined = IconData(0xe1a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">featured_play_list</i> &#x2014; material icon named "featured play list rounded".
  static const IconData featured_play_list_rounded = IconData(0xf1d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">featured_play_list</i> &#x2014; material icon named "featured play list sharp".
  static const IconData featured_play_list_sharp = IconData(0xeca3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">featured_video</i> &#x2014; material icon named "featured video".
  static const IconData featured_video = IconData(0xe724, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">featured_video</i> &#x2014; material icon named "featured video outlined".
  static const IconData featured_video_outlined = IconData(0xe1a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">featured_video</i> &#x2014; material icon named "featured video rounded".
  static const IconData featured_video_rounded = IconData(0xf1d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">featured_video</i> &#x2014; material icon named "featured video sharp".
  static const IconData featured_video_sharp = IconData(0xeca4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">feedback</i> &#x2014; material icon named "feedback".
  static const IconData feedback = IconData(0xe725, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">feedback</i> &#x2014; material icon named "feedback outlined".
  static const IconData feedback_outlined = IconData(0xe1a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">feedback</i> &#x2014; material icon named "feedback rounded".
  static const IconData feedback_rounded = IconData(0xf1d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">feedback</i> &#x2014; material icon named "feedback sharp".
  static const IconData feedback_sharp = IconData(0xeca5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fence</i> &#x2014; material icon named "fence".
  static const IconData fence = IconData(0xe726, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fence</i> &#x2014; material icon named "fence outlined".
  static const IconData fence_outlined = IconData(0xe1a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fence</i> &#x2014; material icon named "fence rounded".
  static const IconData fence_rounded = IconData(0xf1d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fence</i> &#x2014; material icon named "fence sharp".
  static const IconData fence_sharp = IconData(0xeca6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">festival</i> &#x2014; material icon named "festival".
  static const IconData festival = IconData(0xe727, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_dvr</i> &#x2014; material icon named "fiber dvr".
  static const IconData fiber_dvr = IconData(0xe728, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_dvr</i> &#x2014; material icon named "fiber dvr outlined".
  static const IconData fiber_dvr_outlined = IconData(0xe1a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_dvr</i> &#x2014; material icon named "fiber dvr rounded".
  static const IconData fiber_dvr_rounded = IconData(0xf1d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_dvr</i> &#x2014; material icon named "fiber dvr sharp".
  static const IconData fiber_dvr_sharp = IconData(0xeca7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_manual_record</i> &#x2014; material icon named "fiber manual record".
  static const IconData fiber_manual_record = IconData(0xe729, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_manual_record</i> &#x2014; material icon named "fiber manual record outlined".
  static const IconData fiber_manual_record_outlined = IconData(0xe1a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_manual_record</i> &#x2014; material icon named "fiber manual record rounded".
  static const IconData fiber_manual_record_rounded = IconData(0xf1d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_manual_record</i> &#x2014; material icon named "fiber manual record sharp".
  static const IconData fiber_manual_record_sharp = IconData(0xeca8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_new</i> &#x2014; material icon named "fiber new".
  static const IconData fiber_new = IconData(0xe72a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_new</i> &#x2014; material icon named "fiber new outlined".
  static const IconData fiber_new_outlined = IconData(0xe1a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_new</i> &#x2014; material icon named "fiber new rounded".
  static const IconData fiber_new_rounded = IconData(0xf1d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_new</i> &#x2014; material icon named "fiber new sharp".
  static const IconData fiber_new_sharp = IconData(0xeca9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_pin</i> &#x2014; material icon named "fiber pin".
  static const IconData fiber_pin = IconData(0xe72b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_pin</i> &#x2014; material icon named "fiber pin outlined".
  static const IconData fiber_pin_outlined = IconData(0xe1a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_pin</i> &#x2014; material icon named "fiber pin rounded".
  static const IconData fiber_pin_rounded = IconData(0xf1d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_pin</i> &#x2014; material icon named "fiber pin sharp".
  static const IconData fiber_pin_sharp = IconData(0xecaa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_smart_record</i> &#x2014; material icon named "fiber smart record".
  static const IconData fiber_smart_record = IconData(0xe72c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_smart_record</i> &#x2014; material icon named "fiber smart record outlined".
  static const IconData fiber_smart_record_outlined = IconData(0xe1aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_smart_record</i> &#x2014; material icon named "fiber smart record rounded".
  static const IconData fiber_smart_record_rounded = IconData(0xf1d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_smart_record</i> &#x2014; material icon named "fiber smart record sharp".
  static const IconData fiber_smart_record_sharp = IconData(0xecab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_copy</i> &#x2014; material icon named "file copy".
  static const IconData file_copy = IconData(0xe72d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">file_copy</i> &#x2014; material icon named "file copy outlined".
  static const IconData file_copy_outlined = IconData(0xe1ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">file_copy</i> &#x2014; material icon named "file copy rounded".
  static const IconData file_copy_rounded = IconData(0xf1da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">file_copy</i> &#x2014; material icon named "file copy sharp".
  static const IconData file_copy_sharp = IconData(0xecac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_download</i> &#x2014; material icon named "file download".
  static const IconData file_download = IconData(0xe72e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_download_done</i> &#x2014; material icon named "file download done".
  static const IconData file_download_done = IconData(0xe72f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_present</i> &#x2014; material icon named "file present".
  static const IconData file_present = IconData(0xe730, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_upload</i> &#x2014; material icon named "file upload".
  static const IconData file_upload = IconData(0xe731, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter</i> &#x2014; material icon named "filter".
  static const IconData filter = IconData(0xe732, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_1</i> &#x2014; material icon named "filter 1".
  static const IconData filter_1 = IconData(0xe733, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_1</i> &#x2014; material icon named "filter 1 outlined".
  static const IconData filter_1_outlined = IconData(0xe1ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_1</i> &#x2014; material icon named "filter 1 rounded".
  static const IconData filter_1_rounded = IconData(0xf1db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_1</i> &#x2014; material icon named "filter 1 sharp".
  static const IconData filter_1_sharp = IconData(0xecad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_2</i> &#x2014; material icon named "filter 2".
  static const IconData filter_2 = IconData(0xe734, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_2</i> &#x2014; material icon named "filter 2 outlined".
  static const IconData filter_2_outlined = IconData(0xe1ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_2</i> &#x2014; material icon named "filter 2 rounded".
  static const IconData filter_2_rounded = IconData(0xf1dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_2</i> &#x2014; material icon named "filter 2 sharp".
  static const IconData filter_2_sharp = IconData(0xecae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_3</i> &#x2014; material icon named "filter 3".
  static const IconData filter_3 = IconData(0xe735, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_3</i> &#x2014; material icon named "filter 3 outlined".
  static const IconData filter_3_outlined = IconData(0xe1ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_3</i> &#x2014; material icon named "filter 3 rounded".
  static const IconData filter_3_rounded = IconData(0xf1dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_3</i> &#x2014; material icon named "filter 3 sharp".
  static const IconData filter_3_sharp = IconData(0xecaf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_4</i> &#x2014; material icon named "filter 4".
  static const IconData filter_4 = IconData(0xe736, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_4</i> &#x2014; material icon named "filter 4 outlined".
  static const IconData filter_4_outlined = IconData(0xe1af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_4</i> &#x2014; material icon named "filter 4 rounded".
  static const IconData filter_4_rounded = IconData(0xf1de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_4</i> &#x2014; material icon named "filter 4 sharp".
  static const IconData filter_4_sharp = IconData(0xecb0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_5</i> &#x2014; material icon named "filter 5".
  static const IconData filter_5 = IconData(0xe737, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_5</i> &#x2014; material icon named "filter 5 outlined".
  static const IconData filter_5_outlined = IconData(0xe1b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_5</i> &#x2014; material icon named "filter 5 rounded".
  static const IconData filter_5_rounded = IconData(0xf1df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_5</i> &#x2014; material icon named "filter 5 sharp".
  static const IconData filter_5_sharp = IconData(0xecb1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_6</i> &#x2014; material icon named "filter 6".
  static const IconData filter_6 = IconData(0xe738, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_6</i> &#x2014; material icon named "filter 6 outlined".
  static const IconData filter_6_outlined = IconData(0xe1b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_6</i> &#x2014; material icon named "filter 6 rounded".
  static const IconData filter_6_rounded = IconData(0xf1e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_6</i> &#x2014; material icon named "filter 6 sharp".
  static const IconData filter_6_sharp = IconData(0xecb2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_7</i> &#x2014; material icon named "filter 7".
  static const IconData filter_7 = IconData(0xe739, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_7</i> &#x2014; material icon named "filter 7 outlined".
  static const IconData filter_7_outlined = IconData(0xe1b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_7</i> &#x2014; material icon named "filter 7 rounded".
  static const IconData filter_7_rounded = IconData(0xf1e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_7</i> &#x2014; material icon named "filter 7 sharp".
  static const IconData filter_7_sharp = IconData(0xecb3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_8</i> &#x2014; material icon named "filter 8".
  static const IconData filter_8 = IconData(0xe73a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_8</i> &#x2014; material icon named "filter 8 outlined".
  static const IconData filter_8_outlined = IconData(0xe1b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_8</i> &#x2014; material icon named "filter 8 rounded".
  static const IconData filter_8_rounded = IconData(0xf1e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_8</i> &#x2014; material icon named "filter 8 sharp".
  static const IconData filter_8_sharp = IconData(0xecb4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_9</i> &#x2014; material icon named "filter 9".
  static const IconData filter_9 = IconData(0xe73b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_9</i> &#x2014; material icon named "filter 9 outlined".
  static const IconData filter_9_outlined = IconData(0xe1b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_9_plus</i> &#x2014; material icon named "filter 9 plus".
  static const IconData filter_9_plus = IconData(0xe73c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_9_plus</i> &#x2014; material icon named "filter 9 plus outlined".
  static const IconData filter_9_plus_outlined = IconData(0xe1b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_9_plus</i> &#x2014; material icon named "filter 9 plus rounded".
  static const IconData filter_9_plus_rounded = IconData(0xf1e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_9_plus</i> &#x2014; material icon named "filter 9 plus sharp".
  static const IconData filter_9_plus_sharp = IconData(0xecb5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_9</i> &#x2014; material icon named "filter 9 rounded".
  static const IconData filter_9_rounded = IconData(0xf1e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_9</i> &#x2014; material icon named "filter 9 sharp".
  static const IconData filter_9_sharp = IconData(0xecb6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_alt</i> &#x2014; material icon named "filter alt".
  static const IconData filter_alt = IconData(0xe73d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_alt</i> &#x2014; material icon named "filter alt outlined".
  static const IconData filter_alt_outlined = IconData(0xe1b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_alt</i> &#x2014; material icon named "filter alt rounded".
  static const IconData filter_alt_rounded = IconData(0xf1e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_alt</i> &#x2014; material icon named "filter alt sharp".
  static const IconData filter_alt_sharp = IconData(0xecb7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_b_and_w</i> &#x2014; material icon named "filter b and w".
  static const IconData filter_b_and_w = IconData(0xe73e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_b_and_w</i> &#x2014; material icon named "filter b and w outlined".
  static const IconData filter_b_and_w_outlined = IconData(0xe1b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_b_and_w</i> &#x2014; material icon named "filter b and w rounded".
  static const IconData filter_b_and_w_rounded = IconData(0xf1e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_b_and_w</i> &#x2014; material icon named "filter b and w sharp".
  static const IconData filter_b_and_w_sharp = IconData(0xecb8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_center_focus</i> &#x2014; material icon named "filter center focus".
  static const IconData filter_center_focus = IconData(0xe73f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_center_focus</i> &#x2014; material icon named "filter center focus outlined".
  static const IconData filter_center_focus_outlined = IconData(0xe1b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_center_focus</i> &#x2014; material icon named "filter center focus rounded".
  static const IconData filter_center_focus_rounded = IconData(0xf1e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_center_focus</i> &#x2014; material icon named "filter center focus sharp".
  static const IconData filter_center_focus_sharp = IconData(0xecb9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_drama</i> &#x2014; material icon named "filter drama".
  static const IconData filter_drama = IconData(0xe740, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_drama</i> &#x2014; material icon named "filter drama outlined".
  static const IconData filter_drama_outlined = IconData(0xe1b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_drama</i> &#x2014; material icon named "filter drama rounded".
  static const IconData filter_drama_rounded = IconData(0xf1e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_drama</i> &#x2014; material icon named "filter drama sharp".
  static const IconData filter_drama_sharp = IconData(0xecba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_frames</i> &#x2014; material icon named "filter frames".
  static const IconData filter_frames = IconData(0xe741, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_frames</i> &#x2014; material icon named "filter frames outlined".
  static const IconData filter_frames_outlined = IconData(0xe1ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_frames</i> &#x2014; material icon named "filter frames rounded".
  static const IconData filter_frames_rounded = IconData(0xf1e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_frames</i> &#x2014; material icon named "filter frames sharp".
  static const IconData filter_frames_sharp = IconData(0xecbb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_hdr</i> &#x2014; material icon named "filter hdr".
  static const IconData filter_hdr = IconData(0xe742, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_hdr</i> &#x2014; material icon named "filter hdr outlined".
  static const IconData filter_hdr_outlined = IconData(0xe1bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_hdr</i> &#x2014; material icon named "filter hdr rounded".
  static const IconData filter_hdr_rounded = IconData(0xf1ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_hdr</i> &#x2014; material icon named "filter hdr sharp".
  static const IconData filter_hdr_sharp = IconData(0xecbc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_list</i> &#x2014; material icon named "filter list".
  static const IconData filter_list = IconData(0xe743, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_list_alt</i> &#x2014; material icon named "filter list alt".
  static const IconData filter_list_alt = IconData(0xe744, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_list</i> &#x2014; material icon named "filter list outlined".
  static const IconData filter_list_outlined = IconData(0xe1bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_list</i> &#x2014; material icon named "filter list rounded".
  static const IconData filter_list_rounded = IconData(0xf1eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_list</i> &#x2014; material icon named "filter list sharp".
  static const IconData filter_list_sharp = IconData(0xecbd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_none</i> &#x2014; material icon named "filter none".
  static const IconData filter_none = IconData(0xe745, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_none</i> &#x2014; material icon named "filter none outlined".
  static const IconData filter_none_outlined = IconData(0xe1bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_none</i> &#x2014; material icon named "filter none rounded".
  static const IconData filter_none_rounded = IconData(0xf1ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_none</i> &#x2014; material icon named "filter none sharp".
  static const IconData filter_none_sharp = IconData(0xecbe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter</i> &#x2014; material icon named "filter outlined".
  static const IconData filter_outlined = IconData(0xe1be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter</i> &#x2014; material icon named "filter rounded".
  static const IconData filter_rounded = IconData(0xf1ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter</i> &#x2014; material icon named "filter sharp".
  static const IconData filter_sharp = IconData(0xecbf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_tilt_shift</i> &#x2014; material icon named "filter tilt shift".
  static const IconData filter_tilt_shift = IconData(0xe746, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_tilt_shift</i> &#x2014; material icon named "filter tilt shift outlined".
  static const IconData filter_tilt_shift_outlined = IconData(0xe1bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_tilt_shift</i> &#x2014; material icon named "filter tilt shift rounded".
  static const IconData filter_tilt_shift_rounded = IconData(0xf1ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_tilt_shift</i> &#x2014; material icon named "filter tilt shift sharp".
  static const IconData filter_tilt_shift_sharp = IconData(0xecc0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_vintage</i> &#x2014; material icon named "filter vintage".
  static const IconData filter_vintage = IconData(0xe747, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_vintage</i> &#x2014; material icon named "filter vintage outlined".
  static const IconData filter_vintage_outlined = IconData(0xe1c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_vintage</i> &#x2014; material icon named "filter vintage rounded".
  static const IconData filter_vintage_rounded = IconData(0xf1ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_vintage</i> &#x2014; material icon named "filter vintage sharp".
  static const IconData filter_vintage_sharp = IconData(0xecc1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">find_in_page</i> &#x2014; material icon named "find in page".
  static const IconData find_in_page = IconData(0xe748, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">find_in_page</i> &#x2014; material icon named "find in page outlined".
  static const IconData find_in_page_outlined = IconData(0xe1c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">find_in_page</i> &#x2014; material icon named "find in page rounded".
  static const IconData find_in_page_rounded = IconData(0xf1f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">find_in_page</i> &#x2014; material icon named "find in page sharp".
  static const IconData find_in_page_sharp = IconData(0xecc2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">find_replace</i> &#x2014; material icon named "find replace".
  static const IconData find_replace = IconData(0xe749, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">find_replace</i> &#x2014; material icon named "find replace outlined".
  static const IconData find_replace_outlined = IconData(0xe1c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">find_replace</i> &#x2014; material icon named "find replace rounded".
  static const IconData find_replace_rounded = IconData(0xf1f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">find_replace</i> &#x2014; material icon named "find replace sharp".
  static const IconData find_replace_sharp = IconData(0xecc3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fingerprint</i> &#x2014; material icon named "fingerprint".
  static const IconData fingerprint = IconData(0xe74a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fingerprint</i> &#x2014; material icon named "fingerprint outlined".
  static const IconData fingerprint_outlined = IconData(0xe1c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fingerprint</i> &#x2014; material icon named "fingerprint rounded".
  static const IconData fingerprint_rounded = IconData(0xf1f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fingerprint</i> &#x2014; material icon named "fingerprint sharp".
  static const IconData fingerprint_sharp = IconData(0xecc4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fire_extinguisher</i> &#x2014; material icon named "fire extinguisher".
  static const IconData fire_extinguisher = IconData(0xe74b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fire_extinguisher</i> &#x2014; material icon named "fire extinguisher outlined".
  static const IconData fire_extinguisher_outlined = IconData(0xe1c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fire_extinguisher</i> &#x2014; material icon named "fire extinguisher rounded".
  static const IconData fire_extinguisher_rounded = IconData(0xf1f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fire_extinguisher</i> &#x2014; material icon named "fire extinguisher sharp".
  static const IconData fire_extinguisher_sharp = IconData(0xecc5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fire_hydrant</i> &#x2014; material icon named "fire hydrant".
  static const IconData fire_hydrant = IconData(0xe74c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fireplace</i> &#x2014; material icon named "fireplace".
  static const IconData fireplace = IconData(0xe74d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fireplace</i> &#x2014; material icon named "fireplace outlined".
  static const IconData fireplace_outlined = IconData(0xe1c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fireplace</i> &#x2014; material icon named "fireplace rounded".
  static const IconData fireplace_rounded = IconData(0xf1f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fireplace</i> &#x2014; material icon named "fireplace sharp".
  static const IconData fireplace_sharp = IconData(0xecc6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">first_page</i> &#x2014; material icon named "first page".
  static const IconData first_page = IconData(0xe74e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">first_page</i> &#x2014; material icon named "first page outlined".
  static const IconData first_page_outlined = IconData(0xe1c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">first_page</i> &#x2014; material icon named "first page rounded".
  static const IconData first_page_rounded = IconData(0xf1f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">first_page</i> &#x2014; material icon named "first page sharp".
  static const IconData first_page_sharp = IconData(0xecc7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fit_screen</i> &#x2014; material icon named "fit screen".
  static const IconData fit_screen = IconData(0xe74f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fitness_center</i> &#x2014; material icon named "fitness center".
  static const IconData fitness_center = IconData(0xe750, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fitness_center</i> &#x2014; material icon named "fitness center outlined".
  static const IconData fitness_center_outlined = IconData(0xe1c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fitness_center</i> &#x2014; material icon named "fitness center rounded".
  static const IconData fitness_center_rounded = IconData(0xf1f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fitness_center</i> &#x2014; material icon named "fitness center sharp".
  static const IconData fitness_center_sharp = IconData(0xecc8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flag</i> &#x2014; material icon named "flag".
  static const IconData flag = IconData(0xe751, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flag</i> &#x2014; material icon named "flag outlined".
  static const IconData flag_outlined = IconData(0xe1c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flag</i> &#x2014; material icon named "flag rounded".
  static const IconData flag_rounded = IconData(0xf1f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flag</i> &#x2014; material icon named "flag sharp".
  static const IconData flag_sharp = IconData(0xecc9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flaky</i> &#x2014; material icon named "flaky".
  static const IconData flaky = IconData(0xe752, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flaky</i> &#x2014; material icon named "flaky outlined".
  static const IconData flaky_outlined = IconData(0xe1c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flaky</i> &#x2014; material icon named "flaky rounded".
  static const IconData flaky_rounded = IconData(0xf1f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flaky</i> &#x2014; material icon named "flaky sharp".
  static const IconData flaky_sharp = IconData(0xecca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flare</i> &#x2014; material icon named "flare".
  static const IconData flare = IconData(0xe753, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flare</i> &#x2014; material icon named "flare outlined".
  static const IconData flare_outlined = IconData(0xe1ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flare</i> &#x2014; material icon named "flare rounded".
  static const IconData flare_rounded = IconData(0xf1f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flare</i> &#x2014; material icon named "flare sharp".
  static const IconData flare_sharp = IconData(0xeccb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flash_auto</i> &#x2014; material icon named "flash auto".
  static const IconData flash_auto = IconData(0xe754, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flash_auto</i> &#x2014; material icon named "flash auto outlined".
  static const IconData flash_auto_outlined = IconData(0xe1cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flash_auto</i> &#x2014; material icon named "flash auto rounded".
  static const IconData flash_auto_rounded = IconData(0xf1fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flash_auto</i> &#x2014; material icon named "flash auto sharp".
  static const IconData flash_auto_sharp = IconData(0xeccc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flash_off</i> &#x2014; material icon named "flash off".
  static const IconData flash_off = IconData(0xe755, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flash_off</i> &#x2014; material icon named "flash off outlined".
  static const IconData flash_off_outlined = IconData(0xe1cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flash_off</i> &#x2014; material icon named "flash off rounded".
  static const IconData flash_off_rounded = IconData(0xf1fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flash_off</i> &#x2014; material icon named "flash off sharp".
  static const IconData flash_off_sharp = IconData(0xeccd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flash_on</i> &#x2014; material icon named "flash on".
  static const IconData flash_on = IconData(0xe756, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flash_on</i> &#x2014; material icon named "flash on outlined".
  static const IconData flash_on_outlined = IconData(0xe1cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flash_on</i> &#x2014; material icon named "flash on rounded".
  static const IconData flash_on_rounded = IconData(0xf1fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flash_on</i> &#x2014; material icon named "flash on sharp".
  static const IconData flash_on_sharp = IconData(0xecce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flight</i> &#x2014; material icon named "flight".
  static const IconData flight = IconData(0xe757, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flight_land</i> &#x2014; material icon named "flight land".
  static const IconData flight_land = IconData(0xe758, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">flight_land</i> &#x2014; material icon named "flight land outlined".
  static const IconData flight_land_outlined = IconData(0xe1ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flight_land</i> &#x2014; material icon named "flight land rounded".
  static const IconData flight_land_rounded = IconData(0xf1fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flight_land</i> &#x2014; material icon named "flight land sharp".
  static const IconData flight_land_sharp = IconData(0xeccf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flight</i> &#x2014; material icon named "flight outlined".
  static const IconData flight_outlined = IconData(0xe1cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flight</i> &#x2014; material icon named "flight rounded".
  static const IconData flight_rounded = IconData(0xf1fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flight</i> &#x2014; material icon named "flight sharp".
  static const IconData flight_sharp = IconData(0xecd0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flight_takeoff</i> &#x2014; material icon named "flight takeoff".
  static const IconData flight_takeoff = IconData(0xe759, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">flight_takeoff</i> &#x2014; material icon named "flight takeoff outlined".
  static const IconData flight_takeoff_outlined = IconData(0xe1d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flight_takeoff</i> &#x2014; material icon named "flight takeoff rounded".
  static const IconData flight_takeoff_rounded = IconData(0xf1ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flight_takeoff</i> &#x2014; material icon named "flight takeoff sharp".
  static const IconData flight_takeoff_sharp = IconData(0xecd1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip</i> &#x2014; material icon named "flip".
  static const IconData flip = IconData(0xe75a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android".
  static const IconData flip_camera_android = IconData(0xe75b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android outlined".
  static const IconData flip_camera_android_outlined = IconData(0xe1d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android rounded".
  static const IconData flip_camera_android_rounded = IconData(0xf200, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android sharp".
  static const IconData flip_camera_android_sharp = IconData(0xecd2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios".
  static const IconData flip_camera_ios = IconData(0xe75c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios outlined".
  static const IconData flip_camera_ios_outlined = IconData(0xe1d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios rounded".
  static const IconData flip_camera_ios_rounded = IconData(0xf201, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios sharp".
  static const IconData flip_camera_ios_sharp = IconData(0xecd3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip</i> &#x2014; material icon named "flip outlined".
  static const IconData flip_outlined = IconData(0xe1d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip</i> &#x2014; material icon named "flip rounded".
  static const IconData flip_rounded = IconData(0xf202, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip</i> &#x2014; material icon named "flip sharp".
  static const IconData flip_sharp = IconData(0xecd4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_to_back</i> &#x2014; material icon named "flip to back".
  static const IconData flip_to_back = IconData(0xe75d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip_to_back</i> &#x2014; material icon named "flip to back outlined".
  static const IconData flip_to_back_outlined = IconData(0xe1d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip_to_back</i> &#x2014; material icon named "flip to back rounded".
  static const IconData flip_to_back_rounded = IconData(0xf203, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip_to_back</i> &#x2014; material icon named "flip to back sharp".
  static const IconData flip_to_back_sharp = IconData(0xecd5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_to_front</i> &#x2014; material icon named "flip to front".
  static const IconData flip_to_front = IconData(0xe75e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip_to_front</i> &#x2014; material icon named "flip to front outlined".
  static const IconData flip_to_front_outlined = IconData(0xe1d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip_to_front</i> &#x2014; material icon named "flip to front rounded".
  static const IconData flip_to_front_rounded = IconData(0xf204, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip_to_front</i> &#x2014; material icon named "flip to front sharp".
  static const IconData flip_to_front_sharp = IconData(0xecd6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder</i> &#x2014; material icon named "folder".
  static const IconData folder = IconData(0xe75f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder_open</i> &#x2014; material icon named "folder open".
  static const IconData folder_open = IconData(0xe760, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">folder_open</i> &#x2014; material icon named "folder open outlined".
  static const IconData folder_open_outlined = IconData(0xe1d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">folder_open</i> &#x2014; material icon named "folder open rounded".
  static const IconData folder_open_rounded = IconData(0xf205, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">folder_open</i> &#x2014; material icon named "folder open sharp".
  static const IconData folder_open_sharp = IconData(0xecd7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">folder</i> &#x2014; material icon named "folder outlined".
  static const IconData folder_outlined = IconData(0xe1d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">folder</i> &#x2014; material icon named "folder rounded".
  static const IconData folder_rounded = IconData(0xf206, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder_shared</i> &#x2014; material icon named "folder shared".
  static const IconData folder_shared = IconData(0xe761, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">folder_shared</i> &#x2014; material icon named "folder shared outlined".
  static const IconData folder_shared_outlined = IconData(0xe1d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">folder_shared</i> &#x2014; material icon named "folder shared rounded".
  static const IconData folder_shared_rounded = IconData(0xf207, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">folder_shared</i> &#x2014; material icon named "folder shared sharp".
  static const IconData folder_shared_sharp = IconData(0xecd8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">folder</i> &#x2014; material icon named "folder sharp".
  static const IconData folder_sharp = IconData(0xecd9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder_special</i> &#x2014; material icon named "folder special".
  static const IconData folder_special = IconData(0xe762, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">folder_special</i> &#x2014; material icon named "folder special outlined".
  static const IconData folder_special_outlined = IconData(0xe1d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">folder_special</i> &#x2014; material icon named "folder special rounded".
  static const IconData folder_special_rounded = IconData(0xf208, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">folder_special</i> &#x2014; material icon named "folder special sharp".
  static const IconData folder_special_sharp = IconData(0xecda, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">follow_the_signs</i> &#x2014; material icon named "follow the signs".
  static const IconData follow_the_signs = IconData(0xe763, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">follow_the_signs</i> &#x2014; material icon named "follow the signs outlined".
  static const IconData follow_the_signs_outlined = IconData(0xe1da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">follow_the_signs</i> &#x2014; material icon named "follow the signs rounded".
  static const IconData follow_the_signs_rounded = IconData(0xf209, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">follow_the_signs</i> &#x2014; material icon named "follow the signs sharp".
  static const IconData follow_the_signs_sharp = IconData(0xecdb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">font_download</i> &#x2014; material icon named "font download".
  static const IconData font_download = IconData(0xe764, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">font_download</i> &#x2014; material icon named "font download outlined".
  static const IconData font_download_outlined = IconData(0xe1db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">font_download</i> &#x2014; material icon named "font download rounded".
  static const IconData font_download_rounded = IconData(0xf20a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">font_download</i> &#x2014; material icon named "font download sharp".
  static const IconData font_download_sharp = IconData(0xecdc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">food_bank</i> &#x2014; material icon named "food bank".
  static const IconData food_bank = IconData(0xe765, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">food_bank</i> &#x2014; material icon named "food bank outlined".
  static const IconData food_bank_outlined = IconData(0xe1dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">food_bank</i> &#x2014; material icon named "food bank rounded".
  static const IconData food_bank_rounded = IconData(0xf20b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">food_bank</i> &#x2014; material icon named "food bank sharp".
  static const IconData food_bank_sharp = IconData(0xecdd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_center</i> &#x2014; material icon named "format align center".
  static const IconData format_align_center = IconData(0xe766, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_align_center</i> &#x2014; material icon named "format align center outlined".
  static const IconData format_align_center_outlined = IconData(0xe1dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_align_center</i> &#x2014; material icon named "format align center rounded".
  static const IconData format_align_center_rounded = IconData(0xf20c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_align_center</i> &#x2014; material icon named "format align center sharp".
  static const IconData format_align_center_sharp = IconData(0xecde, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_justify</i> &#x2014; material icon named "format align justify".
  static const IconData format_align_justify = IconData(0xe767, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_align_justify</i> &#x2014; material icon named "format align justify outlined".
  static const IconData format_align_justify_outlined = IconData(0xe1de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_align_justify</i> &#x2014; material icon named "format align justify rounded".
  static const IconData format_align_justify_rounded = IconData(0xf20d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_align_justify</i> &#x2014; material icon named "format align justify sharp".
  static const IconData format_align_justify_sharp = IconData(0xecdf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_left</i> &#x2014; material icon named "format align left".
  static const IconData format_align_left = IconData(0xe768, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_align_left</i> &#x2014; material icon named "format align left outlined".
  static const IconData format_align_left_outlined = IconData(0xe1df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_align_left</i> &#x2014; material icon named "format align left rounded".
  static const IconData format_align_left_rounded = IconData(0xf20e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_align_left</i> &#x2014; material icon named "format align left sharp".
  static const IconData format_align_left_sharp = IconData(0xece0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_right</i> &#x2014; material icon named "format align right".
  static const IconData format_align_right = IconData(0xe769, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_align_right</i> &#x2014; material icon named "format align right outlined".
  static const IconData format_align_right_outlined = IconData(0xe1e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_align_right</i> &#x2014; material icon named "format align right rounded".
  static const IconData format_align_right_rounded = IconData(0xf20f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_align_right</i> &#x2014; material icon named "format align right sharp".
  static const IconData format_align_right_sharp = IconData(0xece1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_bold</i> &#x2014; material icon named "format bold".
  static const IconData format_bold = IconData(0xe76a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_bold</i> &#x2014; material icon named "format bold outlined".
  static const IconData format_bold_outlined = IconData(0xe1e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_bold</i> &#x2014; material icon named "format bold rounded".
  static const IconData format_bold_rounded = IconData(0xf210, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_bold</i> &#x2014; material icon named "format bold sharp".
  static const IconData format_bold_sharp = IconData(0xece2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_clear</i> &#x2014; material icon named "format clear".
  static const IconData format_clear = IconData(0xe76b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_clear</i> &#x2014; material icon named "format clear outlined".
  static const IconData format_clear_outlined = IconData(0xe1e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_clear</i> &#x2014; material icon named "format clear rounded".
  static const IconData format_clear_rounded = IconData(0xf211, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_clear</i> &#x2014; material icon named "format clear sharp".
  static const IconData format_clear_sharp = IconData(0xece3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_color_fill</i> &#x2014; material icon named "format color fill".
  static const IconData format_color_fill = IconData(0xe76c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_color_reset</i> &#x2014; material icon named "format color reset".
  static const IconData format_color_reset = IconData(0xe76d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_color_reset</i> &#x2014; material icon named "format color reset outlined".
  static const IconData format_color_reset_outlined = IconData(0xe1e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_color_reset</i> &#x2014; material icon named "format color reset rounded".
  static const IconData format_color_reset_rounded = IconData(0xf212, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_color_reset</i> &#x2014; material icon named "format color reset sharp".
  static const IconData format_color_reset_sharp = IconData(0xece4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_color_text</i> &#x2014; material icon named "format color text".
  static const IconData format_color_text = IconData(0xe76e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_indent_decrease</i> &#x2014; material icon named "format indent decrease".
  static const IconData format_indent_decrease = IconData(0xe76f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">format_indent_decrease</i> &#x2014; material icon named "format indent decrease outlined".
  static const IconData format_indent_decrease_outlined = IconData(0xe1e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_indent_decrease</i> &#x2014; material icon named "format indent decrease rounded".
  static const IconData format_indent_decrease_rounded = IconData(0xf213, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_indent_decrease</i> &#x2014; material icon named "format indent decrease sharp".
  static const IconData format_indent_decrease_sharp = IconData(0xece5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_indent_increase</i> &#x2014; material icon named "format indent increase".
  static const IconData format_indent_increase = IconData(0xe770, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">format_indent_increase</i> &#x2014; material icon named "format indent increase outlined".
  static const IconData format_indent_increase_outlined = IconData(0xe1e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_indent_increase</i> &#x2014; material icon named "format indent increase rounded".
  static const IconData format_indent_increase_rounded = IconData(0xf214, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_indent_increase</i> &#x2014; material icon named "format indent increase sharp".
  static const IconData format_indent_increase_sharp = IconData(0xece6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_italic</i> &#x2014; material icon named "format italic".
  static const IconData format_italic = IconData(0xe771, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_italic</i> &#x2014; material icon named "format italic outlined".
  static const IconData format_italic_outlined = IconData(0xe1e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_italic</i> &#x2014; material icon named "format italic rounded".
  static const IconData format_italic_rounded = IconData(0xf215, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_italic</i> &#x2014; material icon named "format italic sharp".
  static const IconData format_italic_sharp = IconData(0xece7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_line_spacing</i> &#x2014; material icon named "format line spacing".
  static const IconData format_line_spacing = IconData(0xe772, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_line_spacing</i> &#x2014; material icon named "format line spacing outlined".
  static const IconData format_line_spacing_outlined = IconData(0xe1e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_line_spacing</i> &#x2014; material icon named "format line spacing rounded".
  static const IconData format_line_spacing_rounded = IconData(0xf216, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_line_spacing</i> &#x2014; material icon named "format line spacing sharp".
  static const IconData format_line_spacing_sharp = IconData(0xece8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_list_bulleted</i> &#x2014; material icon named "format list bulleted".
  static const IconData format_list_bulleted = IconData(0xe773, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">format_list_bulleted</i> &#x2014; material icon named "format list bulleted outlined".
  static const IconData format_list_bulleted_outlined = IconData(0xe1e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_list_bulleted</i> &#x2014; material icon named "format list bulleted rounded".
  static const IconData format_list_bulleted_rounded = IconData(0xf217, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_list_bulleted</i> &#x2014; material icon named "format list bulleted sharp".
  static const IconData format_list_bulleted_sharp = IconData(0xece9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_list_numbered</i> &#x2014; material icon named "format list numbered".
  static const IconData format_list_numbered = IconData(0xe774, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_list_numbered</i> &#x2014; material icon named "format list numbered outlined".
  static const IconData format_list_numbered_outlined = IconData(0xe1e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_list_numbered</i> &#x2014; material icon named "format list numbered rounded".
  static const IconData format_list_numbered_rounded = IconData(0xf218, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_list_numbered_rtl</i> &#x2014; material icon named "format list numbered rtl".
  static const IconData format_list_numbered_rtl = IconData(0xe775, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_list_numbered_rtl</i> &#x2014; material icon named "format list numbered rtl outlined".
  static const IconData format_list_numbered_rtl_outlined = IconData(0xe1ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_list_numbered_rtl</i> &#x2014; material icon named "format list numbered rtl rounded".
  static const IconData format_list_numbered_rtl_rounded = IconData(0xf219, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_list_numbered_rtl</i> &#x2014; material icon named "format list numbered rtl sharp".
  static const IconData format_list_numbered_rtl_sharp = IconData(0xecea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_list_numbered</i> &#x2014; material icon named "format list numbered sharp".
  static const IconData format_list_numbered_sharp = IconData(0xeceb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_paint</i> &#x2014; material icon named "format paint".
  static const IconData format_paint = IconData(0xe776, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_paint</i> &#x2014; material icon named "format paint outlined".
  static const IconData format_paint_outlined = IconData(0xe1eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_paint</i> &#x2014; material icon named "format paint rounded".
  static const IconData format_paint_rounded = IconData(0xf21a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_paint</i> &#x2014; material icon named "format paint sharp".
  static const IconData format_paint_sharp = IconData(0xecec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_quote</i> &#x2014; material icon named "format quote".
  static const IconData format_quote = IconData(0xe777, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_quote</i> &#x2014; material icon named "format quote outlined".
  static const IconData format_quote_outlined = IconData(0xe1ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_quote</i> &#x2014; material icon named "format quote rounded".
  static const IconData format_quote_rounded = IconData(0xf21b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_quote</i> &#x2014; material icon named "format quote sharp".
  static const IconData format_quote_sharp = IconData(0xeced, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_shapes</i> &#x2014; material icon named "format shapes".
  static const IconData format_shapes = IconData(0xe778, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_shapes</i> &#x2014; material icon named "format shapes outlined".
  static const IconData format_shapes_outlined = IconData(0xe1ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_shapes</i> &#x2014; material icon named "format shapes rounded".
  static const IconData format_shapes_rounded = IconData(0xf21c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_shapes</i> &#x2014; material icon named "format shapes sharp".
  static const IconData format_shapes_sharp = IconData(0xecee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_size</i> &#x2014; material icon named "format size".
  static const IconData format_size = IconData(0xe779, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_size</i> &#x2014; material icon named "format size outlined".
  static const IconData format_size_outlined = IconData(0xe1ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_size</i> &#x2014; material icon named "format size rounded".
  static const IconData format_size_rounded = IconData(0xf21d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_size</i> &#x2014; material icon named "format size sharp".
  static const IconData format_size_sharp = IconData(0xecef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_strikethrough</i> &#x2014; material icon named "format strikethrough".
  static const IconData format_strikethrough = IconData(0xe77a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_strikethrough</i> &#x2014; material icon named "format strikethrough outlined".
  static const IconData format_strikethrough_outlined = IconData(0xe1ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_strikethrough</i> &#x2014; material icon named "format strikethrough rounded".
  static const IconData format_strikethrough_rounded = IconData(0xf21e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_strikethrough</i> &#x2014; material icon named "format strikethrough sharp".
  static const IconData format_strikethrough_sharp = IconData(0xecf0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_textdirection_l_to_r</i> &#x2014; material icon named "format textdirection l to r".
  static const IconData format_textdirection_l_to_r = IconData(0xe77b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_textdirection_l_to_r</i> &#x2014; material icon named "format textdirection l to r outlined".
  static const IconData format_textdirection_l_to_r_outlined = IconData(0xe1f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_textdirection_l_to_r</i> &#x2014; material icon named "format textdirection l to r rounded".
  static const IconData format_textdirection_l_to_r_rounded = IconData(0xf21f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_textdirection_l_to_r</i> &#x2014; material icon named "format textdirection l to r sharp".
  static const IconData format_textdirection_l_to_r_sharp = IconData(0xecf1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_textdirection_r_to_l</i> &#x2014; material icon named "format textdirection r to l".
  static const IconData format_textdirection_r_to_l = IconData(0xe77c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_textdirection_r_to_l</i> &#x2014; material icon named "format textdirection r to l outlined".
  static const IconData format_textdirection_r_to_l_outlined = IconData(0xe1f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_textdirection_r_to_l</i> &#x2014; material icon named "format textdirection r to l rounded".
  static const IconData format_textdirection_r_to_l_rounded = IconData(0xf220, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_textdirection_r_to_l</i> &#x2014; material icon named "format textdirection r to l sharp".
  static const IconData format_textdirection_r_to_l_sharp = IconData(0xecf2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_underline</i> &#x2014; material icon named "format underline".
  static const IconData format_underline = IconData(0xe77d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_underline</i> &#x2014; material icon named "format underline outlined".
  static const IconData format_underline_outlined = IconData(0xe1f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_underline</i> &#x2014; material icon named "format underline rounded".
  static const IconData format_underline_rounded = IconData(0xf221, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_underline</i> &#x2014; material icon named "format underline sharp".
  static const IconData format_underline_sharp = IconData(0xecf3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_underlined</i> &#x2014; material icon named "format underlined".
  static const IconData format_underlined = IconData(0xe77d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_underlined</i> &#x2014; material icon named "format underlined outlined".
  static const IconData format_underlined_outlined = IconData(0xe1f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_underlined</i> &#x2014; material icon named "format underlined rounded".
  static const IconData format_underlined_rounded = IconData(0xf221, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_underlined</i> &#x2014; material icon named "format underlined sharp".
  static const IconData format_underlined_sharp = IconData(0xecf3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forum</i> &#x2014; material icon named "forum".
  static const IconData forum = IconData(0xe77e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forum</i> &#x2014; material icon named "forum outlined".
  static const IconData forum_outlined = IconData(0xe1f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forum</i> &#x2014; material icon named "forum rounded".
  static const IconData forum_rounded = IconData(0xf222, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forum</i> &#x2014; material icon named "forum sharp".
  static const IconData forum_sharp = IconData(0xecf4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward</i> &#x2014; material icon named "forward".
  static const IconData forward = IconData(0xe77f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">forward_10</i> &#x2014; material icon named "forward 10".
  static const IconData forward_10 = IconData(0xe780, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forward_10</i> &#x2014; material icon named "forward 10 outlined".
  static const IconData forward_10_outlined = IconData(0xe1f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forward_10</i> &#x2014; material icon named "forward 10 rounded".
  static const IconData forward_10_rounded = IconData(0xf223, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forward_10</i> &#x2014; material icon named "forward 10 sharp".
  static const IconData forward_10_sharp = IconData(0xecf5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward_30</i> &#x2014; material icon named "forward 30".
  static const IconData forward_30 = IconData(0xe781, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forward_30</i> &#x2014; material icon named "forward 30 outlined".
  static const IconData forward_30_outlined = IconData(0xe1f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forward_30</i> &#x2014; material icon named "forward 30 rounded".
  static const IconData forward_30_rounded = IconData(0xf224, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forward_30</i> &#x2014; material icon named "forward 30 sharp".
  static const IconData forward_30_sharp = IconData(0xecf6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward_5</i> &#x2014; material icon named "forward 5".
  static const IconData forward_5 = IconData(0xe782, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forward_5</i> &#x2014; material icon named "forward 5 outlined".
  static const IconData forward_5_outlined = IconData(0xe1f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forward_5</i> &#x2014; material icon named "forward 5 rounded".
  static const IconData forward_5_rounded = IconData(0xf225, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forward_5</i> &#x2014; material icon named "forward 5 sharp".
  static const IconData forward_5_sharp = IconData(0xecf7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forward</i> &#x2014; material icon named "forward outlined".
  static const IconData forward_outlined = IconData(0xe1f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forward</i> &#x2014; material icon named "forward rounded".
  static const IconData forward_rounded = IconData(0xf226, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forward</i> &#x2014; material icon named "forward sharp".
  static const IconData forward_sharp = IconData(0xecf8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward_to_inbox</i> &#x2014; material icon named "forward to inbox".
  static const IconData forward_to_inbox = IconData(0xe783, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forward_to_inbox</i> &#x2014; material icon named "forward to inbox outlined".
  static const IconData forward_to_inbox_outlined = IconData(0xe1f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forward_to_inbox</i> &#x2014; material icon named "forward to inbox rounded".
  static const IconData forward_to_inbox_rounded = IconData(0xf227, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forward_to_inbox</i> &#x2014; material icon named "forward to inbox sharp".
  static const IconData forward_to_inbox_sharp = IconData(0xecf9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">foundation</i> &#x2014; material icon named "foundation".
  static const IconData foundation = IconData(0xe784, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">foundation</i> &#x2014; material icon named "foundation outlined".
  static const IconData foundation_outlined = IconData(0xe1f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">foundation</i> &#x2014; material icon named "foundation rounded".
  static const IconData foundation_rounded = IconData(0xf228, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">foundation</i> &#x2014; material icon named "foundation sharp".
  static const IconData foundation_sharp = IconData(0xecfa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">free_breakfast</i> &#x2014; material icon named "free breakfast".
  static const IconData free_breakfast = IconData(0xe785, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">free_breakfast</i> &#x2014; material icon named "free breakfast outlined".
  static const IconData free_breakfast_outlined = IconData(0xe1fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">free_breakfast</i> &#x2014; material icon named "free breakfast rounded".
  static const IconData free_breakfast_rounded = IconData(0xf229, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">free_breakfast</i> &#x2014; material icon named "free breakfast sharp".
  static const IconData free_breakfast_sharp = IconData(0xecfb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fullscreen</i> &#x2014; material icon named "fullscreen".
  static const IconData fullscreen = IconData(0xe786, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fullscreen_exit</i> &#x2014; material icon named "fullscreen exit".
  static const IconData fullscreen_exit = IconData(0xe787, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fullscreen_exit</i> &#x2014; material icon named "fullscreen exit outlined".
  static const IconData fullscreen_exit_outlined = IconData(0xe1fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fullscreen_exit</i> &#x2014; material icon named "fullscreen exit rounded".
  static const IconData fullscreen_exit_rounded = IconData(0xf22a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fullscreen_exit</i> &#x2014; material icon named "fullscreen exit sharp".
  static const IconData fullscreen_exit_sharp = IconData(0xecfc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fullscreen</i> &#x2014; material icon named "fullscreen outlined".
  static const IconData fullscreen_outlined = IconData(0xe1fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fullscreen</i> &#x2014; material icon named "fullscreen rounded".
  static const IconData fullscreen_rounded = IconData(0xf22b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fullscreen</i> &#x2014; material icon named "fullscreen sharp".
  static const IconData fullscreen_sharp = IconData(0xecfd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">functions</i> &#x2014; material icon named "functions".
  static const IconData functions = IconData(0xe788, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">functions</i> &#x2014; material icon named "functions outlined".
  static const IconData functions_outlined = IconData(0xe1fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">functions</i> &#x2014; material icon named "functions rounded".
  static const IconData functions_rounded = IconData(0xf22c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">functions</i> &#x2014; material icon named "functions sharp".
  static const IconData functions_sharp = IconData(0xecfe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">g_translate</i> &#x2014; material icon named "g translate".
  static const IconData g_translate = IconData(0xe789, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">g_translate</i> &#x2014; material icon named "g translate outlined".
  static const IconData g_translate_outlined = IconData(0xe1fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">g_translate</i> &#x2014; material icon named "g translate rounded".
  static const IconData g_translate_rounded = IconData(0xf22d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">g_translate</i> &#x2014; material icon named "g translate sharp".
  static const IconData g_translate_sharp = IconData(0xecff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gamepad</i> &#x2014; material icon named "gamepad".
  static const IconData gamepad = IconData(0xe78a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gamepad</i> &#x2014; material icon named "gamepad outlined".
  static const IconData gamepad_outlined = IconData(0xe1ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gamepad</i> &#x2014; material icon named "gamepad rounded".
  static const IconData gamepad_rounded = IconData(0xf22e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gamepad</i> &#x2014; material icon named "gamepad sharp".
  static const IconData gamepad_sharp = IconData(0xed00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">games</i> &#x2014; material icon named "games".
  static const IconData games = IconData(0xe78b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">games</i> &#x2014; material icon named "games outlined".
  static const IconData games_outlined = IconData(0xe200, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">games</i> &#x2014; material icon named "games rounded".
  static const IconData games_rounded = IconData(0xf22f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">games</i> &#x2014; material icon named "games sharp".
  static const IconData games_sharp = IconData(0xed01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gavel</i> &#x2014; material icon named "gavel".
  static const IconData gavel = IconData(0xe78c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gavel</i> &#x2014; material icon named "gavel outlined".
  static const IconData gavel_outlined = IconData(0xe201, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gavel</i> &#x2014; material icon named "gavel rounded".
  static const IconData gavel_rounded = IconData(0xf230, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gavel</i> &#x2014; material icon named "gavel sharp".
  static const IconData gavel_sharp = IconData(0xed02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gesture</i> &#x2014; material icon named "gesture".
  static const IconData gesture = IconData(0xe78d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gesture</i> &#x2014; material icon named "gesture outlined".
  static const IconData gesture_outlined = IconData(0xe202, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gesture</i> &#x2014; material icon named "gesture rounded".
  static const IconData gesture_rounded = IconData(0xf231, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gesture</i> &#x2014; material icon named "gesture sharp".
  static const IconData gesture_sharp = IconData(0xed03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">get_app</i> &#x2014; material icon named "get app".
  static const IconData get_app = IconData(0xe78e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">get_app</i> &#x2014; material icon named "get app outlined".
  static const IconData get_app_outlined = IconData(0xe203, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">get_app</i> &#x2014; material icon named "get app rounded".
  static const IconData get_app_rounded = IconData(0xf232, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">get_app</i> &#x2014; material icon named "get app sharp".
  static const IconData get_app_sharp = IconData(0xed04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gif</i> &#x2014; material icon named "gif".
  static const IconData gif = IconData(0xe78f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gif</i> &#x2014; material icon named "gif outlined".
  static const IconData gif_outlined = IconData(0xe204, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gif</i> &#x2014; material icon named "gif rounded".
  static const IconData gif_rounded = IconData(0xf233, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gif</i> &#x2014; material icon named "gif sharp".
  static const IconData gif_sharp = IconData(0xed05, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">golf_course</i> &#x2014; material icon named "golf course".
  static const IconData golf_course = IconData(0xe790, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">golf_course</i> &#x2014; material icon named "golf course outlined".
  static const IconData golf_course_outlined = IconData(0xe205, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">golf_course</i> &#x2014; material icon named "golf course rounded".
  static const IconData golf_course_rounded = IconData(0xf234, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">golf_course</i> &#x2014; material icon named "golf course sharp".
  static const IconData golf_course_sharp = IconData(0xed06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gps_fixed</i> &#x2014; material icon named "gps fixed".
  static const IconData gps_fixed = IconData(0xe791, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gps_fixed</i> &#x2014; material icon named "gps fixed outlined".
  static const IconData gps_fixed_outlined = IconData(0xe206, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gps_fixed</i> &#x2014; material icon named "gps fixed rounded".
  static const IconData gps_fixed_rounded = IconData(0xf235, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gps_fixed</i> &#x2014; material icon named "gps fixed sharp".
  static const IconData gps_fixed_sharp = IconData(0xed07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gps_not_fixed</i> &#x2014; material icon named "gps not fixed".
  static const IconData gps_not_fixed = IconData(0xe792, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gps_not_fixed</i> &#x2014; material icon named "gps not fixed outlined".
  static const IconData gps_not_fixed_outlined = IconData(0xe207, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gps_not_fixed</i> &#x2014; material icon named "gps not fixed rounded".
  static const IconData gps_not_fixed_rounded = IconData(0xf236, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gps_not_fixed</i> &#x2014; material icon named "gps not fixed sharp".
  static const IconData gps_not_fixed_sharp = IconData(0xed08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gps_off</i> &#x2014; material icon named "gps off".
  static const IconData gps_off = IconData(0xe793, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gps_off</i> &#x2014; material icon named "gps off outlined".
  static const IconData gps_off_outlined = IconData(0xe208, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gps_off</i> &#x2014; material icon named "gps off rounded".
  static const IconData gps_off_rounded = IconData(0xf237, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gps_off</i> &#x2014; material icon named "gps off sharp".
  static const IconData gps_off_sharp = IconData(0xed09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grade</i> &#x2014; material icon named "grade".
  static const IconData grade = IconData(0xe794, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grade</i> &#x2014; material icon named "grade outlined".
  static const IconData grade_outlined = IconData(0xe209, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grade</i> &#x2014; material icon named "grade rounded".
  static const IconData grade_rounded = IconData(0xf238, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grade</i> &#x2014; material icon named "grade sharp".
  static const IconData grade_sharp = IconData(0xed0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gradient</i> &#x2014; material icon named "gradient".
  static const IconData gradient = IconData(0xe795, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gradient</i> &#x2014; material icon named "gradient outlined".
  static const IconData gradient_outlined = IconData(0xe20a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gradient</i> &#x2014; material icon named "gradient rounded".
  static const IconData gradient_rounded = IconData(0xf239, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gradient</i> &#x2014; material icon named "gradient sharp".
  static const IconData gradient_sharp = IconData(0xed0b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grading</i> &#x2014; material icon named "grading".
  static const IconData grading = IconData(0xe796, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grading</i> &#x2014; material icon named "grading outlined".
  static const IconData grading_outlined = IconData(0xe20b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grading</i> &#x2014; material icon named "grading rounded".
  static const IconData grading_rounded = IconData(0xf23a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grading</i> &#x2014; material icon named "grading sharp".
  static const IconData grading_sharp = IconData(0xed0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grain</i> &#x2014; material icon named "grain".
  static const IconData grain = IconData(0xe797, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grain</i> &#x2014; material icon named "grain outlined".
  static const IconData grain_outlined = IconData(0xe20c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grain</i> &#x2014; material icon named "grain rounded".
  static const IconData grain_rounded = IconData(0xf23b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grain</i> &#x2014; material icon named "grain sharp".
  static const IconData grain_sharp = IconData(0xed0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">graphic_eq</i> &#x2014; material icon named "graphic eq".
  static const IconData graphic_eq = IconData(0xe798, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">graphic_eq</i> &#x2014; material icon named "graphic eq outlined".
  static const IconData graphic_eq_outlined = IconData(0xe20d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">graphic_eq</i> &#x2014; material icon named "graphic eq rounded".
  static const IconData graphic_eq_rounded = IconData(0xf23c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">graphic_eq</i> &#x2014; material icon named "graphic eq sharp".
  static const IconData graphic_eq_sharp = IconData(0xed0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grass</i> &#x2014; material icon named "grass".
  static const IconData grass = IconData(0xe799, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grass</i> &#x2014; material icon named "grass outlined".
  static const IconData grass_outlined = IconData(0xe20e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grass</i> &#x2014; material icon named "grass rounded".
  static const IconData grass_rounded = IconData(0xf23d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grass</i> &#x2014; material icon named "grass sharp".
  static const IconData grass_sharp = IconData(0xed0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_off</i> &#x2014; material icon named "grid off".
  static const IconData grid_off = IconData(0xe79a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grid_off</i> &#x2014; material icon named "grid off outlined".
  static const IconData grid_off_outlined = IconData(0xe20f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grid_off</i> &#x2014; material icon named "grid off rounded".
  static const IconData grid_off_rounded = IconData(0xf23e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grid_off</i> &#x2014; material icon named "grid off sharp".
  static const IconData grid_off_sharp = IconData(0xed10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_on</i> &#x2014; material icon named "grid on".
  static const IconData grid_on = IconData(0xe79b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grid_on</i> &#x2014; material icon named "grid on outlined".
  static const IconData grid_on_outlined = IconData(0xe210, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grid_on</i> &#x2014; material icon named "grid on rounded".
  static const IconData grid_on_rounded = IconData(0xf23f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grid_on</i> &#x2014; material icon named "grid on sharp".
  static const IconData grid_on_sharp = IconData(0xed11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_view</i> &#x2014; material icon named "grid view".
  static const IconData grid_view = IconData(0xe79c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">group</i> &#x2014; material icon named "group".
  static const IconData group = IconData(0xe79d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">group_add</i> &#x2014; material icon named "group add".
  static const IconData group_add = IconData(0xe79e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">group_add</i> &#x2014; material icon named "group add outlined".
  static const IconData group_add_outlined = IconData(0xe211, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">group_add</i> &#x2014; material icon named "group add rounded".
  static const IconData group_add_rounded = IconData(0xf240, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">group_add</i> &#x2014; material icon named "group add sharp".
  static const IconData group_add_sharp = IconData(0xed12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">group</i> &#x2014; material icon named "group outlined".
  static const IconData group_outlined = IconData(0xe212, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">group</i> &#x2014; material icon named "group rounded".
  static const IconData group_rounded = IconData(0xf241, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">group</i> &#x2014; material icon named "group sharp".
  static const IconData group_sharp = IconData(0xed13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">group_work</i> &#x2014; material icon named "group work".
  static const IconData group_work = IconData(0xe79f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">group_work</i> &#x2014; material icon named "group work outlined".
  static const IconData group_work_outlined = IconData(0xe213, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">group_work</i> &#x2014; material icon named "group work rounded".
  static const IconData group_work_rounded = IconData(0xf242, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">group_work</i> &#x2014; material icon named "group work sharp".
  static const IconData group_work_sharp = IconData(0xed14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hail</i> &#x2014; material icon named "hail".
  static const IconData hail = IconData(0xe7a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">handyman</i> &#x2014; material icon named "handyman".
  static const IconData handyman = IconData(0xe7a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">handyman</i> &#x2014; material icon named "handyman outlined".
  static const IconData handyman_outlined = IconData(0xe214, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">handyman</i> &#x2014; material icon named "handyman rounded".
  static const IconData handyman_rounded = IconData(0xf243, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">handyman</i> &#x2014; material icon named "handyman sharp".
  static const IconData handyman_sharp = IconData(0xed15, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hardware</i> &#x2014; material icon named "hardware".
  static const IconData hardware = IconData(0xe7a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hd</i> &#x2014; material icon named "hd".
  static const IconData hd = IconData(0xe7a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hd</i> &#x2014; material icon named "hd outlined".
  static const IconData hd_outlined = IconData(0xe215, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hd</i> &#x2014; material icon named "hd rounded".
  static const IconData hd_rounded = IconData(0xf244, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hd</i> &#x2014; material icon named "hd sharp".
  static const IconData hd_sharp = IconData(0xed16, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_enhanced_select</i> &#x2014; material icon named "hdr enhanced select".
  static const IconData hdr_enhanced_select = IconData(0xe7a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_off</i> &#x2014; material icon named "hdr off".
  static const IconData hdr_off = IconData(0xe7a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_off</i> &#x2014; material icon named "hdr off outlined".
  static const IconData hdr_off_outlined = IconData(0xe216, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_off</i> &#x2014; material icon named "hdr off rounded".
  static const IconData hdr_off_rounded = IconData(0xf245, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_off</i> &#x2014; material icon named "hdr off sharp".
  static const IconData hdr_off_sharp = IconData(0xed17, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_on</i> &#x2014; material icon named "hdr on".
  static const IconData hdr_on = IconData(0xe7a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_on</i> &#x2014; material icon named "hdr on outlined".
  static const IconData hdr_on_outlined = IconData(0xe217, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_on</i> &#x2014; material icon named "hdr on rounded".
  static const IconData hdr_on_rounded = IconData(0xf246, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_on</i> &#x2014; material icon named "hdr on sharp".
  static const IconData hdr_on_sharp = IconData(0xed18, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_strong</i> &#x2014; material icon named "hdr strong".
  static const IconData hdr_strong = IconData(0xe7a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_strong</i> &#x2014; material icon named "hdr strong outlined".
  static const IconData hdr_strong_outlined = IconData(0xe218, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_strong</i> &#x2014; material icon named "hdr strong rounded".
  static const IconData hdr_strong_rounded = IconData(0xf247, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_strong</i> &#x2014; material icon named "hdr strong sharp".
  static const IconData hdr_strong_sharp = IconData(0xed19, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_weak</i> &#x2014; material icon named "hdr weak".
  static const IconData hdr_weak = IconData(0xe7a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_weak</i> &#x2014; material icon named "hdr weak outlined".
  static const IconData hdr_weak_outlined = IconData(0xe219, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_weak</i> &#x2014; material icon named "hdr weak rounded".
  static const IconData hdr_weak_rounded = IconData(0xf248, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_weak</i> &#x2014; material icon named "hdr weak sharp".
  static const IconData hdr_weak_sharp = IconData(0xed1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headset</i> &#x2014; material icon named "headset".
  static const IconData headset = IconData(0xe7a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headset_mic</i> &#x2014; material icon named "headset mic".
  static const IconData headset_mic = IconData(0xe7aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">headset_mic</i> &#x2014; material icon named "headset mic outlined".
  static const IconData headset_mic_outlined = IconData(0xe21a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">headset_mic</i> &#x2014; material icon named "headset mic rounded".
  static const IconData headset_mic_rounded = IconData(0xf249, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">headset_mic</i> &#x2014; material icon named "headset mic sharp".
  static const IconData headset_mic_sharp = IconData(0xed1b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headset_off</i> &#x2014; material icon named "headset off".
  static const IconData headset_off = IconData(0xe7ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">headset</i> &#x2014; material icon named "headset outlined".
  static const IconData headset_outlined = IconData(0xe21b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">headset</i> &#x2014; material icon named "headset rounded".
  static const IconData headset_rounded = IconData(0xf24a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">headset</i> &#x2014; material icon named "headset sharp".
  static const IconData headset_sharp = IconData(0xed1c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">healing</i> &#x2014; material icon named "healing".
  static const IconData healing = IconData(0xe7ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">healing</i> &#x2014; material icon named "healing outlined".
  static const IconData healing_outlined = IconData(0xe21c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">healing</i> &#x2014; material icon named "healing rounded".
  static const IconData healing_rounded = IconData(0xf24b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">healing</i> &#x2014; material icon named "healing sharp".
  static const IconData healing_sharp = IconData(0xed1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hearing</i> &#x2014; material icon named "hearing".
  static const IconData hearing = IconData(0xe7ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hearing_disabled</i> &#x2014; material icon named "hearing disabled".
  static const IconData hearing_disabled = IconData(0xe7ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hearing_disabled</i> &#x2014; material icon named "hearing disabled outlined".
  static const IconData hearing_disabled_outlined = IconData(0xe21d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hearing_disabled</i> &#x2014; material icon named "hearing disabled rounded".
  static const IconData hearing_disabled_rounded = IconData(0xf24c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hearing_disabled</i> &#x2014; material icon named "hearing disabled sharp".
  static const IconData hearing_disabled_sharp = IconData(0xed1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hearing</i> &#x2014; material icon named "hearing outlined".
  static const IconData hearing_outlined = IconData(0xe21e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hearing</i> &#x2014; material icon named "hearing rounded".
  static const IconData hearing_rounded = IconData(0xf24d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hearing</i> &#x2014; material icon named "hearing sharp".
  static const IconData hearing_sharp = IconData(0xed1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">height</i> &#x2014; material icon named "height".
  static const IconData height = IconData(0xe7af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">height</i> &#x2014; material icon named "height outlined".
  static const IconData height_outlined = IconData(0xe21f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">height</i> &#x2014; material icon named "height rounded".
  static const IconData height_rounded = IconData(0xf24e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">height</i> &#x2014; material icon named "height sharp".
  static const IconData height_sharp = IconData(0xed20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">help</i> &#x2014; material icon named "help".
  static const IconData help = IconData(0xe7b0, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">help_center</i> &#x2014; material icon named "help center".
  static const IconData help_center = IconData(0xe7b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">help_center</i> &#x2014; material icon named "help center outlined".
  static const IconData help_center_outlined = IconData(0xe220, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">help_center</i> &#x2014; material icon named "help center rounded".
  static const IconData help_center_rounded = IconData(0xf24f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">help_center</i> &#x2014; material icon named "help center sharp".
  static const IconData help_center_sharp = IconData(0xed21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">help_outline</i> &#x2014; material icon named "help outline".
  static const IconData help_outline = IconData(0xe7b2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">help_outline</i> &#x2014; material icon named "help outline outlined".
  static const IconData help_outline_outlined = IconData(0xe221, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">help_outline</i> &#x2014; material icon named "help outline rounded".
  static const IconData help_outline_rounded = IconData(0xf250, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">help_outline</i> &#x2014; material icon named "help outline sharp".
  static const IconData help_outline_sharp = IconData(0xed22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">help</i> &#x2014; material icon named "help outlined".
  static const IconData help_outlined = IconData(0xe222, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">help</i> &#x2014; material icon named "help rounded".
  static const IconData help_rounded = IconData(0xf251, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">help</i> &#x2014; material icon named "help sharp".
  static const IconData help_sharp = IconData(0xed23, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">high_quality</i> &#x2014; material icon named "high quality".
  static const IconData high_quality = IconData(0xe7b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">high_quality</i> &#x2014; material icon named "high quality outlined".
  static const IconData high_quality_outlined = IconData(0xe223, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">high_quality</i> &#x2014; material icon named "high quality rounded".
  static const IconData high_quality_rounded = IconData(0xf252, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">high_quality</i> &#x2014; material icon named "high quality sharp".
  static const IconData high_quality_sharp = IconData(0xed24, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight</i> &#x2014; material icon named "highlight".
  static const IconData highlight = IconData(0xe7b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight_alt</i> &#x2014; material icon named "highlight alt".
  static const IconData highlight_alt = IconData(0xe7b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">highlight_alt</i> &#x2014; material icon named "highlight alt outlined".
  static const IconData highlight_alt_outlined = IconData(0xe224, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">highlight_alt</i> &#x2014; material icon named "highlight alt rounded".
  static const IconData highlight_alt_rounded = IconData(0xf253, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">highlight_alt</i> &#x2014; material icon named "highlight alt sharp".
  static const IconData highlight_alt_sharp = IconData(0xed25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight_off</i> &#x2014; material icon named "highlight off".
  static const IconData highlight_off = IconData(0xe7b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">highlight_off</i> &#x2014; material icon named "highlight off outlined".
  static const IconData highlight_off_outlined = IconData(0xe225, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">highlight_off</i> &#x2014; material icon named "highlight off rounded".
  static const IconData highlight_off_rounded = IconData(0xf254, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">highlight_off</i> &#x2014; material icon named "highlight off sharp".
  static const IconData highlight_off_sharp = IconData(0xed26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">highlight</i> &#x2014; material icon named "highlight outlined".
  static const IconData highlight_outlined = IconData(0xe226, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight_remove</i> &#x2014; material icon named "highlight remove".
  static const IconData highlight_remove = IconData(0xe7b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">highlight_remove</i> &#x2014; material icon named "highlight remove outlined".
  static const IconData highlight_remove_outlined = IconData(0xe225, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">highlight_remove</i> &#x2014; material icon named "highlight remove rounded".
  static const IconData highlight_remove_rounded = IconData(0xf254, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">highlight_remove</i> &#x2014; material icon named "highlight remove sharp".
  static const IconData highlight_remove_sharp = IconData(0xed26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">highlight</i> &#x2014; material icon named "highlight rounded".
  static const IconData highlight_rounded = IconData(0xf255, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">highlight</i> &#x2014; material icon named "highlight sharp".
  static const IconData highlight_sharp = IconData(0xed27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">history</i> &#x2014; material icon named "history".
  static const IconData history = IconData(0xe7b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">history_edu</i> &#x2014; material icon named "history edu".
  static const IconData history_edu = IconData(0xe7b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">history_edu</i> &#x2014; material icon named "history edu outlined".
  static const IconData history_edu_outlined = IconData(0xe227, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">history_edu</i> &#x2014; material icon named "history edu rounded".
  static const IconData history_edu_rounded = IconData(0xf256, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">history_edu</i> &#x2014; material icon named "history edu sharp".
  static const IconData history_edu_sharp = IconData(0xed28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">history</i> &#x2014; material icon named "history outlined".
  static const IconData history_outlined = IconData(0xe228, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">history</i> &#x2014; material icon named "history rounded".
  static const IconData history_rounded = IconData(0xf257, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">history</i> &#x2014; material icon named "history sharp".
  static const IconData history_sharp = IconData(0xed29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">history_toggle_off</i> &#x2014; material icon named "history toggle off".
  static const IconData history_toggle_off = IconData(0xe7b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">history_toggle_off</i> &#x2014; material icon named "history toggle off outlined".
  static const IconData history_toggle_off_outlined = IconData(0xe229, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">history_toggle_off</i> &#x2014; material icon named "history toggle off rounded".
  static const IconData history_toggle_off_rounded = IconData(0xf258, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">history_toggle_off</i> &#x2014; material icon named "history toggle off sharp".
  static const IconData history_toggle_off_sharp = IconData(0xed2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home</i> &#x2014; material icon named "home".
  static const IconData home = IconData(0xe7ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home_filled</i> &#x2014; material icon named "home filled".
  static const IconData home_filled = IconData(0xe7bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">home</i> &#x2014; material icon named "home outlined".
  static const IconData home_outlined = IconData(0xe22a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home_repair_service</i> &#x2014; material icon named "home repair service".
  static const IconData home_repair_service = IconData(0xe7bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">home_repair_service</i> &#x2014; material icon named "home repair service outlined".
  static const IconData home_repair_service_outlined = IconData(0xe22b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">home_repair_service</i> &#x2014; material icon named "home repair service rounded".
  static const IconData home_repair_service_rounded = IconData(0xf259, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">home_repair_service</i> &#x2014; material icon named "home repair service sharp".
  static const IconData home_repair_service_sharp = IconData(0xed2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">home</i> &#x2014; material icon named "home rounded".
  static const IconData home_rounded = IconData(0xf25a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">home</i> &#x2014; material icon named "home sharp".
  static const IconData home_sharp = IconData(0xed2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home_work</i> &#x2014; material icon named "home work".
  static const IconData home_work = IconData(0xe7bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">home_work</i> &#x2014; material icon named "home work outlined".
  static const IconData home_work_outlined = IconData(0xe22c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">home_work</i> &#x2014; material icon named "home work rounded".
  static const IconData home_work_rounded = IconData(0xf25b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">home_work</i> &#x2014; material icon named "home work sharp".
  static const IconData home_work_sharp = IconData(0xed2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">horizontal_rule</i> &#x2014; material icon named "horizontal rule".
  static const IconData horizontal_rule = IconData(0xe7be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">horizontal_rule</i> &#x2014; material icon named "horizontal rule outlined".
  static const IconData horizontal_rule_outlined = IconData(0xe22d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">horizontal_rule</i> &#x2014; material icon named "horizontal rule rounded".
  static const IconData horizontal_rule_rounded = IconData(0xf25c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">horizontal_rule</i> &#x2014; material icon named "horizontal rule sharp".
  static const IconData horizontal_rule_sharp = IconData(0xed2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">horizontal_split</i> &#x2014; material icon named "horizontal split".
  static const IconData horizontal_split = IconData(0xe7bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">horizontal_split</i> &#x2014; material icon named "horizontal split outlined".
  static const IconData horizontal_split_outlined = IconData(0xe22e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">horizontal_split</i> &#x2014; material icon named "horizontal split rounded".
  static const IconData horizontal_split_rounded = IconData(0xf25d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">horizontal_split</i> &#x2014; material icon named "horizontal split sharp".
  static const IconData horizontal_split_sharp = IconData(0xed2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hot_tub</i> &#x2014; material icon named "hot tub".
  static const IconData hot_tub = IconData(0xe7c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hot_tub</i> &#x2014; material icon named "hot tub outlined".
  static const IconData hot_tub_outlined = IconData(0xe22f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hot_tub</i> &#x2014; material icon named "hot tub rounded".
  static const IconData hot_tub_rounded = IconData(0xf25e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hot_tub</i> &#x2014; material icon named "hot tub sharp".
  static const IconData hot_tub_sharp = IconData(0xed30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hotel</i> &#x2014; material icon named "hotel".
  static const IconData hotel = IconData(0xe7c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hotel</i> &#x2014; material icon named "hotel outlined".
  static const IconData hotel_outlined = IconData(0xe230, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hotel</i> &#x2014; material icon named "hotel rounded".
  static const IconData hotel_rounded = IconData(0xf25f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hotel</i> &#x2014; material icon named "hotel sharp".
  static const IconData hotel_sharp = IconData(0xed31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_bottom</i> &#x2014; material icon named "hourglass bottom".
  static const IconData hourglass_bottom = IconData(0xe7c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_bottom</i> &#x2014; material icon named "hourglass bottom outlined".
  static const IconData hourglass_bottom_outlined = IconData(0xe231, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_bottom</i> &#x2014; material icon named "hourglass bottom rounded".
  static const IconData hourglass_bottom_rounded = IconData(0xf260, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_bottom</i> &#x2014; material icon named "hourglass bottom sharp".
  static const IconData hourglass_bottom_sharp = IconData(0xed32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_disabled</i> &#x2014; material icon named "hourglass disabled".
  static const IconData hourglass_disabled = IconData(0xe7c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_disabled</i> &#x2014; material icon named "hourglass disabled outlined".
  static const IconData hourglass_disabled_outlined = IconData(0xe232, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_disabled</i> &#x2014; material icon named "hourglass disabled rounded".
  static const IconData hourglass_disabled_rounded = IconData(0xf261, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_disabled</i> &#x2014; material icon named "hourglass disabled sharp".
  static const IconData hourglass_disabled_sharp = IconData(0xed33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_empty</i> &#x2014; material icon named "hourglass empty".
  static const IconData hourglass_empty = IconData(0xe7c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_empty</i> &#x2014; material icon named "hourglass empty outlined".
  static const IconData hourglass_empty_outlined = IconData(0xe233, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_empty</i> &#x2014; material icon named "hourglass empty rounded".
  static const IconData hourglass_empty_rounded = IconData(0xf262, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_empty</i> &#x2014; material icon named "hourglass empty sharp".
  static const IconData hourglass_empty_sharp = IconData(0xed34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_full</i> &#x2014; material icon named "hourglass full".
  static const IconData hourglass_full = IconData(0xe7c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_full</i> &#x2014; material icon named "hourglass full outlined".
  static const IconData hourglass_full_outlined = IconData(0xe234, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_full</i> &#x2014; material icon named "hourglass full rounded".
  static const IconData hourglass_full_rounded = IconData(0xf263, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_full</i> &#x2014; material icon named "hourglass full sharp".
  static const IconData hourglass_full_sharp = IconData(0xed35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_top</i> &#x2014; material icon named "hourglass top".
  static const IconData hourglass_top = IconData(0xe7c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_top</i> &#x2014; material icon named "hourglass top outlined".
  static const IconData hourglass_top_outlined = IconData(0xe235, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_top</i> &#x2014; material icon named "hourglass top rounded".
  static const IconData hourglass_top_rounded = IconData(0xf264, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_top</i> &#x2014; material icon named "hourglass top sharp".
  static const IconData hourglass_top_sharp = IconData(0xed36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">house</i> &#x2014; material icon named "house".
  static const IconData house = IconData(0xe7c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">house</i> &#x2014; material icon named "house outlined".
  static const IconData house_outlined = IconData(0xe236, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">house</i> &#x2014; material icon named "house rounded".
  static const IconData house_rounded = IconData(0xf265, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">house</i> &#x2014; material icon named "house sharp".
  static const IconData house_sharp = IconData(0xed37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">house_siding</i> &#x2014; material icon named "house siding".
  static const IconData house_siding = IconData(0xe7c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">house_siding</i> &#x2014; material icon named "house siding outlined".
  static const IconData house_siding_outlined = IconData(0xe237, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">house_siding</i> &#x2014; material icon named "house siding rounded".
  static const IconData house_siding_rounded = IconData(0xf266, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">house_siding</i> &#x2014; material icon named "house siding sharp".
  static const IconData house_siding_sharp = IconData(0xed38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">how_to_reg</i> &#x2014; material icon named "how to reg".
  static const IconData how_to_reg = IconData(0xe7c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">how_to_reg</i> &#x2014; material icon named "how to reg outlined".
  static const IconData how_to_reg_outlined = IconData(0xe238, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">how_to_reg</i> &#x2014; material icon named "how to reg rounded".
  static const IconData how_to_reg_rounded = IconData(0xf267, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">how_to_reg</i> &#x2014; material icon named "how to reg sharp".
  static const IconData how_to_reg_sharp = IconData(0xed39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">how_to_vote</i> &#x2014; material icon named "how to vote".
  static const IconData how_to_vote = IconData(0xe7ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">how_to_vote</i> &#x2014; material icon named "how to vote outlined".
  static const IconData how_to_vote_outlined = IconData(0xe239, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">how_to_vote</i> &#x2014; material icon named "how to vote rounded".
  static const IconData how_to_vote_rounded = IconData(0xf268, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">how_to_vote</i> &#x2014; material icon named "how to vote sharp".
  static const IconData how_to_vote_sharp = IconData(0xed3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">http</i> &#x2014; material icon named "http".
  static const IconData http = IconData(0xe7cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">http</i> &#x2014; material icon named "http outlined".
  static const IconData http_outlined = IconData(0xe23a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">http</i> &#x2014; material icon named "http rounded".
  static const IconData http_rounded = IconData(0xf269, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">http</i> &#x2014; material icon named "http sharp".
  static const IconData http_sharp = IconData(0xed3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">https</i> &#x2014; material icon named "https".
  static const IconData https = IconData(0xe7cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">https</i> &#x2014; material icon named "https outlined".
  static const IconData https_outlined = IconData(0xe23b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">https</i> &#x2014; material icon named "https rounded".
  static const IconData https_rounded = IconData(0xf26a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">https</i> &#x2014; material icon named "https sharp".
  static const IconData https_sharp = IconData(0xed3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hvac</i> &#x2014; material icon named "hvac".
  static const IconData hvac = IconData(0xe7cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hvac</i> &#x2014; material icon named "hvac outlined".
  static const IconData hvac_outlined = IconData(0xe23c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hvac</i> &#x2014; material icon named "hvac rounded".
  static const IconData hvac_rounded = IconData(0xf26b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hvac</i> &#x2014; material icon named "hvac sharp".
  static const IconData hvac_sharp = IconData(0xed3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">icecream</i> &#x2014; material icon named "icecream".
  static const IconData icecream = IconData(0xe7ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image</i> &#x2014; material icon named "image".
  static const IconData image = IconData(0xe7cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image_aspect_ratio</i> &#x2014; material icon named "image aspect ratio".
  static const IconData image_aspect_ratio = IconData(0xe7d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">image_aspect_ratio</i> &#x2014; material icon named "image aspect ratio outlined".
  static const IconData image_aspect_ratio_outlined = IconData(0xe23d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">image_aspect_ratio</i> &#x2014; material icon named "image aspect ratio rounded".
  static const IconData image_aspect_ratio_rounded = IconData(0xf26c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">image_aspect_ratio</i> &#x2014; material icon named "image aspect ratio sharp".
  static const IconData image_aspect_ratio_sharp = IconData(0xed3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image_not_supported</i> &#x2014; material icon named "image not supported".
  static const IconData image_not_supported = IconData(0xe7d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">image_not_supported</i> &#x2014; material icon named "image not supported outlined".
  static const IconData image_not_supported_outlined = IconData(0xe23e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">image_not_supported</i> &#x2014; material icon named "image not supported rounded".
  static const IconData image_not_supported_rounded = IconData(0xf26d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">image_not_supported</i> &#x2014; material icon named "image not supported sharp".
  static const IconData image_not_supported_sharp = IconData(0xed3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">image</i> &#x2014; material icon named "image outlined".
  static const IconData image_outlined = IconData(0xe23f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">image</i> &#x2014; material icon named "image rounded".
  static const IconData image_rounded = IconData(0xf26e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image_search</i> &#x2014; material icon named "image search".
  static const IconData image_search = IconData(0xe7d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">image_search</i> &#x2014; material icon named "image search outlined".
  static const IconData image_search_outlined = IconData(0xe240, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">image_search</i> &#x2014; material icon named "image search rounded".
  static const IconData image_search_rounded = IconData(0xf26f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">image_search</i> &#x2014; material icon named "image search sharp".
  static const IconData image_search_sharp = IconData(0xed40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">image</i> &#x2014; material icon named "image sharp".
  static const IconData image_sharp = IconData(0xed41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">imagesearch_roller</i> &#x2014; material icon named "imagesearch roller".
  static const IconData imagesearch_roller = IconData(0xe7d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">import_contacts</i> &#x2014; material icon named "import contacts".
  static const IconData import_contacts = IconData(0xe7d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">import_contacts</i> &#x2014; material icon named "import contacts outlined".
  static const IconData import_contacts_outlined = IconData(0xe241, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">import_contacts</i> &#x2014; material icon named "import contacts rounded".
  static const IconData import_contacts_rounded = IconData(0xf270, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">import_contacts</i> &#x2014; material icon named "import contacts sharp".
  static const IconData import_contacts_sharp = IconData(0xed42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">import_export</i> &#x2014; material icon named "import export".
  static const IconData import_export = IconData(0xe7d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">import_export</i> &#x2014; material icon named "import export outlined".
  static const IconData import_export_outlined = IconData(0xe242, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">import_export</i> &#x2014; material icon named "import export rounded".
  static const IconData import_export_rounded = IconData(0xf271, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">import_export</i> &#x2014; material icon named "import export sharp".
  static const IconData import_export_sharp = IconData(0xed43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">important_devices</i> &#x2014; material icon named "important devices".
  static const IconData important_devices = IconData(0xe7d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">important_devices</i> &#x2014; material icon named "important devices outlined".
  static const IconData important_devices_outlined = IconData(0xe243, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">important_devices</i> &#x2014; material icon named "important devices rounded".
  static const IconData important_devices_rounded = IconData(0xf272, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">important_devices</i> &#x2014; material icon named "important devices sharp".
  static const IconData important_devices_sharp = IconData(0xed44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">inbox</i> &#x2014; material icon named "inbox".
  static const IconData inbox = IconData(0xe7d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">inbox</i> &#x2014; material icon named "inbox outlined".
  static const IconData inbox_outlined = IconData(0xe244, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">inbox</i> &#x2014; material icon named "inbox rounded".
  static const IconData inbox_rounded = IconData(0xf273, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">inbox</i> &#x2014; material icon named "inbox sharp".
  static const IconData inbox_sharp = IconData(0xed45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">indeterminate_check_box</i> &#x2014; material icon named "indeterminate check box".
  static const IconData indeterminate_check_box = IconData(0xe7d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">indeterminate_check_box</i> &#x2014; material icon named "indeterminate check box outlined".
  static const IconData indeterminate_check_box_outlined = IconData(0xe245, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">indeterminate_check_box</i> &#x2014; material icon named "indeterminate check box rounded".
  static const IconData indeterminate_check_box_rounded = IconData(0xf274, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">indeterminate_check_box</i> &#x2014; material icon named "indeterminate check box sharp".
  static const IconData indeterminate_check_box_sharp = IconData(0xed46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">info</i> &#x2014; material icon named "info".
  static const IconData info = IconData(0xe7d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">info_outline</i> &#x2014; material icon named "info outline".
  static const IconData info_outline = IconData(0xe7da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">info_outline</i> &#x2014; material icon named "info outline rounded".
  static const IconData info_outline_rounded = IconData(0xf275, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">info_outline</i> &#x2014; material icon named "info outline sharp".
  static const IconData info_outline_sharp = IconData(0xed47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">info</i> &#x2014; material icon named "info outlined".
  static const IconData info_outlined = IconData(0xe246, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">info</i> &#x2014; material icon named "info rounded".
  static const IconData info_rounded = IconData(0xf276, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">info</i> &#x2014; material icon named "info sharp".
  static const IconData info_sharp = IconData(0xed48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">input</i> &#x2014; material icon named "input".
  static const IconData input = IconData(0xe7db, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">input</i> &#x2014; material icon named "input outlined".
  static const IconData input_outlined = IconData(0xe247, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">input</i> &#x2014; material icon named "input rounded".
  static const IconData input_rounded = IconData(0xf277, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">input</i> &#x2014; material icon named "input sharp".
  static const IconData input_sharp = IconData(0xed49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_chart</i> &#x2014; material icon named "insert chart".
  static const IconData insert_chart = IconData(0xe7dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_chart_outlined</i> &#x2014; material icon named "insert chart outlined".
  static const IconData insert_chart_outlined = IconData(0xe248, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_chart</i> &#x2014; material icon named "insert chart outlined outlined".
  static const IconData insert_chart_outlined_outlined = IconData(0xe249, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_chart_outlined</i> &#x2014; material icon named "insert chart outlined rounded".
  static const IconData insert_chart_outlined_rounded = IconData(0xf278, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_chart_outlined</i> &#x2014; material icon named "insert chart outlined sharp".
  static const IconData insert_chart_outlined_sharp = IconData(0xed4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_chart</i> &#x2014; material icon named "insert chart rounded".
  static const IconData insert_chart_rounded = IconData(0xf279, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_chart</i> &#x2014; material icon named "insert chart sharp".
  static const IconData insert_chart_sharp = IconData(0xed4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_comment</i> &#x2014; material icon named "insert comment".
  static const IconData insert_comment = IconData(0xe7de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_comment</i> &#x2014; material icon named "insert comment outlined".
  static const IconData insert_comment_outlined = IconData(0xe24a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_comment</i> &#x2014; material icon named "insert comment rounded".
  static const IconData insert_comment_rounded = IconData(0xf27a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_comment</i> &#x2014; material icon named "insert comment sharp".
  static const IconData insert_comment_sharp = IconData(0xed4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_drive_file</i> &#x2014; material icon named "insert drive file".
  static const IconData insert_drive_file = IconData(0xe7df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_drive_file</i> &#x2014; material icon named "insert drive file outlined".
  static const IconData insert_drive_file_outlined = IconData(0xe24b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_drive_file</i> &#x2014; material icon named "insert drive file rounded".
  static const IconData insert_drive_file_rounded = IconData(0xf27b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_drive_file</i> &#x2014; material icon named "insert drive file sharp".
  static const IconData insert_drive_file_sharp = IconData(0xed4d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_emoticon</i> &#x2014; material icon named "insert emoticon".
  static const IconData insert_emoticon = IconData(0xe7e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_emoticon</i> &#x2014; material icon named "insert emoticon outlined".
  static const IconData insert_emoticon_outlined = IconData(0xe24c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_emoticon</i> &#x2014; material icon named "insert emoticon rounded".
  static const IconData insert_emoticon_rounded = IconData(0xf27c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_emoticon</i> &#x2014; material icon named "insert emoticon sharp".
  static const IconData insert_emoticon_sharp = IconData(0xed4e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_invitation</i> &#x2014; material icon named "insert invitation".
  static const IconData insert_invitation = IconData(0xe7e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_invitation</i> &#x2014; material icon named "insert invitation outlined".
  static const IconData insert_invitation_outlined = IconData(0xe24d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_invitation</i> &#x2014; material icon named "insert invitation rounded".
  static const IconData insert_invitation_rounded = IconData(0xf27d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_invitation</i> &#x2014; material icon named "insert invitation sharp".
  static const IconData insert_invitation_sharp = IconData(0xed4f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_link</i> &#x2014; material icon named "insert link".
  static const IconData insert_link = IconData(0xe7e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_link</i> &#x2014; material icon named "insert link outlined".
  static const IconData insert_link_outlined = IconData(0xe24e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_link</i> &#x2014; material icon named "insert link rounded".
  static const IconData insert_link_rounded = IconData(0xf27e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_link</i> &#x2014; material icon named "insert link sharp".
  static const IconData insert_link_sharp = IconData(0xed50, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_photo</i> &#x2014; material icon named "insert photo".
  static const IconData insert_photo = IconData(0xe7e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_photo</i> &#x2014; material icon named "insert photo outlined".
  static const IconData insert_photo_outlined = IconData(0xe24f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_photo</i> &#x2014; material icon named "insert photo rounded".
  static const IconData insert_photo_rounded = IconData(0xf27f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_photo</i> &#x2014; material icon named "insert photo sharp".
  static const IconData insert_photo_sharp = IconData(0xed51, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insights</i> &#x2014; material icon named "insights".
  static const IconData insights = IconData(0xe7e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insights</i> &#x2014; material icon named "insights outlined".
  static const IconData insights_outlined = IconData(0xe250, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insights</i> &#x2014; material icon named "insights rounded".
  static const IconData insights_rounded = IconData(0xf280, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insights</i> &#x2014; material icon named "insights sharp".
  static const IconData insights_sharp = IconData(0xed52, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">integration_instructions</i> &#x2014; material icon named "integration instructions".
  static const IconData integration_instructions = IconData(0xe7e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">integration_instructions</i> &#x2014; material icon named "integration instructions outlined".
  static const IconData integration_instructions_outlined = IconData(0xe251, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">integration_instructions</i> &#x2014; material icon named "integration instructions rounded".
  static const IconData integration_instructions_rounded = IconData(0xf281, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">integration_instructions</i> &#x2014; material icon named "integration instructions sharp".
  static const IconData integration_instructions_sharp = IconData(0xed53, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">inventory</i> &#x2014; material icon named "inventory".
  static const IconData inventory = IconData(0xe7e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">invert_colors</i> &#x2014; material icon named "invert colors".
  static const IconData invert_colors = IconData(0xe7e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">invert_colors_off</i> &#x2014; material icon named "invert colors off".
  static const IconData invert_colors_off = IconData(0xe7e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">invert_colors_off</i> &#x2014; material icon named "invert colors off outlined".
  static const IconData invert_colors_off_outlined = IconData(0xe252, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">invert_colors_off</i> &#x2014; material icon named "invert colors off rounded".
  static const IconData invert_colors_off_rounded = IconData(0xf282, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">invert_colors_off</i> &#x2014; material icon named "invert colors off sharp".
  static const IconData invert_colors_off_sharp = IconData(0xed54, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">invert_colors_on</i> &#x2014; material icon named "invert colors on".
  static const IconData invert_colors_on = IconData(0xe7e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">invert_colors_on</i> &#x2014; material icon named "invert colors on outlined".
  static const IconData invert_colors_on_outlined = IconData(0xe253, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">invert_colors_on</i> &#x2014; material icon named "invert colors on rounded".
  static const IconData invert_colors_on_rounded = IconData(0xf283, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">invert_colors_on</i> &#x2014; material icon named "invert colors on sharp".
  static const IconData invert_colors_on_sharp = IconData(0xed55, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">invert_colors</i> &#x2014; material icon named "invert colors outlined".
  static const IconData invert_colors_outlined = IconData(0xe253, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">invert_colors</i> &#x2014; material icon named "invert colors rounded".
  static const IconData invert_colors_rounded = IconData(0xf283, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">invert_colors</i> &#x2014; material icon named "invert colors sharp".
  static const IconData invert_colors_sharp = IconData(0xed55, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ios_share</i> &#x2014; material icon named "ios share".
  static const IconData ios_share = IconData(0xe7e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">iso</i> &#x2014; material icon named "iso".
  static const IconData iso = IconData(0xe7ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">iso</i> &#x2014; material icon named "iso outlined".
  static const IconData iso_outlined = IconData(0xe254, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">iso</i> &#x2014; material icon named "iso rounded".
  static const IconData iso_rounded = IconData(0xf284, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">iso</i> &#x2014; material icon named "iso sharp".
  static const IconData iso_sharp = IconData(0xed56, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard</i> &#x2014; material icon named "keyboard".
  static const IconData keyboard = IconData(0xe7eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_down</i> &#x2014; material icon named "keyboard arrow down".
  static const IconData keyboard_arrow_down = IconData(0xe7ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_arrow_down</i> &#x2014; material icon named "keyboard arrow down outlined".
  static const IconData keyboard_arrow_down_outlined = IconData(0xe255, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_arrow_down</i> &#x2014; material icon named "keyboard arrow down rounded".
  static const IconData keyboard_arrow_down_rounded = IconData(0xf285, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_arrow_down</i> &#x2014; material icon named "keyboard arrow down sharp".
  static const IconData keyboard_arrow_down_sharp = IconData(0xed57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_left</i> &#x2014; material icon named "keyboard arrow left".
  static const IconData keyboard_arrow_left = IconData(0xe7ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_arrow_left</i> &#x2014; material icon named "keyboard arrow left outlined".
  static const IconData keyboard_arrow_left_outlined = IconData(0xe256, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_arrow_left</i> &#x2014; material icon named "keyboard arrow left rounded".
  static const IconData keyboard_arrow_left_rounded = IconData(0xf286, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_arrow_left</i> &#x2014; material icon named "keyboard arrow left sharp".
  static const IconData keyboard_arrow_left_sharp = IconData(0xed58, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_right</i> &#x2014; material icon named "keyboard arrow right".
  static const IconData keyboard_arrow_right = IconData(0xe7ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_arrow_right</i> &#x2014; material icon named "keyboard arrow right outlined".
  static const IconData keyboard_arrow_right_outlined = IconData(0xe257, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_arrow_right</i> &#x2014; material icon named "keyboard arrow right rounded".
  static const IconData keyboard_arrow_right_rounded = IconData(0xf287, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_arrow_right</i> &#x2014; material icon named "keyboard arrow right sharp".
  static const IconData keyboard_arrow_right_sharp = IconData(0xed59, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_up</i> &#x2014; material icon named "keyboard arrow up".
  static const IconData keyboard_arrow_up = IconData(0xe7ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_arrow_up</i> &#x2014; material icon named "keyboard arrow up outlined".
  static const IconData keyboard_arrow_up_outlined = IconData(0xe258, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_arrow_up</i> &#x2014; material icon named "keyboard arrow up rounded".
  static const IconData keyboard_arrow_up_rounded = IconData(0xf288, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_arrow_up</i> &#x2014; material icon named "keyboard arrow up sharp".
  static const IconData keyboard_arrow_up_sharp = IconData(0xed5a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_backspace</i> &#x2014; material icon named "keyboard backspace".
  static const IconData keyboard_backspace = IconData(0xe7f0, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">keyboard_backspace</i> &#x2014; material icon named "keyboard backspace outlined".
  static const IconData keyboard_backspace_outlined = IconData(0xe259, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_backspace</i> &#x2014; material icon named "keyboard backspace rounded".
  static const IconData keyboard_backspace_rounded = IconData(0xf289, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_backspace</i> &#x2014; material icon named "keyboard backspace sharp".
  static const IconData keyboard_backspace_sharp = IconData(0xed5b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_capslock</i> &#x2014; material icon named "keyboard capslock".
  static const IconData keyboard_capslock = IconData(0xe7f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_capslock</i> &#x2014; material icon named "keyboard capslock outlined".
  static const IconData keyboard_capslock_outlined = IconData(0xe25a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_capslock</i> &#x2014; material icon named "keyboard capslock rounded".
  static const IconData keyboard_capslock_rounded = IconData(0xf28a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_capslock</i> &#x2014; material icon named "keyboard capslock sharp".
  static const IconData keyboard_capslock_sharp = IconData(0xed5c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_control</i> &#x2014; material icon named "keyboard control".
  static const IconData keyboard_control = IconData(0xe886, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_control</i> &#x2014; material icon named "keyboard control outlined".
  static const IconData keyboard_control_outlined = IconData(0xe2e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_control</i> &#x2014; material icon named "keyboard control rounded".
  static const IconData keyboard_control_rounded = IconData(0xf315, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_control</i> &#x2014; material icon named "keyboard control sharp".
  static const IconData keyboard_control_sharp = IconData(0xede7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_hide</i> &#x2014; material icon named "keyboard hide".
  static const IconData keyboard_hide = IconData(0xe7f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_hide</i> &#x2014; material icon named "keyboard hide outlined".
  static const IconData keyboard_hide_outlined = IconData(0xe25b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_hide</i> &#x2014; material icon named "keyboard hide rounded".
  static const IconData keyboard_hide_rounded = IconData(0xf28b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_hide</i> &#x2014; material icon named "keyboard hide sharp".
  static const IconData keyboard_hide_sharp = IconData(0xed5d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard</i> &#x2014; material icon named "keyboard outlined".
  static const IconData keyboard_outlined = IconData(0xe25c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_return</i> &#x2014; material icon named "keyboard return".
  static const IconData keyboard_return = IconData(0xe7f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_return</i> &#x2014; material icon named "keyboard return outlined".
  static const IconData keyboard_return_outlined = IconData(0xe25d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_return</i> &#x2014; material icon named "keyboard return rounded".
  static const IconData keyboard_return_rounded = IconData(0xf28c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_return</i> &#x2014; material icon named "keyboard return sharp".
  static const IconData keyboard_return_sharp = IconData(0xed5e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard</i> &#x2014; material icon named "keyboard rounded".
  static const IconData keyboard_rounded = IconData(0xf28d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard</i> &#x2014; material icon named "keyboard sharp".
  static const IconData keyboard_sharp = IconData(0xed5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_tab</i> &#x2014; material icon named "keyboard tab".
  static const IconData keyboard_tab = IconData(0xe7f4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">keyboard_tab</i> &#x2014; material icon named "keyboard tab outlined".
  static const IconData keyboard_tab_outlined = IconData(0xe25e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_tab</i> &#x2014; material icon named "keyboard tab rounded".
  static const IconData keyboard_tab_rounded = IconData(0xf28e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_tab</i> &#x2014; material icon named "keyboard tab sharp".
  static const IconData keyboard_tab_sharp = IconData(0xed60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_voice</i> &#x2014; material icon named "keyboard voice".
  static const IconData keyboard_voice = IconData(0xe7f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_voice</i> &#x2014; material icon named "keyboard voice outlined".
  static const IconData keyboard_voice_outlined = IconData(0xe25f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_voice</i> &#x2014; material icon named "keyboard voice rounded".
  static const IconData keyboard_voice_rounded = IconData(0xf28f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_voice</i> &#x2014; material icon named "keyboard voice sharp".
  static const IconData keyboard_voice_sharp = IconData(0xed61, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">king_bed</i> &#x2014; material icon named "king bed".
  static const IconData king_bed = IconData(0xe7f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">king_bed</i> &#x2014; material icon named "king bed outlined".
  static const IconData king_bed_outlined = IconData(0xe260, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">king_bed</i> &#x2014; material icon named "king bed rounded".
  static const IconData king_bed_rounded = IconData(0xf290, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">king_bed</i> &#x2014; material icon named "king bed sharp".
  static const IconData king_bed_sharp = IconData(0xed62, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">kitchen</i> &#x2014; material icon named "kitchen".
  static const IconData kitchen = IconData(0xe7f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">kitchen</i> &#x2014; material icon named "kitchen outlined".
  static const IconData kitchen_outlined = IconData(0xe261, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">kitchen</i> &#x2014; material icon named "kitchen rounded".
  static const IconData kitchen_rounded = IconData(0xf291, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">kitchen</i> &#x2014; material icon named "kitchen sharp".
  static const IconData kitchen_sharp = IconData(0xed63, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">label</i> &#x2014; material icon named "label".
  static const IconData label = IconData(0xe7f8, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">label_important</i> &#x2014; material icon named "label important".
  static const IconData label_important = IconData(0xe7f9, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">label_important_outline</i> &#x2014; material icon named "label important outline".
  static const IconData label_important_outline = IconData(0xe7fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">label_important_outline</i> &#x2014; material icon named "label important outline rounded".
  static const IconData label_important_outline_rounded = IconData(0xf292, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">label_important_outline</i> &#x2014; material icon named "label important outline sharp".
  static const IconData label_important_outline_sharp = IconData(0xed64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">label_important</i> &#x2014; material icon named "label important outlined".
  static const IconData label_important_outlined = IconData(0xe262, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">label_important</i> &#x2014; material icon named "label important rounded".
  static const IconData label_important_rounded = IconData(0xf293, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">label_important</i> &#x2014; material icon named "label important sharp".
  static const IconData label_important_sharp = IconData(0xed65, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">label_off</i> &#x2014; material icon named "label off".
  static const IconData label_off = IconData(0xe7fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">label_off</i> &#x2014; material icon named "label off outlined".
  static const IconData label_off_outlined = IconData(0xe263, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">label_off</i> &#x2014; material icon named "label off rounded".
  static const IconData label_off_rounded = IconData(0xf294, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">label_off</i> &#x2014; material icon named "label off sharp".
  static const IconData label_off_sharp = IconData(0xed66, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">label_outline</i> &#x2014; material icon named "label outline".
  static const IconData label_outline = IconData(0xe7fc, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">label_outline</i> &#x2014; material icon named "label outline rounded".
  static const IconData label_outline_rounded = IconData(0xf295, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">label_outline</i> &#x2014; material icon named "label outline sharp".
  static const IconData label_outline_sharp = IconData(0xed67, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">label</i> &#x2014; material icon named "label outlined".
  static const IconData label_outlined = IconData(0xe264, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">label</i> &#x2014; material icon named "label rounded".
  static const IconData label_rounded = IconData(0xf296, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">label</i> &#x2014; material icon named "label sharp".
  static const IconData label_sharp = IconData(0xed68, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">landscape</i> &#x2014; material icon named "landscape".
  static const IconData landscape = IconData(0xe7fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">landscape</i> &#x2014; material icon named "landscape outlined".
  static const IconData landscape_outlined = IconData(0xe265, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">landscape</i> &#x2014; material icon named "landscape rounded".
  static const IconData landscape_rounded = IconData(0xf297, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">landscape</i> &#x2014; material icon named "landscape sharp".
  static const IconData landscape_sharp = IconData(0xed69, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">language</i> &#x2014; material icon named "language".
  static const IconData language = IconData(0xe7fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">language</i> &#x2014; material icon named "language outlined".
  static const IconData language_outlined = IconData(0xe266, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">language</i> &#x2014; material icon named "language rounded".
  static const IconData language_rounded = IconData(0xf298, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">language</i> &#x2014; material icon named "language sharp".
  static const IconData language_sharp = IconData(0xed6a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop</i> &#x2014; material icon named "laptop".
  static const IconData laptop = IconData(0xe7ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop_chromebook</i> &#x2014; material icon named "laptop chromebook".
  static const IconData laptop_chromebook = IconData(0xe800, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">laptop_chromebook</i> &#x2014; material icon named "laptop chromebook outlined".
  static const IconData laptop_chromebook_outlined = IconData(0xe267, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">laptop_chromebook</i> &#x2014; material icon named "laptop chromebook rounded".
  static const IconData laptop_chromebook_rounded = IconData(0xf299, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">laptop_chromebook</i> &#x2014; material icon named "laptop chromebook sharp".
  static const IconData laptop_chromebook_sharp = IconData(0xed6b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop_mac</i> &#x2014; material icon named "laptop mac".
  static const IconData laptop_mac = IconData(0xe801, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">laptop_mac</i> &#x2014; material icon named "laptop mac outlined".
  static const IconData laptop_mac_outlined = IconData(0xe268, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">laptop_mac</i> &#x2014; material icon named "laptop mac rounded".
  static const IconData laptop_mac_rounded = IconData(0xf29a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">laptop_mac</i> &#x2014; material icon named "laptop mac sharp".
  static const IconData laptop_mac_sharp = IconData(0xed6c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">laptop</i> &#x2014; material icon named "laptop outlined".
  static const IconData laptop_outlined = IconData(0xe269, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">laptop</i> &#x2014; material icon named "laptop rounded".
  static const IconData laptop_rounded = IconData(0xf29b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">laptop</i> &#x2014; material icon named "laptop sharp".
  static const IconData laptop_sharp = IconData(0xed6d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop_windows</i> &#x2014; material icon named "laptop windows".
  static const IconData laptop_windows = IconData(0xe802, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">laptop_windows</i> &#x2014; material icon named "laptop windows outlined".
  static const IconData laptop_windows_outlined = IconData(0xe26a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">laptop_windows</i> &#x2014; material icon named "laptop windows rounded".
  static const IconData laptop_windows_rounded = IconData(0xf29c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">laptop_windows</i> &#x2014; material icon named "laptop windows sharp".
  static const IconData laptop_windows_sharp = IconData(0xed6e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">last_page</i> &#x2014; material icon named "last page".
  static const IconData last_page = IconData(0xe803, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">last_page</i> &#x2014; material icon named "last page outlined".
  static const IconData last_page_outlined = IconData(0xe26b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">last_page</i> &#x2014; material icon named "last page rounded".
  static const IconData last_page_rounded = IconData(0xf29d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">last_page</i> &#x2014; material icon named "last page sharp".
  static const IconData last_page_sharp = IconData(0xed6f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">launch</i> &#x2014; material icon named "launch".
  static const IconData launch = IconData(0xe804, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">launch</i> &#x2014; material icon named "launch outlined".
  static const IconData launch_outlined = IconData(0xe26c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">launch</i> &#x2014; material icon named "launch rounded".
  static const IconData launch_rounded = IconData(0xf29e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">launch</i> &#x2014; material icon named "launch sharp".
  static const IconData launch_sharp = IconData(0xed70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">layers</i> &#x2014; material icon named "layers".
  static const IconData layers = IconData(0xe805, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">layers_clear</i> &#x2014; material icon named "layers clear".
  static const IconData layers_clear = IconData(0xe806, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">layers_clear</i> &#x2014; material icon named "layers clear outlined".
  static const IconData layers_clear_outlined = IconData(0xe26d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">layers_clear</i> &#x2014; material icon named "layers clear rounded".
  static const IconData layers_clear_rounded = IconData(0xf29f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">layers_clear</i> &#x2014; material icon named "layers clear sharp".
  static const IconData layers_clear_sharp = IconData(0xed71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">layers</i> &#x2014; material icon named "layers outlined".
  static const IconData layers_outlined = IconData(0xe26e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">layers</i> &#x2014; material icon named "layers rounded".
  static const IconData layers_rounded = IconData(0xf2a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">layers</i> &#x2014; material icon named "layers sharp".
  static const IconData layers_sharp = IconData(0xed72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leaderboard</i> &#x2014; material icon named "leaderboard".
  static const IconData leaderboard = IconData(0xe807, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">leaderboard</i> &#x2014; material icon named "leaderboard outlined".
  static const IconData leaderboard_outlined = IconData(0xe26f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">leaderboard</i> &#x2014; material icon named "leaderboard rounded".
  static const IconData leaderboard_rounded = IconData(0xf2a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">leaderboard</i> &#x2014; material icon named "leaderboard sharp".
  static const IconData leaderboard_sharp = IconData(0xed73, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leak_add</i> &#x2014; material icon named "leak add".
  static const IconData leak_add = IconData(0xe808, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">leak_add</i> &#x2014; material icon named "leak add outlined".
  static const IconData leak_add_outlined = IconData(0xe270, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">leak_add</i> &#x2014; material icon named "leak add rounded".
  static const IconData leak_add_rounded = IconData(0xf2a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">leak_add</i> &#x2014; material icon named "leak add sharp".
  static const IconData leak_add_sharp = IconData(0xed74, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leak_remove</i> &#x2014; material icon named "leak remove".
  static const IconData leak_remove = IconData(0xe809, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">leak_remove</i> &#x2014; material icon named "leak remove outlined".
  static const IconData leak_remove_outlined = IconData(0xe271, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">leak_remove</i> &#x2014; material icon named "leak remove rounded".
  static const IconData leak_remove_rounded = IconData(0xf2a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">leak_remove</i> &#x2014; material icon named "leak remove sharp".
  static const IconData leak_remove_sharp = IconData(0xed75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leave_bags_at_home</i> &#x2014; material icon named "leave bags at home".
  static const IconData leave_bags_at_home = IconData(0xe80a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">leave_bags_at_home</i> &#x2014; material icon named "leave bags at home outlined".
  static const IconData leave_bags_at_home_outlined = IconData(0xe272, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">leave_bags_at_home</i> &#x2014; material icon named "leave bags at home rounded".
  static const IconData leave_bags_at_home_rounded = IconData(0xf2a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">leave_bags_at_home</i> &#x2014; material icon named "leave bags at home sharp".
  static const IconData leave_bags_at_home_sharp = IconData(0xed76, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">legend_toggle</i> &#x2014; material icon named "legend toggle".
  static const IconData legend_toggle = IconData(0xe80b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">legend_toggle</i> &#x2014; material icon named "legend toggle outlined".
  static const IconData legend_toggle_outlined = IconData(0xe273, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">legend_toggle</i> &#x2014; material icon named "legend toggle rounded".
  static const IconData legend_toggle_rounded = IconData(0xf2a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">legend_toggle</i> &#x2014; material icon named "legend toggle sharp".
  static const IconData legend_toggle_sharp = IconData(0xed77, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lens</i> &#x2014; material icon named "lens".
  static const IconData lens = IconData(0xe80c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lens</i> &#x2014; material icon named "lens outlined".
  static const IconData lens_outlined = IconData(0xe274, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lens</i> &#x2014; material icon named "lens rounded".
  static const IconData lens_rounded = IconData(0xf2a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lens</i> &#x2014; material icon named "lens sharp".
  static const IconData lens_sharp = IconData(0xed78, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_add</i> &#x2014; material icon named "library add".
  static const IconData library_add = IconData(0xe80d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_add_check</i> &#x2014; material icon named "library add check".
  static const IconData library_add_check = IconData(0xe80e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">library_add_check</i> &#x2014; material icon named "library add check outlined".
  static const IconData library_add_check_outlined = IconData(0xe275, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">library_add_check</i> &#x2014; material icon named "library add check rounded".
  static const IconData library_add_check_rounded = IconData(0xf2a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">library_add_check</i> &#x2014; material icon named "library add check sharp".
  static const IconData library_add_check_sharp = IconData(0xed79, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">library_add</i> &#x2014; material icon named "library add outlined".
  static const IconData library_add_outlined = IconData(0xe276, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">library_add</i> &#x2014; material icon named "library add rounded".
  static const IconData library_add_rounded = IconData(0xf2a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">library_add</i> &#x2014; material icon named "library add sharp".
  static const IconData library_add_sharp = IconData(0xed7a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_books</i> &#x2014; material icon named "library books".
  static const IconData library_books = IconData(0xe80f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">library_books</i> &#x2014; material icon named "library books outlined".
  static const IconData library_books_outlined = IconData(0xe277, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">library_books</i> &#x2014; material icon named "library books rounded".
  static const IconData library_books_rounded = IconData(0xf2a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">library_books</i> &#x2014; material icon named "library books sharp".
  static const IconData library_books_sharp = IconData(0xed7b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_music</i> &#x2014; material icon named "library music".
  static const IconData library_music = IconData(0xe810, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">library_music</i> &#x2014; material icon named "library music outlined".
  static const IconData library_music_outlined = IconData(0xe278, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">library_music</i> &#x2014; material icon named "library music rounded".
  static const IconData library_music_rounded = IconData(0xf2aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">library_music</i> &#x2014; material icon named "library music sharp".
  static const IconData library_music_sharp = IconData(0xed7c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lightbulb</i> &#x2014; material icon named "lightbulb".
  static const IconData lightbulb = IconData(0xe811, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lightbulb_outline</i> &#x2014; material icon named "lightbulb outline".
  static const IconData lightbulb_outline = IconData(0xe812, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lightbulb_outline</i> &#x2014; material icon named "lightbulb outline rounded".
  static const IconData lightbulb_outline_rounded = IconData(0xf2ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lightbulb_outline</i> &#x2014; material icon named "lightbulb outline sharp".
  static const IconData lightbulb_outline_sharp = IconData(0xed7d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lightbulb</i> &#x2014; material icon named "lightbulb outlined".
  static const IconData lightbulb_outlined = IconData(0xe279, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">line_style</i> &#x2014; material icon named "line style".
  static const IconData line_style = IconData(0xe813, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">line_style</i> &#x2014; material icon named "line style outlined".
  static const IconData line_style_outlined = IconData(0xe27a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">line_style</i> &#x2014; material icon named "line style rounded".
  static const IconData line_style_rounded = IconData(0xf2ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">line_style</i> &#x2014; material icon named "line style sharp".
  static const IconData line_style_sharp = IconData(0xed7e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">line_weight</i> &#x2014; material icon named "line weight".
  static const IconData line_weight = IconData(0xe814, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">line_weight</i> &#x2014; material icon named "line weight outlined".
  static const IconData line_weight_outlined = IconData(0xe27b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">line_weight</i> &#x2014; material icon named "line weight rounded".
  static const IconData line_weight_rounded = IconData(0xf2ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">line_weight</i> &#x2014; material icon named "line weight sharp".
  static const IconData line_weight_sharp = IconData(0xed7f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">linear_scale</i> &#x2014; material icon named "linear scale".
  static const IconData linear_scale = IconData(0xe815, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">linear_scale</i> &#x2014; material icon named "linear scale outlined".
  static const IconData linear_scale_outlined = IconData(0xe27c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">linear_scale</i> &#x2014; material icon named "linear scale rounded".
  static const IconData linear_scale_rounded = IconData(0xf2ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">linear_scale</i> &#x2014; material icon named "linear scale sharp".
  static const IconData linear_scale_sharp = IconData(0xed80, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">link</i> &#x2014; material icon named "link".
  static const IconData link = IconData(0xe816, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">link_off</i> &#x2014; material icon named "link off".
  static const IconData link_off = IconData(0xe817, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">link_off</i> &#x2014; material icon named "link off outlined".
  static const IconData link_off_outlined = IconData(0xe27d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">link_off</i> &#x2014; material icon named "link off rounded".
  static const IconData link_off_rounded = IconData(0xf2af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">link_off</i> &#x2014; material icon named "link off sharp".
  static const IconData link_off_sharp = IconData(0xed81, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">link</i> &#x2014; material icon named "link outlined".
  static const IconData link_outlined = IconData(0xe27e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">link</i> &#x2014; material icon named "link rounded".
  static const IconData link_rounded = IconData(0xf2b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">link</i> &#x2014; material icon named "link sharp".
  static const IconData link_sharp = IconData(0xed82, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">linked_camera</i> &#x2014; material icon named "linked camera".
  static const IconData linked_camera = IconData(0xe818, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">linked_camera</i> &#x2014; material icon named "linked camera outlined".
  static const IconData linked_camera_outlined = IconData(0xe27f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">linked_camera</i> &#x2014; material icon named "linked camera rounded".
  static const IconData linked_camera_rounded = IconData(0xf2b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">linked_camera</i> &#x2014; material icon named "linked camera sharp".
  static const IconData linked_camera_sharp = IconData(0xed83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">liquor</i> &#x2014; material icon named "liquor".
  static const IconData liquor = IconData(0xe819, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">list</i> &#x2014; material icon named "list".
  static const IconData list = IconData(0xe81a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">list_alt</i> &#x2014; material icon named "list alt".
  static const IconData list_alt = IconData(0xe81b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">list_alt</i> &#x2014; material icon named "list alt outlined".
  static const IconData list_alt_outlined = IconData(0xe280, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">list_alt</i> &#x2014; material icon named "list alt rounded".
  static const IconData list_alt_rounded = IconData(0xf2b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">list_alt</i> &#x2014; material icon named "list alt sharp".
  static const IconData list_alt_sharp = IconData(0xed84, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">list</i> &#x2014; material icon named "list outlined".
  static const IconData list_outlined = IconData(0xe281, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">list</i> &#x2014; material icon named "list rounded".
  static const IconData list_rounded = IconData(0xf2b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">list</i> &#x2014; material icon named "list sharp".
  static const IconData list_sharp = IconData(0xed85, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">live_help</i> &#x2014; material icon named "live help".
  static const IconData live_help = IconData(0xe81c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">live_help</i> &#x2014; material icon named "live help outlined".
  static const IconData live_help_outlined = IconData(0xe282, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">live_help</i> &#x2014; material icon named "live help rounded".
  static const IconData live_help_rounded = IconData(0xf2b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">live_help</i> &#x2014; material icon named "live help sharp".
  static const IconData live_help_sharp = IconData(0xed86, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">live_tv</i> &#x2014; material icon named "live tv".
  static const IconData live_tv = IconData(0xe81d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">live_tv</i> &#x2014; material icon named "live tv outlined".
  static const IconData live_tv_outlined = IconData(0xe283, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">live_tv</i> &#x2014; material icon named "live tv rounded".
  static const IconData live_tv_rounded = IconData(0xf2b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">live_tv</i> &#x2014; material icon named "live tv sharp".
  static const IconData live_tv_sharp = IconData(0xed87, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_activity</i> &#x2014; material icon named "local activity".
  static const IconData local_activity = IconData(0xe81e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_activity</i> &#x2014; material icon named "local activity outlined".
  static const IconData local_activity_outlined = IconData(0xe284, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_activity</i> &#x2014; material icon named "local activity rounded".
  static const IconData local_activity_rounded = IconData(0xf2b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_activity</i> &#x2014; material icon named "local activity sharp".
  static const IconData local_activity_sharp = IconData(0xed88, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_airport</i> &#x2014; material icon named "local airport".
  static const IconData local_airport = IconData(0xe81f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_airport</i> &#x2014; material icon named "local airport outlined".
  static const IconData local_airport_outlined = IconData(0xe285, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_airport</i> &#x2014; material icon named "local airport rounded".
  static const IconData local_airport_rounded = IconData(0xf2b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_airport</i> &#x2014; material icon named "local airport sharp".
  static const IconData local_airport_sharp = IconData(0xed89, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_atm</i> &#x2014; material icon named "local atm".
  static const IconData local_atm = IconData(0xe820, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_atm</i> &#x2014; material icon named "local atm outlined".
  static const IconData local_atm_outlined = IconData(0xe286, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_atm</i> &#x2014; material icon named "local atm rounded".
  static const IconData local_atm_rounded = IconData(0xf2b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_atm</i> &#x2014; material icon named "local atm sharp".
  static const IconData local_atm_sharp = IconData(0xed8a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_attraction</i> &#x2014; material icon named "local attraction".
  static const IconData local_attraction = IconData(0xe81e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_attraction</i> &#x2014; material icon named "local attraction outlined".
  static const IconData local_attraction_outlined = IconData(0xe284, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_attraction</i> &#x2014; material icon named "local attraction rounded".
  static const IconData local_attraction_rounded = IconData(0xf2b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_attraction</i> &#x2014; material icon named "local attraction sharp".
  static const IconData local_attraction_sharp = IconData(0xed88, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_bar</i> &#x2014; material icon named "local bar".
  static const IconData local_bar = IconData(0xe821, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_bar</i> &#x2014; material icon named "local bar outlined".
  static const IconData local_bar_outlined = IconData(0xe287, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_bar</i> &#x2014; material icon named "local bar rounded".
  static const IconData local_bar_rounded = IconData(0xf2b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_bar</i> &#x2014; material icon named "local bar sharp".
  static const IconData local_bar_sharp = IconData(0xed8b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_cafe</i> &#x2014; material icon named "local cafe".
  static const IconData local_cafe = IconData(0xe822, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_cafe</i> &#x2014; material icon named "local cafe outlined".
  static const IconData local_cafe_outlined = IconData(0xe288, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_cafe</i> &#x2014; material icon named "local cafe rounded".
  static const IconData local_cafe_rounded = IconData(0xf2ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_cafe</i> &#x2014; material icon named "local cafe sharp".
  static const IconData local_cafe_sharp = IconData(0xed8c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_car_wash</i> &#x2014; material icon named "local car wash".
  static const IconData local_car_wash = IconData(0xe823, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_car_wash</i> &#x2014; material icon named "local car wash outlined".
  static const IconData local_car_wash_outlined = IconData(0xe289, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_car_wash</i> &#x2014; material icon named "local car wash rounded".
  static const IconData local_car_wash_rounded = IconData(0xf2bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_car_wash</i> &#x2014; material icon named "local car wash sharp".
  static const IconData local_car_wash_sharp = IconData(0xed8d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_convenience_store</i> &#x2014; material icon named "local convenience store".
  static const IconData local_convenience_store = IconData(0xe824, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_convenience_store</i> &#x2014; material icon named "local convenience store outlined".
  static const IconData local_convenience_store_outlined = IconData(0xe28a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_convenience_store</i> &#x2014; material icon named "local convenience store rounded".
  static const IconData local_convenience_store_rounded = IconData(0xf2bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_convenience_store</i> &#x2014; material icon named "local convenience store sharp".
  static const IconData local_convenience_store_sharp = IconData(0xed8e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_dining</i> &#x2014; material icon named "local dining".
  static const IconData local_dining = IconData(0xe825, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_dining</i> &#x2014; material icon named "local dining outlined".
  static const IconData local_dining_outlined = IconData(0xe28b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_dining</i> &#x2014; material icon named "local dining rounded".
  static const IconData local_dining_rounded = IconData(0xf2bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_dining</i> &#x2014; material icon named "local dining sharp".
  static const IconData local_dining_sharp = IconData(0xed8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_drink</i> &#x2014; material icon named "local drink".
  static const IconData local_drink = IconData(0xe826, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_drink</i> &#x2014; material icon named "local drink outlined".
  static const IconData local_drink_outlined = IconData(0xe28c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_drink</i> &#x2014; material icon named "local drink rounded".
  static const IconData local_drink_rounded = IconData(0xf2be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_drink</i> &#x2014; material icon named "local drink sharp".
  static const IconData local_drink_sharp = IconData(0xed90, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_fire_department</i> &#x2014; material icon named "local fire department".
  static const IconData local_fire_department = IconData(0xe827, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_fire_department</i> &#x2014; material icon named "local fire department outlined".
  static const IconData local_fire_department_outlined = IconData(0xe28d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_fire_department</i> &#x2014; material icon named "local fire department rounded".
  static const IconData local_fire_department_rounded = IconData(0xf2bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_fire_department</i> &#x2014; material icon named "local fire department sharp".
  static const IconData local_fire_department_sharp = IconData(0xed91, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_florist</i> &#x2014; material icon named "local florist".
  static const IconData local_florist = IconData(0xe828, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_florist</i> &#x2014; material icon named "local florist outlined".
  static const IconData local_florist_outlined = IconData(0xe28e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_florist</i> &#x2014; material icon named "local florist rounded".
  static const IconData local_florist_rounded = IconData(0xf2c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_florist</i> &#x2014; material icon named "local florist sharp".
  static const IconData local_florist_sharp = IconData(0xed92, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_gas_station</i> &#x2014; material icon named "local gas station".
  static const IconData local_gas_station = IconData(0xe829, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_gas_station</i> &#x2014; material icon named "local gas station outlined".
  static const IconData local_gas_station_outlined = IconData(0xe28f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_gas_station</i> &#x2014; material icon named "local gas station rounded".
  static const IconData local_gas_station_rounded = IconData(0xf2c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_gas_station</i> &#x2014; material icon named "local gas station sharp".
  static const IconData local_gas_station_sharp = IconData(0xed93, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_grocery_store</i> &#x2014; material icon named "local grocery store".
  static const IconData local_grocery_store = IconData(0xe82a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_grocery_store</i> &#x2014; material icon named "local grocery store outlined".
  static const IconData local_grocery_store_outlined = IconData(0xe290, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_grocery_store</i> &#x2014; material icon named "local grocery store rounded".
  static const IconData local_grocery_store_rounded = IconData(0xf2c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_grocery_store</i> &#x2014; material icon named "local grocery store sharp".
  static const IconData local_grocery_store_sharp = IconData(0xed94, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_hospital</i> &#x2014; material icon named "local hospital".
  static const IconData local_hospital = IconData(0xe82b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_hospital</i> &#x2014; material icon named "local hospital outlined".
  static const IconData local_hospital_outlined = IconData(0xe291, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_hospital</i> &#x2014; material icon named "local hospital rounded".
  static const IconData local_hospital_rounded = IconData(0xf2c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_hospital</i> &#x2014; material icon named "local hospital sharp".
  static const IconData local_hospital_sharp = IconData(0xed95, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_hotel</i> &#x2014; material icon named "local hotel".
  static const IconData local_hotel = IconData(0xe82c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_hotel</i> &#x2014; material icon named "local hotel outlined".
  static const IconData local_hotel_outlined = IconData(0xe292, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_hotel</i> &#x2014; material icon named "local hotel rounded".
  static const IconData local_hotel_rounded = IconData(0xf2c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_hotel</i> &#x2014; material icon named "local hotel sharp".
  static const IconData local_hotel_sharp = IconData(0xed96, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_laundry_service</i> &#x2014; material icon named "local laundry service".
  static const IconData local_laundry_service = IconData(0xe82d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_laundry_service</i> &#x2014; material icon named "local laundry service outlined".
  static const IconData local_laundry_service_outlined = IconData(0xe293, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_laundry_service</i> &#x2014; material icon named "local laundry service rounded".
  static const IconData local_laundry_service_rounded = IconData(0xf2c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_laundry_service</i> &#x2014; material icon named "local laundry service sharp".
  static const IconData local_laundry_service_sharp = IconData(0xed97, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_library</i> &#x2014; material icon named "local library".
  static const IconData local_library = IconData(0xe82e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_library</i> &#x2014; material icon named "local library outlined".
  static const IconData local_library_outlined = IconData(0xe294, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_library</i> &#x2014; material icon named "local library rounded".
  static const IconData local_library_rounded = IconData(0xf2c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_library</i> &#x2014; material icon named "local library sharp".
  static const IconData local_library_sharp = IconData(0xed98, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_mall</i> &#x2014; material icon named "local mall".
  static const IconData local_mall = IconData(0xe82f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_mall</i> &#x2014; material icon named "local mall outlined".
  static const IconData local_mall_outlined = IconData(0xe295, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_mall</i> &#x2014; material icon named "local mall rounded".
  static const IconData local_mall_rounded = IconData(0xf2c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_mall</i> &#x2014; material icon named "local mall sharp".
  static const IconData local_mall_sharp = IconData(0xed99, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_movies</i> &#x2014; material icon named "local movies".
  static const IconData local_movies = IconData(0xe830, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_movies</i> &#x2014; material icon named "local movies outlined".
  static const IconData local_movies_outlined = IconData(0xe296, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_movies</i> &#x2014; material icon named "local movies rounded".
  static const IconData local_movies_rounded = IconData(0xf2c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_movies</i> &#x2014; material icon named "local movies sharp".
  static const IconData local_movies_sharp = IconData(0xed9a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_offer</i> &#x2014; material icon named "local offer".
  static const IconData local_offer = IconData(0xe831, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_offer</i> &#x2014; material icon named "local offer outlined".
  static const IconData local_offer_outlined = IconData(0xe297, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_offer</i> &#x2014; material icon named "local offer rounded".
  static const IconData local_offer_rounded = IconData(0xf2c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_offer</i> &#x2014; material icon named "local offer sharp".
  static const IconData local_offer_sharp = IconData(0xed9b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_parking</i> &#x2014; material icon named "local parking".
  static const IconData local_parking = IconData(0xe832, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_parking</i> &#x2014; material icon named "local parking outlined".
  static const IconData local_parking_outlined = IconData(0xe298, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_parking</i> &#x2014; material icon named "local parking rounded".
  static const IconData local_parking_rounded = IconData(0xf2ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_parking</i> &#x2014; material icon named "local parking sharp".
  static const IconData local_parking_sharp = IconData(0xed9c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_pharmacy</i> &#x2014; material icon named "local pharmacy".
  static const IconData local_pharmacy = IconData(0xe833, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_pharmacy</i> &#x2014; material icon named "local pharmacy outlined".
  static const IconData local_pharmacy_outlined = IconData(0xe299, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_pharmacy</i> &#x2014; material icon named "local pharmacy rounded".
  static const IconData local_pharmacy_rounded = IconData(0xf2cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_pharmacy</i> &#x2014; material icon named "local pharmacy sharp".
  static const IconData local_pharmacy_sharp = IconData(0xed9d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_phone</i> &#x2014; material icon named "local phone".
  static const IconData local_phone = IconData(0xe834, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_phone</i> &#x2014; material icon named "local phone outlined".
  static const IconData local_phone_outlined = IconData(0xe29a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_phone</i> &#x2014; material icon named "local phone rounded".
  static const IconData local_phone_rounded = IconData(0xf2cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_phone</i> &#x2014; material icon named "local phone sharp".
  static const IconData local_phone_sharp = IconData(0xed9e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_pizza</i> &#x2014; material icon named "local pizza".
  static const IconData local_pizza = IconData(0xe835, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_pizza</i> &#x2014; material icon named "local pizza outlined".
  static const IconData local_pizza_outlined = IconData(0xe29b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_pizza</i> &#x2014; material icon named "local pizza rounded".
  static const IconData local_pizza_rounded = IconData(0xf2cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_pizza</i> &#x2014; material icon named "local pizza sharp".
  static const IconData local_pizza_sharp = IconData(0xed9f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_play</i> &#x2014; material icon named "local play".
  static const IconData local_play = IconData(0xe836, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_play</i> &#x2014; material icon named "local play outlined".
  static const IconData local_play_outlined = IconData(0xe29c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_play</i> &#x2014; material icon named "local play rounded".
  static const IconData local_play_rounded = IconData(0xf2ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_play</i> &#x2014; material icon named "local play sharp".
  static const IconData local_play_sharp = IconData(0xeda0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_police</i> &#x2014; material icon named "local police".
  static const IconData local_police = IconData(0xe837, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_police</i> &#x2014; material icon named "local police outlined".
  static const IconData local_police_outlined = IconData(0xe29d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_police</i> &#x2014; material icon named "local police rounded".
  static const IconData local_police_rounded = IconData(0xf2cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_police</i> &#x2014; material icon named "local police sharp".
  static const IconData local_police_sharp = IconData(0xeda1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_post_office</i> &#x2014; material icon named "local post office".
  static const IconData local_post_office = IconData(0xe838, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_post_office</i> &#x2014; material icon named "local post office outlined".
  static const IconData local_post_office_outlined = IconData(0xe29e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_post_office</i> &#x2014; material icon named "local post office rounded".
  static const IconData local_post_office_rounded = IconData(0xf2d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_post_office</i> &#x2014; material icon named "local post office sharp".
  static const IconData local_post_office_sharp = IconData(0xeda2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_print_shop</i> &#x2014; material icon named "local print shop".
  static const IconData local_print_shop = IconData(0xe839, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_print_shop</i> &#x2014; material icon named "local print shop outlined".
  static const IconData local_print_shop_outlined = IconData(0xe29f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_print_shop</i> &#x2014; material icon named "local print shop rounded".
  static const IconData local_print_shop_rounded = IconData(0xf2d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_print_shop</i> &#x2014; material icon named "local print shop sharp".
  static const IconData local_print_shop_sharp = IconData(0xeda3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_printshop</i> &#x2014; material icon named "local printshop".
  static const IconData local_printshop = IconData(0xe839, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_printshop</i> &#x2014; material icon named "local printshop outlined".
  static const IconData local_printshop_outlined = IconData(0xe29f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_printshop</i> &#x2014; material icon named "local printshop rounded".
  static const IconData local_printshop_rounded = IconData(0xf2d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_printshop</i> &#x2014; material icon named "local printshop sharp".
  static const IconData local_printshop_sharp = IconData(0xeda3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_restaurant</i> &#x2014; material icon named "local restaurant".
  static const IconData local_restaurant = IconData(0xe825, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_restaurant</i> &#x2014; material icon named "local restaurant outlined".
  static const IconData local_restaurant_outlined = IconData(0xe28b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_restaurant</i> &#x2014; material icon named "local restaurant rounded".
  static const IconData local_restaurant_rounded = IconData(0xf2bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_restaurant</i> &#x2014; material icon named "local restaurant sharp".
  static const IconData local_restaurant_sharp = IconData(0xed8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_see</i> &#x2014; material icon named "local see".
  static const IconData local_see = IconData(0xe83a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_see</i> &#x2014; material icon named "local see outlined".
  static const IconData local_see_outlined = IconData(0xe2a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_see</i> &#x2014; material icon named "local see rounded".
  static const IconData local_see_rounded = IconData(0xf2d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_see</i> &#x2014; material icon named "local see sharp".
  static const IconData local_see_sharp = IconData(0xeda4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_shipping</i> &#x2014; material icon named "local shipping".
  static const IconData local_shipping = IconData(0xe83b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_shipping</i> &#x2014; material icon named "local shipping outlined".
  static const IconData local_shipping_outlined = IconData(0xe2a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_shipping</i> &#x2014; material icon named "local shipping rounded".
  static const IconData local_shipping_rounded = IconData(0xf2d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_shipping</i> &#x2014; material icon named "local shipping sharp".
  static const IconData local_shipping_sharp = IconData(0xeda5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_taxi</i> &#x2014; material icon named "local taxi".
  static const IconData local_taxi = IconData(0xe83c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_taxi</i> &#x2014; material icon named "local taxi outlined".
  static const IconData local_taxi_outlined = IconData(0xe2a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_taxi</i> &#x2014; material icon named "local taxi rounded".
  static const IconData local_taxi_rounded = IconData(0xf2d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_taxi</i> &#x2014; material icon named "local taxi sharp".
  static const IconData local_taxi_sharp = IconData(0xeda6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_city</i> &#x2014; material icon named "location city".
  static const IconData location_city = IconData(0xe83d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_city</i> &#x2014; material icon named "location city outlined".
  static const IconData location_city_outlined = IconData(0xe2a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_city</i> &#x2014; material icon named "location city rounded".
  static const IconData location_city_rounded = IconData(0xf2d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_city</i> &#x2014; material icon named "location city sharp".
  static const IconData location_city_sharp = IconData(0xeda7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_disabled</i> &#x2014; material icon named "location disabled".
  static const IconData location_disabled = IconData(0xe83e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_disabled</i> &#x2014; material icon named "location disabled outlined".
  static const IconData location_disabled_outlined = IconData(0xe2a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_disabled</i> &#x2014; material icon named "location disabled rounded".
  static const IconData location_disabled_rounded = IconData(0xf2d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_disabled</i> &#x2014; material icon named "location disabled sharp".
  static const IconData location_disabled_sharp = IconData(0xeda8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_history</i> &#x2014; material icon named "location history".
  static const IconData location_history = IconData(0xe906, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_history</i> &#x2014; material icon named "location history outlined".
  static const IconData location_history_outlined = IconData(0xe353, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_history</i> &#x2014; material icon named "location history rounded".
  static const IconData location_history_rounded = IconData(0xf385, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_history</i> &#x2014; material icon named "location history sharp".
  static const IconData location_history_sharp = IconData(0xee57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_off</i> &#x2014; material icon named "location off".
  static const IconData location_off = IconData(0xe83f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_off</i> &#x2014; material icon named "location off outlined".
  static const IconData location_off_outlined = IconData(0xe2a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_off</i> &#x2014; material icon named "location off rounded".
  static const IconData location_off_rounded = IconData(0xf2d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_off</i> &#x2014; material icon named "location off sharp".
  static const IconData location_off_sharp = IconData(0xeda9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_on</i> &#x2014; material icon named "location on".
  static const IconData location_on = IconData(0xe840, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_on</i> &#x2014; material icon named "location on outlined".
  static const IconData location_on_outlined = IconData(0xe2a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_on</i> &#x2014; material icon named "location on rounded".
  static const IconData location_on_rounded = IconData(0xf2d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_on</i> &#x2014; material icon named "location on sharp".
  static const IconData location_on_sharp = IconData(0xedaa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_pin</i> &#x2014; material icon named "location pin".
  static const IconData location_pin = IconData(0xe841, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_searching</i> &#x2014; material icon named "location searching".
  static const IconData location_searching = IconData(0xe842, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_searching</i> &#x2014; material icon named "location searching outlined".
  static const IconData location_searching_outlined = IconData(0xe2a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_searching</i> &#x2014; material icon named "location searching rounded".
  static const IconData location_searching_rounded = IconData(0xf2d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_searching</i> &#x2014; material icon named "location searching sharp".
  static const IconData location_searching_sharp = IconData(0xedab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock</i> &#x2014; material icon named "lock".
  static const IconData lock = IconData(0xe843, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock_clock</i> &#x2014; material icon named "lock clock".
  static const IconData lock_clock = IconData(0xe844, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock_open</i> &#x2014; material icon named "lock open".
  static const IconData lock_open = IconData(0xe845, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lock_open</i> &#x2014; material icon named "lock open outlined".
  static const IconData lock_open_outlined = IconData(0xe2a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lock_open</i> &#x2014; material icon named "lock open rounded".
  static const IconData lock_open_rounded = IconData(0xf2da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lock_open</i> &#x2014; material icon named "lock open sharp".
  static const IconData lock_open_sharp = IconData(0xedac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock_outline</i> &#x2014; material icon named "lock outline".
  static const IconData lock_outline = IconData(0xe846, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lock_outline</i> &#x2014; material icon named "lock outline rounded".
  static const IconData lock_outline_rounded = IconData(0xf2db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lock_outline</i> &#x2014; material icon named "lock outline sharp".
  static const IconData lock_outline_sharp = IconData(0xedad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lock</i> &#x2014; material icon named "lock outlined".
  static const IconData lock_outlined = IconData(0xe2a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lock</i> &#x2014; material icon named "lock rounded".
  static const IconData lock_rounded = IconData(0xf2dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lock</i> &#x2014; material icon named "lock sharp".
  static const IconData lock_sharp = IconData(0xedae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">login</i> &#x2014; material icon named "login".
  static const IconData login = IconData(0xe847, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">login</i> &#x2014; material icon named "login outlined".
  static const IconData login_outlined = IconData(0xe2aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">login</i> &#x2014; material icon named "login rounded".
  static const IconData login_rounded = IconData(0xf2dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">login</i> &#x2014; material icon named "login sharp".
  static const IconData login_sharp = IconData(0xedaf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">logout</i> &#x2014; material icon named "logout".
  static const IconData logout = IconData(0xe848, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks</i> &#x2014; material icon named "looks".
  static const IconData looks = IconData(0xe849, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_3</i> &#x2014; material icon named "looks 3".
  static const IconData looks_3 = IconData(0xe84a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_3</i> &#x2014; material icon named "looks 3 outlined".
  static const IconData looks_3_outlined = IconData(0xe2ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_3</i> &#x2014; material icon named "looks 3 rounded".
  static const IconData looks_3_rounded = IconData(0xf2de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_3</i> &#x2014; material icon named "looks 3 sharp".
  static const IconData looks_3_sharp = IconData(0xedb0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_4</i> &#x2014; material icon named "looks 4".
  static const IconData looks_4 = IconData(0xe84b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_4</i> &#x2014; material icon named "looks 4 outlined".
  static const IconData looks_4_outlined = IconData(0xe2ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_4</i> &#x2014; material icon named "looks 4 rounded".
  static const IconData looks_4_rounded = IconData(0xf2df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_4</i> &#x2014; material icon named "looks 4 sharp".
  static const IconData looks_4_sharp = IconData(0xedb1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_5</i> &#x2014; material icon named "looks 5".
  static const IconData looks_5 = IconData(0xe84c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_5</i> &#x2014; material icon named "looks 5 outlined".
  static const IconData looks_5_outlined = IconData(0xe2ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_5</i> &#x2014; material icon named "looks 5 rounded".
  static const IconData looks_5_rounded = IconData(0xf2e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_5</i> &#x2014; material icon named "looks 5 sharp".
  static const IconData looks_5_sharp = IconData(0xedb2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_6</i> &#x2014; material icon named "looks 6".
  static const IconData looks_6 = IconData(0xe84d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_6</i> &#x2014; material icon named "looks 6 outlined".
  static const IconData looks_6_outlined = IconData(0xe2ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_6</i> &#x2014; material icon named "looks 6 rounded".
  static const IconData looks_6_rounded = IconData(0xf2e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_6</i> &#x2014; material icon named "looks 6 sharp".
  static const IconData looks_6_sharp = IconData(0xedb3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_one</i> &#x2014; material icon named "looks one".
  static const IconData looks_one = IconData(0xe84e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_one</i> &#x2014; material icon named "looks one outlined".
  static const IconData looks_one_outlined = IconData(0xe2af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_one</i> &#x2014; material icon named "looks one rounded".
  static const IconData looks_one_rounded = IconData(0xf2e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_one</i> &#x2014; material icon named "looks one sharp".
  static const IconData looks_one_sharp = IconData(0xedb4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks</i> &#x2014; material icon named "looks outlined".
  static const IconData looks_outlined = IconData(0xe2b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks</i> &#x2014; material icon named "looks rounded".
  static const IconData looks_rounded = IconData(0xf2e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks</i> &#x2014; material icon named "looks sharp".
  static const IconData looks_sharp = IconData(0xedb5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_two</i> &#x2014; material icon named "looks two".
  static const IconData looks_two = IconData(0xe84f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_two</i> &#x2014; material icon named "looks two outlined".
  static const IconData looks_two_outlined = IconData(0xe2b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_two</i> &#x2014; material icon named "looks two rounded".
  static const IconData looks_two_rounded = IconData(0xf2e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_two</i> &#x2014; material icon named "looks two sharp".
  static const IconData looks_two_sharp = IconData(0xedb6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">loop</i> &#x2014; material icon named "loop".
  static const IconData loop = IconData(0xe850, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">loop</i> &#x2014; material icon named "loop outlined".
  static const IconData loop_outlined = IconData(0xe2b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">loop</i> &#x2014; material icon named "loop rounded".
  static const IconData loop_rounded = IconData(0xf2e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">loop</i> &#x2014; material icon named "loop sharp".
  static const IconData loop_sharp = IconData(0xedb7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">loupe</i> &#x2014; material icon named "loupe".
  static const IconData loupe = IconData(0xe851, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">loupe</i> &#x2014; material icon named "loupe outlined".
  static const IconData loupe_outlined = IconData(0xe2b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">loupe</i> &#x2014; material icon named "loupe rounded".
  static const IconData loupe_rounded = IconData(0xf2e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">loupe</i> &#x2014; material icon named "loupe sharp".
  static const IconData loupe_sharp = IconData(0xedb8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">low_priority</i> &#x2014; material icon named "low priority".
  static const IconData low_priority = IconData(0xe852, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">low_priority</i> &#x2014; material icon named "low priority outlined".
  static const IconData low_priority_outlined = IconData(0xe2b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">low_priority</i> &#x2014; material icon named "low priority rounded".
  static const IconData low_priority_rounded = IconData(0xf2e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">low_priority</i> &#x2014; material icon named "low priority sharp".
  static const IconData low_priority_sharp = IconData(0xedb9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">loyalty</i> &#x2014; material icon named "loyalty".
  static const IconData loyalty = IconData(0xe853, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">loyalty</i> &#x2014; material icon named "loyalty outlined".
  static const IconData loyalty_outlined = IconData(0xe2b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">loyalty</i> &#x2014; material icon named "loyalty rounded".
  static const IconData loyalty_rounded = IconData(0xf2e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">loyalty</i> &#x2014; material icon named "loyalty sharp".
  static const IconData loyalty_sharp = IconData(0xedba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lunch_dining</i> &#x2014; material icon named "lunch dining".
  static const IconData lunch_dining = IconData(0xe854, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mail</i> &#x2014; material icon named "mail".
  static const IconData mail = IconData(0xe855, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mail_outline</i> &#x2014; material icon named "mail outline".
  static const IconData mail_outline = IconData(0xe856, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mail_outline</i> &#x2014; material icon named "mail outline outlined".
  static const IconData mail_outline_outlined = IconData(0xe2b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mail_outline</i> &#x2014; material icon named "mail outline rounded".
  static const IconData mail_outline_rounded = IconData(0xf2e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mail_outline</i> &#x2014; material icon named "mail outline sharp".
  static const IconData mail_outline_sharp = IconData(0xedbb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mail</i> &#x2014; material icon named "mail outlined".
  static const IconData mail_outlined = IconData(0xe2b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mail</i> &#x2014; material icon named "mail rounded".
  static const IconData mail_rounded = IconData(0xf2ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mail</i> &#x2014; material icon named "mail sharp".
  static const IconData mail_sharp = IconData(0xedbc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">map</i> &#x2014; material icon named "map".
  static const IconData map = IconData(0xe857, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">map</i> &#x2014; material icon named "map outlined".
  static const IconData map_outlined = IconData(0xe2b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">map</i> &#x2014; material icon named "map rounded".
  static const IconData map_rounded = IconData(0xf2eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">map</i> &#x2014; material icon named "map sharp".
  static const IconData map_sharp = IconData(0xedbd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">maps_ugc</i> &#x2014; material icon named "maps ugc".
  static const IconData maps_ugc = IconData(0xe858, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">maps_ugc</i> &#x2014; material icon named "maps ugc outlined".
  static const IconData maps_ugc_outlined = IconData(0xe2b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">maps_ugc</i> &#x2014; material icon named "maps ugc rounded".
  static const IconData maps_ugc_rounded = IconData(0xf2ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">maps_ugc</i> &#x2014; material icon named "maps ugc sharp".
  static const IconData maps_ugc_sharp = IconData(0xedbe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">margin</i> &#x2014; material icon named "margin".
  static const IconData margin = IconData(0xe859, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_as_unread</i> &#x2014; material icon named "mark as unread".
  static const IconData mark_as_unread = IconData(0xe85a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_chat_read</i> &#x2014; material icon named "mark chat read".
  static const IconData mark_chat_read = IconData(0xe85b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mark_chat_read</i> &#x2014; material icon named "mark chat read outlined".
  static const IconData mark_chat_read_outlined = IconData(0xe2ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mark_chat_read</i> &#x2014; material icon named "mark chat read rounded".
  static const IconData mark_chat_read_rounded = IconData(0xf2ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mark_chat_read</i> &#x2014; material icon named "mark chat read sharp".
  static const IconData mark_chat_read_sharp = IconData(0xedbf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_chat_unread</i> &#x2014; material icon named "mark chat unread".
  static const IconData mark_chat_unread = IconData(0xe85c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mark_chat_unread</i> &#x2014; material icon named "mark chat unread outlined".
  static const IconData mark_chat_unread_outlined = IconData(0xe2bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mark_chat_unread</i> &#x2014; material icon named "mark chat unread rounded".
  static const IconData mark_chat_unread_rounded = IconData(0xf2ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mark_chat_unread</i> &#x2014; material icon named "mark chat unread sharp".
  static const IconData mark_chat_unread_sharp = IconData(0xedc0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_email_read</i> &#x2014; material icon named "mark email read".
  static const IconData mark_email_read = IconData(0xe85d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mark_email_read</i> &#x2014; material icon named "mark email read outlined".
  static const IconData mark_email_read_outlined = IconData(0xe2bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mark_email_read</i> &#x2014; material icon named "mark email read rounded".
  static const IconData mark_email_read_rounded = IconData(0xf2ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mark_email_read</i> &#x2014; material icon named "mark email read sharp".
  static const IconData mark_email_read_sharp = IconData(0xedc1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_email_unread</i> &#x2014; material icon named "mark email unread".
  static const IconData mark_email_unread = IconData(0xe85e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mark_email_unread</i> &#x2014; material icon named "mark email unread outlined".
  static const IconData mark_email_unread_outlined = IconData(0xe2bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mark_email_unread</i> &#x2014; material icon named "mark email unread rounded".
  static const IconData mark_email_unread_rounded = IconData(0xf2f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mark_email_unread</i> &#x2014; material icon named "mark email unread sharp".
  static const IconData mark_email_unread_sharp = IconData(0xedc2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">markunread</i> &#x2014; material icon named "markunread".
  static const IconData markunread = IconData(0xe85f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">markunread_mailbox</i> &#x2014; material icon named "markunread mailbox".
  static const IconData markunread_mailbox = IconData(0xe860, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">markunread_mailbox</i> &#x2014; material icon named "markunread mailbox outlined".
  static const IconData markunread_mailbox_outlined = IconData(0xe2be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">markunread_mailbox</i> &#x2014; material icon named "markunread mailbox rounded".
  static const IconData markunread_mailbox_rounded = IconData(0xf2f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">markunread_mailbox</i> &#x2014; material icon named "markunread mailbox sharp".
  static const IconData markunread_mailbox_sharp = IconData(0xedc3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">markunread</i> &#x2014; material icon named "markunread outlined".
  static const IconData markunread_outlined = IconData(0xe2bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">markunread</i> &#x2014; material icon named "markunread rounded".
  static const IconData markunread_rounded = IconData(0xf2f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">markunread</i> &#x2014; material icon named "markunread sharp".
  static const IconData markunread_sharp = IconData(0xedc4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">masks</i> &#x2014; material icon named "masks".
  static const IconData masks = IconData(0xe861, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">masks</i> &#x2014; material icon named "masks outlined".
  static const IconData masks_outlined = IconData(0xe2c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">masks</i> &#x2014; material icon named "masks rounded".
  static const IconData masks_rounded = IconData(0xf2f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">masks</i> &#x2014; material icon named "masks sharp".
  static const IconData masks_sharp = IconData(0xedc5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">maximize</i> &#x2014; material icon named "maximize".
  static const IconData maximize = IconData(0xe862, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">maximize</i> &#x2014; material icon named "maximize outlined".
  static const IconData maximize_outlined = IconData(0xe2c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">maximize</i> &#x2014; material icon named "maximize rounded".
  static const IconData maximize_rounded = IconData(0xf2f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">maximize</i> &#x2014; material icon named "maximize sharp".
  static const IconData maximize_sharp = IconData(0xedc6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mediation</i> &#x2014; material icon named "mediation".
  static const IconData mediation = IconData(0xe863, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mediation</i> &#x2014; material icon named "mediation outlined".
  static const IconData mediation_outlined = IconData(0xe2c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mediation</i> &#x2014; material icon named "mediation rounded".
  static const IconData mediation_rounded = IconData(0xf2f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mediation</i> &#x2014; material icon named "mediation sharp".
  static const IconData mediation_sharp = IconData(0xedc7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">medical_services</i> &#x2014; material icon named "medical services".
  static const IconData medical_services = IconData(0xe864, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">medical_services</i> &#x2014; material icon named "medical services outlined".
  static const IconData medical_services_outlined = IconData(0xe2c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">medical_services</i> &#x2014; material icon named "medical services rounded".
  static const IconData medical_services_rounded = IconData(0xf2f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">medical_services</i> &#x2014; material icon named "medical services sharp".
  static const IconData medical_services_sharp = IconData(0xedc8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">meeting_room</i> &#x2014; material icon named "meeting room".
  static const IconData meeting_room = IconData(0xe865, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">meeting_room</i> &#x2014; material icon named "meeting room outlined".
  static const IconData meeting_room_outlined = IconData(0xe2c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">meeting_room</i> &#x2014; material icon named "meeting room rounded".
  static const IconData meeting_room_rounded = IconData(0xf2f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">meeting_room</i> &#x2014; material icon named "meeting room sharp".
  static const IconData meeting_room_sharp = IconData(0xedc9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">memory</i> &#x2014; material icon named "memory".
  static const IconData memory = IconData(0xe866, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">memory</i> &#x2014; material icon named "memory outlined".
  static const IconData memory_outlined = IconData(0xe2c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">memory</i> &#x2014; material icon named "memory rounded".
  static const IconData memory_rounded = IconData(0xf2f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">memory</i> &#x2014; material icon named "memory sharp".
  static const IconData memory_sharp = IconData(0xedca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">menu</i> &#x2014; material icon named "menu".
  static const IconData menu = IconData(0xe867, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">menu_book</i> &#x2014; material icon named "menu book".
  static const IconData menu_book = IconData(0xe868, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">menu_book</i> &#x2014; material icon named "menu book outlined".
  static const IconData menu_book_outlined = IconData(0xe2c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">menu_book</i> &#x2014; material icon named "menu book rounded".
  static const IconData menu_book_rounded = IconData(0xf2f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">menu_book</i> &#x2014; material icon named "menu book sharp".
  static const IconData menu_book_sharp = IconData(0xedcb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">menu_open</i> &#x2014; material icon named "menu open".
  static const IconData menu_open = IconData(0xe869, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">menu_open</i> &#x2014; material icon named "menu open outlined".
  static const IconData menu_open_outlined = IconData(0xe2c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">menu_open</i> &#x2014; material icon named "menu open rounded".
  static const IconData menu_open_rounded = IconData(0xf2fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">menu_open</i> &#x2014; material icon named "menu open sharp".
  static const IconData menu_open_sharp = IconData(0xedcc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">menu</i> &#x2014; material icon named "menu outlined".
  static const IconData menu_outlined = IconData(0xe2c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">menu</i> &#x2014; material icon named "menu rounded".
  static const IconData menu_rounded = IconData(0xf2fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">menu</i> &#x2014; material icon named "menu sharp".
  static const IconData menu_sharp = IconData(0xedcd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">merge_type</i> &#x2014; material icon named "merge type".
  static const IconData merge_type = IconData(0xe86a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">merge_type</i> &#x2014; material icon named "merge type outlined".
  static const IconData merge_type_outlined = IconData(0xe2c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">merge_type</i> &#x2014; material icon named "merge type rounded".
  static const IconData merge_type_rounded = IconData(0xf2fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">merge_type</i> &#x2014; material icon named "merge type sharp".
  static const IconData merge_type_sharp = IconData(0xedce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">message</i> &#x2014; material icon named "message".
  static const IconData message = IconData(0xe86b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">message</i> &#x2014; material icon named "message outlined".
  static const IconData message_outlined = IconData(0xe2ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">message</i> &#x2014; material icon named "message rounded".
  static const IconData message_rounded = IconData(0xf2fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">message</i> &#x2014; material icon named "message sharp".
  static const IconData message_sharp = IconData(0xedcf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">messenger</i> &#x2014; material icon named "messenger".
  static const IconData messenger = IconData(0xe64a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">messenger_outline</i> &#x2014; material icon named "messenger outline".
  static const IconData messenger_outline = IconData(0xe64b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">messenger_outline</i> &#x2014; material icon named "messenger outline outlined".
  static const IconData messenger_outline_outlined = IconData(0xe0d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">messenger_outline</i> &#x2014; material icon named "messenger outline rounded".
  static const IconData messenger_outline_rounded = IconData(0xf107, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">messenger_outline</i> &#x2014; material icon named "messenger outline sharp".
  static const IconData messenger_outline_sharp = IconData(0xebd9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">messenger</i> &#x2014; material icon named "messenger outlined".
  static const IconData messenger_outlined = IconData(0xe0da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">messenger</i> &#x2014; material icon named "messenger rounded".
  static const IconData messenger_rounded = IconData(0xf108, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">messenger</i> &#x2014; material icon named "messenger sharp".
  static const IconData messenger_sharp = IconData(0xebda, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic</i> &#x2014; material icon named "mic".
  static const IconData mic = IconData(0xe86c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_external_off</i> &#x2014; material icon named "mic external off".
  static const IconData mic_external_off = IconData(0xe86d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_external_on</i> &#x2014; material icon named "mic external on".
  static const IconData mic_external_on = IconData(0xe86e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_none</i> &#x2014; material icon named "mic none".
  static const IconData mic_none = IconData(0xe86f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mic_none</i> &#x2014; material icon named "mic none outlined".
  static const IconData mic_none_outlined = IconData(0xe2cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mic_none</i> &#x2014; material icon named "mic none rounded".
  static const IconData mic_none_rounded = IconData(0xf2fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mic_none</i> &#x2014; material icon named "mic none sharp".
  static const IconData mic_none_sharp = IconData(0xedd0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_off</i> &#x2014; material icon named "mic off".
  static const IconData mic_off = IconData(0xe870, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mic_off</i> &#x2014; material icon named "mic off outlined".
  static const IconData mic_off_outlined = IconData(0xe2cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mic_off</i> &#x2014; material icon named "mic off rounded".
  static const IconData mic_off_rounded = IconData(0xf2ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mic_off</i> &#x2014; material icon named "mic off sharp".
  static const IconData mic_off_sharp = IconData(0xedd1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mic</i> &#x2014; material icon named "mic outlined".
  static const IconData mic_outlined = IconData(0xe2cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mic</i> &#x2014; material icon named "mic rounded".
  static const IconData mic_rounded = IconData(0xf300, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mic</i> &#x2014; material icon named "mic sharp".
  static const IconData mic_sharp = IconData(0xedd2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">microwave</i> &#x2014; material icon named "microwave".
  static const IconData microwave = IconData(0xe871, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">microwave</i> &#x2014; material icon named "microwave outlined".
  static const IconData microwave_outlined = IconData(0xe2ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">microwave</i> &#x2014; material icon named "microwave rounded".
  static const IconData microwave_rounded = IconData(0xf301, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">microwave</i> &#x2014; material icon named "microwave sharp".
  static const IconData microwave_sharp = IconData(0xedd3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">military_tech</i> &#x2014; material icon named "military tech".
  static const IconData military_tech = IconData(0xe872, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">military_tech</i> &#x2014; material icon named "military tech outlined".
  static const IconData military_tech_outlined = IconData(0xe2cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">military_tech</i> &#x2014; material icon named "military tech rounded".
  static const IconData military_tech_rounded = IconData(0xf302, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">military_tech</i> &#x2014; material icon named "military tech sharp".
  static const IconData military_tech_sharp = IconData(0xedd4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">minimize</i> &#x2014; material icon named "minimize".
  static const IconData minimize = IconData(0xe873, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">minimize</i> &#x2014; material icon named "minimize outlined".
  static const IconData minimize_outlined = IconData(0xe2d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">minimize</i> &#x2014; material icon named "minimize rounded".
  static const IconData minimize_rounded = IconData(0xf303, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">minimize</i> &#x2014; material icon named "minimize sharp".
  static const IconData minimize_sharp = IconData(0xedd5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">miscellaneous_services</i> &#x2014; material icon named "miscellaneous services".
  static const IconData miscellaneous_services = IconData(0xe874, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">miscellaneous_services</i> &#x2014; material icon named "miscellaneous services outlined".
  static const IconData miscellaneous_services_outlined = IconData(0xe2d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">miscellaneous_services</i> &#x2014; material icon named "miscellaneous services rounded".
  static const IconData miscellaneous_services_rounded = IconData(0xf304, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">miscellaneous_services</i> &#x2014; material icon named "miscellaneous services sharp".
  static const IconData miscellaneous_services_sharp = IconData(0xedd6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">missed_video_call</i> &#x2014; material icon named "missed video call".
  static const IconData missed_video_call = IconData(0xe875, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">missed_video_call</i> &#x2014; material icon named "missed video call outlined".
  static const IconData missed_video_call_outlined = IconData(0xe2d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">missed_video_call</i> &#x2014; material icon named "missed video call rounded".
  static const IconData missed_video_call_rounded = IconData(0xf305, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">missed_video_call</i> &#x2014; material icon named "missed video call sharp".
  static const IconData missed_video_call_sharp = IconData(0xedd7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mms</i> &#x2014; material icon named "mms".
  static const IconData mms = IconData(0xe876, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mms</i> &#x2014; material icon named "mms outlined".
  static const IconData mms_outlined = IconData(0xe2d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mms</i> &#x2014; material icon named "mms rounded".
  static const IconData mms_rounded = IconData(0xf306, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mms</i> &#x2014; material icon named "mms sharp".
  static const IconData mms_sharp = IconData(0xedd8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mobile_friendly</i> &#x2014; material icon named "mobile friendly".
  static const IconData mobile_friendly = IconData(0xe877, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mobile_friendly</i> &#x2014; material icon named "mobile friendly outlined".
  static const IconData mobile_friendly_outlined = IconData(0xe2d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mobile_friendly</i> &#x2014; material icon named "mobile friendly rounded".
  static const IconData mobile_friendly_rounded = IconData(0xf307, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mobile_friendly</i> &#x2014; material icon named "mobile friendly sharp".
  static const IconData mobile_friendly_sharp = IconData(0xedd9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mobile_off</i> &#x2014; material icon named "mobile off".
  static const IconData mobile_off = IconData(0xe878, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mobile_off</i> &#x2014; material icon named "mobile off outlined".
  static const IconData mobile_off_outlined = IconData(0xe2d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mobile_off</i> &#x2014; material icon named "mobile off rounded".
  static const IconData mobile_off_rounded = IconData(0xf308, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mobile_off</i> &#x2014; material icon named "mobile off sharp".
  static const IconData mobile_off_sharp = IconData(0xedda, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mobile_screen_share</i> &#x2014; material icon named "mobile screen share".
  static const IconData mobile_screen_share = IconData(0xe879, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">mobile_screen_share</i> &#x2014; material icon named "mobile screen share outlined".
  static const IconData mobile_screen_share_outlined = IconData(0xe2d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mobile_screen_share</i> &#x2014; material icon named "mobile screen share rounded".
  static const IconData mobile_screen_share_rounded = IconData(0xf309, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mobile_screen_share</i> &#x2014; material icon named "mobile screen share sharp".
  static const IconData mobile_screen_share_sharp = IconData(0xeddb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mode_comment</i> &#x2014; material icon named "mode comment".
  static const IconData mode_comment = IconData(0xe87a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mode_comment</i> &#x2014; material icon named "mode comment outlined".
  static const IconData mode_comment_outlined = IconData(0xe2d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mode_comment</i> &#x2014; material icon named "mode comment rounded".
  static const IconData mode_comment_rounded = IconData(0xf30a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mode_comment</i> &#x2014; material icon named "mode comment sharp".
  static const IconData mode_comment_sharp = IconData(0xeddc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mode_edit</i> &#x2014; material icon named "mode edit".
  static const IconData mode_edit = IconData(0xe87b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mode</i> &#x2014; material icon named "mode outlined".
  static const IconData mode_outlined = IconData(0xe2d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mode</i> &#x2014; material icon named "mode rounded".
  static const IconData mode_rounded = IconData(0xf30b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mode</i> &#x2014; material icon named "mode sharp".
  static const IconData mode_sharp = IconData(0xeddd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">model_training</i> &#x2014; material icon named "model training".
  static const IconData model_training = IconData(0xe87c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">model_training</i> &#x2014; material icon named "model training outlined".
  static const IconData model_training_outlined = IconData(0xe2d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">model_training</i> &#x2014; material icon named "model training rounded".
  static const IconData model_training_rounded = IconData(0xf30c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">model_training</i> &#x2014; material icon named "model training sharp".
  static const IconData model_training_sharp = IconData(0xedde, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">monetization_on</i> &#x2014; material icon named "monetization on".
  static const IconData monetization_on = IconData(0xe87d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">monetization_on</i> &#x2014; material icon named "monetization on outlined".
  static const IconData monetization_on_outlined = IconData(0xe2da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">monetization_on</i> &#x2014; material icon named "monetization on rounded".
  static const IconData monetization_on_rounded = IconData(0xf30d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">monetization_on</i> &#x2014; material icon named "monetization on sharp".
  static const IconData monetization_on_sharp = IconData(0xeddf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">money</i> &#x2014; material icon named "money".
  static const IconData money = IconData(0xe87e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">money_off</i> &#x2014; material icon named "money off".
  static const IconData money_off = IconData(0xe87f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">money_off_csred</i> &#x2014; material icon named "money off csred outlined".
  static const IconData money_off_csred_outlined = IconData(0xe2db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">money_off_csred</i> &#x2014; material icon named "money off csred rounded".
  static const IconData money_off_csred_rounded = IconData(0xf30e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">money_off_csred</i> &#x2014; material icon named "money off csred sharp".
  static const IconData money_off_csred_sharp = IconData(0xede0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">money_off</i> &#x2014; material icon named "money off outlined".
  static const IconData money_off_outlined = IconData(0xe2dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">money_off</i> &#x2014; material icon named "money off rounded".
  static const IconData money_off_rounded = IconData(0xf30f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">money_off</i> &#x2014; material icon named "money off sharp".
  static const IconData money_off_sharp = IconData(0xede1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">money</i> &#x2014; material icon named "money outlined".
  static const IconData money_outlined = IconData(0xe2dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">money</i> &#x2014; material icon named "money rounded".
  static const IconData money_rounded = IconData(0xf310, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">money</i> &#x2014; material icon named "money sharp".
  static const IconData money_sharp = IconData(0xede2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">monitor</i> &#x2014; material icon named "monitor".
  static const IconData monitor = IconData(0xe880, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">monochrome_photos</i> &#x2014; material icon named "monochrome photos".
  static const IconData monochrome_photos = IconData(0xe881, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">monochrome_photos</i> &#x2014; material icon named "monochrome photos outlined".
  static const IconData monochrome_photos_outlined = IconData(0xe2de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">monochrome_photos</i> &#x2014; material icon named "monochrome photos rounded".
  static const IconData monochrome_photos_rounded = IconData(0xf311, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">monochrome_photos</i> &#x2014; material icon named "monochrome photos sharp".
  static const IconData monochrome_photos_sharp = IconData(0xede3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mood</i> &#x2014; material icon named "mood".
  static const IconData mood = IconData(0xe882, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mood_bad</i> &#x2014; material icon named "mood bad".
  static const IconData mood_bad = IconData(0xe883, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mood_bad</i> &#x2014; material icon named "mood bad outlined".
  static const IconData mood_bad_outlined = IconData(0xe2df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mood_bad</i> &#x2014; material icon named "mood bad rounded".
  static const IconData mood_bad_rounded = IconData(0xf312, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mood_bad</i> &#x2014; material icon named "mood bad sharp".
  static const IconData mood_bad_sharp = IconData(0xede4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mood</i> &#x2014; material icon named "mood outlined".
  static const IconData mood_outlined = IconData(0xe2e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mood</i> &#x2014; material icon named "mood rounded".
  static const IconData mood_rounded = IconData(0xf313, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mood</i> &#x2014; material icon named "mood sharp".
  static const IconData mood_sharp = IconData(0xede5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">moped</i> &#x2014; material icon named "moped".
  static const IconData moped = IconData(0xe884, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">moped</i> &#x2014; material icon named "moped outlined".
  static const IconData moped_outlined = IconData(0xe2e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">moped</i> &#x2014; material icon named "moped rounded".
  static const IconData moped_rounded = IconData(0xf314, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">moped</i> &#x2014; material icon named "moped sharp".
  static const IconData moped_sharp = IconData(0xede6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more</i> &#x2014; material icon named "more".
  static const IconData more = IconData(0xe885, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more_horiz</i> &#x2014; material icon named "more horiz".
  static const IconData more_horiz = IconData(0xe886, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">more_horiz</i> &#x2014; material icon named "more horiz outlined".
  static const IconData more_horiz_outlined = IconData(0xe2e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">more_horiz</i> &#x2014; material icon named "more horiz rounded".
  static const IconData more_horiz_rounded = IconData(0xf315, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">more_horiz</i> &#x2014; material icon named "more horiz sharp".
  static const IconData more_horiz_sharp = IconData(0xede7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">more</i> &#x2014; material icon named "more outlined".
  static const IconData more_outlined = IconData(0xe2e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">more</i> &#x2014; material icon named "more rounded".
  static const IconData more_rounded = IconData(0xf316, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">more</i> &#x2014; material icon named "more sharp".
  static const IconData more_sharp = IconData(0xede8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more_time</i> &#x2014; material icon named "more time".
  static const IconData more_time = IconData(0xe887, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">more_time</i> &#x2014; material icon named "more time outlined".
  static const IconData more_time_outlined = IconData(0xe2e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">more_time</i> &#x2014; material icon named "more time rounded".
  static const IconData more_time_rounded = IconData(0xf317, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">more_time</i> &#x2014; material icon named "more time sharp".
  static const IconData more_time_sharp = IconData(0xede9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more_vert</i> &#x2014; material icon named "more vert".
  static const IconData more_vert = IconData(0xe888, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">more_vert</i> &#x2014; material icon named "more vert outlined".
  static const IconData more_vert_outlined = IconData(0xe2e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">more_vert</i> &#x2014; material icon named "more vert rounded".
  static const IconData more_vert_rounded = IconData(0xf318, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">more_vert</i> &#x2014; material icon named "more vert sharp".
  static const IconData more_vert_sharp = IconData(0xedea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motion_photos_off</i> &#x2014; material icon named "motion photos off".
  static const IconData motion_photos_off = IconData(0xe889, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motion_photos_on</i> &#x2014; material icon named "motion photos on".
  static const IconData motion_photos_on = IconData(0xe88a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motion_photos_on</i> &#x2014; material icon named "motion photos on outlined".
  static const IconData motion_photos_on_outlined = IconData(0xe2e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motion_photos_on</i> &#x2014; material icon named "motion photos on rounded".
  static const IconData motion_photos_on_rounded = IconData(0xf319, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motion_photos_on</i> &#x2014; material icon named "motion photos on sharp".
  static const IconData motion_photos_on_sharp = IconData(0xedeb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motion_photos_pause</i> &#x2014; material icon named "motion photos pause".
  static const IconData motion_photos_pause = IconData(0xe88b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motion_photos_pause</i> &#x2014; material icon named "motion photos pause outlined".
  static const IconData motion_photos_pause_outlined = IconData(0xe2e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motion_photos_pause</i> &#x2014; material icon named "motion photos pause rounded".
  static const IconData motion_photos_pause_rounded = IconData(0xf31a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motion_photos_pause</i> &#x2014; material icon named "motion photos pause sharp".
  static const IconData motion_photos_pause_sharp = IconData(0xedec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motion_photos_paused</i> &#x2014; material icon named "motion photos paused".
  static const IconData motion_photos_paused = IconData(0xe88c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motion_photos_paused</i> &#x2014; material icon named "motion photos paused outlined".
  static const IconData motion_photos_paused_outlined = IconData(0xe2e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motion_photos_paused</i> &#x2014; material icon named "motion photos paused rounded".
  static const IconData motion_photos_paused_rounded = IconData(0xf31b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motion_photos_paused</i> &#x2014; material icon named "motion photos paused sharp".
  static const IconData motion_photos_paused_sharp = IconData(0xeded, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motorcycle</i> &#x2014; material icon named "motorcycle".
  static const IconData motorcycle = IconData(0xe88d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motorcycle</i> &#x2014; material icon named "motorcycle outlined".
  static const IconData motorcycle_outlined = IconData(0xe2e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motorcycle</i> &#x2014; material icon named "motorcycle rounded".
  static const IconData motorcycle_rounded = IconData(0xf31c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motorcycle</i> &#x2014; material icon named "motorcycle sharp".
  static const IconData motorcycle_sharp = IconData(0xedee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mouse</i> &#x2014; material icon named "mouse".
  static const IconData mouse = IconData(0xe88e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mouse</i> &#x2014; material icon named "mouse outlined".
  static const IconData mouse_outlined = IconData(0xe2ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mouse</i> &#x2014; material icon named "mouse rounded".
  static const IconData mouse_rounded = IconData(0xf31d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mouse</i> &#x2014; material icon named "mouse sharp".
  static const IconData mouse_sharp = IconData(0xedef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">move_to_inbox</i> &#x2014; material icon named "move to inbox".
  static const IconData move_to_inbox = IconData(0xe88f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">move_to_inbox</i> &#x2014; material icon named "move to inbox outlined".
  static const IconData move_to_inbox_outlined = IconData(0xe2eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">move_to_inbox</i> &#x2014; material icon named "move to inbox rounded".
  static const IconData move_to_inbox_rounded = IconData(0xf31e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">move_to_inbox</i> &#x2014; material icon named "move to inbox sharp".
  static const IconData move_to_inbox_sharp = IconData(0xedf0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">movie</i> &#x2014; material icon named "movie".
  static const IconData movie = IconData(0xe890, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">movie_creation</i> &#x2014; material icon named "movie creation".
  static const IconData movie_creation = IconData(0xe891, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">movie_creation</i> &#x2014; material icon named "movie creation outlined".
  static const IconData movie_creation_outlined = IconData(0xe2ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">movie_creation</i> &#x2014; material icon named "movie creation rounded".
  static const IconData movie_creation_rounded = IconData(0xf31f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">movie_creation</i> &#x2014; material icon named "movie creation sharp".
  static const IconData movie_creation_sharp = IconData(0xedf1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">movie_filter</i> &#x2014; material icon named "movie filter".
  static const IconData movie_filter = IconData(0xe892, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">movie_filter</i> &#x2014; material icon named "movie filter outlined".
  static const IconData movie_filter_outlined = IconData(0xe2ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">movie_filter</i> &#x2014; material icon named "movie filter rounded".
  static const IconData movie_filter_rounded = IconData(0xf320, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">movie_filter</i> &#x2014; material icon named "movie filter sharp".
  static const IconData movie_filter_sharp = IconData(0xedf2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">movie</i> &#x2014; material icon named "movie outlined".
  static const IconData movie_outlined = IconData(0xe2ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">movie</i> &#x2014; material icon named "movie rounded".
  static const IconData movie_rounded = IconData(0xf321, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">movie</i> &#x2014; material icon named "movie sharp".
  static const IconData movie_sharp = IconData(0xedf3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mp</i> &#x2014; material icon named "mp".
  static const IconData mp = IconData(0xe893, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">multiline_chart</i> &#x2014; material icon named "multiline chart".
  static const IconData multiline_chart = IconData(0xe894, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">multiline_chart</i> &#x2014; material icon named "multiline chart outlined".
  static const IconData multiline_chart_outlined = IconData(0xe2ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">multiline_chart</i> &#x2014; material icon named "multiline chart rounded".
  static const IconData multiline_chart_rounded = IconData(0xf322, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">multiline_chart</i> &#x2014; material icon named "multiline chart sharp".
  static const IconData multiline_chart_sharp = IconData(0xedf4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">multiple_stop</i> &#x2014; material icon named "multiple stop".
  static const IconData multiple_stop = IconData(0xe895, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">multiple_stop</i> &#x2014; material icon named "multiple stop outlined".
  static const IconData multiple_stop_outlined = IconData(0xe2f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">multiple_stop</i> &#x2014; material icon named "multiple stop rounded".
  static const IconData multiple_stop_rounded = IconData(0xf323, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">multiple_stop</i> &#x2014; material icon named "multiple stop sharp".
  static const IconData multiple_stop_sharp = IconData(0xedf5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">multitrack_audio</i> &#x2014; material icon named "multitrack audio".
  static const IconData multitrack_audio = IconData(0xe798, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">multitrack_audio</i> &#x2014; material icon named "multitrack audio outlined".
  static const IconData multitrack_audio_outlined = IconData(0xe20d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">multitrack_audio</i> &#x2014; material icon named "multitrack audio rounded".
  static const IconData multitrack_audio_rounded = IconData(0xf23c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">multitrack_audio</i> &#x2014; material icon named "multitrack audio sharp".
  static const IconData multitrack_audio_sharp = IconData(0xed0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">museum</i> &#x2014; material icon named "museum".
  static const IconData museum = IconData(0xe896, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">museum</i> &#x2014; material icon named "museum outlined".
  static const IconData museum_outlined = IconData(0xe2f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">museum</i> &#x2014; material icon named "museum rounded".
  static const IconData museum_rounded = IconData(0xf324, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">museum</i> &#x2014; material icon named "museum sharp".
  static const IconData museum_sharp = IconData(0xedf6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">music_note</i> &#x2014; material icon named "music note".
  static const IconData music_note = IconData(0xe897, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">music_note</i> &#x2014; material icon named "music note outlined".
  static const IconData music_note_outlined = IconData(0xe2f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">music_note</i> &#x2014; material icon named "music note rounded".
  static const IconData music_note_rounded = IconData(0xf325, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">music_note</i> &#x2014; material icon named "music note sharp".
  static const IconData music_note_sharp = IconData(0xedf7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">music_off</i> &#x2014; material icon named "music off".
  static const IconData music_off = IconData(0xe898, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">music_off</i> &#x2014; material icon named "music off outlined".
  static const IconData music_off_outlined = IconData(0xe2f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">music_off</i> &#x2014; material icon named "music off rounded".
  static const IconData music_off_rounded = IconData(0xf326, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">music_off</i> &#x2014; material icon named "music off sharp".
  static const IconData music_off_sharp = IconData(0xedf8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">music_video</i> &#x2014; material icon named "music video".
  static const IconData music_video = IconData(0xe899, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">music_video</i> &#x2014; material icon named "music video outlined".
  static const IconData music_video_outlined = IconData(0xe2f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">music_video</i> &#x2014; material icon named "music video rounded".
  static const IconData music_video_rounded = IconData(0xf327, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">music_video</i> &#x2014; material icon named "music video sharp".
  static const IconData music_video_sharp = IconData(0xedf9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">my_library_add</i> &#x2014; material icon named "my library add".
  static const IconData my_library_add = IconData(0xe80d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">my_library_add</i> &#x2014; material icon named "my library add outlined".
  static const IconData my_library_add_outlined = IconData(0xe276, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">my_library_add</i> &#x2014; material icon named "my library add rounded".
  static const IconData my_library_add_rounded = IconData(0xf2a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">my_library_add</i> &#x2014; material icon named "my library add sharp".
  static const IconData my_library_add_sharp = IconData(0xed7a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">my_library_books</i> &#x2014; material icon named "my library books".
  static const IconData my_library_books = IconData(0xe80f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">my_library_books</i> &#x2014; material icon named "my library books outlined".
  static const IconData my_library_books_outlined = IconData(0xe277, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">my_library_books</i> &#x2014; material icon named "my library books rounded".
  static const IconData my_library_books_rounded = IconData(0xf2a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">my_library_books</i> &#x2014; material icon named "my library books sharp".
  static const IconData my_library_books_sharp = IconData(0xed7b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">my_library_music</i> &#x2014; material icon named "my library music".
  static const IconData my_library_music = IconData(0xe810, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">my_library_music</i> &#x2014; material icon named "my library music outlined".
  static const IconData my_library_music_outlined = IconData(0xe278, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">my_library_music</i> &#x2014; material icon named "my library music rounded".
  static const IconData my_library_music_rounded = IconData(0xf2aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">my_library_music</i> &#x2014; material icon named "my library music sharp".
  static const IconData my_library_music_sharp = IconData(0xed7c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">my_location</i> &#x2014; material icon named "my location".
  static const IconData my_location = IconData(0xe89a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">my_location</i> &#x2014; material icon named "my location outlined".
  static const IconData my_location_outlined = IconData(0xe2f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">my_location</i> &#x2014; material icon named "my location rounded".
  static const IconData my_location_rounded = IconData(0xf328, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">my_location</i> &#x2014; material icon named "my location sharp".
  static const IconData my_location_sharp = IconData(0xedfa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nat</i> &#x2014; material icon named "nat".
  static const IconData nat = IconData(0xe89b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nat</i> &#x2014; material icon named "nat outlined".
  static const IconData nat_outlined = IconData(0xe2f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nat</i> &#x2014; material icon named "nat rounded".
  static const IconData nat_rounded = IconData(0xf329, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nat</i> &#x2014; material icon named "nat sharp".
  static const IconData nat_sharp = IconData(0xedfb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nature</i> &#x2014; material icon named "nature".
  static const IconData nature = IconData(0xe89c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nature</i> &#x2014; material icon named "nature outlined".
  static const IconData nature_outlined = IconData(0xe2f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nature_people</i> &#x2014; material icon named "nature people".
  static const IconData nature_people = IconData(0xe89d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nature_people</i> &#x2014; material icon named "nature people outlined".
  static const IconData nature_people_outlined = IconData(0xe2f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nature_people</i> &#x2014; material icon named "nature people rounded".
  static const IconData nature_people_rounded = IconData(0xf32a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nature_people</i> &#x2014; material icon named "nature people sharp".
  static const IconData nature_people_sharp = IconData(0xedfc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nature</i> &#x2014; material icon named "nature rounded".
  static const IconData nature_rounded = IconData(0xf32b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nature</i> &#x2014; material icon named "nature sharp".
  static const IconData nature_sharp = IconData(0xedfd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">navigate_before</i> &#x2014; material icon named "navigate before".
  static const IconData navigate_before = IconData(0xe89e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">navigate_before</i> &#x2014; material icon named "navigate before outlined".
  static const IconData navigate_before_outlined = IconData(0xe2f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">navigate_before</i> &#x2014; material icon named "navigate before rounded".
  static const IconData navigate_before_rounded = IconData(0xf32c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">navigate_before</i> &#x2014; material icon named "navigate before sharp".
  static const IconData navigate_before_sharp = IconData(0xedfe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">navigate_next</i> &#x2014; material icon named "navigate next".
  static const IconData navigate_next = IconData(0xe89f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">navigate_next</i> &#x2014; material icon named "navigate next outlined".
  static const IconData navigate_next_outlined = IconData(0xe2fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">navigate_next</i> &#x2014; material icon named "navigate next rounded".
  static const IconData navigate_next_rounded = IconData(0xf32d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">navigate_next</i> &#x2014; material icon named "navigate next sharp".
  static const IconData navigate_next_sharp = IconData(0xedff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">navigation</i> &#x2014; material icon named "navigation".
  static const IconData navigation = IconData(0xe8a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">navigation</i> &#x2014; material icon named "navigation outlined".
  static const IconData navigation_outlined = IconData(0xe2fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">navigation</i> &#x2014; material icon named "navigation rounded".
  static const IconData navigation_rounded = IconData(0xf32e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">navigation</i> &#x2014; material icon named "navigation sharp".
  static const IconData navigation_sharp = IconData(0xee00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">near_me</i> &#x2014; material icon named "near me".
  static const IconData near_me = IconData(0xe8a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">near_me_disabled</i> &#x2014; material icon named "near me disabled".
  static const IconData near_me_disabled = IconData(0xe8a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">near_me_disabled</i> &#x2014; material icon named "near me disabled outlined".
  static const IconData near_me_disabled_outlined = IconData(0xe2fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">near_me_disabled</i> &#x2014; material icon named "near me disabled rounded".
  static const IconData near_me_disabled_rounded = IconData(0xf32f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">near_me_disabled</i> &#x2014; material icon named "near me disabled sharp".
  static const IconData near_me_disabled_sharp = IconData(0xee01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">near_me</i> &#x2014; material icon named "near me outlined".
  static const IconData near_me_outlined = IconData(0xe2fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">near_me</i> &#x2014; material icon named "near me rounded".
  static const IconData near_me_rounded = IconData(0xf330, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">near_me</i> &#x2014; material icon named "near me sharp".
  static const IconData near_me_sharp = IconData(0xee02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_cell</i> &#x2014; material icon named "network cell".
  static const IconData network_cell = IconData(0xe8a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_check</i> &#x2014; material icon named "network check".
  static const IconData network_check = IconData(0xe8a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">network_check</i> &#x2014; material icon named "network check outlined".
  static const IconData network_check_outlined = IconData(0xe2fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">network_check</i> &#x2014; material icon named "network check rounded".
  static const IconData network_check_rounded = IconData(0xf331, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">network_check</i> &#x2014; material icon named "network check sharp".
  static const IconData network_check_sharp = IconData(0xee03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_locked</i> &#x2014; material icon named "network locked".
  static const IconData network_locked = IconData(0xe8a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">network_locked</i> &#x2014; material icon named "network locked outlined".
  static const IconData network_locked_outlined = IconData(0xe2ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">network_locked</i> &#x2014; material icon named "network locked rounded".
  static const IconData network_locked_rounded = IconData(0xf332, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">network_locked</i> &#x2014; material icon named "network locked sharp".
  static const IconData network_locked_sharp = IconData(0xee04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_wifi</i> &#x2014; material icon named "network wifi".
  static const IconData network_wifi = IconData(0xe8a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">new_releases</i> &#x2014; material icon named "new releases".
  static const IconData new_releases = IconData(0xe8a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">new_releases</i> &#x2014; material icon named "new releases outlined".
  static const IconData new_releases_outlined = IconData(0xe300, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">new_releases</i> &#x2014; material icon named "new releases rounded".
  static const IconData new_releases_rounded = IconData(0xf333, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">new_releases</i> &#x2014; material icon named "new releases sharp".
  static const IconData new_releases_sharp = IconData(0xee05, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">next_plan</i> &#x2014; material icon named "next plan".
  static const IconData next_plan = IconData(0xe8a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">next_plan</i> &#x2014; material icon named "next plan outlined".
  static const IconData next_plan_outlined = IconData(0xe301, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">next_plan</i> &#x2014; material icon named "next plan rounded".
  static const IconData next_plan_rounded = IconData(0xf334, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">next_plan</i> &#x2014; material icon named "next plan sharp".
  static const IconData next_plan_sharp = IconData(0xee06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">next_week</i> &#x2014; material icon named "next week".
  static const IconData next_week = IconData(0xe8a9, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">next_week</i> &#x2014; material icon named "next week outlined".
  static const IconData next_week_outlined = IconData(0xe302, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">next_week</i> &#x2014; material icon named "next week rounded".
  static const IconData next_week_rounded = IconData(0xf335, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">next_week</i> &#x2014; material icon named "next week sharp".
  static const IconData next_week_sharp = IconData(0xee07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nfc</i> &#x2014; material icon named "nfc".
  static const IconData nfc = IconData(0xe8aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nfc</i> &#x2014; material icon named "nfc outlined".
  static const IconData nfc_outlined = IconData(0xe303, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nfc</i> &#x2014; material icon named "nfc rounded".
  static const IconData nfc_rounded = IconData(0xf336, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nfc</i> &#x2014; material icon named "nfc sharp".
  static const IconData nfc_sharp = IconData(0xee08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">night_shelter</i> &#x2014; material icon named "night shelter".
  static const IconData night_shelter = IconData(0xe8ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">night_shelter</i> &#x2014; material icon named "night shelter outlined".
  static const IconData night_shelter_outlined = IconData(0xe304, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">night_shelter</i> &#x2014; material icon named "night shelter rounded".
  static const IconData night_shelter_rounded = IconData(0xf337, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">night_shelter</i> &#x2014; material icon named "night shelter sharp".
  static const IconData night_shelter_sharp = IconData(0xee09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nightlife</i> &#x2014; material icon named "nightlife".
  static const IconData nightlife = IconData(0xe8ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nightlight_round</i> &#x2014; material icon named "nightlight round".
  static const IconData nightlight_round = IconData(0xe8ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nights_stay</i> &#x2014; material icon named "nights stay".
  static const IconData nights_stay = IconData(0xe8ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nights_stay</i> &#x2014; material icon named "nights stay outlined".
  static const IconData nights_stay_outlined = IconData(0xe305, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nights_stay</i> &#x2014; material icon named "nights stay rounded".
  static const IconData nights_stay_rounded = IconData(0xf338, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nights_stay</i> &#x2014; material icon named "nights stay sharp".
  static const IconData nights_stay_sharp = IconData(0xee0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_cell</i> &#x2014; material icon named "no cell".
  static const IconData no_cell = IconData(0xe8af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_cell</i> &#x2014; material icon named "no cell outlined".
  static const IconData no_cell_outlined = IconData(0xe306, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_cell</i> &#x2014; material icon named "no cell rounded".
  static const IconData no_cell_rounded = IconData(0xf339, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_cell</i> &#x2014; material icon named "no cell sharp".
  static const IconData no_cell_sharp = IconData(0xee0b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_drinks</i> &#x2014; material icon named "no drinks".
  static const IconData no_drinks = IconData(0xe8b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_drinks</i> &#x2014; material icon named "no drinks outlined".
  static const IconData no_drinks_outlined = IconData(0xe307, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_drinks</i> &#x2014; material icon named "no drinks rounded".
  static const IconData no_drinks_rounded = IconData(0xf33a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_drinks</i> &#x2014; material icon named "no drinks sharp".
  static const IconData no_drinks_sharp = IconData(0xee0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_encryption</i> &#x2014; material icon named "no encryption".
  static const IconData no_encryption = IconData(0xe8b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_encryption_gmailerrorred</i> &#x2014; material icon named "no encryption gmailerrorred outlined".
  static const IconData no_encryption_gmailerrorred_outlined = IconData(0xe308, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_encryption_gmailerrorred</i> &#x2014; material icon named "no encryption gmailerrorred rounded".
  static const IconData no_encryption_gmailerrorred_rounded = IconData(0xf33b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_encryption_gmailerrorred</i> &#x2014; material icon named "no encryption gmailerrorred sharp".
  static const IconData no_encryption_gmailerrorred_sharp = IconData(0xee0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_encryption</i> &#x2014; material icon named "no encryption outlined".
  static const IconData no_encryption_outlined = IconData(0xe309, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_encryption</i> &#x2014; material icon named "no encryption rounded".
  static const IconData no_encryption_rounded = IconData(0xf33c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_encryption</i> &#x2014; material icon named "no encryption sharp".
  static const IconData no_encryption_sharp = IconData(0xee0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_flash</i> &#x2014; material icon named "no flash".
  static const IconData no_flash = IconData(0xe8b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_flash</i> &#x2014; material icon named "no flash outlined".
  static const IconData no_flash_outlined = IconData(0xe30a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_flash</i> &#x2014; material icon named "no flash rounded".
  static const IconData no_flash_rounded = IconData(0xf33d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_flash</i> &#x2014; material icon named "no flash sharp".
  static const IconData no_flash_sharp = IconData(0xee0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_food</i> &#x2014; material icon named "no food".
  static const IconData no_food = IconData(0xe8b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_food</i> &#x2014; material icon named "no food outlined".
  static const IconData no_food_outlined = IconData(0xe30b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_food</i> &#x2014; material icon named "no food rounded".
  static const IconData no_food_rounded = IconData(0xf33e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_food</i> &#x2014; material icon named "no food sharp".
  static const IconData no_food_sharp = IconData(0xee10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_meals</i> &#x2014; material icon named "no meals".
  static const IconData no_meals = IconData(0xe8b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_meals_ouline</i> &#x2014; material icon named "no meals ouline".
  static const IconData no_meals_ouline = IconData(0xe8b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_meals</i> &#x2014; material icon named "no meals outlined".
  static const IconData no_meals_outlined = IconData(0xe30c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_meals</i> &#x2014; material icon named "no meals rounded".
  static const IconData no_meals_rounded = IconData(0xf33f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_meals</i> &#x2014; material icon named "no meals sharp".
  static const IconData no_meals_sharp = IconData(0xee11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_meeting_room</i> &#x2014; material icon named "no meeting room".
  static const IconData no_meeting_room = IconData(0xe8b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_meeting_room</i> &#x2014; material icon named "no meeting room outlined".
  static const IconData no_meeting_room_outlined = IconData(0xe30d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_meeting_room</i> &#x2014; material icon named "no meeting room rounded".
  static const IconData no_meeting_room_rounded = IconData(0xf340, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_meeting_room</i> &#x2014; material icon named "no meeting room sharp".
  static const IconData no_meeting_room_sharp = IconData(0xee12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_photography</i> &#x2014; material icon named "no photography".
  static const IconData no_photography = IconData(0xe8b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_photography</i> &#x2014; material icon named "no photography outlined".
  static const IconData no_photography_outlined = IconData(0xe30e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_photography</i> &#x2014; material icon named "no photography rounded".
  static const IconData no_photography_rounded = IconData(0xf341, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_photography</i> &#x2014; material icon named "no photography sharp".
  static const IconData no_photography_sharp = IconData(0xee13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_sim</i> &#x2014; material icon named "no sim".
  static const IconData no_sim = IconData(0xe8b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_sim</i> &#x2014; material icon named "no sim outlined".
  static const IconData no_sim_outlined = IconData(0xe30f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_sim</i> &#x2014; material icon named "no sim rounded".
  static const IconData no_sim_rounded = IconData(0xf342, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_sim</i> &#x2014; material icon named "no sim sharp".
  static const IconData no_sim_sharp = IconData(0xee14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_stroller</i> &#x2014; material icon named "no stroller".
  static const IconData no_stroller = IconData(0xe8b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_stroller</i> &#x2014; material icon named "no stroller outlined".
  static const IconData no_stroller_outlined = IconData(0xe310, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_stroller</i> &#x2014; material icon named "no stroller rounded".
  static const IconData no_stroller_rounded = IconData(0xf343, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_stroller</i> &#x2014; material icon named "no stroller sharp".
  static const IconData no_stroller_sharp = IconData(0xee15, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_transfer</i> &#x2014; material icon named "no transfer".
  static const IconData no_transfer = IconData(0xe8ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_transfer</i> &#x2014; material icon named "no transfer outlined".
  static const IconData no_transfer_outlined = IconData(0xe311, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_transfer</i> &#x2014; material icon named "no transfer rounded".
  static const IconData no_transfer_rounded = IconData(0xf344, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_transfer</i> &#x2014; material icon named "no transfer sharp".
  static const IconData no_transfer_sharp = IconData(0xee16, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">north</i> &#x2014; material icon named "north".
  static const IconData north = IconData(0xe8bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">north_east</i> &#x2014; material icon named "north east".
  static const IconData north_east = IconData(0xe8bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">north_east</i> &#x2014; material icon named "north east outlined".
  static const IconData north_east_outlined = IconData(0xe312, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">north_east</i> &#x2014; material icon named "north east rounded".
  static const IconData north_east_rounded = IconData(0xf345, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">north_east</i> &#x2014; material icon named "north east sharp".
  static const IconData north_east_sharp = IconData(0xee17, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">north</i> &#x2014; material icon named "north outlined".
  static const IconData north_outlined = IconData(0xe313, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">north</i> &#x2014; material icon named "north rounded".
  static const IconData north_rounded = IconData(0xf346, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">north</i> &#x2014; material icon named "north sharp".
  static const IconData north_sharp = IconData(0xee18, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">north_west</i> &#x2014; material icon named "north west".
  static const IconData north_west = IconData(0xe8bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">north_west</i> &#x2014; material icon named "north west outlined".
  static const IconData north_west_outlined = IconData(0xe314, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">north_west</i> &#x2014; material icon named "north west rounded".
  static const IconData north_west_rounded = IconData(0xf347, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">north_west</i> &#x2014; material icon named "north west sharp".
  static const IconData north_west_sharp = IconData(0xee19, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_accessible</i> &#x2014; material icon named "not accessible".
  static const IconData not_accessible = IconData(0xe8be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">not_accessible</i> &#x2014; material icon named "not accessible outlined".
  static const IconData not_accessible_outlined = IconData(0xe315, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">not_accessible</i> &#x2014; material icon named "not accessible rounded".
  static const IconData not_accessible_rounded = IconData(0xf348, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">not_accessible</i> &#x2014; material icon named "not accessible sharp".
  static const IconData not_accessible_sharp = IconData(0xee1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_interested</i> &#x2014; material icon named "not interested".
  static const IconData not_interested = IconData(0xe8bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">not_interested</i> &#x2014; material icon named "not interested outlined".
  static const IconData not_interested_outlined = IconData(0xe316, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">not_interested</i> &#x2014; material icon named "not interested rounded".
  static const IconData not_interested_rounded = IconData(0xf349, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">not_interested</i> &#x2014; material icon named "not interested sharp".
  static const IconData not_interested_sharp = IconData(0xee1b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_listed_location</i> &#x2014; material icon named "not listed location".
  static const IconData not_listed_location = IconData(0xe8c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">not_listed_location</i> &#x2014; material icon named "not listed location outlined".
  static const IconData not_listed_location_outlined = IconData(0xe317, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">not_listed_location</i> &#x2014; material icon named "not listed location rounded".
  static const IconData not_listed_location_rounded = IconData(0xf34a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">not_listed_location</i> &#x2014; material icon named "not listed location sharp".
  static const IconData not_listed_location_sharp = IconData(0xee1c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_started</i> &#x2014; material icon named "not started".
  static const IconData not_started = IconData(0xe8c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">not_started</i> &#x2014; material icon named "not started outlined".
  static const IconData not_started_outlined = IconData(0xe318, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">not_started</i> &#x2014; material icon named "not started rounded".
  static const IconData not_started_rounded = IconData(0xf34b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">not_started</i> &#x2014; material icon named "not started sharp".
  static const IconData not_started_sharp = IconData(0xee1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">note</i> &#x2014; material icon named "note".
  static const IconData note = IconData(0xe8c2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">note_add</i> &#x2014; material icon named "note add".
  static const IconData note_add = IconData(0xe8c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">note_add</i> &#x2014; material icon named "note add outlined".
  static const IconData note_add_outlined = IconData(0xe319, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">note_add</i> &#x2014; material icon named "note add rounded".
  static const IconData note_add_rounded = IconData(0xf34c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">note_add</i> &#x2014; material icon named "note add sharp".
  static const IconData note_add_sharp = IconData(0xee1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">note</i> &#x2014; material icon named "note outlined".
  static const IconData note_outlined = IconData(0xe31a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">note</i> &#x2014; material icon named "note rounded".
  static const IconData note_rounded = IconData(0xf34d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">note</i> &#x2014; material icon named "note sharp".
  static const IconData note_sharp = IconData(0xee1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notes</i> &#x2014; material icon named "notes".
  static const IconData notes = IconData(0xe8c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notes</i> &#x2014; material icon named "notes outlined".
  static const IconData notes_outlined = IconData(0xe31b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notes</i> &#x2014; material icon named "notes rounded".
  static const IconData notes_rounded = IconData(0xf34e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notes</i> &#x2014; material icon named "notes sharp".
  static const IconData notes_sharp = IconData(0xee20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notification_important</i> &#x2014; material icon named "notification important".
  static const IconData notification_important = IconData(0xe8c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notification_important</i> &#x2014; material icon named "notification important outlined".
  static const IconData notification_important_outlined = IconData(0xe31c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notification_important</i> &#x2014; material icon named "notification important rounded".
  static const IconData notification_important_rounded = IconData(0xf34f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notification_important</i> &#x2014; material icon named "notification important sharp".
  static const IconData notification_important_sharp = IconData(0xee21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications</i> &#x2014; material icon named "notifications".
  static const IconData notifications = IconData(0xe8c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_active</i> &#x2014; material icon named "notifications active".
  static const IconData notifications_active = IconData(0xe8c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_active</i> &#x2014; material icon named "notifications active outlined".
  static const IconData notifications_active_outlined = IconData(0xe31d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_active</i> &#x2014; material icon named "notifications active rounded".
  static const IconData notifications_active_rounded = IconData(0xf350, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_active</i> &#x2014; material icon named "notifications active sharp".
  static const IconData notifications_active_sharp = IconData(0xee22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_none</i> &#x2014; material icon named "notifications none".
  static const IconData notifications_none = IconData(0xe8c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_none</i> &#x2014; material icon named "notifications none outlined".
  static const IconData notifications_none_outlined = IconData(0xe31e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_none</i> &#x2014; material icon named "notifications none rounded".
  static const IconData notifications_none_rounded = IconData(0xf351, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_none</i> &#x2014; material icon named "notifications none sharp".
  static const IconData notifications_none_sharp = IconData(0xee23, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_off</i> &#x2014; material icon named "notifications off".
  static const IconData notifications_off = IconData(0xe8c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_off</i> &#x2014; material icon named "notifications off outlined".
  static const IconData notifications_off_outlined = IconData(0xe31f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_off</i> &#x2014; material icon named "notifications off rounded".
  static const IconData notifications_off_rounded = IconData(0xf352, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_off</i> &#x2014; material icon named "notifications off sharp".
  static const IconData notifications_off_sharp = IconData(0xee24, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_on</i> &#x2014; material icon named "notifications on".
  static const IconData notifications_on = IconData(0xe8c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_on</i> &#x2014; material icon named "notifications on outlined".
  static const IconData notifications_on_outlined = IconData(0xe31d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_on</i> &#x2014; material icon named "notifications on rounded".
  static const IconData notifications_on_rounded = IconData(0xf350, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_on</i> &#x2014; material icon named "notifications on sharp".
  static const IconData notifications_on_sharp = IconData(0xee22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications</i> &#x2014; material icon named "notifications outlined".
  static const IconData notifications_outlined = IconData(0xe320, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_paused</i> &#x2014; material icon named "notifications paused".
  static const IconData notifications_paused = IconData(0xe8ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_paused</i> &#x2014; material icon named "notifications paused outlined".
  static const IconData notifications_paused_outlined = IconData(0xe321, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_paused</i> &#x2014; material icon named "notifications paused rounded".
  static const IconData notifications_paused_rounded = IconData(0xf353, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_paused</i> &#x2014; material icon named "notifications paused sharp".
  static const IconData notifications_paused_sharp = IconData(0xee25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications</i> &#x2014; material icon named "notifications rounded".
  static const IconData notifications_rounded = IconData(0xf354, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications</i> &#x2014; material icon named "notifications sharp".
  static const IconData notifications_sharp = IconData(0xee26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">now_wallpaper</i> &#x2014; material icon named "now wallpaper".
  static const IconData now_wallpaper = IconData(0xead5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">now_wallpaper</i> &#x2014; material icon named "now wallpaper outlined".
  static const IconData now_wallpaper_outlined = IconData(0xe503, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">now_wallpaper</i> &#x2014; material icon named "now wallpaper rounded".
  static const IconData now_wallpaper_rounded = IconData(0xf534, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">now_wallpaper</i> &#x2014; material icon named "now wallpaper sharp".
  static const IconData now_wallpaper_sharp = IconData(0xf007, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">now_widgets</i> &#x2014; material icon named "now widgets".
  static const IconData now_widgets = IconData(0xeaec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">now_widgets</i> &#x2014; material icon named "now widgets outlined".
  static const IconData now_widgets_outlined = IconData(0xe518, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">now_widgets</i> &#x2014; material icon named "now widgets rounded".
  static const IconData now_widgets_rounded = IconData(0xf549, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">now_widgets</i> &#x2014; material icon named "now widgets sharp".
  static const IconData now_widgets_sharp = IconData(0xf01c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">offline_bolt</i> &#x2014; material icon named "offline bolt".
  static const IconData offline_bolt = IconData(0xe8cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">offline_bolt</i> &#x2014; material icon named "offline bolt outlined".
  static const IconData offline_bolt_outlined = IconData(0xe322, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">offline_bolt</i> &#x2014; material icon named "offline bolt rounded".
  static const IconData offline_bolt_rounded = IconData(0xf355, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">offline_bolt</i> &#x2014; material icon named "offline bolt sharp".
  static const IconData offline_bolt_sharp = IconData(0xee27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">offline_pin</i> &#x2014; material icon named "offline pin".
  static const IconData offline_pin = IconData(0xe8cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">offline_pin</i> &#x2014; material icon named "offline pin outlined".
  static const IconData offline_pin_outlined = IconData(0xe323, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">offline_pin</i> &#x2014; material icon named "offline pin rounded".
  static const IconData offline_pin_rounded = IconData(0xf356, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">offline_pin</i> &#x2014; material icon named "offline pin sharp".
  static const IconData offline_pin_sharp = IconData(0xee28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">offline_share</i> &#x2014; material icon named "offline share".
  static const IconData offline_share = IconData(0xe8cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ondemand_video</i> &#x2014; material icon named "ondemand video".
  static const IconData ondemand_video = IconData(0xe8ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ondemand_video</i> &#x2014; material icon named "ondemand video outlined".
  static const IconData ondemand_video_outlined = IconData(0xe324, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ondemand_video</i> &#x2014; material icon named "ondemand video rounded".
  static const IconData ondemand_video_rounded = IconData(0xf357, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ondemand_video</i> &#x2014; material icon named "ondemand video sharp".
  static const IconData ondemand_video_sharp = IconData(0xee29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">online_prediction</i> &#x2014; material icon named "online prediction".
  static const IconData online_prediction = IconData(0xe8cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">online_prediction</i> &#x2014; material icon named "online prediction outlined".
  static const IconData online_prediction_outlined = IconData(0xe325, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">online_prediction</i> &#x2014; material icon named "online prediction rounded".
  static const IconData online_prediction_rounded = IconData(0xf358, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">online_prediction</i> &#x2014; material icon named "online prediction sharp".
  static const IconData online_prediction_sharp = IconData(0xee2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">opacity</i> &#x2014; material icon named "opacity".
  static const IconData opacity = IconData(0xe8d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">opacity</i> &#x2014; material icon named "opacity outlined".
  static const IconData opacity_outlined = IconData(0xe326, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">opacity</i> &#x2014; material icon named "opacity rounded".
  static const IconData opacity_rounded = IconData(0xf359, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">opacity</i> &#x2014; material icon named "opacity sharp".
  static const IconData opacity_sharp = IconData(0xee2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_in_browser</i> &#x2014; material icon named "open in browser".
  static const IconData open_in_browser = IconData(0xe8d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">open_in_browser</i> &#x2014; material icon named "open in browser outlined".
  static const IconData open_in_browser_outlined = IconData(0xe327, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">open_in_browser</i> &#x2014; material icon named "open in browser rounded".
  static const IconData open_in_browser_rounded = IconData(0xf35a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">open_in_browser</i> &#x2014; material icon named "open in browser sharp".
  static const IconData open_in_browser_sharp = IconData(0xee2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_in_full</i> &#x2014; material icon named "open in full".
  static const IconData open_in_full = IconData(0xe8d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">open_in_full</i> &#x2014; material icon named "open in full outlined".
  static const IconData open_in_full_outlined = IconData(0xe328, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">open_in_full</i> &#x2014; material icon named "open in full rounded".
  static const IconData open_in_full_rounded = IconData(0xf35b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">open_in_full</i> &#x2014; material icon named "open in full sharp".
  static const IconData open_in_full_sharp = IconData(0xee2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_in_new</i> &#x2014; material icon named "open in new".
  static const IconData open_in_new = IconData(0xe8d3, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">open_in_new</i> &#x2014; material icon named "open in new outlined".
  static const IconData open_in_new_outlined = IconData(0xe329, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">open_in_new</i> &#x2014; material icon named "open in new rounded".
  static const IconData open_in_new_rounded = IconData(0xf35c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">open_in_new</i> &#x2014; material icon named "open in new sharp".
  static const IconData open_in_new_sharp = IconData(0xee2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_with</i> &#x2014; material icon named "open with".
  static const IconData open_with = IconData(0xe8d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">open_with</i> &#x2014; material icon named "open with outlined".
  static const IconData open_with_outlined = IconData(0xe32a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">open_with</i> &#x2014; material icon named "open with rounded".
  static const IconData open_with_rounded = IconData(0xf35d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">open_with</i> &#x2014; material icon named "open with sharp".
  static const IconData open_with_sharp = IconData(0xee2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outbond</i> &#x2014; material icon named "outbond".
  static const IconData outbond = IconData(0xe8d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outbond</i> &#x2014; material icon named "outbond outlined".
  static const IconData outbond_outlined = IconData(0xe32b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outbond</i> &#x2014; material icon named "outbond rounded".
  static const IconData outbond_rounded = IconData(0xf35e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outbond</i> &#x2014; material icon named "outbond sharp".
  static const IconData outbond_sharp = IconData(0xee30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outbox</i> &#x2014; material icon named "outbox".
  static const IconData outbox = IconData(0xe8d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outdoor_grill</i> &#x2014; material icon named "outdoor grill".
  static const IconData outdoor_grill = IconData(0xe8d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outdoor_grill</i> &#x2014; material icon named "outdoor grill outlined".
  static const IconData outdoor_grill_outlined = IconData(0xe32c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outdoor_grill</i> &#x2014; material icon named "outdoor grill rounded".
  static const IconData outdoor_grill_rounded = IconData(0xf35f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outdoor_grill</i> &#x2014; material icon named "outdoor grill sharp".
  static const IconData outdoor_grill_sharp = IconData(0xee31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outgoing_mail</i> &#x2014; material icon named "outgoing mail".
  static const IconData outgoing_mail = IconData(0xe8d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outlet</i> &#x2014; material icon named "outlet".
  static const IconData outlet = IconData(0xe8d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outlet</i> &#x2014; material icon named "outlet outlined".
  static const IconData outlet_outlined = IconData(0xe32d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outlet</i> &#x2014; material icon named "outlet rounded".
  static const IconData outlet_rounded = IconData(0xf360, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outlet</i> &#x2014; material icon named "outlet sharp".
  static const IconData outlet_sharp = IconData(0xee32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outlined_flag</i> &#x2014; material icon named "outlined flag".
  static const IconData outlined_flag = IconData(0xe8da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outlined_flag</i> &#x2014; material icon named "outlined flag outlined".
  static const IconData outlined_flag_outlined = IconData(0xe32e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outlined_flag</i> &#x2014; material icon named "outlined flag rounded".
  static const IconData outlined_flag_rounded = IconData(0xf361, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outlined_flag</i> &#x2014; material icon named "outlined flag sharp".
  static const IconData outlined_flag_sharp = IconData(0xee33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">padding</i> &#x2014; material icon named "padding".
  static const IconData padding = IconData(0xe8db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pages</i> &#x2014; material icon named "pages".
  static const IconData pages = IconData(0xe8dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pages</i> &#x2014; material icon named "pages outlined".
  static const IconData pages_outlined = IconData(0xe32f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pages</i> &#x2014; material icon named "pages rounded".
  static const IconData pages_rounded = IconData(0xf362, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pages</i> &#x2014; material icon named "pages sharp".
  static const IconData pages_sharp = IconData(0xee34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pageview</i> &#x2014; material icon named "pageview".
  static const IconData pageview = IconData(0xe8dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pageview</i> &#x2014; material icon named "pageview outlined".
  static const IconData pageview_outlined = IconData(0xe330, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pageview</i> &#x2014; material icon named "pageview rounded".
  static const IconData pageview_rounded = IconData(0xf363, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pageview</i> &#x2014; material icon named "pageview sharp".
  static const IconData pageview_sharp = IconData(0xee35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">palette</i> &#x2014; material icon named "palette".
  static const IconData palette = IconData(0xe8de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">palette</i> &#x2014; material icon named "palette outlined".
  static const IconData palette_outlined = IconData(0xe331, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">palette</i> &#x2014; material icon named "palette rounded".
  static const IconData palette_rounded = IconData(0xf364, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">palette</i> &#x2014; material icon named "palette sharp".
  static const IconData palette_sharp = IconData(0xee36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pan_tool</i> &#x2014; material icon named "pan tool".
  static const IconData pan_tool = IconData(0xe8df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pan_tool</i> &#x2014; material icon named "pan tool outlined".
  static const IconData pan_tool_outlined = IconData(0xe332, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pan_tool</i> &#x2014; material icon named "pan tool rounded".
  static const IconData pan_tool_rounded = IconData(0xf365, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pan_tool</i> &#x2014; material icon named "pan tool sharp".
  static const IconData pan_tool_sharp = IconData(0xee37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama</i> &#x2014; material icon named "panorama".
  static const IconData panorama = IconData(0xe8e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_fish_eye</i> &#x2014; material icon named "panorama fish eye".
  static const IconData panorama_fish_eye = IconData(0xe8e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_fish_eye</i> &#x2014; material icon named "panorama fish eye outlined".
  static const IconData panorama_fish_eye_outlined = IconData(0xe333, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_fish_eye</i> &#x2014; material icon named "panorama fish eye rounded".
  static const IconData panorama_fish_eye_rounded = IconData(0xf366, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_fish_eye</i> &#x2014; material icon named "panorama fish eye sharp".
  static const IconData panorama_fish_eye_sharp = IconData(0xee38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_fisheye</i> &#x2014; material icon named "panorama fisheye".
  static const IconData panorama_fisheye = IconData(0xe8e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_fisheye</i> &#x2014; material icon named "panorama fisheye outlined".
  static const IconData panorama_fisheye_outlined = IconData(0xe333, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_fisheye</i> &#x2014; material icon named "panorama fisheye rounded".
  static const IconData panorama_fisheye_rounded = IconData(0xf366, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_fisheye</i> &#x2014; material icon named "panorama fisheye sharp".
  static const IconData panorama_fisheye_sharp = IconData(0xee38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_horizontal</i> &#x2014; material icon named "panorama horizontal".
  static const IconData panorama_horizontal = IconData(0xe8e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_horizontal</i> &#x2014; material icon named "panorama horizontal outlined".
  static const IconData panorama_horizontal_outlined = IconData(0xe334, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_horizontal</i> &#x2014; material icon named "panorama horizontal rounded".
  static const IconData panorama_horizontal_rounded = IconData(0xf367, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_horizontal_select</i> &#x2014; material icon named "panorama horizontal select".
  static const IconData panorama_horizontal_select = IconData(0xe8e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_horizontal</i> &#x2014; material icon named "panorama horizontal sharp".
  static const IconData panorama_horizontal_sharp = IconData(0xee39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama</i> &#x2014; material icon named "panorama outlined".
  static const IconData panorama_outlined = IconData(0xe335, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_photosphere</i> &#x2014; material icon named "panorama photosphere".
  static const IconData panorama_photosphere = IconData(0xe8e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_photosphere_select</i> &#x2014; material icon named "panorama photosphere select".
  static const IconData panorama_photosphere_select = IconData(0xe8e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama</i> &#x2014; material icon named "panorama rounded".
  static const IconData panorama_rounded = IconData(0xf368, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama</i> &#x2014; material icon named "panorama sharp".
  static const IconData panorama_sharp = IconData(0xee3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_vertical</i> &#x2014; material icon named "panorama vertical".
  static const IconData panorama_vertical = IconData(0xe8e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_vertical</i> &#x2014; material icon named "panorama vertical outlined".
  static const IconData panorama_vertical_outlined = IconData(0xe336, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_vertical</i> &#x2014; material icon named "panorama vertical rounded".
  static const IconData panorama_vertical_rounded = IconData(0xf369, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_vertical_select</i> &#x2014; material icon named "panorama vertical select".
  static const IconData panorama_vertical_select = IconData(0xe8e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_vertical</i> &#x2014; material icon named "panorama vertical sharp".
  static const IconData panorama_vertical_sharp = IconData(0xee3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_wide_angle</i> &#x2014; material icon named "panorama wide angle".
  static const IconData panorama_wide_angle = IconData(0xe8e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_wide_angle</i> &#x2014; material icon named "panorama wide angle outlined".
  static const IconData panorama_wide_angle_outlined = IconData(0xe337, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_wide_angle</i> &#x2014; material icon named "panorama wide angle rounded".
  static const IconData panorama_wide_angle_rounded = IconData(0xf36a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_wide_angle_select</i> &#x2014; material icon named "panorama wide angle select".
  static const IconData panorama_wide_angle_select = IconData(0xe8e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_wide_angle</i> &#x2014; material icon named "panorama wide angle sharp".
  static const IconData panorama_wide_angle_sharp = IconData(0xee3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">park</i> &#x2014; material icon named "park".
  static const IconData park = IconData(0xe8ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">party_mode</i> &#x2014; material icon named "party mode".
  static const IconData party_mode = IconData(0xe8eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">party_mode</i> &#x2014; material icon named "party mode outlined".
  static const IconData party_mode_outlined = IconData(0xe338, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">party_mode</i> &#x2014; material icon named "party mode rounded".
  static const IconData party_mode_rounded = IconData(0xf36b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">party_mode</i> &#x2014; material icon named "party mode sharp".
  static const IconData party_mode_sharp = IconData(0xee3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">paste</i> &#x2014; material icon named "paste".
  static const IconData paste = IconData(0xe683, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">paste</i> &#x2014; material icon named "paste outlined".
  static const IconData paste_outlined = IconData(0xe10e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">paste</i> &#x2014; material icon named "paste rounded".
  static const IconData paste_rounded = IconData(0xf13c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">paste</i> &#x2014; material icon named "paste sharp".
  static const IconData paste_sharp = IconData(0xec0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause</i> &#x2014; material icon named "pause".
  static const IconData pause = IconData(0xe8ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause_circle_filled</i> &#x2014; material icon named "pause circle filled".
  static const IconData pause_circle_filled = IconData(0xe8ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pause_circle_filled</i> &#x2014; material icon named "pause circle filled outlined".
  static const IconData pause_circle_filled_outlined = IconData(0xe339, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pause_circle_filled</i> &#x2014; material icon named "pause circle filled rounded".
  static const IconData pause_circle_filled_rounded = IconData(0xf36c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pause_circle_filled</i> &#x2014; material icon named "pause circle filled sharp".
  static const IconData pause_circle_filled_sharp = IconData(0xee3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause_circle_outline</i> &#x2014; material icon named "pause circle outline".
  static const IconData pause_circle_outline = IconData(0xe8ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pause_circle_outline</i> &#x2014; material icon named "pause circle outline outlined".
  static const IconData pause_circle_outline_outlined = IconData(0xe33a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pause_circle_outline</i> &#x2014; material icon named "pause circle outline rounded".
  static const IconData pause_circle_outline_rounded = IconData(0xf36d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pause_circle_outline</i> &#x2014; material icon named "pause circle outline sharp".
  static const IconData pause_circle_outline_sharp = IconData(0xee3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pause</i> &#x2014; material icon named "pause outlined".
  static const IconData pause_outlined = IconData(0xe33b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause_presentation</i> &#x2014; material icon named "pause presentation".
  static const IconData pause_presentation = IconData(0xe8ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pause_presentation</i> &#x2014; material icon named "pause presentation outlined".
  static const IconData pause_presentation_outlined = IconData(0xe33c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pause_presentation</i> &#x2014; material icon named "pause presentation rounded".
  static const IconData pause_presentation_rounded = IconData(0xf36e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pause_presentation</i> &#x2014; material icon named "pause presentation sharp".
  static const IconData pause_presentation_sharp = IconData(0xee40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pause</i> &#x2014; material icon named "pause rounded".
  static const IconData pause_rounded = IconData(0xf36f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pause</i> &#x2014; material icon named "pause sharp".
  static const IconData pause_sharp = IconData(0xee41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">payment</i> &#x2014; material icon named "payment".
  static const IconData payment = IconData(0xe8f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">payment</i> &#x2014; material icon named "payment outlined".
  static const IconData payment_outlined = IconData(0xe33d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">payment</i> &#x2014; material icon named "payment rounded".
  static const IconData payment_rounded = IconData(0xf370, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">payment</i> &#x2014; material icon named "payment sharp".
  static const IconData payment_sharp = IconData(0xee42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">payments</i> &#x2014; material icon named "payments".
  static const IconData payments = IconData(0xe8f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">payments</i> &#x2014; material icon named "payments outlined".
  static const IconData payments_outlined = IconData(0xe33e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">payments</i> &#x2014; material icon named "payments rounded".
  static const IconData payments_rounded = IconData(0xf371, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">payments</i> &#x2014; material icon named "payments sharp".
  static const IconData payments_sharp = IconData(0xee43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pedal_bike</i> &#x2014; material icon named "pedal bike".
  static const IconData pedal_bike = IconData(0xe8f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pedal_bike</i> &#x2014; material icon named "pedal bike outlined".
  static const IconData pedal_bike_outlined = IconData(0xe33f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pedal_bike</i> &#x2014; material icon named "pedal bike rounded".
  static const IconData pedal_bike_rounded = IconData(0xf372, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pedal_bike</i> &#x2014; material icon named "pedal bike sharp".
  static const IconData pedal_bike_sharp = IconData(0xee44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pending</i> &#x2014; material icon named "pending".
  static const IconData pending = IconData(0xe8f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pending_actions</i> &#x2014; material icon named "pending actions".
  static const IconData pending_actions = IconData(0xe8f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pending_actions</i> &#x2014; material icon named "pending actions outlined".
  static const IconData pending_actions_outlined = IconData(0xe340, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pending_actions</i> &#x2014; material icon named "pending actions rounded".
  static const IconData pending_actions_rounded = IconData(0xf373, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pending_actions</i> &#x2014; material icon named "pending actions sharp".
  static const IconData pending_actions_sharp = IconData(0xee45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pending</i> &#x2014; material icon named "pending outlined".
  static const IconData pending_outlined = IconData(0xe341, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pending</i> &#x2014; material icon named "pending rounded".
  static const IconData pending_rounded = IconData(0xf374, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pending</i> &#x2014; material icon named "pending sharp".
  static const IconData pending_sharp = IconData(0xee46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">people</i> &#x2014; material icon named "people".
  static const IconData people = IconData(0xe8f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">people_alt</i> &#x2014; material icon named "people alt".
  static const IconData people_alt = IconData(0xe8f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">people_alt</i> &#x2014; material icon named "people alt outlined".
  static const IconData people_alt_outlined = IconData(0xe342, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">people_alt</i> &#x2014; material icon named "people alt rounded".
  static const IconData people_alt_rounded = IconData(0xf375, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">people_alt</i> &#x2014; material icon named "people alt sharp".
  static const IconData people_alt_sharp = IconData(0xee47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">people_outline</i> &#x2014; material icon named "people outline".
  static const IconData people_outline = IconData(0xe8f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">people_outline</i> &#x2014; material icon named "people outline outlined".
  static const IconData people_outline_outlined = IconData(0xe343, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">people_outline</i> &#x2014; material icon named "people outline rounded".
  static const IconData people_outline_rounded = IconData(0xf376, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">people_outline</i> &#x2014; material icon named "people outline sharp".
  static const IconData people_outline_sharp = IconData(0xee48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">people</i> &#x2014; material icon named "people outlined".
  static const IconData people_outlined = IconData(0xe344, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">people</i> &#x2014; material icon named "people rounded".
  static const IconData people_rounded = IconData(0xf377, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">people</i> &#x2014; material icon named "people sharp".
  static const IconData people_sharp = IconData(0xee49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_camera_mic</i> &#x2014; material icon named "perm camera mic".
  static const IconData perm_camera_mic = IconData(0xe8f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_camera_mic</i> &#x2014; material icon named "perm camera mic outlined".
  static const IconData perm_camera_mic_outlined = IconData(0xe345, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_camera_mic</i> &#x2014; material icon named "perm camera mic rounded".
  static const IconData perm_camera_mic_rounded = IconData(0xf378, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_camera_mic</i> &#x2014; material icon named "perm camera mic sharp".
  static const IconData perm_camera_mic_sharp = IconData(0xee4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_contact_cal</i> &#x2014; material icon named "perm contact cal".
  static const IconData perm_contact_cal = IconData(0xe8f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_contact_cal</i> &#x2014; material icon named "perm contact cal outlined".
  static const IconData perm_contact_cal_outlined = IconData(0xe346, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_contact_cal</i> &#x2014; material icon named "perm contact cal rounded".
  static const IconData perm_contact_cal_rounded = IconData(0xf379, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_contact_cal</i> &#x2014; material icon named "perm contact cal sharp".
  static const IconData perm_contact_cal_sharp = IconData(0xee4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_contact_calendar</i> &#x2014; material icon named "perm contact calendar".
  static const IconData perm_contact_calendar = IconData(0xe8f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_contact_calendar</i> &#x2014; material icon named "perm contact calendar outlined".
  static const IconData perm_contact_calendar_outlined = IconData(0xe346, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_contact_calendar</i> &#x2014; material icon named "perm contact calendar rounded".
  static const IconData perm_contact_calendar_rounded = IconData(0xf379, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_contact_calendar</i> &#x2014; material icon named "perm contact calendar sharp".
  static const IconData perm_contact_calendar_sharp = IconData(0xee4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_data_setting</i> &#x2014; material icon named "perm data setting".
  static const IconData perm_data_setting = IconData(0xe8fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_data_setting</i> &#x2014; material icon named "perm data setting outlined".
  static const IconData perm_data_setting_outlined = IconData(0xe347, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_data_setting</i> &#x2014; material icon named "perm data setting rounded".
  static const IconData perm_data_setting_rounded = IconData(0xf37a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_data_setting</i> &#x2014; material icon named "perm data setting sharp".
  static const IconData perm_data_setting_sharp = IconData(0xee4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_device_info</i> &#x2014; material icon named "perm device info".
  static const IconData perm_device_info = IconData(0xe8fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_device_info</i> &#x2014; material icon named "perm device info outlined".
  static const IconData perm_device_info_outlined = IconData(0xe348, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_device_info</i> &#x2014; material icon named "perm device info rounded".
  static const IconData perm_device_info_rounded = IconData(0xf37b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_device_info</i> &#x2014; material icon named "perm device info sharp".
  static const IconData perm_device_info_sharp = IconData(0xee4d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_device_information</i> &#x2014; material icon named "perm device information".
  static const IconData perm_device_information = IconData(0xe8fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_device_information</i> &#x2014; material icon named "perm device information outlined".
  static const IconData perm_device_information_outlined = IconData(0xe348, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_device_information</i> &#x2014; material icon named "perm device information rounded".
  static const IconData perm_device_information_rounded = IconData(0xf37b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_device_information</i> &#x2014; material icon named "perm device information sharp".
  static const IconData perm_device_information_sharp = IconData(0xee4d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_identity</i> &#x2014; material icon named "perm identity".
  static const IconData perm_identity = IconData(0xe8fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_identity</i> &#x2014; material icon named "perm identity outlined".
  static const IconData perm_identity_outlined = IconData(0xe349, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_identity</i> &#x2014; material icon named "perm identity rounded".
  static const IconData perm_identity_rounded = IconData(0xf37c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_identity</i> &#x2014; material icon named "perm identity sharp".
  static const IconData perm_identity_sharp = IconData(0xee4e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_media</i> &#x2014; material icon named "perm media".
  static const IconData perm_media = IconData(0xe8fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_media</i> &#x2014; material icon named "perm media outlined".
  static const IconData perm_media_outlined = IconData(0xe34a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_media</i> &#x2014; material icon named "perm media rounded".
  static const IconData perm_media_rounded = IconData(0xf37d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_media</i> &#x2014; material icon named "perm media sharp".
  static const IconData perm_media_sharp = IconData(0xee4f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_phone_msg</i> &#x2014; material icon named "perm phone msg".
  static const IconData perm_phone_msg = IconData(0xe8fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_phone_msg</i> &#x2014; material icon named "perm phone msg outlined".
  static const IconData perm_phone_msg_outlined = IconData(0xe34b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_phone_msg</i> &#x2014; material icon named "perm phone msg rounded".
  static const IconData perm_phone_msg_rounded = IconData(0xf37e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_phone_msg</i> &#x2014; material icon named "perm phone msg sharp".
  static const IconData perm_phone_msg_sharp = IconData(0xee50, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_scan_wifi</i> &#x2014; material icon named "perm scan wifi".
  static const IconData perm_scan_wifi = IconData(0xe8ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_scan_wifi</i> &#x2014; material icon named "perm scan wifi outlined".
  static const IconData perm_scan_wifi_outlined = IconData(0xe34c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_scan_wifi</i> &#x2014; material icon named "perm scan wifi rounded".
  static const IconData perm_scan_wifi_rounded = IconData(0xf37f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_scan_wifi</i> &#x2014; material icon named "perm scan wifi sharp".
  static const IconData perm_scan_wifi_sharp = IconData(0xee51, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person</i> &#x2014; material icon named "person".
  static const IconData person = IconData(0xe900, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_add</i> &#x2014; material icon named "person add".
  static const IconData person_add = IconData(0xe901, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_add_alt</i> &#x2014; material icon named "person add alt".
  static const IconData person_add_alt = IconData(0xe902, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_add_alt_1</i> &#x2014; material icon named "person add alt 1".
  static const IconData person_add_alt_1 = IconData(0xe903, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_add_alt_1</i> &#x2014; material icon named "person add alt 1 outlined".
  static const IconData person_add_alt_1_outlined = IconData(0xe34d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_add_alt_1</i> &#x2014; material icon named "person add alt 1 rounded".
  static const IconData person_add_alt_1_rounded = IconData(0xf380, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_add_alt_1</i> &#x2014; material icon named "person add alt 1 sharp".
  static const IconData person_add_alt_1_sharp = IconData(0xee52, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_add_disabled</i> &#x2014; material icon named "person add disabled".
  static const IconData person_add_disabled = IconData(0xe904, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_add_disabled</i> &#x2014; material icon named "person add disabled outlined".
  static const IconData person_add_disabled_outlined = IconData(0xe34e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_add_disabled</i> &#x2014; material icon named "person add disabled rounded".
  static const IconData person_add_disabled_rounded = IconData(0xf381, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_add_disabled</i> &#x2014; material icon named "person add disabled sharp".
  static const IconData person_add_disabled_sharp = IconData(0xee53, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_add</i> &#x2014; material icon named "person add outlined".
  static const IconData person_add_outlined = IconData(0xe34f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_add</i> &#x2014; material icon named "person add rounded".
  static const IconData person_add_rounded = IconData(0xf382, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_add</i> &#x2014; material icon named "person add sharp".
  static const IconData person_add_sharp = IconData(0xee54, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_outline</i> &#x2014; material icon named "person outline".
  static const IconData person_outline = IconData(0xe905, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_outline</i> &#x2014; material icon named "person outline outlined".
  static const IconData person_outline_outlined = IconData(0xe350, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_outline</i> &#x2014; material icon named "person outline rounded".
  static const IconData person_outline_rounded = IconData(0xf383, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_outline</i> &#x2014; material icon named "person outline sharp".
  static const IconData person_outline_sharp = IconData(0xee55, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person</i> &#x2014; material icon named "person outlined".
  static const IconData person_outlined = IconData(0xe351, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_pin</i> &#x2014; material icon named "person pin".
  static const IconData person_pin = IconData(0xe906, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_pin_circle</i> &#x2014; material icon named "person pin circle".
  static const IconData person_pin_circle = IconData(0xe907, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_pin_circle</i> &#x2014; material icon named "person pin circle outlined".
  static const IconData person_pin_circle_outlined = IconData(0xe352, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_pin_circle</i> &#x2014; material icon named "person pin circle rounded".
  static const IconData person_pin_circle_rounded = IconData(0xf384, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_pin_circle</i> &#x2014; material icon named "person pin circle sharp".
  static const IconData person_pin_circle_sharp = IconData(0xee56, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_pin</i> &#x2014; material icon named "person pin outlined".
  static const IconData person_pin_outlined = IconData(0xe353, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_pin</i> &#x2014; material icon named "person pin rounded".
  static const IconData person_pin_rounded = IconData(0xf385, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_pin</i> &#x2014; material icon named "person pin sharp".
  static const IconData person_pin_sharp = IconData(0xee57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_remove</i> &#x2014; material icon named "person remove".
  static const IconData person_remove = IconData(0xe908, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_remove_alt_1</i> &#x2014; material icon named "person remove alt 1".
  static const IconData person_remove_alt_1 = IconData(0xe909, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_remove_alt_1</i> &#x2014; material icon named "person remove alt 1 outlined".
  static const IconData person_remove_alt_1_outlined = IconData(0xe354, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_remove_alt_1</i> &#x2014; material icon named "person remove alt 1 rounded".
  static const IconData person_remove_alt_1_rounded = IconData(0xf386, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_remove_alt_1</i> &#x2014; material icon named "person remove alt 1 sharp".
  static const IconData person_remove_alt_1_sharp = IconData(0xee58, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_remove</i> &#x2014; material icon named "person remove outlined".
  static const IconData person_remove_outlined = IconData(0xe355, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_remove</i> &#x2014; material icon named "person remove rounded".
  static const IconData person_remove_rounded = IconData(0xf387, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_remove</i> &#x2014; material icon named "person remove sharp".
  static const IconData person_remove_sharp = IconData(0xee59, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person</i> &#x2014; material icon named "person rounded".
  static const IconData person_rounded = IconData(0xf388, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_search</i> &#x2014; material icon named "person search".
  static const IconData person_search = IconData(0xe90a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_search</i> &#x2014; material icon named "person search outlined".
  static const IconData person_search_outlined = IconData(0xe356, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_search</i> &#x2014; material icon named "person search rounded".
  static const IconData person_search_rounded = IconData(0xf389, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_search</i> &#x2014; material icon named "person search sharp".
  static const IconData person_search_sharp = IconData(0xee5a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person</i> &#x2014; material icon named "person sharp".
  static const IconData person_sharp = IconData(0xee5b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">personal_video</i> &#x2014; material icon named "personal video".
  static const IconData personal_video = IconData(0xe90b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">personal_video</i> &#x2014; material icon named "personal video outlined".
  static const IconData personal_video_outlined = IconData(0xe357, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">personal_video</i> &#x2014; material icon named "personal video rounded".
  static const IconData personal_video_rounded = IconData(0xf38a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">personal_video</i> &#x2014; material icon named "personal video sharp".
  static const IconData personal_video_sharp = IconData(0xee5c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pest_control</i> &#x2014; material icon named "pest control".
  static const IconData pest_control = IconData(0xe90c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pest_control</i> &#x2014; material icon named "pest control outlined".
  static const IconData pest_control_outlined = IconData(0xe358, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pest_control_rodent</i> &#x2014; material icon named "pest control rodent".
  static const IconData pest_control_rodent = IconData(0xe90d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pest_control_rodent</i> &#x2014; material icon named "pest control rodent outlined".
  static const IconData pest_control_rodent_outlined = IconData(0xe359, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pest_control_rodent</i> &#x2014; material icon named "pest control rodent rounded".
  static const IconData pest_control_rodent_rounded = IconData(0xf38b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pest_control_rodent</i> &#x2014; material icon named "pest control rodent sharp".
  static const IconData pest_control_rodent_sharp = IconData(0xee5d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pest_control</i> &#x2014; material icon named "pest control rounded".
  static const IconData pest_control_rounded = IconData(0xf38c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pest_control</i> &#x2014; material icon named "pest control sharp".
  static const IconData pest_control_sharp = IconData(0xee5e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pets</i> &#x2014; material icon named "pets".
  static const IconData pets = IconData(0xe90e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pets</i> &#x2014; material icon named "pets outlined".
  static const IconData pets_outlined = IconData(0xe35a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pets</i> &#x2014; material icon named "pets rounded".
  static const IconData pets_rounded = IconData(0xf38d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pets</i> &#x2014; material icon named "pets sharp".
  static const IconData pets_sharp = IconData(0xee5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone</i> &#x2014; material icon named "phone".
  static const IconData phone = IconData(0xe90f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_android</i> &#x2014; material icon named "phone android".
  static const IconData phone_android = IconData(0xe910, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_android</i> &#x2014; material icon named "phone android outlined".
  static const IconData phone_android_outlined = IconData(0xe35b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_android</i> &#x2014; material icon named "phone android rounded".
  static const IconData phone_android_rounded = IconData(0xf38e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_android</i> &#x2014; material icon named "phone android sharp".
  static const IconData phone_android_sharp = IconData(0xee60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_bluetooth_speaker</i> &#x2014; material icon named "phone bluetooth speaker".
  static const IconData phone_bluetooth_speaker = IconData(0xe911, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_bluetooth_speaker</i> &#x2014; material icon named "phone bluetooth speaker outlined".
  static const IconData phone_bluetooth_speaker_outlined = IconData(0xe35c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_bluetooth_speaker</i> &#x2014; material icon named "phone bluetooth speaker rounded".
  static const IconData phone_bluetooth_speaker_rounded = IconData(0xf38f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_bluetooth_speaker</i> &#x2014; material icon named "phone bluetooth speaker sharp".
  static const IconData phone_bluetooth_speaker_sharp = IconData(0xee61, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_callback</i> &#x2014; material icon named "phone callback".
  static const IconData phone_callback = IconData(0xe912, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_callback</i> &#x2014; material icon named "phone callback outlined".
  static const IconData phone_callback_outlined = IconData(0xe35d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_callback</i> &#x2014; material icon named "phone callback rounded".
  static const IconData phone_callback_rounded = IconData(0xf390, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_callback</i> &#x2014; material icon named "phone callback sharp".
  static const IconData phone_callback_sharp = IconData(0xee62, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_disabled</i> &#x2014; material icon named "phone disabled".
  static const IconData phone_disabled = IconData(0xe913, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_disabled</i> &#x2014; material icon named "phone disabled outlined".
  static const IconData phone_disabled_outlined = IconData(0xe35e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_disabled</i> &#x2014; material icon named "phone disabled rounded".
  static const IconData phone_disabled_rounded = IconData(0xf391, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_disabled</i> &#x2014; material icon named "phone disabled sharp".
  static const IconData phone_disabled_sharp = IconData(0xee63, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_enabled</i> &#x2014; material icon named "phone enabled".
  static const IconData phone_enabled = IconData(0xe914, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_enabled</i> &#x2014; material icon named "phone enabled outlined".
  static const IconData phone_enabled_outlined = IconData(0xe35f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_enabled</i> &#x2014; material icon named "phone enabled rounded".
  static const IconData phone_enabled_rounded = IconData(0xf392, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_enabled</i> &#x2014; material icon named "phone enabled sharp".
  static const IconData phone_enabled_sharp = IconData(0xee64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_forwarded</i> &#x2014; material icon named "phone forwarded".
  static const IconData phone_forwarded = IconData(0xe915, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_forwarded</i> &#x2014; material icon named "phone forwarded outlined".
  static const IconData phone_forwarded_outlined = IconData(0xe360, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_forwarded</i> &#x2014; material icon named "phone forwarded rounded".
  static const IconData phone_forwarded_rounded = IconData(0xf393, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_forwarded</i> &#x2014; material icon named "phone forwarded sharp".
  static const IconData phone_forwarded_sharp = IconData(0xee65, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_in_talk</i> &#x2014; material icon named "phone in talk".
  static const IconData phone_in_talk = IconData(0xe916, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_in_talk</i> &#x2014; material icon named "phone in talk outlined".
  static const IconData phone_in_talk_outlined = IconData(0xe361, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_in_talk</i> &#x2014; material icon named "phone in talk rounded".
  static const IconData phone_in_talk_rounded = IconData(0xf394, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_in_talk</i> &#x2014; material icon named "phone in talk sharp".
  static const IconData phone_in_talk_sharp = IconData(0xee66, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_iphone</i> &#x2014; material icon named "phone iphone".
  static const IconData phone_iphone = IconData(0xe917, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_iphone</i> &#x2014; material icon named "phone iphone outlined".
  static const IconData phone_iphone_outlined = IconData(0xe362, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_iphone</i> &#x2014; material icon named "phone iphone rounded".
  static const IconData phone_iphone_rounded = IconData(0xf395, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_iphone</i> &#x2014; material icon named "phone iphone sharp".
  static const IconData phone_iphone_sharp = IconData(0xee67, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_locked</i> &#x2014; material icon named "phone locked".
  static const IconData phone_locked = IconData(0xe918, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_locked</i> &#x2014; material icon named "phone locked outlined".
  static const IconData phone_locked_outlined = IconData(0xe363, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_locked</i> &#x2014; material icon named "phone locked rounded".
  static const IconData phone_locked_rounded = IconData(0xf396, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_locked</i> &#x2014; material icon named "phone locked sharp".
  static const IconData phone_locked_sharp = IconData(0xee68, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_missed</i> &#x2014; material icon named "phone missed".
  static const IconData phone_missed = IconData(0xe919, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_missed</i> &#x2014; material icon named "phone missed outlined".
  static const IconData phone_missed_outlined = IconData(0xe364, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_missed</i> &#x2014; material icon named "phone missed rounded".
  static const IconData phone_missed_rounded = IconData(0xf397, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_missed</i> &#x2014; material icon named "phone missed sharp".
  static const IconData phone_missed_sharp = IconData(0xee69, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone</i> &#x2014; material icon named "phone outlined".
  static const IconData phone_outlined = IconData(0xe365, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_paused</i> &#x2014; material icon named "phone paused".
  static const IconData phone_paused = IconData(0xe91a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phone_paused</i> &#x2014; material icon named "phone paused outlined".
  static const IconData phone_paused_outlined = IconData(0xe366, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone_paused</i> &#x2014; material icon named "phone paused rounded".
  static const IconData phone_paused_rounded = IconData(0xf398, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone_paused</i> &#x2014; material icon named "phone paused sharp".
  static const IconData phone_paused_sharp = IconData(0xee6a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phone</i> &#x2014; material icon named "phone rounded".
  static const IconData phone_rounded = IconData(0xf399, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phone</i> &#x2014; material icon named "phone sharp".
  static const IconData phone_sharp = IconData(0xee6b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink</i> &#x2014; material icon named "phonelink".
  static const IconData phonelink = IconData(0xe91b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_erase</i> &#x2014; material icon named "phonelink erase".
  static const IconData phonelink_erase = IconData(0xe91c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phonelink_erase</i> &#x2014; material icon named "phonelink erase outlined".
  static const IconData phonelink_erase_outlined = IconData(0xe367, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phonelink_erase</i> &#x2014; material icon named "phonelink erase rounded".
  static const IconData phonelink_erase_rounded = IconData(0xf39a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phonelink_erase</i> &#x2014; material icon named "phonelink erase sharp".
  static const IconData phonelink_erase_sharp = IconData(0xee6c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_lock</i> &#x2014; material icon named "phonelink lock".
  static const IconData phonelink_lock = IconData(0xe91d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phonelink_lock</i> &#x2014; material icon named "phonelink lock outlined".
  static const IconData phonelink_lock_outlined = IconData(0xe368, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phonelink_lock</i> &#x2014; material icon named "phonelink lock rounded".
  static const IconData phonelink_lock_rounded = IconData(0xf39b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phonelink_lock</i> &#x2014; material icon named "phonelink lock sharp".
  static const IconData phonelink_lock_sharp = IconData(0xee6d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_off</i> &#x2014; material icon named "phonelink off".
  static const IconData phonelink_off = IconData(0xe91e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phonelink_off</i> &#x2014; material icon named "phonelink off outlined".
  static const IconData phonelink_off_outlined = IconData(0xe369, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phonelink_off</i> &#x2014; material icon named "phonelink off rounded".
  static const IconData phonelink_off_rounded = IconData(0xf39c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phonelink_off</i> &#x2014; material icon named "phonelink off sharp".
  static const IconData phonelink_off_sharp = IconData(0xee6e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phonelink</i> &#x2014; material icon named "phonelink outlined".
  static const IconData phonelink_outlined = IconData(0xe36a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_ring</i> &#x2014; material icon named "phonelink ring".
  static const IconData phonelink_ring = IconData(0xe91f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phonelink_ring</i> &#x2014; material icon named "phonelink ring outlined".
  static const IconData phonelink_ring_outlined = IconData(0xe36b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phonelink_ring</i> &#x2014; material icon named "phonelink ring rounded".
  static const IconData phonelink_ring_rounded = IconData(0xf39d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phonelink_ring</i> &#x2014; material icon named "phonelink ring sharp".
  static const IconData phonelink_ring_sharp = IconData(0xee6f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phonelink</i> &#x2014; material icon named "phonelink rounded".
  static const IconData phonelink_rounded = IconData(0xf39e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_setup</i> &#x2014; material icon named "phonelink setup".
  static const IconData phonelink_setup = IconData(0xe920, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">phonelink_setup</i> &#x2014; material icon named "phonelink setup outlined".
  static const IconData phonelink_setup_outlined = IconData(0xe36c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">phonelink_setup</i> &#x2014; material icon named "phonelink setup rounded".
  static const IconData phonelink_setup_rounded = IconData(0xf39f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phonelink_setup</i> &#x2014; material icon named "phonelink setup sharp".
  static const IconData phonelink_setup_sharp = IconData(0xee70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">phonelink</i> &#x2014; material icon named "phonelink sharp".
  static const IconData phonelink_sharp = IconData(0xee71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo</i> &#x2014; material icon named "photo".
  static const IconData photo = IconData(0xe921, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_album</i> &#x2014; material icon named "photo album".
  static const IconData photo_album = IconData(0xe922, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">photo_album</i> &#x2014; material icon named "photo album outlined".
  static const IconData photo_album_outlined = IconData(0xe36d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">photo_album</i> &#x2014; material icon named "photo album rounded".
  static const IconData photo_album_rounded = IconData(0xf3a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">photo_album</i> &#x2014; material icon named "photo album sharp".
  static const IconData photo_album_sharp = IconData(0xee72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_camera</i> &#x2014; material icon named "photo camera".
  static const IconData photo_camera = IconData(0xe923, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_camera_back</i> &#x2014; material icon named "photo camera back".
  static const IconData photo_camera_back = IconData(0xe924, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_camera_front</i> &#x2014; material icon named "photo camera front".
  static const IconData photo_camera_front = IconData(0xe925, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">photo_camera</i> &#x2014; material icon named "photo camera outlined".
  static const IconData photo_camera_outlined = IconData(0xe36e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">photo_camera</i> &#x2014; material icon named "photo camera rounded".
  static const IconData photo_camera_rounded = IconData(0xf3a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">photo_camera</i> &#x2014; material icon named "photo camera sharp".
  static const IconData photo_camera_sharp = IconData(0xee73, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_filter</i> &#x2014; material icon named "photo filter".
  static const IconData photo_filter = IconData(0xe926, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">photo_filter</i> &#x2014; material icon named "photo filter outlined".
  static const IconData photo_filter_outlined = IconData(0xe36f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">photo_filter</i> &#x2014; material icon named "photo filter rounded".
  static const IconData photo_filter_rounded = IconData(0xf3a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">photo_filter</i> &#x2014; material icon named "photo filter sharp".
  static const IconData photo_filter_sharp = IconData(0xee74, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_library</i> &#x2014; material icon named "photo library".
  static const IconData photo_library = IconData(0xe927, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">photo_library</i> &#x2014; material icon named "photo library outlined".
  static const IconData photo_library_outlined = IconData(0xe370, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">photo_library</i> &#x2014; material icon named "photo library rounded".
  static const IconData photo_library_rounded = IconData(0xf3a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">photo_library</i> &#x2014; material icon named "photo library sharp".
  static const IconData photo_library_sharp = IconData(0xee75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">photo</i> &#x2014; material icon named "photo outlined".
  static const IconData photo_outlined = IconData(0xe371, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">photo</i> &#x2014; material icon named "photo rounded".
  static const IconData photo_rounded = IconData(0xf3a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">photo</i> &#x2014; material icon named "photo sharp".
  static const IconData photo_sharp = IconData(0xee76, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_size_select_actual</i> &#x2014; material icon named "photo size select actual".
  static const IconData photo_size_select_actual = IconData(0xe928, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">photo_size_select_actual</i> &#x2014; material icon named "photo size select actual outlined".
  static const IconData photo_size_select_actual_outlined = IconData(0xe372, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">photo_size_select_actual</i> &#x2014; material icon named "photo size select actual rounded".
  static const IconData photo_size_select_actual_rounded = IconData(0xf3a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">photo_size_select_actual</i> &#x2014; material icon named "photo size select actual sharp".
  static const IconData photo_size_select_actual_sharp = IconData(0xee77, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_size_select_large</i> &#x2014; material icon named "photo size select large".
  static const IconData photo_size_select_large = IconData(0xe929, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">photo_size_select_large</i> &#x2014; material icon named "photo size select large outlined".
  static const IconData photo_size_select_large_outlined = IconData(0xe373, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">photo_size_select_large</i> &#x2014; material icon named "photo size select large rounded".
  static const IconData photo_size_select_large_rounded = IconData(0xf3a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">photo_size_select_large</i> &#x2014; material icon named "photo size select large sharp".
  static const IconData photo_size_select_large_sharp = IconData(0xee78, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_size_select_small</i> &#x2014; material icon named "photo size select small".
  static const IconData photo_size_select_small = IconData(0xe92a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">photo_size_select_small</i> &#x2014; material icon named "photo size select small outlined".
  static const IconData photo_size_select_small_outlined = IconData(0xe374, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">photo_size_select_small</i> &#x2014; material icon named "photo size select small rounded".
  static const IconData photo_size_select_small_rounded = IconData(0xf3a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">photo_size_select_small</i> &#x2014; material icon named "photo size select small sharp".
  static const IconData photo_size_select_small_sharp = IconData(0xee79, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">picture_as_pdf</i> &#x2014; material icon named "picture as pdf".
  static const IconData picture_as_pdf = IconData(0xe92b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">picture_as_pdf</i> &#x2014; material icon named "picture as pdf outlined".
  static const IconData picture_as_pdf_outlined = IconData(0xe375, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">picture_as_pdf</i> &#x2014; material icon named "picture as pdf rounded".
  static const IconData picture_as_pdf_rounded = IconData(0xf3a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">picture_as_pdf</i> &#x2014; material icon named "picture as pdf sharp".
  static const IconData picture_as_pdf_sharp = IconData(0xee7a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">picture_in_picture</i> &#x2014; material icon named "picture in picture".
  static const IconData picture_in_picture = IconData(0xe92c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">picture_in_picture_alt</i> &#x2014; material icon named "picture in picture alt".
  static const IconData picture_in_picture_alt = IconData(0xe92d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">picture_in_picture_alt</i> &#x2014; material icon named "picture in picture alt outlined".
  static const IconData picture_in_picture_alt_outlined = IconData(0xe376, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">picture_in_picture_alt</i> &#x2014; material icon named "picture in picture alt rounded".
  static const IconData picture_in_picture_alt_rounded = IconData(0xf3a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">picture_in_picture_alt</i> &#x2014; material icon named "picture in picture alt sharp".
  static const IconData picture_in_picture_alt_sharp = IconData(0xee7b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">picture_in_picture</i> &#x2014; material icon named "picture in picture outlined".
  static const IconData picture_in_picture_outlined = IconData(0xe377, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">picture_in_picture</i> &#x2014; material icon named "picture in picture rounded".
  static const IconData picture_in_picture_rounded = IconData(0xf3aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">picture_in_picture</i> &#x2014; material icon named "picture in picture sharp".
  static const IconData picture_in_picture_sharp = IconData(0xee7c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pie_chart</i> &#x2014; material icon named "pie chart".
  static const IconData pie_chart = IconData(0xe92e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pie_chart_outline</i> &#x2014; material icon named "pie chart outline outlined".
  static const IconData pie_chart_outline_outlined = IconData(0xe378, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pie_chart_outline</i> &#x2014; material icon named "pie chart outline rounded".
  static const IconData pie_chart_outline_rounded = IconData(0xf3ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pie_chart_outline</i> &#x2014; material icon named "pie chart outline sharp".
  static const IconData pie_chart_outline_sharp = IconData(0xee7d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pie_chart</i> &#x2014; material icon named "pie chart outlined".
  static const IconData pie_chart_outlined = IconData(0xe379, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pie_chart</i> &#x2014; material icon named "pie chart rounded".
  static const IconData pie_chart_rounded = IconData(0xf3ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pie_chart</i> &#x2014; material icon named "pie chart sharp".
  static const IconData pie_chart_sharp = IconData(0xee7e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pin_drop</i> &#x2014; material icon named "pin drop".
  static const IconData pin_drop = IconData(0xe930, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pin_drop</i> &#x2014; material icon named "pin drop outlined".
  static const IconData pin_drop_outlined = IconData(0xe37a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pin_drop</i> &#x2014; material icon named "pin drop rounded".
  static const IconData pin_drop_rounded = IconData(0xf3ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pin_drop</i> &#x2014; material icon named "pin drop sharp".
  static const IconData pin_drop_sharp = IconData(0xee7f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pivot_table_chart</i> &#x2014; material icon named "pivot table chart".
  static const IconData pivot_table_chart = IconData(0xe931, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">place</i> &#x2014; material icon named "place".
  static const IconData place = IconData(0xe932, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">place</i> &#x2014; material icon named "place outlined".
  static const IconData place_outlined = IconData(0xe37b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">place</i> &#x2014; material icon named "place rounded".
  static const IconData place_rounded = IconData(0xf3ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">place</i> &#x2014; material icon named "place sharp".
  static const IconData place_sharp = IconData(0xee80, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">plagiarism</i> &#x2014; material icon named "plagiarism".
  static const IconData plagiarism = IconData(0xe933, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">plagiarism</i> &#x2014; material icon named "plagiarism outlined".
  static const IconData plagiarism_outlined = IconData(0xe37c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">plagiarism</i> &#x2014; material icon named "plagiarism rounded".
  static const IconData plagiarism_rounded = IconData(0xf3af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">plagiarism</i> &#x2014; material icon named "plagiarism sharp".
  static const IconData plagiarism_sharp = IconData(0xee81, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_arrow</i> &#x2014; material icon named "play arrow".
  static const IconData play_arrow = IconData(0xe934, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">play_arrow</i> &#x2014; material icon named "play arrow outlined".
  static const IconData play_arrow_outlined = IconData(0xe37d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">play_arrow</i> &#x2014; material icon named "play arrow rounded".
  static const IconData play_arrow_rounded = IconData(0xf3b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">play_arrow</i> &#x2014; material icon named "play arrow sharp".
  static const IconData play_arrow_sharp = IconData(0xee82, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_circle_fill</i> &#x2014; material icon named "play circle fill".
  static const IconData play_circle_fill = IconData(0xe935, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">play_circle_fill</i> &#x2014; material icon named "play circle fill outlined".
  static const IconData play_circle_fill_outlined = IconData(0xe37e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">play_circle_fill</i> &#x2014; material icon named "play circle fill rounded".
  static const IconData play_circle_fill_rounded = IconData(0xf3b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">play_circle_fill</i> &#x2014; material icon named "play circle fill sharp".
  static const IconData play_circle_fill_sharp = IconData(0xee83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_circle_filled</i> &#x2014; material icon named "play circle filled".
  static const IconData play_circle_filled = IconData(0xe935, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">play_circle_filled</i> &#x2014; material icon named "play circle filled outlined".
  static const IconData play_circle_filled_outlined = IconData(0xe37e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">play_circle_filled</i> &#x2014; material icon named "play circle filled rounded".
  static const IconData play_circle_filled_rounded = IconData(0xf3b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">play_circle_filled</i> &#x2014; material icon named "play circle filled sharp".
  static const IconData play_circle_filled_sharp = IconData(0xee83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_circle_outline</i> &#x2014; material icon named "play circle outline".
  static const IconData play_circle_outline = IconData(0xe936, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">play_circle_outline</i> &#x2014; material icon named "play circle outline outlined".
  static const IconData play_circle_outline_outlined = IconData(0xe37f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">play_circle_outline</i> &#x2014; material icon named "play circle outline rounded".
  static const IconData play_circle_outline_rounded = IconData(0xf3b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">play_circle_outline</i> &#x2014; material icon named "play circle outline sharp".
  static const IconData play_circle_outline_sharp = IconData(0xee84, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_disabled</i> &#x2014; material icon named "play disabled".
  static const IconData play_disabled = IconData(0xe937, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_for_work</i> &#x2014; material icon named "play for work".
  static const IconData play_for_work = IconData(0xe938, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">play_for_work</i> &#x2014; material icon named "play for work outlined".
  static const IconData play_for_work_outlined = IconData(0xe380, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">play_for_work</i> &#x2014; material icon named "play for work rounded".
  static const IconData play_for_work_rounded = IconData(0xf3b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">play_for_work</i> &#x2014; material icon named "play for work sharp".
  static const IconData play_for_work_sharp = IconData(0xee85, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">playlist_add</i> &#x2014; material icon named "playlist add".
  static const IconData playlist_add = IconData(0xe939, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">playlist_add_check</i> &#x2014; material icon named "playlist add check".
  static const IconData playlist_add_check = IconData(0xe93a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">playlist_add_check</i> &#x2014; material icon named "playlist add check outlined".
  static const IconData playlist_add_check_outlined = IconData(0xe381, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">playlist_add_check</i> &#x2014; material icon named "playlist add check rounded".
  static const IconData playlist_add_check_rounded = IconData(0xf3b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">playlist_add_check</i> &#x2014; material icon named "playlist add check sharp".
  static const IconData playlist_add_check_sharp = IconData(0xee86, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">playlist_add</i> &#x2014; material icon named "playlist add outlined".
  static const IconData playlist_add_outlined = IconData(0xe382, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">playlist_add</i> &#x2014; material icon named "playlist add rounded".
  static const IconData playlist_add_rounded = IconData(0xf3b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">playlist_add</i> &#x2014; material icon named "playlist add sharp".
  static const IconData playlist_add_sharp = IconData(0xee87, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">playlist_play</i> &#x2014; material icon named "playlist play".
  static const IconData playlist_play = IconData(0xe93b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">playlist_play</i> &#x2014; material icon named "playlist play outlined".
  static const IconData playlist_play_outlined = IconData(0xe383, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">playlist_play</i> &#x2014; material icon named "playlist play rounded".
  static const IconData playlist_play_rounded = IconData(0xf3b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">playlist_play</i> &#x2014; material icon named "playlist play sharp".
  static const IconData playlist_play_sharp = IconData(0xee88, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">plumbing</i> &#x2014; material icon named "plumbing".
  static const IconData plumbing = IconData(0xe93c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">plumbing</i> &#x2014; material icon named "plumbing outlined".
  static const IconData plumbing_outlined = IconData(0xe384, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">plumbing</i> &#x2014; material icon named "plumbing rounded".
  static const IconData plumbing_rounded = IconData(0xf3b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">plumbing</i> &#x2014; material icon named "plumbing sharp".
  static const IconData plumbing_sharp = IconData(0xee89, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">plus_one</i> &#x2014; material icon named "plus one".
  static const IconData plus_one = IconData(0xe93d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">plus_one</i> &#x2014; material icon named "plus one outlined".
  static const IconData plus_one_outlined = IconData(0xe385, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">plus_one</i> &#x2014; material icon named "plus one rounded".
  static const IconData plus_one_rounded = IconData(0xf3b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">plus_one</i> &#x2014; material icon named "plus one sharp".
  static const IconData plus_one_sharp = IconData(0xee8a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">point_of_sale</i> &#x2014; material icon named "point of sale".
  static const IconData point_of_sale = IconData(0xe93e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">point_of_sale</i> &#x2014; material icon named "point of sale outlined".
  static const IconData point_of_sale_outlined = IconData(0xe386, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">point_of_sale</i> &#x2014; material icon named "point of sale rounded".
  static const IconData point_of_sale_rounded = IconData(0xf3b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">point_of_sale</i> &#x2014; material icon named "point of sale sharp".
  static const IconData point_of_sale_sharp = IconData(0xee8b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">policy</i> &#x2014; material icon named "policy".
  static const IconData policy = IconData(0xe93f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">policy</i> &#x2014; material icon named "policy outlined".
  static const IconData policy_outlined = IconData(0xe387, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">policy</i> &#x2014; material icon named "policy rounded".
  static const IconData policy_rounded = IconData(0xf3ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">policy</i> &#x2014; material icon named "policy sharp".
  static const IconData policy_sharp = IconData(0xee8c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">poll</i> &#x2014; material icon named "poll".
  static const IconData poll = IconData(0xe940, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">poll</i> &#x2014; material icon named "poll outlined".
  static const IconData poll_outlined = IconData(0xe388, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">poll</i> &#x2014; material icon named "poll rounded".
  static const IconData poll_rounded = IconData(0xf3bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">poll</i> &#x2014; material icon named "poll sharp".
  static const IconData poll_sharp = IconData(0xee8d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">polymer</i> &#x2014; material icon named "polymer".
  static const IconData polymer = IconData(0xe941, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">polymer</i> &#x2014; material icon named "polymer outlined".
  static const IconData polymer_outlined = IconData(0xe389, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">polymer</i> &#x2014; material icon named "polymer rounded".
  static const IconData polymer_rounded = IconData(0xf3bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">polymer</i> &#x2014; material icon named "polymer sharp".
  static const IconData polymer_sharp = IconData(0xee8e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pool</i> &#x2014; material icon named "pool".
  static const IconData pool = IconData(0xe942, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pool</i> &#x2014; material icon named "pool outlined".
  static const IconData pool_outlined = IconData(0xe38a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pool</i> &#x2014; material icon named "pool rounded".
  static const IconData pool_rounded = IconData(0xf3bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pool</i> &#x2014; material icon named "pool sharp".
  static const IconData pool_sharp = IconData(0xee8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">portable_wifi_off</i> &#x2014; material icon named "portable wifi off".
  static const IconData portable_wifi_off = IconData(0xe943, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">portable_wifi_off</i> &#x2014; material icon named "portable wifi off outlined".
  static const IconData portable_wifi_off_outlined = IconData(0xe38b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">portable_wifi_off</i> &#x2014; material icon named "portable wifi off rounded".
  static const IconData portable_wifi_off_rounded = IconData(0xf3be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">portable_wifi_off</i> &#x2014; material icon named "portable wifi off sharp".
  static const IconData portable_wifi_off_sharp = IconData(0xee90, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">portrait</i> &#x2014; material icon named "portrait".
  static const IconData portrait = IconData(0xe944, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">portrait</i> &#x2014; material icon named "portrait outlined".
  static const IconData portrait_outlined = IconData(0xe38c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">portrait</i> &#x2014; material icon named "portrait rounded".
  static const IconData portrait_rounded = IconData(0xf3bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">portrait</i> &#x2014; material icon named "portrait sharp".
  static const IconData portrait_sharp = IconData(0xee91, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">post_add</i> &#x2014; material icon named "post add".
  static const IconData post_add = IconData(0xe945, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">post_add</i> &#x2014; material icon named "post add outlined".
  static const IconData post_add_outlined = IconData(0xe38d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">post_add</i> &#x2014; material icon named "post add rounded".
  static const IconData post_add_rounded = IconData(0xf3c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">post_add</i> &#x2014; material icon named "post add sharp".
  static const IconData post_add_sharp = IconData(0xee92, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">power</i> &#x2014; material icon named "power".
  static const IconData power = IconData(0xe946, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">power_input</i> &#x2014; material icon named "power input".
  static const IconData power_input = IconData(0xe947, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">power_input</i> &#x2014; material icon named "power input outlined".
  static const IconData power_input_outlined = IconData(0xe38e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">power_input</i> &#x2014; material icon named "power input rounded".
  static const IconData power_input_rounded = IconData(0xf3c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">power_input</i> &#x2014; material icon named "power input sharp".
  static const IconData power_input_sharp = IconData(0xee93, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">power_off</i> &#x2014; material icon named "power off".
  static const IconData power_off = IconData(0xe948, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">power_off</i> &#x2014; material icon named "power off outlined".
  static const IconData power_off_outlined = IconData(0xe38f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">power_off</i> &#x2014; material icon named "power off rounded".
  static const IconData power_off_rounded = IconData(0xf3c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">power_off</i> &#x2014; material icon named "power off sharp".
  static const IconData power_off_sharp = IconData(0xee94, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">power</i> &#x2014; material icon named "power outlined".
  static const IconData power_outlined = IconData(0xe390, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">power</i> &#x2014; material icon named "power rounded".
  static const IconData power_rounded = IconData(0xf3c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">power_settings_new</i> &#x2014; material icon named "power settings new".
  static const IconData power_settings_new = IconData(0xe949, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">power_settings_new</i> &#x2014; material icon named "power settings new outlined".
  static const IconData power_settings_new_outlined = IconData(0xe391, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">power_settings_new</i> &#x2014; material icon named "power settings new rounded".
  static const IconData power_settings_new_rounded = IconData(0xf3c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">power_settings_new</i> &#x2014; material icon named "power settings new sharp".
  static const IconData power_settings_new_sharp = IconData(0xee95, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">power</i> &#x2014; material icon named "power sharp".
  static const IconData power_sharp = IconData(0xee96, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">precision_manufacturing</i> &#x2014; material icon named "precision manufacturing outlined".
  static const IconData precision_manufacturing_outlined = IconData(0xe392, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">precision_manufacturing</i> &#x2014; material icon named "precision manufacturing rounded".
  static const IconData precision_manufacturing_rounded = IconData(0xf3c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">precision_manufacturing</i> &#x2014; material icon named "precision manufacturing sharp".
  static const IconData precision_manufacturing_sharp = IconData(0xee97, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pregnant_woman</i> &#x2014; material icon named "pregnant woman".
  static const IconData pregnant_woman = IconData(0xe94a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pregnant_woman</i> &#x2014; material icon named "pregnant woman outlined".
  static const IconData pregnant_woman_outlined = IconData(0xe393, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pregnant_woman</i> &#x2014; material icon named "pregnant woman rounded".
  static const IconData pregnant_woman_rounded = IconData(0xf3c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pregnant_woman</i> &#x2014; material icon named "pregnant woman sharp".
  static const IconData pregnant_woman_sharp = IconData(0xee98, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">present_to_all</i> &#x2014; material icon named "present to all".
  static const IconData present_to_all = IconData(0xe94b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">present_to_all</i> &#x2014; material icon named "present to all outlined".
  static const IconData present_to_all_outlined = IconData(0xe394, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">present_to_all</i> &#x2014; material icon named "present to all rounded".
  static const IconData present_to_all_rounded = IconData(0xf3c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">present_to_all</i> &#x2014; material icon named "present to all sharp".
  static const IconData present_to_all_sharp = IconData(0xee99, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">preview</i> &#x2014; material icon named "preview".
  static const IconData preview = IconData(0xe94c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">preview</i> &#x2014; material icon named "preview outlined".
  static const IconData preview_outlined = IconData(0xe395, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">preview</i> &#x2014; material icon named "preview rounded".
  static const IconData preview_rounded = IconData(0xf3c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">preview</i> &#x2014; material icon named "preview sharp".
  static const IconData preview_sharp = IconData(0xee9a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">print</i> &#x2014; material icon named "print".
  static const IconData print = IconData(0xe94d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">print_disabled</i> &#x2014; material icon named "print disabled".
  static const IconData print_disabled = IconData(0xe94e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">print_disabled</i> &#x2014; material icon named "print disabled outlined".
  static const IconData print_disabled_outlined = IconData(0xe396, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">print_disabled</i> &#x2014; material icon named "print disabled rounded".
  static const IconData print_disabled_rounded = IconData(0xf3c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">print_disabled</i> &#x2014; material icon named "print disabled sharp".
  static const IconData print_disabled_sharp = IconData(0xee9b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">print</i> &#x2014; material icon named "print outlined".
  static const IconData print_outlined = IconData(0xe397, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">print</i> &#x2014; material icon named "print rounded".
  static const IconData print_rounded = IconData(0xf3ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">print</i> &#x2014; material icon named "print sharp".
  static const IconData print_sharp = IconData(0xee9c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">priority_high</i> &#x2014; material icon named "priority high".
  static const IconData priority_high = IconData(0xe94f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">priority_high</i> &#x2014; material icon named "priority high outlined".
  static const IconData priority_high_outlined = IconData(0xe398, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">priority_high</i> &#x2014; material icon named "priority high rounded".
  static const IconData priority_high_rounded = IconData(0xf3cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">priority_high</i> &#x2014; material icon named "priority high sharp".
  static const IconData priority_high_sharp = IconData(0xee9d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">privacy_tip</i> &#x2014; material icon named "privacy tip".
  static const IconData privacy_tip = IconData(0xe950, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">privacy_tip</i> &#x2014; material icon named "privacy tip outlined".
  static const IconData privacy_tip_outlined = IconData(0xe399, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">privacy_tip</i> &#x2014; material icon named "privacy tip rounded".
  static const IconData privacy_tip_rounded = IconData(0xf3cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">privacy_tip</i> &#x2014; material icon named "privacy tip sharp".
  static const IconData privacy_tip_sharp = IconData(0xee9e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">psychology</i> &#x2014; material icon named "psychology".
  static const IconData psychology = IconData(0xe951, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">psychology</i> &#x2014; material icon named "psychology outlined".
  static const IconData psychology_outlined = IconData(0xe39a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">psychology</i> &#x2014; material icon named "psychology rounded".
  static const IconData psychology_rounded = IconData(0xf3cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">psychology</i> &#x2014; material icon named "psychology sharp".
  static const IconData psychology_sharp = IconData(0xee9f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">public</i> &#x2014; material icon named "public".
  static const IconData public = IconData(0xe952, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">public_off</i> &#x2014; material icon named "public off".
  static const IconData public_off = IconData(0xe953, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">public_off</i> &#x2014; material icon named "public off outlined".
  static const IconData public_off_outlined = IconData(0xe39b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">public_off</i> &#x2014; material icon named "public off rounded".
  static const IconData public_off_rounded = IconData(0xf3ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">public_off</i> &#x2014; material icon named "public off sharp".
  static const IconData public_off_sharp = IconData(0xeea0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">public</i> &#x2014; material icon named "public outlined".
  static const IconData public_outlined = IconData(0xe39c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">public</i> &#x2014; material icon named "public rounded".
  static const IconData public_rounded = IconData(0xf3cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">public</i> &#x2014; material icon named "public sharp".
  static const IconData public_sharp = IconData(0xeea1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">publish</i> &#x2014; material icon named "publish".
  static const IconData publish = IconData(0xe954, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">publish</i> &#x2014; material icon named "publish outlined".
  static const IconData publish_outlined = IconData(0xe39d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">publish</i> &#x2014; material icon named "publish rounded".
  static const IconData publish_rounded = IconData(0xf3d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">publish</i> &#x2014; material icon named "publish sharp".
  static const IconData publish_sharp = IconData(0xeea2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">push_pin</i> &#x2014; material icon named "push pin".
  static const IconData push_pin = IconData(0xe955, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">push_pin</i> &#x2014; material icon named "push pin outlined".
  static const IconData push_pin_outlined = IconData(0xe39e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">push_pin</i> &#x2014; material icon named "push pin rounded".
  static const IconData push_pin_rounded = IconData(0xf3d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">push_pin</i> &#x2014; material icon named "push pin sharp".
  static const IconData push_pin_sharp = IconData(0xeea3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">qr_code</i> &#x2014; material icon named "qr code".
  static const IconData qr_code = IconData(0xe956, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">qr_code</i> &#x2014; material icon named "qr code outlined".
  static const IconData qr_code_outlined = IconData(0xe39f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">qr_code</i> &#x2014; material icon named "qr code rounded".
  static const IconData qr_code_rounded = IconData(0xf3d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">qr_code_scanner</i> &#x2014; material icon named "qr code scanner".
  static const IconData qr_code_scanner = IconData(0xe957, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">qr_code_scanner</i> &#x2014; material icon named "qr code scanner outlined".
  static const IconData qr_code_scanner_outlined = IconData(0xe3a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">qr_code_scanner</i> &#x2014; material icon named "qr code scanner rounded".
  static const IconData qr_code_scanner_rounded = IconData(0xf3d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">qr_code_scanner</i> &#x2014; material icon named "qr code scanner sharp".
  static const IconData qr_code_scanner_sharp = IconData(0xeea4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">qr_code</i> &#x2014; material icon named "qr code sharp".
  static const IconData qr_code_sharp = IconData(0xeea5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">query_builder</i> &#x2014; material icon named "query builder".
  static const IconData query_builder = IconData(0xe958, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">query_builder</i> &#x2014; material icon named "query builder outlined".
  static const IconData query_builder_outlined = IconData(0xe3a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">query_builder</i> &#x2014; material icon named "query builder rounded".
  static const IconData query_builder_rounded = IconData(0xf3d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">query_builder</i> &#x2014; material icon named "query builder sharp".
  static const IconData query_builder_sharp = IconData(0xeea6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">question_answer</i> &#x2014; material icon named "question answer".
  static const IconData question_answer = IconData(0xe959, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">question_answer</i> &#x2014; material icon named "question answer outlined".
  static const IconData question_answer_outlined = IconData(0xe3a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">question_answer</i> &#x2014; material icon named "question answer rounded".
  static const IconData question_answer_rounded = IconData(0xf3d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">question_answer</i> &#x2014; material icon named "question answer sharp".
  static const IconData question_answer_sharp = IconData(0xeea7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">queue</i> &#x2014; material icon named "queue".
  static const IconData queue = IconData(0xe95a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">queue_music</i> &#x2014; material icon named "queue music".
  static const IconData queue_music = IconData(0xe95b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">queue_music</i> &#x2014; material icon named "queue music outlined".
  static const IconData queue_music_outlined = IconData(0xe3a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">queue_music</i> &#x2014; material icon named "queue music rounded".
  static const IconData queue_music_rounded = IconData(0xf3d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">queue_music</i> &#x2014; material icon named "queue music sharp".
  static const IconData queue_music_sharp = IconData(0xeea8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">queue</i> &#x2014; material icon named "queue outlined".
  static const IconData queue_outlined = IconData(0xe3a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">queue_play_next</i> &#x2014; material icon named "queue play next".
  static const IconData queue_play_next = IconData(0xe95c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">queue_play_next</i> &#x2014; material icon named "queue play next outlined".
  static const IconData queue_play_next_outlined = IconData(0xe3a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">queue_play_next</i> &#x2014; material icon named "queue play next rounded".
  static const IconData queue_play_next_rounded = IconData(0xf3d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">queue_play_next</i> &#x2014; material icon named "queue play next sharp".
  static const IconData queue_play_next_sharp = IconData(0xeea9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">queue</i> &#x2014; material icon named "queue rounded".
  static const IconData queue_rounded = IconData(0xf3d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">queue</i> &#x2014; material icon named "queue sharp".
  static const IconData queue_sharp = IconData(0xeeaa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">quick_contacts_dialer</i> &#x2014; material icon named "quick contacts dialer".
  static const IconData quick_contacts_dialer = IconData(0xe67d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">quick_contacts_dialer</i> &#x2014; material icon named "quick contacts dialer outlined".
  static const IconData quick_contacts_dialer_outlined = IconData(0xe108, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">quick_contacts_dialer</i> &#x2014; material icon named "quick contacts dialer rounded".
  static const IconData quick_contacts_dialer_rounded = IconData(0xf136, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">quick_contacts_dialer</i> &#x2014; material icon named "quick contacts dialer sharp".
  static const IconData quick_contacts_dialer_sharp = IconData(0xec08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">quick_contacts_mail</i> &#x2014; material icon named "quick contacts mail".
  static const IconData quick_contacts_mail = IconData(0xe67b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">quick_contacts_mail</i> &#x2014; material icon named "quick contacts mail outlined".
  static const IconData quick_contacts_mail_outlined = IconData(0xe106, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">quick_contacts_mail</i> &#x2014; material icon named "quick contacts mail rounded".
  static const IconData quick_contacts_mail_rounded = IconData(0xf134, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">quick_contacts_mail</i> &#x2014; material icon named "quick contacts mail sharp".
  static const IconData quick_contacts_mail_sharp = IconData(0xec06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">quickreply</i> &#x2014; material icon named "quickreply".
  static const IconData quickreply = IconData(0xe95d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">quickreply</i> &#x2014; material icon named "quickreply outlined".
  static const IconData quickreply_outlined = IconData(0xe3a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">quickreply</i> &#x2014; material icon named "quickreply rounded".
  static const IconData quickreply_rounded = IconData(0xf3d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">quickreply</i> &#x2014; material icon named "quickreply sharp".
  static const IconData quickreply_sharp = IconData(0xeeab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">radio</i> &#x2014; material icon named "radio".
  static const IconData radio = IconData(0xe95e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">radio_button_checked</i> &#x2014; material icon named "radio button checked".
  static const IconData radio_button_checked = IconData(0xe95f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">radio_button_checked</i> &#x2014; material icon named "radio button checked outlined".
  static const IconData radio_button_checked_outlined = IconData(0xe3a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">radio_button_checked</i> &#x2014; material icon named "radio button checked rounded".
  static const IconData radio_button_checked_rounded = IconData(0xf3da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">radio_button_checked</i> &#x2014; material icon named "radio button checked sharp".
  static const IconData radio_button_checked_sharp = IconData(0xeeac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">radio_button_off</i> &#x2014; material icon named "radio button off".
  static const IconData radio_button_off = IconData(0xe960, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">radio_button_off</i> &#x2014; material icon named "radio button off outlined".
  static const IconData radio_button_off_outlined = IconData(0xe3a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">radio_button_off</i> &#x2014; material icon named "radio button off rounded".
  static const IconData radio_button_off_rounded = IconData(0xf3db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">radio_button_off</i> &#x2014; material icon named "radio button off sharp".
  static const IconData radio_button_off_sharp = IconData(0xeead, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">radio_button_on</i> &#x2014; material icon named "radio button on".
  static const IconData radio_button_on = IconData(0xe95f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">radio_button_on</i> &#x2014; material icon named "radio button on outlined".
  static const IconData radio_button_on_outlined = IconData(0xe3a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">radio_button_on</i> &#x2014; material icon named "radio button on rounded".
  static const IconData radio_button_on_rounded = IconData(0xf3da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">radio_button_on</i> &#x2014; material icon named "radio button on sharp".
  static const IconData radio_button_on_sharp = IconData(0xeeac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">radio_button_unchecked</i> &#x2014; material icon named "radio button unchecked".
  static const IconData radio_button_unchecked = IconData(0xe960, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">radio_button_unchecked</i> &#x2014; material icon named "radio button unchecked outlined".
  static const IconData radio_button_unchecked_outlined = IconData(0xe3a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">radio_button_unchecked</i> &#x2014; material icon named "radio button unchecked rounded".
  static const IconData radio_button_unchecked_rounded = IconData(0xf3db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">radio_button_unchecked</i> &#x2014; material icon named "radio button unchecked sharp".
  static const IconData radio_button_unchecked_sharp = IconData(0xeead, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">radio</i> &#x2014; material icon named "radio outlined".
  static const IconData radio_outlined = IconData(0xe3a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">radio</i> &#x2014; material icon named "radio rounded".
  static const IconData radio_rounded = IconData(0xf3dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">radio</i> &#x2014; material icon named "radio sharp".
  static const IconData radio_sharp = IconData(0xeeae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">railway_alert</i> &#x2014; material icon named "railway alert".
  static const IconData railway_alert = IconData(0xe961, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ramen_dining</i> &#x2014; material icon named "ramen dining".
  static const IconData ramen_dining = IconData(0xe962, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rate_review</i> &#x2014; material icon named "rate review".
  static const IconData rate_review = IconData(0xe963, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rate_review</i> &#x2014; material icon named "rate review outlined".
  static const IconData rate_review_outlined = IconData(0xe3aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rate_review</i> &#x2014; material icon named "rate review rounded".
  static const IconData rate_review_rounded = IconData(0xf3dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rate_review</i> &#x2014; material icon named "rate review sharp".
  static const IconData rate_review_sharp = IconData(0xeeaf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">read_more</i> &#x2014; material icon named "read more".
  static const IconData read_more = IconData(0xe964, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">read_more</i> &#x2014; material icon named "read more outlined".
  static const IconData read_more_outlined = IconData(0xe3ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">read_more</i> &#x2014; material icon named "read more rounded".
  static const IconData read_more_rounded = IconData(0xf3de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">read_more</i> &#x2014; material icon named "read more sharp".
  static const IconData read_more_sharp = IconData(0xeeb0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">receipt</i> &#x2014; material icon named "receipt".
  static const IconData receipt = IconData(0xe965, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">receipt_long</i> &#x2014; material icon named "receipt long".
  static const IconData receipt_long = IconData(0xe966, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">receipt_long</i> &#x2014; material icon named "receipt long outlined".
  static const IconData receipt_long_outlined = IconData(0xe3ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">receipt_long</i> &#x2014; material icon named "receipt long rounded".
  static const IconData receipt_long_rounded = IconData(0xf3df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">receipt_long</i> &#x2014; material icon named "receipt long sharp".
  static const IconData receipt_long_sharp = IconData(0xeeb1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">receipt</i> &#x2014; material icon named "receipt outlined".
  static const IconData receipt_outlined = IconData(0xe3ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">receipt</i> &#x2014; material icon named "receipt rounded".
  static const IconData receipt_rounded = IconData(0xf3e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">receipt</i> &#x2014; material icon named "receipt sharp".
  static const IconData receipt_sharp = IconData(0xeeb2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">recent_actors</i> &#x2014; material icon named "recent actors".
  static const IconData recent_actors = IconData(0xe967, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">recent_actors</i> &#x2014; material icon named "recent actors outlined".
  static const IconData recent_actors_outlined = IconData(0xe3ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">recent_actors</i> &#x2014; material icon named "recent actors rounded".
  static const IconData recent_actors_rounded = IconData(0xf3e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">recent_actors</i> &#x2014; material icon named "recent actors sharp".
  static const IconData recent_actors_sharp = IconData(0xeeb3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">recommend</i> &#x2014; material icon named "recommend".
  static const IconData recommend = IconData(0xe968, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">record_voice_over</i> &#x2014; material icon named "record voice over".
  static const IconData record_voice_over = IconData(0xe969, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">record_voice_over</i> &#x2014; material icon named "record voice over outlined".
  static const IconData record_voice_over_outlined = IconData(0xe3af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">record_voice_over</i> &#x2014; material icon named "record voice over rounded".
  static const IconData record_voice_over_rounded = IconData(0xf3e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">record_voice_over</i> &#x2014; material icon named "record voice over sharp".
  static const IconData record_voice_over_sharp = IconData(0xeeb4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">redeem</i> &#x2014; material icon named "redeem".
  static const IconData redeem = IconData(0xe96a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">redeem</i> &#x2014; material icon named "redeem outlined".
  static const IconData redeem_outlined = IconData(0xe3b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">redeem</i> &#x2014; material icon named "redeem rounded".
  static const IconData redeem_rounded = IconData(0xf3e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">redeem</i> &#x2014; material icon named "redeem sharp".
  static const IconData redeem_sharp = IconData(0xeeb5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">redo</i> &#x2014; material icon named "redo".
  static const IconData redo = IconData(0xe96b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">redo</i> &#x2014; material icon named "redo outlined".
  static const IconData redo_outlined = IconData(0xe3b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">redo</i> &#x2014; material icon named "redo rounded".
  static const IconData redo_rounded = IconData(0xf3e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">redo</i> &#x2014; material icon named "redo sharp".
  static const IconData redo_sharp = IconData(0xeeb6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">reduce_capacity</i> &#x2014; material icon named "reduce capacity".
  static const IconData reduce_capacity = IconData(0xe96c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">reduce_capacity</i> &#x2014; material icon named "reduce capacity outlined".
  static const IconData reduce_capacity_outlined = IconData(0xe3b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">reduce_capacity</i> &#x2014; material icon named "reduce capacity rounded".
  static const IconData reduce_capacity_rounded = IconData(0xf3e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">reduce_capacity</i> &#x2014; material icon named "reduce capacity sharp".
  static const IconData reduce_capacity_sharp = IconData(0xeeb7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">refresh</i> &#x2014; material icon named "refresh".
  static const IconData refresh = IconData(0xe96d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">refresh</i> &#x2014; material icon named "refresh outlined".
  static const IconData refresh_outlined = IconData(0xe3b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">refresh</i> &#x2014; material icon named "refresh rounded".
  static const IconData refresh_rounded = IconData(0xf3e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">refresh</i> &#x2014; material icon named "refresh sharp".
  static const IconData refresh_sharp = IconData(0xeeb8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove</i> &#x2014; material icon named "remove".
  static const IconData remove = IconData(0xe96e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_circle</i> &#x2014; material icon named "remove circle".
  static const IconData remove_circle = IconData(0xe96f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_circle_outline</i> &#x2014; material icon named "remove circle outline".
  static const IconData remove_circle_outline = IconData(0xe970, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">remove_circle_outline</i> &#x2014; material icon named "remove circle outline outlined".
  static const IconData remove_circle_outline_outlined = IconData(0xe3b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">remove_circle_outline</i> &#x2014; material icon named "remove circle outline rounded".
  static const IconData remove_circle_outline_rounded = IconData(0xf3e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">remove_circle_outline</i> &#x2014; material icon named "remove circle outline sharp".
  static const IconData remove_circle_outline_sharp = IconData(0xeeb9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">remove_circle</i> &#x2014; material icon named "remove circle outlined".
  static const IconData remove_circle_outlined = IconData(0xe3b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">remove_circle</i> &#x2014; material icon named "remove circle rounded".
  static const IconData remove_circle_rounded = IconData(0xf3e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">remove_circle</i> &#x2014; material icon named "remove circle sharp".
  static const IconData remove_circle_sharp = IconData(0xeeba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_done</i> &#x2014; material icon named "remove done".
  static const IconData remove_done = IconData(0xe971, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_from_queue</i> &#x2014; material icon named "remove from queue".
  static const IconData remove_from_queue = IconData(0xe972, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">remove_from_queue</i> &#x2014; material icon named "remove from queue outlined".
  static const IconData remove_from_queue_outlined = IconData(0xe3b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">remove_from_queue</i> &#x2014; material icon named "remove from queue rounded".
  static const IconData remove_from_queue_rounded = IconData(0xf3e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">remove_from_queue</i> &#x2014; material icon named "remove from queue sharp".
  static const IconData remove_from_queue_sharp = IconData(0xeebb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_moderator</i> &#x2014; material icon named "remove moderator".
  static const IconData remove_moderator = IconData(0xe973, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">remove</i> &#x2014; material icon named "remove outlined".
  static const IconData remove_outlined = IconData(0xe3b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_red_eye</i> &#x2014; material icon named "remove red eye".
  static const IconData remove_red_eye = IconData(0xe974, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">remove_red_eye</i> &#x2014; material icon named "remove red eye outlined".
  static const IconData remove_red_eye_outlined = IconData(0xe3b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">remove_red_eye</i> &#x2014; material icon named "remove red eye rounded".
  static const IconData remove_red_eye_rounded = IconData(0xf3ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">remove_red_eye</i> &#x2014; material icon named "remove red eye sharp".
  static const IconData remove_red_eye_sharp = IconData(0xeebc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">remove</i> &#x2014; material icon named "remove rounded".
  static const IconData remove_rounded = IconData(0xf3eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">remove</i> &#x2014; material icon named "remove sharp".
  static const IconData remove_sharp = IconData(0xeebd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_shopping_cart</i> &#x2014; material icon named "remove shopping cart".
  static const IconData remove_shopping_cart = IconData(0xe975, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">remove_shopping_cart</i> &#x2014; material icon named "remove shopping cart outlined".
  static const IconData remove_shopping_cart_outlined = IconData(0xe3b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">remove_shopping_cart</i> &#x2014; material icon named "remove shopping cart rounded".
  static const IconData remove_shopping_cart_rounded = IconData(0xf3ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">remove_shopping_cart</i> &#x2014; material icon named "remove shopping cart sharp".
  static const IconData remove_shopping_cart_sharp = IconData(0xeebe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">reorder</i> &#x2014; material icon named "reorder".
  static const IconData reorder = IconData(0xe976, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">reorder</i> &#x2014; material icon named "reorder outlined".
  static const IconData reorder_outlined = IconData(0xe3ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">reorder</i> &#x2014; material icon named "reorder rounded".
  static const IconData reorder_rounded = IconData(0xf3ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">reorder</i> &#x2014; material icon named "reorder sharp".
  static const IconData reorder_sharp = IconData(0xeebf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">repeat</i> &#x2014; material icon named "repeat".
  static const IconData repeat = IconData(0xe977, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">repeat_on</i> &#x2014; material icon named "repeat on".
  static const IconData repeat_on = IconData(0xe978, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">repeat_one</i> &#x2014; material icon named "repeat one".
  static const IconData repeat_one = IconData(0xe979, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">repeat_one_on</i> &#x2014; material icon named "repeat one on".
  static const IconData repeat_one_on = IconData(0xe97a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">repeat_one</i> &#x2014; material icon named "repeat one outlined".
  static const IconData repeat_one_outlined = IconData(0xe3bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">repeat_one</i> &#x2014; material icon named "repeat one rounded".
  static const IconData repeat_one_rounded = IconData(0xf3ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">repeat_one</i> &#x2014; material icon named "repeat one sharp".
  static const IconData repeat_one_sharp = IconData(0xeec0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">repeat</i> &#x2014; material icon named "repeat outlined".
  static const IconData repeat_outlined = IconData(0xe3bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">repeat</i> &#x2014; material icon named "repeat rounded".
  static const IconData repeat_rounded = IconData(0xf3ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">repeat</i> &#x2014; material icon named "repeat sharp".
  static const IconData repeat_sharp = IconData(0xeec1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">replay</i> &#x2014; material icon named "replay".
  static const IconData replay = IconData(0xe97b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">replay_10</i> &#x2014; material icon named "replay 10".
  static const IconData replay_10 = IconData(0xe97c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">replay_10</i> &#x2014; material icon named "replay 10 outlined".
  static const IconData replay_10_outlined = IconData(0xe3bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">replay_10</i> &#x2014; material icon named "replay 10 rounded".
  static const IconData replay_10_rounded = IconData(0xf3f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">replay_10</i> &#x2014; material icon named "replay 10 sharp".
  static const IconData replay_10_sharp = IconData(0xeec2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">replay_30</i> &#x2014; material icon named "replay 30".
  static const IconData replay_30 = IconData(0xe97d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">replay_30</i> &#x2014; material icon named "replay 30 outlined".
  static const IconData replay_30_outlined = IconData(0xe3be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">replay_30</i> &#x2014; material icon named "replay 30 rounded".
  static const IconData replay_30_rounded = IconData(0xf3f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">replay_30</i> &#x2014; material icon named "replay 30 sharp".
  static const IconData replay_30_sharp = IconData(0xeec3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">replay_5</i> &#x2014; material icon named "replay 5".
  static const IconData replay_5 = IconData(0xe97e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">replay_5</i> &#x2014; material icon named "replay 5 outlined".
  static const IconData replay_5_outlined = IconData(0xe3bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">replay_5</i> &#x2014; material icon named "replay 5 rounded".
  static const IconData replay_5_rounded = IconData(0xf3f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">replay_5</i> &#x2014; material icon named "replay 5 sharp".
  static const IconData replay_5_sharp = IconData(0xeec4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">replay_circle_filled</i> &#x2014; material icon named "replay circle filled".
  static const IconData replay_circle_filled = IconData(0xe97f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">replay</i> &#x2014; material icon named "replay outlined".
  static const IconData replay_outlined = IconData(0xe3c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">replay</i> &#x2014; material icon named "replay rounded".
  static const IconData replay_rounded = IconData(0xf3f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">replay</i> &#x2014; material icon named "replay sharp".
  static const IconData replay_sharp = IconData(0xeec5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">reply</i> &#x2014; material icon named "reply".
  static const IconData reply = IconData(0xe980, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">reply_all</i> &#x2014; material icon named "reply all".
  static const IconData reply_all = IconData(0xe981, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">reply_all</i> &#x2014; material icon named "reply all outlined".
  static const IconData reply_all_outlined = IconData(0xe3c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">reply_all</i> &#x2014; material icon named "reply all rounded".
  static const IconData reply_all_rounded = IconData(0xf3f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">reply_all</i> &#x2014; material icon named "reply all sharp".
  static const IconData reply_all_sharp = IconData(0xeec6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">reply</i> &#x2014; material icon named "reply outlined".
  static const IconData reply_outlined = IconData(0xe3c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">reply</i> &#x2014; material icon named "reply rounded".
  static const IconData reply_rounded = IconData(0xf3f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">reply</i> &#x2014; material icon named "reply sharp".
  static const IconData reply_sharp = IconData(0xeec7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">report</i> &#x2014; material icon named "report".
  static const IconData report = IconData(0xe982, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">report_gmailerrorred</i> &#x2014; material icon named "report gmailerrorred outlined".
  static const IconData report_gmailerrorred_outlined = IconData(0xe3c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">report_gmailerrorred</i> &#x2014; material icon named "report gmailerrorred rounded".
  static const IconData report_gmailerrorred_rounded = IconData(0xf3f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">report_gmailerrorred</i> &#x2014; material icon named "report gmailerrorred sharp".
  static const IconData report_gmailerrorred_sharp = IconData(0xeec8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">report_off</i> &#x2014; material icon named "report off".
  static const IconData report_off = IconData(0xe983, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">report_off</i> &#x2014; material icon named "report off outlined".
  static const IconData report_off_outlined = IconData(0xe3c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">report_off</i> &#x2014; material icon named "report off rounded".
  static const IconData report_off_rounded = IconData(0xf3f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">report_off</i> &#x2014; material icon named "report off sharp".
  static const IconData report_off_sharp = IconData(0xeec9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">report</i> &#x2014; material icon named "report outlined".
  static const IconData report_outlined = IconData(0xe3c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">report_problem</i> &#x2014; material icon named "report problem".
  static const IconData report_problem = IconData(0xe984, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">report_problem</i> &#x2014; material icon named "report problem outlined".
  static const IconData report_problem_outlined = IconData(0xe3c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">report_problem</i> &#x2014; material icon named "report problem rounded".
  static const IconData report_problem_rounded = IconData(0xf3f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">report_problem</i> &#x2014; material icon named "report problem sharp".
  static const IconData report_problem_sharp = IconData(0xeeca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">report</i> &#x2014; material icon named "report rounded".
  static const IconData report_rounded = IconData(0xf3f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">report</i> &#x2014; material icon named "report sharp".
  static const IconData report_sharp = IconData(0xeecb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">request_page</i> &#x2014; material icon named "request page".
  static const IconData request_page = IconData(0xe985, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">request_page</i> &#x2014; material icon named "request page outlined".
  static const IconData request_page_outlined = IconData(0xe3c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">request_page</i> &#x2014; material icon named "request page rounded".
  static const IconData request_page_rounded = IconData(0xf3fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">request_page</i> &#x2014; material icon named "request page sharp".
  static const IconData request_page_sharp = IconData(0xeecc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">request_quote</i> &#x2014; material icon named "request quote".
  static const IconData request_quote = IconData(0xe986, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">request_quote</i> &#x2014; material icon named "request quote outlined".
  static const IconData request_quote_outlined = IconData(0xe3c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">request_quote</i> &#x2014; material icon named "request quote rounded".
  static const IconData request_quote_rounded = IconData(0xf3fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">request_quote</i> &#x2014; material icon named "request quote sharp".
  static const IconData request_quote_sharp = IconData(0xeecd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">reset_tv</i> &#x2014; material icon named "reset tv".
  static const IconData reset_tv = IconData(0xe987, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restaurant</i> &#x2014; material icon named "restaurant".
  static const IconData restaurant = IconData(0xe988, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restaurant_menu</i> &#x2014; material icon named "restaurant menu".
  static const IconData restaurant_menu = IconData(0xe989, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">restaurant_menu</i> &#x2014; material icon named "restaurant menu outlined".
  static const IconData restaurant_menu_outlined = IconData(0xe3c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">restaurant_menu</i> &#x2014; material icon named "restaurant menu rounded".
  static const IconData restaurant_menu_rounded = IconData(0xf3fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">restaurant_menu</i> &#x2014; material icon named "restaurant menu sharp".
  static const IconData restaurant_menu_sharp = IconData(0xeece, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">restaurant</i> &#x2014; material icon named "restaurant outlined".
  static const IconData restaurant_outlined = IconData(0xe3ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">restaurant</i> &#x2014; material icon named "restaurant rounded".
  static const IconData restaurant_rounded = IconData(0xf3fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">restaurant</i> &#x2014; material icon named "restaurant sharp".
  static const IconData restaurant_sharp = IconData(0xeecf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restore</i> &#x2014; material icon named "restore".
  static const IconData restore = IconData(0xe98a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restore_from_trash</i> &#x2014; material icon named "restore from trash".
  static const IconData restore_from_trash = IconData(0xe98b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">restore_from_trash</i> &#x2014; material icon named "restore from trash outlined".
  static const IconData restore_from_trash_outlined = IconData(0xe3cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">restore_from_trash</i> &#x2014; material icon named "restore from trash rounded".
  static const IconData restore_from_trash_rounded = IconData(0xf3fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">restore_from_trash</i> &#x2014; material icon named "restore from trash sharp".
  static const IconData restore_from_trash_sharp = IconData(0xeed0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">restore</i> &#x2014; material icon named "restore outlined".
  static const IconData restore_outlined = IconData(0xe3cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restore_page</i> &#x2014; material icon named "restore page".
  static const IconData restore_page = IconData(0xe98c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">restore_page</i> &#x2014; material icon named "restore page outlined".
  static const IconData restore_page_outlined = IconData(0xe3cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">restore_page</i> &#x2014; material icon named "restore page rounded".
  static const IconData restore_page_rounded = IconData(0xf3ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">restore_page</i> &#x2014; material icon named "restore page sharp".
  static const IconData restore_page_sharp = IconData(0xeed1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">restore</i> &#x2014; material icon named "restore rounded".
  static const IconData restore_rounded = IconData(0xf400, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">restore</i> &#x2014; material icon named "restore sharp".
  static const IconData restore_sharp = IconData(0xeed2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rice_bowl</i> &#x2014; material icon named "rice bowl".
  static const IconData rice_bowl = IconData(0xe98d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rice_bowl</i> &#x2014; material icon named "rice bowl outlined".
  static const IconData rice_bowl_outlined = IconData(0xe3ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rice_bowl</i> &#x2014; material icon named "rice bowl rounded".
  static const IconData rice_bowl_rounded = IconData(0xf401, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rice_bowl</i> &#x2014; material icon named "rice bowl sharp".
  static const IconData rice_bowl_sharp = IconData(0xeed3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ring_volume</i> &#x2014; material icon named "ring volume".
  static const IconData ring_volume = IconData(0xe98e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ring_volume</i> &#x2014; material icon named "ring volume outlined".
  static const IconData ring_volume_outlined = IconData(0xe3cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ring_volume</i> &#x2014; material icon named "ring volume rounded".
  static const IconData ring_volume_rounded = IconData(0xf402, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ring_volume</i> &#x2014; material icon named "ring volume sharp".
  static const IconData ring_volume_sharp = IconData(0xeed4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">roofing</i> &#x2014; material icon named "roofing".
  static const IconData roofing = IconData(0xe98f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">roofing</i> &#x2014; material icon named "roofing outlined".
  static const IconData roofing_outlined = IconData(0xe3d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">roofing</i> &#x2014; material icon named "roofing rounded".
  static const IconData roofing_rounded = IconData(0xf403, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">roofing</i> &#x2014; material icon named "roofing sharp".
  static const IconData roofing_sharp = IconData(0xeed5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">room</i> &#x2014; material icon named "room".
  static const IconData room = IconData(0xe990, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">room</i> &#x2014; material icon named "room outlined".
  static const IconData room_outlined = IconData(0xe3d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">room_preferences</i> &#x2014; material icon named "room preferences".
  static const IconData room_preferences = IconData(0xe991, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">room_preferences</i> &#x2014; material icon named "room preferences outlined".
  static const IconData room_preferences_outlined = IconData(0xe3d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">room_preferences</i> &#x2014; material icon named "room preferences rounded".
  static const IconData room_preferences_rounded = IconData(0xf404, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">room_preferences</i> &#x2014; material icon named "room preferences sharp".
  static const IconData room_preferences_sharp = IconData(0xeed6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">room</i> &#x2014; material icon named "room rounded".
  static const IconData room_rounded = IconData(0xf405, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">room_service</i> &#x2014; material icon named "room service".
  static const IconData room_service = IconData(0xe992, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">room_service</i> &#x2014; material icon named "room service outlined".
  static const IconData room_service_outlined = IconData(0xe3d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">room_service</i> &#x2014; material icon named "room service rounded".
  static const IconData room_service_rounded = IconData(0xf406, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">room_service</i> &#x2014; material icon named "room service sharp".
  static const IconData room_service_sharp = IconData(0xeed7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">room</i> &#x2014; material icon named "room sharp".
  static const IconData room_sharp = IconData(0xeed8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rotate_90_degrees_ccw</i> &#x2014; material icon named "rotate 90 degrees ccw".
  static const IconData rotate_90_degrees_ccw = IconData(0xe993, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rotate_90_degrees_ccw</i> &#x2014; material icon named "rotate 90 degrees ccw outlined".
  static const IconData rotate_90_degrees_ccw_outlined = IconData(0xe3d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rotate_90_degrees_ccw</i> &#x2014; material icon named "rotate 90 degrees ccw rounded".
  static const IconData rotate_90_degrees_ccw_rounded = IconData(0xf407, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rotate_90_degrees_ccw</i> &#x2014; material icon named "rotate 90 degrees ccw sharp".
  static const IconData rotate_90_degrees_ccw_sharp = IconData(0xeed9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rotate_left</i> &#x2014; material icon named "rotate left".
  static const IconData rotate_left = IconData(0xe994, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rotate_left</i> &#x2014; material icon named "rotate left outlined".
  static const IconData rotate_left_outlined = IconData(0xe3d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rotate_left</i> &#x2014; material icon named "rotate left rounded".
  static const IconData rotate_left_rounded = IconData(0xf408, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rotate_left</i> &#x2014; material icon named "rotate left sharp".
  static const IconData rotate_left_sharp = IconData(0xeeda, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rotate_right</i> &#x2014; material icon named "rotate right".
  static const IconData rotate_right = IconData(0xe995, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rotate_right</i> &#x2014; material icon named "rotate right outlined".
  static const IconData rotate_right_outlined = IconData(0xe3d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rotate_right</i> &#x2014; material icon named "rotate right rounded".
  static const IconData rotate_right_rounded = IconData(0xf409, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rotate_right</i> &#x2014; material icon named "rotate right sharp".
  static const IconData rotate_right_sharp = IconData(0xeedb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rounded_corner</i> &#x2014; material icon named "rounded corner".
  static const IconData rounded_corner = IconData(0xe996, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rounded_corner</i> &#x2014; material icon named "rounded corner outlined".
  static const IconData rounded_corner_outlined = IconData(0xe3d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rounded_corner</i> &#x2014; material icon named "rounded corner rounded".
  static const IconData rounded_corner_rounded = IconData(0xf40a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rounded_corner</i> &#x2014; material icon named "rounded corner sharp".
  static const IconData rounded_corner_sharp = IconData(0xeedc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">router</i> &#x2014; material icon named "router".
  static const IconData router = IconData(0xe997, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">router</i> &#x2014; material icon named "router outlined".
  static const IconData router_outlined = IconData(0xe3d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">router</i> &#x2014; material icon named "router rounded".
  static const IconData router_rounded = IconData(0xf40b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">router</i> &#x2014; material icon named "router sharp".
  static const IconData router_sharp = IconData(0xeedd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rowing</i> &#x2014; material icon named "rowing".
  static const IconData rowing = IconData(0xe998, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rowing</i> &#x2014; material icon named "rowing outlined".
  static const IconData rowing_outlined = IconData(0xe3d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rowing</i> &#x2014; material icon named "rowing rounded".
  static const IconData rowing_rounded = IconData(0xf40c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rowing</i> &#x2014; material icon named "rowing sharp".
  static const IconData rowing_sharp = IconData(0xeede, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rss_feed</i> &#x2014; material icon named "rss feed".
  static const IconData rss_feed = IconData(0xe999, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rss_feed</i> &#x2014; material icon named "rss feed outlined".
  static const IconData rss_feed_outlined = IconData(0xe3da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rss_feed</i> &#x2014; material icon named "rss feed rounded".
  static const IconData rss_feed_rounded = IconData(0xf40d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rss_feed</i> &#x2014; material icon named "rss feed sharp".
  static const IconData rss_feed_sharp = IconData(0xeedf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rtt</i> &#x2014; material icon named "rtt".
  static const IconData rtt = IconData(0xe99a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rule</i> &#x2014; material icon named "rule".
  static const IconData rule = IconData(0xe99b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rule_folder</i> &#x2014; material icon named "rule folder".
  static const IconData rule_folder = IconData(0xe99c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rule_folder</i> &#x2014; material icon named "rule folder outlined".
  static const IconData rule_folder_outlined = IconData(0xe3db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rule_folder</i> &#x2014; material icon named "rule folder rounded".
  static const IconData rule_folder_rounded = IconData(0xf40e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rule_folder</i> &#x2014; material icon named "rule folder sharp".
  static const IconData rule_folder_sharp = IconData(0xeee0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rule</i> &#x2014; material icon named "rule outlined".
  static const IconData rule_outlined = IconData(0xe3dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rule</i> &#x2014; material icon named "rule rounded".
  static const IconData rule_rounded = IconData(0xf40f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rule</i> &#x2014; material icon named "rule sharp".
  static const IconData rule_sharp = IconData(0xeee1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">run_circle</i> &#x2014; material icon named "run circle".
  static const IconData run_circle = IconData(0xe99d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">run_circle</i> &#x2014; material icon named "run circle outlined".
  static const IconData run_circle_outlined = IconData(0xe3dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">run_circle</i> &#x2014; material icon named "run circle rounded".
  static const IconData run_circle_rounded = IconData(0xf410, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">run_circle</i> &#x2014; material icon named "run circle sharp".
  static const IconData run_circle_sharp = IconData(0xeee2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rv_hookup</i> &#x2014; material icon named "rv hookup".
  static const IconData rv_hookup = IconData(0xe99e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">rv_hookup</i> &#x2014; material icon named "rv hookup outlined".
  static const IconData rv_hookup_outlined = IconData(0xe3de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">rv_hookup</i> &#x2014; material icon named "rv hookup rounded".
  static const IconData rv_hookup_rounded = IconData(0xf411, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">rv_hookup</i> &#x2014; material icon named "rv hookup sharp".
  static const IconData rv_hookup_sharp = IconData(0xeee3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sanitizer</i> &#x2014; material icon named "sanitizer".
  static const IconData sanitizer = IconData(0xe99f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sanitizer</i> &#x2014; material icon named "sanitizer outlined".
  static const IconData sanitizer_outlined = IconData(0xe3df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sanitizer</i> &#x2014; material icon named "sanitizer rounded".
  static const IconData sanitizer_rounded = IconData(0xf412, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sanitizer</i> &#x2014; material icon named "sanitizer sharp".
  static const IconData sanitizer_sharp = IconData(0xeee4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">satellite</i> &#x2014; material icon named "satellite".
  static const IconData satellite = IconData(0xe9a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">satellite</i> &#x2014; material icon named "satellite outlined".
  static const IconData satellite_outlined = IconData(0xe3e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">satellite</i> &#x2014; material icon named "satellite rounded".
  static const IconData satellite_rounded = IconData(0xf413, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">satellite</i> &#x2014; material icon named "satellite sharp".
  static const IconData satellite_sharp = IconData(0xeee5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">save</i> &#x2014; material icon named "save".
  static const IconData save = IconData(0xe9a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">save_alt</i> &#x2014; material icon named "save alt".
  static const IconData save_alt = IconData(0xe9a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">save_alt</i> &#x2014; material icon named "save alt outlined".
  static const IconData save_alt_outlined = IconData(0xe3e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">save_alt</i> &#x2014; material icon named "save alt rounded".
  static const IconData save_alt_rounded = IconData(0xf414, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">save_alt</i> &#x2014; material icon named "save alt sharp".
  static const IconData save_alt_sharp = IconData(0xeee6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">save</i> &#x2014; material icon named "save outlined".
  static const IconData save_outlined = IconData(0xe3e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">save</i> &#x2014; material icon named "save rounded".
  static const IconData save_rounded = IconData(0xf415, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">save</i> &#x2014; material icon named "save sharp".
  static const IconData save_sharp = IconData(0xeee7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">saved_search</i> &#x2014; material icon named "saved search".
  static const IconData saved_search = IconData(0xe9a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">scanner</i> &#x2014; material icon named "scanner".
  static const IconData scanner = IconData(0xe9a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">scanner</i> &#x2014; material icon named "scanner outlined".
  static const IconData scanner_outlined = IconData(0xe3e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">scanner</i> &#x2014; material icon named "scanner rounded".
  static const IconData scanner_rounded = IconData(0xf416, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">scanner</i> &#x2014; material icon named "scanner sharp".
  static const IconData scanner_sharp = IconData(0xeee8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">scatter_plot</i> &#x2014; material icon named "scatter plot".
  static const IconData scatter_plot = IconData(0xe9a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">scatter_plot</i> &#x2014; material icon named "scatter plot outlined".
  static const IconData scatter_plot_outlined = IconData(0xe3e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">scatter_plot</i> &#x2014; material icon named "scatter plot rounded".
  static const IconData scatter_plot_rounded = IconData(0xf417, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">scatter_plot</i> &#x2014; material icon named "scatter plot sharp".
  static const IconData scatter_plot_sharp = IconData(0xeee9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">schedule</i> &#x2014; material icon named "schedule".
  static const IconData schedule = IconData(0xe9a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">schedule</i> &#x2014; material icon named "schedule outlined".
  static const IconData schedule_outlined = IconData(0xe3e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">schedule</i> &#x2014; material icon named "schedule rounded".
  static const IconData schedule_rounded = IconData(0xf418, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">schedule_send</i> &#x2014; material icon named "schedule send".
  static const IconData schedule_send = IconData(0xe9a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">schedule</i> &#x2014; material icon named "schedule sharp".
  static const IconData schedule_sharp = IconData(0xeeea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">school</i> &#x2014; material icon named "school".
  static const IconData school = IconData(0xe9a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">school</i> &#x2014; material icon named "school outlined".
  static const IconData school_outlined = IconData(0xe3e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">school</i> &#x2014; material icon named "school rounded".
  static const IconData school_rounded = IconData(0xf419, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">school</i> &#x2014; material icon named "school sharp".
  static const IconData school_sharp = IconData(0xeeeb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">science</i> &#x2014; material icon named "science".
  static const IconData science = IconData(0xe9a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">science</i> &#x2014; material icon named "science outlined".
  static const IconData science_outlined = IconData(0xe3e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">science</i> &#x2014; material icon named "science rounded".
  static const IconData science_rounded = IconData(0xf41a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">science</i> &#x2014; material icon named "science sharp".
  static const IconData science_sharp = IconData(0xeeec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">score</i> &#x2014; material icon named "score".
  static const IconData score = IconData(0xe9aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">score</i> &#x2014; material icon named "score outlined".
  static const IconData score_outlined = IconData(0xe3e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">score</i> &#x2014; material icon named "score rounded".
  static const IconData score_rounded = IconData(0xf41b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">score</i> &#x2014; material icon named "score sharp".
  static const IconData score_sharp = IconData(0xeeed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_lock_landscape</i> &#x2014; material icon named "screen lock landscape".
  static const IconData screen_lock_landscape = IconData(0xe9ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">screen_lock_landscape</i> &#x2014; material icon named "screen lock landscape outlined".
  static const IconData screen_lock_landscape_outlined = IconData(0xe3e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">screen_lock_landscape</i> &#x2014; material icon named "screen lock landscape rounded".
  static const IconData screen_lock_landscape_rounded = IconData(0xf41c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">screen_lock_landscape</i> &#x2014; material icon named "screen lock landscape sharp".
  static const IconData screen_lock_landscape_sharp = IconData(0xeeee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_lock_portrait</i> &#x2014; material icon named "screen lock portrait".
  static const IconData screen_lock_portrait = IconData(0xe9ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">screen_lock_portrait</i> &#x2014; material icon named "screen lock portrait outlined".
  static const IconData screen_lock_portrait_outlined = IconData(0xe3ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">screen_lock_portrait</i> &#x2014; material icon named "screen lock portrait rounded".
  static const IconData screen_lock_portrait_rounded = IconData(0xf41d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">screen_lock_portrait</i> &#x2014; material icon named "screen lock portrait sharp".
  static const IconData screen_lock_portrait_sharp = IconData(0xeeef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_lock_rotation</i> &#x2014; material icon named "screen lock rotation".
  static const IconData screen_lock_rotation = IconData(0xe9ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">screen_lock_rotation</i> &#x2014; material icon named "screen lock rotation outlined".
  static const IconData screen_lock_rotation_outlined = IconData(0xe3eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">screen_lock_rotation</i> &#x2014; material icon named "screen lock rotation rounded".
  static const IconData screen_lock_rotation_rounded = IconData(0xf41e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">screen_lock_rotation</i> &#x2014; material icon named "screen lock rotation sharp".
  static const IconData screen_lock_rotation_sharp = IconData(0xeef0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_rotation</i> &#x2014; material icon named "screen rotation".
  static const IconData screen_rotation = IconData(0xe9ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">screen_rotation</i> &#x2014; material icon named "screen rotation outlined".
  static const IconData screen_rotation_outlined = IconData(0xe3ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">screen_rotation</i> &#x2014; material icon named "screen rotation rounded".
  static const IconData screen_rotation_rounded = IconData(0xf41f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">screen_rotation</i> &#x2014; material icon named "screen rotation sharp".
  static const IconData screen_rotation_sharp = IconData(0xeef1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_search_desktop</i> &#x2014; material icon named "screen search desktop".
  static const IconData screen_search_desktop = IconData(0xe9af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_share</i> &#x2014; material icon named "screen share".
  static const IconData screen_share = IconData(0xe9b0, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">screen_share</i> &#x2014; material icon named "screen share outlined".
  static const IconData screen_share_outlined = IconData(0xe3ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">screen_share</i> &#x2014; material icon named "screen share rounded".
  static const IconData screen_share_rounded = IconData(0xf420, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">screen_share</i> &#x2014; material icon named "screen share sharp".
  static const IconData screen_share_sharp = IconData(0xeef2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sd</i> &#x2014; material icon named "sd".
  static const IconData sd = IconData(0xe9b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sd_card</i> &#x2014; material icon named "sd card".
  static const IconData sd_card = IconData(0xe9b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sd_card_alert</i> &#x2014; material icon named "sd card alert outlined".
  static const IconData sd_card_alert_outlined = IconData(0xe3ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sd_card_alert</i> &#x2014; material icon named "sd card alert rounded".
  static const IconData sd_card_alert_rounded = IconData(0xf421, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sd_card_alert</i> &#x2014; material icon named "sd card alert sharp".
  static const IconData sd_card_alert_sharp = IconData(0xeef3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sd_card</i> &#x2014; material icon named "sd card outlined".
  static const IconData sd_card_outlined = IconData(0xe3ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sd_card</i> &#x2014; material icon named "sd card rounded".
  static const IconData sd_card_rounded = IconData(0xf422, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sd_card</i> &#x2014; material icon named "sd card sharp".
  static const IconData sd_card_sharp = IconData(0xeef4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sd_storage</i> &#x2014; material icon named "sd storage".
  static const IconData sd_storage = IconData(0xe9b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sd_storage</i> &#x2014; material icon named "sd storage outlined".
  static const IconData sd_storage_outlined = IconData(0xe3f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sd_storage</i> &#x2014; material icon named "sd storage rounded".
  static const IconData sd_storage_rounded = IconData(0xf423, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sd_storage</i> &#x2014; material icon named "sd storage sharp".
  static const IconData sd_storage_sharp = IconData(0xeef5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">search</i> &#x2014; material icon named "search".
  static const IconData search = IconData(0xe9b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">search_off</i> &#x2014; material icon named "search off".
  static const IconData search_off = IconData(0xe9b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">search_off</i> &#x2014; material icon named "search off outlined".
  static const IconData search_off_outlined = IconData(0xe3f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">search_off</i> &#x2014; material icon named "search off rounded".
  static const IconData search_off_rounded = IconData(0xf424, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">search_off</i> &#x2014; material icon named "search off sharp".
  static const IconData search_off_sharp = IconData(0xeef6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">search</i> &#x2014; material icon named "search outlined".
  static const IconData search_outlined = IconData(0xe3f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">search</i> &#x2014; material icon named "search rounded".
  static const IconData search_rounded = IconData(0xf425, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">search</i> &#x2014; material icon named "search sharp".
  static const IconData search_sharp = IconData(0xeef7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">security</i> &#x2014; material icon named "security".
  static const IconData security = IconData(0xe9b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">security</i> &#x2014; material icon named "security outlined".
  static const IconData security_outlined = IconData(0xe3f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">security</i> &#x2014; material icon named "security rounded".
  static const IconData security_rounded = IconData(0xf426, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">security</i> &#x2014; material icon named "security sharp".
  static const IconData security_sharp = IconData(0xeef8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">segment</i> &#x2014; material icon named "segment".
  static const IconData segment = IconData(0xe9b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">select_all</i> &#x2014; material icon named "select all".
  static const IconData select_all = IconData(0xe9b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">select_all</i> &#x2014; material icon named "select all outlined".
  static const IconData select_all_outlined = IconData(0xe3f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">select_all</i> &#x2014; material icon named "select all rounded".
  static const IconData select_all_rounded = IconData(0xf427, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">select_all</i> &#x2014; material icon named "select all sharp".
  static const IconData select_all_sharp = IconData(0xeef9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">self_improvement</i> &#x2014; material icon named "self improvement".
  static const IconData self_improvement = IconData(0xe9b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">self_improvement</i> &#x2014; material icon named "self improvement outlined".
  static const IconData self_improvement_outlined = IconData(0xe3f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">self_improvement</i> &#x2014; material icon named "self improvement rounded".
  static const IconData self_improvement_rounded = IconData(0xf428, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">self_improvement</i> &#x2014; material icon named "self improvement sharp".
  static const IconData self_improvement_sharp = IconData(0xeefa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">send</i> &#x2014; material icon named "send".
  static const IconData send = IconData(0xe9ba, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">send_and_archive</i> &#x2014; material icon named "send and archive".
  static const IconData send_and_archive = IconData(0xe9bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">send</i> &#x2014; material icon named "send outlined".
  static const IconData send_outlined = IconData(0xe3f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">send</i> &#x2014; material icon named "send rounded".
  static const IconData send_rounded = IconData(0xf429, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">send</i> &#x2014; material icon named "send sharp".
  static const IconData send_sharp = IconData(0xeefb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">send_to_mobile</i> &#x2014; material icon named "send to mobile".
  static const IconData send_to_mobile = IconData(0xe9bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sensor_door</i> &#x2014; material icon named "sensor door".
  static const IconData sensor_door = IconData(0xe9bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sensor_door</i> &#x2014; material icon named "sensor door outlined".
  static const IconData sensor_door_outlined = IconData(0xe3f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sensor_door</i> &#x2014; material icon named "sensor door rounded".
  static const IconData sensor_door_rounded = IconData(0xf42a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sensor_door</i> &#x2014; material icon named "sensor door sharp".
  static const IconData sensor_door_sharp = IconData(0xeefc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sensor_window</i> &#x2014; material icon named "sensor window".
  static const IconData sensor_window = IconData(0xe9be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sensor_window</i> &#x2014; material icon named "sensor window outlined".
  static const IconData sensor_window_outlined = IconData(0xe3f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sensor_window</i> &#x2014; material icon named "sensor window rounded".
  static const IconData sensor_window_rounded = IconData(0xf42b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sensor_window</i> &#x2014; material icon named "sensor window sharp".
  static const IconData sensor_window_sharp = IconData(0xeefd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_dissatisfied</i> &#x2014; material icon named "sentiment dissatisfied".
  static const IconData sentiment_dissatisfied = IconData(0xe9bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sentiment_dissatisfied</i> &#x2014; material icon named "sentiment dissatisfied outlined".
  static const IconData sentiment_dissatisfied_outlined = IconData(0xe3f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sentiment_dissatisfied</i> &#x2014; material icon named "sentiment dissatisfied rounded".
  static const IconData sentiment_dissatisfied_rounded = IconData(0xf42c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sentiment_dissatisfied</i> &#x2014; material icon named "sentiment dissatisfied sharp".
  static const IconData sentiment_dissatisfied_sharp = IconData(0xeefe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_neutral</i> &#x2014; material icon named "sentiment neutral".
  static const IconData sentiment_neutral = IconData(0xe9c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sentiment_neutral</i> &#x2014; material icon named "sentiment neutral outlined".
  static const IconData sentiment_neutral_outlined = IconData(0xe3fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sentiment_neutral</i> &#x2014; material icon named "sentiment neutral rounded".
  static const IconData sentiment_neutral_rounded = IconData(0xf42d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_satisfied</i> &#x2014; material icon named "sentiment satisfied".
  static const IconData sentiment_satisfied = IconData(0xe9c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_satisfied_alt</i> &#x2014; material icon named "sentiment satisfied alt".
  static const IconData sentiment_satisfied_alt = IconData(0xe9c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sentiment_satisfied_alt</i> &#x2014; material icon named "sentiment satisfied alt outlined".
  static const IconData sentiment_satisfied_alt_outlined = IconData(0xe3fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sentiment_satisfied_alt</i> &#x2014; material icon named "sentiment satisfied alt rounded".
  static const IconData sentiment_satisfied_alt_rounded = IconData(0xf42e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sentiment_satisfied_alt</i> &#x2014; material icon named "sentiment satisfied alt sharp".
  static const IconData sentiment_satisfied_alt_sharp = IconData(0xeeff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sentiment_satisfied</i> &#x2014; material icon named "sentiment satisfied outlined".
  static const IconData sentiment_satisfied_outlined = IconData(0xe3fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sentiment_satisfied</i> &#x2014; material icon named "sentiment satisfied rounded".
  static const IconData sentiment_satisfied_rounded = IconData(0xf42f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sentiment_satisfied</i> &#x2014; material icon named "sentiment satisfied sharp".
  static const IconData sentiment_satisfied_sharp = IconData(0xef00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_very_dissatisfied</i> &#x2014; material icon named "sentiment very dissatisfied".
  static const IconData sentiment_very_dissatisfied = IconData(0xe9c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sentiment_very_dissatisfied</i> &#x2014; material icon named "sentiment very dissatisfied outlined".
  static const IconData sentiment_very_dissatisfied_outlined = IconData(0xe3fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sentiment_very_dissatisfied</i> &#x2014; material icon named "sentiment very dissatisfied rounded".
  static const IconData sentiment_very_dissatisfied_rounded = IconData(0xf430, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sentiment_very_dissatisfied</i> &#x2014; material icon named "sentiment very dissatisfied sharp".
  static const IconData sentiment_very_dissatisfied_sharp = IconData(0xef01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_very_satisfied</i> &#x2014; material icon named "sentiment very satisfied".
  static const IconData sentiment_very_satisfied = IconData(0xe9c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sentiment_very_satisfied</i> &#x2014; material icon named "sentiment very satisfied outlined".
  static const IconData sentiment_very_satisfied_outlined = IconData(0xe3fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sentiment_very_satisfied</i> &#x2014; material icon named "sentiment very satisfied rounded".
  static const IconData sentiment_very_satisfied_rounded = IconData(0xf431, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sentiment_very_satisfied</i> &#x2014; material icon named "sentiment very satisfied sharp".
  static const IconData sentiment_very_satisfied_sharp = IconData(0xef02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">set_meal</i> &#x2014; material icon named "set meal".
  static const IconData set_meal = IconData(0xe9c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">set_meal</i> &#x2014; material icon named "set meal outlined".
  static const IconData set_meal_outlined = IconData(0xe3ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">set_meal</i> &#x2014; material icon named "set meal rounded".
  static const IconData set_meal_rounded = IconData(0xf432, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">set_meal</i> &#x2014; material icon named "set meal sharp".
  static const IconData set_meal_sharp = IconData(0xef03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings</i> &#x2014; material icon named "settings".
  static const IconData settings = IconData(0xe9c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_applications</i> &#x2014; material icon named "settings applications".
  static const IconData settings_applications = IconData(0xe9c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_applications</i> &#x2014; material icon named "settings applications outlined".
  static const IconData settings_applications_outlined = IconData(0xe400, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_applications</i> &#x2014; material icon named "settings applications rounded".
  static const IconData settings_applications_rounded = IconData(0xf433, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_applications</i> &#x2014; material icon named "settings applications sharp".
  static const IconData settings_applications_sharp = IconData(0xef04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_backup_restore</i> &#x2014; material icon named "settings backup restore".
  static const IconData settings_backup_restore = IconData(0xe9c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_backup_restore</i> &#x2014; material icon named "settings backup restore outlined".
  static const IconData settings_backup_restore_outlined = IconData(0xe401, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_backup_restore</i> &#x2014; material icon named "settings backup restore rounded".
  static const IconData settings_backup_restore_rounded = IconData(0xf434, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_backup_restore</i> &#x2014; material icon named "settings backup restore sharp".
  static const IconData settings_backup_restore_sharp = IconData(0xef05, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_bluetooth</i> &#x2014; material icon named "settings bluetooth".
  static const IconData settings_bluetooth = IconData(0xe9c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_bluetooth</i> &#x2014; material icon named "settings bluetooth outlined".
  static const IconData settings_bluetooth_outlined = IconData(0xe402, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_bluetooth</i> &#x2014; material icon named "settings bluetooth rounded".
  static const IconData settings_bluetooth_rounded = IconData(0xf435, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_bluetooth</i> &#x2014; material icon named "settings bluetooth sharp".
  static const IconData settings_bluetooth_sharp = IconData(0xef06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_brightness</i> &#x2014; material icon named "settings brightness".
  static const IconData settings_brightness = IconData(0xe9ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_brightness</i> &#x2014; material icon named "settings brightness outlined".
  static const IconData settings_brightness_outlined = IconData(0xe403, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_brightness</i> &#x2014; material icon named "settings brightness rounded".
  static const IconData settings_brightness_rounded = IconData(0xf436, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_brightness</i> &#x2014; material icon named "settings brightness sharp".
  static const IconData settings_brightness_sharp = IconData(0xef07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_cell</i> &#x2014; material icon named "settings cell".
  static const IconData settings_cell = IconData(0xe9cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_cell</i> &#x2014; material icon named "settings cell outlined".
  static const IconData settings_cell_outlined = IconData(0xe404, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_cell</i> &#x2014; material icon named "settings cell rounded".
  static const IconData settings_cell_rounded = IconData(0xf437, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_cell</i> &#x2014; material icon named "settings cell sharp".
  static const IconData settings_cell_sharp = IconData(0xef08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_display</i> &#x2014; material icon named "settings display".
  static const IconData settings_display = IconData(0xe9ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_display</i> &#x2014; material icon named "settings display outlined".
  static const IconData settings_display_outlined = IconData(0xe403, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_display</i> &#x2014; material icon named "settings display rounded".
  static const IconData settings_display_rounded = IconData(0xf436, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_display</i> &#x2014; material icon named "settings display sharp".
  static const IconData settings_display_sharp = IconData(0xef07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_ethernet</i> &#x2014; material icon named "settings ethernet".
  static const IconData settings_ethernet = IconData(0xe9cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_ethernet</i> &#x2014; material icon named "settings ethernet outlined".
  static const IconData settings_ethernet_outlined = IconData(0xe405, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_ethernet</i> &#x2014; material icon named "settings ethernet rounded".
  static const IconData settings_ethernet_rounded = IconData(0xf438, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_ethernet</i> &#x2014; material icon named "settings ethernet sharp".
  static const IconData settings_ethernet_sharp = IconData(0xef09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_antenna</i> &#x2014; material icon named "settings input antenna".
  static const IconData settings_input_antenna = IconData(0xe9cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_input_antenna</i> &#x2014; material icon named "settings input antenna outlined".
  static const IconData settings_input_antenna_outlined = IconData(0xe406, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_input_antenna</i> &#x2014; material icon named "settings input antenna rounded".
  static const IconData settings_input_antenna_rounded = IconData(0xf439, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_input_antenna</i> &#x2014; material icon named "settings input antenna sharp".
  static const IconData settings_input_antenna_sharp = IconData(0xef0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_component</i> &#x2014; material icon named "settings input component".
  static const IconData settings_input_component = IconData(0xe9ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_input_component</i> &#x2014; material icon named "settings input component outlined".
  static const IconData settings_input_component_outlined = IconData(0xe407, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_input_component</i> &#x2014; material icon named "settings input component rounded".
  static const IconData settings_input_component_rounded = IconData(0xf43a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_input_component</i> &#x2014; material icon named "settings input component sharp".
  static const IconData settings_input_component_sharp = IconData(0xef0b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_composite</i> &#x2014; material icon named "settings input composite".
  static const IconData settings_input_composite = IconData(0xe9cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_input_composite</i> &#x2014; material icon named "settings input composite outlined".
  static const IconData settings_input_composite_outlined = IconData(0xe408, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_input_composite</i> &#x2014; material icon named "settings input composite rounded".
  static const IconData settings_input_composite_rounded = IconData(0xf43b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_input_composite</i> &#x2014; material icon named "settings input composite sharp".
  static const IconData settings_input_composite_sharp = IconData(0xef0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_hdmi</i> &#x2014; material icon named "settings input hdmi".
  static const IconData settings_input_hdmi = IconData(0xe9d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_input_hdmi</i> &#x2014; material icon named "settings input hdmi outlined".
  static const IconData settings_input_hdmi_outlined = IconData(0xe409, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_input_hdmi</i> &#x2014; material icon named "settings input hdmi rounded".
  static const IconData settings_input_hdmi_rounded = IconData(0xf43c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_input_hdmi</i> &#x2014; material icon named "settings input hdmi sharp".
  static const IconData settings_input_hdmi_sharp = IconData(0xef0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_svideo</i> &#x2014; material icon named "settings input svideo".
  static const IconData settings_input_svideo = IconData(0xe9d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_input_svideo</i> &#x2014; material icon named "settings input svideo outlined".
  static const IconData settings_input_svideo_outlined = IconData(0xe40a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_input_svideo</i> &#x2014; material icon named "settings input svideo rounded".
  static const IconData settings_input_svideo_rounded = IconData(0xf43d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_input_svideo</i> &#x2014; material icon named "settings input svideo sharp".
  static const IconData settings_input_svideo_sharp = IconData(0xef0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings</i> &#x2014; material icon named "settings outlined".
  static const IconData settings_outlined = IconData(0xe40b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_overscan</i> &#x2014; material icon named "settings overscan".
  static const IconData settings_overscan = IconData(0xe9d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_overscan</i> &#x2014; material icon named "settings overscan outlined".
  static const IconData settings_overscan_outlined = IconData(0xe40c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_overscan</i> &#x2014; material icon named "settings overscan rounded".
  static const IconData settings_overscan_rounded = IconData(0xf43e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_overscan</i> &#x2014; material icon named "settings overscan sharp".
  static const IconData settings_overscan_sharp = IconData(0xef0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_phone</i> &#x2014; material icon named "settings phone".
  static const IconData settings_phone = IconData(0xe9d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_phone</i> &#x2014; material icon named "settings phone outlined".
  static const IconData settings_phone_outlined = IconData(0xe40d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_phone</i> &#x2014; material icon named "settings phone rounded".
  static const IconData settings_phone_rounded = IconData(0xf43f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_phone</i> &#x2014; material icon named "settings phone sharp".
  static const IconData settings_phone_sharp = IconData(0xef10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_power</i> &#x2014; material icon named "settings power".
  static const IconData settings_power = IconData(0xe9d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_power</i> &#x2014; material icon named "settings power outlined".
  static const IconData settings_power_outlined = IconData(0xe40e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_power</i> &#x2014; material icon named "settings power rounded".
  static const IconData settings_power_rounded = IconData(0xf440, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_power</i> &#x2014; material icon named "settings power sharp".
  static const IconData settings_power_sharp = IconData(0xef11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_remote</i> &#x2014; material icon named "settings remote".
  static const IconData settings_remote = IconData(0xe9d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_remote</i> &#x2014; material icon named "settings remote outlined".
  static const IconData settings_remote_outlined = IconData(0xe40f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_remote</i> &#x2014; material icon named "settings remote rounded".
  static const IconData settings_remote_rounded = IconData(0xf441, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_remote</i> &#x2014; material icon named "settings remote sharp".
  static const IconData settings_remote_sharp = IconData(0xef12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings</i> &#x2014; material icon named "settings rounded".
  static const IconData settings_rounded = IconData(0xf442, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings</i> &#x2014; material icon named "settings sharp".
  static const IconData settings_sharp = IconData(0xef13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_system_daydream</i> &#x2014; material icon named "settings system daydream".
  static const IconData settings_system_daydream = IconData(0xe9d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_system_daydream</i> &#x2014; material icon named "settings system daydream outlined".
  static const IconData settings_system_daydream_outlined = IconData(0xe410, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_system_daydream</i> &#x2014; material icon named "settings system daydream rounded".
  static const IconData settings_system_daydream_rounded = IconData(0xf443, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_system_daydream</i> &#x2014; material icon named "settings system daydream sharp".
  static const IconData settings_system_daydream_sharp = IconData(0xef14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_voice</i> &#x2014; material icon named "settings voice".
  static const IconData settings_voice = IconData(0xe9d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">settings_voice</i> &#x2014; material icon named "settings voice outlined".
  static const IconData settings_voice_outlined = IconData(0xe411, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">settings_voice</i> &#x2014; material icon named "settings voice rounded".
  static const IconData settings_voice_rounded = IconData(0xf444, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">settings_voice</i> &#x2014; material icon named "settings voice sharp".
  static const IconData settings_voice_sharp = IconData(0xef15, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">share</i> &#x2014; material icon named "share".
  static const IconData share = IconData(0xe9d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">share</i> &#x2014; material icon named "share outlined".
  static const IconData share_outlined = IconData(0xe412, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">share</i> &#x2014; material icon named "share rounded".
  static const IconData share_rounded = IconData(0xf445, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">share</i> &#x2014; material icon named "share sharp".
  static const IconData share_sharp = IconData(0xef16, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shield</i> &#x2014; material icon named "shield".
  static const IconData shield = IconData(0xe9d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shop</i> &#x2014; material icon named "shop".
  static const IconData shop = IconData(0xe9da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">shop</i> &#x2014; material icon named "shop outlined".
  static const IconData shop_outlined = IconData(0xe413, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">shop</i> &#x2014; material icon named "shop rounded".
  static const IconData shop_rounded = IconData(0xf446, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">shop</i> &#x2014; material icon named "shop sharp".
  static const IconData shop_sharp = IconData(0xef17, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shop_two</i> &#x2014; material icon named "shop two".
  static const IconData shop_two = IconData(0xe9db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">shop_two</i> &#x2014; material icon named "shop two outlined".
  static const IconData shop_two_outlined = IconData(0xe414, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">shop_two</i> &#x2014; material icon named "shop two rounded".
  static const IconData shop_two_rounded = IconData(0xf447, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">shop_two</i> &#x2014; material icon named "shop two sharp".
  static const IconData shop_two_sharp = IconData(0xef18, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shopping_bag</i> &#x2014; material icon named "shopping bag".
  static const IconData shopping_bag = IconData(0xe9dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">shopping_bag</i> &#x2014; material icon named "shopping bag outlined".
  static const IconData shopping_bag_outlined = IconData(0xe415, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">shopping_bag</i> &#x2014; material icon named "shopping bag rounded".
  static const IconData shopping_bag_rounded = IconData(0xf448, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">shopping_bag</i> &#x2014; material icon named "shopping bag sharp".
  static const IconData shopping_bag_sharp = IconData(0xef19, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shopping_basket</i> &#x2014; material icon named "shopping basket".
  static const IconData shopping_basket = IconData(0xe9dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">shopping_basket</i> &#x2014; material icon named "shopping basket outlined".
  static const IconData shopping_basket_outlined = IconData(0xe416, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">shopping_basket</i> &#x2014; material icon named "shopping basket rounded".
  static const IconData shopping_basket_rounded = IconData(0xf449, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">shopping_basket</i> &#x2014; material icon named "shopping basket sharp".
  static const IconData shopping_basket_sharp = IconData(0xef1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shopping_cart</i> &#x2014; material icon named "shopping cart".
  static const IconData shopping_cart = IconData(0xe9de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">shopping_cart</i> &#x2014; material icon named "shopping cart outlined".
  static const IconData shopping_cart_outlined = IconData(0xe417, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">shopping_cart</i> &#x2014; material icon named "shopping cart rounded".
  static const IconData shopping_cart_rounded = IconData(0xf44a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">shopping_cart</i> &#x2014; material icon named "shopping cart sharp".
  static const IconData shopping_cart_sharp = IconData(0xef1b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">short_text</i> &#x2014; material icon named "short text".
  static const IconData short_text = IconData(0xe9df, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">short_text</i> &#x2014; material icon named "short text outlined".
  static const IconData short_text_outlined = IconData(0xe418, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">short_text</i> &#x2014; material icon named "short text rounded".
  static const IconData short_text_rounded = IconData(0xf44b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">short_text</i> &#x2014; material icon named "short text sharp".
  static const IconData short_text_sharp = IconData(0xef1c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">show_chart</i> &#x2014; material icon named "show chart".
  static const IconData show_chart = IconData(0xe9e0, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">show_chart</i> &#x2014; material icon named "show chart outlined".
  static const IconData show_chart_outlined = IconData(0xe419, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">show_chart</i> &#x2014; material icon named "show chart rounded".
  static const IconData show_chart_rounded = IconData(0xf44c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">show_chart</i> &#x2014; material icon named "show chart sharp".
  static const IconData show_chart_sharp = IconData(0xef1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shuffle</i> &#x2014; material icon named "shuffle".
  static const IconData shuffle = IconData(0xe9e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shuffle_on</i> &#x2014; material icon named "shuffle on".
  static const IconData shuffle_on = IconData(0xe9e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">shuffle</i> &#x2014; material icon named "shuffle outlined".
  static const IconData shuffle_outlined = IconData(0xe41a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">shuffle</i> &#x2014; material icon named "shuffle rounded".
  static const IconData shuffle_rounded = IconData(0xf44d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">shuffle</i> &#x2014; material icon named "shuffle sharp".
  static const IconData shuffle_sharp = IconData(0xef1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shutter_speed</i> &#x2014; material icon named "shutter speed".
  static const IconData shutter_speed = IconData(0xe9e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">shutter_speed</i> &#x2014; material icon named "shutter speed outlined".
  static const IconData shutter_speed_outlined = IconData(0xe41b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">shutter_speed</i> &#x2014; material icon named "shutter speed rounded".
  static const IconData shutter_speed_rounded = IconData(0xf44e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">shutter_speed</i> &#x2014; material icon named "shutter speed sharp".
  static const IconData shutter_speed_sharp = IconData(0xef1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sick</i> &#x2014; material icon named "sick".
  static const IconData sick = IconData(0xe9e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sick</i> &#x2014; material icon named "sick outlined".
  static const IconData sick_outlined = IconData(0xe41c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sick</i> &#x2014; material icon named "sick rounded".
  static const IconData sick_rounded = IconData(0xf44f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sick</i> &#x2014; material icon named "sick sharp".
  static const IconData sick_sharp = IconData(0xef20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_4_bar</i> &#x2014; material icon named "signal cellular 4 bar".
  static const IconData signal_cellular_4_bar = IconData(0xe9e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">signal_cellular_4_bar</i> &#x2014; material icon named "signal cellular 4 bar outlined".
  static const IconData signal_cellular_4_bar_outlined = IconData(0xe41d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">signal_cellular_4_bar</i> &#x2014; material icon named "signal cellular 4 bar rounded".
  static const IconData signal_cellular_4_bar_rounded = IconData(0xf450, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">signal_cellular_4_bar</i> &#x2014; material icon named "signal cellular 4 bar sharp".
  static const IconData signal_cellular_4_bar_sharp = IconData(0xef21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_alt</i> &#x2014; material icon named "signal cellular alt".
  static const IconData signal_cellular_alt = IconData(0xe9e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">signal_cellular_alt</i> &#x2014; material icon named "signal cellular alt outlined".
  static const IconData signal_cellular_alt_outlined = IconData(0xe41e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">signal_cellular_alt</i> &#x2014; material icon named "signal cellular alt rounded".
  static const IconData signal_cellular_alt_rounded = IconData(0xf451, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">signal_cellular_alt</i> &#x2014; material icon named "signal cellular alt sharp".
  static const IconData signal_cellular_alt_sharp = IconData(0xef22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_connected_no_internet_4_bar</i> &#x2014; material icon named "signal cellular connected no internet 4 bar".
  static const IconData signal_cellular_connected_no_internet_4_bar = IconData(0xe9e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">signal_cellular_connected_no_internet_4_bar</i> &#x2014; material icon named "signal cellular connected no internet 4 bar outlined".
  static const IconData signal_cellular_connected_no_internet_4_bar_outlined = IconData(0xe41f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">signal_cellular_connected_no_internet_4_bar</i> &#x2014; material icon named "signal cellular connected no internet 4 bar rounded".
  static const IconData signal_cellular_connected_no_internet_4_bar_rounded = IconData(0xf452, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">signal_cellular_connected_no_internet_4_bar</i> &#x2014; material icon named "signal cellular connected no internet 4 bar sharp".
  static const IconData signal_cellular_connected_no_internet_4_bar_sharp = IconData(0xef23, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_no_sim</i> &#x2014; material icon named "signal cellular no sim".
  static const IconData signal_cellular_no_sim = IconData(0xe9e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">signal_cellular_no_sim</i> &#x2014; material icon named "signal cellular no sim outlined".
  static const IconData signal_cellular_no_sim_outlined = IconData(0xe420, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">signal_cellular_no_sim</i> &#x2014; material icon named "signal cellular no sim rounded".
  static const IconData signal_cellular_no_sim_rounded = IconData(0xf453, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">signal_cellular_no_sim</i> &#x2014; material icon named "signal cellular no sim sharp".
  static const IconData signal_cellular_no_sim_sharp = IconData(0xef24, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_null</i> &#x2014; material icon named "signal cellular null".
  static const IconData signal_cellular_null = IconData(0xe9e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">signal_cellular_null</i> &#x2014; material icon named "signal cellular null outlined".
  static const IconData signal_cellular_null_outlined = IconData(0xe421, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">signal_cellular_null</i> &#x2014; material icon named "signal cellular null rounded".
  static const IconData signal_cellular_null_rounded = IconData(0xf454, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">signal_cellular_null</i> &#x2014; material icon named "signal cellular null sharp".
  static const IconData signal_cellular_null_sharp = IconData(0xef25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_off</i> &#x2014; material icon named "signal cellular off".
  static const IconData signal_cellular_off = IconData(0xe9ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">signal_cellular_off</i> &#x2014; material icon named "signal cellular off outlined".
  static const IconData signal_cellular_off_outlined = IconData(0xe422, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">signal_cellular_off</i> &#x2014; material icon named "signal cellular off rounded".
  static const IconData signal_cellular_off_rounded = IconData(0xf455, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">signal_cellular_off</i> &#x2014; material icon named "signal cellular off sharp".
  static const IconData signal_cellular_off_sharp = IconData(0xef26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_wifi_4_bar</i> &#x2014; material icon named "signal wifi 4 bar".
  static const IconData signal_wifi_4_bar = IconData(0xe9eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_wifi_4_bar_lock</i> &#x2014; material icon named "signal wifi 4 bar lock".
  static const IconData signal_wifi_4_bar_lock = IconData(0xe9ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">signal_wifi_4_bar_lock</i> &#x2014; material icon named "signal wifi 4 bar lock outlined".
  static const IconData signal_wifi_4_bar_lock_outlined = IconData(0xe423, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">signal_wifi_4_bar_lock</i> &#x2014; material icon named "signal wifi 4 bar lock rounded".
  static const IconData signal_wifi_4_bar_lock_rounded = IconData(0xf456, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">signal_wifi_4_bar_lock</i> &#x2014; material icon named "signal wifi 4 bar lock sharp".
  static const IconData signal_wifi_4_bar_lock_sharp = IconData(0xef27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">signal_wifi_4_bar</i> &#x2014; material icon named "signal wifi 4 bar outlined".
  static const IconData signal_wifi_4_bar_outlined = IconData(0xe424, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">signal_wifi_4_bar</i> &#x2014; material icon named "signal wifi 4 bar rounded".
  static const IconData signal_wifi_4_bar_rounded = IconData(0xf457, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">signal_wifi_4_bar</i> &#x2014; material icon named "signal wifi 4 bar sharp".
  static const IconData signal_wifi_4_bar_sharp = IconData(0xef28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_wifi_off</i> &#x2014; material icon named "signal wifi off".
  static const IconData signal_wifi_off = IconData(0xe9ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">signal_wifi_off</i> &#x2014; material icon named "signal wifi off outlined".
  static const IconData signal_wifi_off_outlined = IconData(0xe425, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">signal_wifi_off</i> &#x2014; material icon named "signal wifi off rounded".
  static const IconData signal_wifi_off_rounded = IconData(0xf458, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">signal_wifi_off</i> &#x2014; material icon named "signal wifi off sharp".
  static const IconData signal_wifi_off_sharp = IconData(0xef29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sim_card</i> &#x2014; material icon named "sim card".
  static const IconData sim_card = IconData(0xe9ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sim_card_alert</i> &#x2014; material icon named "sim card alert".
  static const IconData sim_card_alert = IconData(0xe9ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sim_card</i> &#x2014; material icon named "sim card outlined".
  static const IconData sim_card_outlined = IconData(0xe426, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sim_card</i> &#x2014; material icon named "sim card rounded".
  static const IconData sim_card_rounded = IconData(0xf459, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sim_card</i> &#x2014; material icon named "sim card sharp".
  static const IconData sim_card_sharp = IconData(0xef2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">single_bed</i> &#x2014; material icon named "single bed".
  static const IconData single_bed = IconData(0xe9f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">single_bed</i> &#x2014; material icon named "single bed outlined".
  static const IconData single_bed_outlined = IconData(0xe427, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">single_bed</i> &#x2014; material icon named "single bed rounded".
  static const IconData single_bed_rounded = IconData(0xf45a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">single_bed</i> &#x2014; material icon named "single bed sharp".
  static const IconData single_bed_sharp = IconData(0xef2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">skip_next</i> &#x2014; material icon named "skip next".
  static const IconData skip_next = IconData(0xe9f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">skip_next</i> &#x2014; material icon named "skip next outlined".
  static const IconData skip_next_outlined = IconData(0xe428, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">skip_next</i> &#x2014; material icon named "skip next rounded".
  static const IconData skip_next_rounded = IconData(0xf45b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">skip_next</i> &#x2014; material icon named "skip next sharp".
  static const IconData skip_next_sharp = IconData(0xef2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">skip_previous</i> &#x2014; material icon named "skip previous".
  static const IconData skip_previous = IconData(0xe9f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">skip_previous</i> &#x2014; material icon named "skip previous outlined".
  static const IconData skip_previous_outlined = IconData(0xe429, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">skip_previous</i> &#x2014; material icon named "skip previous rounded".
  static const IconData skip_previous_rounded = IconData(0xf45c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">skip_previous</i> &#x2014; material icon named "skip previous sharp".
  static const IconData skip_previous_sharp = IconData(0xef2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">slideshow</i> &#x2014; material icon named "slideshow".
  static const IconData slideshow = IconData(0xe9f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">slideshow</i> &#x2014; material icon named "slideshow outlined".
  static const IconData slideshow_outlined = IconData(0xe42a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">slideshow</i> &#x2014; material icon named "slideshow rounded".
  static const IconData slideshow_rounded = IconData(0xf45d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">slideshow</i> &#x2014; material icon named "slideshow sharp".
  static const IconData slideshow_sharp = IconData(0xef2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">slow_motion_video</i> &#x2014; material icon named "slow motion video".
  static const IconData slow_motion_video = IconData(0xe9f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">slow_motion_video</i> &#x2014; material icon named "slow motion video outlined".
  static const IconData slow_motion_video_outlined = IconData(0xe42b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">slow_motion_video</i> &#x2014; material icon named "slow motion video rounded".
  static const IconData slow_motion_video_rounded = IconData(0xf45e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">slow_motion_video</i> &#x2014; material icon named "slow motion video sharp".
  static const IconData slow_motion_video_sharp = IconData(0xef2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">smart_button</i> &#x2014; material icon named "smart button".
  static const IconData smart_button = IconData(0xe9f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">smart_button</i> &#x2014; material icon named "smart button outlined".
  static const IconData smart_button_outlined = IconData(0xe42c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">smart_button</i> &#x2014; material icon named "smart button rounded".
  static const IconData smart_button_rounded = IconData(0xf45f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">smart_button</i> &#x2014; material icon named "smart button sharp".
  static const IconData smart_button_sharp = IconData(0xef30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">smartphone</i> &#x2014; material icon named "smartphone".
  static const IconData smartphone = IconData(0xe9f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">smartphone</i> &#x2014; material icon named "smartphone outlined".
  static const IconData smartphone_outlined = IconData(0xe42d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">smartphone</i> &#x2014; material icon named "smartphone rounded".
  static const IconData smartphone_rounded = IconData(0xf460, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">smartphone</i> &#x2014; material icon named "smartphone sharp".
  static const IconData smartphone_sharp = IconData(0xef31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">smoke_free</i> &#x2014; material icon named "smoke free".
  static const IconData smoke_free = IconData(0xe9f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">smoke_free</i> &#x2014; material icon named "smoke free outlined".
  static const IconData smoke_free_outlined = IconData(0xe42e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">smoke_free</i> &#x2014; material icon named "smoke free rounded".
  static const IconData smoke_free_rounded = IconData(0xf461, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">smoke_free</i> &#x2014; material icon named "smoke free sharp".
  static const IconData smoke_free_sharp = IconData(0xef32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">smoking_rooms</i> &#x2014; material icon named "smoking rooms".
  static const IconData smoking_rooms = IconData(0xe9f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">smoking_rooms</i> &#x2014; material icon named "smoking rooms outlined".
  static const IconData smoking_rooms_outlined = IconData(0xe42f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">smoking_rooms</i> &#x2014; material icon named "smoking rooms rounded".
  static const IconData smoking_rooms_rounded = IconData(0xf462, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">smoking_rooms</i> &#x2014; material icon named "smoking rooms sharp".
  static const IconData smoking_rooms_sharp = IconData(0xef33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sms</i> &#x2014; material icon named "sms".
  static const IconData sms = IconData(0xe9f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sms_failed</i> &#x2014; material icon named "sms failed".
  static const IconData sms_failed = IconData(0xe9fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sms_failed</i> &#x2014; material icon named "sms failed outlined".
  static const IconData sms_failed_outlined = IconData(0xe430, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sms_failed</i> &#x2014; material icon named "sms failed rounded".
  static const IconData sms_failed_rounded = IconData(0xf463, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sms_failed</i> &#x2014; material icon named "sms failed sharp".
  static const IconData sms_failed_sharp = IconData(0xef34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sms</i> &#x2014; material icon named "sms outlined".
  static const IconData sms_outlined = IconData(0xe431, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sms</i> &#x2014; material icon named "sms rounded".
  static const IconData sms_rounded = IconData(0xf464, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sms</i> &#x2014; material icon named "sms sharp".
  static const IconData sms_sharp = IconData(0xef35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">snippet_folder</i> &#x2014; material icon named "snippet folder".
  static const IconData snippet_folder = IconData(0xe9fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">snippet_folder</i> &#x2014; material icon named "snippet folder outlined".
  static const IconData snippet_folder_outlined = IconData(0xe432, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">snippet_folder</i> &#x2014; material icon named "snippet folder rounded".
  static const IconData snippet_folder_rounded = IconData(0xf465, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">snippet_folder</i> &#x2014; material icon named "snippet folder sharp".
  static const IconData snippet_folder_sharp = IconData(0xef36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">snooze</i> &#x2014; material icon named "snooze".
  static const IconData snooze = IconData(0xe9fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">snooze</i> &#x2014; material icon named "snooze outlined".
  static const IconData snooze_outlined = IconData(0xe433, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">snooze</i> &#x2014; material icon named "snooze rounded".
  static const IconData snooze_rounded = IconData(0xf466, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">snooze</i> &#x2014; material icon named "snooze sharp".
  static const IconData snooze_sharp = IconData(0xef37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">soap</i> &#x2014; material icon named "soap".
  static const IconData soap = IconData(0xe9fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">soap</i> &#x2014; material icon named "soap outlined".
  static const IconData soap_outlined = IconData(0xe434, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">soap</i> &#x2014; material icon named "soap rounded".
  static const IconData soap_rounded = IconData(0xf467, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">soap</i> &#x2014; material icon named "soap sharp".
  static const IconData soap_sharp = IconData(0xef38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sort</i> &#x2014; material icon named "sort".
  static const IconData sort = IconData(0xe9fe, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">sort_by_alpha</i> &#x2014; material icon named "sort by alpha".
  static const IconData sort_by_alpha = IconData(0xe9ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sort_by_alpha</i> &#x2014; material icon named "sort by alpha outlined".
  static const IconData sort_by_alpha_outlined = IconData(0xe435, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sort_by_alpha</i> &#x2014; material icon named "sort by alpha rounded".
  static const IconData sort_by_alpha_rounded = IconData(0xf468, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sort_by_alpha</i> &#x2014; material icon named "sort by alpha sharp".
  static const IconData sort_by_alpha_sharp = IconData(0xef39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sort</i> &#x2014; material icon named "sort outlined".
  static const IconData sort_outlined = IconData(0xe436, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sort</i> &#x2014; material icon named "sort rounded".
  static const IconData sort_rounded = IconData(0xf469, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sort</i> &#x2014; material icon named "sort sharp".
  static const IconData sort_sharp = IconData(0xef3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">source</i> &#x2014; material icon named "source".
  static const IconData source = IconData(0xea00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">source</i> &#x2014; material icon named "source outlined".
  static const IconData source_outlined = IconData(0xe437, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">source</i> &#x2014; material icon named "source rounded".
  static const IconData source_rounded = IconData(0xf46a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">source</i> &#x2014; material icon named "source sharp".
  static const IconData source_sharp = IconData(0xef3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">south</i> &#x2014; material icon named "south".
  static const IconData south = IconData(0xea01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">south_east</i> &#x2014; material icon named "south east".
  static const IconData south_east = IconData(0xea02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">south_east</i> &#x2014; material icon named "south east outlined".
  static const IconData south_east_outlined = IconData(0xe438, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">south_east</i> &#x2014; material icon named "south east rounded".
  static const IconData south_east_rounded = IconData(0xf46b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">south_east</i> &#x2014; material icon named "south east sharp".
  static const IconData south_east_sharp = IconData(0xef3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">south</i> &#x2014; material icon named "south outlined".
  static const IconData south_outlined = IconData(0xe439, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">south</i> &#x2014; material icon named "south rounded".
  static const IconData south_rounded = IconData(0xf46c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">south</i> &#x2014; material icon named "south sharp".
  static const IconData south_sharp = IconData(0xef3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">south_west</i> &#x2014; material icon named "south west".
  static const IconData south_west = IconData(0xea03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">south_west</i> &#x2014; material icon named "south west outlined".
  static const IconData south_west_outlined = IconData(0xe43a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">south_west</i> &#x2014; material icon named "south west rounded".
  static const IconData south_west_rounded = IconData(0xf46d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">south_west</i> &#x2014; material icon named "south west sharp".
  static const IconData south_west_sharp = IconData(0xef3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">spa</i> &#x2014; material icon named "spa".
  static const IconData spa = IconData(0xea04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">spa</i> &#x2014; material icon named "spa outlined".
  static const IconData spa_outlined = IconData(0xe43b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">spa</i> &#x2014; material icon named "spa rounded".
  static const IconData spa_rounded = IconData(0xf46e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">spa</i> &#x2014; material icon named "spa sharp".
  static const IconData spa_sharp = IconData(0xef3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">space_bar</i> &#x2014; material icon named "space bar".
  static const IconData space_bar = IconData(0xea05, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">space_bar</i> &#x2014; material icon named "space bar outlined".
  static const IconData space_bar_outlined = IconData(0xe43c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">space_bar</i> &#x2014; material icon named "space bar rounded".
  static const IconData space_bar_rounded = IconData(0xf46f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">space_bar</i> &#x2014; material icon named "space bar sharp".
  static const IconData space_bar_sharp = IconData(0xef40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker</i> &#x2014; material icon named "speaker".
  static const IconData speaker = IconData(0xea06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker_group</i> &#x2014; material icon named "speaker group".
  static const IconData speaker_group = IconData(0xea07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">speaker_group</i> &#x2014; material icon named "speaker group outlined".
  static const IconData speaker_group_outlined = IconData(0xe43d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">speaker_group</i> &#x2014; material icon named "speaker group rounded".
  static const IconData speaker_group_rounded = IconData(0xf470, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">speaker_group</i> &#x2014; material icon named "speaker group sharp".
  static const IconData speaker_group_sharp = IconData(0xef41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker_notes</i> &#x2014; material icon named "speaker notes".
  static const IconData speaker_notes = IconData(0xea08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker_notes_off</i> &#x2014; material icon named "speaker notes off".
  static const IconData speaker_notes_off = IconData(0xea09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">speaker_notes_off</i> &#x2014; material icon named "speaker notes off outlined".
  static const IconData speaker_notes_off_outlined = IconData(0xe43e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">speaker_notes_off</i> &#x2014; material icon named "speaker notes off rounded".
  static const IconData speaker_notes_off_rounded = IconData(0xf471, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">speaker_notes_off</i> &#x2014; material icon named "speaker notes off sharp".
  static const IconData speaker_notes_off_sharp = IconData(0xef42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">speaker_notes</i> &#x2014; material icon named "speaker notes outlined".
  static const IconData speaker_notes_outlined = IconData(0xe43f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">speaker_notes</i> &#x2014; material icon named "speaker notes rounded".
  static const IconData speaker_notes_rounded = IconData(0xf472, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">speaker_notes</i> &#x2014; material icon named "speaker notes sharp".
  static const IconData speaker_notes_sharp = IconData(0xef43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">speaker</i> &#x2014; material icon named "speaker outlined".
  static const IconData speaker_outlined = IconData(0xe440, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker_phone</i> &#x2014; material icon named "speaker phone".
  static const IconData speaker_phone = IconData(0xea0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">speaker_phone</i> &#x2014; material icon named "speaker phone outlined".
  static const IconData speaker_phone_outlined = IconData(0xe441, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">speaker_phone</i> &#x2014; material icon named "speaker phone rounded".
  static const IconData speaker_phone_rounded = IconData(0xf473, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">speaker_phone</i> &#x2014; material icon named "speaker phone sharp".
  static const IconData speaker_phone_sharp = IconData(0xef44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">speaker</i> &#x2014; material icon named "speaker rounded".
  static const IconData speaker_rounded = IconData(0xf474, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">speaker</i> &#x2014; material icon named "speaker sharp".
  static const IconData speaker_sharp = IconData(0xef45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speed</i> &#x2014; material icon named "speed".
  static const IconData speed = IconData(0xea0b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">speed</i> &#x2014; material icon named "speed outlined".
  static const IconData speed_outlined = IconData(0xe442, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">speed</i> &#x2014; material icon named "speed rounded".
  static const IconData speed_rounded = IconData(0xf475, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">speed</i> &#x2014; material icon named "speed sharp".
  static const IconData speed_sharp = IconData(0xef46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">spellcheck</i> &#x2014; material icon named "spellcheck".
  static const IconData spellcheck = IconData(0xea0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">spellcheck</i> &#x2014; material icon named "spellcheck outlined".
  static const IconData spellcheck_outlined = IconData(0xe443, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">spellcheck</i> &#x2014; material icon named "spellcheck rounded".
  static const IconData spellcheck_rounded = IconData(0xf476, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">spellcheck</i> &#x2014; material icon named "spellcheck sharp".
  static const IconData spellcheck_sharp = IconData(0xef47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports</i> &#x2014; material icon named "sports".
  static const IconData sports = IconData(0xea0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_bar</i> &#x2014; material icon named "sports bar".
  static const IconData sports_bar = IconData(0xea0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_bar</i> &#x2014; material icon named "sports bar outlined".
  static const IconData sports_bar_outlined = IconData(0xe444, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_bar</i> &#x2014; material icon named "sports bar rounded".
  static const IconData sports_bar_rounded = IconData(0xf477, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_bar</i> &#x2014; material icon named "sports bar sharp".
  static const IconData sports_bar_sharp = IconData(0xef48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_baseball</i> &#x2014; material icon named "sports baseball".
  static const IconData sports_baseball = IconData(0xea0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_baseball</i> &#x2014; material icon named "sports baseball outlined".
  static const IconData sports_baseball_outlined = IconData(0xe445, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_baseball</i> &#x2014; material icon named "sports baseball rounded".
  static const IconData sports_baseball_rounded = IconData(0xf478, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_baseball</i> &#x2014; material icon named "sports baseball sharp".
  static const IconData sports_baseball_sharp = IconData(0xef49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_basketball</i> &#x2014; material icon named "sports basketball".
  static const IconData sports_basketball = IconData(0xea10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_basketball</i> &#x2014; material icon named "sports basketball outlined".
  static const IconData sports_basketball_outlined = IconData(0xe446, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_basketball</i> &#x2014; material icon named "sports basketball rounded".
  static const IconData sports_basketball_rounded = IconData(0xf479, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_basketball</i> &#x2014; material icon named "sports basketball sharp".
  static const IconData sports_basketball_sharp = IconData(0xef4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_cricket</i> &#x2014; material icon named "sports cricket".
  static const IconData sports_cricket = IconData(0xea11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_cricket</i> &#x2014; material icon named "sports cricket outlined".
  static const IconData sports_cricket_outlined = IconData(0xe447, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_cricket</i> &#x2014; material icon named "sports cricket rounded".
  static const IconData sports_cricket_rounded = IconData(0xf47a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_cricket</i> &#x2014; material icon named "sports cricket sharp".
  static const IconData sports_cricket_sharp = IconData(0xef4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_esports</i> &#x2014; material icon named "sports esports".
  static const IconData sports_esports = IconData(0xea12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_esports</i> &#x2014; material icon named "sports esports outlined".
  static const IconData sports_esports_outlined = IconData(0xe448, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_esports</i> &#x2014; material icon named "sports esports rounded".
  static const IconData sports_esports_rounded = IconData(0xf47b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_esports</i> &#x2014; material icon named "sports esports sharp".
  static const IconData sports_esports_sharp = IconData(0xef4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_football</i> &#x2014; material icon named "sports football".
  static const IconData sports_football = IconData(0xea13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_football</i> &#x2014; material icon named "sports football outlined".
  static const IconData sports_football_outlined = IconData(0xe449, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_football</i> &#x2014; material icon named "sports football rounded".
  static const IconData sports_football_rounded = IconData(0xf47c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_football</i> &#x2014; material icon named "sports football sharp".
  static const IconData sports_football_sharp = IconData(0xef4d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_golf</i> &#x2014; material icon named "sports golf".
  static const IconData sports_golf = IconData(0xea14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_golf</i> &#x2014; material icon named "sports golf outlined".
  static const IconData sports_golf_outlined = IconData(0xe44a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_golf</i> &#x2014; material icon named "sports golf rounded".
  static const IconData sports_golf_rounded = IconData(0xf47d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_golf</i> &#x2014; material icon named "sports golf sharp".
  static const IconData sports_golf_sharp = IconData(0xef4e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_handball</i> &#x2014; material icon named "sports handball".
  static const IconData sports_handball = IconData(0xea15, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_handball</i> &#x2014; material icon named "sports handball outlined".
  static const IconData sports_handball_outlined = IconData(0xe44b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_handball</i> &#x2014; material icon named "sports handball rounded".
  static const IconData sports_handball_rounded = IconData(0xf47e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_handball</i> &#x2014; material icon named "sports handball sharp".
  static const IconData sports_handball_sharp = IconData(0xef4f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_hockey</i> &#x2014; material icon named "sports hockey".
  static const IconData sports_hockey = IconData(0xea16, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_hockey</i> &#x2014; material icon named "sports hockey outlined".
  static const IconData sports_hockey_outlined = IconData(0xe44c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_hockey</i> &#x2014; material icon named "sports hockey rounded".
  static const IconData sports_hockey_rounded = IconData(0xf47f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_hockey</i> &#x2014; material icon named "sports hockey sharp".
  static const IconData sports_hockey_sharp = IconData(0xef50, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_kabaddi</i> &#x2014; material icon named "sports kabaddi".
  static const IconData sports_kabaddi = IconData(0xea17, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_kabaddi</i> &#x2014; material icon named "sports kabaddi outlined".
  static const IconData sports_kabaddi_outlined = IconData(0xe44d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_kabaddi</i> &#x2014; material icon named "sports kabaddi rounded".
  static const IconData sports_kabaddi_rounded = IconData(0xf480, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_kabaddi</i> &#x2014; material icon named "sports kabaddi sharp".
  static const IconData sports_kabaddi_sharp = IconData(0xef51, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_mma</i> &#x2014; material icon named "sports mma".
  static const IconData sports_mma = IconData(0xea18, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_mma</i> &#x2014; material icon named "sports mma outlined".
  static const IconData sports_mma_outlined = IconData(0xe44e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_mma</i> &#x2014; material icon named "sports mma rounded".
  static const IconData sports_mma_rounded = IconData(0xf481, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_mma</i> &#x2014; material icon named "sports mma sharp".
  static const IconData sports_mma_sharp = IconData(0xef52, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_motorsports</i> &#x2014; material icon named "sports motorsports".
  static const IconData sports_motorsports = IconData(0xea19, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_motorsports</i> &#x2014; material icon named "sports motorsports outlined".
  static const IconData sports_motorsports_outlined = IconData(0xe44f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_motorsports</i> &#x2014; material icon named "sports motorsports rounded".
  static const IconData sports_motorsports_rounded = IconData(0xf482, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_motorsports</i> &#x2014; material icon named "sports motorsports sharp".
  static const IconData sports_motorsports_sharp = IconData(0xef53, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports</i> &#x2014; material icon named "sports outlined".
  static const IconData sports_outlined = IconData(0xe450, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports</i> &#x2014; material icon named "sports rounded".
  static const IconData sports_rounded = IconData(0xf483, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_rugby</i> &#x2014; material icon named "sports rugby".
  static const IconData sports_rugby = IconData(0xea1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_rugby</i> &#x2014; material icon named "sports rugby outlined".
  static const IconData sports_rugby_outlined = IconData(0xe451, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_rugby</i> &#x2014; material icon named "sports rugby rounded".
  static const IconData sports_rugby_rounded = IconData(0xf484, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_rugby</i> &#x2014; material icon named "sports rugby sharp".
  static const IconData sports_rugby_sharp = IconData(0xef54, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports</i> &#x2014; material icon named "sports sharp".
  static const IconData sports_sharp = IconData(0xef55, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_soccer</i> &#x2014; material icon named "sports soccer".
  static const IconData sports_soccer = IconData(0xea1b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_soccer</i> &#x2014; material icon named "sports soccer outlined".
  static const IconData sports_soccer_outlined = IconData(0xe452, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_soccer</i> &#x2014; material icon named "sports soccer rounded".
  static const IconData sports_soccer_rounded = IconData(0xf485, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_soccer</i> &#x2014; material icon named "sports soccer sharp".
  static const IconData sports_soccer_sharp = IconData(0xef56, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_tennis</i> &#x2014; material icon named "sports tennis".
  static const IconData sports_tennis = IconData(0xea1c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_tennis</i> &#x2014; material icon named "sports tennis outlined".
  static const IconData sports_tennis_outlined = IconData(0xe453, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_tennis</i> &#x2014; material icon named "sports tennis rounded".
  static const IconData sports_tennis_rounded = IconData(0xf486, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_tennis</i> &#x2014; material icon named "sports tennis sharp".
  static const IconData sports_tennis_sharp = IconData(0xef57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sports_volleyball</i> &#x2014; material icon named "sports volleyball".
  static const IconData sports_volleyball = IconData(0xea1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sports_volleyball</i> &#x2014; material icon named "sports volleyball outlined".
  static const IconData sports_volleyball_outlined = IconData(0xe454, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sports_volleyball</i> &#x2014; material icon named "sports volleyball rounded".
  static const IconData sports_volleyball_rounded = IconData(0xf487, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sports_volleyball</i> &#x2014; material icon named "sports volleyball sharp".
  static const IconData sports_volleyball_sharp = IconData(0xef58, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">square_foot</i> &#x2014; material icon named "square foot".
  static const IconData square_foot = IconData(0xea1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">square_foot</i> &#x2014; material icon named "square foot outlined".
  static const IconData square_foot_outlined = IconData(0xe455, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">square_foot</i> &#x2014; material icon named "square foot rounded".
  static const IconData square_foot_rounded = IconData(0xf488, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">square_foot</i> &#x2014; material icon named "square foot sharp".
  static const IconData square_foot_sharp = IconData(0xef59, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stacked_bar_chart</i> &#x2014; material icon named "stacked bar chart".
  static const IconData stacked_bar_chart = IconData(0xea1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stacked_line_chart</i> &#x2014; material icon named "stacked line chart".
  static const IconData stacked_line_chart = IconData(0xea20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stacked_line_chart</i> &#x2014; material icon named "stacked line chart outlined".
  static const IconData stacked_line_chart_outlined = IconData(0xe456, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stacked_line_chart</i> &#x2014; material icon named "stacked line chart rounded".
  static const IconData stacked_line_chart_rounded = IconData(0xf489, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stacked_line_chart</i> &#x2014; material icon named "stacked line chart sharp".
  static const IconData stacked_line_chart_sharp = IconData(0xef5a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stairs</i> &#x2014; material icon named "stairs".
  static const IconData stairs = IconData(0xea21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stairs</i> &#x2014; material icon named "stairs outlined".
  static const IconData stairs_outlined = IconData(0xe457, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stairs</i> &#x2014; material icon named "stairs rounded".
  static const IconData stairs_rounded = IconData(0xf48a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stairs</i> &#x2014; material icon named "stairs sharp".
  static const IconData stairs_sharp = IconData(0xef5b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">star</i> &#x2014; material icon named "star".
  static const IconData star = IconData(0xea22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">star_border</i> &#x2014; material icon named "star border".
  static const IconData star_border = IconData(0xea23, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">star_border</i> &#x2014; material icon named "star border outlined".
  static const IconData star_border_outlined = IconData(0xe458, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">star_border_purple500</i> &#x2014; material icon named "star border purple500 outlined".
  static const IconData star_border_purple500_outlined = IconData(0xe459, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">star_border_purple500</i> &#x2014; material icon named "star border purple500 sharp".
  static const IconData star_border_purple500_sharp = IconData(0xef5c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">star_border</i> &#x2014; material icon named "star border rounded".
  static const IconData star_border_rounded = IconData(0xf48b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">star_border</i> &#x2014; material icon named "star border sharp".
  static const IconData star_border_sharp = IconData(0xef5d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">star_half</i> &#x2014; material icon named "star half".
  static const IconData star_half = IconData(0xea24, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">star_half</i> &#x2014; material icon named "star half outlined".
  static const IconData star_half_outlined = IconData(0xe45a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">star_half</i> &#x2014; material icon named "star half rounded".
  static const IconData star_half_rounded = IconData(0xf48c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">star_half</i> &#x2014; material icon named "star half sharp".
  static const IconData star_half_sharp = IconData(0xef5e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">star_outline</i> &#x2014; material icon named "star outline".
  static const IconData star_outline = IconData(0xea25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">star_outline</i> &#x2014; material icon named "star outline outlined".
  static const IconData star_outline_outlined = IconData(0xe45b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">star_outline</i> &#x2014; material icon named "star outline rounded".
  static const IconData star_outline_rounded = IconData(0xf48d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">star_outline</i> &#x2014; material icon named "star outline sharp".
  static const IconData star_outline_sharp = IconData(0xef5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">star</i> &#x2014; material icon named "star outlined".
  static const IconData star_outlined = IconData(0xe45c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">star_purple500</i> &#x2014; material icon named "star purple500 outlined".
  static const IconData star_purple500_outlined = IconData(0xe45d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">star_purple500</i> &#x2014; material icon named "star purple500 sharp".
  static const IconData star_purple500_sharp = IconData(0xef60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">star_rate</i> &#x2014; material icon named "star rate".
  static const IconData star_rate = IconData(0xea26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">star_rate</i> &#x2014; material icon named "star rate outlined".
  static const IconData star_rate_outlined = IconData(0xe45e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">star_rate</i> &#x2014; material icon named "star rate rounded".
  static const IconData star_rate_rounded = IconData(0xf48e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">star_rate</i> &#x2014; material icon named "star rate sharp".
  static const IconData star_rate_sharp = IconData(0xef61, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">star</i> &#x2014; material icon named "star rounded".
  static const IconData star_rounded = IconData(0xf48f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">star</i> &#x2014; material icon named "star sharp".
  static const IconData star_sharp = IconData(0xef62, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stars</i> &#x2014; material icon named "stars".
  static const IconData stars = IconData(0xea27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stars</i> &#x2014; material icon named "stars outlined".
  static const IconData stars_outlined = IconData(0xe45f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stars</i> &#x2014; material icon named "stars rounded".
  static const IconData stars_rounded = IconData(0xf490, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stars</i> &#x2014; material icon named "stars sharp".
  static const IconData stars_sharp = IconData(0xef63, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stay_current_landscape</i> &#x2014; material icon named "stay current landscape".
  static const IconData stay_current_landscape = IconData(0xea28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stay_current_landscape</i> &#x2014; material icon named "stay current landscape outlined".
  static const IconData stay_current_landscape_outlined = IconData(0xe460, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stay_current_landscape</i> &#x2014; material icon named "stay current landscape rounded".
  static const IconData stay_current_landscape_rounded = IconData(0xf491, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stay_current_landscape</i> &#x2014; material icon named "stay current landscape sharp".
  static const IconData stay_current_landscape_sharp = IconData(0xef64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stay_current_portrait</i> &#x2014; material icon named "stay current portrait".
  static const IconData stay_current_portrait = IconData(0xea29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stay_current_portrait</i> &#x2014; material icon named "stay current portrait outlined".
  static const IconData stay_current_portrait_outlined = IconData(0xe461, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stay_current_portrait</i> &#x2014; material icon named "stay current portrait rounded".
  static const IconData stay_current_portrait_rounded = IconData(0xf492, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stay_current_portrait</i> &#x2014; material icon named "stay current portrait sharp".
  static const IconData stay_current_portrait_sharp = IconData(0xef65, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stay_primary_landscape</i> &#x2014; material icon named "stay primary landscape".
  static const IconData stay_primary_landscape = IconData(0xea2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stay_primary_landscape</i> &#x2014; material icon named "stay primary landscape outlined".
  static const IconData stay_primary_landscape_outlined = IconData(0xe462, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stay_primary_landscape</i> &#x2014; material icon named "stay primary landscape rounded".
  static const IconData stay_primary_landscape_rounded = IconData(0xf493, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stay_primary_landscape</i> &#x2014; material icon named "stay primary landscape sharp".
  static const IconData stay_primary_landscape_sharp = IconData(0xef66, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stay_primary_portrait</i> &#x2014; material icon named "stay primary portrait".
  static const IconData stay_primary_portrait = IconData(0xea2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stay_primary_portrait</i> &#x2014; material icon named "stay primary portrait outlined".
  static const IconData stay_primary_portrait_outlined = IconData(0xe463, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stay_primary_portrait</i> &#x2014; material icon named "stay primary portrait rounded".
  static const IconData stay_primary_portrait_rounded = IconData(0xf494, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stay_primary_portrait</i> &#x2014; material icon named "stay primary portrait sharp".
  static const IconData stay_primary_portrait_sharp = IconData(0xef67, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sticky_note_2</i> &#x2014; material icon named "sticky note 2".
  static const IconData sticky_note_2 = IconData(0xea2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">sticky_note_2</i> &#x2014; material icon named "sticky note 2 outlined".
  static const IconData sticky_note_2_outlined = IconData(0xe464, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">sticky_note_2</i> &#x2014; material icon named "sticky note 2 rounded".
  static const IconData sticky_note_2_rounded = IconData(0xf495, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">sticky_note_2</i> &#x2014; material icon named "sticky note 2 sharp".
  static const IconData sticky_note_2_sharp = IconData(0xef68, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stop</i> &#x2014; material icon named "stop".
  static const IconData stop = IconData(0xea2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stop_circle</i> &#x2014; material icon named "stop circle".
  static const IconData stop_circle = IconData(0xea2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stop_circle</i> &#x2014; material icon named "stop circle outlined".
  static const IconData stop_circle_outlined = IconData(0xe465, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stop_circle</i> &#x2014; material icon named "stop circle rounded".
  static const IconData stop_circle_rounded = IconData(0xf496, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stop_circle</i> &#x2014; material icon named "stop circle sharp".
  static const IconData stop_circle_sharp = IconData(0xef69, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stop</i> &#x2014; material icon named "stop outlined".
  static const IconData stop_outlined = IconData(0xe466, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stop</i> &#x2014; material icon named "stop rounded".
  static const IconData stop_rounded = IconData(0xf497, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stop_screen_share</i> &#x2014; material icon named "stop screen share".
  static const IconData stop_screen_share = IconData(0xea2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stop_screen_share</i> &#x2014; material icon named "stop screen share outlined".
  static const IconData stop_screen_share_outlined = IconData(0xe467, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stop_screen_share</i> &#x2014; material icon named "stop screen share rounded".
  static const IconData stop_screen_share_rounded = IconData(0xf498, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stop_screen_share</i> &#x2014; material icon named "stop screen share sharp".
  static const IconData stop_screen_share_sharp = IconData(0xef6a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stop</i> &#x2014; material icon named "stop sharp".
  static const IconData stop_sharp = IconData(0xef6b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">storage</i> &#x2014; material icon named "storage".
  static const IconData storage = IconData(0xea30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">storage</i> &#x2014; material icon named "storage outlined".
  static const IconData storage_outlined = IconData(0xe468, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">storage</i> &#x2014; material icon named "storage rounded".
  static const IconData storage_rounded = IconData(0xf499, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">storage</i> &#x2014; material icon named "storage sharp".
  static const IconData storage_sharp = IconData(0xef6c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">store</i> &#x2014; material icon named "store".
  static const IconData store = IconData(0xea31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">store_mall_directory</i> &#x2014; material icon named "store mall directory".
  static const IconData store_mall_directory = IconData(0xea32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">store_mall_directory</i> &#x2014; material icon named "store mall directory outlined".
  static const IconData store_mall_directory_outlined = IconData(0xe469, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">store_mall_directory</i> &#x2014; material icon named "store mall directory rounded".
  static const IconData store_mall_directory_rounded = IconData(0xf49a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">store_mall_directory</i> &#x2014; material icon named "store mall directory sharp".
  static const IconData store_mall_directory_sharp = IconData(0xef6d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">store</i> &#x2014; material icon named "store outlined".
  static const IconData store_outlined = IconData(0xe46a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">store</i> &#x2014; material icon named "store rounded".
  static const IconData store_rounded = IconData(0xf49b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">store</i> &#x2014; material icon named "store sharp".
  static const IconData store_sharp = IconData(0xef6e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">storefront</i> &#x2014; material icon named "storefront".
  static const IconData storefront = IconData(0xea33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">storefront</i> &#x2014; material icon named "storefront outlined".
  static const IconData storefront_outlined = IconData(0xe46b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">storefront</i> &#x2014; material icon named "storefront rounded".
  static const IconData storefront_rounded = IconData(0xf49c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">storefront</i> &#x2014; material icon named "storefront sharp".
  static const IconData storefront_sharp = IconData(0xef6f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">straighten</i> &#x2014; material icon named "straighten".
  static const IconData straighten = IconData(0xea34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">straighten</i> &#x2014; material icon named "straighten outlined".
  static const IconData straighten_outlined = IconData(0xe46c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">straighten</i> &#x2014; material icon named "straighten rounded".
  static const IconData straighten_rounded = IconData(0xf49d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">straighten</i> &#x2014; material icon named "straighten sharp".
  static const IconData straighten_sharp = IconData(0xef70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stream</i> &#x2014; material icon named "stream".
  static const IconData stream = IconData(0xea35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">streetview</i> &#x2014; material icon named "streetview".
  static const IconData streetview = IconData(0xea36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">streetview</i> &#x2014; material icon named "streetview outlined".
  static const IconData streetview_outlined = IconData(0xe46d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">streetview</i> &#x2014; material icon named "streetview rounded".
  static const IconData streetview_rounded = IconData(0xf49e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">streetview</i> &#x2014; material icon named "streetview sharp".
  static const IconData streetview_sharp = IconData(0xef71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">strikethrough_s</i> &#x2014; material icon named "strikethrough s".
  static const IconData strikethrough_s = IconData(0xea37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">strikethrough_s</i> &#x2014; material icon named "strikethrough s outlined".
  static const IconData strikethrough_s_outlined = IconData(0xe46e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">strikethrough_s</i> &#x2014; material icon named "strikethrough s rounded".
  static const IconData strikethrough_s_rounded = IconData(0xf49f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">strikethrough_s</i> &#x2014; material icon named "strikethrough s sharp".
  static const IconData strikethrough_s_sharp = IconData(0xef72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stroller</i> &#x2014; material icon named "stroller".
  static const IconData stroller = IconData(0xea38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">stroller</i> &#x2014; material icon named "stroller outlined".
  static const IconData stroller_outlined = IconData(0xe46f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">stroller</i> &#x2014; material icon named "stroller rounded".
  static const IconData stroller_rounded = IconData(0xf4a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">stroller</i> &#x2014; material icon named "stroller sharp".
  static const IconData stroller_sharp = IconData(0xef73, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">style</i> &#x2014; material icon named "style".
  static const IconData style = IconData(0xea39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">style</i> &#x2014; material icon named "style outlined".
  static const IconData style_outlined = IconData(0xe470, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">style</i> &#x2014; material icon named "style rounded".
  static const IconData style_rounded = IconData(0xf4a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">style</i> &#x2014; material icon named "style sharp".
  static const IconData style_sharp = IconData(0xef74, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">subdirectory_arrow_left</i> &#x2014; material icon named "subdirectory arrow left".
  static const IconData subdirectory_arrow_left = IconData(0xea3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">subdirectory_arrow_left</i> &#x2014; material icon named "subdirectory arrow left outlined".
  static const IconData subdirectory_arrow_left_outlined = IconData(0xe471, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">subdirectory_arrow_left</i> &#x2014; material icon named "subdirectory arrow left rounded".
  static const IconData subdirectory_arrow_left_rounded = IconData(0xf4a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">subdirectory_arrow_left</i> &#x2014; material icon named "subdirectory arrow left sharp".
  static const IconData subdirectory_arrow_left_sharp = IconData(0xef75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">subdirectory_arrow_right</i> &#x2014; material icon named "subdirectory arrow right".
  static const IconData subdirectory_arrow_right = IconData(0xea3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">subdirectory_arrow_right</i> &#x2014; material icon named "subdirectory arrow right outlined".
  static const IconData subdirectory_arrow_right_outlined = IconData(0xe472, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36