// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated.  Please do not edit it manually.
// To regenerate the file, use:
// dart dev/tools/gen_localizations.dart lib/src/material/i18n material

/// Maps from [Locale.languageCode] to a map that contains the localized strings
/// for that locale.
///
/// This variable is used by [MaterialLocalizations].
const Map<String, Map<String, String>> localizations = const <String, Map<String, String>> {
  "ar": const <String, String>{
    "timeOfDayFormat": r"h:mm a",
    "openAppDrawerTooltip": r"افتح قائمة التنقل",
    "backButtonTooltip": r"الى الخلف",
    "closeButtonTooltip": r"إغلا",
    "nextMonthTooltip": r"الشهر القادم",
    "previousMonthTooltip": r"الشهر الماضى",
    "nextPageTooltip": r"الصفحة التالية",
    "previousPageTooltip": r"الصفحة السابقة",
    "showMenuTooltip": r"قائمة العرض",
    "aboutListTileTitle": r"حول $applicationName",
    "licensesPageTitle": r"التّراخيص",
    "pageRowsInfoTitle": r"$firstRow–$lastRow أو $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow من حوالي $rowCount",
    "rowsPerPageTitle": r"الصفوف في الصفحة:",
    "selectedRowCountTitleOther": r"$selectedRowCount العناصر المحددة",
    "cancelButtonLabel": r"إلغاء",
    "closeButtonLabel": r"أغلاق",
    "continueButtonLabel": r"استمر",
    "copyButtonLabel": r"نسخ",
    "cutButtonLabel": r"كِم جارح",
    "okButtonLabel": r"حسنا",
    "pasteButtonLabel": r"عجين",
    "selectAllButtonLabel": r"اختر الكل",
    "viewLicensesButtonLabel": r"عرض التراخيص",
    "anteMeridiemAbbreviation": r"ص",
    "postMeridiemAbbreviation": r"م",
  },
  "de": const <String, String>{
    "timeOfDayFormat": r"HH:mm",
    "openAppDrawerTooltip": r"Navigationsmenü öffnen",
    "backButtonTooltip": r"Zurück",
    "closeButtonTooltip": r"Schließen",
    "nextMonthTooltip": r"Nächster Monat",
    "previousMonthTooltip": r"Vorheriger Monat",
    "nextPageTooltip": r"Nächste Seite",
    "previousPageTooltip": r"Vorherige Seite",
    "showMenuTooltip": r"Menü anzeigen",
    "aboutListTileTitle": r"Über $applicationName",
    "licensesPageTitle": r"Lizenzen",
    "pageRowsInfoTitle": r"$firstRow–$lastRow von $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow von etwa $rowCount",
    "rowsPerPageTitle": r"Zeilen pro Seite:",
    "selectedRowCountTitleZero": r"Keine Objekte ausgewählt",
    "selectedRowCountTitleOne": r"1 Objekt ausgewählt",
    "selectedRowCountTitleOther": r"$selectedRowCount Objekte ausgewählt",
    "cancelButtonLabel": r"ABBRECHEN",
    "closeButtonLabel": r"SCHLIESSEN",
    "continueButtonLabel": r"FORTSETZEN",
    "copyButtonLabel": r"KOPIEREN",
    "cutButtonLabel": r"AUSSCHNEIDEN",
    "okButtonLabel": r"OK",
    "pasteButtonLabel": r"EINFÜGEN",
    "selectAllButtonLabel": r"ALLES AUSWÄHLEN",
    "viewLicensesButtonLabel": r"LIZENZEN ANZEIGEN",
  },
  "en": const <String, String>{
    "timeOfDayFormat": r"h:mm a",
    "openAppDrawerTooltip": r"Open navigation menu",
    "backButtonTooltip": r"Back",
    "closeButtonTooltip": r"Close",
    "nextMonthTooltip": r"Next month",
    "previousMonthTooltip": r"Previous month",
    "nextPageTooltip": r"Next page",
    "previousPageTooltip": r"Previous page",
    "showMenuTooltip": r"Show menu",
    "aboutListTileTitle": r"About $applicationName",
    "licensesPageTitle": r"Licenses",
    "pageRowsInfoTitle": r"$firstRow–$lastRow of $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow of about $rowCount",
    "rowsPerPageTitle": r"Rows per page:",
    "selectedRowCountTitleZero": r"No items selected",
    "selectedRowCountTitleOne": r"1 item selected",
    "selectedRowCountTitleOther": r"$selectedRowCount items selected",
    "cancelButtonLabel": r"CANCEL",
    "closeButtonLabel": r"CLOSE",
    "continueButtonLabel": r"CONTINUE",
    "copyButtonLabel": r"COPY",
    "cutButtonLabel": r"CUT",
    "okButtonLabel": r"OK",
    "pasteButtonLabel": r"PASTE",
    "selectAllButtonLabel": r"SELECT ALL",
    "viewLicensesButtonLabel": r"VIEW LICENSES",
    "anteMeridiemAbbreviation": r"AM",
    "postMeridiemAbbreviation": r"PM",
  },
  "en_GB": const <String, String>{
    "timeOfDayFormat": r"HH:mm",
  },
  "en_IE": const <String, String>{
    "timeOfDayFormat": r"HH:mm",
  },
  "en_ZA": const <String, String>{
    "timeOfDayFormat": r"HH:mm",
  },
  "es": const <String, String>{
    "timeOfDayFormat": r"H:mm",
    "openAppDrawerTooltip": r"Abrir el menú de navegación",
    "backButtonTooltip": r"Espalda",
    "closeButtonTooltip": r"Cerrar",
    "nextMonthTooltip": r"Próximo mes",
    "previousMonthTooltip": r"Mes anterior",
    "nextPageTooltip": r"Siguiente página",
    "previousPageTooltip": r"Pagina anterior",
    "showMenuTooltip": r"Muestrame el menu",
    "aboutListTileTitle": r"Desarrollado por $applicationName",
    "licensesPageTitle": r"Licencias",
    "pageRowsInfoTitle": r"$firstRow–$lastRow de $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow de aproximadamente $rowCount",
    "rowsPerPageTitle": r"Filas por página:",
    "selectedRowCountTitleZero": r"No se han seleccionado elementos",
    "selectedRowCountTitleOne": r"1 artículo seleccionado",
    "selectedRowCountTitleOther": r"$selectedRowCount artículos seleccionados",
    "cancelButtonLabel": r"CANCELAR",
    "closeButtonLabel": r"CERRAR",
    "continueButtonLabel": r"CONTINUAR",
    "copyButtonLabel": r"COPIAR",
    "cutButtonLabel": r"CORTAR",
    "okButtonLabel": r"OK",
    "pasteButtonLabel": r"PEGAR",
    "selectAllButtonLabel": r"SELECCIONAR TODO",
    "viewLicensesButtonLabel": r"VER LICENCIAS",
  },
  "es_US": const <String, String>{
    "timeOfDayFormat": r"h:mm a",
  },
  "fa": const <String, String>{
    "timeOfDayFormat": r"H:mm",
    "openAppDrawerTooltip": r"منوی ناوبری را باز کنید",
    "backButtonTooltip": r"بازگشت",
    "closeButtonTooltip": r"بستن",
    "nextMonthTooltip": r"ماه بعد",
    "previousMonthTooltip": r"ماه گذشته",
    "nextPageTooltip": r"صفحه بعد",
    "previousPageTooltip": r"صفحه قبلی",
    "showMenuTooltip": r"نمایش منو",
    "aboutListTileTitle": r"درباره $applicationName",
    "licensesPageTitle": r"مجوز",
    "pageRowsInfoTitle": r"$firstRow–$lastRow از $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow از حدود $rowCount",
    "rowsPerPageTitle": r"ردیف در صفحه:",
    "selectedRowCountTitleOther": r"$selectedRowCount آیتم های انتخاب شده",
    "cancelButtonLabel": r"لغو",
    "closeButtonLabel": r"بستن",
    "continueButtonLabel": r"ادامه دهید",
    "copyButtonLabel": r"کپی",
    "cutButtonLabel": r"برش",
    "okButtonLabel": r"تایید",
    "pasteButtonLabel": r"چسباندن",
    "selectAllButtonLabel": r"انتخاب همه",
    "viewLicensesButtonLabel": r"مشاهده مجوز",
  },
  "fr": const <String, String>{
    "timeOfDayFormat": r"HH:mm",
    "openAppDrawerTooltip": r"Ouvrir le menu de navigation",
    "backButtonTooltip": r"Retour",
    "closeButtonTooltip": r"Fermer",
    "nextMonthTooltip": r"Mois Suivant",
    "previousMonthTooltip": r"Mois précédent",
    "nextPageTooltip": r"Page suivante",
    "previousPageTooltip": r"Page précédente",
    "showMenuTooltip": r"Afficher le menu",
    "aboutListTileTitle": r"À propos de $applicationName",
    "licensesPageTitle": r"Licences",
    "pageRowsInfoTitle": r"$firstRow–$lastRow de $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow d'environ $rowCount",
    "rowsPerPageTitle": r"Lignes par page:",
    "selectedRowCountTitleZero": r"Aucun élément sélectionné",
    "selectedRowCountTitleOne": r"1 élément sélectionné",
    "selectedRowCountTitleOther": r"$selectedRowCount éléments sélectionnés",
    "cancelButtonLabel": r"ANNULER",
    "closeButtonLabel": r"FERMER",
    "continueButtonLabel": r"CONTINUER",
    "copyButtonLabel": r"COPIER",
    "cutButtonLabel": r"COUPER",
    "okButtonLabel": r"OK",
    "pasteButtonLabel": r"COLLER",
    "selectAllButtonLabel": r"TOUT SÉLECTIONNER",
    "viewLicensesButtonLabel": r"AFFICHER LES LICENCES",
  },
  "fr_CA": const <String, String>{
    "timeOfDayFormat": r"HH 'h' mm",
  },
  "he": const <String, String>{
    "timeOfDayFormat": r"H:mm",
    "openAppDrawerTooltip": r"פתח תפריט ניווט",
    "backButtonTooltip": r"אחורה",
    "closeButtonTooltip": r"סגור",
    "nextMonthTooltip": r"חודש הבא",
    "previousMonthTooltip": r"חודש שעבר",
    "nextPageTooltip": r"עמוד הבא",
    "previousPageTooltip": r"עמוד קודם",
    "showMenuTooltip": r"הצג תפריט",
    "aboutListTileTitle": r"על $applicationName",
    "licensesPageTitle": r"רישיונות",
    "pageRowsInfoTitle": r"$firstRow–$lastRow מתוך $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow מתוך כ $rowCount",
    "rowsPerPageTitle": r"שורות לעמוד:",
    "selectedRowCountTitleOther": r"$selectedRowCount פריטים שנבחרו",
    "cancelButtonLabel": r"ביטול",
    "closeButtonLabel": r"סגור",
    "continueButtonLabel": r"לְהַמשִׁיך",
    "copyButtonLabel": r"קיבלתי!",
    "cutButtonLabel": r"גזור",
    "okButtonLabel": r"בסדר",
    "pasteButtonLabel": r"הדבק",
    "selectAllButtonLabel": r"בחר הכל",
    "viewLicensesButtonLabel": r"ראה רישיונות",
  },
  "it": const <String, String>{
    "timeOfDayFormat": r"HH:mm",
    "openAppDrawerTooltip": r"Apri il menu di navigazione",
    "backButtonTooltip": r"Indietro",
    "closeButtonTooltip": r"Chiudi",
    "nextMonthTooltip": r"Il prossimo mese",
    "previousMonthTooltip": r"Il mese scorso",
    "nextPageTooltip": r"Pagina successiva",
    "previousPageTooltip": r"Pagina precedente",
    "showMenuTooltip": r"Mostra il menu",
    "aboutListTileTitle": r"A proposito di $applicationName",
    "licensesPageTitle": r"Licenze",
    "pageRowsInfoTitle": r"$firstRow–$lastRow di $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow di circa $rowCount",
    "rowsPerPageTitle": r"Righe per pagina:",
    "selectedRowCountTitleOther": r"$selectedRowCount selezionati",
    "cancelButtonLabel": r"ANNULLA",
    "closeButtonLabel": r"CHIUDI",
    "continueButtonLabel": r"CONTINUA",
    "copyButtonLabel": r"COPY",
    "cutButtonLabel": r"TAGLIARE",
    "okButtonLabel": r"OK",
    "pasteButtonLabel": r"INCOLLA",
    "selectAllButtonLabel": r"SELEZIONA TUTTO",
    "viewLicensesButtonLabel": r"VEDI LE LICENZE",
  },
  "ja": const <String, String>{
    "timeOfDayFormat": r"H:mm",
    "openAppDrawerTooltip": r"ナビゲーションメニューを開く",
    "backButtonTooltip": r"戻る",
    "closeButtonTooltip": r"閉じる",
    "nextMonthTooltip": r"前の月へ",
    "previousMonthTooltip": r"前の月へ",
    "nextPageTooltip": r"次のページ",
    "previousPageTooltip": r"前のページ",
    "showMenuTooltip": r"メニューを表示",
    "aboutListTileTitle": r"$applicationNameについて",
    "licensesPageTitle": r"ライセンス",
    "pageRowsInfoTitle": r"$rowCount行中の$firstRow–$lastRow",
    "pageRowsInfoTitleApproximate": r"約$rowCount行中の$firstRow–$lastRow",
    "rowsPerPageTitle": r"1ページあたりの行数：",
    "selectedRowCountTitleOther": r"$selectedRowCount個のアイテムが選択されています",
    "cancelButtonLabel": r"キャンセル",
    "closeButtonLabel": r"閉じる",
    "continueButtonLabel": r"次へ",
    "copyButtonLabel": r"コピー",
    "cutButtonLabel": r"カット",
    "okButtonLabel": r"OK",
    "pasteButtonLabel": r"貼付け",
    "selectAllButtonLabel": r"全選択",
    "viewLicensesButtonLabel": r"ライセンス表記",
  },
  "ps": const <String, String>{
    "timeOfDayFormat": r"HH:mm",
    "openAppDrawerTooltip": r"د پرانیستی نیینګ مینو",
    "backButtonTooltip": r"شاته",
    "closeButtonTooltip": r"بنده",
    "nextMonthTooltip": r"بله میاشت",
    "previousMonthTooltip": r"تیره میاشت",
    "nextPageTooltip": r"بله پاڼه",
    "previousPageTooltip": r"مخکینی مخ",
    "showMenuTooltip": r"غورنۍ ښودل",
    "aboutListTileTitle": r"د $applicationName په اړه",
    "licensesPageTitle": r"جوازونه",
    "pageRowsInfoTitle": r"$firstRow–$lastRow د $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow څخه $rowCount د",
    "rowsPerPageTitle": r"د هرې پاڼې پاڼې:",
    "selectedRowCountTitleOther": r"$selectedRowCount توکي غوره شوي",
    "cancelButtonLabel": r"لغوه کول",
    "closeButtonLabel": r"تړل",
    "continueButtonLabel": r"منځپانګې",
    "copyButtonLabel": r"کاپی",
    "cutButtonLabel": r"کم کړئ",
    "okButtonLabel": r"سمه ده",
    "pasteButtonLabel": r"پیټ کړئ",
    "selectAllButtonLabel": r"غوره کړئ",
    "viewLicensesButtonLabel": r"لیدلس وګورئ",
  },
  "pt": const <String, String>{
    "timeOfDayFormat": r"HH:mm",
    "openAppDrawerTooltip": r"Abrir menu de navegação",
    "backButtonTooltip": r"Costas",
    "closeButtonTooltip": r"Fechar",
    "nextMonthTooltip": r"Próximo mês",
    "previousMonthTooltip": r"Mês anterior",
    "nextPageTooltip": r"Próxima página",
    "previousPageTooltip": r"Página anterior",
    "showMenuTooltip": r"Mostrar menu",
    "aboutListTileTitle": r"Sobre $applicationName",
    "licensesPageTitle": r"Licenças",
    "pageRowsInfoTitle": r"$firstRow–$lastRow de $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow de cerca de $rowCount",
    "rowsPerPageTitle": r"Linhas por página:",
    "selectedRowCountTitleOther": r"$selectedRowCount selecionados",
    "cancelButtonLabel": r"CANCELAR",
    "closeButtonLabel": r"FECHAR",
    "continueButtonLabel": r"CONTINUAR",
    "copyButtonLabel": r"CÓPIA DE",
    "cutButtonLabel": r"CORTA",
    "okButtonLabel": r"OK",
    "pasteButtonLabel": r"COLAR",
    "selectAllButtonLabel": r"SELECIONAR TUDO",
    "viewLicensesButtonLabel": r"VER LICENÇAS",
  },
  "ru": const <String, String>{
    "timeOfDayFormat": r"H:mm",
    "openAppDrawerTooltip": r"Открыть меню навигации",
    "backButtonTooltip": r"Назад",
    "closeButtonTooltip": r"Закрыть",
    "nextMonthTooltip": r"Следующий месяц",
    "previousMonthTooltip": r"Предыдущий месяц",
    "nextPageTooltip": r"Следущая страница",
    "previousPageTooltip": r"Предыдущая страница",
    "showMenuTooltip": r"Показать меню",
    "pageRowsInfoTitle": r"$firstRow–$lastRow из $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow из примерно $rowCount",
    "rowsPerPageTitle": r"Строки на страницу:",
    "aboutListTileTitle": r"O $applicationName",
    "licensesPageTitle": r"Лицензии",
    "selectedRowCountTitleOther": r"Выбранно $selectedRowCount строк",
    "cancelButtonLabel": r"ОТМЕНИТЬ",
    "closeButtonLabel": r"ЗАКРЫТЬ",
    "continueButtonLabel": r"ПРОДОЛЖИТЬ",
    "copyButtonLabel": r"СКОПИРОВАТЬ",
    "cutButtonLabel": r"ВЫРЕЗАТЬ",
    "okButtonLabel": r"ОК",
    "pasteButtonLabel": r"ВСТАВИТЬ",
    "selectAllButtonLabel": r"ВЫБРАТЬ ВСЁ",
    "viewLicensesButtonLabel": r"ПРОСМОТРЕТЬ ЛИЦЕНЗИИ",
  },
  "sd": const <String, String>{
    "timeOfDayFormat": r"HH:mm",
    "openAppDrawerTooltip": r"اوپن جي مينڊيٽ مينيو",
    "backButtonTooltip": r"پوئتي",
    "closeButtonTooltip": r"بند ڪريو",
    "nextMonthTooltip": r"ايندڙ مهيني",
    "previousMonthTooltip": r"پويون مهينو",
    "nextPageTooltip": r"اڳيون پيج",
    "previousPageTooltip": r"پويون صفحو",
    "showMenuTooltip": r"ڏيکاريو",
    "aboutListTileTitle": r"$applicationName بابت",
    "licensesPageTitle": r"لائسنس",
    "pageRowsInfoTitle": r"$firstRow–$lastRow جي $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow کان $rowCount تقريبن",
    "rowsPerPageTitle": r"رني پاسي وارو صفحو",
    "selectedRowCountTitleOther": r"$selectedRowCount شيون چونڊيل",
    "cancelButtonLabel": r"منسوخ ڪيو",
    "closeButtonLabel": r"بند ڪريو",
    "continueButtonLabel": r"جاري رکو",
    "copyButtonLabel": r"ڪاپي",
    "cutButtonLabel": r"پٽي",
    "okButtonLabel": r"ٺيڪ آهي",
    "pasteButtonLabel": r"پيسٽ ڪريو",
    "selectAllButtonLabel": r"سڀ چونڊيو",
    "viewLicensesButtonLabel": r"لائسنس ڏسو",
  },
  "ur": const <String, String>{
    "timeOfDayFormat": r"h:mm a",
    "openAppDrawerTooltip": r"کھولیں نیویگیشن مینو",
    "backButtonTooltip": r"واپس",
    "closeButtonTooltip": r"بند کریں",
    "nextMonthTooltip": r"اگلا مھینہ",
    "previousMonthTooltip": r"پچھلا مھینہ",
    "nextPageTooltip": r"اگلا صفحہ",
    "previousPageTooltip": r"سابقہ ​​صفحہ",
    "showMenuTooltip": r"مینو دکھائیں",
    "aboutListTileTitle": r"کے بارے میں $applicationName",
    "licensesPageTitle": r"لائسنس",
    "pageRowsInfoTitle": r"$firstRow–$lastRow کے $rowCount",
    "pageRowsInfoTitleApproximate": r"$firstRow–$lastRow میں سے $rowCount تقریبا",
    "rowsPerPageTitle": r"رویوں فی صفحہ:",
    "selectedRowCountTitleOther": r"$selectedRowCount منتخب کردہ اشیاء",
    "cancelButtonLabel": r"منسوخ کریں",
    "closeButtonLabel": r"بند کریں",
    "continueButtonLabel": r"جاری رکھیں",
    "copyButtonLabel": r"کاپی",
    "cutButtonLabel": r"کاٹیں",
    "okButtonLabel": r"ٹھیک ہے",
    "pasteButtonLabel": r"چسپاں",
    "selectAllButtonLabel": r"تکاپیمام منتخب کریں",
    "viewLicensesButtonLabel": r"لائسنس دیکھیں",
    "anteMeridiemAbbreviation": r"AM",
    "postMeridiemAbbreviation": r"PM",
  },
  "zh": const <String, String>{
    "timeOfDayFormat": r"ah:mm",
    "openAppDrawerTooltip": r"打开导航菜单",
    "backButtonTooltip": r"返回",
    "closeButtonTooltip": r"关",
    "nextMonthTooltip": r"-下月就29了。",
    "previousMonthTooltip": r"前一个月",
    "nextPageTooltip": r"下一页",
    "previousPageTooltip": r"上一页",
    "showMenuTooltip": r"显示菜单",
    "aboutListTileTitle": r"关于$applicationName",
    "licensesPageTitle": r"许可证",
    "pageRowsInfoTitle": r"$rowCount中的$firstRow-$lastRow",
    "pageRowsInfoTitleApproximate": r"约$rowCount中的$firstRow-$lastRow",
    "rowsPerPageTitle": r"每页行数：",
    "selectedRowCountTitleOther": r"$selectedRowCount行所选",
    "cancelButtonLabel": r"取消",
    "continueButtonLabel": r"继续",
    "closeButtonLabel": r"关闭",
    "copyButtonLabel": r"复制",
    "cutButtonLabel": r"剪切",
    "okButtonLabel": r"确定",
    "pasteButtonLabel": r"粘贴",
    "selectAllButtonLabel": r"全选",
    "viewLicensesButtonLabel": r"查看许可证",
    "anteMeridiemAbbreviation": r"上午",
    "postMeridiemAbbreviation": r"下午",
  },
};

