// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated. Please do not edit it manually.
// To regenerate the file, use:
// dart dev/tools/localization/gen_localizations.dart --overwrite

import 'dart:collection';

import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart' as intl;

import '../material_localizations.dart';

// The classes defined here encode all of the translations found in the
// `flutter_localizations/lib/src/l10n/*.arb` files.
//
// These classes are constructed by the [getMaterialTranslation] method at the
// bottom of this file, and used by the [_MaterialLocalizationsDelegate.load]
// method defined in `flutter_localizations/lib/src/material_localizations.dart`.

/// The translations for Afrikaans (`af`).
class MaterialLocalizationAf extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Afrikaans.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAf({
    String localeName = 'af',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Meer oor $applicationName';

  @override
  String get alertDialogLabel => r'Opletberig';

  @override
  String get anteMeridiemAbbreviation => r'vm.';

  @override
  String get backButtonTooltip => r'Terug';

  @override
  String get cancelButtonLabel => r'KANSELLEER';

  @override
  String get closeButtonLabel => r'MAAK TOE';

  @override
  String get closeButtonTooltip => r'Maak toe';

  @override
  String get collapsedIconTapHint => r'Vou uit';

  @override
  String get continueButtonLabel => r'GAAN VOORT';

  @override
  String get copyButtonLabel => r'KOPIEER';

  @override
  String get cutButtonLabel => r'KNIP';

  @override
  String get deleteButtonTooltip => r'Vee uit';

  @override
  String get dialogLabel => r'Dialoog';

  @override
  String get drawerLabel => r'Navigasiekieslys';

  @override
  String get expandedIconTapHint => r'Vou in';

  @override
  String get hideAccountsLabel => r'Versteek rekeninge';

  @override
  String get licensesPageTitle => r'Lisensies';

  @override
  String get modalBarrierDismissLabel => r'Maak toe';

  @override
  String get nextMonthTooltip => r'Volgende maand';

  @override
  String get nextPageTooltip => r'Volgende bladsy';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Maak navigasiekieslys oop';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow van $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow van ongeveer $rowCount';

  @override
  String get pasteButtonLabel => r'PLAK';

  @override
  String get popupMenuLabel => r'Opspringkieslys';

  @override
  String get postMeridiemAbbreviation => r'nm.';

  @override
  String get previousMonthTooltip => r'Vorige maand';

  @override
  String get previousPageTooltip => r'Vorige bladsy';

  @override
  String get refreshIndicatorSemanticLabel => r'Herlaai';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 karakter oor';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karakters oor';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Skuif af';

  @override
  String get reorderItemLeft => r'Skuif na links';

  @override
  String get reorderItemRight => r'Skuif na regs';

  @override
  String get reorderItemToEnd => r'Skuif na die einde';

  @override
  String get reorderItemToStart => r'Skuif na die begin';

  @override
  String get reorderItemUp => r'Skuif op';

  @override
  String get rowsPerPageTitle => r'Rye per bladsy:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Soek';

  @override
  String get selectAllButtonLabel => r'KIES ALLES';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item is gekies';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount items is gekies';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Wys rekeninge';

  @override
  String get showMenuTooltip => r'Wys kieslys';

  @override
  String get signedInLabel => r'Aangemeld';

  @override
  String get tabLabelRaw => r'Oortjie $tabIndex van $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Kies ure';

  @override
  String get timePickerMinuteModeAnnouncement => r'Kies minute';

  @override
  String get viewLicensesButtonLabel => r'BEKYK LISENSIES';
}

/// The translations for Amharic (`am`).
class MaterialLocalizationAm extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Amharic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAm({
    String localeName = 'am',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'ስለ $applicationName';

  @override
  String get alertDialogLabel => r'ማንቂያ';

  @override
  String get anteMeridiemAbbreviation => r'ጥዋት';

  @override
  String get backButtonTooltip => r'ተመለስ';

  @override
  String get cancelButtonLabel => r'ይቅር';

  @override
  String get closeButtonLabel => r'ዝጋ';

  @override
  String get closeButtonTooltip => r'ዝጋ';

  @override
  String get collapsedIconTapHint => r'ዘርጋ';

  @override
  String get continueButtonLabel => r'ቀጥል';

  @override
  String get copyButtonLabel => r'ቅዳ';

  @override
  String get cutButtonLabel => r'ቁረጥ';

  @override
  String get deleteButtonTooltip => r'ሰርዝ';

  @override
  String get dialogLabel => r'መገናኛ';

  @override
  String get drawerLabel => r'የዳሰሳ ምናሌ';

  @override
  String get expandedIconTapHint => r'ሰብስብ';

  @override
  String get hideAccountsLabel => r'መለያዎችን ደብቅ';

  @override
  String get licensesPageTitle => r'ፈቃዶች';

  @override
  String get modalBarrierDismissLabel => r'አሰናብት';

  @override
  String get nextMonthTooltip => r'ቀጣይ ወር';

  @override
  String get nextPageTooltip => r'ቀጣይ ገጽ';

  @override
  String get okButtonLabel => r'እሺ';

  @override
  String get openAppDrawerTooltip => r'የዳሰሳ ምናሌን ክፈት';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ከ$rowCount ውስጥ';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ከ$rowCount ያህል ውስጥ';

  @override
  String get pasteButtonLabel => r'ለጥፍ';

  @override
  String get popupMenuLabel => r'የብቅ-ባይ ምናሌ';

  @override
  String get postMeridiemAbbreviation => r'ከሰዓት';

  @override
  String get previousMonthTooltip => r'ቀዳሚ ወር';

  @override
  String get previousPageTooltip => r'ቀዳሚ ገጽ';

  @override
  String get refreshIndicatorSemanticLabel => r'አድስ';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 ቁምፊ ይቀራል';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount ቁምፊዎች ይቀራሉ';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'ወደ ታች ውሰድ';

  @override
  String get reorderItemLeft => r'ወደ ግራ ውሰድ';

  @override
  String get reorderItemRight => r'ወደ ቀኝ ውሰድ';

  @override
  String get reorderItemToEnd => r'ወደ መጨረሻ ውሰድ';

  @override
  String get reorderItemToStart => r'ወደ መጀመሪያ ውሰድ';

  @override
  String get reorderItemUp => r'ወደ ላይ ውሰድ';

  @override
  String get rowsPerPageTitle => r'ረድፎች በገጽ፦';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'ይፈልጉ';

  @override
  String get selectAllButtonLabel => r'ሁሉንም ምረጥ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 ንጥል ተመርጧል';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ንጥሎች ተመርጠዋል';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'መለያዎችን አሳይ';

  @override
  String get showMenuTooltip => r'ምናሌን አሳይ';

  @override
  String get signedInLabel => r'በመለያ ገብቷል';

  @override
  String get tabLabelRaw => r'ትር $tabIndex ከ$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'ሰዓታትን ምረጥ';

  @override
  String get timePickerMinuteModeAnnouncement => r'ደቂቃዎችን ይምረጡ';

  @override
  String get viewLicensesButtonLabel => r'ፈቃዶችን ይመልከቱ';
}

/// The translations for Arabic (`ar`).
class MaterialLocalizationAr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Arabic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAr({
    String localeName = 'ar',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'حول "$applicationName"';

  @override
  String get alertDialogLabel => r'تنبيه';

  @override
  String get anteMeridiemAbbreviation => r'ص';

  @override
  String get backButtonTooltip => r'رجوع';

  @override
  String get cancelButtonLabel => r'إلغاء';

  @override
  String get closeButtonLabel => r'إغلاق';

  @override
  String get closeButtonTooltip => r'إغلاق';

  @override
  String get collapsedIconTapHint => r'توسيع';

  @override
  String get continueButtonLabel => r'متابعة';

  @override
  String get copyButtonLabel => r'نسخ';

  @override
  String get cutButtonLabel => r'قص';

  @override
  String get deleteButtonTooltip => r'حذف';

  @override
  String get dialogLabel => r'مربع حوار';

  @override
  String get drawerLabel => r'قائمة تنقل';

  @override
  String get expandedIconTapHint => r'تصغير';

  @override
  String get hideAccountsLabel => r'إخفاء الحسابات';

  @override
  String get licensesPageTitle => r'التراخيص';

  @override
  String get modalBarrierDismissLabel => r'رفض';

  @override
  String get nextMonthTooltip => r'الشهر التالي';

  @override
  String get nextPageTooltip => r'الصفحة التالية';

  @override
  String get okButtonLabel => r'حسنًا';

  @override
  String get openAppDrawerTooltip => r'فتح قائمة التنقل';

  @override
  String get pageRowsInfoTitleRaw => r'من $firstRow إلى $lastRow من إجمالي $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'من $firstRow إلى $lastRow من إجمالي $rowCount تقريبًا';

  @override
  String get pasteButtonLabel => r'لصق';

  @override
  String get popupMenuLabel => r'قائمة منبثقة';

  @override
  String get postMeridiemAbbreviation => r'م';

  @override
  String get previousMonthTooltip => r'الشهر السابق';

  @override
  String get previousPageTooltip => r'الصفحة السابقة';

  @override
  String get refreshIndicatorSemanticLabel => r'إعادة تحميل';

  @override
  String get remainingTextFieldCharacterCountFew => r'$remainingCount أحرف متبقية';

  @override
  String get remainingTextFieldCharacterCountMany => r'$remainingCount حرفًا متبقيًا';

  @override
  String get remainingTextFieldCharacterCountOne => r'حرف واحد متبقٍ';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount حرف متبقٍ';

  @override
  String get remainingTextFieldCharacterCountTwo => r'حرفان ($remainingCount) متبقيان';

  @override
  String get remainingTextFieldCharacterCountZero => r'لا أحرف متبقية';

  @override
  String get reorderItemDown => r'نقل لأسفل';

  @override
  String get reorderItemLeft => r'نقل لليمين';

  @override
  String get reorderItemRight => r'نقل لليسار';

  @override
  String get reorderItemToEnd => r'نقل إلى نهاية القائمة';

  @override
  String get reorderItemToStart => r'نقل إلى بداية القائمة';

  @override
  String get reorderItemUp => r'نقل لأعلى';

  @override
  String get rowsPerPageTitle => r'عدد الصفوف في الصفحة:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'بحث';

  @override
  String get selectAllButtonLabel => r'اختيار الكل';

  @override
  String get selectedRowCountTitleFew => r'تم اختيار $selectedRowCount عنصر';

  @override
  String get selectedRowCountTitleMany => r'تم اختيار $selectedRowCount عنصرًا';

  @override
  String get selectedRowCountTitleOne => r'تم اختيار عنصر واحد';

  @override
  String get selectedRowCountTitleOther => r'تم اختيار $selectedRowCount عنصر';

  @override
  String get selectedRowCountTitleTwo => r'تم اختيار عنصرين ($selectedRowCount)';

  @override
  String get selectedRowCountTitleZero => r'لم يتم اختيار أي عنصر';

  @override
  String get showAccountsLabel => r'إظهار الحسابات';

  @override
  String get showMenuTooltip => r'عرض القائمة';

  @override
  String get signedInLabel => r'تم تسجيل الدخول';

  @override
  String get tabLabelRaw => r'علامة التبويب $tabIndex من $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'اختيار الساعات';

  @override
  String get timePickerMinuteModeAnnouncement => r'اختيار الدقائق';

  @override
  String get viewLicensesButtonLabel => r'الاطّلاع على التراخيص';
}

/// The translations for Assamese (`as`).
class MaterialLocalizationAs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Assamese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAs({
    String localeName = 'as',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationNameৰ বিষয়ে';

  @override
  String get alertDialogLabel => r'সতৰ্কবাৰ্তা';

  @override
  String get anteMeridiemAbbreviation => r'পূৰ্বাহ্ন';

  @override
  String get backButtonTooltip => r'উভতি যাওক';

  @override
  String get cancelButtonLabel => r'বাতিল কৰক';

  @override
  String get closeButtonLabel => r'বন্ধ কৰক';

  @override
  String get closeButtonTooltip => r'বন্ধ কৰক';

  @override
  String get collapsedIconTapHint => r'বিস্তাৰ কৰক';

  @override
  String get continueButtonLabel => r'অব্যাহত ৰাখক';

  @override
  String get copyButtonLabel => r'প্ৰতিলিপি কৰক';

  @override
  String get cutButtonLabel => r'কাট কৰক';

  @override
  String get deleteButtonTooltip => r'মচক';

  @override
  String get dialogLabel => r'ডায়ল' "'" r'গ';

  @override
  String get drawerLabel => r'নেভিগেশ্বন মেনু';

  @override
  String get expandedIconTapHint => r'সংকোচন কৰক';

  @override
  String get hideAccountsLabel => r'একাউণ্টসমূহ লুকুৱাওক';

  @override
  String get licensesPageTitle => r'অনুজ্ঞাপত্ৰসমূহ';

  @override
  String get modalBarrierDismissLabel => r'অগ্ৰাহ্য কৰক';

  @override
  String get nextMonthTooltip => r'পৰৱৰ্তী মাহ';

  @override
  String get nextPageTooltip => r'পৰৱৰ্তী পৃষ্ঠা';

  @override
  String get okButtonLabel => r'ঠিক আছে';

  @override
  String get openAppDrawerTooltip => r'নেভিগেশ্বন মেনু খোলক';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountৰ $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCountৰ $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'পে' "'" r'ষ্ট কৰক';

  @override
  String get popupMenuLabel => r'প' "'" r'পআপ মেনু';

  @override
  String get postMeridiemAbbreviation => r'অপৰাহ্ন';

  @override
  String get previousMonthTooltip => r'পূৰ্বৱৰ্তী মাহ';

  @override
  String get previousPageTooltip => r'পূৰ্বৱৰ্তী পৃষ্ঠা';

  @override
  String get refreshIndicatorSemanticLabel => r'ৰিফ্ৰেশ্ব কৰক';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'১টা বর্ণ বাকী আছে';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCountটা বর্ণ বাকী আছে';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'তললৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemLeft => r'বাওঁফাললৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemRight => r'সোঁফাললৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemToEnd => r'শেষলৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemToStart => r'আৰম্ভণিলৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemUp => r'ওপৰলৈ নিয়ক';

  @override
  String get rowsPerPageTitle => r'প্ৰতিটো পৃষ্ঠাত থকা শাৰী:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'সন্ধান কৰক';

  @override
  String get selectAllButtonLabel => r'সকলো বাছনি কৰক';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'১টা বস্তু বাছনি কৰা হ' "'" r'ল';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCountটা বস্তু বাছনি কৰা হ’ল';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'একাউণ্টসমূহ দেখুৱাওক';

  @override
  String get showMenuTooltip => r'মেনুখন দেখুৱাওক';

  @override
  String get signedInLabel => r'ছাইন ইন কৰা হ’ল';

  @override
  String get tabLabelRaw => r'$tabCountৰ $tabIndexটা টেব';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'সময় বাছনি কৰক';

  @override
  String get timePickerMinuteModeAnnouncement => r'মিনিট বাছনি কৰক';

  @override
  String get viewLicensesButtonLabel => r'অনুজ্ঞাপত্ৰসমূহ চাওক';
}

/// The translations for Azerbaijani (`az`).
class MaterialLocalizationAz extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Azerbaijani.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAz({
    String localeName = 'az',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName haqqında';

  @override
  String get alertDialogLabel => r'Bildiriş';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Geri';

  @override
  String get cancelButtonLabel => r'LƏĞV EDİN';

  @override
  String get closeButtonLabel => r'BAĞLAYIN';

  @override
  String get closeButtonTooltip => r'Bağlayın';

  @override
  String get collapsedIconTapHint => r'Genişləndirin';

  @override
  String get continueButtonLabel => r'DAVAM EDİN';

  @override
  String get copyButtonLabel => r'KOPYALAYIN';

  @override
  String get cutButtonLabel => r'KƏSİN';

  @override
  String get deleteButtonTooltip => r'Silin';

  @override
  String get dialogLabel => r'Dialoq';

  @override
  String get drawerLabel => r'Naviqasiya menyusu';

  @override
  String get expandedIconTapHint => r'Yığcamlaşdırın';

  @override
  String get hideAccountsLabel => r'Hesabları gizlədin';

  @override
  String get licensesPageTitle => r'Lisenziyalar';

  @override
  String get modalBarrierDismissLabel => r'İmtina edin';

  @override
  String get nextMonthTooltip => r'Növbəti ay';

  @override
  String get nextPageTooltip => r'Növbəti səhifə';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Naviqasiya menyusunu açın';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow/$rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow/ təxminən $rowCount';

  @override
  String get pasteButtonLabel => r'YERLƏŞDİRİN';

  @override
  String get popupMenuLabel => r'Popap menyusu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Keçən ay';

  @override
  String get previousPageTooltip => r'Əvvəlki səhifə';

  @override
  String get refreshIndicatorSemanticLabel => r'Yeniləyin';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 simvol qalır';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount simvol qalır';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Aşağı köçürün';

  @override
  String get reorderItemLeft => r'Sola köçürün';

  @override
  String get reorderItemRight => r'Sağa köçürün';

  @override
  String get reorderItemToEnd => r'Sona köçürün';

  @override
  String get reorderItemToStart => r'Əvvələ köçürün';

  @override
  String get reorderItemUp => r'Yuxarı köçürün';

  @override
  String get rowsPerPageTitle => r'Hər səhifə üzrə sıra:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Axtarın';

  @override
  String get selectAllButtonLabel => r'HAMISINI SEÇİN';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 element seçildi';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount element seçildi';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Hesabları göstərin';

  @override
  String get showMenuTooltip => r'Menyunu göstərin';

  @override
  String get signedInLabel => r'Daxil olundu';

  @override
  String get tabLabelRaw => r'$tabIndex/$tabCount tab';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Saat seçin';

  @override
  String get timePickerMinuteModeAnnouncement => r'Dəqiqə seçin';

  @override
  String get viewLicensesButtonLabel => r'LİSENZİYALARA BAXIN';
}

/// The translations for Belarusian (`be`).
class MaterialLocalizationBe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Belarusian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBe({
    String localeName = 'be',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Інфармацыя пра праграму "$applicationName"';

  @override
  String get alertDialogLabel => r'Абвестка';

  @override
  String get anteMeridiemAbbreviation => r'раніцы';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'СКАСАВАЦЬ';

  @override
  String get closeButtonLabel => r'ЗАКРЫЦЬ';

  @override
  String get closeButtonTooltip => r'Закрыць';

  @override
  String get collapsedIconTapHint => r'Разгарнуць';

  @override
  String get continueButtonLabel => r'ПРАЦЯГНУЦЬ';

  @override
  String get copyButtonLabel => r'КАПІРАВАЦЬ';

  @override
  String get cutButtonLabel => r'ВЫРАЗАЦЬ';

  @override
  String get deleteButtonTooltip => r'Выдаліць';

  @override
  String get dialogLabel => r'Дыялогавае акно';

  @override
  String get drawerLabel => r'Меню навігацыі';

  @override
  String get expandedIconTapHint => r'Згарнуць';

  @override
  String get hideAccountsLabel => r'Схаваць уліковыя запісы';

  @override
  String get licensesPageTitle => r'Ліцэнзіі';

  @override
  String get modalBarrierDismissLabel => r'Адхіліць';

  @override
  String get nextMonthTooltip => r'Наступны месяц';

  @override
  String get nextPageTooltip => r'Наступная старонка';

  @override
  String get okButtonLabel => r'ОК';

  @override
  String get openAppDrawerTooltip => r'Адкрыць меню навігацыі';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow з $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow з прыблізна $rowCount';

  @override
  String get pasteButtonLabel => r'УСТАВІЦЬ';

  @override
  String get popupMenuLabel => r'Меню ўсплывальнага акна';

  @override
  String get postMeridiemAbbreviation => r'вечара';

  @override
  String get previousMonthTooltip => r'Папярэдні месяц';

  @override
  String get previousPageTooltip => r'Папярэдняя старонка';

  @override
  String get refreshIndicatorSemanticLabel => r'Абнавіць';

  @override
  String get remainingTextFieldCharacterCountFew => r'Засталося $remainingCount сімвалы';

  @override
  String get remainingTextFieldCharacterCountMany => r'Засталося $remainingCount сімвалаў';

  @override
  String get remainingTextFieldCharacterCountOne => r'Застаўся 1 сімвал';

  @override
  String get remainingTextFieldCharacterCountOther => r'Засталося $remainingCount сімвала';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Перамясціць уніз';

  @override
  String get reorderItemLeft => r'Перамясціць улева';

  @override
  String get reorderItemRight => r'Перамясціць управа';

  @override
  String get reorderItemToEnd => r'Перамясціць у канец';

  @override
  String get reorderItemToStart => r'Перамясціць у пачатак';

  @override
  String get reorderItemUp => r'Перамясціць уверх';

  @override
  String get rowsPerPageTitle => r'Радкоў на старонку:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Пошук';

  @override
  String get selectAllButtonLabel => r'ВЫБРАЦЬ УСЕ';

  @override
  String get selectedRowCountTitleFew => r'Выбрана $selectedRowCount элементы';

  @override
  String get selectedRowCountTitleMany => r'Выбрана $selectedRowCount элементаў';

  @override
  String get selectedRowCountTitleOne => r'Выбраны 1 элемент';

  @override
  String get selectedRowCountTitleOther => r'Выбрана $selectedRowCount элемента';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Паказаць уліковыя запісы';

  @override
  String get showMenuTooltip => r'Паказаць меню';

  @override
  String get signedInLabel => r'Уваход выкананы';

  @override
  String get tabLabelRaw => r'Укладка $tabIndex з $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Выберыце гадзіны';

  @override
  String get timePickerMinuteModeAnnouncement => r'Выберыце хвіліны';

  @override
  String get viewLicensesButtonLabel => r'ПАКАЗАЦЬ ЛІЦЭНЗІІ';
}

/// The translations for Bulgarian (`bg`).
class MaterialLocalizationBg extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Bulgarian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBg({
    String localeName = 'bg',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Всичко за $applicationName';

  @override
  String get alertDialogLabel => r'Сигнал';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'ОТКАЗ';

  @override
  String get closeButtonLabel => r'ЗАТВАРЯНЕ';

  @override
  String get closeButtonTooltip => r'Затваряне';

  @override
  String get collapsedIconTapHint => r'Разгъване';

  @override
  String get continueButtonLabel => r'НАПРЕД';

  @override
  String get copyButtonLabel => r'КОПИРАНЕ';

  @override
  String get cutButtonLabel => r'ИЗРЯЗВАНЕ';

  @override
  String get deleteButtonTooltip => r'Изтриване';

  @override
  String get dialogLabel => r'Диалогов прозорец';

  @override
  String get drawerLabel => r'Меню за навигация';

  @override
  String get expandedIconTapHint => r'Свиване';

  @override
  String get hideAccountsLabel => r'Скриване на профилите';

  @override
  String get licensesPageTitle => r'Лицензи';

  @override
  String get modalBarrierDismissLabel => r'Отхвърляне';

  @override
  String get nextMonthTooltip => r'Следващият месец';

  @override
  String get nextPageTooltip => r'Следващата страница';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Отваряне на менюто за навигация';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow от $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow от около $rowCount';

  @override
  String get pasteButtonLabel => r'ПОСТАВЯНЕ';

  @override
  String get popupMenuLabel => r'Изскачащо меню';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Предишният месец';

  @override
  String get previousPageTooltip => r'Предишната страница';

  @override
  String get refreshIndicatorSemanticLabel => r'Опресняване';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Остава 1 знак';

  @override
  String get remainingTextFieldCharacterCountOther => r'Остават $remainingCount знака';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Преместване надолу';

  @override
  String get reorderItemLeft => r'Преместване наляво';

  @override
  String get reorderItemRight => r'Преместване надясно';

  @override
  String get reorderItemToEnd => r'Преместване в края';

  @override
  String get reorderItemToStart => r'Преместване в началото';

  @override
  String get reorderItemUp => r'Преместване нагоре';

  @override
  String get rowsPerPageTitle => r'Редове на страница:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Търсене';

  @override
  String get selectAllButtonLabel => r'ИЗБИРАНЕ НА ВСИЧКО';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Избран е 1 елемент';

  @override
  String get selectedRowCountTitleOther => r'Избрани са $selectedRowCount елемента';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Показване на профилите';

  @override
  String get showMenuTooltip => r'Показване на менюто';

  @override
  String get signedInLabel => r'В профила си сте';

  @override
  String get tabLabelRaw => r'Раздел $tabIndex от $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Избиране на часове';

  @override
  String get timePickerMinuteModeAnnouncement => r'Избиране на минути';

  @override
  String get viewLicensesButtonLabel => r'ПРЕГЛЕД НА ЛИЦЕНЗИТЕ';
}

/// The translations for Bengali Bangla (`bn`).
class MaterialLocalizationBn extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Bengali Bangla.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBn({
    String localeName = 'bn',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName সম্পর্কে';

  @override
  String get alertDialogLabel => r'সতর্কতা';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'ফিরে যান';

  @override
  String get cancelButtonLabel => r'বাতিল করুন';

  @override
  String get closeButtonLabel => r'বন্ধ করুন';

  @override
  String get closeButtonTooltip => r'বন্ধ করুন';

  @override
  String get collapsedIconTapHint => r'বড় করুন';

  @override
  String get continueButtonLabel => r'চালিয়ে যান';

  @override
  String get copyButtonLabel => r'কপি করুন';

  @override
  String get cutButtonLabel => r'কাট করুন';

  @override
  String get deleteButtonTooltip => r'মুছে দিন';

  @override
  String get dialogLabel => r'ডায়ালগ';

  @override
  String get drawerLabel => r'নেভিগেশান মেনু';

  @override
  String get expandedIconTapHint => r'আড়াল করুন';

  @override
  String get hideAccountsLabel => r'অ্যাকাউন্টগুলি লুকান';

  @override
  String get licensesPageTitle => r'লাইসেন্স';

  @override
  String get modalBarrierDismissLabel => r'খারিজ করুন';

  @override
  String get nextMonthTooltip => r'পরের মাস';

  @override
  String get nextPageTooltip => r'পরের পৃষ্ঠা';

  @override
  String get okButtonLabel => r'ঠিক আছে';

  @override
  String get openAppDrawerTooltip => r'নেভিগেশন মেনু খুলুন';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountটির মধ্যে $firstRow-$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'প্রায় $rowCountটির মধ্যে $firstRow-$lastRow নম্বর';

  @override
  String get pasteButtonLabel => r'পেস্ট করুন';

  @override
  String get popupMenuLabel => r'পপ-আপ মেনু';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'আগের মাস';

  @override
  String get previousPageTooltip => r'আগের পৃষ্ঠা';

  @override
  String get refreshIndicatorSemanticLabel => r'রিফ্রেশ করুন';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'আর ১টি অক্ষর লেখা যাবে';

  @override
  String get remainingTextFieldCharacterCountOther => r'আর $remainingCountটি অক্ষর লেখা যাবে';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'নিচের দিকে সরান';

  @override
  String get reorderItemLeft => r'বাঁদিকে সরান';

  @override
  String get reorderItemRight => r'ডানদিকে সরান';

  @override
  String get reorderItemToEnd => r'একদম শেষের দিকে যান';

  @override
  String get reorderItemToStart => r'চালু করতে সরান';

  @override
  String get reorderItemUp => r'উপরের দিকে সরান';

  @override
  String get rowsPerPageTitle => r'প্রতি পৃষ্ঠায় সারির সংখ্যা:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'সার্চ';

  @override
  String get selectAllButtonLabel => r'সব বেছে নিন';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'১টি আইটেম বেছে নেওয়া হয়েছে';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCountটি আইটেম বেছে নেওয়া হয়েছে';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'অ্যাকাউন্টগুলি দেখান';

  @override
  String get showMenuTooltip => r'মেনু দেখান';

  @override
  String get signedInLabel => r'সাইন-ইন করা হয়েছে';

  @override
  String get tabLabelRaw => r'$tabCount-এর মধ্যে $tabIndexটি ট্যাব';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'ঘণ্টা বেছে নিন';

  @override
  String get timePickerMinuteModeAnnouncement => r'মিনিট বেছে নিন';

  @override
  String get viewLicensesButtonLabel => r'লাইসেন্স দেখুন';
}

/// The translations for Bosnian (`bs`).
class MaterialLocalizationBs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Bosnian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBs({
    String localeName = 'bs',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => r'Upozorenje';

  @override
  String get anteMeridiemAbbreviation => r'prijepodne';

  @override
  String get backButtonTooltip => r'Natrag';

  @override
  String get cancelButtonLabel => r'ODUSTANI';

  @override
  String get closeButtonLabel => r'ZATVORI';

  @override
  String get closeButtonTooltip => r'Zatvaranje';

  @override
  String get collapsedIconTapHint => r'Proširi';

  @override
  String get continueButtonLabel => r'NASTAVI';

  @override
  String get copyButtonLabel => r'KOPIRAJ';

  @override
  String get cutButtonLabel => r'IZREŽI';

  @override
  String get deleteButtonTooltip => r'Brisanje';

  @override
  String get dialogLabel => r'Dijalog';

  @override
  String get drawerLabel => r'Navigacijski izbornik';

  @override
  String get expandedIconTapHint => r'Sažmi';

  @override
  String get hideAccountsLabel => r'Sakrijte račune';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get modalBarrierDismissLabel => r'Odbaci';

  @override
  String get nextMonthTooltip => r'Sljedeći mjesec';

  @override
  String get nextPageTooltip => r'Sljedeća stranica';

  @override
  String get okButtonLabel => r'U REDU';

  @override
  String get openAppDrawerTooltip => r'Otvaranje izbornika za navigaciju';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow od otprilike $rowCount';

  @override
  String get pasteButtonLabel => r'ZALIJEPI';

  @override
  String get popupMenuLabel => r'Skočni izbornik';

  @override
  String get postMeridiemAbbreviation => r'popodne';

  @override
  String get previousMonthTooltip => r'Prethodni mjesec';

  @override
  String get previousPageTooltip => r'Prethodna stranica';

  @override
  String get refreshIndicatorSemanticLabel => r'Osvježi';

  @override
  String get remainingTextFieldCharacterCountFew => r'Preostala su $remainingCount znaka';

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Preostao je 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Preostalo je $remainingCount znakova';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Pomakni prema dolje';

  @override
  String get reorderItemLeft => r'Pomakni ulijevo';

  @override
  String get reorderItemRight => r'Pomakni udesno';

  @override
  String get reorderItemToEnd => r'Premjesti na kraj';

  @override
  String get reorderItemToStart => r'Premjesti na početak';

  @override
  String get reorderItemUp => r'Pomakni prema gore';

  @override
  String get rowsPerPageTitle => r'Redaka po stranici:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Pretražite';

  @override
  String get selectAllButtonLabel => r'ODABERI SVE';

  @override
  String get selectedRowCountTitleFew => r'Odabrane su $selectedRowCount stavke';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Odabrana je jedna stavka';

  @override
  String get selectedRowCountTitleOther => r'Odabrano je $selectedRowCount stavki';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Prikažite račune';

  @override
  String get showMenuTooltip => r'Prikaz izbornika';

  @override
  String get signedInLabel => r'Prijavljeni korisnik';

  @override
  String get tabLabelRaw => r'Kartica $tabIndex od $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Odaberite sate';

  @override
  String get timePickerMinuteModeAnnouncement => r'Odaberite minute';

  @override
  String get viewLicensesButtonLabel => r'PRIKAŽI LICENCE';
}

/// The translations for Catalan Valencian (`ca`).
class MaterialLocalizationCa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Catalan Valencian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationCa({
    String localeName = 'ca',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Sobre $applicationName';

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Enrere';

  @override
  String get cancelButtonLabel => r'CANCEL·LA';

  @override
  String get closeButtonLabel => r'TANCA';

  @override
  String get closeButtonTooltip => r'Tanca';

  @override
  String get collapsedIconTapHint => r'Desplega';

  @override
  String get continueButtonLabel => r'CONTINUA';

  @override
  String get copyButtonLabel => r'COPIA';

  @override
  String get cutButtonLabel => r'RETALLA';

  @override
  String get deleteButtonTooltip => r'Suprimeix';

  @override
  String get dialogLabel => r'Diàleg';

  @override
  String get drawerLabel => r'Menú de navegació';

  @override
  String get expandedIconTapHint => r'Replega';

  @override
  String get hideAccountsLabel => r'Amaga els comptes';

  @override
  String get licensesPageTitle => r'Llicències';

  @override
  String get modalBarrierDismissLabel => r'Ignora';

  @override
  String get nextMonthTooltip => r'Mes següent';

  @override
  String get nextPageTooltip => r'Pàgina següent';

  @override
  String get okButtonLabel => r'D' "'" r'ACORD';

  @override
  String get openAppDrawerTooltip => r'Obre el menú de navegació';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow d' "'" r'aproximadament $rowCount';

  @override
  String get pasteButtonLabel => r'ENGANXA';

  @override
  String get popupMenuLabel => r'Menú emergent';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Mes anterior';

  @override
  String get previousPageTooltip => r'Pàgina anterior';

  @override
  String get refreshIndicatorSemanticLabel => r'Actualitza';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 caràcter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Queden $remainingCount caràcters';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Mou avall';

  @override
  String get reorderItemLeft => r'Mou cap a l' "'" r'esquerra';

  @override
  String get reorderItemRight => r'Mou cap a la dreta';

  @override
  String get reorderItemToEnd => r'Mou al final';

  @override
  String get reorderItemToStart => r'Mou al principi';

  @override
  String get reorderItemUp => r'Mou amunt';

  @override
  String get rowsPerPageTitle => r'Files per pàgina:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Cerca';

  @override
  String get selectAllButtonLabel => r'SELECCIONA-HO TOT';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'S' "'" r'ha seleccionat 1 element';

  @override
  String get selectedRowCountTitleOther => r'S' "'" r'han seleccionat $selectedRowCount elements';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Mostra els comptes';

  @override
  String get showMenuTooltip => r'Mostra el menú';

  @override
  String get signedInLabel => r'Sessió iniciada';

  @override
  String get tabLabelRaw => r'Pestanya $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Selecciona les hores';

  @override
  String get timePickerMinuteModeAnnouncement => r'Selecciona els minuts';

  @override
  String get viewLicensesButtonLabel => r'MOSTRA LES LLICÈNCIES';
}

/// The translations for Czech (`cs`).
class MaterialLocalizationCs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Czech.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationCs({
    String localeName = 'cs',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaci $applicationName';

  @override
  String get alertDialogLabel => r'Upozornění';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Zpět';

  @override
  String get cancelButtonLabel => r'ZRUŠIT';

  @override
  String get closeButtonLabel => r'ZAVŘÍT';

  @override
  String get closeButtonTooltip => r'Zavřít';

  @override
  String get collapsedIconTapHint => r'Rozbalit';

  @override
  String get continueButtonLabel => r'POKRAČOVAT';

  @override
  String get copyButtonLabel => r'KOPÍROVAT';

  @override
  String get cutButtonLabel => r'VYJMOUT';

  @override
  String get deleteButtonTooltip => r'Smazat';

  @override
  String get dialogLabel => r'Dialogové okno';

  @override
  String get drawerLabel => r'Navigační nabídka';

  @override
  String get expandedIconTapHint => r'Sbalit';

  @override
  String get hideAccountsLabel => r'Skrýt účty';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get modalBarrierDismissLabel => r'Zavřít';

  @override
  String get nextMonthTooltip => r'Další měsíc';

  @override
  String get nextPageTooltip => r'Další stránka';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Otevřít navigační nabídku';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow z $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow z asi $rowCount';

  @override
  String get pasteButtonLabel => r'VLOŽIT';

  @override
  String get popupMenuLabel => r'Vyskakovací nabídka';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Předchozí měsíc';

  @override
  String get previousPageTooltip => r'Předchozí stránka';

  @override
  String get refreshIndicatorSemanticLabel => r'Obnovit';

  @override
  String get remainingTextFieldCharacterCountFew => r'Zbývají $remainingCount znaky';

  @override
  String get remainingTextFieldCharacterCountMany => r'Zbývá $remainingCount znaku';

  @override
  String get remainingTextFieldCharacterCountOne => r'Zbývá 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Zbývá $remainingCount znaků';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Přesunout dolů';

  @override
  String get reorderItemLeft => r'Přesunout doleva';

  @override
  String get reorderItemRight => r'Přesunout doprava';

  @override
  String get reorderItemToEnd => r'Přesunout na konec';

  @override
  String get reorderItemToStart => r'Přesunout na začátek';

  @override
  String get reorderItemUp => r'Přesunout nahoru';

  @override
  String get rowsPerPageTitle => r'Počet řádků na stránku:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Hledat';

  @override
  String get selectAllButtonLabel => r'VYBRAT VŠE';

  @override
  String get selectedRowCountTitleFew => r'Jsou vybrány $selectedRowCount položky';

  @override
  String get selectedRowCountTitleMany => r'Je vybráno $selectedRowCount položky';

  @override
  String get selectedRowCountTitleOne => r'Je vybrána 1 položka';

  @override
  String get selectedRowCountTitleOther => r'Je vybráno $selectedRowCount položek';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Zobrazit účty';

  @override
  String get showMenuTooltip => r'Zobrazit nabídku';

  @override
  String get signedInLabel => r'Uživatel přihlášen';

  @override
  String get tabLabelRaw => r'Karta $tabIndex z $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Vyberte hodiny';

  @override
  String get timePickerMinuteModeAnnouncement => r'Vyberte minuty';

  @override
  String get viewLicensesButtonLabel => r'ZOBRAZIT LICENCE';
}

/// The translations for Danish (`da`).
class MaterialLocalizationDa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Danish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationDa({
    String localeName = 'da',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => r'Underretning';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Tilbage';

  @override
  String get cancelButtonLabel => r'ANNULLER';

  @override
  String get closeButtonLabel => r'LUK';

  @override
  String get closeButtonTooltip => r'Luk';

  @override
  String get collapsedIconTapHint => r'Udvid';

  @override
  String get continueButtonLabel => r'FORTSÆT';

  @override
  String get copyButtonLabel => r'KOPIÉR';

  @override
  String get cutButtonLabel => r'KLIP';

  @override
  String get deleteButtonTooltip => r'Slet';

  @override
  String get dialogLabel => r'Dialogboks';

  @override
  String get drawerLabel => r'Navigationsmenu';

  @override
  String get expandedIconTapHint => r'Skjul';

  @override
  String get hideAccountsLabel => r'Skjul konti';

  @override
  String get licensesPageTitle => r'Licenser';

  @override
  String get modalBarrierDismissLabel => r'Afvis';

  @override
  String get nextMonthTooltip => r'Næste måned';

  @override
  String get nextPageTooltip => r'Næste side';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Åbn navigationsmenuen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow af $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow af ca. $rowCount';

  @override
  String get pasteButtonLabel => r'SÆT IND';

  @override
  String get popupMenuLabel => r'Pop op-menu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Forrige måned';

  @override
  String get previousPageTooltip => r'Forrige side';

  @override
  String get refreshIndicatorSemanticLabel => r'Opdater';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Ét tegn tilbage';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount tegn tilbage';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Flyt ned';

  @override
  String get reorderItemLeft => r'Flyt til venstre';

  @override
  String get reorderItemRight => r'Flyt til højre';

  @override
  String get reorderItemToEnd => r'Flyt til sidst på listen';

  @override
  String get reorderItemToStart => r'Flyt til først på listen';

  @override
  String get reorderItemUp => r'Flyt op';

  @override
  String get rowsPerPageTitle => r'Rækker pr. side:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Søg';

  @override
  String get selectAllButtonLabel => r'VÆLG ALLE';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 element er valgt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementer er valgt';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Vis konti';

  @override
  String get showMenuTooltip => r'Vis menu';

  @override
  String get signedInLabel => r'Logget ind';

  @override
  String get tabLabelRaw => r'Fane $tabIndex af $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Vælg timer';

  @override
  String get timePickerMinuteModeAnnouncement => r'Vælg minutter';

  @override
  String get viewLicensesButtonLabel => r'SE LICENSER';
}

/// The translations for German (`de`).
class MaterialLocalizationDe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for German.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationDe({
    String localeName = 'de',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Über $applicationName';

  @override
  String get alertDialogLabel => r'Benachrichtigung';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Zurück';

  @override
  String get cancelButtonLabel => r'ABBRECHEN';

  @override
  String get closeButtonLabel => r'SCHLIEẞEN';

  @override
  String get closeButtonTooltip => r'Schließen';

  @override
  String get collapsedIconTapHint => r'Maximieren';

  @override
  String get continueButtonLabel => r'WEITER';

  @override
  String get copyButtonLabel => r'KOPIEREN';

  @override
  String get cutButtonLabel => r'AUSSCHNEIDEN';

  @override
  String get deleteButtonTooltip => r'Löschen';

  @override
  String get dialogLabel => r'Dialogfeld';

  @override
  String get drawerLabel => r'Navigationsmenü';

  @override
  String get expandedIconTapHint => r'Minimieren';

  @override
  String get hideAccountsLabel => r'Konten ausblenden';

  @override
  String get licensesPageTitle => r'Lizenzen';

  @override
  String get modalBarrierDismissLabel => r'Schließen';

  @override
  String get nextMonthTooltip => r'Nächster Monat';

  @override
  String get nextPageTooltip => r'Nächste Seite';

  @override
  String get okButtonLabel => r'Ok';

  @override
  String get openAppDrawerTooltip => r'Navigationsmenü öffnen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow von $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow von etwa $rowCount';

  @override
  String get pasteButtonLabel => r'EINFÜGEN';

  @override
  String get popupMenuLabel => r'Pop-up-Menü';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Vorheriger Monat';

  @override
  String get previousPageTooltip => r'Vorherige Seite';

  @override
  String get refreshIndicatorSemanticLabel => r'Aktualisieren';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Noch 1 Zeichen';

  @override
  String get remainingTextFieldCharacterCountOther => r'Noch $remainingCount Zeichen';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Nach unten verschieben';

  @override
  String get reorderItemLeft => r'Nach links verschieben';

  @override
  String get reorderItemRight => r'Nach rechts verschieben';

  @override
  String get reorderItemToEnd => r'An das Ende verschieben';

  @override
  String get reorderItemToStart => r'An den Anfang verschieben';

  @override
  String get reorderItemUp => r'Nach oben verschieben';

  @override
  String get rowsPerPageTitle => r'Zeilen pro Seite:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Suchen';

  @override
  String get selectAllButtonLabel => r'ALLE AUSWÄHLEN';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 Element ausgewählt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount Elemente ausgewählt';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Keine Objekte ausgewählt';

  @override
  String get showAccountsLabel => r'Konten anzeigen';

  @override
  String get showMenuTooltip => r'Menü anzeigen';

  @override
  String get signedInLabel => r'Angemeldet';

  @override
  String get tabLabelRaw => r'Tab $tabIndex von $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Stunden auswählen';

  @override
  String get timePickerMinuteModeAnnouncement => r'Minuten auswählen';

  @override
  String get viewLicensesButtonLabel => r'LIZENZEN ANZEIGEN';
}

/// The translations for German, as used in Switzerland (`de_CH`).
class MaterialLocalizationDeCh extends MaterialLocalizationDe {
  /// Create an instance of the translation bundle for German, as used in Switzerland.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationDeCh({
    String localeName = 'de_CH',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get closeButtonTooltip => r'Schliessen';

  @override
  String get modalBarrierDismissLabel => r'Schliessen';
}

/// The translations for Modern Greek (`el`).
class MaterialLocalizationEl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Modern Greek.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEl({
    String localeName = 'el',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Σχετικά με την εφαρμογή $applicationName';

  @override
  String get alertDialogLabel => r'Ειδοποίηση';

  @override
  String get anteMeridiemAbbreviation => r'π.μ.';

  @override
  String get backButtonTooltip => r'Πίσω';

  @override
  String get cancelButtonLabel => r'ΑΚΥΡΩΣΗ';

  @override
  String get closeButtonLabel => r'ΚΛΕΙΣΙΜΟ';

  @override
  String get closeButtonTooltip => r'Κλείσιμο';

  @override
  String get collapsedIconTapHint => r'Ανάπτυξη';

  @override
  String get continueButtonLabel => r'ΣΥΝΕΧΕΙΑ';

  @override
  String get copyButtonLabel => r'ΑΝΤΙΓΡΑΦΗ';

  @override
  String get cutButtonLabel => r'ΑΠΟΚΟΠΗ';

  @override
  String get deleteButtonTooltip => r'Διαγραφή';

  @override
  String get dialogLabel => r'Παράθυρο διαλόγου';

  @override
  String get drawerLabel => r'Μενού πλοήγησης';

  @override
  String get expandedIconTapHint => r'Σύμπτυξη';

  @override
  String get hideAccountsLabel => r'Απόκρυψη λογαριασμών';

  @override
  String get licensesPageTitle => r'Άδειες';

  @override
  String get modalBarrierDismissLabel => r'Παράβλεψη';

  @override
  String get nextMonthTooltip => r'Επόμενος μήνας';

  @override
  String get nextPageTooltip => r'Επόμενη σελίδα';

  @override
  String get okButtonLabel => r'ΟΚ';

  @override
  String get openAppDrawerTooltip => r'Άνοιγμα μενού πλοήγησης';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow από $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow από περίπου $rowCount';

  @override
  String get pasteButtonLabel => r'ΕΠΙΚΟΛΛΗΣΗ';

  @override
  String get popupMenuLabel => r'Αναδυόμενο μενού';

  @override
  String get postMeridiemAbbreviation => r'μ.μ.';

  @override
  String get previousMonthTooltip => r'Προηγούμενος μήνας';

  @override
  String get previousPageTooltip => r'Προηγούμενη σελίδα';

  @override
  String get refreshIndicatorSemanticLabel => r'Ανανέωση';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'απομένει 1 χαρακτήρας';

  @override
  String get remainingTextFieldCharacterCountOther => r'απομένουν $remainingCount χαρακτήρες';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Μετακίνηση προς τα κάτω';

  @override
  String get reorderItemLeft => r'Μετακίνηση αριστερά';

  @override
  String get reorderItemRight => r'Μετακίνηση δεξιά';

  @override
  String get reorderItemToEnd => r'Μετακίνηση στο τέλος';

  @override
  String get reorderItemToStart => r'Μετακίνηση στην αρχή';

  @override
  String get reorderItemUp => r'Μετακίνηση προς τα πάνω';

  @override
  String get rowsPerPageTitle => r'Σειρές ανά σελίδα:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Αναζήτηση';

  @override
  String get selectAllButtonLabel => r'ΕΠΙΛΟΓΗ ΟΛΩΝ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Επιλέχθηκε 1 στοιχείο';

  @override
  String get selectedRowCountTitleOther => r'Επιλέχθηκαν $selectedRowCount στοιχεία';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Εμφάνιση λογαριασμών';

  @override
  String get showMenuTooltip => r'Εμφάνιση μενού';

  @override
  String get signedInLabel => r'Σε σύνδεση';

  @override
  String get tabLabelRaw => r'Καρτέλα $tabIndex από $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Επιλογή ωρών';

  @override
  String get timePickerMinuteModeAnnouncement => r'Επιλογή λεπτών';

  @override
  String get viewLicensesButtonLabel => r'ΠΡΟΒΟΛΗ ΑΔΕΙΩΝ';
}

/// The translations for English (`en`).
class MaterialLocalizationEn extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for English.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEn({
    String localeName = 'en',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'About $applicationName';

  @override
  String get alertDialogLabel => r'Alert';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Back';

  @override
  String get cancelButtonLabel => r'CANCEL';

  @override
  String get closeButtonLabel => r'CLOSE';

  @override
  String get closeButtonTooltip => r'Close';

  @override
  String get collapsedIconTapHint => r'Expand';

  @override
  String get continueButtonLabel => r'CONTINUE';

  @override
  String get copyButtonLabel => r'COPY';

  @override
  String get cutButtonLabel => r'CUT';

  @override
  String get deleteButtonTooltip => r'Delete';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Navigation menu';

  @override
  String get expandedIconTapHint => r'Collapse';

  @override
  String get hideAccountsLabel => r'Hide accounts';

  @override
  String get licensesPageTitle => r'Licenses';

  @override
  String get modalBarrierDismissLabel => r'Dismiss';

  @override
  String get nextMonthTooltip => r'Next month';

  @override
  String get nextPageTooltip => r'Next page';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Open navigation menu';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow of $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow of about $rowCount';

  @override
  String get pasteButtonLabel => r'PASTE';

  @override
  String get popupMenuLabel => r'Popup menu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Previous month';

  @override
  String get previousPageTooltip => r'Previous page';

  @override
  String get refreshIndicatorSemanticLabel => r'Refresh';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 character remaining';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount characters remaining';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'No characters remaining';

  @override
  String get reorderItemDown => r'Move down';

  @override
  String get reorderItemLeft => r'Move left';

  @override
  String get reorderItemRight => r'Move right';

  @override
  String get reorderItemToEnd => r'Move to the end';

  @override
  String get reorderItemToStart => r'Move to the start';

  @override
  String get reorderItemUp => r'Move up';

  @override
  String get rowsPerPageTitle => r'Rows per page:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Search';

  @override
  String get selectAllButtonLabel => r'SELECT ALL';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item selected';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount items selected';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'No items selected';

  @override
  String get showAccountsLabel => r'Show accounts';

  @override
  String get showMenuTooltip => r'Show menu';

  @override
  String get signedInLabel => r'Signed in';

  @override
  String get tabLabelRaw => r'Tab $tabIndex of $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'Select hours';

  @override
  String get timePickerMinuteModeAnnouncement => r'Select minutes';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENSES';
}

/// The translations for English, as used in Australia (`en_AU`).
class MaterialLocalizationEnAu extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Australia.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnAu({
    String localeName = 'en_AU',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';

  @override
  String get reorderItemLeft => r'Move to the left';

  @override
  String get reorderItemRight => r'Move to the right';
}

/// The translations for English, as used in Canada (`en_CA`).
class MaterialLocalizationEnCa extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Canada.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnCa({
    String localeName = 'en_CA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';

  @override
  String get reorderItemLeft => r'Move to the left';

  @override
  String get reorderItemRight => r'Move to the right';
}

/// The translations for English, as used in the United Kingdom (`en_GB`).
class MaterialLocalizationEnGb extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in the United Kingdom.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnGb({
    String localeName = 'en_GB',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';

  @override
  String get reorderItemLeft => r'Move to the left';

  @override
  String get reorderItemRight => r'Move to the right';
}

/// The translations for English, as used in Ireland (`en_IE`).
class MaterialLocalizationEnIe extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Ireland.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnIe({
    String localeName = 'en_IE',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';

  @override
  String get reorderItemLeft => r'Move to the left';

  @override
  String get reorderItemRight => r'Move to the right';
}

/// The translations for English, as used in India (`en_IN`).
class MaterialLocalizationEnIn extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in India.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnIn({
    String localeName = 'en_IN',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';

  @override
  String get reorderItemLeft => r'Move to the left';

  @override
  String get reorderItemRight => r'Move to the right';
}

/// The translations for English, as used in Singapore (`en_SG`).
class MaterialLocalizationEnSg extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Singapore.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnSg({
    String localeName = 'en_SG',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';

  @override
  String get reorderItemLeft => r'Move to the left';

  @override
  String get reorderItemRight => r'Move to the right';
}

/// The translations for English, as used in South Africa (`en_ZA`).
class MaterialLocalizationEnZa extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in South Africa.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnZa({
    String localeName = 'en_ZA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get viewLicensesButtonLabel => r'VIEW LICENCES';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get popupMenuLabel => r'Pop-up menu';

  @override
  String get dialogLabel => r'Dialogue';

  @override
  String get reorderItemLeft => r'Move to the left';

  @override
  String get reorderItemRight => r'Move to the right';
}

/// The translations for Spanish Castilian (`es`).
class MaterialLocalizationEs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Spanish Castilian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEs({
    String localeName = 'es',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Sobre $applicationName';

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'A.M.';

  @override
  String get backButtonTooltip => r'Atrás';

  @override
  String get cancelButtonLabel => r'CANCELAR';

  @override
  String get closeButtonLabel => r'CERRAR';

  @override
  String get closeButtonTooltip => r'Cerrar';

  @override
  String get collapsedIconTapHint => r'Mostrar';

  @override
  String get continueButtonLabel => r'CONTINUAR';

  @override
  String get copyButtonLabel => r'COPIAR';

  @override
  String get cutButtonLabel => r'CORTAR';

  @override
  String get deleteButtonTooltip => r'Eliminar';

  @override
  String get dialogLabel => r'Cuadro de diálogo';

  @override
  String get drawerLabel => r'Menú de navegación';

  @override
  String get expandedIconTapHint => r'Ocultar';

  @override
  String get hideAccountsLabel => r'Ocultar cuentas';

  @override
  String get licensesPageTitle => r'Licencias';

  @override
  String get modalBarrierDismissLabel => r'Cerrar';

  @override
  String get nextMonthTooltip => r'Mes siguiente';

  @override
  String get nextPageTooltip => r'Página siguiente';

  @override
  String get okButtonLabel => r'ACEPTAR';

  @override
  String get openAppDrawerTooltip => r'Abrir el menú de navegación';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow‑$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow‑$lastRow de aproximadamente $rowCount';

  @override
  String get pasteButtonLabel => r'PEGAR';

  @override
  String get popupMenuLabel => r'Menú emergente';

  @override
  String get postMeridiemAbbreviation => r'P.M.';

  @override
  String get previousMonthTooltip => r'Mes anterior';

  @override
  String get previousPageTooltip => r'Página anterior';

  @override
  String get refreshIndicatorSemanticLabel => r'Actualizar';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter.';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Mover hacia abajo';

  @override
  String get reorderItemLeft => r'Mover hacia la izquierda';

  @override
  String get reorderItemRight => r'Mover hacia la derecha';

  @override
  String get reorderItemToEnd => r'Mover al final';

  @override
  String get reorderItemToStart => r'Mover al principio';

  @override
  String get reorderItemUp => r'Mover hacia arriba';

  @override
  String get rowsPerPageTitle => r'Filas por página:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Buscar';

  @override
  String get selectAllButtonLabel => r'SELECCIONAR TODO';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 elemento seleccionado';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementos seleccionados';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'No se han seleccionado elementos';

  @override
  String get showAccountsLabel => r'Mostrar cuentas';

  @override
  String get showMenuTooltip => r'Mostrar menú';

  @override
  String get signedInLabel => r'Sesión iniciada';

  @override
  String get tabLabelRaw => r'Pestaña $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Seleccionar horas';

  @override
  String get timePickerMinuteModeAnnouncement => r'Seleccionar minutos';

  @override
  String get viewLicensesButtonLabel => r'VER LICENCIAS';
}

/// The translations for Spanish Castilian, as used in Latin America and the Caribbean (`es_419`).
class MaterialLocalizationEs419 extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Latin America and the Caribbean.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEs419({
    String localeName = 'es_419',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Argentina (`es_AR`).
class MaterialLocalizationEsAr extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Argentina.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsAr({
    String localeName = 'es_AR',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Bolivia (`es_BO`).
class MaterialLocalizationEsBo extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Bolivia.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsBo({
    String localeName = 'es_BO',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Chile (`es_CL`).
class MaterialLocalizationEsCl extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Chile.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsCl({
    String localeName = 'es_CL',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Colombia (`es_CO`).
class MaterialLocalizationEsCo extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Colombia.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsCo({
    String localeName = 'es_CO',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Costa Rica (`es_CR`).
class MaterialLocalizationEsCr extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Costa Rica.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsCr({
    String localeName = 'es_CR',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in the Dominican Republic (`es_DO`).
class MaterialLocalizationEsDo extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in the Dominican Republic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsDo({
    String localeName = 'es_DO',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Ecuador (`es_EC`).
class MaterialLocalizationEsEc extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Ecuador.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsEc({
    String localeName = 'es_EC',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Guatemala (`es_GT`).
class MaterialLocalizationEsGt extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Guatemala.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsGt({
    String localeName = 'es_GT',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Honduras (`es_HN`).
class MaterialLocalizationEsHn extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Honduras.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsHn({
    String localeName = 'es_HN',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Mexico (`es_MX`).
class MaterialLocalizationEsMx extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Mexico.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsMx({
    String localeName = 'es_MX',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Nicaragua (`es_NI`).
class MaterialLocalizationEsNi extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Nicaragua.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsNi({
    String localeName = 'es_NI',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Panama (`es_PA`).
class MaterialLocalizationEsPa extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Panama.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPa({
    String localeName = 'es_PA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Peru (`es_PE`).
class MaterialLocalizationEsPe extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Peru.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPe({
    String localeName = 'es_PE',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Puerto Rico (`es_PR`).
class MaterialLocalizationEsPr extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Puerto Rico.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPr({
    String localeName = 'es_PR',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Paraguay (`es_PY`).
class MaterialLocalizationEsPy extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Paraguay.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPy({
    String localeName = 'es_PY',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in El Salvador (`es_SV`).
class MaterialLocalizationEsSv extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in El Salvador.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsSv({
    String localeName = 'es_SV',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in the United States (`es_US`).
class MaterialLocalizationEsUs extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in the United States.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsUs({
    String localeName = 'es_US',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Uruguay (`es_UY`).
class MaterialLocalizationEsUy extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Uruguay.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsUy({
    String localeName = 'es_UY',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Spanish Castilian, as used in Venezuela (`es_VE`).
class MaterialLocalizationEsVe extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Venezuela.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsVe({
    String localeName = 'es_VE',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get reorderItemToStart => r'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => r'Descartar';

  @override
  String get signedInLabel => r'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => r'Borrar';

  @override
  String get nextMonthTooltip => r'Próximo mes';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get selectedRowCountTitleOne => r'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get dialogLabel => r'Diálogo';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Queda 1 carácter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';
}

/// The translations for Estonian (`et`).
class MaterialLocalizationEt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Estonian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEt({
    String localeName = 'et',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Teave rakenduse $applicationName kohta';

  @override
  String get alertDialogLabel => r'Märguanne';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Tagasi';

  @override
  String get cancelButtonLabel => r'TÜHISTA';

  @override
  String get closeButtonLabel => r'SULE';

  @override
  String get closeButtonTooltip => r'Sule';

  @override
  String get collapsedIconTapHint => r'Laienda';

  @override
  String get continueButtonLabel => r'JÄTKA';

  @override
  String get copyButtonLabel => r'KOPEERI';

  @override
  String get cutButtonLabel => r'LÕIKA';

  @override
  String get deleteButtonTooltip => r'Kustuta';

  @override
  String get dialogLabel => r'Dialoog';

  @override
  String get drawerLabel => r'Navigeerimismenüü';

  @override
  String get expandedIconTapHint => r'Ahenda';

  @override
  String get hideAccountsLabel => r'Peida kontod';

  @override
  String get licensesPageTitle => r'Litsentsid';

  @override
  String get modalBarrierDismissLabel => r'Loobu';

  @override
  String get nextMonthTooltip => r'Järgmine kuu';

  @override
  String get nextPageTooltip => r'Järgmine leht';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Ava navigeerimismenüü';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow $rowCount-st';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow umbes $rowCount-st';

  @override
  String get pasteButtonLabel => r'KLEEBI';

  @override
  String get popupMenuLabel => r'Hüpikmenüü';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Eelmine kuu';

  @override
  String get previousPageTooltip => r'Eelmine leht';

  @override
  String get refreshIndicatorSemanticLabel => r'Värskendamine';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Jäänud on 1 tähemärk';

  @override
  String get remainingTextFieldCharacterCountOther => r'Jäänud on $remainingCount tähemärki';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Teisalda alla';

  @override
  String get reorderItemLeft => r'Teisalda vasakule';

  @override
  String get reorderItemRight => r'Teisalda paremale';

  @override
  String get reorderItemToEnd => r'Teisalda lõppu';

  @override
  String get reorderItemToStart => r'Teisalda algusesse';

  @override
  String get reorderItemUp => r'Teisalda üles';

  @override
  String get rowsPerPageTitle => r'Ridu lehe kohta:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Otsing';

  @override
  String get selectAllButtonLabel => r'VALI KÕIK';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Valitud on 1 üksus';

  @override
  String get selectedRowCountTitleOther => r'Valitud on $selectedRowCount üksust';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Kuva kontod';

  @override
  String get showMenuTooltip => r'Kuva menüü';

  @override
  String get signedInLabel => r'Sisse logitud';

  @override
  String get tabLabelRaw => r'$tabIndex. vahekaart $tabCount-st';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Tundide valimine';

  @override
  String get timePickerMinuteModeAnnouncement => r'Minutite valimine';

  @override
  String get viewLicensesButtonLabel => r'KUVA LITSENTSID';
}

/// The translations for Basque (`eu`).
class MaterialLocalizationEu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Basque.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEu({
    String localeName = 'eu',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName aplikazioari buruz';

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Atzera';

  @override
  String get cancelButtonLabel => r'UTZI';

  @override
  String get closeButtonLabel => r'ITXI';

  @override
  String get closeButtonTooltip => r'Itxi';

  @override
  String get collapsedIconTapHint => r'Zabaldu';

  @override
  String get continueButtonLabel => r'EGIN AURRERA';

  @override
  String get copyButtonLabel => r'KOPIATU';

  @override
  String get cutButtonLabel => r'EBAKI';

  @override
  String get deleteButtonTooltip => r'Ezabatu';

  @override
  String get dialogLabel => r'Leihoa';

  @override
  String get drawerLabel => r'Nabigazio-menua';

  @override
  String get expandedIconTapHint => r'Tolestu';

  @override
  String get hideAccountsLabel => r'Ezkutatu kontuak';

  @override
  String get licensesPageTitle => r'Lizentziak';

  @override
  String get modalBarrierDismissLabel => r'Baztertu';

  @override
  String get nextMonthTooltip => r'Hurrengo hilabetea';

  @override
  String get nextPageTooltip => r'Hurrengo orria';

  @override
  String get okButtonLabel => r'Ados';

  @override
  String get openAppDrawerTooltip => r'Ireki nabigazio-menua';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow - $lastRow / $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow - $lastRow / $rowCount';

  @override
  String get pasteButtonLabel => r'ITSATSI';

  @override
  String get popupMenuLabel => r'Menu gainerakorra';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Aurreko hilabetea';

  @override
  String get previousPageTooltip => r'Aurreko orria';

  @override
  String get refreshIndicatorSemanticLabel => r'Freskatu';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 karaktere geratzen da';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karaktere geratzen dira';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Eraman behera';

  @override
  String get reorderItemLeft => r'Eraman ezkerrera';

  @override
  String get reorderItemRight => r'Eraman eskuinera';

  @override
  String get reorderItemToEnd => r'Eraman amaierara';

  @override
  String get reorderItemToStart => r'Eraman hasierara';

  @override
  String get reorderItemUp => r'Eraman gora';

  @override
  String get rowsPerPageTitle => r'Errenkadak orriko:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Bilatu';

  @override
  String get selectAllButtonLabel => r'HAUTATU GUZTIAK';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 elementu hautatu da';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementu hautatu dira';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Erakutsi kontuak';

  @override
  String get showMenuTooltip => r'Erakutsi menua';

  @override
  String get signedInLabel => r'Hasi da saioa';

  @override
  String get tabLabelRaw => r'$tabIndex/$tabCount fitxa';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Hautatu orduak';

  @override
  String get timePickerMinuteModeAnnouncement => r'Hautatu minutuak';

  @override
  String get viewLicensesButtonLabel => r'IKUSI LIZENTZIAK';
}

/// The translations for Persian (`fa`).
class MaterialLocalizationFa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Persian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFa({
    String localeName = 'fa',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'درباره $applicationName';

  @override
  String get alertDialogLabel => r'هشدار';

  @override
  String get anteMeridiemAbbreviation => r'ق.ظ.';

  @override
  String get backButtonTooltip => r'برگشت';

  @override
  String get cancelButtonLabel => r'لغو';

  @override
  String get closeButtonLabel => r'بستن';

  @override
  String get closeButtonTooltip => r'بستن';

  @override
  String get collapsedIconTapHint => r'بزرگ کردن';

  @override
  String get continueButtonLabel => r'ادامه';

  @override
  String get copyButtonLabel => r'کپی';

  @override
  String get cutButtonLabel => r'برش';

  @override
  String get deleteButtonTooltip => r'حذف';

  @override
  String get dialogLabel => r'کادر گفتگو';

  @override
  String get drawerLabel => r'منوی پیمایش';

  @override
  String get expandedIconTapHint => r'کوچک کردن';

  @override
  String get hideAccountsLabel => r'پنهان کردن حساب‌ها';

  @override
  String get licensesPageTitle => r'مجوزها';

  @override
  String get modalBarrierDismissLabel => r'نپذیرفتن';

  @override
  String get nextMonthTooltip => r'ماه بعد';

  @override
  String get nextPageTooltip => r'صفحه بعد';

  @override
  String get okButtonLabel => r'تأیید';

  @override
  String get openAppDrawerTooltip => r'باز کردن منوی پیمایش';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow از $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow از حدود $rowCount';

  @override
  String get pasteButtonLabel => r'جای‌گذاری';

  @override
  String get popupMenuLabel => r'منوی بازشو';

  @override
  String get postMeridiemAbbreviation => r'ب.ظ.';

  @override
  String get previousMonthTooltip => r'ماه قبل';

  @override
  String get previousPageTooltip => r'صفحه قبل';

  @override
  String get refreshIndicatorSemanticLabel => r'بازخوانی';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'۱ نویسه باقی مانده است';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount نویسه باقی مانده است';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'انتقال به پایین';

  @override
  String get reorderItemLeft => r'انتقال به راست';

  @override
  String get reorderItemRight => r'انتقال به چپ';

  @override
  String get reorderItemToEnd => r'انتقال به انتها';

  @override
  String get reorderItemToStart => r'انتقال به ابتدا';

  @override
  String get reorderItemUp => r'انتقال به بالا';

  @override
  String get rowsPerPageTitle => r'ردیف در هر صفحه:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'جستجو';

  @override
  String get selectAllButtonLabel => r'انتخاب همه';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'۱ مورد انتخاب شد';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount مورد انتخاب شدند';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'نشان دادن حساب‌ها';

  @override
  String get showMenuTooltip => r'نمایش منو';

  @override
  String get signedInLabel => r'واردشده به سیستم';

  @override
  String get tabLabelRaw => r'برگه $tabIndex از $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'انتخاب ساعت';

  @override
  String get timePickerMinuteModeAnnouncement => r'انتخاب دقیقه';

  @override
  String get viewLicensesButtonLabel => r'مشاهده مجوزها';
}

/// The translations for Finnish (`fi`).
class MaterialLocalizationFi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Finnish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFi({
    String localeName = 'fi',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tietoja: $applicationName';

  @override
  String get alertDialogLabel => r'Ilmoitus';

  @override
  String get anteMeridiemAbbreviation => r'ap';

  @override
  String get backButtonTooltip => r'Takaisin';

  @override
  String get cancelButtonLabel => r'PERUUTA';

  @override
  String get closeButtonLabel => r'SULJE';

  @override
  String get closeButtonTooltip => r'Sulje';

  @override
  String get collapsedIconTapHint => r'Laajenna';

  @override
  String get continueButtonLabel => r'JATKA';

  @override
  String get copyButtonLabel => r'COPY';

  @override
  String get cutButtonLabel => r'LEIKKAA';

  @override
  String get deleteButtonTooltip => r'Poista';

  @override
  String get dialogLabel => r'Valintaikkuna';

  @override
  String get drawerLabel => r'Navigointivalikko';

  @override
  String get expandedIconTapHint => r'Tiivistä';

  @override
  String get hideAccountsLabel => r'Piilota tilit';

  @override
  String get licensesPageTitle => r'Lisenssit';

  @override
  String get modalBarrierDismissLabel => r'Ohita';

  @override
  String get nextMonthTooltip => r'Seuraava kuukausi';

  @override
  String get nextPageTooltip => r'Seuraava sivu';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Avaa navigointivalikko';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow/$rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow/~$rowCount';

  @override
  String get pasteButtonLabel => r'Sijoita';

  @override
  String get popupMenuLabel => r'Ponnahdusvalikko';

  @override
  String get postMeridiemAbbreviation => r'ip';

  @override
  String get previousMonthTooltip => r'Edellinen kuukausi';

  @override
  String get previousPageTooltip => r'Edellinen sivu';

  @override
  String get refreshIndicatorSemanticLabel => r'Päivitys';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 merkki jäljellä';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount merkkiä jäljellä';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Siirrä alas';

  @override
  String get reorderItemLeft => r'Siirrä vasemmalle';

  @override
  String get reorderItemRight => r'Siirrä oikealle';

  @override
  String get reorderItemToEnd => r'Siirrä loppuun';

  @override
  String get reorderItemToStart => r'Siirrä alkuun';

  @override
  String get reorderItemUp => r'Siirrä ylös';

  @override
  String get rowsPerPageTitle => r'Riviä/sivu:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Haku';

  @override
  String get selectAllButtonLabel => r'VALITSE KAIKKI';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 kohde valittu';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount kohdetta valittu';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Näytä tilit';

  @override
  String get showMenuTooltip => r'Näytä valikko';

  @override
  String get signedInLabel => r'Kirjautunut sisään';

  @override
  String get tabLabelRaw => r'Välilehti $tabIndex/$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Valitse tunnit';

  @override
  String get timePickerMinuteModeAnnouncement => r'Valitse minuutit';

  @override
  String get viewLicensesButtonLabel => r'NÄYTÄ KÄYTTÖOIKEUDET';
}

/// The translations for Filipino Pilipino (`fil`).
class MaterialLocalizationFil extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Filipino Pilipino.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFil({
    String localeName = 'fil',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tungkol sa $applicationName';

  @override
  String get alertDialogLabel => r'Alerto';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Bumalik';

  @override
  String get cancelButtonLabel => r'KANSELAHIN';

  @override
  String get closeButtonLabel => r'ISARA';

  @override
  String get closeButtonTooltip => r'Isara';

  @override
  String get collapsedIconTapHint => r'I-expand';

  @override
  String get continueButtonLabel => r'MAGPATULOY';

  @override
  String get copyButtonLabel => r'KOPYAHIN';

  @override
  String get cutButtonLabel => r'I-CUT';

  @override
  String get deleteButtonTooltip => r'I-delete';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Menu ng navigation';

  @override
  String get expandedIconTapHint => r'I-collapse';

  @override
  String get hideAccountsLabel => r'Itago ang mga account';

  @override
  String get licensesPageTitle => r'Mga Lisensya';

  @override
  String get modalBarrierDismissLabel => r'I-dismiss';

  @override
  String get nextMonthTooltip => r'Susunod na buwan';

  @override
  String get nextPageTooltip => r'Susunod na page';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Buksan ang menu ng navigation';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ng $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ng humigit kumulang $rowCount';

  @override
  String get pasteButtonLabel => r'I-PASTE';

  @override
  String get popupMenuLabel => r'Popup na menu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Nakaraang buwan';

  @override
  String get previousPageTooltip => r'Nakaraang page';

  @override
  String get refreshIndicatorSemanticLabel => r'Nagre-refresh';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 character ang natitira';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount na character ang natitira';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Ilipat pababa';

  @override
  String get reorderItemLeft => r'Ilipat pakaliwa';

  @override
  String get reorderItemRight => r'Ilipat pakanan';

  @override
  String get reorderItemToEnd => r'Ilipat sa dulo';

  @override
  String get reorderItemToStart => r'Ilipat sa simula';

  @override
  String get reorderItemUp => r'Ilipat pataas';

  @override
  String get rowsPerPageTitle => r'Mga row bawat page:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Maghanap';

  @override
  String get selectAllButtonLabel => r'PILIIN LAHAT';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item ang napili';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount na item ang napili';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Ipakita ang mga account';

  @override
  String get showMenuTooltip => r'Ipakita ang menu';

  @override
  String get signedInLabel => r'Naka-sign in';

  @override
  String get tabLabelRaw => r'Tab $tabIndex ng $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Pumili ng mga oras';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pumili ng mga minuto';

  @override
  String get viewLicensesButtonLabel => r'TINGNAN ANG MGA LISENSYA';
}

/// The translations for French (`fr`).
class MaterialLocalizationFr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for French.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFr({
    String localeName = 'fr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'À propos de $applicationName';

  @override
  String get alertDialogLabel => r'Alerte';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Retour';

  @override
  String get cancelButtonLabel => r'ANNULER';

  @override
  String get closeButtonLabel => r'FERMER';

  @override
  String get closeButtonTooltip => r'Fermer';

  @override
  String get collapsedIconTapHint => r'Développer';

  @override
  String get continueButtonLabel => r'CONTINUER';

  @override
  String get copyButtonLabel => r'COPIER';

  @override
  String get cutButtonLabel => r'COUPER';

  @override
  String get deleteButtonTooltip => r'Supprimer';

  @override
  String get dialogLabel => r'Boîte de dialogue';

  @override
  String get drawerLabel => r'Menu de navigation';

  @override
  String get expandedIconTapHint => r'Réduire';

  @override
  String get hideAccountsLabel => r'Masquer les comptes';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get modalBarrierDismissLabel => r'Ignorer';

  @override
  String get nextMonthTooltip => r'Mois suivant';

  @override
  String get nextPageTooltip => r'Page suivante';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Ouvrir le menu de navigation';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow sur $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow sur environ $rowCount';

  @override
  String get pasteButtonLabel => r'COLLER';

  @override
  String get popupMenuLabel => r'Menu contextuel';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Mois précédent';

  @override
  String get previousPageTooltip => r'Page précédente';

  @override
  String get refreshIndicatorSemanticLabel => r'Actualiser';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 caractère restant';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount caractères restants';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Déplacer vers le bas';

  @override
  String get reorderItemLeft => r'Déplacer vers la gauche';

  @override
  String get reorderItemRight => r'Déplacer vers la droite';

  @override
  String get reorderItemToEnd => r'Déplacer vers la fin';

  @override
  String get reorderItemToStart => r'Déplacer vers le début';

  @override
  String get reorderItemUp => r'Déplacer vers le haut';

  @override
  String get rowsPerPageTitle => r'Lignes par page :';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Rechercher';

  @override
  String get selectAllButtonLabel => r'TOUT SÉLECTIONNER';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 élément sélectionné';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount éléments sélectionnés';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Aucun élément sélectionné';

  @override
  String get showAccountsLabel => r'Afficher les comptes';

  @override
  String get showMenuTooltip => r'Afficher le menu';

  @override
  String get signedInLabel => r'Connecté';

  @override
  String get tabLabelRaw => r'Onglet $tabIndex sur $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Sélectionner une heure';

  @override
  String get timePickerMinuteModeAnnouncement => r'Sélectionner des minutes';

  @override
  String get viewLicensesButtonLabel => r'AFFICHER LES LICENCES';
}

/// The translations for French, as used in Canada (`fr_CA`).
class MaterialLocalizationFrCa extends MaterialLocalizationFr {
  /// Create an instance of the translation bundle for French, as used in Canada.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFrCa({
    String localeName = 'fr_CA',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow à $lastRow sur $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow à $lastRow sur environ $rowCount';

  @override
  String get tabLabelRaw => r'Onglet $tabIndex sur $tabCount';

  @override
  String get anteMeridiemAbbreviation => r'am';

  @override
  String get postMeridiemAbbreviation => r'pm';

  @override
  String get timePickerHourModeAnnouncement => r'Sélectionnez les heures';

  @override
  String get timePickerMinuteModeAnnouncement => r'Sélectionnez les minutes';

  @override
  String get reorderItemToStart => r'Déplacer au début';

  @override
  String get reorderItemToEnd => r'Déplacer à la fin';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.frenchCanadian;
}

/// The translations for Galician (`gl`).
class MaterialLocalizationGl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Galician.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationGl({
    String localeName = 'gl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Acerca de: $applicationName';

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get backButtonTooltip => r'Atrás';

  @override
  String get cancelButtonLabel => r'CANCELAR';

  @override
  String get closeButtonLabel => r'PECHAR';

  @override
  String get closeButtonTooltip => r'Pechar';

  @override
  String get collapsedIconTapHint => r'Despregar';

  @override
  String get continueButtonLabel => r'CONTINUAR';

  @override
  String get copyButtonLabel => r'COPIAR';

  @override
  String get cutButtonLabel => r'CORTAR';

  @override
  String get deleteButtonTooltip => r'Eliminar';

  @override
  String get dialogLabel => r'Cadro de diálogo';

  @override
  String get drawerLabel => r'Menú de navegación';

  @override
  String get expandedIconTapHint => r'Contraer';

  @override
  String get hideAccountsLabel => r'Ocultar contas';

  @override
  String get licensesPageTitle => r'Licenzas';

  @override
  String get modalBarrierDismissLabel => r'Ignorar';

  @override
  String get nextMonthTooltip => r'Mes seguinte';

  @override
  String get nextPageTooltip => r'Páxina seguinte';

  @override
  String get okButtonLabel => r'Aceptar';

  @override
  String get openAppDrawerTooltip => r'Abrir menú de navegación';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow de aproximadamente $rowCount';

  @override
  String get pasteButtonLabel => r'PEGAR';

  @override
  String get popupMenuLabel => r'Menú emerxente';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get previousMonthTooltip => r'Mes anterior';

  @override
  String get previousPageTooltip => r'Páxina anterior';

  @override
  String get refreshIndicatorSemanticLabel => r'Actualizar';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 carácter restante';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount caracteres restantes';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Mover cara abaixo';

  @override
  String get reorderItemLeft => r'Mover cara á esquerda';

  @override
  String get reorderItemRight => r'Mover cara á dereita';

  @override
  String get reorderItemToEnd => r'Mover ao final';

  @override
  String get reorderItemToStart => r'Mover ao inicio';

  @override
  String get reorderItemUp => r'Mover cara arriba';

  @override
  String get rowsPerPageTitle => r'Filas por páxina:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Buscar';

  @override
  String get selectAllButtonLabel => r'SELECCIONAR TODO';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Seleccionouse 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Seleccionáronse $selectedRowCount elementos';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Non se seleccionaron elementos';

  @override
  String get showAccountsLabel => r'Mostrar contas';

  @override
  String get showMenuTooltip => r'Mostrar menú';

  @override
  String get signedInLabel => r'Sesión iniciada';

  @override
  String get tabLabelRaw => r'Pestana $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Seleccionar horas';

  @override
  String get timePickerMinuteModeAnnouncement => r'Seleccionar minutos';

  @override
  String get viewLicensesButtonLabel => r'VER LICENZAS';
}

/// The translations for Swiss German Alemannic Alsatian (`gsw`).
class MaterialLocalizationGsw extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Swiss German Alemannic Alsatian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationGsw({
    String localeName = 'gsw',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Über $applicationName';

  @override
  String get alertDialogLabel => r'Benachrichtigung';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Zurück';

  @override
  String get cancelButtonLabel => r'ABBRECHEN';

  @override
  String get closeButtonLabel => r'SCHLIEẞEN';

  @override
  String get closeButtonTooltip => r'Schließen';

  @override
  String get collapsedIconTapHint => r'Maximieren';

  @override
  String get continueButtonLabel => r'WEITER';

  @override
  String get copyButtonLabel => r'KOPIEREN';

  @override
  String get cutButtonLabel => r'AUSSCHNEIDEN';

  @override
  String get deleteButtonTooltip => r'Löschen';

  @override
  String get dialogLabel => r'Dialogfeld';

  @override
  String get drawerLabel => r'Navigationsmenü';

  @override
  String get expandedIconTapHint => r'Minimieren';

  @override
  String get hideAccountsLabel => r'Konten ausblenden';

  @override
  String get licensesPageTitle => r'Lizenzen';

  @override
  String get modalBarrierDismissLabel => r'Schließen';

  @override
  String get nextMonthTooltip => r'Nächster Monat';

  @override
  String get nextPageTooltip => r'Nächste Seite';

  @override
  String get okButtonLabel => r'Ok';

  @override
  String get openAppDrawerTooltip => r'Navigationsmenü öffnen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow von $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow von etwa $rowCount';

  @override
  String get pasteButtonLabel => r'EINFÜGEN';

  @override
  String get popupMenuLabel => r'Pop-up-Menü';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Vorheriger Monat';

  @override
  String get previousPageTooltip => r'Vorherige Seite';

  @override
  String get refreshIndicatorSemanticLabel => r'Aktualisieren';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Noch 1 Zeichen';

  @override
  String get remainingTextFieldCharacterCountOther => r'Noch $remainingCount Zeichen';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Nach unten verschieben';

  @override
  String get reorderItemLeft => r'Nach links verschieben';

  @override
  String get reorderItemRight => r'Nach rechts verschieben';

  @override
  String get reorderItemToEnd => r'An das Ende verschieben';

  @override
  String get reorderItemToStart => r'An den Anfang verschieben';

  @override
  String get reorderItemUp => r'Nach oben verschieben';

  @override
  String get rowsPerPageTitle => r'Zeilen pro Seite:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Suchen';

  @override
  String get selectAllButtonLabel => r'ALLE AUSWÄHLEN';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 Element ausgewählt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount Elemente ausgewählt';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Konten anzeigen';

  @override
  String get showMenuTooltip => r'Menü anzeigen';

  @override
  String get signedInLabel => r'Angemeldet';

  @override
  String get tabLabelRaw => r'Tab $tabIndex von $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Stunden auswählen';

  @override
  String get timePickerMinuteModeAnnouncement => r'Minuten auswählen';

  @override
  String get viewLicensesButtonLabel => r'LIZENZEN ANZEIGEN';
}

/// The translations for Gujarati (`gu`).
class MaterialLocalizationGu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Gujarati.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationGu({
    String localeName = 'gu',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName વિશે';

  @override
  String get alertDialogLabel => r'અલર્ટ';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'પાછળ';

  @override
  String get cancelButtonLabel => r'રદ કરો';

  @override
  String get closeButtonLabel => r'બંધ કરો';

  @override
  String get closeButtonTooltip => r'બંધ કરો';

  @override
  String get collapsedIconTapHint => r'વિસ્તૃત કરો';

  @override
  String get continueButtonLabel => r'ચાલુ રાખો';

  @override
  String get copyButtonLabel => r'કૉપિ કરો';

  @override
  String get cutButtonLabel => r'કાપો';

  @override
  String get deleteButtonTooltip => r'ડિલીટ કરો';

  @override
  String get dialogLabel => r'સંવાદ';

  @override
  String get drawerLabel => r'નૅવિગેશન મેનૂ';

  @override
  String get expandedIconTapHint => r'સંકુચિત કરો';

  @override
  String get hideAccountsLabel => r'એકાઉન્ટ છુપાવો';

  @override
  String get licensesPageTitle => r'લાઇસન્સ';

  @override
  String get modalBarrierDismissLabel => r'છોડી દો';

  @override
  String get nextMonthTooltip => r'આગલો મહિનો';

  @override
  String get nextPageTooltip => r'આગલું પેજ';

  @override
  String get okButtonLabel => r'ઓકે';

  @override
  String get openAppDrawerTooltip => r'નૅવિગેશન મેનૂ ખોલો';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountમાંથી $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'આશરે $rowCountમાંથી $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'પેસ્ટ કરો';

  @override
  String get popupMenuLabel => r'પૉપઅપ મેનૂ';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'પાછલો મહિનો';

  @override
  String get previousPageTooltip => r'પાછલું પેજ';

  @override
  String get refreshIndicatorSemanticLabel => r'રિફ્રેશ કરો';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 અક્ષર બાકી';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount અક્ષર બાકી';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'નીચે ખસેડો';

  @override
  String get reorderItemLeft => r'ડાબે ખસેડો';

  @override
  String get reorderItemRight => r'જમણે ખસેડો';

  @override
  String get reorderItemToEnd => r'અંતમાં ખસેડો';

  @override
  String get reorderItemToStart => r'પ્રારંભમાં ખસેડો';

  @override
  String get reorderItemUp => r'ઉપર ખસેડો';

  @override
  String get rowsPerPageTitle => r'પેજ દીઠ પંક્તિઓ:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'શોધો';

  @override
  String get selectAllButtonLabel => r'બધા પસંદ કરો';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 આઇટમ પસંદ કરી';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount આઇટમ પસંદ કરી';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'એકાઉન્ટ બતાવો';

  @override
  String get showMenuTooltip => r'મેનૂ બતાવો';

  @override
  String get signedInLabel => r'આમાં સાઇન ઇન કર્યું છે';

  @override
  String get tabLabelRaw => r'$tabCountમાંથી $tabIndex ટૅબ';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'કલાક પસંદ કરો';

  @override
  String get timePickerMinuteModeAnnouncement => r'મિનિટ પસંદ કરો';

  @override
  String get viewLicensesButtonLabel => r'લાઇસન્સ જુઓ';
}

/// The translations for Hebrew (`he`).
class MaterialLocalizationHe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Hebrew.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHe({
    String localeName = 'he',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'מידע על $applicationName';

  @override
  String get alertDialogLabel => r'התראה';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'הקודם';

  @override
  String get cancelButtonLabel => r'ביטול';

  @override
  String get closeButtonLabel => r'סגירה';

  @override
  String get closeButtonTooltip => r'סגירה';

  @override
  String get collapsedIconTapHint => r'הרחבה';

  @override
  String get continueButtonLabel => r'המשך';

  @override
  String get copyButtonLabel => r'העתקה';

  @override
  String get cutButtonLabel => r'גזירה';

  @override
  String get deleteButtonTooltip => r'מחיקה';

  @override
  String get dialogLabel => r'תיבת דו-שיח';

  @override
  String get drawerLabel => r'תפריט ניווט';

  @override
  String get expandedIconTapHint => r'כיווץ';

  @override
  String get hideAccountsLabel => r'הסתרת החשבונות';

  @override
  String get licensesPageTitle => r'רישיונות';

  @override
  String get modalBarrierDismissLabel => r'סגירה';

  @override
  String get nextMonthTooltip => r'החודש הבא';

  @override
  String get nextPageTooltip => r'הדף הבא';

  @override
  String get okButtonLabel => r'אישור';

  @override
  String get openAppDrawerTooltip => r'פתיחה של תפריט הניווט';

  @override
  String get pageRowsInfoTitleRaw => r'$lastRow–$firstRow מתוך $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$lastRow–$firstRow מתוך כ-$rowCount';

  @override
  String get pasteButtonLabel => r'הדבקה';

  @override
  String get popupMenuLabel => r'תפריט קופץ';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'החודש הקודם';

  @override
  String get previousPageTooltip => r'הדף הקודם';

  @override
  String get refreshIndicatorSemanticLabel => r'רענון';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => r'נותרו $remainingCount תווים';

  @override
  String get remainingTextFieldCharacterCountOne => r'נותר תו אחד';

  @override
  String get remainingTextFieldCharacterCountOther => r'נותרו $remainingCount תווים';

  @override
  String get remainingTextFieldCharacterCountTwo => r'נותרו $remainingCount תווים';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'העברה למטה';

  @override
  String get reorderItemLeft => r'העברה שמאלה';

  @override
  String get reorderItemRight => r'העברה ימינה';

  @override
  String get reorderItemToEnd => r'העברה לסוף';

  @override
  String get reorderItemToStart => r'העברה להתחלה';

  @override
  String get reorderItemUp => r'העברה למעלה';

  @override
  String get rowsPerPageTitle => r'שורות בכל דף:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'חיפוש';

  @override
  String get selectAllButtonLabel => r'בחירת הכול';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => r'$selectedRowCount פריטים נבחרו';

  @override
  String get selectedRowCountTitleOne => r'פריט אחד נבחר';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount פריטים נבחרו';

  @override
  String get selectedRowCountTitleTwo => r'$selectedRowCount פריטים נבחרו';

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'הצגת החשבונות';

  @override
  String get showMenuTooltip => r'הצגת התפריט';

  @override
  String get signedInLabel => r'מחובר';

  @override
  String get tabLabelRaw => r'כרטיסייה $tabIndex מתוך $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'בחירת שעות';

  @override
  String get timePickerMinuteModeAnnouncement => r'בחירת דקות';

  @override
  String get viewLicensesButtonLabel => r'הצגת הרישיונות';
}

/// The translations for Hindi (`hi`).
class MaterialLocalizationHi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Hindi.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHi({
    String localeName = 'hi',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName के बारे में जानकारी';

  @override
  String get alertDialogLabel => r'अलर्ट';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'वापस जाएं';

  @override
  String get cancelButtonLabel => r'रद्द करें';

  @override
  String get closeButtonLabel => r'बंद करें';

  @override
  String get closeButtonTooltip => r'बंद करें';

  @override
  String get collapsedIconTapHint => r'बड़ा करें';

  @override
  String get continueButtonLabel => r'जारी रखें';

  @override
  String get copyButtonLabel => r'कॉपी करें';

  @override
  String get cutButtonLabel => r'कट करें';

  @override
  String get deleteButtonTooltip => r'मिटाएं';

  @override
  String get dialogLabel => r'संवाद';

  @override
  String get drawerLabel => r'नेविगेशन मेन्यू';

  @override
  String get expandedIconTapHint => r'छोटा करें';

  @override
  String get hideAccountsLabel => r'खाते छिपाएं';

  @override
  String get licensesPageTitle => r'लाइसेंस';

  @override
  String get modalBarrierDismissLabel => r'खारिज करें';

  @override
  String get nextMonthTooltip => r'अगला महीना';

  @override
  String get nextPageTooltip => r'अगला पेज';

  @override
  String get okButtonLabel => r'ठीक है';

  @override
  String get openAppDrawerTooltip => r'नेविगेशन मेन्यू खोलें';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount का $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCount में से करीब $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'चिपकाएं';

  @override
  String get popupMenuLabel => r'पॉपअप मेन्यू';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'पिछला महीना';

  @override
  String get previousPageTooltip => r'पिछला पेज';

  @override
  String get refreshIndicatorSemanticLabel => r'रीफ़्रेश करें';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'एक वर्ण अाैर डाला जा सकता है';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount वर्ण अाैर डाले जा सकते हैं';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'नीचे ले जाएं';

  @override
  String get reorderItemLeft => r'बाएं ले जाएं';

  @override
  String get reorderItemRight => r'दाएं ले जाएं';

  @override
  String get reorderItemToEnd => r'आखिर में ले जाएं';

  @override
  String get reorderItemToStart => r'शुरुआत पर ले जाएं';

  @override
  String get reorderItemUp => r'ऊपर ले जाएं';

  @override
  String get rowsPerPageTitle => r'हर पेज में पंक्तियों की संख्या:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => r'खोजें';

  @override
  String get selectAllButtonLabel => r'सभी चुनें';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 चीज़ चुनी गई';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount चीज़ें चुनी गईं';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'खाते दिखाएं';

  @override
  String get showMenuTooltip => r'मेन्यू दिखाएं';

  @override
  String get signedInLabel => r'साइन इन किया हुआ है';

  @override
  String get tabLabelRaw => r'$tabCount का टैब $tabIndex';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'घंटे के हिसाब से समय चुनें';

  @override
  String get timePickerMinuteModeAnnouncement => r'मिनट के हिसाब से समय चुनें';

  @override
  String get viewLicensesButtonLabel => r'लाइसेंस देखें';
}

/// The translations for Croatian (`hr`).
class MaterialLocalizationHr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Croatian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHr({
    String localeName = 'hr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => r'Upozorenje';

  @override
  String get anteMeridiemAbbreviation => r'prijepodne';

  @override
  String get backButtonTooltip => r'Natrag';

  @override
  String get cancelButtonLabel => r'ODUSTANI';

  @override
  String get closeButtonLabel => r'ZATVORI';

  @override
  String get closeButtonTooltip => r'Zatvaranje';

  @override
  String get collapsedIconTapHint => r'Proširi';

  @override
  String get continueButtonLabel => r'NASTAVI';

  @override
  String get copyButtonLabel => r'KOPIRAJ';

  @override
  String get cutButtonLabel => r'IZREŽI';

  @override
  String get deleteButtonTooltip => r'Brisanje';

  @override
  String get dialogLabel => r'Dijalog';

  @override
  String get drawerLabel => r'Navigacijski izbornik';

  @override
  String get expandedIconTapHint => r'Sažmi';

  @override
  String get hideAccountsLabel => r'Sakrijte račune';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get modalBarrierDismissLabel => r'Odbaci';

  @override
  String get nextMonthTooltip => r'Sljedeći mjesec';

  @override
  String get nextPageTooltip => r'Sljedeća stranica';

  @override
  String get okButtonLabel => r'U REDU';

  @override
  String get openAppDrawerTooltip => r'Otvaranje izbornika za navigaciju';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow od otprilike $rowCount';

  @override
  String get pasteButtonLabel => r'ZALIJEPI';

  @override
  String get popupMenuLabel => r'Skočni izbornik';

  @override
  String get postMeridiemAbbreviation => r'popodne';

  @override
  String get previousMonthTooltip => r'Prethodni mjesec';

  @override
  String get previousPageTooltip => r'Prethodna stranica';

  @override
  String get refreshIndicatorSemanticLabel => r'Osvježi';

  @override
  String get remainingTextFieldCharacterCountFew => r'Preostala su $remainingCount znaka';

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Preostao je 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Preostalo je $remainingCount znakova';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Pomakni prema dolje';

  @override
  String get reorderItemLeft => r'Pomakni ulijevo';

  @override
  String get reorderItemRight => r'Pomakni udesno';

  @override
  String get reorderItemToEnd => r'Premjesti na kraj';

  @override
  String get reorderItemToStart => r'Premjesti na početak';

  @override
  String get reorderItemUp => r'Pomakni prema gore';

  @override
  String get rowsPerPageTitle => r'Redaka po stranici:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Pretražite';

  @override
  String get selectAllButtonLabel => r'ODABERI SVE';

  @override
  String get selectedRowCountTitleFew => r'Odabrane su $selectedRowCount stavke';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Odabrana je jedna stavka';

  @override
  String get selectedRowCountTitleOther => r'Odabrano je $selectedRowCount stavki';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Prikažite račune';

  @override
  String get showMenuTooltip => r'Prikaz izbornika';

  @override
  String get signedInLabel => r'Prijavljeni korisnik';

  @override
  String get tabLabelRaw => r'Kartica $tabIndex od $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Odaberite sate';

  @override
  String get timePickerMinuteModeAnnouncement => r'Odaberite minute';

  @override
  String get viewLicensesButtonLabel => r'PRIKAŽI LICENCE';
}

/// The translations for Hungarian (`hu`).
class MaterialLocalizationHu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Hungarian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHu({
    String localeName = 'hu',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'A(z) $applicationName névjegye';

  @override
  String get alertDialogLabel => r'Értesítés';

  @override
  String get anteMeridiemAbbreviation => r'de.';

  @override
  String get backButtonTooltip => r'Vissza';

  @override
  String get cancelButtonLabel => r'MÉGSE';

  @override
  String get closeButtonLabel => r'BEZÁRÁS';

  @override
  String get closeButtonTooltip => r'Bezárás';

  @override
  String get collapsedIconTapHint => r'Kibontás';

  @override
  String get continueButtonLabel => r'TOVÁBB';

  @override
  String get copyButtonLabel => r'MÁSOLÁS';

  @override
  String get cutButtonLabel => r'KIVÁGÁS';

  @override
  String get deleteButtonTooltip => r'Törlés';

  @override
  String get dialogLabel => r'Párbeszédablak';

  @override
  String get drawerLabel => r'Navigációs menü';

  @override
  String get expandedIconTapHint => r'Összecsukás';

  @override
  String get hideAccountsLabel => r'Fiókok elrejtése';

  @override
  String get licensesPageTitle => r'Licencek';

  @override
  String get modalBarrierDismissLabel => r'Elvetés';

  @override
  String get nextMonthTooltip => r'Következő hónap';

  @override
  String get nextPageTooltip => r'Következő oldal';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Navigációs menü megnyitása';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount/$firstRow–$lastRow.';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'Körülbelül $rowCount/$firstRow–$lastRow.';

  @override
  String get pasteButtonLabel => r'BEILLESZTÉS';

  @override
  String get popupMenuLabel => r'Előugró menü';

  @override
  String get postMeridiemAbbreviation => r'du.';

  @override
  String get previousMonthTooltip => r'Előző hónap';

  @override
  String get previousPageTooltip => r'Előző oldal';

  @override
  String get refreshIndicatorSemanticLabel => r'Frissítés';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 karakter maradt';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karakter maradt';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Áthelyezés lefelé';

  @override
  String get reorderItemLeft => r'Áthelyezés balra';

  @override
  String get reorderItemRight => r'Áthelyezés jobbra';

  @override
  String get reorderItemToEnd => r'Áthelyezés a végére';

  @override
  String get reorderItemToStart => r'Áthelyezés az elejére';

  @override
  String get reorderItemUp => r'Áthelyezés felfelé';

  @override
  String get rowsPerPageTitle => r'Oldalankénti sorszám:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Keresés';

  @override
  String get selectAllButtonLabel => r'AZ ÖSSZES KIJELÖLÉSE';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 elem kiválasztva';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elem kiválasztva';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Fiókok megjelenítése';

  @override
  String get showMenuTooltip => r'Menü megjelenítése';

  @override
  String get signedInLabel => r'Bejelentkezve';

  @override
  String get tabLabelRaw => r'$tabCount/$tabIndex. lap';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Óra kiválasztása';

  @override
  String get timePickerMinuteModeAnnouncement => r'Perc kiválasztása';

  @override
  String get viewLicensesButtonLabel => r'LICENCEK MEGTEKINTÉSE';
}

/// The translations for Armenian (`hy`).
class MaterialLocalizationHy extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Armenian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHy({
    String localeName = 'hy',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName հավելվածի մասին';

  @override
  String get alertDialogLabel => r'Ծանուցում';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Հետ';

  @override
  String get cancelButtonLabel => r'ՉԵՂԱՐԿԵԼ';

  @override
  String get closeButtonLabel => r'ՓԱԿԵԼ';

  @override
  String get closeButtonTooltip => r'Փակել';

  @override
  String get collapsedIconTapHint => r'Ծավալել';

  @override
  String get continueButtonLabel => r'ՇԱՐՈՒՆԱԿԵԼ';

  @override
  String get copyButtonLabel => r'ՊԱՏՃԵՆԵԼ';

  @override
  String get cutButtonLabel => r'ԿՏՐԵԼ';

  @override
  String get deleteButtonTooltip => r'Ջնջել';

  @override
  String get dialogLabel => r'Երկխոսության պատուհան';

  @override
  String get drawerLabel => r'Նավարկման ընտրացանկ';

  @override
  String get expandedIconTapHint => r'Ծալել';

  @override
  String get hideAccountsLabel => r'Թաքցնել հաշիվները';

  @override
  String get licensesPageTitle => r'Արտոնագրեր';

  @override
  String get modalBarrierDismissLabel => r'Փակել';

  @override
  String get nextMonthTooltip => r'Հաջորդ ամիս';

  @override
  String get nextPageTooltip => r'Հաջորդ էջ';

  @override
  String get okButtonLabel => r'Եղավ';

  @override
  String get openAppDrawerTooltip => r'Բացել նավարկման ընտրացանկը';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow $rowCount-ից';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow մոտավորապես $rowCount-ից';

  @override
  String get pasteButtonLabel => r'ՏԵՂԱԴՐԵԼ';

  @override
  String get popupMenuLabel => r'Ելնող ընտրացանկ';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Նախորդ ամիս';

  @override
  String get previousPageTooltip => r'Նախորդ էջ';

  @override
  String get refreshIndicatorSemanticLabel => r'Թարմացնել';

  @override
  String get remainingTextFieldCharacterCountFew => r'Մնաց $remainingCount նիշ';

  @override
  String get remainingTextFieldCharacterCountMany => r'Մնաց $remainingCount նիշ';

  @override
  String get remainingTextFieldCharacterCountOne => r'Մնացել է 1 նիշ';

  @override
  String get remainingTextFieldCharacterCountOther => r'Մնացել է $remainingCount նիշ';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'Նիշի հնարավորություն չկա';

  @override
  String get reorderItemDown => r'Տեղափոխել ներքև';

  @override
  String get reorderItemLeft => r'Տեղափոխել ձախ';

  @override
  String get reorderItemRight => r'Տեղափոխել աջ';

  @override
  String get reorderItemToEnd => r'Տեղափոխել վերջ';

  @override
  String get reorderItemToStart => r'Տեղափոխել սկիզբ';

  @override
  String get reorderItemUp => r'Տեղափոխել վերև';

  @override
  String get rowsPerPageTitle => r'Մեկ էջի տողերը՝';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Որոնել';

  @override
  String get selectAllButtonLabel => r'ՆՇԵԼ ԲՈԼՈՐԸ';

  @override
  String get selectedRowCountTitleFew => r'Ընտրված է $selectedRowCount օբյեկտ';

  @override
  String get selectedRowCountTitleMany => r'Ընտրված է $selectedRowCount օբյեկտ';

  @override
  String get selectedRowCountTitleOne => r'Ընտրվել է 1 տարր';

  @override
  String get selectedRowCountTitleOther => r'Ընտրվել է $selectedRowCount տարր';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Տողերը ընտրված չեն';

  @override
  String get showAccountsLabel => r'Ցույց տալ հաշիվները';

  @override
  String get showMenuTooltip => r'Ցույց տալ ընտրացանկը';

  @override
  String get signedInLabel => r'Դուք մուտք եք գործել';

  @override
  String get tabLabelRaw => r'Ներդիր $tabIndex՝ $tabCount-ից';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Ընտրեք ժամը';

  @override
  String get timePickerMinuteModeAnnouncement => r'Ընտրեք րոպեները';

  @override
  String get viewLicensesButtonLabel => r'ԴԻՏԵԼ ԱՐՏՈՆԱԳՐԵՐԸ';
}

/// The translations for Indonesian (`id`).
class MaterialLocalizationId extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Indonesian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationId({
    String localeName = 'id',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tentang $applicationName';

  @override
  String get alertDialogLabel => r'Notifikasi';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Kembali';

  @override
  String get cancelButtonLabel => r'BATAL';

  @override
  String get closeButtonLabel => r'TUTUP';

  @override
  String get closeButtonTooltip => r'Tutup';

  @override
  String get collapsedIconTapHint => r'Luaskan';

  @override
  String get continueButtonLabel => r'LANJUTKAN';

  @override
  String get copyButtonLabel => r'SALIN';

  @override
  String get cutButtonLabel => r'POTONG';

  @override
  String get deleteButtonTooltip => r'Hapus';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Menu navigasi';

  @override
  String get expandedIconTapHint => r'Ciutkan';

  @override
  String get hideAccountsLabel => r'Sembunyikan akun';

  @override
  String get licensesPageTitle => r'Lisensi';

  @override
  String get modalBarrierDismissLabel => r'Tutup';

  @override
  String get nextMonthTooltip => r'Bulan berikutnya';

  @override
  String get nextPageTooltip => r'Halaman berikutnya';

  @override
  String get okButtonLabel => r'OKE';

  @override
  String get openAppDrawerTooltip => r'Buka menu navigasi';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow dari $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow dari kira-kira $rowCount';

  @override
  String get pasteButtonLabel => r'TEMPEL';

  @override
  String get popupMenuLabel => r'Menu pop-up';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Bulan sebelumnya';

  @override
  String get previousPageTooltip => r'Halaman sebelumnya';

  @override
  String get refreshIndicatorSemanticLabel => r'Memuat ulang';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Sisa 1 karakter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Sisa $remainingCount karakter';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Turunkan';

  @override
  String get reorderItemLeft => r'Pindahkan ke kiri';

  @override
  String get reorderItemRight => r'Pindahkan ke kanan';

  @override
  String get reorderItemToEnd => r'Pindahkan ke akhir';

  @override
  String get reorderItemToStart => r'Pindahkan ke awal';

  @override
  String get reorderItemUp => r'Naikkan';

  @override
  String get rowsPerPageTitle => r'Baris per halaman:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Telusuri';

  @override
  String get selectAllButtonLabel => r'PILIH SEMUA';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item dipilih';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount item dipilih';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Tampilkan akun';

  @override
  String get showMenuTooltip => r'Tampilkan menu';

  @override
  String get signedInLabel => r'Telah login';

  @override
  String get tabLabelRaw => r'Tab $tabIndex dari $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Pilih jam';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pilih menit';

  @override
  String get viewLicensesButtonLabel => r'LIHAT LISENSI';
}

/// The translations for Icelandic (`is`).
class MaterialLocalizationIs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Icelandic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationIs({
    String localeName = 'is',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Um $applicationName';

  @override
  String get alertDialogLabel => r'Tilkynning';

  @override
  String get anteMeridiemAbbreviation => r'f.h.';

  @override
  String get backButtonTooltip => r'Til baka';

  @override
  String get cancelButtonLabel => r'HÆTTA';

  @override
  String get closeButtonLabel => r'LOKA';

  @override
  String get closeButtonTooltip => r'Loka';

  @override
  String get collapsedIconTapHint => r'Stækka';

  @override
  String get continueButtonLabel => r'HALDA ÁFRAM';

  @override
  String get copyButtonLabel => r'AFRITA';

  @override
  String get cutButtonLabel => r'KLIPPA';

  @override
  String get deleteButtonTooltip => r'Eyða';

  @override
  String get dialogLabel => r'Gluggi';

  @override
  String get drawerLabel => r'Yfirlitsvalmynd';

  @override
  String get expandedIconTapHint => r'Draga saman';

  @override
  String get hideAccountsLabel => r'Fela reikninga';

  @override
  String get licensesPageTitle => r'Leyfi';

  @override
  String get modalBarrierDismissLabel => r'Hunsa';

  @override
  String get nextMonthTooltip => r'Næsti mánuður';

  @override
  String get nextPageTooltip => r'Næsta síða';

  @override
  String get okButtonLabel => r'Í lagi';

  @override
  String get openAppDrawerTooltip => r'Opna yfirlitsvalmynd';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow af $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow af um það bil $rowCount';

  @override
  String get pasteButtonLabel => r'LÍMA';

  @override
  String get popupMenuLabel => r'Sprettivalmynd';

  @override
  String get postMeridiemAbbreviation => r'e.h.';

  @override
  String get previousMonthTooltip => r'Fyrri mánuður';

  @override
  String get previousPageTooltip => r'Fyrri síða';

  @override
  String get refreshIndicatorSemanticLabel => r'Endurnýja';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 stafur eftir';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount stafir eftir';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Færa niður';

  @override
  String get reorderItemLeft => r'Færa til vinstri';

  @override
  String get reorderItemRight => r'Færa til hægri';

  @override
  String get reorderItemToEnd => r'Færa aftast';

  @override
  String get reorderItemToStart => r'Færa fremst';

  @override
  String get reorderItemUp => r'Færa upp';

  @override
  String get rowsPerPageTitle => r'Línur á síðu:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Leit';

  @override
  String get selectAllButtonLabel => r'VELJA ALLT';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 atriði valið';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount atriði valin';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Sýna reikninga';

  @override
  String get showMenuTooltip => r'Sýna valmynd';

  @override
  String get signedInLabel => r'Innskráð(ur)';

  @override
  String get tabLabelRaw => r'Flipi $tabIndex af $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Velja klukkustundir';

  @override
  String get timePickerMinuteModeAnnouncement => r'Velja mínútur';

  @override
  String get viewLicensesButtonLabel => r'SKOÐA LEYFI';
}

/// The translations for Italian (`it`).
class MaterialLocalizationIt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Italian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationIt({
    String localeName = 'it',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Informazioni su $applicationName';

  @override
  String get alertDialogLabel => r'Avviso';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Indietro';

  @override
  String get cancelButtonLabel => r'ANNULLA';

  @override
  String get closeButtonLabel => r'CHIUDI';

  @override
  String get closeButtonTooltip => r'Chiudi';

  @override
  String get collapsedIconTapHint => r'Espandi';

  @override
  String get continueButtonLabel => r'CONTINUA';

  @override
  String get copyButtonLabel => r'COPIA';

  @override
  String get cutButtonLabel => r'TAGLIA';

  @override
  String get deleteButtonTooltip => r'Elimina';

  @override
  String get dialogLabel => r'Finestra di dialogo';

  @override
  String get drawerLabel => r'Menu di navigazione';

  @override
  String get expandedIconTapHint => r'Comprimi';

  @override
  String get hideAccountsLabel => r'Nascondi account';

  @override
  String get licensesPageTitle => r'Licenze';

  @override
  String get modalBarrierDismissLabel => r'Ignora';

  @override
  String get nextMonthTooltip => r'Mese successivo';

  @override
  String get nextPageTooltip => r'Pagina successiva';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Apri il menu di navigazione';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow di $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow di circa $rowCount';

  @override
  String get pasteButtonLabel => r'INCOLLA';

  @override
  String get popupMenuLabel => r'Menu popup';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Mese precedente';

  @override
  String get previousPageTooltip => r'Pagina precedente';

  @override
  String get refreshIndicatorSemanticLabel => r'Aggiorna';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 carattere rimanente';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount caratteri rimanenti';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Sposta giù';

  @override
  String get reorderItemLeft => r'Sposta a sinistra';

  @override
  String get reorderItemRight => r'Sposta a destra';

  @override
  String get reorderItemToEnd => r'Sposta alla fine';

  @override
  String get reorderItemToStart => r'Sposta all' "'" r'inizio';

  @override
  String get reorderItemUp => r'Sposta su';

  @override
  String get rowsPerPageTitle => r'Righe per pagina:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Cerca';

  @override
  String get selectAllButtonLabel => r'SELEZIONA TUTTO';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 elemento selezionato';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementi selezionati';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Mostra account';

  @override
  String get showMenuTooltip => r'Mostra il menu';

  @override
  String get signedInLabel => r'Connesso';

  @override
  String get tabLabelRaw => r'Scheda $tabIndex di $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Seleziona le ore';

  @override
  String get timePickerMinuteModeAnnouncement => r'Seleziona i minuti';

  @override
  String get viewLicensesButtonLabel => r'VISUALIZZA LICENZE';
}

/// The translations for Japanese (`ja`).
class MaterialLocalizationJa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Japanese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationJa({
    String localeName = 'ja',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName について';

  @override
  String get alertDialogLabel => r'通知';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'戻る';

  @override
  String get cancelButtonLabel => r'キャンセル';

  @override
  String get closeButtonLabel => r'閉じる';

  @override
  String get closeButtonTooltip => r'閉じる';

  @override
  String get collapsedIconTapHint => r'展開';

  @override
  String get continueButtonLabel => r'続行';

  @override
  String get copyButtonLabel => r'コピー';

  @override
  String get cutButtonLabel => r'切り取り';

  @override
  String get deleteButtonTooltip => r'削除';

  @override
  String get dialogLabel => r'ダイアログ';

  @override
  String get drawerLabel => r'ナビゲーション メニュー';

  @override
  String get expandedIconTapHint => r'折りたたむ';

  @override
  String get hideAccountsLabel => r'アカウントを非表示';

  @override
  String get licensesPageTitle => r'ライセンス';

  @override
  String get modalBarrierDismissLabel => r'閉じる';

  @override
  String get nextMonthTooltip => r'来月';

  @override
  String get nextPageTooltip => r'次のページ';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'ナビゲーション メニューを開く';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow - $lastRow 行（合計 $rowCount 行）';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow 行（合計約 $rowCount 行）';

  @override
  String get pasteButtonLabel => r'貼り付け';

  @override
  String get popupMenuLabel => r'ポップアップ メニュー';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'前月';

  @override
  String get previousPageTooltip => r'前のページ';

  @override
  String get refreshIndicatorSemanticLabel => r'更新';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'残り 1 文字（半角相当）';

  @override
  String get remainingTextFieldCharacterCountOther => r'残り $remainingCount 文字（半角相当）';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'下に移動';

  @override
  String get reorderItemLeft => r'左に移動';

  @override
  String get reorderItemRight => r'右に移動';

  @override
  String get reorderItemToEnd => r'最後に移動';

  @override
  String get reorderItemToStart => r'先頭に移動';

  @override
  String get reorderItemUp => r'上に移動';

  @override
  String get rowsPerPageTitle => r'ページあたりの行数:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => r'検索';

  @override
  String get selectAllButtonLabel => r'すべて選択';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 件のアイテムを選択中';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount 件のアイテムを選択中';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'アカウントを表示';

  @override
  String get showMenuTooltip => r'メニューを表示';

  @override
  String get signedInLabel => r'ログイン中';

  @override
  String get tabLabelRaw => r'タブ: $tabIndex/$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'時間を選択';

  @override
  String get timePickerMinuteModeAnnouncement => r'分を選択';

  @override
  String get viewLicensesButtonLabel => r'ライセンスを表示';
}

/// The translations for Georgian (`ka`).
class MaterialLocalizationKa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Georgian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKa({
    String localeName = 'ka',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName-ის შესახებ';

  @override
  String get alertDialogLabel => r'გაფრთხილება';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'უკან';

  @override
  String get cancelButtonLabel => r'გაუქმება';

  @override
  String get closeButtonLabel => r'დახურვა';

  @override
  String get closeButtonTooltip => r'დახურვა';

  @override
  String get collapsedIconTapHint => r'გაშლა';

  @override
  String get continueButtonLabel => r'გაგრძელება';

  @override
  String get copyButtonLabel => r'კოპირება';

  @override
  String get cutButtonLabel => r'ამოჭრა';

  @override
  String get deleteButtonTooltip => r'წაშლა';

  @override
  String get dialogLabel => r'დიალოგი';

  @override
  String get drawerLabel => r'ნავიგაციის მენიუ';

  @override
  String get expandedIconTapHint => r'ჩაკეცვა';

  @override
  String get hideAccountsLabel => r'ანგარიშების დამალვა';

  @override
  String get licensesPageTitle => r'ლიცენზიები';

  @override
  String get modalBarrierDismissLabel => r'დახურვა';

  @override
  String get nextMonthTooltip => r'შემდეგი თვე';

  @override
  String get nextPageTooltip => r'შემდეგი გვერდი';

  @override
  String get okButtonLabel => r'კარგი';

  @override
  String get openAppDrawerTooltip => r'სანავიგაციო მენიუს გახსნა';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow / $rowCount-დან';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow / დაახლოებით $rowCount-დან';

  @override
  String get pasteButtonLabel => r'ჩასმა';

  @override
  String get popupMenuLabel => r'ამომხტარი მენიუ';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'წინა თვე';

  @override
  String get previousPageTooltip => r'წინა გვერდი';

  @override
  String get refreshIndicatorSemanticLabel => r'განახლება';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'დარჩა 1 სიმბოლო';

  @override
  String get remainingTextFieldCharacterCountOther => r'დარჩა $remainingCount სიმბოლო';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'ქვემოთ გადატანა';

  @override
  String get reorderItemLeft => r'მარცხნივ გადატანა';

  @override
  String get reorderItemRight => r'მარჯვნივ გადატანა';

  @override
  String get reorderItemToEnd => r'ბოლოში გადატანა';

  @override
  String get reorderItemToStart => r'დასაწყისში გადატანა';

  @override
  String get reorderItemUp => r'ზემოთ გადატანა';

  @override
  String get rowsPerPageTitle => r'მწკრივი გვერდზე:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'ძიება';

  @override
  String get selectAllButtonLabel => r'ყველას არჩევა';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'არჩეულია 1 ერთეული';

  @override
  String get selectedRowCountTitleOther => r'არჩეულია $selectedRowCount ერთეული';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'ანგარიშების ჩვენება';

  @override
  String get showMenuTooltip => r'მენიუს ჩვენება';

  @override
  String get signedInLabel => r'შესული';

  @override
  String get tabLabelRaw => r'ჩანართი $tabIndex / $tabCount-დან';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'აირჩიეთ საათები';

  @override
  String get timePickerMinuteModeAnnouncement => r'აირჩიეთ წუთები';

  @override
  String get viewLicensesButtonLabel => r'ლიცენზიების ნახვა';
}

/// The translations for Kazakh (`kk`).
class MaterialLocalizationKk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Kazakh.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKk({
    String localeName = 'kk',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName туралы';

  @override
  String get alertDialogLabel => r'Дабыл';

  @override
  String get anteMeridiemAbbreviation => r'түстен кейін';

  @override
  String get backButtonTooltip => r'Артқа';

  @override
  String get cancelButtonLabel => r'БАС ТАРТУ';

  @override
  String get closeButtonLabel => r'ЖАБУ';

  @override
  String get closeButtonTooltip => r'Жабу';

  @override
  String get collapsedIconTapHint => r'Жаю';

  @override
  String get continueButtonLabel => r'ЖАЛҒАСТЫРУ';

  @override
  String get copyButtonLabel => r'КӨШІРУ';

  @override
  String get cutButtonLabel => r'ҚИЮ';

  @override
  String get deleteButtonTooltip => r'Жою';

  @override
  String get dialogLabel => r'Диалогтық терезе';

  @override
  String get drawerLabel => r'Навигация мәзірі';

  @override
  String get expandedIconTapHint => r'Жию';

  @override
  String get hideAccountsLabel => r'Есептік жазбаларды жасыру';

  @override
  String get licensesPageTitle => r'Лицензиялар';

  @override
  String get modalBarrierDismissLabel => r'Жабу';

  @override
  String get nextMonthTooltip => r'Келесі ай';

  @override
  String get nextPageTooltip => r'Келесі бет';

  @override
  String get okButtonLabel => r'Иә';

  @override
  String get openAppDrawerTooltip => r'Навигация мәзірін ашу';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount ішінен $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'Шамамен $rowCount ішінен $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'ҚОЮ';

  @override
  String get popupMenuLabel => r'Қалқымалы терезе мәзірі';

  @override
  String get postMeridiemAbbreviation => r'түстен кейін';

  @override
  String get previousMonthTooltip => r'Өткен ай';

  @override
  String get previousPageTooltip => r'Алдыңғы бет';

  @override
  String get refreshIndicatorSemanticLabel => r'Жаңарту';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 таңба қалды.';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount таңба қалды.';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'Таңбалар қалмады';

  @override
  String get reorderItemDown => r'Төменге жылжыту';

  @override
  String get reorderItemLeft => r'Солға жылжыту';

  @override
  String get reorderItemRight => r'Оңға жылжыту';

  @override
  String get reorderItemToEnd => r'Соңына өту';

  @override
  String get reorderItemToStart => r'Басына өту';

  @override
  String get reorderItemUp => r'Жоғарыға жылжыту';

  @override
  String get rowsPerPageTitle => r'Әр беттегі жолдар саны:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Іздеу';

  @override
  String get selectAllButtonLabel => r'БАРЛЫҒЫН ТАҢДАУ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 элемент таңдалды.';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount элемент таңдалды.';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Тармақ таңдалмаған';

  @override
  String get showAccountsLabel => r'Есептік жазбаларды көрсету';

  @override
  String get showMenuTooltip => r'Мәзірді көрсету';

  @override
  String get signedInLabel => r'Есептік жазбаға кірген';

  @override
  String get tabLabelRaw => r'$tabCount/$tabIndex қойынды';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Сағаттарды таңдаңыз';

  @override
  String get timePickerMinuteModeAnnouncement => r'Минуттарды таңдаңыз';

  @override
  String get viewLicensesButtonLabel => r'ЛИЦЕНЗИЯЛАРДЫ КӨРУ';
}

/// The translations for Khmer Central Khmer (`km`).
class MaterialLocalizationKm extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Khmer Central Khmer.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKm({
    String localeName = 'km',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'អំពី $applicationName';

  @override
  String get alertDialogLabel => r'ជូនដំណឹង';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'ថយក្រោយ';

  @override
  String get cancelButtonLabel => r'បោះបង់';

  @override
  String get closeButtonLabel => r'បិទ';

  @override
  String get closeButtonTooltip => r'បិទ';

  @override
  String get collapsedIconTapHint => r'ពង្រីក';

  @override
  String get continueButtonLabel => r'បន្ត';

  @override
  String get copyButtonLabel => r'ចម្លង';

  @override
  String get cutButtonLabel => r'កាត់';

  @override
  String get deleteButtonTooltip => r'លុប';

  @override
  String get dialogLabel => r'ប្រអប់';

  @override
  String get drawerLabel => r'ម៉ឺនុយរុករក';

  @override
  String get expandedIconTapHint => r'បង្រួម';

  @override
  String get hideAccountsLabel => r'លាក់គណនី';

  @override
  String get licensesPageTitle => r'អាជ្ញាបណ្ណ';

  @override
  String get modalBarrierDismissLabel => r'ច្រាន​ចោល';

  @override
  String get nextMonthTooltip => r'ខែ​​ក្រោយ';

  @override
  String get nextPageTooltip => r'ទំព័របន្ទាប់';

  @override
  String get okButtonLabel => r'យល់ព្រម';

  @override
  String get openAppDrawerTooltip => r'បើក​ម៉ឺនុយរុករក';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ក្នុង​ចំណោម​ $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ក្នុង​ចំណោម​ប្រហែល $rowCount';

  @override
  String get pasteButtonLabel => r'ដាក់​ចូល';

  @override
  String get popupMenuLabel => r'​ម៉ឺនុយ​លោត​ឡើង';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'ខែមុន';

  @override
  String get previousPageTooltip => r'ទំព័រមុន';

  @override
  String get refreshIndicatorSemanticLabel => r'ផ្ទុកឡើងវិញ';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'នៅសល់​ 1 តួ​ទៀត';

  @override
  String get remainingTextFieldCharacterCountOther => r'នៅសល់ $remainingCount តួ​ទៀត';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'ផ្លាស់ទី​ចុះ​ក្រោម';

  @override
  String get reorderItemLeft => r'ផ្លាស់ទី​ទៅ​ឆ្វេង';

  @override
  String get reorderItemRight => r'ផ្លាស់ទីទៅ​ស្តាំ';

  @override
  String get reorderItemToEnd => r'ផ្លាស់ទីទៅ​ចំណុចបញ្ចប់';

  @override
  String get reorderItemToStart => r'ផ្លាស់ទីទៅ​ចំណុច​ចាប់ផ្ដើម';

  @override
  String get reorderItemUp => r'ផ្លាស់ទី​ឡើង​លើ';

  @override
  String get rowsPerPageTitle => r'ជួរ​ដេក​ក្នុង​មួយ​ទំព័រ៖';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => r'ស្វែងរក';

  @override
  String get selectAllButtonLabel => r'ជ្រើសរើស​ទាំង​អស់';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'បាន​ជ្រើស​រើស​ធាតុ 1';

  @override
  String get selectedRowCountTitleOther => r'បាន​ជ្រើស​រើស​ធាតុ $selectedRowCount';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'បង្ហាញគណនី';

  @override
  String get showMenuTooltip => r'បង្ហាញ​ម៉ឺនុយ';

  @override
  String get signedInLabel => r'បានចូល​គណនី';

  @override
  String get tabLabelRaw => r'ផ្ទាំង $tabIndex ក្នុង​ចំណោម​ $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'ជ្រើសរើស​ម៉ោង';

  @override
  String get timePickerMinuteModeAnnouncement => r'ជ្រើសរើស​នាទី';

  @override
  String get viewLicensesButtonLabel => r'មើលអាជ្ញាបណ្ណ';
}

/// The translations for Korean (`ko`).
class MaterialLocalizationKo extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Korean.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKo({
    String localeName = 'ko',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName 정보';

  @override
  String get alertDialogLabel => r'알림';

  @override
  String get anteMeridiemAbbreviation => r'오전';

  @override
  String get backButtonTooltip => r'뒤로';

  @override
  String get cancelButtonLabel => r'취소';

  @override
  String get closeButtonLabel => r'닫기';

  @override
  String get closeButtonTooltip => r'닫기';

  @override
  String get collapsedIconTapHint => r'펼치기';

  @override
  String get continueButtonLabel => r'계속';

  @override
  String get copyButtonLabel => r'복사';

  @override
  String get cutButtonLabel => r'잘라내기';

  @override
  String get deleteButtonTooltip => r'삭제';

  @override
  String get dialogLabel => r'대화상자';

  @override
  String get drawerLabel => r'탐색 메뉴';

  @override
  String get expandedIconTapHint => r'접기';

  @override
  String get hideAccountsLabel => r'계정 숨기기';

  @override
  String get licensesPageTitle => r'라이선스';

  @override
  String get modalBarrierDismissLabel => r'닫기';

  @override
  String get nextMonthTooltip => r'다음 달';

  @override
  String get nextPageTooltip => r'다음 페이지';

  @override
  String get okButtonLabel => r'확인';

  @override
  String get openAppDrawerTooltip => r'탐색 메뉴 열기';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount행 중 $firstRow~$lastRow행';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'약 $rowCount행 중 $firstRow~$lastRow행';

  @override
  String get pasteButtonLabel => r'붙여넣기';

  @override
  String get popupMenuLabel => r'팝업 메뉴';

  @override
  String get postMeridiemAbbreviation => r'오후';

  @override
  String get previousMonthTooltip => r'지난달';

  @override
  String get previousPageTooltip => r'이전 페이지';

  @override
  String get refreshIndicatorSemanticLabel => r'새로고침';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1자 남음';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount자 남음';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'아래로 이동';

  @override
  String get reorderItemLeft => r'왼쪽으로 이동';

  @override
  String get reorderItemRight => r'오른쪽으로 이동';

  @override
  String get reorderItemToEnd => r'끝으로 이동';

  @override
  String get reorderItemToStart => r'시작으로 이동';

  @override
  String get reorderItemUp => r'위로 이동';

  @override
  String get rowsPerPageTitle => r'페이지당 행 수:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => r'검색';

  @override
  String get selectAllButtonLabel => r'전체 선택';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'항목 1개 선택됨';

  @override
  String get selectedRowCountTitleOther => r'항목 $selectedRowCount개 선택됨';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'계정 표시';

  @override
  String get showMenuTooltip => r'메뉴 표시';

  @override
  String get signedInLabel => r'로그인됨';

  @override
  String get tabLabelRaw => r'탭 $tabCount개 중 $tabIndex번째';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'시간 선택';

  @override
  String get timePickerMinuteModeAnnouncement => r'분 선택';

  @override
  String get viewLicensesButtonLabel => r'라이선스 보기';
}

/// The translations for Kirghiz Kyrgyz (`ky`).
class MaterialLocalizationKy extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Kirghiz Kyrgyz.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKy({
    String localeName = 'ky',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName каналы жөнүндө';

  @override
  String get alertDialogLabel => r'Эскертүү';

  @override
  String get anteMeridiemAbbreviation => r'түшкө чейин';

  @override
  String get backButtonTooltip => r'Артка';

  @override
  String get cancelButtonLabel => r'ЖОККО ЧЫГАРУУ';

  @override
  String get closeButtonLabel => r'ЖАБУУ';

  @override
  String get closeButtonTooltip => r'Жабуу';

  @override
  String get collapsedIconTapHint => r'Жайып көрсөтүү';

  @override
  String get continueButtonLabel => r'УЛАНТУУ';

  @override
  String get copyButtonLabel => r'КӨЧҮРҮҮ';

  @override
  String get cutButtonLabel => r'КЕСҮҮ';

  @override
  String get deleteButtonTooltip => r'Жок кылуу';

  @override
  String get dialogLabel => r'Диалог';

  @override
  String get drawerLabel => r'Чабыттоо менюсу';

  @override
  String get expandedIconTapHint => r'Жыйыштыруу';

  @override
  String get hideAccountsLabel => r'Аккаунттарды жашыруу';

  @override
  String get licensesPageTitle => r'Уруксаттамалар';

  @override
  String get modalBarrierDismissLabel => r'Жабуу';

  @override
  String get nextMonthTooltip => r'Кийинки ай';

  @override
  String get nextPageTooltip => r'Кийинки бет';

  @override
  String get okButtonLabel => r'Макул';

  @override
  String get openAppDrawerTooltip => r'Чабыттоо менюсун ачуу';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount ичинен $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'Болжол менен $rowCount ичинен $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'ЧАПТОО';

  @override
  String get popupMenuLabel => r'Калкып чыгуучу меню';

  @override
  String get postMeridiemAbbreviation => r'түштөн кийин';

  @override
  String get previousMonthTooltip => r'Мурунку ай';

  @override
  String get previousPageTooltip => r'Мурунку бет';

  @override
  String get refreshIndicatorSemanticLabel => r'Жаңыртуу';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 белги калды';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount белги калды';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Төмөн жылдыруу';

  @override
  String get reorderItemLeft => r'Солго жылдыруу';

  @override
  String get reorderItemRight => r'Оңго жылдыруу';

  @override
  String get reorderItemToEnd => r'Аягына жылдыруу';

  @override
  String get reorderItemToStart => r'Башына жылдыруу';

  @override
  String get reorderItemUp => r'Жогору жылдыруу';

  @override
  String get rowsPerPageTitle => r'Бир бетте көрсөтүлүүчү саптардын саны:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Издөө';

  @override
  String get selectAllButtonLabel => r'БААРЫН ТАНДОО';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 нерсе тандалды';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount нерсе тандалды';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Аккаунттарды көрсөтүү';

  @override
  String get showMenuTooltip => r'Менюну көрсөтүү';

  @override
  String get signedInLabel => r'Аккаунтуңузга кирдиңиз';

  @override
  String get tabLabelRaw => r'$tabCount кыналма ичинен $tabIndex';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Саатты тандаңыз';

  @override
  String get timePickerMinuteModeAnnouncement => r'Мүнөттөрдү тандаңыз';

  @override
  String get viewLicensesButtonLabel => r'УРУКСАТТАМАЛАРДЫ КӨРҮҮ';
}

/// The translations for Lao (`lo`).
class MaterialLocalizationLo extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Lao.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationLo({
    String localeName = 'lo',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'ກ່ຽວກັບ $applicationName';

  @override
  String get alertDialogLabel => r'ການເຕືອນ';

  @override
  String get anteMeridiemAbbreviation => r'ກ່ອນທ່ຽງ';

  @override
  String get backButtonTooltip => r'ກັບຄືນ';

  @override
  String get cancelButtonLabel => r'ຍົກເລີກ';

  @override
  String get closeButtonLabel => r'ປິດ';

  @override
  String get closeButtonTooltip => r'ປິດ';

  @override
  String get collapsedIconTapHint => r'ຂະຫຍາຍ';

  @override
  String get continueButtonLabel => r'ສືບຕໍ່';

  @override
  String get copyButtonLabel => r'ສຳເນົາ';

  @override
  String get cutButtonLabel => r'ຕັດ';

  @override
  String get deleteButtonTooltip => r'ລຶບ';

  @override
  String get dialogLabel => r'ຂໍ້ຄວາມ';

  @override
  String get drawerLabel => r'ເມນູນຳທາງ';

  @override
  String get expandedIconTapHint => r'ຫຍໍ້ເຂົ້າ';

  @override
  String get hideAccountsLabel => r'ເຊື່ອງບັນຊີ';

  @override
  String get licensesPageTitle => r'ໃບອະນຸຍາດ';

  @override
  String get modalBarrierDismissLabel => r'ປິດໄວ້';

  @override
  String get nextMonthTooltip => r'ເດືອນໜ້າ';

  @override
  String get nextPageTooltip => r'ໜ້າຕໍ່ໄປ';

  @override
  String get okButtonLabel => r'ຕົກລົງ';

  @override
  String get openAppDrawerTooltip => r'ເປີດເມນູການນຳທາງ';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ຈາກທັງໝົດ $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ຈາກປະມານ $rowCount';

  @override
  String get pasteButtonLabel => r'ວາງ';

  @override
  String get popupMenuLabel => r'ເມນູປັອບອັບ';

  @override
  String get postMeridiemAbbreviation => r'ຫຼັງທ່ຽງ';

  @override
  String get previousMonthTooltip => r'ເດືອນແລ້ວ';

  @override
  String get previousPageTooltip => r'ໜ້າກ່ອນໜ້າ';

  @override
  String get refreshIndicatorSemanticLabel => r'ໂຫຼດຄືນໃໝ່';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'ຍັງອີກ 1 ຕົວອັກສອນ';

  @override
  String get remainingTextFieldCharacterCountOther => r'ຍັງອີກ $remainingCount ຕົວອັກສອນ';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'ຍ້າຍລົງ';

  @override
  String get reorderItemLeft => r'ຍ້າຍໄປຊ້າຍ';

  @override
  String get reorderItemRight => r'ຍ້າຍໄປຂວາ';

  @override
  String get reorderItemToEnd => r'ຍ້າຍໄປສິ້ນສຸດ';

  @override
  String get reorderItemToStart => r'ຍ້າຍໄປເລີ່ມຕົ້ນ';

  @override
  String get reorderItemUp => r'ຍ້າຍຂຶ້ນ';

  @override
  String get rowsPerPageTitle => r'ແຖວຕໍ່ໜ້າ:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'ຊອກຫາ';

  @override
  String get selectAllButtonLabel => r'ເລືອກທັງໝົດ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'ເລືອກ 1 ລາຍການແລ້ວ';

  @override
  String get selectedRowCountTitleOther => r'ເລືອກ $selectedRowCount ລາຍການແລ້ວ';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'ສະແດງບັນຊີ';

  @override
  String get showMenuTooltip => r'ສະແດງເມນູ';

  @override
  String get signedInLabel => r'ເຂົ້າສູ່ລະບົບແລ້ວ';

  @override
  String get tabLabelRaw => r'ແຖບທີ $tabIndex ຈາກທັງໝົດ $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'ເລືອກໂມງ';

  @override
  String get timePickerMinuteModeAnnouncement => r'ເລືອກນາທີ';

  @override
  String get viewLicensesButtonLabel => r'ເບິ່ງໃບອະນຸຍາດ';
}

/// The translations for Lithuanian (`lt`).
class MaterialLocalizationLt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Lithuanian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationLt({
    String localeName = 'lt',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Apie „$applicationName“';

  @override
  String get alertDialogLabel => r'Įspėjimas';

  @override
  String get anteMeridiemAbbreviation => r'priešpiet';

  @override
  String get backButtonTooltip => r'Atgal';

  @override
  String get cancelButtonLabel => r'ATŠAUKTI';

  @override
  String get closeButtonLabel => r'UŽDARYTI';

  @override
  String get closeButtonTooltip => r'Uždaryti';

  @override
  String get collapsedIconTapHint => r'Išskleisti';

  @override
  String get continueButtonLabel => r'TĘSTI';

  @override
  String get copyButtonLabel => r'KOPIJUOTI';

  @override
  String get cutButtonLabel => r'IŠKIRPTI';

  @override
  String get deleteButtonTooltip => r'Ištrinti';

  @override
  String get dialogLabel => r'Dialogo langas';

  @override
  String get drawerLabel => r'Naršymo meniu';

  @override
  String get expandedIconTapHint => r'Sutraukti';

  @override
  String get hideAccountsLabel => r'Slėpti paskyras';

  @override
  String get licensesPageTitle => r'Licencijos';

  @override
  String get modalBarrierDismissLabel => r'Atsisakyti';

  @override
  String get nextMonthTooltip => r'Kitas mėnuo';

  @override
  String get nextPageTooltip => r'Kitas puslapis';

  @override
  String get okButtonLabel => r'GERAI';

  @override
  String get openAppDrawerTooltip => r'Atidaryti naršymo meniu';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow iš $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow iš maždaug $rowCount';

  @override
  String get pasteButtonLabel => r'ĮKLIJUOTI';

  @override
  String get popupMenuLabel => r'Iššokantysis meniu';

  @override
  String get postMeridiemAbbreviation => r'popiet';

  @override
  String get previousMonthTooltip => r'Ankstesnis mėnuo';

  @override
  String get previousPageTooltip => r'Ankstesnis puslapis';

  @override
  String get refreshIndicatorSemanticLabel => r'Atnaujinti';

  @override
  String get remainingTextFieldCharacterCountFew => r'Liko $remainingCount simboliai';

  @override
  String get remainingTextFieldCharacterCountMany => r'Liko $remainingCount simbolio';

  @override
  String get remainingTextFieldCharacterCountOne => r'Liko 1 simbolis';

  @override
  String get remainingTextFieldCharacterCountOther => r'Liko $remainingCount simbolių';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Perkelti žemyn';

  @override
  String get reorderItemLeft => r'Perkelti kairėn';

  @override
  String get reorderItemRight => r'Perkelti dešinėn';

  @override
  String get reorderItemToEnd => r'Perkelti į pabaigą';

  @override
  String get reorderItemToStart => r'Perkelti į pradžią';

  @override
  String get reorderItemUp => r'Perkelti aukštyn';

  @override
  String get rowsPerPageTitle => r'Eilučių puslapyje:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Paieška';

  @override
  String get selectAllButtonLabel => r'PASIRINKTI VISKĄ';

  @override
  String get selectedRowCountTitleFew => r'Pasirinkti $selectedRowCount elementai';

  @override
  String get selectedRowCountTitleMany => r'Pasirinkta $selectedRowCount elemento';

  @override
  String get selectedRowCountTitleOne => r'Pasirinktas 1 elementas';

  @override
  String get selectedRowCountTitleOther => r'Pasirinkta $selectedRowCount elementų';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Rodyti paskyras';

  @override
  String get showMenuTooltip => r'Rodyti meniu';

  @override
  String get signedInLabel => r'Prisijungta';

  @override
  String get tabLabelRaw => r'$tabIndex skirtukas iš $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Pasirinkite valandas';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pasirinkite minutes';

  @override
  String get viewLicensesButtonLabel => r'PERŽIŪRĖTI LICENCIJAS';
}

/// The translations for Latvian (`lv`).
class MaterialLocalizationLv extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Latvian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationLv({
    String localeName = 'lv',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Par $applicationName';

  @override
  String get alertDialogLabel => r'Brīdinājums';

  @override
  String get anteMeridiemAbbreviation => r'priekšpusdienā';

  @override
  String get backButtonTooltip => r'Atpakaļ';

  @override
  String get cancelButtonLabel => r'ATCELT';

  @override
  String get closeButtonLabel => r'AIZVĒRT';

  @override
  String get closeButtonTooltip => r'Aizvērt';

  @override
  String get collapsedIconTapHint => r'Izvērst';

  @override
  String get continueButtonLabel => r'TURPINĀT';

  @override
  String get copyButtonLabel => r'KOPĒT';

  @override
  String get cutButtonLabel => r'IZGRIEZT';

  @override
  String get deleteButtonTooltip => r'Dzēst';

  @override
  String get dialogLabel => r'Dialoglodziņš';

  @override
  String get drawerLabel => r'Navigācijas izvēlne';

  @override
  String get expandedIconTapHint => r'Sakļaut';

  @override
  String get hideAccountsLabel => r'Slēpt kontus';

  @override
  String get licensesPageTitle => r'Licences';

  @override
  String get modalBarrierDismissLabel => r'Nerādīt';

  @override
  String get nextMonthTooltip => r'Nākamais mēnesis';

  @override
  String get nextPageTooltip => r'Nākamā lapa';

  @override
  String get okButtonLabel => r'LABI';

  @override
  String get openAppDrawerTooltip => r'Atvērt navigācijas izvēlni';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow.–$lastRow. no $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow.–$lastRow. no aptuveni $rowCount';

  @override
  String get pasteButtonLabel => r'IELĪMĒT';

  @override
  String get popupMenuLabel => r'Uznirstošā izvēlne';

  @override
  String get postMeridiemAbbreviation => r'pēcpusdienā';

  @override
  String get previousMonthTooltip => r'Iepriekšējais mēnesis';

  @override
  String get previousPageTooltip => r'Iepriekšējā lapa';

  @override
  String get refreshIndicatorSemanticLabel => r'Atsvaidzināt';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Atlikusi 1 rakstzīme.';

  @override
  String get remainingTextFieldCharacterCountOther => r'Atlikušas $remainingCount rakstzīmes.';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'Nav atlikusi neviena rakstzīme.';

  @override
  String get reorderItemDown => r'Pārvietot uz leju';

  @override
  String get reorderItemLeft => r'Pārvietot pa kreisi';

  @override
  String get reorderItemRight => r'Pārvietot pa labi';

  @override
  String get reorderItemToEnd => r'Pārvietot uz beigām';

  @override
  String get reorderItemToStart => r'Pārvietot uz sākumu';

  @override
  String get reorderItemUp => r'Pārvietot uz augšu';

  @override
  String get rowsPerPageTitle => r'Rindas lapā:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Meklēt';

  @override
  String get selectAllButtonLabel => r'ATLASĪT VISU';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Atlasīts 1 vienums';

  @override
  String get selectedRowCountTitleOther => r'Atlasīti $selectedRowCount vienumi';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Nav atlasītu vienumu';

  @override
  String get showAccountsLabel => r'Rādīt kontus';

  @override
  String get showMenuTooltip => r'Rādīt izvēlni';

  @override
  String get signedInLabel => r'Esat pierakstījies';

  @override
  String get tabLabelRaw => r'$tabIndex. cilne no $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Atlasiet stundas';

  @override
  String get timePickerMinuteModeAnnouncement => r'Atlasiet minūtes';

  @override
  String get viewLicensesButtonLabel => r'SKATĪT LICENCES';
}

/// The translations for Macedonian (`mk`).
class MaterialLocalizationMk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Macedonian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMk({
    String localeName = 'mk',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'За $applicationName';

  @override
  String get alertDialogLabel => r'Предупредување';

  @override
  String get anteMeridiemAbbreviation => r'ПРЕТПЛАДНЕ';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'ОТКАЖИ';

  @override
  String get closeButtonLabel => r'ЗАТВОРИ';

  @override
  String get closeButtonTooltip => r'Затвори';

  @override
  String get collapsedIconTapHint => r'Прошири';

  @override
  String get continueButtonLabel => r'ПРОДОЛЖИ';

  @override
  String get copyButtonLabel => r'КОПИРАЈ';

  @override
  String get cutButtonLabel => r'ИСЕЧИ';

  @override
  String get deleteButtonTooltip => r'Избриши';

  @override
  String get dialogLabel => r'Дијалог';

  @override
  String get drawerLabel => r'Мени за навигација';

  @override
  String get expandedIconTapHint => r'Собери';

  @override
  String get hideAccountsLabel => r'Сокриј сметки';

  @override
  String get licensesPageTitle => r'Лиценци';

  @override
  String get modalBarrierDismissLabel => r'Отфрли';

  @override
  String get nextMonthTooltip => r'Следниот месец';

  @override
  String get nextPageTooltip => r'Следна страница';

  @override
  String get okButtonLabel => r'Во ред';

  @override
  String get openAppDrawerTooltip => r'Отворете го менито за навигација';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow - $lastRow од $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow - $lastRow од приближно $rowCount';

  @override
  String get pasteButtonLabel => r'ЗАЛЕПИ';

  @override
  String get popupMenuLabel => r'Скокачко мени';

  @override
  String get postMeridiemAbbreviation => r'ПОПЛАДНЕ';

  @override
  String get previousMonthTooltip => r'Претходниот месец';

  @override
  String get previousPageTooltip => r'Претходна страница';

  @override
  String get refreshIndicatorSemanticLabel => r'Освежи';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Преостанува уште 1 знак';

  @override
  String get remainingTextFieldCharacterCountOther => r'Преостануваат уште $remainingCount знаци';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Преместете надолу';

  @override
  String get reorderItemLeft => r'Преместете налево';

  @override
  String get reorderItemRight => r'Преместете надесно';

  @override
  String get reorderItemToEnd => r'Преместете на крајот';

  @override
  String get reorderItemToStart => r'Преместете на почеток';

  @override
  String get reorderItemUp => r'Преместете нагоре';

  @override
  String get rowsPerPageTitle => r'Редови на страница:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Пребарувајте';

  @override
  String get selectAllButtonLabel => r'ИЗБЕРИ ГИ СИТЕ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Избрана е 1 ставка';

  @override
  String get selectedRowCountTitleOther => r'Избрани се $selectedRowCount ставки';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Прикажи сметки';

  @override
  String get showMenuTooltip => r'Прикажи мени';

  @override
  String get signedInLabel => r'Најавени сте';

  @override
  String get tabLabelRaw => r'Картичка $tabIndex од $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Изберете часови';

  @override
  String get timePickerMinuteModeAnnouncement => r'Изберете минути';

  @override
  String get viewLicensesButtonLabel => r'ПРИКАЖИ ЛИЦЕНЦИ';
}

/// The translations for Malayalam (`ml`).
class MaterialLocalizationMl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Malayalam.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMl({
    String localeName = 'ml',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName എന്നതിനെക്കുറിച്ച്';

  @override
  String get alertDialogLabel => r'മുന്നറിയിപ്പ്';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'മടങ്ങുക';

  @override
  String get cancelButtonLabel => r'റദ്ദാക്കുക';

  @override
  String get closeButtonLabel => r'അടയ്‌ക്കുക';

  @override
  String get closeButtonTooltip => r'അടയ്‌ക്കുക';

  @override
  String get collapsedIconTapHint => r'വികസിപ്പിക്കുക';

  @override
  String get continueButtonLabel => r'തുടരുക';

  @override
  String get copyButtonLabel => r'പകർത്തുക';

  @override
  String get cutButtonLabel => r'മുറിക്കുക';

  @override
  String get deleteButtonTooltip => r'ഇല്ലാതാക്കുക';

  @override
  String get dialogLabel => r'ഡയലോഗ്';

  @override
  String get drawerLabel => r'നാവിഗേഷൻ മെനു';

  @override
  String get expandedIconTapHint => r'ചുരുക്കുക';

  @override
  String get hideAccountsLabel => r'അക്കൗണ്ടുകൾ മറയ്‌ക്കുക';

  @override
  String get licensesPageTitle => r'ലൈസൻസുകൾ';

  @override
  String get modalBarrierDismissLabel => r'നിരസിക്കുക';

  @override
  String get nextMonthTooltip => r'അടുത്ത മാസം';

  @override
  String get nextPageTooltip => r'അടുത്ത പേജ്';

  @override
  String get okButtonLabel => r'ശരി';

  @override
  String get openAppDrawerTooltip => r'നാവിഗേഷൻ മെനു തുറക്കുക';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount-ൽ $firstRow –$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'ഏകദേശം $rowCount-ൽ $firstRow –$lastRow';

  @override
  String get pasteButtonLabel => r'ഒട്ടിക്കുക';

  @override
  String get popupMenuLabel => r'പോപ്പ് അപ്പ് മെനു';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'മുമ്പത്തെ മാസം';

  @override
  String get previousPageTooltip => r'മുമ്പത്തെ പേജ്';

  @override
  String get refreshIndicatorSemanticLabel => r'പുതുക്കിയെടുക്കുക';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'ഒരു പ്രതീകം ശേഷിക്കുന്നു';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount പ്രതീകങ്ങൾ ശേഷിക്കുന്നു';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'താഴോട്ട് നീക്കുക';

  @override
  String get reorderItemLeft => r'ഇടത്തോട്ട് നീക്കുക';

  @override
  String get reorderItemRight => r'വലത്തോട്ട് നീക്കുക';

  @override
  String get reorderItemToEnd => r'അവസാന ഭാഗത്തേക്ക് പോവുക';

  @override
  String get reorderItemToStart => r'തുടക്കത്തിലേക്ക് പോവുക';

  @override
  String get reorderItemUp => r'മുകളിലോട്ട് നീക്കുക';

  @override
  String get rowsPerPageTitle => r'ഓരോ പേജിലുമുള്ള വരികൾ:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'തിരയുക';

  @override
  String get selectAllButtonLabel => r'എല്ലാം തിരഞ്ഞെടുക്കുക';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'ഒരു ഇനം തിരഞ്ഞെടുത്തു';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ഇനങ്ങൾ തിരഞ്ഞെടുത്തു';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'അക്കൗണ്ടുകൾ കാണിക്കുക';

  @override
  String get showMenuTooltip => r'മെനു കാണിക്കുക';

  @override
  String get signedInLabel => r'സൈൻ ഇൻ ചെയ്‌തു';

  @override
  String get tabLabelRaw => r'$tabCount-ൽ $tabIndex';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'മണിക്കൂർ തിരഞ്ഞെടുക്കുക';

  @override
  String get timePickerMinuteModeAnnouncement => r'മിനിറ്റ് തിരഞ്ഞെടുക്കുക';

  @override
  String get viewLicensesButtonLabel => r'ലൈസൻസുകൾ കാണുക';
}

/// The translations for Mongolian (`mn`).
class MaterialLocalizationMn extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Mongolian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMn({
    String localeName = 'mn',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName-н тухай';

  @override
  String get alertDialogLabel => r'Сэрэмжлүүлэг';

  @override
  String get anteMeridiemAbbreviation => r'ӨГЛӨӨ';

  @override
  String get backButtonTooltip => r'Буцах';

  @override
  String get cancelButtonLabel => r'БОЛИХ';

  @override
  String get closeButtonLabel => r'ХААХ';

  @override
  String get closeButtonTooltip => r'Хаах';

  @override
  String get collapsedIconTapHint => r'Дэлгэх';

  @override
  String get continueButtonLabel => r'ҮРГЭЛЖЛҮҮЛЭХ';

  @override
  String get copyButtonLabel => r'ХУУЛАХ';

  @override
  String get cutButtonLabel => r'ТАСЛАХ';

  @override
  String get deleteButtonTooltip => r'Устгах';

  @override
  String get dialogLabel => r'Харилцах цонх';

  @override
  String get drawerLabel => r'Навигацийн цэс';

  @override
  String get expandedIconTapHint => r'Буулгах';

  @override
  String get hideAccountsLabel => r'Бүртгэлүүдийг нуух';

  @override
  String get licensesPageTitle => r'Лиценз';

  @override
  String get modalBarrierDismissLabel => r'Үл хэрэгсэх';

  @override
  String get nextMonthTooltip => r'Дараах сар';

  @override
  String get nextPageTooltip => r'Дараах хуудас';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Навигацийн цэсийг нээх';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount-н $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'Ойролцоогоор $rowCount-н $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'БУУЛГАХ';

  @override
  String get popupMenuLabel => r'Попап цэс';

  @override
  String get postMeridiemAbbreviation => r'ОРОЙ';

  @override
  String get previousMonthTooltip => r'Өмнөх сар';

  @override
  String get previousPageTooltip => r'Өмнөх хуудас';

  @override
  String get refreshIndicatorSemanticLabel => r'Сэргээх';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 тэмдэгт үлдсэн';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount тэмдэгт үлдсэн';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'No characters remaining';

  @override
  String get reorderItemDown => r'Доош зөөх';

  @override
  String get reorderItemLeft => r'Зүүн тийш зөөх';

  @override
  String get reorderItemRight => r'Баруун тийш зөөх';

  @override
  String get reorderItemToEnd => r'Төгсгөл рүү зөөх';

  @override
  String get reorderItemToStart => r'Эхлэл рүү зөөх';

  @override
  String get reorderItemUp => r'Дээш зөөх';

  @override
  String get rowsPerPageTitle => r'Хуудсан дахь мөрийн тоо:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Хайх';

  @override
  String get selectAllButtonLabel => r'БҮГДИЙГ СОНГОХ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 зүйл сонгосон';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount зүйл сонгосон';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Бичлэг сонгоогүй байна';

  @override
  String get showAccountsLabel => r'Бүртгэлүүдийг харуулах';

  @override
  String get showMenuTooltip => r'Цэсийг харуулах';

  @override
  String get signedInLabel => r'Нэвтэрсэн';

  @override
  String get tabLabelRaw => r'$tabCount-н $tabIndex-р таб';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Цаг сонгоно уу';

  @override
  String get timePickerMinuteModeAnnouncement => r'Минут сонгоно уу';

  @override
  String get viewLicensesButtonLabel => r'ЛИЦЕНЗИЙГ ХАРАХ';
}

/// The translations for Marathi (`mr`).
class MaterialLocalizationMr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Marathi.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMr({
    String localeName = 'mr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName बद्दल';

  @override
  String get alertDialogLabel => r'सूचना';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'मागे';

  @override
  String get cancelButtonLabel => r'रद्द करा';

  @override
  String get closeButtonLabel => r'बंद करा';

  @override
  String get closeButtonTooltip => r'बंद करा';

  @override
  String get collapsedIconTapHint => r'विस्तार करा';

  @override
  String get continueButtonLabel => r'सुरू ठेवा';

  @override
  String get copyButtonLabel => r'कॉपी करा';

  @override
  String get cutButtonLabel => r'कट करा';

  @override
  String get deleteButtonTooltip => r'हटवा';

  @override
  String get dialogLabel => r'डायलॉग';

  @override
  String get drawerLabel => r'नेव्हिगेशन मेनू';

  @override
  String get expandedIconTapHint => r'कोलॅप्स करा';

  @override
  String get hideAccountsLabel => r'खाती लपवा';

  @override
  String get licensesPageTitle => r'परवाने';

  @override
  String get modalBarrierDismissLabel => r'डिसमिस करा';

  @override
  String get nextMonthTooltip => r'पुढील महिना';

  @override
  String get nextPageTooltip => r'पुढील पेज';

  @override
  String get okButtonLabel => r'ओके';

  @override
  String get openAppDrawerTooltip => r'नेव्हिगेशन मेनू उघडा';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount पैकी $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCount च्या बद्दल $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'पेस्ट करा';

  @override
  String get popupMenuLabel => r'पॉपअप मेनू';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'मागील महिना';

  @override
  String get previousPageTooltip => r'मागील पेज';

  @override
  String get refreshIndicatorSemanticLabel => r'रिफ्रेश करा';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'एक वर्ण शिल्लक';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount वर्ण शिल्लक';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'कोणतेही वर्ण शिल्लक नाहीत';

  @override
  String get reorderItemDown => r'खाली हलवा';

  @override
  String get reorderItemLeft => r'डावीकडे हलवा';

  @override
  String get reorderItemRight => r'उजवीकडे हलवा';

  @override
  String get reorderItemToEnd => r'शेवटाकडे हलवा';

  @override
  String get reorderItemToStart => r'सुरुवातीला हलवा';

  @override
  String get reorderItemUp => r'वर हलवा';

  @override
  String get rowsPerPageTitle => r'प्रति पेज पंक्ती:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => r'शोध';

  @override
  String get selectAllButtonLabel => r'सर्व निवडा';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'एक अायटम निवडला';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount अायटम निवडले';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'कोणतेही आयटम निवडलेले नाहीत';

  @override
  String get showAccountsLabel => r'खाती दर्शवा';

  @override
  String get showMenuTooltip => r'मेनू दाखवा';

  @override
  String get signedInLabel => r'साइन इन केले आहे';

  @override
  String get tabLabelRaw => r'$tabCount पैकी $tabIndex टॅब';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'तास निवडा';

  @override
  String get timePickerMinuteModeAnnouncement => r'मिनिटे निवडा';

  @override
  String get viewLicensesButtonLabel => r'परवाने पाहा';
}

/// The translations for Malay (`ms`).
class MaterialLocalizationMs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Malay.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMs({
    String localeName = 'ms',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Perihal $applicationName';

  @override
  String get alertDialogLabel => r'Makluman';

  @override
  String get anteMeridiemAbbreviation => r'PG';

  @override
  String get backButtonTooltip => r'Kembali';

  @override
  String get cancelButtonLabel => r'BATAL';

  @override
  String get closeButtonLabel => r'TUTUP';

  @override
  String get closeButtonTooltip => r'Tutup';

  @override
  String get collapsedIconTapHint => r'Kembangkan';

  @override
  String get continueButtonLabel => r'TERUSKAN';

  @override
  String get copyButtonLabel => r'SALIN';

  @override
  String get cutButtonLabel => r'POTONG';

  @override
  String get deleteButtonTooltip => r'Padam';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Menu navigasi';

  @override
  String get expandedIconTapHint => r'Runtuhkan';

  @override
  String get hideAccountsLabel => r'Sembunyikan akaun';

  @override
  String get licensesPageTitle => r'Lesen';

  @override
  String get modalBarrierDismissLabel => r'Tolak';

  @override
  String get nextMonthTooltip => r'Bulan depan';

  @override
  String get nextPageTooltip => r'Halaman seterusnya';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Buka menu navigasi';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow dari $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow dari kira-kira $rowCount';

  @override
  String get pasteButtonLabel => r'TAMPAL';

  @override
  String get popupMenuLabel => r'Menu pop timbul';

  @override
  String get postMeridiemAbbreviation => r'PTG';

  @override
  String get previousMonthTooltip => r'Bulan sebelumnya';

  @override
  String get previousPageTooltip => r'Halaman sebelumnya';

  @override
  String get refreshIndicatorSemanticLabel => r'Muat semula';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 aksara lagi';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount aksara lagi';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Alih ke bawah';

  @override
  String get reorderItemLeft => r'Alih ke kiri';

  @override
  String get reorderItemRight => r'Alih ke kanan';

  @override
  String get reorderItemToEnd => r'Alih ke penghujung';

  @override
  String get reorderItemToStart => r'Alih ke permulaan';

  @override
  String get reorderItemUp => r'Alih ke atas';

  @override
  String get rowsPerPageTitle => r'Baris setiap halaman:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Cari';

  @override
  String get selectAllButtonLabel => r'PILIH SEMUA';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item dipilih';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount item dipilih';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Tiada item dipilih';

  @override
  String get showAccountsLabel => r'Tunjukkan akaun';

  @override
  String get showMenuTooltip => r'Tunjukkan menu';

  @override
  String get signedInLabel => r'Dilog masuk';

  @override
  String get tabLabelRaw => r'Tab $tabIndex dari $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'Pilih jam';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pilih minit';

  @override
  String get viewLicensesButtonLabel => r'LIHAT LESEN';
}

/// The translations for Burmese (`my`).
class MaterialLocalizationMy extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Burmese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMy({
    String localeName = 'my',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName အကြောင်း';

  @override
  String get alertDialogLabel => r'သတိပေးချက်';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'နောက်သို့';

  @override
  String get cancelButtonLabel => r'မလုပ်တော့';

  @override
  String get closeButtonLabel => r'ပိတ်ရန်';

  @override
  String get closeButtonTooltip => r'ပိတ်ရန်';

  @override
  String get collapsedIconTapHint => r'ချဲ့ရန်';

  @override
  String get continueButtonLabel => r'ရှေ့ဆက်ရန်';

  @override
  String get copyButtonLabel => r'မိတ္တူကူးရန်';

  @override
  String get cutButtonLabel => r'ဖြတ်ယူရန်';

  @override
  String get deleteButtonTooltip => r'ဖျက်ရန်';

  @override
  String get dialogLabel => r'ဒိုင်ယာလော့';

  @override
  String get drawerLabel => r'လမ်းညွှန် မီနူး';

  @override
  String get expandedIconTapHint => r'လျှော့ပြရန်';

  @override
  String get hideAccountsLabel => r'အကောင့်များကို ဝှက်ရန်';

  @override
  String get licensesPageTitle => r'လိုင်စင်များ';

  @override
  String get modalBarrierDismissLabel => r'ပယ်ရန်';

  @override
  String get nextMonthTooltip => r'နောက်လ';

  @override
  String get nextPageTooltip => r'နောက်စာမျက်နှာ';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'လမ်းညွှန်မီနူးကို ဖွင့်ရန်';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount အနက် $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCount ခန့်မှ $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'ကူးထည့်ရန်';

  @override
  String get popupMenuLabel => r'ပေါ့ပ်အပ်မီနူး';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'ယခင်လ';

  @override
  String get previousPageTooltip => r'ယခင်စာမျက်နှာ';

  @override
  String get refreshIndicatorSemanticLabel => r'ပြန်လည်စတင်ရန်';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'အက္ခရာ ၁ လုံးကျန်သည်';

  @override
  String get remainingTextFieldCharacterCountOther => r'အက္ခရာ $remainingCount လုံးကျန်သည်';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'အောက်သို့ရွှေ့ရန်';

  @override
  String get reorderItemLeft => r'ဘယ်ဘက်သို့ရွှေ့ရန်';

  @override
  String get reorderItemRight => r'ညာဘက်သို့ရွှေ့ရန်';

  @override
  String get reorderItemToEnd => r'အဆုံးသို့ ‌ရွှေ့ရန်';

  @override
  String get reorderItemToStart => r'အစသို့ ရွှေ့ရန်';

  @override
  String get reorderItemUp => r'အပေါ်သို့ ရွှေ့ရန်';

  @override
  String get rowsPerPageTitle => r'စာတစ်မျက်နှာပါ လိုင်းအရေအတွက်−';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'ရှာဖွေရန်';

  @override
  String get selectAllButtonLabel => r'အားလုံး ရွေးရန်';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'၁ ခု ရွေးထားသည်';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ခု ရွေးထားသည်';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'အကောင့်များကို ပြရန်';

  @override
  String get showMenuTooltip => r'မီနူး ပြရန်';

  @override
  String get signedInLabel => r'လက်မှတ်ထိုး ဝင်ထားသည်';

  @override
  String get tabLabelRaw => r'တဘ် $tabCount အနက် $tabIndex ခု';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'နာရီကို ရွေးပါ';

  @override
  String get timePickerMinuteModeAnnouncement => r'မိနစ်ကို ရွေးပါ';

  @override
  String get viewLicensesButtonLabel => r'လိုင်စင်များကို ကြည့်ရန်';
}

/// The translations for Norwegian Bokmål (`nb`).
class MaterialLocalizationNb extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Norwegian Bokmål.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationNb({
    String localeName = 'nb',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => r'Varsel';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Tilbake';

  @override
  String get cancelButtonLabel => r'AVBRYT';

  @override
  String get closeButtonLabel => r'LUKK';

  @override
  String get closeButtonTooltip => r'Lukk';

  @override
  String get collapsedIconTapHint => r'Vis';

  @override
  String get continueButtonLabel => r'FORTSETT';

  @override
  String get copyButtonLabel => r'KOPIÉR';

  @override
  String get cutButtonLabel => r'KLIPP UT';

  @override
  String get deleteButtonTooltip => r'Slett';

  @override
  String get dialogLabel => r'Dialogboks';

  @override
  String get drawerLabel => r'Navigasjonsmeny';

  @override
  String get expandedIconTapHint => r'Skjul';

  @override
  String get hideAccountsLabel => r'Skjul kontoer';

  @override
  String get licensesPageTitle => r'Lisenser';

  @override
  String get modalBarrierDismissLabel => r'Avvis';

  @override
  String get nextMonthTooltip => r'Neste måned';

  @override
  String get nextPageTooltip => r'Neste side';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Åpne navigasjonsmenyen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow av $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow av omtrent $rowCount';

  @override
  String get pasteButtonLabel => r'LIM INN';

  @override
  String get popupMenuLabel => r'Forgrunnsmeny';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Forrige måned';

  @override
  String get previousPageTooltip => r'Forrige side';

  @override
  String get refreshIndicatorSemanticLabel => r'Laster inn på nytt';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 tegn gjenstår';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount tegn gjenstår';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Flytt ned';

  @override
  String get reorderItemLeft => r'Flytt til venstre';

  @override
  String get reorderItemRight => r'Flytt til høyre';

  @override
  String get reorderItemToEnd => r'Flytt til slutten';

  @override
  String get reorderItemToStart => r'Flytt til starten';

  @override
  String get reorderItemUp => r'Flytt opp';

  @override
  String get rowsPerPageTitle => r'Rader per side:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Søk';

  @override
  String get selectAllButtonLabel => r'VELG ALLE';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 element er valgt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementer er valgt';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Vis kontoer';

  @override
  String get showMenuTooltip => r'Vis meny';

  @override
  String get signedInLabel => r'Pålogget';

  @override
  String get tabLabelRaw => r'Fane $tabIndex av $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Angi timer';

  @override
  String get timePickerMinuteModeAnnouncement => r'Angi minutter';

  @override
  String get viewLicensesButtonLabel => r'SE LISENSER';
}

/// The translations for Nepali (`ne`).
class MaterialLocalizationNe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Nepali.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationNe({
    String localeName = 'ne',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName बारे';

  @override
  String get alertDialogLabel => r'अलर्ट';

  @override
  String get anteMeridiemAbbreviation => r'पूर्वाह्न';

  @override
  String get backButtonTooltip => r'पछाडि जानुहोस्';

  @override
  String get cancelButtonLabel => r'रद्द गर्नुहोस्';

  @override
  String get closeButtonLabel => r'बन्द गर्नुहोस्';

  @override
  String get closeButtonTooltip => r'बन्द गर्नुहोस्';

  @override
  String get collapsedIconTapHint => r'विस्तार गर्नुहोस्';

  @override
  String get continueButtonLabel => r'जारी राख्नुहोस्';

  @override
  String get copyButtonLabel => r'प्रतिलिपि गर्नुहोस्';

  @override
  String get cutButtonLabel => r'काट्नुहोस्';

  @override
  String get deleteButtonTooltip => r'मेट्नुहोस्';

  @override
  String get dialogLabel => r'संवाद';

  @override
  String get drawerLabel => r'नेभिगेसन मेनु';

  @override
  String get expandedIconTapHint => r'संक्षिप्त गर्नुहोस्';

  @override
  String get hideAccountsLabel => r'खाताहरू लुकाउनुहोस्';

  @override
  String get licensesPageTitle => r'इजाजतपत्रहरू';

  @override
  String get modalBarrierDismissLabel => r'खारेज गर्नुहोस्';

  @override
  String get nextMonthTooltip => r'अर्को महिना';

  @override
  String get nextPageTooltip => r'अर्को पृष्ठ';

  @override
  String get okButtonLabel => r'ठिक छ';

  @override
  String get openAppDrawerTooltip => r'नेभिगेसन मेनु खोल्नुहोस्';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount मध्ये $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'लगभग $rowCount को $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'टाँस्नुहोस्';

  @override
  String get popupMenuLabel => r'पपअप मेनु';

  @override
  String get postMeridiemAbbreviation => r'अपराह्न';

  @override
  String get previousMonthTooltip => r'अघिल्लो महिना';

  @override
  String get previousPageTooltip => r'अघिल्लो पृष्ठ';

  @override
  String get refreshIndicatorSemanticLabel => r'पुनः ताजा गर्नुहोस्';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'१ वर्ण बाँकी';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount वर्णहरू बाँकी';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'तल सार्नुहोस्';

  @override
  String get reorderItemLeft => r'बायाँ सार्नुहोस्';

  @override
  String get reorderItemRight => r'दायाँ सार्नुहोस्';

  @override
  String get reorderItemToEnd => r'अन्त्यमा जानुहोस्';

  @override
  String get reorderItemToStart => r'सुरुमा सार्नुहोस्';

  @override
  String get reorderItemUp => r'माथि सार्नुहोस्';

  @override
  String get rowsPerPageTitle => r'प्रत्येक पृष्ठमा रहेका पङ्क्तिहरूको सङ्ख्या:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'खोज्नुहोस्';

  @override
  String get selectAllButtonLabel => r'सबै चयन गर्नुहोस्';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'१ वस्तु चयन गरियो';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount वस्तुहरू चयन गरिए';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'खाताहरू देखाउनुहोस्';

  @override
  String get showMenuTooltip => r'मेनु देखाउनुहोस्';

  @override
  String get signedInLabel => r'साइन इन गरियो';

  @override
  String get tabLabelRaw => r'$tabCount मध्ये $tabIndex ट्याब';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'घन्टा चयन गर्नुहोस्';

  @override
  String get timePickerMinuteModeAnnouncement => r'मिनेट चयन गर्नुहोस्';

  @override
  String get viewLicensesButtonLabel => r'इजाजतपत्रहरू हेर्नुहोस्';
}

/// The translations for Dutch Flemish (`nl`).
class MaterialLocalizationNl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Dutch Flemish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationNl({
    String localeName = 'nl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Over $applicationName';

  @override
  String get alertDialogLabel => r'Melding';

  @override
  String get anteMeridiemAbbreviation => r'am';

  @override
  String get backButtonTooltip => r'Terug';

  @override
  String get cancelButtonLabel => r'ANNULEREN';

  @override
  String get closeButtonLabel => r'SLUITEN';

  @override
  String get closeButtonTooltip => r'Sluiten';

  @override
  String get collapsedIconTapHint => r'Uitvouwen';

  @override
  String get continueButtonLabel => r'DOORGAAN';

  @override
  String get copyButtonLabel => r'KOPIËREN';

  @override
  String get cutButtonLabel => r'KNIPPEN';

  @override
  String get deleteButtonTooltip => r'Verwijderen';

  @override
  String get dialogLabel => r'Dialoogvenster';

  @override
  String get drawerLabel => r'Navigatiemenu';

  @override
  String get expandedIconTapHint => r'Samenvouwen';

  @override
  String get hideAccountsLabel => r'Accounts verbergen';

  @override
  String get licensesPageTitle => r'Licenties';

  @override
  String get modalBarrierDismissLabel => r'Sluiten';

  @override
  String get nextMonthTooltip => r'Volgende maand';

  @override
  String get nextPageTooltip => r'Volgende pagina';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Navigatiemenu openen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow van $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow van ongeveer $rowCount';

  @override
  String get pasteButtonLabel => r'PLAKKEN';

  @override
  String get popupMenuLabel => r'Pop-upmenu';

  @override
  String get postMeridiemAbbreviation => r'pm';

  @override
  String get previousMonthTooltip => r'Vorige maand';

  @override
  String get previousPageTooltip => r'Vorige pagina';

  @override
  String get refreshIndicatorSemanticLabel => r'Vernieuwen';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 teken resterend';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount tekens resterend';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Omlaag verplaatsen';

  @override
  String get reorderItemLeft => r'Naar links verplaatsen';

  @override
  String get reorderItemRight => r'Naar rechts verplaatsen';

  @override
  String get reorderItemToEnd => r'Naar het einde verplaatsen';

  @override
  String get reorderItemToStart => r'Naar het begin verplaatsen';

  @override
  String get reorderItemUp => r'Omhoog verplaatsen';

  @override
  String get rowsPerPageTitle => r'Rijen per pagina:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Zoeken';

  @override
  String get selectAllButtonLabel => r'ALLES SELECTEREN';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item geselecteerd';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount items geselecteerd';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Accounts weergeven';

  @override
  String get showMenuTooltip => r'Menu weergeven';

  @override
  String get signedInLabel => r'Ingelogd';

  @override
  String get tabLabelRaw => r'Tabblad $tabIndex van $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Uren selecteren';

  @override
  String get timePickerMinuteModeAnnouncement => r'Minuten selecteren';

  @override
  String get viewLicensesButtonLabel => r'LICENTIES BEKIJKEN';
}

/// The translations for Oriya (`or`).
class MaterialLocalizationOr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Oriya.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationOr({
    String localeName = 'or',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName ବିଷୟରେ';

  @override
  String get alertDialogLabel => r'ଆଲର୍ଟ';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'ପଛକୁ ଫେରନ୍ତୁ';

  @override
  String get cancelButtonLabel => r'ବାତିଲ୍ କରନ୍ତୁ';

  @override
  String get closeButtonLabel => r'ବନ୍ଦ କରନ୍ତୁ';

  @override
  String get closeButtonTooltip => r'ବନ୍ଦ କରନ୍ତୁ';

  @override
  String get collapsedIconTapHint => r'ପ୍ରସାରିତ କରନ୍ତୁ';

  @override
  String get continueButtonLabel => r'ଜାରି ରଖନ୍ତୁ';

  @override
  String get copyButtonLabel => r'କପି କରନ୍ତୁ';

  @override
  String get cutButtonLabel => r'କଟ୍ କରନ୍ତୁ';

  @override
  String get deleteButtonTooltip => r'ଡିଲିଟ୍ କରନ୍ତୁ';

  @override
  String get dialogLabel => r'ଡାୟଲଗ୍';

  @override
  String get drawerLabel => r'ନେଭିଗେସନ୍ ମେନୁ';

  @override
  String get expandedIconTapHint => r'ସଙ୍କୁଚିତ କରନ୍ତୁ';

  @override
  String get hideAccountsLabel => r'ଆକାଉଣ୍ଟଗୁଡ଼ିକୁ ଲୁଚାନ୍ତୁ';

  @override
  String get licensesPageTitle => r'ଲାଇସେନ୍ସଗୁଡ଼କ';

  @override
  String get modalBarrierDismissLabel => r'ଖାରଜ କରନ୍ତୁ';

  @override
  String get nextMonthTooltip => r'ପରବର୍ତ୍ତୀ ମାସ';

  @override
  String get nextPageTooltip => r'ପରବର୍ତ୍ତୀ ପେଜ୍';

  @override
  String get okButtonLabel => r'ଠିକ୍ ଅଛି';

  @override
  String get openAppDrawerTooltip => r'ନାଭିଗେସନ୍ ମେନୁ ଖୋଲନ୍ତୁ';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountର $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'ପାଖାପାଖି $rowCountର $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'ପେଷ୍ଟ କରନ୍ତୁ';

  @override
  String get popupMenuLabel => r'ପପ୍-ଅପ୍ ମେନୁ';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'ପୂର୍ବ ମାସ';

  @override
  String get previousPageTooltip => r'ପୂର୍ବବର୍ତ୍ତୀ ପେଜ୍';

  @override
  String get refreshIndicatorSemanticLabel => r'ରିଫ୍ରେସ୍ କରନ୍ତୁ';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1ଟି ଅକ୍ଷର ବାକି ଅଛି';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCountଟି ଅକ୍ଷର ବାକି ଅଛି';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'ତଳକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemLeft => r'ବାମକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemRight => r'ଡାହାଣକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemToEnd => r'ଶେଷକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemToStart => r'ଆରମ୍ଭକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemUp => r'ଉପରକୁ ନିଅନ୍ତୁ';

  @override
  String get rowsPerPageTitle => r'ପୃଷ୍ଠା ପିଛା ଧାଡ଼ି:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'ଖୋଜନ୍ତୁ';

  @override
  String get selectAllButtonLabel => r'ସମସ୍ତ ଚୟନ କରନ୍ତୁ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1ଟି ଆଇଟମ୍ ଚୟନ କରାଯାଇଛି';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCountଟି ଆଇଟମ୍ ଚୟନ କରାଯାଇଛି';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'ଆକାଉଣ୍ଟ ଦେଖାନ୍ତୁ';

  @override
  String get showMenuTooltip => r'ମେନୁ ଦେଖାନ୍ତୁ';

  @override
  String get signedInLabel => r'ସାଇନ୍ ଇନ୍ କରାଯାଇଛି';

  @override
  String get tabLabelRaw => r'$tabCountର $tabIndex ଟାବ୍';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'ଘଣ୍ଟା ଚୟନ କରନ୍ତୁ';

  @override
  String get timePickerMinuteModeAnnouncement => r'ମିନିଟ୍ ଚୟନ କରନ୍ତୁ';

  @override
  String get viewLicensesButtonLabel => r'ଲାଇସେନ୍ସ ଦେଖାନ୍ତୁ';
}

/// The translations for Panjabi Punjabi (`pa`).
class MaterialLocalizationPa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Panjabi Punjabi.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPa({
    String localeName = 'pa',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName ਬਾਰੇ';

  @override
  String get alertDialogLabel => r'ਸੁਚੇਤਨਾ';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'ਪਿੱਛੇ';

  @override
  String get cancelButtonLabel => r'ਰੱਦ ਕਰੋ';

  @override
  String get closeButtonLabel => r'ਬੰਦ ਕਰੋ';

  @override
  String get closeButtonTooltip => r'ਬੰਦ ਕਰੋ';

  @override
  String get collapsedIconTapHint => r'ਵਿਸਤਾਰ ਕਰੋ';

  @override
  String get continueButtonLabel => r'ਜਾਰੀ ਰੱਖੋ';

  @override
  String get copyButtonLabel => r'ਕਾਪੀ ਕਰੋ';

  @override
  String get cutButtonLabel => r'ਕੱਟ ਕਰੋ';

  @override
  String get deleteButtonTooltip => r'ਮਿਟਾਓ';

  @override
  String get dialogLabel => r'ਵਿੰਡੋ';

  @override
  String get drawerLabel => r'ਨੈਵੀਗੇਸ਼ਨ ਮੀਨੂ';

  @override
  String get expandedIconTapHint => r'ਸਮੇਟੋ';

  @override
  String get hideAccountsLabel => r'ਖਾਤੇ ਲੁਕਾਓ';

  @override
  String get licensesPageTitle => r'ਲਾਇਸੰਸ';

  @override
  String get modalBarrierDismissLabel => r'ਖਾਰਜ ਕਰੋ';

  @override
  String get nextMonthTooltip => r'ਅਗਲਾ ਮਹੀਨਾ';

  @override
  String get nextPageTooltip => r'ਅਗਲਾ ਪੰਨਾ';

  @override
  String get okButtonLabel => r'ਠੀਕ ਹੈ';

  @override
  String get openAppDrawerTooltip => r'ਨੈਵੀਗੇਸ਼ਨ ਮੀਨੂ ਖੋਲ੍ਹੋ';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount ਵਿੱਚੋਂ $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'ਲਗਭਗ $rowCount ਵਿੱਚੋਂ $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'ਪੇਸਟ ਕਰੋ';

  @override
  String get popupMenuLabel => r'ਪੌਪਅੱਪ ਮੀਨੂ';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'ਪਿਛਲਾ ਮਹੀਨਾ';

  @override
  String get previousPageTooltip => r'ਪਿਛਲਾ ਪੰਨਾ';

  @override
  String get refreshIndicatorSemanticLabel => r'ਰਿਫ੍ਰੈਸ਼ ਕਰੋ';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 ਅੱਖਰ-ਚਿੰਨ੍ਹ ਬਾਕੀ';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount ਅੱਖਰ-ਚਿੰਨ੍ਹ ਬਾਕੀ';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'ਹੇਠਾਂ ਲਿਜਾਓ';

  @override
  String get reorderItemLeft => r'ਖੱਬੇ ਲਿਜਾਓ';

  @override
  String get reorderItemRight => r'ਸੱਜੇ ਲਿਜਾਓ';

  @override
  String get reorderItemToEnd => r'ਅੰਤ ਵਿੱਚ ਲਿਜਾਓ';

  @override
  String get reorderItemToStart => r'ਸ਼ੁਰੂ ਵਿੱਚ ਲਿਜਾਓ';

  @override
  String get reorderItemUp => r'ਉੱਪਰ ਲਿਜਾਓ';

  @override
  String get rowsPerPageTitle => r'ਹਰ ਪੰਨੇ ' "'" r'ਤੇ ਕਤਾਰਾਂ:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'ਖੋਜੋ';

  @override
  String get selectAllButtonLabel => r'ਸਭ ਚੁਣੋ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 ਆਈਟਮ ਚੁਣੀ ਗਈ';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ਆਈਟਮਾਂ ਚੁਣੀਆਂ ਗਈਆਂ';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'ਖਾਤੇ ਦਿਖਾਓ';

  @override
  String get showMenuTooltip => r'ਮੀਨੂ ਦਿਖਾਓ';

  @override
  String get signedInLabel => r'ਸਾਈਨ-ਇਨ ਕੀਤਾ ਗਿਆ';

  @override
  String get tabLabelRaw => r'$tabCount ਵਿੱਚੋਂ $tabIndex ਟੈਬ';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'ਘੰਟੇ ਚੁਣੋ';

  @override
  String get timePickerMinuteModeAnnouncement => r'ਮਿੰਟ ਚੁਣੋ';

  @override
  String get viewLicensesButtonLabel => r'ਲਾਇਸੰਸ ਦੇਖੋ';
}

/// The translations for Polish (`pl`).
class MaterialLocalizationPl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Polish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPl({
    String localeName = 'pl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName – informacje';

  @override
  String get alertDialogLabel => r'Alert';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Wstecz';

  @override
  String get cancelButtonLabel => r'ANULUJ';

  @override
  String get closeButtonLabel => r'ZAMKNIJ';

  @override
  String get closeButtonTooltip => r'Zamknij';

  @override
  String get collapsedIconTapHint => r'Rozwiń';

  @override
  String get continueButtonLabel => r'DALEJ';

  @override
  String get copyButtonLabel => r'KOPIUJ';

  @override
  String get cutButtonLabel => r'WYTNIJ';

  @override
  String get deleteButtonTooltip => r'Usuń';

  @override
  String get dialogLabel => r'Okno dialogowe';

  @override
  String get drawerLabel => r'Menu nawigacyjne';

  @override
  String get expandedIconTapHint => r'Zwiń';

  @override
  String get hideAccountsLabel => r'Ukryj konta';

  @override
  String get licensesPageTitle => r'Licencje';

  @override
  String get modalBarrierDismissLabel => r'Zamknij';

  @override
  String get nextMonthTooltip => r'Następny miesiąc';

  @override
  String get nextPageTooltip => r'Następna strona';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Otwórz menu nawigacyjne';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow z $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow z około $rowCount';

  @override
  String get pasteButtonLabel => r'WKLEJ';

  @override
  String get popupMenuLabel => r'Menu kontekstowe';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Poprzedni miesiąc';

  @override
  String get previousPageTooltip => r'Poprzednia strona';

  @override
  String get refreshIndicatorSemanticLabel => r'Odśwież';

  @override
  String get remainingTextFieldCharacterCountFew => r'Pozostały $remainingCount znaki';

  @override
  String get remainingTextFieldCharacterCountMany => r'Pozostało $remainingCount znaków';

  @override
  String get remainingTextFieldCharacterCountOne => r'Jeszcze 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Pozostało $remainingCount znaków';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Przenieś w dół';

  @override
  String get reorderItemLeft => r'Przenieś w lewo';

  @override
  String get reorderItemRight => r'Przenieś w prawo';

  @override
  String get reorderItemToEnd => r'Przenieś na koniec';

  @override
  String get reorderItemToStart => r'Przenieś na początek';

  @override
  String get reorderItemUp => r'Przenieś w górę';

  @override
  String get rowsPerPageTitle => r'Wiersze na stronie:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Szukaj';

  @override
  String get selectAllButtonLabel => r'ZAZNACZ WSZYSTKO';

  @override
  String get selectedRowCountTitleFew => r'$selectedRowCount wybrane elementy';

  @override
  String get selectedRowCountTitleMany => r'$selectedRowCount wybranych elementów';

  @override
  String get selectedRowCountTitleOne => r'1 wybrany element';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount wybranych elementów';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Pokaż konta';

  @override
  String get showMenuTooltip => r'Pokaż menu';

  @override
  String get signedInLabel => r'Zalogowani użytkownicy';

  @override
  String get tabLabelRaw => r'Karta $tabIndex z $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Wybierz godziny';

  @override
  String get timePickerMinuteModeAnnouncement => r'Wybierz minuty';

  @override
  String get viewLicensesButtonLabel => r'WYŚWIETL LICENCJE';
}

/// The translations for Pushto Pashto (`ps`).
class MaterialLocalizationPs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Pushto Pashto.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPs({
    String localeName = 'ps',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'د $applicationName په اړه';

  @override
  String get alertDialogLabel => r'خبرتیا';

  @override
  String get anteMeridiemAbbreviation => null;

  @override
  String get backButtonTooltip => r'شاته';

  @override
  String get cancelButtonLabel => r'لغوه کول';

  @override
  String get closeButtonLabel => r'تړل';

  @override
  String get closeButtonTooltip => r'بنده';

  @override
  String get collapsedIconTapHint => r'TBD';

  @override
  String get continueButtonLabel => r'منځپانګې';

  @override
  String get copyButtonLabel => r'کاپی';

  @override
  String get cutButtonLabel => r'کم کړئ';

  @override
  String get deleteButtonTooltip => r'';

  @override
  String get dialogLabel => r'خبرې اترې';

  @override
  String get drawerLabel => r'د نیویگیشن مینو';

  @override
  String get expandedIconTapHint => r'TBD';

  @override
  String get hideAccountsLabel => r'حسابونه پټ کړئ';

  @override
  String get licensesPageTitle => r'جوازونه';

  @override
  String get modalBarrierDismissLabel => r'رد کړه';

  @override
  String get nextMonthTooltip => r'بله میاشت';

  @override
  String get nextPageTooltip => r'بله پاڼه';

  @override
  String get okButtonLabel => r'سمه ده';

  @override
  String get openAppDrawerTooltip => r'د پرانیستی نیینګ مینو';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow د $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow څخه $rowCount د';

  @override
  String get pasteButtonLabel => r'پیټ کړئ';

  @override
  String get popupMenuLabel => r'د پاپ اپ مینو';

  @override
  String get postMeridiemAbbreviation => null;

  @override
  String get previousMonthTooltip => r'تیره میاشت';

  @override
  String get previousPageTooltip => r'مخکینی مخ';

  @override
  String get refreshIndicatorSemanticLabel => r'TBD';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'TBD';

  @override
  String get remainingTextFieldCharacterCountOther => r'TBD';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'TBD';

  @override
  String get reorderItemLeft => r'TBD';

  @override
  String get reorderItemRight => r'TBD';

  @override
  String get reorderItemToEnd => r'TBD';

  @override
  String get reorderItemToStart => r'TBD';

  @override
  String get reorderItemUp => r'TBD';

  @override
  String get rowsPerPageTitle => r'د هرې پاڼې پاڼې:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'لټون';

  @override
  String get selectAllButtonLabel => r'غوره کړئ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => null;

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount توکي غوره شوي';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'حسابونه ښکاره کړئ';

  @override
  String get showMenuTooltip => r'غورنۍ ښودل';

  @override
  String get signedInLabel => r'ننوتل';

  @override
  String get tabLabelRaw => r'$tabIndex د $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'وختونه وټاکئ';

  @override
  String get timePickerMinuteModeAnnouncement => r'منې غوره کړئ';

  @override
  String get viewLicensesButtonLabel => r'لیدلس وګورئ';
}

/// The translations for Portuguese (`pt`).
class MaterialLocalizationPt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Portuguese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPt({
    String localeName = 'pt',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Sobre o app $applicationName';

  @override
  String get alertDialogLabel => r'Alerta';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Voltar';

  @override
  String get cancelButtonLabel => r'CANCELAR';

  @override
  String get closeButtonLabel => r'FECHAR';

  @override
  String get closeButtonTooltip => r'Fechar';

  @override
  String get collapsedIconTapHint => r'Expandir';

  @override
  String get continueButtonLabel => r'CONTINUAR';

  @override
  String get copyButtonLabel => r'COPIAR';

  @override
  String get cutButtonLabel => r'RECORTAR';

  @override
  String get deleteButtonTooltip => r'Excluir';

  @override
  String get dialogLabel => r'Caixa de diálogo';

  @override
  String get drawerLabel => r'Menu de navegação';

  @override
  String get expandedIconTapHint => r'Recolher';

  @override
  String get hideAccountsLabel => r'Ocultar contas';

  @override
  String get licensesPageTitle => r'Licenças';

  @override
  String get modalBarrierDismissLabel => r'Dispensar';

  @override
  String get nextMonthTooltip => r'Próximo mês';

  @override
  String get nextPageTooltip => r'Próxima página';

  @override
  String get okButtonLabel => r'Ok';

  @override
  String get openAppDrawerTooltip => r'Abrir menu de navegação';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow de aproximadamente $rowCount';

  @override
  String get pasteButtonLabel => r'COLAR';

  @override
  String get popupMenuLabel => r'Menu pop-up';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Mês anterior';

  @override
  String get previousPageTooltip => r'Página anterior';

  @override
  String get refreshIndicatorSemanticLabel => r'Atualizar';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 caractere restante';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount caracteres restantes';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Mover para baixo';

  @override
  String get reorderItemLeft => r'Mover para a esquerda';

  @override
  String get reorderItemRight => r'Mover para a direita';

  @override
  String get reorderItemToEnd => r'Mover para o final';

  @override
  String get reorderItemToStart => r'Mover para o início';

  @override
  String get reorderItemUp => r'Mover para cima';

  @override
  String get rowsPerPageTitle => r'Linhas por página:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Pesquisa';

  @override
  String get selectAllButtonLabel => r'SELECIONAR TUDO';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item selecionado';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount itens selecionados';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Mostrar contas';

  @override
  String get showMenuTooltip => r'Mostrar menu';

  @override
  String get signedInLabel => r'Conectado a';

  @override
  String get tabLabelRaw => r'Guia $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Selecione as horas';

  @override
  String get timePickerMinuteModeAnnouncement => r'Selecione os minutos';

  @override
  String get viewLicensesButtonLabel => r'VER LICENÇAS';
}

/// The translations for Portuguese, as used in Portugal (`pt_PT`).
class MaterialLocalizationPtPt extends MaterialLocalizationPt {
  /// Create an instance of the translation bundle for Portuguese, as used in Portugal.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPtPt({
    String localeName = 'pt_PT',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get tabLabelRaw => r'Separador $tabIndex de $tabCount';

  @override
  String get signedInLabel => r'Com sessão iniciada';

  @override
  String get timePickerMinuteModeAnnouncement => r'Selecionar minutos';

  @override
  String get timePickerHourModeAnnouncement => r'Selecionar horas';

  @override
  String get deleteButtonTooltip => r'Eliminar';

  @override
  String get nextMonthTooltip => r'Mês seguinte';

  @override
  String get nextPageTooltip => r'Página seguinte';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow a $lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow a $lastRow de cerca de $rowCount';

  @override
  String get cutButtonLabel => r'CORTAR';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get modalBarrierDismissLabel => r'Ignorar';

  @override
  String get searchFieldLabel => r'Pesquisar';

  @override
  String get reorderItemToEnd => r'Mover para o fim';

  @override
  String get expandedIconTapHint => r'Reduzir';

  @override
  String get remainingTextFieldCharacterCountOne => r'Resta 1 caráter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Restam $remainingCount carateres';
}

/// The translations for Romanian Moldavian Moldovan (`ro`).
class MaterialLocalizationRo extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Romanian Moldavian Moldovan.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationRo({
    String localeName = 'ro',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Despre $applicationName';

  @override
  String get alertDialogLabel => r'Alertă';

  @override
  String get anteMeridiemAbbreviation => r'a.m.';

  @override
  String get backButtonTooltip => r'Înapoi';

  @override
  String get cancelButtonLabel => r'ANULAȚI';

  @override
  String get closeButtonLabel => r'ÎNCHIDEȚI';

  @override
  String get closeButtonTooltip => r'Închideți';

  @override
  String get collapsedIconTapHint => r'Extindeți';

  @override
  String get continueButtonLabel => r'CONTINUAȚI';

  @override
  String get copyButtonLabel => r'COPIAȚI';

  @override
  String get cutButtonLabel => r'DECUPAȚI';

  @override
  String get deleteButtonTooltip => r'Ștergeți';

  @override
  String get dialogLabel => r'Casetă de dialog';

  @override
  String get drawerLabel => r'Meniu de navigare';

  @override
  String get expandedIconTapHint => r'Restrângeți';

  @override
  String get hideAccountsLabel => r'Ascundeți conturile';

  @override
  String get licensesPageTitle => r'Licențe';

  @override
  String get modalBarrierDismissLabel => r'Închideți';

  @override
  String get nextMonthTooltip => r'Luna viitoare';

  @override
  String get nextPageTooltip => r'Pagina următoare';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Deschideți meniul de navigare';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow din $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow din aproximativ $rowCount';

  @override
  String get pasteButtonLabel => r'INSERAȚI';

  @override
  String get popupMenuLabel => r'Meniu pop-up';

  @override
  String get postMeridiemAbbreviation => r'p.m.';

  @override
  String get previousMonthTooltip => r'Luna trecută';

  @override
  String get previousPageTooltip => r'Pagina anterioară';

  @override
  String get refreshIndicatorSemanticLabel => r'Actualizați';

  @override
  String get remainingTextFieldCharacterCountFew => r'$remainingCount caractere rămase';

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'un caracter rămas';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount de caractere rămase';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Mutați în jos';

  @override
  String get reorderItemLeft => r'Mutați la stânga';

  @override
  String get reorderItemRight => r'Mutați la dreapta';

  @override
  String get reorderItemToEnd => r'Mutați la sfârșit';

  @override
  String get reorderItemToStart => r'Mutați la început';

  @override
  String get reorderItemUp => r'Mutați în sus';

  @override
  String get rowsPerPageTitle => r'Rânduri pe pagină:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Căutați';

  @override
  String get selectAllButtonLabel => r'SELECTAȚI TOATE';

  @override
  String get selectedRowCountTitleFew => r'$selectedRowCount articole selectate';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Un articol selectat';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount de articole selectate';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Nu există elemente selectate';

  @override
  String get showAccountsLabel => r'Afișați conturile';

  @override
  String get showMenuTooltip => r'Afișați meniul';

  @override
  String get signedInLabel => r'V-ați conectat';

  @override
  String get tabLabelRaw => r'Fila $tabIndex din $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Selectați orele';

  @override
  String get timePickerMinuteModeAnnouncement => r'Selectați minutele';

  @override
  String get viewLicensesButtonLabel => r'VEDEȚI LICENȚELE';
}

/// The translations for Russian (`ru`).
class MaterialLocalizationRu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Russian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationRu({
    String localeName = 'ru',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName: сведения';

  @override
  String get alertDialogLabel => r'Оповещение';

  @override
  String get anteMeridiemAbbreviation => r'АМ';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'ОТМЕНА';

  @override
  String get closeButtonLabel => r'ЗАКРЫТЬ';

  @override
  String get closeButtonTooltip => r'Закрыть';

  @override
  String get collapsedIconTapHint => r'Развернуть';

  @override
  String get continueButtonLabel => r'ПРОДОЛЖИТЬ';

  @override
  String get copyButtonLabel => r'КОПИРОВАТЬ';

  @override
  String get cutButtonLabel => r'ВЫРЕЗАТЬ';

  @override
  String get deleteButtonTooltip => r'Удалить';

  @override
  String get dialogLabel => r'Диалоговое окно';

  @override
  String get drawerLabel => r'Меню навигации';

  @override
  String get expandedIconTapHint => r'Свернуть';

  @override
  String get hideAccountsLabel => r'Скрыть аккаунты';

  @override
  String get licensesPageTitle => r'Лицензии';

  @override
  String get modalBarrierDismissLabel => r'Закрыть';

  @override
  String get nextMonthTooltip => r'Следующий месяц';

  @override
  String get nextPageTooltip => r'Следующая страница';

  @override
  String get okButtonLabel => r'ОК';

  @override
  String get openAppDrawerTooltip => r'Открыть меню навигации';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow из $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow из примерно $rowCount';

  @override
  String get pasteButtonLabel => r'ВСТАВИТЬ';

  @override
  String get popupMenuLabel => r'Всплывающее меню';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Предыдущий месяц';

  @override
  String get previousPageTooltip => r'Предыдущая страница';

  @override
  String get refreshIndicatorSemanticLabel => r'Обновление';

  @override
  String get remainingTextFieldCharacterCountFew => r'Осталось $remainingCount символа';

  @override
  String get remainingTextFieldCharacterCountMany => r'Осталось $remainingCount символов';

  @override
  String get remainingTextFieldCharacterCountOne => r'Остался 1 символ';

  @override
  String get remainingTextFieldCharacterCountOther => r'Осталось $remainingCount символа';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Переместить вниз';

  @override
  String get reorderItemLeft => r'Переместить влево';

  @override
  String get reorderItemRight => r'Переместить вправо';

  @override
  String get reorderItemToEnd => r'Переместить в конец';

  @override
  String get reorderItemToStart => r'Переместить в начало';

  @override
  String get reorderItemUp => r'Переместить вверх';

  @override
  String get rowsPerPageTitle => r'Строк на странице:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Поиск';

  @override
  String get selectAllButtonLabel => r'ВЫБРАТЬ ВСЕ';

  @override
  String get selectedRowCountTitleFew => r'Выбрано $selectedRowCount объекта';

  @override
  String get selectedRowCountTitleMany => r'Выбрано $selectedRowCount объектов';

  @override
  String get selectedRowCountTitleOne => r'Выбран 1 объект';

  @override
  String get selectedRowCountTitleOther => r'Выбрано $selectedRowCount объекта';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Строки не выбраны';

  @override
  String get showAccountsLabel => r'Показать аккаунты';

  @override
  String get showMenuTooltip => r'Показать меню';

  @override
  String get signedInLabel => r'Вход выполнен';

  @override
  String get tabLabelRaw => r'Вкладка $tabIndex из $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Выберите часы';

  @override
  String get timePickerMinuteModeAnnouncement => r'Выберите минуты';

  @override
  String get viewLicensesButtonLabel => r'ЛИЦЕНЗИИ';
}

/// The translations for Sinhala Sinhalese (`si`).
class MaterialLocalizationSi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Sinhala Sinhalese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSi({
    String localeName = 'si',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName ගැන';

  @override
  String get alertDialogLabel => r'ඇඟවීම';

  @override
  String get anteMeridiemAbbreviation => r'පෙ.ව.';

  @override
  String get backButtonTooltip => r'ආපසු';

  @override
  String get cancelButtonLabel => r'අවලංගු කරන්න';

  @override
  String get closeButtonLabel => r'වසන්න';

  @override
  String get closeButtonTooltip => r'වසන්න';

  @override
  String get collapsedIconTapHint => r'දිග හරින්න';

  @override
  String get continueButtonLabel => r'ඉදිරියට';

  @override
  String get copyButtonLabel => r'පිටපත් කරන්න';

  @override
  String get cutButtonLabel => r'කපන්න';

  @override
  String get deleteButtonTooltip => r'මකන්න';

  @override
  String get dialogLabel => r'සංවාදය';

  @override
  String get drawerLabel => r'සංචාලන මෙනුව';

  @override
  String get expandedIconTapHint => r'හකුළන්න';

  @override
  String get hideAccountsLabel => r'ගිණුම් සඟවන්න';

  @override
  String get licensesPageTitle => r'බලපත්‍ර';

  @override
  String get modalBarrierDismissLabel => r'ඉවත ලන්න';

  @override
  String get nextMonthTooltip => r'ඊළඟ මාසය';

  @override
  String get nextPageTooltip => r'ඊළඟ පිටුව';

  @override
  String get okButtonLabel => r'හරි';

  @override
  String get openAppDrawerTooltip => r'සංචාලන මෙනුව විවෘත කරන්න';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountන් $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCountකින් පමණ $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'අලවන්න';

  @override
  String get popupMenuLabel => r'උත්පතන මෙනුව';

  @override
  String get postMeridiemAbbreviation => r'ප.ව.';

  @override
  String get previousMonthTooltip => r'පෙර මාසය';

  @override
  String get previousPageTooltip => r'පෙර පිටුව';

  @override
  String get refreshIndicatorSemanticLabel => r'නැවුම් කරන්න';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'අනුලකුණු 1ක් ඉතිරිය';

  @override
  String get remainingTextFieldCharacterCountOther => r'අනුලකුණු $remainingCountක් ඉතිරිය';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'පහළට ගෙන යන්න';

  @override
  String get reorderItemLeft => r'වමට ගෙන යන්න';

  @override
  String get reorderItemRight => r'දකුණට ගෙන යන්න';

  @override
  String get reorderItemToEnd => r'අවසානයට යන්න';

  @override
  String get reorderItemToStart => r'ආරම්භය වෙත යන්න';

  @override
  String get reorderItemUp => r'ඉහළට ගෙන යන්න';

  @override
  String get rowsPerPageTitle => r'පිටුවකට පේළි:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'සෙවීම';

  @override
  String get selectAllButtonLabel => r'සියල්ල තෝරන්න';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'අයිතම 1ක් තෝරන ලදී';

  @override
  String get selectedRowCountTitleOther => r'අයිතම $selectedRowCountක් තෝරන ලදී';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'ගිණුම් පෙන්වන්න';

  @override
  String get showMenuTooltip => r'මෙනුව පෙන්වන්න';

  @override
  String get signedInLabel => r'පුරන ලදී';

  @override
  String get tabLabelRaw => r'ටැබ $tabIndexකින් $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'පැය ගණන තෝරන්න';

  @override
  String get timePickerMinuteModeAnnouncement => r'මිනිත්තු ගණන තෝරන්න';

  @override
  String get viewLicensesButtonLabel => r'බලපත්‍ර බලන්න';
}

/// The translations for Slovak (`sk`).
class MaterialLocalizationSk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Slovak.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSk({
    String localeName = 'sk',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName – informácie';

  @override
  String get alertDialogLabel => r'Upozornenie';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Späť';

  @override
  String get cancelButtonLabel => r'ZRUŠIŤ';

  @override
  String get closeButtonLabel => r'ZAVRIEŤ';

  @override
  String get closeButtonTooltip => r'Zavrieť';

  @override
  String get collapsedIconTapHint => r'Rozbaliť';

  @override
  String get continueButtonLabel => r'POKRAČOVAŤ';

  @override
  String get copyButtonLabel => r'KOPÍROVAŤ';

  @override
  String get cutButtonLabel => r'VYSTRIHNÚŤ';

  @override
  String get deleteButtonTooltip => r'Odstrániť';

  @override
  String get dialogLabel => r'Dialógové okno';

  @override
  String get drawerLabel => r'Navigačná ponuka';

  @override
  String get expandedIconTapHint => r'Zbaliť';

  @override
  String get hideAccountsLabel => r'Skryť účty';

  @override
  String get licensesPageTitle => r'Licencie';

  @override
  String get modalBarrierDismissLabel => r'Odmietnuť';

  @override
  String get nextMonthTooltip => r'Budúci mesiac';

  @override
  String get nextPageTooltip => r'Ďalšia strana';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Otvoriť navigačnú ponuku';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow z $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow z približne $rowCount';

  @override
  String get pasteButtonLabel => r'PRILEPIŤ';

  @override
  String get popupMenuLabel => r'Kontextová ponuka';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Predošlý mesiac';

  @override
  String get previousPageTooltip => r'Predchádzajúca stránka';

  @override
  String get refreshIndicatorSemanticLabel => r'Obnoviť';

  @override
  String get remainingTextFieldCharacterCountFew => r'Zostávajú $remainingCount znaky';

  @override
  String get remainingTextFieldCharacterCountMany => r'$remainingCount characters remaining';

  @override
  String get remainingTextFieldCharacterCountOne => r'Zostáva 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Zostáva $remainingCount znakov';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Presunúť nadol';

  @override
  String get reorderItemLeft => r'Presunúť doľava';

  @override
  String get reorderItemRight => r'Presunúť doprava';

  @override
  String get reorderItemToEnd => r'Presunúť na koniec';

  @override
  String get reorderItemToStart => r'Presunúť na začiatok';

  @override
  String get reorderItemUp => r'Presunúť nahor';

  @override
  String get rowsPerPageTitle => r'Počet riadkov na stránku:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Hľadať';

  @override
  String get selectAllButtonLabel => r'VYBRAŤ VŠETKO';

  @override
  String get selectedRowCountTitleFew => r'$selectedRowCount vybraté položky';

  @override
  String get selectedRowCountTitleMany => r'$selectedRowCount items selected';

  @override
  String get selectedRowCountTitleOne => r'1 vybratá položka';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount vybratých položiek';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Zobraziť účty';

  @override
  String get showMenuTooltip => r'Zobraziť ponuku';

  @override
  String get signedInLabel => r'Prihlásili ste sa';

  @override
  String get tabLabelRaw => r'Karta $tabIndex z $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Vybrať hodiny';

  @override
  String get timePickerMinuteModeAnnouncement => r'Vybrať minúty';

  @override
  String get viewLicensesButtonLabel => r'ZOBRAZIŤ LICENCIE';
}

/// The translations for Slovenian (`sl`).
class MaterialLocalizationSl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Slovenian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSl({
    String localeName = 'sl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => r'Opozorilo';

  @override
  String get anteMeridiemAbbreviation => r'DOP.';

  @override
  String get backButtonTooltip => r'Nazaj';

  @override
  String get cancelButtonLabel => r'PREKLIČI';

  @override
  String get closeButtonLabel => r'ZAPRI';

  @override
  String get closeButtonTooltip => r'Zapiranje';

  @override
  String get collapsedIconTapHint => r'Razširiti';

  @override
  String get continueButtonLabel => r'NAPREJ';

  @override
  String get copyButtonLabel => r'KOPIRAJ';

  @override
  String get cutButtonLabel => r'IZREŽI';

  @override
  String get deleteButtonTooltip => r'Brisanje';

  @override
  String get dialogLabel => r'Pogovorno okno';

  @override
  String get drawerLabel => r'Meni za krmarjenje';

  @override
  String get expandedIconTapHint => r'Strniti';

  @override
  String get hideAccountsLabel => r'Skrivanje računov';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get modalBarrierDismissLabel => r'Opusti';

  @override
  String get nextMonthTooltip => r'Naslednji mesec';

  @override
  String get nextPageTooltip => r'Naslednja stran';

  @override
  String get okButtonLabel => r'V REDU';

  @override
  String get openAppDrawerTooltip => r'Odpiranje menija za krmarjenje';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow od približno $rowCount';

  @override
  String get pasteButtonLabel => r'PRILEPI';

  @override
  String get popupMenuLabel => r'Pojavni meni';

  @override
  String get postMeridiemAbbreviation => r'POP.';

  @override
  String get previousMonthTooltip => r'Prejšnji mesec';

  @override
  String get previousPageTooltip => r'Prejšnja stran';

  @override
  String get refreshIndicatorSemanticLabel => r'Osveži';

  @override
  String get remainingTextFieldCharacterCountFew => r'Še $remainingCount znaki';

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Še 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Še $remainingCount znakov';

  @override
  String get remainingTextFieldCharacterCountTwo => r'Še $remainingCount znaka';

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Premakni navzdol';

  @override
  String get reorderItemLeft => r'Premakni levo';

  @override
  String get reorderItemRight => r'Premakni desno';

  @override
  String get reorderItemToEnd => r'Premakni na konec';

  @override
  String get reorderItemToStart => r'Premakni na začetek';

  @override
  String get reorderItemUp => r'Premakni navzgor';

  @override
  String get rowsPerPageTitle => r'Vrstice na stran:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Iskanje';

  @override
  String get selectAllButtonLabel => r'IZBERI VSE';

  @override
  String get selectedRowCountTitleFew => r'Izbrani so $selectedRowCount elementi';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Izbran je 1 element';

  @override
  String get selectedRowCountTitleOther => r'Izbranih je $selectedRowCount elementov';

  @override
  String get selectedRowCountTitleTwo => r'Izbrana sta $selectedRowCount elementa';

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Prikaz računov';

  @override
  String get showMenuTooltip => r'Prikaz menija';

  @override
  String get signedInLabel => r'Prijavljen';

  @override
  String get tabLabelRaw => r'Zavihek $tabIndex od $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Izberite ure';

  @override
  String get timePickerMinuteModeAnnouncement => r'Izberite minute';

  @override
  String get viewLicensesButtonLabel => r'PRIKAŽI LICENCE';
}

/// The translations for Albanian (`sq`).
class MaterialLocalizationSq extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Albanian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSq({
    String localeName = 'sq',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Rreth $applicationName';

  @override
  String get alertDialogLabel => r'Sinjalizim';

  @override
  String get anteMeridiemAbbreviation => r'paradite';

  @override
  String get backButtonTooltip => r'Prapa';

  @override
  String get cancelButtonLabel => r'ANULO';

  @override
  String get closeButtonLabel => r'MBYLL';

  @override
  String get closeButtonTooltip => r'Mbyll';

  @override
  String get collapsedIconTapHint => r'Zgjero';

  @override
  String get continueButtonLabel => r'VAZHDO';

  @override
  String get copyButtonLabel => r'KOPJO';

  @override
  String get cutButtonLabel => r'PRIT';

  @override
  String get deleteButtonTooltip => r'Fshi';

  @override
  String get dialogLabel => r'Dialogu';

  @override
  String get drawerLabel => r'Menyja e navigimit';

  @override
  String get expandedIconTapHint => r'Palos';

  @override
  String get hideAccountsLabel => r'Fshih llogaritë';

  @override
  String get licensesPageTitle => r'Licencat';

  @override
  String get modalBarrierDismissLabel => r'Hiq';

  @override
  String get nextMonthTooltip => r'Muaji i ardhshëm';

  @override
  String get nextPageTooltip => r'Faqja tjetër';

  @override
  String get okButtonLabel => r'Në rregull';

  @override
  String get openAppDrawerTooltip => r'Hap menynë e navigimit';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow nga $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow nga rreth $rowCount';

  @override
  String get pasteButtonLabel => r'NGJIT';

  @override
  String get popupMenuLabel => r'Menyja kërcyese';

  @override
  String get postMeridiemAbbreviation => r'pasdite';

  @override
  String get previousMonthTooltip => r'Muaji i mëparshëm';

  @override
  String get previousPageTooltip => r'Faqja e mëparshme';

  @override
  String get refreshIndicatorSemanticLabel => r'Rifresko';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 karakter i mbetur';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karaktere të mbetura';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Lëvize poshtë';

  @override
  String get reorderItemLeft => r'Lëvize majtas';

  @override
  String get reorderItemRight => r'Lëvize djathtas';

  @override
  String get reorderItemToEnd => r'Lëvize në fund';

  @override
  String get reorderItemToStart => r'Lëvize në fillim';

  @override
  String get reorderItemUp => r'Lëvize lart';

  @override
  String get rowsPerPageTitle => r'Rreshtat për faqe:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Kërko';

  @override
  String get selectAllButtonLabel => r'ZGJIDHI TË GJITHA';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'U zgjodh 1 artikull';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount artikuj u zgjodhën';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Shfaq llogaritë';

  @override
  String get showMenuTooltip => r'Shfaq menynë';

  @override
  String get signedInLabel => r'Je identifikuar';

  @override
  String get tabLabelRaw => r'Skeda $tabIndex nga $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Zgjidh orët';

  @override
  String get timePickerMinuteModeAnnouncement => r'Zgjidh minutat';

  @override
  String get viewLicensesButtonLabel => r'SHIKO LICENCAT';
}

/// The translations for Serbian (`sr`).
class MaterialLocalizationSr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Serbian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSr({
    String localeName = 'sr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'О апликацији $applicationName';

  @override
  String get alertDialogLabel => r'Обавештење';

  @override
  String get anteMeridiemAbbreviation => r'пре подне';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'ОТКАЖИ';

  @override
  String get closeButtonLabel => r'ЗАТВОРИ';

  @override
  String get closeButtonTooltip => r'Затворите';

  @override
  String get collapsedIconTapHint => r'Прошири';

  @override
  String get continueButtonLabel => r'НАСТАВИ';

  @override
  String get copyButtonLabel => r'КОПИРАЈ';

  @override
  String get cutButtonLabel => r'ИСЕЦИ';

  @override
  String get deleteButtonTooltip => r'Избришите';

  @override
  String get dialogLabel => r'Дијалог';

  @override
  String get drawerLabel => r'Мени за навигацију';

  @override
  String get expandedIconTapHint => r'Скупи';

  @override
  String get hideAccountsLabel => r'Сакриј налоге';

  @override
  String get licensesPageTitle => r'Лиценце';

  @override
  String get modalBarrierDismissLabel => r'Одбаци';

  @override
  String get nextMonthTooltip => r'Следећи месец';

  @override
  String get nextPageTooltip => r'Следећа страница';

  @override
  String get okButtonLabel => r'Потврди';

  @override
  String get openAppDrawerTooltip => r'Отворите мени за навигацију';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow oд $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow oд приближно $rowCount';

  @override
  String get pasteButtonLabel => r'НАЛЕПИ';

  @override
  String get popupMenuLabel => r'Искачући мени';

  @override
  String get postMeridiemAbbreviation => r'по подне';

  @override
  String get previousMonthTooltip => r'Претходни месец';

  @override
  String get previousPageTooltip => r'Претходна страница';

  @override
  String get refreshIndicatorSemanticLabel => r'Освежи';

  @override
  String get remainingTextFieldCharacterCountFew => r'Преостала су $remainingCount знака';

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Преостао је 1 знак';

  @override
  String get remainingTextFieldCharacterCountOther => r'Преостало је $remainingCount знакова';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Померите надоле';

  @override
  String get reorderItemLeft => r'Померите улево';

  @override
  String get reorderItemRight => r'Померите удесно';

  @override
  String get reorderItemToEnd => r'Померите на крај';

  @override
  String get reorderItemToStart => r'Померите на почетак';

  @override
  String get reorderItemUp => r'Померите нагоре';

  @override
  String get rowsPerPageTitle => r'Редова по страници:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Претражите';

  @override
  String get selectAllButtonLabel => r'ИЗАБЕРИ СВЕ';

  @override
  String get selectedRowCountTitleFew => r'Изабране су $selectedRowCount ставке';

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Изабрана је 1 ставка';

  @override
  String get selectedRowCountTitleOther => r'Изабрано је $selectedRowCount ставки';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Прикажи налоге';

  @override
  String get showMenuTooltip => r'Прикажи мени';

  @override
  String get signedInLabel => r'Пријављени сте';

  @override
  String get tabLabelRaw => r'$tabIndex. картица од $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Изаберите сате';

  @override
  String get timePickerMinuteModeAnnouncement => r'Изаберите минуте';

  @override
  String get viewLicensesButtonLabel => r'ПРИКАЖИ ЛИЦЕНЦЕ';
}

/// The translations for Serbian, using the Cyrillic script (`sr_Cyrl`).
class MaterialLocalizationSrCyrl extends MaterialLocalizationSr {
  /// Create an instance of the translation bundle for Serbian, using the Cyrillic script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSrCyrl({
    String localeName = 'sr_Cyrl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );
}

/// The translations for Serbian, using the Latin script (`sr_Latn`).
class MaterialLocalizationSrLatn extends MaterialLocalizationSr {
  /// Create an instance of the translation bundle for Serbian, using the Latin script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSrLatn({
    String localeName = 'sr_Latn',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get remainingTextFieldCharacterCountFew => r'Preostala su $remainingCount znaka';

  @override
  String get selectedRowCountTitleFew => r'Izabrane su $selectedRowCount stavke';

  @override
  String get openAppDrawerTooltip => r'Otvorite meni za navigaciju';

  @override
  String get backButtonTooltip => r'Nazad';

  @override
  String get closeButtonTooltip => r'Zatvorite';

  @override
  String get deleteButtonTooltip => r'Izbrišite';

  @override
  String get nextMonthTooltip => r'Sledeći mesec';

  @override
  String get previousMonthTooltip => r'Prethodni mesec';

  @override
  String get nextPageTooltip => r'Sledeća stranica';

  @override
  String get previousPageTooltip => r'Prethodna stranica';

  @override
  String get showMenuTooltip => r'Prikaži meni';

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get licensesPageTitle => r'Licence';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow od približno $rowCount';

  @override
  String get rowsPerPageTitle => r'Redova po stranici:';

  @override
  String get tabLabelRaw => r'$tabIndex. kartica od $tabCount';

  @override
  String get selectedRowCountTitleOne => r'Izabrana je 1 stavka';

  @override
  String get selectedRowCountTitleOther => r'Izabrano je $selectedRowCount stavki';

  @override
  String get cancelButtonLabel => r'OTKAŽI';

  @override
  String get closeButtonLabel => r'ZATVORI';

  @override
  String get continueButtonLabel => r'NASTAVI';

  @override
  String get copyButtonLabel => r'KOPIRAJ';

  @override
  String get cutButtonLabel => r'ISECI';

  @override
  String get okButtonLabel => r'Potvrdi';

  @override
  String get pasteButtonLabel => r'NALEPI';

  @override
  String get selectAllButtonLabel => r'IZABERI SVE';

  @override
  String get viewLicensesButtonLabel => r'PRIKAŽI LICENCE';

  @override
  String get anteMeridiemAbbreviation => r'pre podne';

  @override
  String get postMeridiemAbbreviation => r'po podne';

  @override
  String get timePickerHourModeAnnouncement => r'Izaberite sate';

  @override
  String get timePickerMinuteModeAnnouncement => r'Izaberite minute';

  @override
  String get modalBarrierDismissLabel => r'Odbaci';

  @override
  String get signedInLabel => r'Prijavljeni ste';

  @override
  String get hideAccountsLabel => r'Sakrij naloge';

  @override
  String get showAccountsLabel => r'Prikaži naloge';

  @override
  String get drawerLabel => r'Meni za navigaciju';

  @override
  String get popupMenuLabel => r'Iskačući meni';

  @override
  String get dialogLabel => r'Dijalog';

  @override
  String get alertDialogLabel => r'Obaveštenje';

  @override
  String get searchFieldLabel => r'Pretražite';

  @override
  String get reorderItemToStart => r'Pomerite na početak';

  @override
  String get reorderItemToEnd => r'Pomerite na kraj';

  @override
  String get reorderItemUp => r'Pomerite nagore';

  @override
  String get reorderItemDown => r'Pomerite nadole';

  @override
  String get reorderItemLeft => r'Pomerite ulevo';

  @override
  String get reorderItemRight => r'Pomerite udesno';

  @override
  String get expandedIconTapHint => r'Skupi';

  @override
  String get collapsedIconTapHint => r'Proširi';

  @override
  String get remainingTextFieldCharacterCountOne => r'Preostao je 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Preostalo je $remainingCount znakova';

  @override
  String get refreshIndicatorSemanticLabel => r'Osveži';
}

/// The translations for Swedish (`sv`).
class MaterialLocalizationSv extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Swedish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSv({
    String localeName = 'sv',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => r'Varning';

  @override
  String get anteMeridiemAbbreviation => r'FM';

  @override
  String get backButtonTooltip => r'Tillbaka';

  @override
  String get cancelButtonLabel => r'AVBRYT';

  @override
  String get closeButtonLabel => r'STÄNG';

  @override
  String get closeButtonTooltip => r'Stäng';

  @override
  String get collapsedIconTapHint => r'Utöka';

  @override
  String get continueButtonLabel => r'FORTSÄTT';

  @override
  String get copyButtonLabel => r'KOPIERA';

  @override
  String get cutButtonLabel => r'KLIPP UT';

  @override
  String get deleteButtonTooltip => r'Radera';

  @override
  String get dialogLabel => r'Dialogruta';

  @override
  String get drawerLabel => r'Navigeringsmeny';

  @override
  String get expandedIconTapHint => r'Dölj';

  @override
  String get hideAccountsLabel => r'Dölj konton';

  @override
  String get licensesPageTitle => r'Licenser';

  @override
  String get modalBarrierDismissLabel => r'Stäng';

  @override
  String get nextMonthTooltip => r'Nästa månad';

  @override
  String get nextPageTooltip => r'Nästa sida';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Öppna navigeringsmenyn';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow av $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow av ungefär $rowCount';

  @override
  String get pasteButtonLabel => r'KLISTRA IN';

  @override
  String get popupMenuLabel => r'Popup-meny';

  @override
  String get postMeridiemAbbreviation => r'EM';

  @override
  String get previousMonthTooltip => r'Föregående månad';

  @override
  String get previousPageTooltip => r'Föregående sida';

  @override
  String get refreshIndicatorSemanticLabel => r'Uppdatera';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 tecken kvar';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount tecken kvar';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Flytta nedåt';

  @override
  String get reorderItemLeft => r'Flytta åt vänster';

  @override
  String get reorderItemRight => r'Flytta åt höger';

  @override
  String get reorderItemToEnd => r'Flytta till slutet';

  @override
  String get reorderItemToStart => r'Flytta till början';

  @override
  String get reorderItemUp => r'Flytta uppåt';

  @override
  String get rowsPerPageTitle => r'Rader per sida:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Sök';

  @override
  String get selectAllButtonLabel => r'MARKERA ALLA';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 objekt har markerats';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount objekt har markerats';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Visa konton';

  @override
  String get showMenuTooltip => r'Visa meny';

  @override
  String get signedInLabel => r'Inloggad';

  @override
  String get tabLabelRaw => r'Flik $tabIndex av $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Välj timmar';

  @override
  String get timePickerMinuteModeAnnouncement => r'Välj minuter';

  @override
  String get viewLicensesButtonLabel => r'VISA LICENSER';
}

/// The translations for Swahili (`sw`).
class MaterialLocalizationSw extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Swahili.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSw({
    String localeName = 'sw',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Kuhusu $applicationName';

  @override
  String get alertDialogLabel => r'Arifa';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Rudi Nyuma';

  @override
  String get cancelButtonLabel => r'GHAIRI';

  @override
  String get closeButtonLabel => r'FUNGA';

  @override
  String get closeButtonTooltip => r'Funga';

  @override
  String get collapsedIconTapHint => r'Panua';

  @override
  String get continueButtonLabel => r'ENDELEA';

  @override
  String get copyButtonLabel => r'NAKILI';

  @override
  String get cutButtonLabel => r'KATA';

  @override
  String get deleteButtonTooltip => r'Futa';

  @override
  String get dialogLabel => r'Kidirisha';

  @override
  String get drawerLabel => r'Menyu ya kusogeza';

  @override
  String get expandedIconTapHint => r'Kunja';

  @override
  String get hideAccountsLabel => r'Ficha akaunti';

  @override
  String get licensesPageTitle => r'Leseni';

  @override
  String get modalBarrierDismissLabel => r'Ondoa';

  @override
  String get nextMonthTooltip => r'Mwezi ujao';

  @override
  String get nextPageTooltip => r'Ukurasa unaofuata';

  @override
  String get okButtonLabel => r'Sawa';

  @override
  String get openAppDrawerTooltip => r'Fungua menyu ya kusogeza';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow hadi $lastRow kati ya $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow hadi $lastRow kati ya takriban $rowCount';

  @override
  String get pasteButtonLabel => r'BANDIKA';

  @override
  String get popupMenuLabel => r'Menyu ibukizi';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Mwezi uliopita';

  @override
  String get previousPageTooltip => r'Ukurasa uliotangulia';

  @override
  String get refreshIndicatorSemanticLabel => r'Onyesha upya';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Imesalia herufi 1';

  @override
  String get remainingTextFieldCharacterCountOther => r'Zimesalia herufi $remainingCount';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'Hapana herufi zilizo baki';

  @override
  String get reorderItemDown => r'Sogeza chini';

  @override
  String get reorderItemLeft => r'Sogeza kushoto';

  @override
  String get reorderItemRight => r'Sogeza kulia';

  @override
  String get reorderItemToEnd => r'Sogeza hadi mwisho';

  @override
  String get reorderItemToStart => r'Sogeza hadi mwanzo';

  @override
  String get reorderItemUp => r'Sogeza juu';

  @override
  String get rowsPerPageTitle => r'Safu mlalo kwa kila ukurasa:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Tafuta';

  @override
  String get selectAllButtonLabel => r'CHAGUA ZOTE';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Umechagua kipengee 1';

  @override
  String get selectedRowCountTitleOther => r'Umechagua vipengee $selectedRowCount';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'Hamna kilicho chaguliwa';

  @override
  String get showAccountsLabel => r'Onyesha akaunti';

  @override
  String get showMenuTooltip => r'Onyesha menyu';

  @override
  String get signedInLabel => r'Umeingia katika akaunti';

  @override
  String get tabLabelRaw => r'Kichupo cha $tabIndex kati ya $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'Chagua saa';

  @override
  String get timePickerMinuteModeAnnouncement => r'Chagua dakika';

  @override
  String get viewLicensesButtonLabel => r'ANGALIA LESENI';
}

/// The translations for Tamil (`ta`).
class MaterialLocalizationTa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Tamil.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTa({
    String localeName = 'ta',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName பற்றி';

  @override
  String get alertDialogLabel => r'விழிப்பூட்டல்';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'முந்தைய பக்கம்';

  @override
  String get cancelButtonLabel => r'ரத்துசெய்';

  @override
  String get closeButtonLabel => r'மூடுக';

  @override
  String get closeButtonTooltip => r'மூடுக';

  @override
  String get collapsedIconTapHint => r'விரிக்கும்';

  @override
  String get continueButtonLabel => r'தொடர்க';

  @override
  String get copyButtonLabel => r'நகலெடு';

  @override
  String get cutButtonLabel => r'வெட்டு';

  @override
  String get deleteButtonTooltip => r'நீக்கு';

  @override
  String get dialogLabel => r'உரையாடல்';

  @override
  String get drawerLabel => r'வழிசெலுத்தல் மெனு';

  @override
  String get expandedIconTapHint => r'சுருக்கும்';

  @override
  String get hideAccountsLabel => r'கணக்குகளை மறைக்கும்';

  @override
  String get licensesPageTitle => r'உரிமங்கள்';

  @override
  String get modalBarrierDismissLabel => r'நிராகரிக்கும்';

  @override
  String get nextMonthTooltip => r'அடுத்த மாதம்';

  @override
  String get nextPageTooltip => r'அடுத்த பக்கம்';

  @override
  String get okButtonLabel => r'சரி';

  @override
  String get openAppDrawerTooltip => r'வழிசெலுத்தல் மெனுவைத் திற';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow / $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow / $rowCount';

  @override
  String get pasteButtonLabel => r'ஒட்டு';

  @override
  String get popupMenuLabel => r'பாப் அப் மெனு';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'முந்தைய மாதம்';

  @override
  String get previousPageTooltip => r'முந்தைய பக்கம்';

  @override
  String get refreshIndicatorSemanticLabel => r'ரெஃப்ரெஷ் செய்யும்';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 எழுத்து மீதமுள்ளது';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount எழுத்துகள் மீதமுள்ளன';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'எழுத்துக்கள் எதுவும் இல்லை';

  @override
  String get reorderItemDown => r'கீழே நகர்த்தவும்';

  @override
  String get reorderItemLeft => r'இடப்புறம் நகர்த்தவும்';

  @override
  String get reorderItemRight => r'வலப்புறம் நகர்த்தவும்';

  @override
  String get reorderItemToEnd => r'இறுதிக்கு நகர்த்தவும்';

  @override
  String get reorderItemToStart => r'தொடக்கத்திற்கு நகர்த்தவும்';

  @override
  String get reorderItemUp => r'மேலே நகர்த்தவும்';

  @override
  String get rowsPerPageTitle => r'ஒரு பக்கத்திற்கான வரிசைகள்:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => r'தேடல்';

  @override
  String get selectAllButtonLabel => r'அனைத்தையும் தேர்ந்தெடு';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 வரிசை தேர்ந்தெடுக்கப்பட்டது';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount வரிசைகள் தேர்ந்தெடுக்கப்பட்டன';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => r'எந்த வரிசையும் தேர்ந்தெடுக்கவில்லை';

  @override
  String get showAccountsLabel => r'கணக்குகளைக் காட்டும்';

  @override
  String get showMenuTooltip => r'மெனுவைக் காட்டு';

  @override
  String get signedInLabel => r'உள்நுழைந்துள்ளீர்கள்';

  @override
  String get tabLabelRaw => r'தாவல் $tabIndex / $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'மணிநேரத்தைத் தேர்ந்தெடுக்கவும்';

  @override
  String get timePickerMinuteModeAnnouncement => r'நிமிடங்களைத் தேர்ந்தெடுக்கவும்';

  @override
  String get viewLicensesButtonLabel => r'உரிமங்களைக் காட்டு';
}

/// The translations for Telugu (`te`).
class MaterialLocalizationTe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Telugu.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTe({
    String localeName = 'te',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName గురించి';

  @override
  String get alertDialogLabel => r'అలర్ట్';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'వెనుకకు';

  @override
  String get cancelButtonLabel => r'రద్దు చేయి';

  @override
  String get closeButtonLabel => r'మూసివేయి';

  @override
  String get closeButtonTooltip => r'మూసివేయి';

  @override
  String get collapsedIconTapHint => r'విస్తరించు';

  @override
  String get continueButtonLabel => r'కొనసాగించు';

  @override
  String get copyButtonLabel => r'కాపీ చేయి';

  @override
  String get cutButtonLabel => r'కత్తిరించు';

  @override
  String get deleteButtonTooltip => r'తొలగించు';

  @override
  String get dialogLabel => r'డైలాగ్';

  @override
  String get drawerLabel => r'నావిగేషన్ మెను';

  @override
  String get expandedIconTapHint => r'కుదించు';

  @override
  String get hideAccountsLabel => r'ఖాతాలను దాచు';

  @override
  String get licensesPageTitle => r'లైసెన్స్‌లు';

  @override
  String get modalBarrierDismissLabel => r'విస్మరించు';

  @override
  String get nextMonthTooltip => r'తర్వాత నెల';

  @override
  String get nextPageTooltip => r'తర్వాత పేజీ';

  @override
  String get okButtonLabel => r'సరే';

  @override
  String get openAppDrawerTooltip => r'నావిగేషన్ మెనూను తెరువు';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountలో $firstRow - $lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCountలో $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => r'అతికించు';

  @override
  String get popupMenuLabel => r'పాప్‌అప్ మెను';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'మునుపటి నెల';

  @override
  String get previousPageTooltip => r'మునుపటి పేజీ';

  @override
  String get refreshIndicatorSemanticLabel => r'రిఫ్రెష్ చేయి';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 అక్షరం మిగిలి ఉంది';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount అక్షరాలు మిగిలి ఉన్నాయి';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'కిందికు జరుపు';

  @override
  String get reorderItemLeft => r'ఎడమవైపుగా జరపండి';

  @override
  String get reorderItemRight => r'కుడివైపుగా జరపండి';

  @override
  String get reorderItemToEnd => r'చివరకు తరలించండి';

  @override
  String get reorderItemToStart => r'ప్రారంభానికి తరలించండి';

  @override
  String get reorderItemUp => r'పైకి జరపండి';

  @override
  String get rowsPerPageTitle => r'పేజీకి ఉండే అడ్డు వరుసలు:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'వెతుకు';

  @override
  String get selectAllButtonLabel => r'అన్నింటినీ ఎంచుకోండి';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 అంశం ఎంచుకోబడింది';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount అంశాలు ఎంచుకోబడ్డాయి';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'ఖాతాలను చూపు';

  @override
  String get showMenuTooltip => r'మెనూను చూపు';

  @override
  String get signedInLabel => r'సైన్ ఇన్ చేసారు';

  @override
  String get tabLabelRaw => r'$tabCountలో $tabIndexవ ట్యాబ్';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'గంటలను ఎంచుకోండి';

  @override
  String get timePickerMinuteModeAnnouncement => r'నిమిషాలను ఎంచుకోండి';

  @override
  String get viewLicensesButtonLabel => r'లైసెన్స్‌లను చూడండి';
}

/// The translations for Thai (`th`).
class MaterialLocalizationTh extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Thai.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTh({
    String localeName = 'th',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'เกี่ยวกับ $applicationName';

  @override
  String get alertDialogLabel => r'การแจ้งเตือน';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'กลับ';

  @override
  String get cancelButtonLabel => r'ยกเลิก';

  @override
  String get closeButtonLabel => r'ปิด';

  @override
  String get closeButtonTooltip => r'ปิด';

  @override
  String get collapsedIconTapHint => r'ขยาย';

  @override
  String get continueButtonLabel => r'ต่อไป';

  @override
  String get copyButtonLabel => r'คัดลอก';

  @override
  String get cutButtonLabel => r'ตัด';

  @override
  String get deleteButtonTooltip => r'ลบ';

  @override
  String get dialogLabel => r'กล่องโต้ตอบ';

  @override
  String get drawerLabel => r'เมนูการนำทาง';

  @override
  String get expandedIconTapHint => r'ยุบ';

  @override
  String get hideAccountsLabel => r'ซ่อนบัญชี';

  @override
  String get licensesPageTitle => r'ใบอนุญาต';

  @override
  String get modalBarrierDismissLabel => r'ปิด';

  @override
  String get nextMonthTooltip => r'เดือนหน้า';

  @override
  String get nextPageTooltip => r'หน้าถัดไป';

  @override
  String get okButtonLabel => r'ตกลง';

  @override
  String get openAppDrawerTooltip => r'เปิดเมนูการนำทาง';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow จาก $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow จากประมาณ $rowCount';

  @override
  String get pasteButtonLabel => r'วาง';

  @override
  String get popupMenuLabel => r'เมนูป๊อปอัป';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'เดือนที่แล้ว';

  @override
  String get previousPageTooltip => r'หน้าก่อน';

  @override
  String get refreshIndicatorSemanticLabel => r'รีเฟรช';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'เหลือ 1 อักขระ';

  @override
  String get remainingTextFieldCharacterCountOther => r'เหลือ $remainingCount อักขระ';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'ย้ายลง';

  @override
  String get reorderItemLeft => r'ย้ายไปทางซ้าย';

  @override
  String get reorderItemRight => r'ย้ายไปทางขวา';

  @override
  String get reorderItemToEnd => r'ย้ายไปท้ายรายการ';

  @override
  String get reorderItemToStart => r'ย้ายไปต้นรายการ';

  @override
  String get reorderItemUp => r'ย้ายขึ้น';

  @override
  String get rowsPerPageTitle => r'แถวต่อหน้า:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'ค้นหา';

  @override
  String get selectAllButtonLabel => r'เลือกทั้งหมด';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'เลือกแล้ว 1 รายการ';

  @override
  String get selectedRowCountTitleOther => r'เลือกแล้ว $selectedRowCount รายการ';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'แสดงบัญชี';

  @override
  String get showMenuTooltip => r'แสดงเมนู';

  @override
  String get signedInLabel => r'ลงชื่อเข้าใช้';

  @override
  String get tabLabelRaw => r'แท็บที่ $tabIndex จาก $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'เลือกชั่วโมง';

  @override
  String get timePickerMinuteModeAnnouncement => r'เลือกนาที';

  @override
  String get viewLicensesButtonLabel => r'ดูใบอนุญาต';
}

/// The translations for Tagalog (`tl`).
class MaterialLocalizationTl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Tagalog.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTl({
    String localeName = 'tl',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tungkol sa $applicationName';

  @override
  String get alertDialogLabel => r'Alerto';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Bumalik';

  @override
  String get cancelButtonLabel => r'KANSELAHIN';

  @override
  String get closeButtonLabel => r'ISARA';

  @override
  String get closeButtonTooltip => r'Isara';

  @override
  String get collapsedIconTapHint => r'I-expand';

  @override
  String get continueButtonLabel => r'MAGPATULOY';

  @override
  String get copyButtonLabel => r'KOPYAHIN';

  @override
  String get cutButtonLabel => r'I-CUT';

  @override
  String get deleteButtonTooltip => r'I-delete';

  @override
  String get dialogLabel => r'Dialog';

  @override
  String get drawerLabel => r'Menu ng navigation';

  @override
  String get expandedIconTapHint => r'I-collapse';

  @override
  String get hideAccountsLabel => r'Itago ang mga account';

  @override
  String get licensesPageTitle => r'Mga Lisensya';

  @override
  String get modalBarrierDismissLabel => r'I-dismiss';

  @override
  String get nextMonthTooltip => r'Susunod na buwan';

  @override
  String get nextPageTooltip => r'Susunod na page';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Buksan ang menu ng navigation';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ng $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ng humigit kumulang $rowCount';

  @override
  String get pasteButtonLabel => r'I-PASTE';

  @override
  String get popupMenuLabel => r'Popup na menu';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Nakaraang buwan';

  @override
  String get previousPageTooltip => r'Nakaraang page';

  @override
  String get refreshIndicatorSemanticLabel => r'Nagre-refresh';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 character ang natitira';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount na character ang natitira';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Ilipat pababa';

  @override
  String get reorderItemLeft => r'Ilipat pakaliwa';

  @override
  String get reorderItemRight => r'Ilipat pakanan';

  @override
  String get reorderItemToEnd => r'Ilipat sa dulo';

  @override
  String get reorderItemToStart => r'Ilipat sa simula';

  @override
  String get reorderItemUp => r'Ilipat pataas';

  @override
  String get rowsPerPageTitle => r'Mga row bawat page:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Maghanap';

  @override
  String get selectAllButtonLabel => r'PILIIN LAHAT';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 item ang napili';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount na item ang napili';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Ipakita ang mga account';

  @override
  String get showMenuTooltip => r'Ipakita ang menu';

  @override
  String get signedInLabel => r'Naka-sign in';

  @override
  String get tabLabelRaw => r'Tab $tabIndex ng $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Pumili ng mga oras';

  @override
  String get timePickerMinuteModeAnnouncement => r'Pumili ng mga minuto';

  @override
  String get viewLicensesButtonLabel => r'TINGNAN ANG MGA LISENSYA';
}

/// The translations for Turkish (`tr`).
class MaterialLocalizationTr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Turkish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTr({
    String localeName = 'tr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName Hakkında';

  @override
  String get alertDialogLabel => r'Uyarı';

  @override
  String get anteMeridiemAbbreviation => r'ÖÖ';

  @override
  String get backButtonTooltip => r'Geri';

  @override
  String get cancelButtonLabel => r'İPTAL';

  @override
  String get closeButtonLabel => r'KAPAT';

  @override
  String get closeButtonTooltip => r'Kapat';

  @override
  String get collapsedIconTapHint => r'Genişlet';

  @override
  String get continueButtonLabel => r'DEVAM';

  @override
  String get copyButtonLabel => r'KOPYALA';

  @override
  String get cutButtonLabel => r'KES';

  @override
  String get deleteButtonTooltip => r'Sil';

  @override
  String get dialogLabel => r'İletişim kutusu';

  @override
  String get drawerLabel => r'Gezinme menüsü';

  @override
  String get expandedIconTapHint => r'Daralt';

  @override
  String get hideAccountsLabel => r'Hesapları gizle';

  @override
  String get licensesPageTitle => r'Lisanslar';

  @override
  String get modalBarrierDismissLabel => r'Kapat';

  @override
  String get nextMonthTooltip => r'Gelecek ay';

  @override
  String get nextPageTooltip => r'Sonraki sayfa';

  @override
  String get okButtonLabel => r'Tamam';

  @override
  String get openAppDrawerTooltip => r'Gezinme menüsünü aç';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow / $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow / $rowCount';

  @override
  String get pasteButtonLabel => r'YAPIŞTIR';

  @override
  String get popupMenuLabel => r'Popup menü';

  @override
  String get postMeridiemAbbreviation => r'ÖS';

  @override
  String get previousMonthTooltip => r'Önceki ay';

  @override
  String get previousPageTooltip => r'Önceki sayfa';

  @override
  String get refreshIndicatorSemanticLabel => r'Yenile';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 karakter kaldı';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karakter kaldı';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Aşağı taşı';

  @override
  String get reorderItemLeft => r'Sola taşı';

  @override
  String get reorderItemRight => r'Sağa taşı';

  @override
  String get reorderItemToEnd => r'Sona taşı';

  @override
  String get reorderItemToStart => r'Başa taşı';

  @override
  String get reorderItemUp => r'Yukarı taşı';

  @override
  String get rowsPerPageTitle => r'Sayfa başına satır sayısı:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Ara';

  @override
  String get selectAllButtonLabel => r'TÜMÜNÜ SEÇ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 öğe seçildi';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount öğe seçildi';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Hesapları göster';

  @override
  String get showMenuTooltip => r'Menüyü göster';

  @override
  String get signedInLabel => r'Oturum açıldı';

  @override
  String get tabLabelRaw => r'Sekme $tabIndex / $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Saati seçin';

  @override
  String get timePickerMinuteModeAnnouncement => r'Dakikayı seçin';

  @override
  String get viewLicensesButtonLabel => r'LİSANSLARI GÖSTER';
}

/// The translations for Ukrainian (`uk`).
class MaterialLocalizationUk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Ukrainian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationUk({
    String localeName = 'uk',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Про додаток $applicationName';

  @override
  String get alertDialogLabel => r'Сповіщення';

  @override
  String get anteMeridiemAbbreviation => r'дп';

  @override
  String get backButtonTooltip => r'Назад';

  @override
  String get cancelButtonLabel => r'СКАСУВАТИ';

  @override
  String get closeButtonLabel => r'ЗАКРИТИ';

  @override
  String get closeButtonTooltip => r'Закрити';

  @override
  String get collapsedIconTapHint => r'Розгорнути';

  @override
  String get continueButtonLabel => r'ПРОДОВЖИТИ';

  @override
  String get copyButtonLabel => r'КОПІЮВАТИ';

  @override
  String get cutButtonLabel => r'ВИРІЗАТИ';

  @override
  String get deleteButtonTooltip => r'Видалити';

  @override
  String get dialogLabel => r'Вікно';

  @override
  String get drawerLabel => r'Меню навігації';

  @override
  String get expandedIconTapHint => r'Згорнути';

  @override
  String get hideAccountsLabel => r'Сховати облікові записи';

  @override
  String get licensesPageTitle => r'Ліцензії';

  @override
  String get modalBarrierDismissLabel => r'Закрити';

  @override
  String get nextMonthTooltip => r'Наступний місяць';

  @override
  String get nextPageTooltip => r'Наступна сторінка';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Відкрити меню навігації';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow з $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow з приблизно $rowCount';

  @override
  String get pasteButtonLabel => r'ВСТАВИТИ';

  @override
  String get popupMenuLabel => r'Спливаюче меню';

  @override
  String get postMeridiemAbbreviation => r'пп';

  @override
  String get previousMonthTooltip => r'Попередній місяць';

  @override
  String get previousPageTooltip => r'Попередня сторінка';

  @override
  String get refreshIndicatorSemanticLabel => r'Оновити';

  @override
  String get remainingTextFieldCharacterCountFew => r'Залишилося $remainingCount символи';

  @override
  String get remainingTextFieldCharacterCountMany => r'Залишилося $remainingCount символів';

  @override
  String get remainingTextFieldCharacterCountOne => r'Залишився 1 символ';

  @override
  String get remainingTextFieldCharacterCountOther => r'Залишилося $remainingCount символу';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Перемістити вниз';

  @override
  String get reorderItemLeft => r'Перемістити ліворуч';

  @override
  String get reorderItemRight => r'Перемістити праворуч';

  @override
  String get reorderItemToEnd => r'Перемістити в кінець';

  @override
  String get reorderItemToStart => r'Перемістити на початок';

  @override
  String get reorderItemUp => r'Перемістити вгору';

  @override
  String get rowsPerPageTitle => r'Рядків на сторінці:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Пошук';

  @override
  String get selectAllButtonLabel => r'ВИБРАТИ ВСІ';

  @override
  String get selectedRowCountTitleFew => r'Вибрано $selectedRowCount елементи';

  @override
  String get selectedRowCountTitleMany => r'Вибрано $selectedRowCount елементів';

  @override
  String get selectedRowCountTitleOne => r'Вибрано 1 елемент';

  @override
  String get selectedRowCountTitleOther => r'Вибрано $selectedRowCount елемента';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Показати облікові записи';

  @override
  String get showMenuTooltip => r'Показати меню';

  @override
  String get signedInLabel => r'Ви ввійшли';

  @override
  String get tabLabelRaw => r'Вкладка $tabIndex з $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Виберіть години';

  @override
  String get timePickerMinuteModeAnnouncement => r'Виберіть хвилини';

  @override
  String get viewLicensesButtonLabel => r'ПЕРЕГЛЯНУТИ ЛІЦЕНЗІЇ';
}

/// The translations for Urdu (`ur`).
class MaterialLocalizationUr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Urdu.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationUr({
    String localeName = 'ur',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName کے بارے میں';

  @override
  String get alertDialogLabel => r'الرٹ';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'پیچھے';

  @override
  String get cancelButtonLabel => r'منسوخ کریں';

  @override
  String get closeButtonLabel => r'بند کریں';

  @override
  String get closeButtonTooltip => r'بند کریں';

  @override
  String get collapsedIconTapHint => r'پھیلائیں';

  @override
  String get continueButtonLabel => r'جاری رکھیں';

  @override
  String get copyButtonLabel => r'کاپی کریں';

  @override
  String get cutButtonLabel => r'کٹ کریں';

  @override
  String get deleteButtonTooltip => r'حذف کریں';

  @override
  String get dialogLabel => r'ڈائلاگ';

  @override
  String get drawerLabel => r'نیویگیشن مینو';

  @override
  String get expandedIconTapHint => r'سکیڑیں';

  @override
  String get hideAccountsLabel => r'اکاؤنٹس چھپائیں';

  @override
  String get licensesPageTitle => r'لائسنسز';

  @override
  String get modalBarrierDismissLabel => r'برخاست کریں';

  @override
  String get nextMonthTooltip => r'اگلا مہینہ';

  @override
  String get nextPageTooltip => r'اگلا صفحہ';

  @override
  String get okButtonLabel => r'ٹھیک ہے';

  @override
  String get openAppDrawerTooltip => r'نیویگیشن مینو کھولیں';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow از $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow $rowCount میں سے تقریباً';

  @override
  String get pasteButtonLabel => r'پیسٹ کریں';

  @override
  String get popupMenuLabel => r'پاپ اپ مینو';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'پچھلا مہینہ';

  @override
  String get previousPageTooltip => r'گزشتہ صفحہ';

  @override
  String get refreshIndicatorSemanticLabel => r'ریفریش کریں';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 حرف باقی ہے';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount حروف باقی ہیں';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'نیچے منتقل کریں';

  @override
  String get reorderItemLeft => r'بائیں منتقل کریں';

  @override
  String get reorderItemRight => r'دائیں منتقل کریں';

  @override
  String get reorderItemToEnd => r'آخر میں منتقل کریں';

  @override
  String get reorderItemToStart => r'شروع میں منتقل کریں';

  @override
  String get reorderItemUp => r'اوپر منتقل کریں';

  @override
  String get rowsPerPageTitle => r'قطاریں فی صفحہ:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => r'تلاش';

  @override
  String get selectAllButtonLabel => r'سبھی منتخب کریں';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 آئٹم منتخب کیا گیا';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount آئٹمز منتخب کیے گئے';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'اکاؤنٹس دکھائیں';

  @override
  String get showMenuTooltip => r'مینو دکھائیں';

  @override
  String get signedInLabel => r'سائن ان کردہ ہے';

  @override
  String get tabLabelRaw => r'$tabCount میں سے $tabIndex ٹیب';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerHourModeAnnouncement => r'گھنٹے منتخب کریں';

  @override
  String get timePickerMinuteModeAnnouncement => r'منٹ منتخب کریں';

  @override
  String get viewLicensesButtonLabel => r'لائسنسز دیکھیں';
}

/// The translations for Uzbek (`uz`).
class MaterialLocalizationUz extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Uzbek.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationUz({
    String localeName = 'uz',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName haqida';

  @override
  String get alertDialogLabel => r'Ogohlantirish';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Orqaga';

  @override
  String get cancelButtonLabel => r'BEKOR QILISH';

  @override
  String get closeButtonLabel => r'YOPISH';

  @override
  String get closeButtonTooltip => r'Yopish';

  @override
  String get collapsedIconTapHint => r'Yoyish';

  @override
  String get continueButtonLabel => r'DAVOM ETISH';

  @override
  String get copyButtonLabel => r'NUSXA OLISH';

  @override
  String get cutButtonLabel => r'KESIB OLISH';

  @override
  String get deleteButtonTooltip => r'Olib tashlash';

  @override
  String get dialogLabel => r'Muloqot oynasi';

  @override
  String get drawerLabel => r'Navigatsiya menyusi';

  @override
  String get expandedIconTapHint => r'Kichraytirish';

  @override
  String get hideAccountsLabel => r'Hisoblarni berkitish';

  @override
  String get licensesPageTitle => r'Litsenziyalar';

  @override
  String get modalBarrierDismissLabel => r'Yopish';

  @override
  String get nextMonthTooltip => r'Keyingi oy';

  @override
  String get nextPageTooltip => r'Keyingi sahifa';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Navigatsiya menyusini ochish';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow, jami: $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow, jami: $rowCount';

  @override
  String get pasteButtonLabel => r'JOYLASH';

  @override
  String get popupMenuLabel => r'Pop-ap menyusi';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Avvalgi oy';

  @override
  String get previousPageTooltip => r'Avvalgi sahifa';

  @override
  String get refreshIndicatorSemanticLabel => r'Yangilash';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 ta belgi qoldi';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount ta belgi qoldi';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Pastga siljitish';

  @override
  String get reorderItemLeft => r'Chapga siljitish';

  @override
  String get reorderItemRight => r'Oʻngga siljitish';

  @override
  String get reorderItemToEnd => r'Oxiriga siljitish';

  @override
  String get reorderItemToStart => r'Boshiga siljitish';

  @override
  String get reorderItemUp => r'Tepaga siljitish';

  @override
  String get rowsPerPageTitle => r'Har bir sahifadagi qatorlar soni:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Qidirish';

  @override
  String get selectAllButtonLabel => r'BARCHASINI TANLASH';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 ta element tanlandi';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ta element tanlandi';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Hisoblarni koʻrsatish';

  @override
  String get showMenuTooltip => r'Menyuni koʻrsatish';

  @override
  String get signedInLabel => r'Hisobingizga kirgansiz';

  @override
  String get tabLabelRaw => r'$tabCount varaqdan $tabIndex';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Soatni tanlang';

  @override
  String get timePickerMinuteModeAnnouncement => r'Daqiqani tanlang';

  @override
  String get viewLicensesButtonLabel => r'Litsenziyalarni koʻrish';
}

/// The translations for Vietnamese (`vi`).
class MaterialLocalizationVi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Vietnamese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationVi({
    String localeName = 'vi',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Giới thiệu về $applicationName';

  @override
  String get alertDialogLabel => r'Thông báo';

  @override
  String get anteMeridiemAbbreviation => r'SÁNG';

  @override
  String get backButtonTooltip => r'Quay lại';

  @override
  String get cancelButtonLabel => r'HỦY';

  @override
  String get closeButtonLabel => r'ĐÓNG';

  @override
  String get closeButtonTooltip => r'Đóng';

  @override
  String get collapsedIconTapHint => r'Mở rộng';

  @override
  String get continueButtonLabel => r'TIẾP TỤC';

  @override
  String get copyButtonLabel => r'SAO CHÉP';

  @override
  String get cutButtonLabel => r'CẮT';

  @override
  String get deleteButtonTooltip => r'Xóa';

  @override
  String get dialogLabel => r'Hộp thoại';

  @override
  String get drawerLabel => r'Menu di chuyển';

  @override
  String get expandedIconTapHint => r'Thu gọn';

  @override
  String get hideAccountsLabel => r'Ẩn tài khoản';

  @override
  String get licensesPageTitle => r'Giấy phép';

  @override
  String get modalBarrierDismissLabel => r'Bỏ qua';

  @override
  String get nextMonthTooltip => r'Tháng sau';

  @override
  String get nextPageTooltip => r'Trang tiếp theo';

  @override
  String get okButtonLabel => r'OK';

  @override
  String get openAppDrawerTooltip => r'Mở menu di chuyển';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow trong tổng số $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow trong tổng số khoảng $rowCount';

  @override
  String get pasteButtonLabel => r'DÁN';

  @override
  String get popupMenuLabel => r'Menu bật lên';

  @override
  String get postMeridiemAbbreviation => r'CHIỀU';

  @override
  String get previousMonthTooltip => r'Tháng trước';

  @override
  String get previousPageTooltip => r'Trang trước';

  @override
  String get refreshIndicatorSemanticLabel => r'Làm mới';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'Còn lại 1 ký tự';

  @override
  String get remainingTextFieldCharacterCountOther => r'Còn lại $remainingCount ký tự';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'Di chuyển xuống';

  @override
  String get reorderItemLeft => r'Di chuyển sang trái';

  @override
  String get reorderItemRight => r'Di chuyển sang phải';

  @override
  String get reorderItemToEnd => r'Di chuyển xuống cuối danh sách';

  @override
  String get reorderItemToStart => r'Di chuyển lên đầu danh sách';

  @override
  String get reorderItemUp => r'Di chuyển lên';

  @override
  String get rowsPerPageTitle => r'Số hàng mỗi trang:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Tìm kiếm';

  @override
  String get selectAllButtonLabel => r'CHỌN TẤT CẢ';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'Đã chọn 1 mục';

  @override
  String get selectedRowCountTitleOther => r'Đã chọn $selectedRowCount mục';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Hiển thị tài khoản';

  @override
  String get showMenuTooltip => r'Hiển thị menu';

  @override
  String get signedInLabel => r'Đã đăng nhập';

  @override
  String get tabLabelRaw => r'Tab $tabIndex trong tổng số $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Chọn giờ';

  @override
  String get timePickerMinuteModeAnnouncement => r'Chọn phút';

  @override
  String get viewLicensesButtonLabel => r'XEM GIẤY PHÉP';
}

/// The translations for Chinese (`zh`).
class MaterialLocalizationZh extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Chinese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZh({
    String localeName = 'zh',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'关于$applicationName';

  @override
  String get alertDialogLabel => r'提醒';

  @override
  String get anteMeridiemAbbreviation => r'上午';

  @override
  String get backButtonTooltip => r'返回';

  @override
  String get cancelButtonLabel => r'取消';

  @override
  String get closeButtonLabel => r'关闭';

  @override
  String get closeButtonTooltip => r'关闭';

  @override
  String get collapsedIconTapHint => r'展开';

  @override
  String get continueButtonLabel => r'继续';

  @override
  String get copyButtonLabel => r'复制';

  @override
  String get cutButtonLabel => r'剪切';

  @override
  String get deleteButtonTooltip => r'删除';

  @override
  String get dialogLabel => r'对话框';

  @override
  String get drawerLabel => r'导航菜单';

  @override
  String get expandedIconTapHint => r'收起';

  @override
  String get hideAccountsLabel => r'隐藏帐号';

  @override
  String get licensesPageTitle => r'许可';

  @override
  String get modalBarrierDismissLabel => r'关闭';

  @override
  String get nextMonthTooltip => r'下个月';

  @override
  String get nextPageTooltip => r'下一页';

  @override
  String get okButtonLabel => r'确定';

  @override
  String get openAppDrawerTooltip => r'打开导航菜单';

  @override
  String get pageRowsInfoTitleRaw => r'第 $firstRow-$lastRow 行（共 $rowCount 行）';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'第 $firstRow-$lastRow 行（共约 $rowCount 行）';

  @override
  String get pasteButtonLabel => r'粘贴';

  @override
  String get popupMenuLabel => r'弹出菜单';

  @override
  String get postMeridiemAbbreviation => r'下午';

  @override
  String get previousMonthTooltip => r'上个月';

  @override
  String get previousPageTooltip => r'上一页';

  @override
  String get refreshIndicatorSemanticLabel => r'刷新';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'还可输入 1 个字符';

  @override
  String get remainingTextFieldCharacterCountOther => r'还可输入 $remainingCount 个字符';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => r'TBD';

  @override
  String get reorderItemDown => r'下移';

  @override
  String get reorderItemLeft => r'左移';

  @override
  String get reorderItemRight => r'右移';

  @override
  String get reorderItemToEnd => r'移到末尾';

  @override
  String get reorderItemToStart => r'移到开头';

  @override
  String get reorderItemUp => r'上移';

  @override
  String get rowsPerPageTitle => r'每页行数：';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => r'搜索';

  @override
  String get selectAllButtonLabel => r'全选';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'已选择 1 项内容';

  @override
  String get selectedRowCountTitleOther => r'已选择 $selectedRowCount 项内容';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'显示帐号';

  @override
  String get showMenuTooltip => r'显示菜单';

  @override
  String get signedInLabel => r'已登录';

  @override
  String get tabLabelRaw => r'第 $tabIndex 个标签，共 $tabCount 个';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'选择小时';

  @override
  String get timePickerMinuteModeAnnouncement => r'选择分钟';

  @override
  String get viewLicensesButtonLabel => r'查看许可';
}

/// The translations for Chinese, using the Han script (`zh_Hans`).
class MaterialLocalizationZhHans extends MaterialLocalizationZh {
  /// Create an instance of the translation bundle for Chinese, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhHans({
    String localeName = 'zh_Hans',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class MaterialLocalizationZhHant extends MaterialLocalizationZh {
  /// Create an instance of the translation bundle for Chinese, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhHant({
    String localeName = 'zh_Hant',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get tabLabelRaw => r'第 $tabIndex 個分頁 (共 $tabCount 個)';

  @override
  String get showAccountsLabel => r'顯示帳戶';

  @override
  String get modalBarrierDismissLabel => r'關閉';

  @override
  String get hideAccountsLabel => r'隱藏帳戶';

  @override
  String get signedInLabel => r'已登入帳戶';

  @override
  String get openAppDrawerTooltip => r'開啟導覽選單';

  @override
  String get closeButtonTooltip => r'關閉';

  @override
  String get deleteButtonTooltip => r'刪除';

  @override
  String get nextMonthTooltip => r'下個月';

  @override
  String get previousMonthTooltip => r'上個月';

  @override
  String get nextPageTooltip => r'下一頁';

  @override
  String get previousPageTooltip => r'上一頁';

  @override
  String get showMenuTooltip => r'顯示選單';

  @override
  String get aboutListTileTitleRaw => r'關於「$applicationName」';

  @override
  String get licensesPageTitle => r'授權';

  @override
  String get pageRowsInfoTitleRaw => r'第 $firstRow - $lastRow 列 (總共 $rowCount 列)';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'第 $firstRow - $lastRow 列 (總共約 $rowCount 列)';

  @override
  String get rowsPerPageTitle => r'每頁列數：';

  @override
  String get selectedRowCountTitleOne => r'已選取 1 個項目';

  @override
  String get selectedRowCountTitleOther => r'已選取 $selectedRowCount 個項目';

  @override
  String get closeButtonLabel => r'關閉';

  @override
  String get continueButtonLabel => r'繼續';

  @override
  String get copyButtonLabel => r'複製';

  @override
  String get cutButtonLabel => r'剪下';

  @override
  String get okButtonLabel => r'確定';

  @override
  String get pasteButtonLabel => r'貼上';

  @override
  String get selectAllButtonLabel => r'全選';

  @override
  String get viewLicensesButtonLabel => r'查看授權';

  @override
  String get timePickerHourModeAnnouncement => r'選取小時數';

  @override
  String get timePickerMinuteModeAnnouncement => r'選取分鐘數';

  @override
  String get drawerLabel => r'導覽選單';

  @override
  String get popupMenuLabel => r'彈出式選單';

  @override
  String get dialogLabel => r'對話方塊';

  @override
  String get alertDialogLabel => r'快訊';

  @override
  String get searchFieldLabel => r'搜尋';

  @override
  String get reorderItemToStart => r'移至開頭';

  @override
  String get reorderItemToEnd => r'移至結尾';

  @override
  String get reorderItemUp => r'向上移';

  @override
  String get reorderItemDown => r'向下移';

  @override
  String get reorderItemLeft => r'向左移';

  @override
  String get reorderItemRight => r'向右移';

  @override
  String get expandedIconTapHint => r'收合';

  @override
  String get collapsedIconTapHint => r'展開';

  @override
  String get remainingTextFieldCharacterCountOne => r'還可輸入 1 個字元';

  @override
  String get remainingTextFieldCharacterCountOther => r'還可輸入 $remainingCount 個字元';

  @override
  String get refreshIndicatorSemanticLabel => r'重新整理';
}

/// The translations for Chinese, as used in Hong Kong, using the Han script (`zh_Hant_HK`).
class MaterialLocalizationZhHantHk extends MaterialLocalizationZhHant {
  /// Create an instance of the translation bundle for Chinese, as used in Hong Kong, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhHantHk({
    String localeName = 'zh_Hant_HK',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );
}

/// The translations for Chinese, as used in Taiwan, using the Han script (`zh_Hant_TW`).
class MaterialLocalizationZhHantTw extends MaterialLocalizationZhHant {
  /// Create an instance of the translation bundle for Chinese, as used in Taiwan, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhHantTw({
    String localeName = 'zh_Hant_TW',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );
}

/// The translations for Zulu (`zu`).
class MaterialLocalizationZu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Zulu.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZu({
    String localeName = 'zu',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat longDateFormat,
    @required intl.DateFormat yearMonthFormat,
    @required intl.NumberFormat decimalFormat,
    @required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Mayelana no-$applicationName';

  @override
  String get alertDialogLabel => r'Isexwayiso';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get backButtonTooltip => r'Emuva';

  @override
  String get cancelButtonLabel => r'KHANSELA';

  @override
  String get closeButtonLabel => r'VALA';

  @override
  String get closeButtonTooltip => r'Vala';

  @override
  String get collapsedIconTapHint => r'Nweba';

  @override
  String get continueButtonLabel => r'QHUBEKA';

  @override
  String get copyButtonLabel => r'KOPISHA';

  @override
  String get cutButtonLabel => r'SIKA';

  @override
  String get deleteButtonTooltip => r'Susa';

  @override
  String get dialogLabel => r'Ingxoxo';

  @override
  String get drawerLabel => r'Imenyu yokuzulazula';

  @override
  String get expandedIconTapHint => r'Goqa';

  @override
  String get hideAccountsLabel => r'Fihla ama-akhawunti';

  @override
  String get licensesPageTitle => r'Amalayisense';

  @override
  String get modalBarrierDismissLabel => r'Cashisa';

  @override
  String get nextMonthTooltip => r'Inyanga ezayo';

  @override
  String get nextPageTooltip => r'Ikhasi elilandelayo';

  @override
  String get okButtonLabel => r'KULUNGILE';

  @override
  String get openAppDrawerTooltip => r'Vula imenyu yokuzulazula';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow kokungu-$rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow cishe kokungu-$rowCount';

  @override
  String get pasteButtonLabel => r'NAMATHISELA';

  @override
  String get popupMenuLabel => r'Imenyu ye-popup';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get previousMonthTooltip => r'Inyanga edlule';

  @override
  String get previousPageTooltip => r'Ikhasi elidlule';

  @override
  String get refreshIndicatorSemanticLabel => r'Vuselela';

  @override
  String get remainingTextFieldCharacterCountFew => null;

  @override
  String get remainingTextFieldCharacterCountMany => null;

  @override
  String get remainingTextFieldCharacterCountOne => r'1 uhlamvu olusele';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount izinhlamvu ezisele';

  @override
  String get remainingTextFieldCharacterCountTwo => null;

  @override
  String get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => r'Iya phansi';

  @override
  String get reorderItemLeft => r'Hambisa kwesokunxele';

  @override
  String get reorderItemRight => r'Yisa kwesokudla';

  @override
  String get reorderItemToEnd => r'Yisa ekugcineni';

  @override
  String get reorderItemToStart => r'Yisa ekuqaleni';

  @override
  String get reorderItemUp => r'Iya phezulu';

  @override
  String get rowsPerPageTitle => r'Imigqa ekhasini ngalinye:';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => r'Sesha';

  @override
  String get selectAllButtonLabel => r'KHETHA KONKE';

  @override
  String get selectedRowCountTitleFew => null;

  @override
  String get selectedRowCountTitleMany => null;

  @override
  String get selectedRowCountTitleOne => r'1 into ekhethiwe';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount izinto ezikhethiwe';

  @override
  String get selectedRowCountTitleTwo => null;

  @override
  String get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => r'Bonisa ama-akhawunti';

  @override
  String get showMenuTooltip => r'Bonisa imenyu';

  @override
  String get signedInLabel => r'Ungene ngemvume';

  @override
  String get tabLabelRaw => r'Ithebhu $tabIndex kwangu-$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerHourModeAnnouncement => r'Khetha amahora';

  @override
  String get timePickerMinuteModeAnnouncement => r'Khetha amaminithi';

  @override
  String get viewLicensesButtonLabel => r'Buka amalayisense';
}

/// The set of supported languages, as language code strings.
///
/// The [GlobalMaterialLocalizations.delegate] can generate localizations for
/// any [Locale] with a language code from this set, regardless of the region.
/// Some regions have specific support (e.g. `de` covers all forms of German,
/// but there is support for `de-CH` specifically to override some of the
/// translations for Switzerland).
///
/// See also:
///
///  * [getMaterialTranslation], whose documentation describes these values.
final Set<String> kMaterialSupportedLanguages = HashSet<String>.from(const <String>[
  'af', // Afrikaans
  'am', // Amharic
  'ar', // Arabic
  'as', // Assamese
  'az', // Azerbaijani
  'be', // Belarusian
  'bg', // Bulgarian
  'bn', // Bengali Bangla
  'bs', // Bosnian
  'ca', // Catalan Valencian
  'cs', // Czech
  'da', // Danish
  'de', // German
  'el', // Modern Greek
  'en', // English
  'es', // Spanish Castilian
  'et', // Estonian
  'eu', // Basque
  'fa', // Persian
  'fi', // Finnish
  'fil', // Filipino Pilipino
  'fr', // French
  'gl', // Galician
  'gsw', // Swiss German Alemannic Alsatian
  'gu', // Gujarati
  'he', // Hebrew
  'hi', // Hindi
  'hr', // Croatian
  'hu', // Hungarian
  'hy', // Armenian
  'id', // Indonesian
  'is', // Icelandic
  'it', // Italian
  'ja', // Japanese
  'ka', // Georgian
  'kk', // Kazakh
  'km', // Khmer Central Khmer
  'ko', // Korean
  'ky', // Kirghiz Kyrgyz
  'lo', // Lao
  'lt', // Lithuanian
  'lv', // Latvian
  'mk', // Macedonian
  'ml', // Malayalam
  'mn', // Mongolian
  'mr', // Marathi
  'ms', // Malay
  'my', // Burmese
  'nb', // Norwegian Bokmål
  'ne', // Nepali
  'nl', // Dutch Flemish
  'or', // Oriya
  'pa', // Panjabi Punjabi
  'pl', // Polish
  'ps', // Pushto Pashto
  'pt', // Portuguese
  'ro', // Romanian Moldavian Moldovan
  'ru', // Russian
  'si', // Sinhala Sinhalese
  'sk', // Slovak
  'sl', // Slovenian
  'sq', // Albanian
  'sr', // Serbian
  'sv', // Swedish
  'sw', // Swahili
  'ta', // Tamil
  'te', // Telugu
  'th', // Thai
  'tl', // Tagalog
  'tr', // Turkish
  'uk', // Ukrainian
  'ur', // Urdu
  'uz', // Uzbek
  'vi', // Vietnamese
  'zh', // Chinese
  'zu', // Zulu
]);

/// Creates a [GlobalMaterialLocalizations] instance for the given `locale`.
///
/// All of the function's arguments except `locale` will be passed to the [
/// GlobalMaterialLocalizations] constructor. (The `localeName` argument of that
/// constructor is specified by the actual subclass constructor by this
/// function.)
///
/// The following locales are supported by this package:
///
/// {@template flutter.localizations.material.languages}
///  * `af` - Afrikaans
///  * `am` - Amharic
///  * `ar` - Arabic
///  * `as` - Assamese
///  * `az` - Azerbaijani
///  * `be` - Belarusian
///  * `bg` - Bulgarian
///  * `bn` - Bengali Bangla
///  * `bs` - Bosnian
///  * `ca` - Catalan Valencian
///  * `cs` - Czech
///  * `da` - Danish
///  * `de` - German (plus one country variation)
///  * `el` - Modern Greek
///  * `en` - English (plus 7 country variations)
///  * `es` - Spanish Castilian (plus 20 country variations)
///  * `et` - Estonian
///  * `eu` - Basque
///  * `fa` - Persian
///  * `fi` - Finnish
///  * `fil` - Filipino Pilipino
///  * `fr` - French (plus one country variation)
///  * `gl` - Galician
///  * `gsw` - Swiss German Alemannic Alsatian
///  * `gu` - Gujarati
///  * `he` - Hebrew
///  * `hi` - Hindi
///  * `hr` - Croatian
///  * `hu` - Hungarian
///  * `hy` - Armenian
///  * `id` - Indonesian
///  * `is` - Icelandic
///  * `it` - Italian
///  * `ja` - Japanese
///  * `ka` - Georgian
///  * `kk` - Kazakh
///  * `km` - Khmer Central Khmer
///  * `ko` - Korean
///  * `ky` - Kirghiz Kyrgyz
///  * `lo` - Lao
///  * `lt` - Lithuanian
///  * `lv` - Latvian
///  * `mk` - Macedonian
///  * `ml` - Malayalam
///  * `mn` - Mongolian
///  * `mr` - Marathi
///  * `ms` - Malay
///  * `my` - Burmese
///  * `nb` - Norwegian Bokmål
///  * `ne` - Nepali
///  * `nl` - Dutch Flemish
///  * `or` - Oriya
///  * `pa` - Panjabi Punjabi
///  * `pl` - Polish
///  * `ps` - Pushto Pashto
///  * `pt` - Portuguese (plus one country variation)
///  * `ro` - Romanian Moldavian Moldovan
///  * `ru` - Russian
///  * `si` - Sinhala Sinhalese
///  * `sk` - Slovak
///  * `sl` - Slovenian
///  * `sq` - Albanian
///  * `sr` - Serbian (plus 2 scripts)
///  * `sv` - Swedish
///  * `sw` - Swahili
///  * `ta` - Tamil
///  * `te` - Telugu
///  * `th` - Thai
///  * `tl` - Tagalog
///  * `tr` - Turkish
///  * `uk` - Ukrainian
///  * `ur` - Urdu
///  * `uz` - Uzbek
///  * `vi` - Vietnamese
///  * `zh` - Chinese (plus 2 country variations and 2 scripts)
///  * `zu` - Zulu
/// {@endtemplate}
///
/// Generally speaking, this method is only intended to be used by
/// [GlobalMaterialLocalizations.delegate].
GlobalMaterialLocalizations getMaterialTranslation(
  Locale locale,
  intl.DateFormat fullYearFormat,
  intl.DateFormat mediumDateFormat,
  intl.DateFormat longDateFormat,
  intl.DateFormat yearMonthFormat,
  intl.NumberFormat decimalFormat,
  intl.NumberFormat twoDigitZeroPaddedFormat,
) {
  switch (locale.languageCode) {
    case 'af':
      return MaterialLocalizationAf(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'am':
      return MaterialLocalizationAm(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ar':
      return MaterialLocalizationAr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'as':
      return MaterialLocalizationAs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'az':
      return MaterialLocalizationAz(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'be':
      return MaterialLocalizationBe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'bg':
      return MaterialLocalizationBg(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'bn':
      return MaterialLocalizationBn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'bs':
      return MaterialLocalizationBs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ca':
      return MaterialLocalizationCa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'cs':
      return MaterialLocalizationCs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'da':
      return MaterialLocalizationDa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'de': {
      switch (locale.countryCode) {
        case 'CH':
          return MaterialLocalizationDeCh(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationDe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'el':
      return MaterialLocalizationEl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'en': {
      switch (locale.countryCode) {
        case 'AU':
          return MaterialLocalizationEnAu(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CA':
          return MaterialLocalizationEnCa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'GB':
          return MaterialLocalizationEnGb(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'IE':
          return MaterialLocalizationEnIe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'IN':
          return MaterialLocalizationEnIn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'SG':
          return MaterialLocalizationEnSg(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'ZA':
          return MaterialLocalizationEnZa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationEn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'es': {
      switch (locale.countryCode) {
        case '419':
          return MaterialLocalizationEs419(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'AR':
          return MaterialLocalizationEsAr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'BO':
          return MaterialLocalizationEsBo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CL':
          return MaterialLocalizationEsCl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CO':
          return MaterialLocalizationEsCo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CR':
          return MaterialLocalizationEsCr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'DO':
          return MaterialLocalizationEsDo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'EC':
          return MaterialLocalizationEsEc(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'GT':
          return MaterialLocalizationEsGt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'HN':
          return MaterialLocalizationEsHn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'MX':
          return MaterialLocalizationEsMx(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'NI':
          return MaterialLocalizationEsNi(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PA':
          return MaterialLocalizationEsPa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PE':
          return MaterialLocalizationEsPe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PR':
          return MaterialLocalizationEsPr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PY':
          return MaterialLocalizationEsPy(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'SV':
          return MaterialLocalizationEsSv(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'US':
          return MaterialLocalizationEsUs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'UY':
          return MaterialLocalizationEsUy(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'VE':
          return MaterialLocalizationEsVe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationEs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'et':
      return MaterialLocalizationEt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'eu':
      return MaterialLocalizationEu(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fa':
      return MaterialLocalizationFa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fi':
      return MaterialLocalizationFi(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fil':
      return MaterialLocalizationFil(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fr': {
      switch (locale.countryCode) {
        case 'CA':
          return MaterialLocalizationFrCa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationFr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'gl':
      return MaterialLocalizationGl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'gsw':
      return MaterialLocalizationGsw(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'gu':
      return MaterialLocalizationGu(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'he':
      return MaterialLocalizationHe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hi':
      return MaterialLocalizationHi(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hr':
      return MaterialLocalizationHr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hu':
      return MaterialLocalizationHu(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hy':
      return MaterialLocalizationHy(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'id':
      return MaterialLocalizationId(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'is':
      return MaterialLocalizationIs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'it':
      return MaterialLocalizationIt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ja':
      return MaterialLocalizationJa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ka':
      return MaterialLocalizationKa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'kk':
      return MaterialLocalizationKk(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'km':
      return MaterialLocalizationKm(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ko':
      return MaterialLocalizationKo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ky':
      return MaterialLocalizationKy(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'lo':
      return MaterialLocalizationLo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'lt':
      return MaterialLocalizationLt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'lv':
      return MaterialLocalizationLv(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'mk':
      return MaterialLocalizationMk(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ml':
      return MaterialLocalizationMl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'mn':
      return MaterialLocalizationMn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'mr':
      return MaterialLocalizationMr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ms':
      return MaterialLocalizationMs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'my':
      return MaterialLocalizationMy(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'nb':
      return MaterialLocalizationNb(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ne':
      return MaterialLocalizationNe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'nl':
      return MaterialLocalizationNl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'or':
      return MaterialLocalizationOr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'pa':
      return MaterialLocalizationPa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'pl':
      return MaterialLocalizationPl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ps':
      return MaterialLocalizationPs(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'pt': {
      switch (locale.countryCode) {
        case 'PT':
          return MaterialLocalizationPtPt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationPt(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'ro':
      return MaterialLocalizationRo(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ru':
      return MaterialLocalizationRu(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'si':
      return MaterialLocalizationSi(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sk':
      return MaterialLocalizationSk(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sl':
      return MaterialLocalizationSl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sq':
      return MaterialLocalizationSq(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sr': {
      switch (locale.scriptCode) {
        case 'Cyrl': {
          return MaterialLocalizationSrCyrl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        }
        case 'Latn': {
          return MaterialLocalizationSrLatn(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        }
      }
      return MaterialLocalizationSr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'sv':
      return MaterialLocalizationSv(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sw':
      return MaterialLocalizationSw(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ta':
      return MaterialLocalizationTa(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'te':
      return MaterialLocalizationTe(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'th':
      return MaterialLocalizationTh(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'tl':
      return MaterialLocalizationTl(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'tr':
      return MaterialLocalizationTr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'uk':
      return MaterialLocalizationUk(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ur':
      return MaterialLocalizationUr(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'uz':
      return MaterialLocalizationUz(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'vi':
      return MaterialLocalizationVi(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'zh': {
      switch (locale.scriptCode) {
        case 'Hans': {
          return MaterialLocalizationZhHans(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        }
        case 'Hant': {
          switch (locale.countryCode) {
            case 'HK':
              return MaterialLocalizationZhHantHk(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
            case 'TW':
              return MaterialLocalizationZhHantTw(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
          }
          return MaterialLocalizationZhHant(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        }
      }
      switch (locale.countryCode) {
        case 'HK':
          return MaterialLocalizationZhHantHk(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'TW':
          return MaterialLocalizationZhHantTw(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationZh(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'zu':
      return MaterialLocalizationZu(fullYearFormat: fullYearFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
  }
  assert(false, 'getMaterialTranslation() called for unsupported locale "$locale"');
  return null;
}
