// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';

void main() {
  testWidgets('ExpansionPanelList test', (WidgetTester tester) async {
    int index;
    bool isExpanded;

    await tester.pumpWidget(
      new SingleChildScrollView(
        child: new ExpansionPanelList(
          expansionCallback: (int _index, bool _isExpanded) {
            index = _index;
            isExpanded = _isExpanded;
          },
          children: <ExpansionPanel>[
            new ExpansionPanel(
              headerBuilder: (BuildContext context, bool isExpanded) {
                return new Text(isExpanded ? 'B' : 'A');
              },
              body: const SizedBox(height: 100.0)
            )
          ]
        )
      )
    );

    expect(find.text('A'), findsOneWidget);
    expect(find.text('B'), findsNothing);
    RenderBox box = tester.renderObject(find.byType(ExpansionPanelList));
    final double oldHeight = box.size.height;
    expect(find.byType(ExpandIcon), findsOneWidget);
    await tester.tap(find.byType(ExpandIcon));
    expect(index, 0);
    expect(isExpanded, isFalse);
    box = tester.renderObject(find.byType(ExpansionPanelList));
    expect(box.size.height, equals(oldHeight));

    // now expand the child panel
    await tester.pumpWidget(
      new SingleChildScrollView(
        child: new ExpansionPanelList(
          expansionCallback: (int _index, bool _isExpanded) {
            index = _index;
            isExpanded = _isExpanded;
          },
          children: <ExpansionPanel>[
            new ExpansionPanel(
              headerBuilder: (BuildContext context, bool isExpanded) {
                return new Text(isExpanded ? 'B' : 'A');
              },
              body: const SizedBox(height: 100.0),
              isExpanded: true // this is the addition
            )
          ]
        )
      )
    );

    await tester.pump(const Duration(milliseconds: 200));


    expect(find.text('A'), findsNothing);
    expect(find.text('B'), findsOneWidget);
    box = tester.renderObject(find.byType(ExpansionPanelList));
    expect(box.size.height - oldHeight, greaterThanOrEqualTo(100.0)); // 100 + some margin
  });
}
