// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

class IconData {
  const IconData(this.codePoint);
  final int codePoint;

  bool operator ==(dynamic other) {
    if (other is! IconData)
      return false;
    final IconData typedOther = other;
    return codePoint == typedOther.codePoint;
  }
  int get hashCode => codePoint.hashCode;
  String toString() => 'IconData(codePoint: $codePoint)';
}

class Icons {
  Icons._();

  static const IconData threed_rotation = const IconData(0xe84d); // 3d_rotation isn't a valid identifier.
  static const IconData ac_unit = const IconData(0xeb3b);
  static const IconData access_alarm = const IconData(0xe190);
  static const IconData access_alarms = const IconData(0xe191);
  static const IconData access_time = const IconData(0xe192);
  static const IconData accessibility = const IconData(0xe84e);
  static const IconData accessible = const IconData(0xe914);
  static const IconData account_balance = const IconData(0xe84f);
  static const IconData account_balance_wallet = const IconData(0xe850);
  static const IconData account_box = const IconData(0xe851);
  static const IconData account_circle = const IconData(0xe853);
  static const IconData adb = const IconData(0xe60e);
  static const IconData add = const IconData(0xe145);
  static const IconData add_a_photo = const IconData(0xe439);
  static const IconData add_alarm = const IconData(0xe193);
  static const IconData add_alert = const IconData(0xe003);
  static const IconData add_box = const IconData(0xe146);
  static const IconData add_circle = const IconData(0xe147);
  static const IconData add_circle_outline = const IconData(0xe148);
  static const IconData add_location = const IconData(0xe567);
  static const IconData add_shopping_cart = const IconData(0xe854);
  static const IconData add_to_photos = const IconData(0xe39d);
  static const IconData add_to_queue = const IconData(0xe05c);
  static const IconData adjust = const IconData(0xe39e);
  static const IconData airline_seat_flat = const IconData(0xe630);
  static const IconData airline_seat_flat_angled = const IconData(0xe631);
  static const IconData airline_seat_individual_suite = const IconData(0xe632);
  static const IconData airline_seat_legroom_extra = const IconData(0xe633);
  static const IconData airline_seat_legroom_normal = const IconData(0xe634);
  static const IconData airline_seat_legroom_reduced = const IconData(0xe635);
  static const IconData airline_seat_recline_extra = const IconData(0xe636);
  static const IconData airline_seat_recline_normal = const IconData(0xe637);
  static const IconData airplanemode_active = const IconData(0xe195);
  static const IconData airplanemode_inactive = const IconData(0xe194);
  static const IconData airplay = const IconData(0xe055);
  static const IconData airport_shuttle = const IconData(0xeb3c);
  static const IconData alarm = const IconData(0xe855);
  static const IconData alarm_add = const IconData(0xe856);
  static const IconData alarm_off = const IconData(0xe857);
  static const IconData alarm_on = const IconData(0xe858);
  static const IconData album = const IconData(0xe019);
  static const IconData all_inclusive = const IconData(0xeb3d);
  static const IconData all_out = const IconData(0xe90b);
  static const IconData android = const IconData(0xe859);
  static const IconData announcement = const IconData(0xe85a);
  static const IconData apps = const IconData(0xe5c3);
  static const IconData archive = const IconData(0xe149);
  static const IconData arrow_back = const IconData(0xe5c4);
  static const IconData arrow_downward = const IconData(0xe5db);
  static const IconData arrow_drop_down = const IconData(0xe5c5);
  static const IconData arrow_drop_down_circle = const IconData(0xe5c6);
  static const IconData arrow_drop_up = const IconData(0xe5c7);
  static const IconData arrow_forward = const IconData(0xe5c8);
  static const IconData arrow_upward = const IconData(0xe5d8);
  static const IconData art_track = const IconData(0xe060);
  static const IconData aspect_ratio = const IconData(0xe85b);
  static const IconData assessment = const IconData(0xe85c);
  static const IconData assignment = const IconData(0xe85d);
  static const IconData assignment_ind = const IconData(0xe85e);
  static const IconData assignment_late = const IconData(0xe85f);
  static const IconData assignment_return = const IconData(0xe860);
  static const IconData assignment_returned = const IconData(0xe861);
  static const IconData assignment_turned_in = const IconData(0xe862);
  static const IconData assistant = const IconData(0xe39f);
  static const IconData assistant_photo = const IconData(0xe3a0);
  static const IconData attach_file = const IconData(0xe226);
  static const IconData attach_money = const IconData(0xe227);
  static const IconData attachment = const IconData(0xe2bc);
  static const IconData audiotrack = const IconData(0xe3a1);
  static const IconData autoreconst = const IconData(0xe863);
  static const IconData av_timer = const IconData(0xe01b);
  static const IconData backspace = const IconData(0xe14a);
  static const IconData backup = const IconData(0xe864);
  static const IconData battery_alert = const IconData(0xe19c);
  static const IconData battery_charging_full = const IconData(0xe1a3);
  static const IconData battery_full = const IconData(0xe1a4);
  static const IconData battery_std = const IconData(0xe1a5);
  static const IconData battery_unknown = const IconData(0xe1a6);
  static const IconData beach_access = const IconData(0xeb3e);
  static const IconData beenhere = const IconData(0xe52d);
  static const IconData block = const IconData(0xe14b);
  static const IconData bluetooth = const IconData(0xe1a7);
  static const IconData bluetooth_audio = const IconData(0xe60f);
  static const IconData bluetooth_connected = const IconData(0xe1a8);
  static const IconData bluetooth_disabled = const IconData(0xe1a9);
  static const IconData bluetooth_searching = const IconData(0xe1aa);
  static const IconData blur_circular = const IconData(0xe3a2);
  static const IconData blur_linear = const IconData(0xe3a3);
  static const IconData blur_off = const IconData(0xe3a4);
  static const IconData blur_on = const IconData(0xe3a5);
  static const IconData book = const IconData(0xe865);
  static const IconData bookmark = const IconData(0xe866);
  static const IconData bookmark_border = const IconData(0xe867);
  static const IconData border_all = const IconData(0xe228);
  static const IconData border_bottom = const IconData(0xe229);
  static const IconData border_clear = const IconData(0xe22a);
  static const IconData border_color = const IconData(0xe22b);
  static const IconData border_horizontal = const IconData(0xe22c);
  static const IconData border_inner = const IconData(0xe22d);
  static const IconData border_left = const IconData(0xe22e);
  static const IconData border_outer = const IconData(0xe22f);
  static const IconData border_right = const IconData(0xe230);
  static const IconData border_style = const IconData(0xe231);
  static const IconData border_top = const IconData(0xe232);
  static const IconData border_vertical = const IconData(0xe233);
  static const IconData branding_watermark = const IconData(0xe06b);
  static const IconData brightness_1 = const IconData(0xe3a6);
  static const IconData brightness_2 = const IconData(0xe3a7);
  static const IconData brightness_3 = const IconData(0xe3a8);
  static const IconData brightness_4 = const IconData(0xe3a9);
  static const IconData brightness_5 = const IconData(0xe3aa);
  static const IconData brightness_6 = const IconData(0xe3ab);
  static const IconData brightness_7 = const IconData(0xe3ac);
  static const IconData brightness_auto = const IconData(0xe1ab);
  static const IconData brightness_high = const IconData(0xe1ac);
  static const IconData brightness_low = const IconData(0xe1ad);
  static const IconData brightness_medium = const IconData(0xe1ae);
  static const IconData broken_image = const IconData(0xe3ad);
  static const IconData brush = const IconData(0xe3ae);
  static const IconData bubble_chart = const IconData(0xe6dd);
  static const IconData bug_report = const IconData(0xe868);
  static const IconData build = const IconData(0xe869);
  static const IconData burst_mode = const IconData(0xe43c);
  static const IconData business = const IconData(0xe0af);
  static const IconData business_center = const IconData(0xeb3f);
  static const IconData cached = const IconData(0xe86a);
  static const IconData cake = const IconData(0xe7e9);
  static const IconData call = const IconData(0xe0b0);
  static const IconData call_end = const IconData(0xe0b1);
  static const IconData call_made = const IconData(0xe0b2);
  static const IconData call_merge = const IconData(0xe0b3);
  static const IconData call_missed = const IconData(0xe0b4);
  static const IconData call_missed_outgoing = const IconData(0xe0e4);
  static const IconData call_received = const IconData(0xe0b5);
  static const IconData call_split = const IconData(0xe0b6);
  static const IconData call_to_action = const IconData(0xe06c);
  static const IconData camera = const IconData(0xe3af);
  static const IconData camera_alt = const IconData(0xe3b0);
  static const IconData camera_enhance = const IconData(0xe8fc);
  static const IconData camera_front = const IconData(0xe3b1);
  static const IconData camera_rear = const IconData(0xe3b2);
  static const IconData camera_roll = const IconData(0xe3b3);
  static const IconData cancel = const IconData(0xe5c9);
  static const IconData card_giftcard = const IconData(0xe8f6);
  static const IconData card_membership = const IconData(0xe8f7);
  static const IconData card_travel = const IconData(0xe8f8);
  static const IconData casino = const IconData(0xeb40);
  static const IconData cast = const IconData(0xe307);
  static const IconData cast_connected = const IconData(0xe308);
  static const IconData center_focus_strong = const IconData(0xe3b4);
  static const IconData center_focus_weak = const IconData(0xe3b5);
  static const IconData change_history = const IconData(0xe86b);
  static const IconData chat = const IconData(0xe0b7);
  static const IconData chat_bubble = const IconData(0xe0ca);
  static const IconData chat_bubble_outline = const IconData(0xe0cb);
  static const IconData check = const IconData(0xe5ca);
  static const IconData check_box = const IconData(0xe834);
  static const IconData check_box_outline_blank = const IconData(0xe835);
  static const IconData check_circle = const IconData(0xe86c);
  static const IconData chevron_left = const IconData(0xe5cb);
  static const IconData chevron_right = const IconData(0xe5cc);
  static const IconData child_care = const IconData(0xeb41);
  static const IconData child_friendly = const IconData(0xeb42);
  static const IconData chrome_reader_mode = const IconData(0xe86d);
  static const IconData class_ = const IconData(0xe86e); // class is a reserved word in Dart.
  static const IconData clear = const IconData(0xe14c);
  static const IconData clear_all = const IconData(0xe0b8);
  static const IconData close = const IconData(0xe5cd);
  static const IconData closed_caption = const IconData(0xe01c);
  static const IconData cloud = const IconData(0xe2bd);
  static const IconData cloud_circle = const IconData(0xe2be);
  static const IconData cloud_done = const IconData(0xe2bf);
  static const IconData cloud_download = const IconData(0xe2c0);
  static const IconData cloud_off = const IconData(0xe2c1);
  static const IconData cloud_queue = const IconData(0xe2c2);
  static const IconData cloud_upload = const IconData(0xe2c3);
  static const IconData code = const IconData(0xe86f);
  static const IconData collections = const IconData(0xe3b6);
  static const IconData collections_bookmark = const IconData(0xe431);
  static const IconData color_lens = const IconData(0xe3b7);
  static const IconData colorize = const IconData(0xe3b8);
  static const IconData comment = const IconData(0xe0b9);
  static const IconData compare = const IconData(0xe3b9);
  static const IconData compare_arrows = const IconData(0xe915);
  static const IconData computer = const IconData(0xe30a);
  static const IconData confirmation_number = const IconData(0xe638);
  static const IconData contact_mail = const IconData(0xe0d0);
  static const IconData contact_phone = const IconData(0xe0cf);
  static const IconData contacts = const IconData(0xe0ba);
  static const IconData content_copy = const IconData(0xe14d);
  static const IconData content_cut = const IconData(0xe14e);
  static const IconData content_paste = const IconData(0xe14f);
  static const IconData control_point = const IconData(0xe3ba);
  static const IconData control_point_duplicate = const IconData(0xe3bb);
  static const IconData copyright = const IconData(0xe90c);
  static const IconData create = const IconData(0xe150);
  static const IconData create_const_folder = const IconData(0xe2cc);
  static const IconData credit_card = const IconData(0xe870);
  static const IconData crop = const IconData(0xe3be);
  static const IconData crop_16_9 = const IconData(0xe3bc);
  static const IconData crop_3_2 = const IconData(0xe3bd);
  static const IconData crop_5_4 = const IconData(0xe3bf);
  static const IconData crop_7_5 = const IconData(0xe3c0);
  static const IconData crop_din = const IconData(0xe3c1);
  static const IconData crop_free = const IconData(0xe3c2);
  static const IconData crop_landscape = const IconData(0xe3c3);
  static const IconData crop_original = const IconData(0xe3c4);
  static const IconData crop_portrait = const IconData(0xe3c5);
  static const IconData crop_rotate = const IconData(0xe437);
  static const IconData crop_square = const IconData(0xe3c6);
  static const IconData dashboard = const IconData(0xe871);
  static const IconData data_usage = const IconData(0xe1af);
  static const IconData date_range = const IconData(0xe916);
  static const IconData dehaze = const IconData(0xe3c7);
  static const IconData delete = const IconData(0xe872);
  static const IconData delete_forever = const IconData(0xe92b);
  static const IconData delete_sweep = const IconData(0xe16c);
  static const IconData description = const IconData(0xe873);
  static const IconData desktop_mac = const IconData(0xe30b);
  static const IconData desktop_windows = const IconData(0xe30c);
  static const IconData details = const IconData(0xe3c8);
  static const IconData developer_board = const IconData(0xe30d);
  static const IconData developer_mode = const IconData(0xe1b0);
  static const IconData device_hub = const IconData(0xe335);
  static const IconData devices = const IconData(0xe1b1);
  static const IconData devices_other = const IconData(0xe337);
  static const IconData dialer_sip = const IconData(0xe0bb);
  static const IconData dialpad = const IconData(0xe0bc);
  static const IconData directions = const IconData(0xe52e);
  static const IconData directions_bike = const IconData(0xe52f);
  static const IconData directions_boat = const IconData(0xe532);
  static const IconData directions_bus = const IconData(0xe530);
  static const IconData directions_car = const IconData(0xe531);
  static const IconData directions_railway = const IconData(0xe534);
  static const IconData directions_run = const IconData(0xe566);
  static const IconData directions_subway = const IconData(0xe533);
  static const IconData directions_transit = const IconData(0xe535);
  static const IconData directions_walk = const IconData(0xe536);
  static const IconData disc_full = const IconData(0xe610);
  static const IconData dns = const IconData(0xe875);
  static const IconData do_not_disturb = const IconData(0xe612);
  static const IconData do_not_disturb_alt = const IconData(0xe611);
  static const IconData do_not_disturb_off = const IconData(0xe643);
  static const IconData do_not_disturb_on = const IconData(0xe644);
  static const IconData dock = const IconData(0xe30e);
  static const IconData domain = const IconData(0xe7ee);
  static const IconData done = const IconData(0xe876);
  static const IconData done_all = const IconData(0xe877);
  static const IconData donut_large = const IconData(0xe917);
  static const IconData donut_small = const IconData(0xe918);
  static const IconData drafts = const IconData(0xe151);
  static const IconData drag_handle = const IconData(0xe25d);
  static const IconData drive_eta = const IconData(0xe613);
  static const IconData dvr = const IconData(0xe1b2);
  static const IconData edit = const IconData(0xe3c9);
  static const IconData edit_location = const IconData(0xe568);
  static const IconData eject = const IconData(0xe8fb);
  static const IconData email = const IconData(0xe0be);
  static const IconData enhanced_encryption = const IconData(0xe63f);
  static const IconData equalizer = const IconData(0xe01d);
  static const IconData error = const IconData(0xe000);
  static const IconData error_outline = const IconData(0xe001);
  static const IconData euro_symbol = const IconData(0xe926);
  static const IconData ev_station = const IconData(0xe56d);
  static const IconData event = const IconData(0xe878);
  static const IconData event_available = const IconData(0xe614);
  static const IconData event_busy = const IconData(0xe615);
  static const IconData event_note = const IconData(0xe616);
  static const IconData event_seat = const IconData(0xe903);
  static const IconData exit_to_app = const IconData(0xe879);
  static const IconData expand_less = const IconData(0xe5ce);
  static const IconData expand_more = const IconData(0xe5cf);
  static const IconData explicit = const IconData(0xe01e);
  static const IconData explore = const IconData(0xe87a);
  static const IconData exposure = const IconData(0xe3ca);
  static const IconData exposure_neg_1 = const IconData(0xe3cb);
  static const IconData exposure_neg_2 = const IconData(0xe3cc);
  static const IconData exposure_plus_1 = const IconData(0xe3cd);
  static const IconData exposure_plus_2 = const IconData(0xe3ce);
  static const IconData exposure_zero = const IconData(0xe3cf);
  static const IconData extension = const IconData(0xe87b);
  static const IconData face = const IconData(0xe87c);
  static const IconData fast_forward = const IconData(0xe01f);
  static const IconData fast_rewind = const IconData(0xe020);
  static const IconData favorite = const IconData(0xe87d);
  static const IconData favorite_border = const IconData(0xe87e);
  static const IconData featured_play_list = const IconData(0xe06d);
  static const IconData featured_video = const IconData(0xe06e);
  static const IconData feedback = const IconData(0xe87f);
  static const IconData fiber_dvr = const IconData(0xe05d);
  static const IconData fiber_manual_record = const IconData(0xe061);
  static const IconData fiber_const = const IconData(0xe05e);
  static const IconData fiber_pin = const IconData(0xe06a);
  static const IconData fiber_smart_record = const IconData(0xe062);
  static const IconData file_download = const IconData(0xe2c4);
  static const IconData file_upload = const IconData(0xe2c6);
  static const IconData filter = const IconData(0xe3d3);
  static const IconData filter_1 = const IconData(0xe3d0);
  static const IconData filter_2 = const IconData(0xe3d1);
  static const IconData filter_3 = const IconData(0xe3d2);
  static const IconData filter_4 = const IconData(0xe3d4);
  static const IconData filter_5 = const IconData(0xe3d5);
  static const IconData filter_6 = const IconData(0xe3d6);
  static const IconData filter_7 = const IconData(0xe3d7);
  static const IconData filter_8 = const IconData(0xe3d8);
  static const IconData filter_9 = const IconData(0xe3d9);
  static const IconData filter_9_plus = const IconData(0xe3da);
  static const IconData filter_b_and_w = const IconData(0xe3db);
  static const IconData filter_center_focus = const IconData(0xe3dc);
  static const IconData filter_drama = const IconData(0xe3dd);
  static const IconData filter_frames = const IconData(0xe3de);
  static const IconData filter_hdr = const IconData(0xe3df);
  static const IconData filter_list = const IconData(0xe152);
  static const IconData filter_none = const IconData(0xe3e0);
  static const IconData filter_tilt_shift = const IconData(0xe3e2);
  static const IconData filter_vintage = const IconData(0xe3e3);
  static const IconData find_in_page = const IconData(0xe880);
  static const IconData find_replace = const IconData(0xe881);
  static const IconData fingerprint = const IconData(0xe90d);
  static const IconData first_page = const IconData(0xe5dc);
  static const IconData fitness_center = const IconData(0xeb43);
  static const IconData flag = const IconData(0xe153);
  static const IconData flare = const IconData(0xe3e4);
  static const IconData flash_auto = const IconData(0xe3e5);
  static const IconData flash_off = const IconData(0xe3e6);
  static const IconData flash_on = const IconData(0xe3e7);
  static const IconData flight = const IconData(0xe539);
  static const IconData flight_land = const IconData(0xe904);
  static const IconData flight_takeoff = const IconData(0xe905);
  static const IconData flip = const IconData(0xe3e8);
  static const IconData flip_to_back = const IconData(0xe882);
  static const IconData flip_to_front = const IconData(0xe883);
  static const IconData folder = const IconData(0xe2c7);
  static const IconData folder_open = const IconData(0xe2c8);
  static const IconData folder_shared = const IconData(0xe2c9);
  static const IconData folder_special = const IconData(0xe617);
  static const IconData font_download = const IconData(0xe167);
  static const IconData format_align_center = const IconData(0xe234);
  static const IconData format_align_justify = const IconData(0xe235);
  static const IconData format_align_left = const IconData(0xe236);
  static const IconData format_align_right = const IconData(0xe237);
  static const IconData format_bold = const IconData(0xe238);
  static const IconData format_clear = const IconData(0xe239);
  static const IconData format_color_fill = const IconData(0xe23a);
  static const IconData format_color_reset = const IconData(0xe23b);
  static const IconData format_color_text = const IconData(0xe23c);
  static const IconData format_indent_decrease = const IconData(0xe23d);
  static const IconData format_indent_increase = const IconData(0xe23e);
  static const IconData format_italic = const IconData(0xe23f);
  static const IconData format_line_spacing = const IconData(0xe240);
  static const IconData format_list_bulleted = const IconData(0xe241);
  static const IconData format_list_numbered = const IconData(0xe242);
  static const IconData format_paint = const IconData(0xe243);
  static const IconData format_quote = const IconData(0xe244);
  static const IconData format_shapes = const IconData(0xe25e);
  static const IconData format_size = const IconData(0xe245);
  static const IconData format_strikethrough = const IconData(0xe246);
  static const IconData format_textdirection_l_to_r = const IconData(0xe247);
  static const IconData format_textdirection_r_to_l = const IconData(0xe248);
  static const IconData format_underlined = const IconData(0xe249);
  static const IconData forum = const IconData(0xe0bf);
  static const IconData forward = const IconData(0xe154);
  static const IconData forward_10 = const IconData(0xe056);
  static const IconData forward_30 = const IconData(0xe057);
  static const IconData forward_5 = const IconData(0xe058);
  static const IconData free_breakfast = const IconData(0xeb44);
  static const IconData fullscreen = const IconData(0xe5d0);
  static const IconData fullscreen_exit = const IconData(0xe5d1);
  static const IconData functions = const IconData(0xe24a);
  static const IconData g_translate = const IconData(0xe927);
  static const IconData gamepad = const IconData(0xe30f);
  static const IconData games = const IconData(0xe021);
  static const IconData gavel = const IconData(0xe90e);
  static const IconData gesture = const IconData(0xe155);
  static const IconData get_app = const IconData(0xe884);
  static const IconData gif = const IconData(0xe908);
  static const IconData golf_course = const IconData(0xeb45);
  static const IconData gps_fixed = const IconData(0xe1b3);
  static const IconData gps_not_fixed = const IconData(0xe1b4);
  static const IconData gps_off = const IconData(0xe1b5);
  static const IconData grade = const IconData(0xe885);
  static const IconData gradient = const IconData(0xe3e9);
  static const IconData grain = const IconData(0xe3ea);
  static const IconData graphic_eq = const IconData(0xe1b8);
  static const IconData grid_off = const IconData(0xe3eb);
  static const IconData grid_on = const IconData(0xe3ec);
  static const IconData group = const IconData(0xe7ef);
  static const IconData group_add = const IconData(0xe7f0);
  static const IconData group_work = const IconData(0xe886);
  static const IconData hd = const IconData(0xe052);
  static const IconData hdr_off = const IconData(0xe3ed);
  static const IconData hdr_on = const IconData(0xe3ee);
  static const IconData hdr_strong = const IconData(0xe3f1);
  static const IconData hdr_weak = const IconData(0xe3f2);
  static const IconData headset = const IconData(0xe310);
  static const IconData headset_mic = const IconData(0xe311);
  static const IconData healing = const IconData(0xe3f3);
  static const IconData hearing = const IconData(0xe023);
  static const IconData help = const IconData(0xe887);
  static const IconData help_outline = const IconData(0xe8fd);
  static const IconData high_quality = const IconData(0xe024);
  static const IconData highlight = const IconData(0xe25f);
  static const IconData highlight_off = const IconData(0xe888);
  static const IconData history = const IconData(0xe889);
  static const IconData home = const IconData(0xe88a);
  static const IconData hot_tub = const IconData(0xeb46);
  static const IconData hotel = const IconData(0xe53a);
  static const IconData hourglass_empty = const IconData(0xe88b);
  static const IconData hourglass_full = const IconData(0xe88c);
  static const IconData http = const IconData(0xe902);
  static const IconData https = const IconData(0xe88d);
  static const IconData image = const IconData(0xe3f4);
  static const IconData image_aspect_ratio = const IconData(0xe3f5);
  static const IconData import_contacts = const IconData(0xe0e0);
  static const IconData import_export = const IconData(0xe0c3);
  static const IconData important_devices = const IconData(0xe912);
  static const IconData inbox = const IconData(0xe156);
  static const IconData indeterminate_check_box = const IconData(0xe909);
  static const IconData info = const IconData(0xe88e);
  static const IconData info_outline = const IconData(0xe88f);
  static const IconData input = const IconData(0xe890);
  static const IconData insert_chart = const IconData(0xe24b);
  static const IconData insert_comment = const IconData(0xe24c);
  static const IconData insert_drive_file = const IconData(0xe24d);
  static const IconData insert_emoticon = const IconData(0xe24e);
  static const IconData insert_invitation = const IconData(0xe24f);
  static const IconData insert_link = const IconData(0xe250);
  static const IconData insert_photo = const IconData(0xe251);
  static const IconData invert_colors = const IconData(0xe891);
  static const IconData invert_colors_off = const IconData(0xe0c4);
  static const IconData iso = const IconData(0xe3f6);
  static const IconData keyboard = const IconData(0xe312);
  static const IconData keyboard_arrow_down = const IconData(0xe313);
  static const IconData keyboard_arrow_left = const IconData(0xe314);
  static const IconData keyboard_arrow_right = const IconData(0xe315);
  static const IconData keyboard_arrow_up = const IconData(0xe316);
  static const IconData keyboard_backspace = const IconData(0xe317);
  static const IconData keyboard_capslock = const IconData(0xe318);
  static const IconData keyboard_hide = const IconData(0xe31a);
  static const IconData keyboard_return = const IconData(0xe31b);
  static const IconData keyboard_tab = const IconData(0xe31c);
  static const IconData keyboard_voice = const IconData(0xe31d);
  static const IconData kitchen = const IconData(0xeb47);
  static const IconData label = const IconData(0xe892);
  static const IconData label_outline = const IconData(0xe893);
  static const IconData landscape = const IconData(0xe3f7);
  static const IconData language = const IconData(0xe894);
  static const IconData laptop = const IconData(0xe31e);
  static const IconData laptop_chromebook = const IconData(0xe31f);
  static const IconData laptop_mac = const IconData(0xe320);
  static const IconData laptop_windows = const IconData(0xe321);
  static const IconData last_page = const IconData(0xe5dd);
  static const IconData launch = const IconData(0xe895);
  static const IconData layers = const IconData(0xe53b);
  static const IconData layers_clear = const IconData(0xe53c);
  static const IconData leak_add = const IconData(0xe3f8);
  static const IconData leak_remove = const IconData(0xe3f9);
  static const IconData lens = const IconData(0xe3fa);
  static const IconData library_add = const IconData(0xe02e);
  static const IconData library_books = const IconData(0xe02f);
  static const IconData library_music = const IconData(0xe030);
  static const IconData lightbulb_outline = const IconData(0xe90f);
  static const IconData line_style = const IconData(0xe919);
  static const IconData line_weight = const IconData(0xe91a);
  static const IconData linear_scale = const IconData(0xe260);
  static const IconData link = const IconData(0xe157);
  static const IconData linked_camera = const IconData(0xe438);
  static const IconData list = const IconData(0xe896);
  static const IconData live_help = const IconData(0xe0c6);
  static const IconData live_tv = const IconData(0xe639);
  static const IconData local_activity = const IconData(0xe53f);
  static const IconData local_airport = const IconData(0xe53d);
  static const IconData local_atm = const IconData(0xe53e);
  static const IconData local_bar = const IconData(0xe540);
  static const IconData local_cafe = const IconData(0xe541);
  static const IconData local_car_wash = const IconData(0xe542);
  static const IconData local_convenience_store = const IconData(0xe543);
  static const IconData local_dining = const IconData(0xe556);
  static const IconData local_drink = const IconData(0xe544);
  static const IconData local_florist = const IconData(0xe545);
  static const IconData local_gas_station = const IconData(0xe546);
  static const IconData local_grocery_store = const IconData(0xe547);
  static const IconData local_hospital = const IconData(0xe548);
  static const IconData local_hotel = const IconData(0xe549);
  static const IconData local_laundry_service = const IconData(0xe54a);
  static const IconData local_library = const IconData(0xe54b);
  static const IconData local_mall = const IconData(0xe54c);
  static const IconData local_movies = const IconData(0xe54d);
  static const IconData local_offer = const IconData(0xe54e);
  static const IconData local_parking = const IconData(0xe54f);
  static const IconData local_pharmacy = const IconData(0xe550);
  static const IconData local_phone = const IconData(0xe551);
  static const IconData local_pizza = const IconData(0xe552);
  static const IconData local_play = const IconData(0xe553);
  static const IconData local_post_office = const IconData(0xe554);
  static const IconData local_printshop = const IconData(0xe555);
  static const IconData local_see = const IconData(0xe557);
  static const IconData local_shipping = const IconData(0xe558);
  static const IconData local_taxi = const IconData(0xe559);
  static const IconData location_city = const IconData(0xe7f1);
  static const IconData location_disabled = const IconData(0xe1b6);
  static const IconData location_off = const IconData(0xe0c7);
  static const IconData location_on = const IconData(0xe0c8);
  static const IconData location_searching = const IconData(0xe1b7);
  static const IconData lock = const IconData(0xe897);
  static const IconData lock_open = const IconData(0xe898);
  static const IconData lock_outline = const IconData(0xe899);
  static const IconData looks = const IconData(0xe3fc);
  static const IconData looks_3 = const IconData(0xe3fb);
  static const IconData looks_4 = const IconData(0xe3fd);
  static const IconData looks_5 = const IconData(0xe3fe);
  static const IconData looks_6 = const IconData(0xe3ff);
  static const IconData looks_one = const IconData(0xe400);
  static const IconData looks_two = const IconData(0xe401);
  static const IconData loop = const IconData(0xe028);
  static const IconData loupe = const IconData(0xe402);
  static const IconData low_priority = const IconData(0xe16d);
  static const IconData loyalty = const IconData(0xe89a);
  static const IconData mail = const IconData(0xe158);
  static const IconData mail_outline = const IconData(0xe0e1);
  static const IconData map = const IconData(0xe55b);
  static const IconData markunread = const IconData(0xe159);
  static const IconData markunread_mailbox = const IconData(0xe89b);
  static const IconData memory = const IconData(0xe322);
  static const IconData menu = const IconData(0xe5d2);
  static const IconData merge_type = const IconData(0xe252);
  static const IconData message = const IconData(0xe0c9);
  static const IconData mic = const IconData(0xe029);
  static const IconData mic_none = const IconData(0xe02a);
  static const IconData mic_off = const IconData(0xe02b);
  static const IconData mms = const IconData(0xe618);
  static const IconData mode_comment = const IconData(0xe253);
  static const IconData mode_edit = const IconData(0xe254);
  static const IconData monetization_on = const IconData(0xe263);
  static const IconData money_off = const IconData(0xe25c);
  static const IconData monochrome_photos = const IconData(0xe403);
  static const IconData mood = const IconData(0xe7f2);
  static const IconData mood_bad = const IconData(0xe7f3);
  static const IconData more = const IconData(0xe619);
  static const IconData more_horiz = const IconData(0xe5d3);
  static const IconData more_vert = const IconData(0xe5d4);
  static const IconData motorcycle = const IconData(0xe91b);
  static const IconData mouse = const IconData(0xe323);
  static const IconData move_to_inbox = const IconData(0xe168);
  static const IconData movie = const IconData(0xe02c);
  static const IconData movie_creation = const IconData(0xe404);
  static const IconData movie_filter = const IconData(0xe43a);
  static const IconData multiline_chart = const IconData(0xe6df);
  static const IconData music_note = const IconData(0xe405);
  static const IconData music_video = const IconData(0xe063);
  static const IconData my_location = const IconData(0xe55c);
  static const IconData nature = const IconData(0xe406);
  static const IconData nature_people = const IconData(0xe407);
  static const IconData navigate_before = const IconData(0xe408);
  static const IconData navigate_next = const IconData(0xe409);
  static const IconData navigation = const IconData(0xe55d);
  static const IconData near_me = const IconData(0xe569);
  static const IconData network_cell = const IconData(0xe1b9);
  static const IconData network_check = const IconData(0xe640);
  static const IconData network_locked = const IconData(0xe61a);
  static const IconData network_wifi = const IconData(0xe1ba);
  static const IconData const_releases = const IconData(0xe031);
  static const IconData next_week = const IconData(0xe16a);
  static const IconData nfc = const IconData(0xe1bb);
  static const IconData no_encryption = const IconData(0xe641);
  static const IconData no_sim = const IconData(0xe0cc);
  static const IconData not_interested = const IconData(0xe033);
  static const IconData note = const IconData(0xe06f);
  static const IconData note_add = const IconData(0xe89c);
  static const IconData notifications = const IconData(0xe7f4);
  static const IconData notifications_active = const IconData(0xe7f7);
  static const IconData notifications_none = const IconData(0xe7f5);
  static const IconData notifications_off = const IconData(0xe7f6);
  static const IconData notifications_paused = const IconData(0xe7f8);
  static const IconData offline_pin = const IconData(0xe90a);
  static const IconData ondemand_video = const IconData(0xe63a);
  static const IconData opacity = const IconData(0xe91c);
  static const IconData open_in_browser = const IconData(0xe89d);
  static const IconData open_in_const = const IconData(0xe89e);
  static const IconData open_with = const IconData(0xe89f);
  static const IconData pages = const IconData(0xe7f9);
  static const IconData pageview = const IconData(0xe8a0);
  static const IconData palette = const IconData(0xe40a);
  static const IconData pan_tool = const IconData(0xe925);
  static const IconData panorama = const IconData(0xe40b);
  static const IconData panorama_fish_eye = const IconData(0xe40c);
  static const IconData panorama_horizontal = const IconData(0xe40d);
  static const IconData panorama_vertical = const IconData(0xe40e);
  static const IconData panorama_wide_angle = const IconData(0xe40f);
  static const IconData party_mode = const IconData(0xe7fa);
  static const IconData pause = const IconData(0xe034);
  static const IconData pause_circle_filled = const IconData(0xe035);
  static const IconData pause_circle_outline = const IconData(0xe036);
  static const IconData payment = const IconData(0xe8a1);
  static const IconData people = const IconData(0xe7fb);
  static const IconData people_outline = const IconData(0xe7fc);
  static const IconData perm_camera_mic = const IconData(0xe8a2);
  static const IconData perm_contact_calendar = const IconData(0xe8a3);
  static const IconData perm_data_setting = const IconData(0xe8a4);
  static const IconData perm_device_information = const IconData(0xe8a5);
  static const IconData perm_identity = const IconData(0xe8a6);
  static const IconData perm_media = const IconData(0xe8a7);
  static const IconData perm_phone_msg = const IconData(0xe8a8);
  static const IconData perm_scan_wifi = const IconData(0xe8a9);
  static const IconData person = const IconData(0xe7fd);
  static const IconData person_add = const IconData(0xe7fe);
  static const IconData person_outline = const IconData(0xe7ff);
  static const IconData person_pin = const IconData(0xe55a);
  static const IconData person_pin_circle = const IconData(0xe56a);
  static const IconData personal_video = const IconData(0xe63b);
  static const IconData pets = const IconData(0xe91d);
  static const IconData phone = const IconData(0xe0cd);
  static const IconData phone_android = const IconData(0xe324);
  static const IconData phone_bluetooth_speaker = const IconData(0xe61b);
  static const IconData phone_forwarded = const IconData(0xe61c);
  static const IconData phone_in_talk = const IconData(0xe61d);
  static const IconData phone_iphone = const IconData(0xe325);
  static const IconData phone_locked = const IconData(0xe61e);
  static const IconData phone_missed = const IconData(0xe61f);
  static const IconData phone_paused = const IconData(0xe620);
  static const IconData phonelink = const IconData(0xe326);
  static const IconData phonelink_erase = const IconData(0xe0db);
  static const IconData phonelink_lock = const IconData(0xe0dc);
  static const IconData phonelink_off = const IconData(0xe327);
  static const IconData phonelink_ring = const IconData(0xe0dd);
  static const IconData phonelink_setup = const IconData(0xe0de);
  static const IconData photo = const IconData(0xe410);
  static const IconData photo_album = const IconData(0xe411);
  static const IconData photo_camera = const IconData(0xe412);
  static const IconData photo_filter = const IconData(0xe43b);
  static const IconData photo_library = const IconData(0xe413);
  static const IconData photo_size_select_actual = const IconData(0xe432);
  static const IconData photo_size_select_large = const IconData(0xe433);
  static const IconData photo_size_select_small = const IconData(0xe434);
  static const IconData picture_as_pdf = const IconData(0xe415);
  static const IconData picture_in_picture = const IconData(0xe8aa);
  static const IconData picture_in_picture_alt = const IconData(0xe911);
  static const IconData pie_chart = const IconData(0xe6c4);
  static const IconData pie_chart_outlined = const IconData(0xe6c5);
  static const IconData pin_drop = const IconData(0xe55e);
  static const IconData place = const IconData(0xe55f);
  static const IconData play_arrow = const IconData(0xe037);
  static const IconData play_circle_filled = const IconData(0xe038);
  static const IconData play_circle_outline = const IconData(0xe039);
  static const IconData play_for_work = const IconData(0xe906);
  static const IconData playlist_add = const IconData(0xe03b);
  static const IconData playlist_add_check = const IconData(0xe065);
  static const IconData playlist_play = const IconData(0xe05f);
  static const IconData plus_one = const IconData(0xe800);
  static const IconData poll = const IconData(0xe801);
  static const IconData polymer = const IconData(0xe8ab);
  static const IconData pool = const IconData(0xeb48);
  static const IconData portable_wifi_off = const IconData(0xe0ce);
  static const IconData portrait = const IconData(0xe416);
  static const IconData power = const IconData(0xe63c);
  static const IconData power_input = const IconData(0xe336);
  static const IconData power_settings_const = const IconData(0xe8ac);
  static const IconData pregnant_woman = const IconData(0xe91e);
  static const IconData present_to_all = const IconData(0xe0df);
  static const IconData print = const IconData(0xe8ad);
  static const IconData priority_high = const IconData(0xe645);
  static const IconData public = const IconData(0xe80b);
  static const IconData publish = const IconData(0xe255);
  static const IconData query_builder = const IconData(0xe8ae);
  static const IconData question_answer = const IconData(0xe8af);
  static const IconData queue = const IconData(0xe03c);
  static const IconData queue_music = const IconData(0xe03d);
  static const IconData queue_play_next = const IconData(0xe066);
  static const IconData radio = const IconData(0xe03e);
  static const IconData radio_button_checked = const IconData(0xe837);
  static const IconData radio_button_unchecked = const IconData(0xe836);
  static const IconData rate_review = const IconData(0xe560);
  static const IconData receipt = const IconData(0xe8b0);
  static const IconData recent_actors = const IconData(0xe03f);
  static const IconData record_voice_over = const IconData(0xe91f);
  static const IconData redeem = const IconData(0xe8b1);
  static const IconData redo = const IconData(0xe15a);
  static const IconData refresh = const IconData(0xe5d5);
  static const IconData remove = const IconData(0xe15b);
  static const IconData remove_circle = const IconData(0xe15c);
  static const IconData remove_circle_outline = const IconData(0xe15d);
  static const IconData remove_from_queue = const IconData(0xe067);
  static const IconData remove_red_eye = const IconData(0xe417);
  static const IconData remove_shopping_cart = const IconData(0xe928);
  static const IconData reorder = const IconData(0xe8fe);
  static const IconData repeat = const IconData(0xe040);
  static const IconData repeat_one = const IconData(0xe041);
  static const IconData replay = const IconData(0xe042);
  static const IconData replay_10 = const IconData(0xe059);
  static const IconData replay_30 = const IconData(0xe05a);
  static const IconData replay_5 = const IconData(0xe05b);
  static const IconData reply = const IconData(0xe15e);
  static const IconData reply_all = const IconData(0xe15f);
  static const IconData report = const IconData(0xe160);
  static const IconData report_problem = const IconData(0xe8b2);
  static const IconData restaurant = const IconData(0xe56c);
  static const IconData restaurant_menu = const IconData(0xe561);
  static const IconData restore = const IconData(0xe8b3);
  static const IconData restore_page = const IconData(0xe929);
  static const IconData ring_volume = const IconData(0xe0d1);
  static const IconData room = const IconData(0xe8b4);
  static const IconData room_service = const IconData(0xeb49);
  static const IconData rotate_90_degrees_ccw = const IconData(0xe418);
  static const IconData rotate_left = const IconData(0xe419);
  static const IconData rotate_right = const IconData(0xe41a);
  static const IconData rounded_corner = const IconData(0xe920);
  static const IconData router = const IconData(0xe328);
  static const IconData rowing = const IconData(0xe921);
  static const IconData rss_feed = const IconData(0xe0e5);
  static const IconData rv_hookup = const IconData(0xe642);
  static const IconData satellite = const IconData(0xe562);
  static const IconData save = const IconData(0xe161);
  static const IconData scanner = const IconData(0xe329);
  static const IconData schedule = const IconData(0xe8b5);
  static const IconData school = const IconData(0xe80c);
  static const IconData screen_lock_landscape = const IconData(0xe1be);
  static const IconData screen_lock_portrait = const IconData(0xe1bf);
  static const IconData screen_lock_rotation = const IconData(0xe1c0);
  static const IconData screen_rotation = const IconData(0xe1c1);
  static const IconData screen_share = const IconData(0xe0e2);
  static const IconData sd_card = const IconData(0xe623);
  static const IconData sd_storage = const IconData(0xe1c2);
  static const IconData search = const IconData(0xe8b6);
  static const IconData security = const IconData(0xe32a);
  static const IconData select_all = const IconData(0xe162);
  static const IconData send = const IconData(0xe163);
  static const IconData sentiment_dissatisfied = const IconData(0xe811);
  static const IconData sentiment_neutral = const IconData(0xe812);
  static const IconData sentiment_satisfied = const IconData(0xe813);
  static const IconData sentiment_very_dissatisfied = const IconData(0xe814);
  static const IconData sentiment_very_satisfied = const IconData(0xe815);
  static const IconData settings = const IconData(0xe8b8);
  static const IconData settings_applications = const IconData(0xe8b9);
  static const IconData settings_backup_restore = const IconData(0xe8ba);
  static const IconData settings_bluetooth = const IconData(0xe8bb);
  static const IconData settings_brightness = const IconData(0xe8bd);
  static const IconData settings_cell = const IconData(0xe8bc);
  static const IconData settings_ethernet = const IconData(0xe8be);
  static const IconData settings_input_antenna = const IconData(0xe8bf);
  static const IconData settings_input_component = const IconData(0xe8c0);
  static const IconData settings_input_composite = const IconData(0xe8c1);
  static const IconData settings_input_hdmi = const IconData(0xe8c2);
  static const IconData settings_input_svideo = const IconData(0xe8c3);
  static const IconData settings_overscan = const IconData(0xe8c4);
  static const IconData settings_phone = const IconData(0xe8c5);
  static const IconData settings_power = const IconData(0xe8c6);
  static const IconData settings_remote = const IconData(0xe8c7);
  static const IconData settings_system_daydream = const IconData(0xe1c3);
  static const IconData settings_voice = const IconData(0xe8c8);
  static const IconData share = const IconData(0xe80d);
  static const IconData shop = const IconData(0xe8c9);
  static const IconData shop_two = const IconData(0xe8ca);
  static const IconData shopping_basket = const IconData(0xe8cb);
  static const IconData shopping_cart = const IconData(0xe8cc);
  static const IconData short_text = const IconData(0xe261);
  static const IconData show_chart = const IconData(0xe6e1);
  static const IconData shuffle = const IconData(0xe043);
  static const IconData signal_cellular_4_bar = const IconData(0xe1c8);
  static const IconData signal_cellular_connected_no_internet_4_bar = const IconData(0xe1cd);
  static const IconData signal_cellular_no_sim = const IconData(0xe1ce);
  static const IconData signal_cellular_null = const IconData(0xe1cf);
  static const IconData signal_cellular_off = const IconData(0xe1d0);
  static const IconData signal_wifi_4_bar = const IconData(0xe1d8);
  static const IconData signal_wifi_4_bar_lock = const IconData(0xe1d9);
  static const IconData signal_wifi_off = const IconData(0xe1da);
  static const IconData sim_card = const IconData(0xe32b);
  static const IconData sim_card_alert = const IconData(0xe624);
  static const IconData skip_next = const IconData(0xe044);
  static const IconData skip_previous = const IconData(0xe045);
  static const IconData slideshow = const IconData(0xe41b);
  static const IconData slow_motion_video = const IconData(0xe068);
  static const IconData smartphone = const IconData(0xe32c);
  static const IconData smoke_free = const IconData(0xeb4a);
  static const IconData smoking_rooms = const IconData(0xeb4b);
  static const IconData sms = const IconData(0xe625);
  static const IconData sms_failed = const IconData(0xe626);
  static const IconData snooze = const IconData(0xe046);
  static const IconData sort = const IconData(0xe164);
  static const IconData sort_by_alpha = const IconData(0xe053);
  static const IconData spa = const IconData(0xeb4c);
  static const IconData space_bar = const IconData(0xe256);
  static const IconData speaker = const IconData(0xe32d);
  static const IconData speaker_group = const IconData(0xe32e);
  static const IconData speaker_notes = const IconData(0xe8cd);
  static const IconData speaker_notes_off = const IconData(0xe92a);
  static const IconData speaker_phone = const IconData(0xe0d2);
  static const IconData spellcheck = const IconData(0xe8ce);
  static const IconData star = const IconData(0xe838);
  static const IconData star_border = const IconData(0xe83a);
  static const IconData star_half = const IconData(0xe839);
  static const IconData stars = const IconData(0xe8d0);
  static const IconData stay_current_landscape = const IconData(0xe0d3);
  static const IconData stay_current_portrait = const IconData(0xe0d4);
  static const IconData stay_primary_landscape = const IconData(0xe0d5);
  static const IconData stay_primary_portrait = const IconData(0xe0d6);
  static const IconData stop = const IconData(0xe047);
  static const IconData stop_screen_share = const IconData(0xe0e3);
  static const IconData storage = const IconData(0xe1db);
  static const IconData store = const IconData(0xe8d1);
  static const IconData store_mall_directory = const IconData(0xe563);
  static const IconData straighten = const IconData(0xe41c);
  static const IconData streetview = const IconData(0xe56e);
  static const IconData strikethrough_s = const IconData(0xe257);
  static const IconData style = const IconData(0xe41d);
  static const IconData subdirectory_arrow_left = const IconData(0xe5d9);
  static const IconData subdirectory_arrow_right = const IconData(0xe5da);
  static const IconData subject = const IconData(0xe8d2);
  static const IconData subscriptions = const IconData(0xe064);
  static const IconData subtitles = const IconData(0xe048);
  static const IconData subway = const IconData(0xe56f);
  static const IconData supervisor_account = const IconData(0xe8d3);
  static const IconData surround_sound = const IconData(0xe049);
  static const IconData swap_calls = const IconData(0xe0d7);
  static const IconData swap_horiz = const IconData(0xe8d4);
  static const IconData swap_vert = const IconData(0xe8d5);
  static const IconData swap_vertical_circle = const IconData(0xe8d6);
  static const IconData switch_camera = const IconData(0xe41e);
  static const IconData switch_video = const IconData(0xe41f);
  static const IconData sync = const IconData(0xe627);
  static const IconData sync_disabled = const IconData(0xe628);
  static const IconData sync_problem = const IconData(0xe629);
  static const IconData system_update = const IconData(0xe62a);
  static const IconData system_update_alt = const IconData(0xe8d7);
  static const IconData tab = const IconData(0xe8d8);
  static const IconData tab_unselected = const IconData(0xe8d9);
  static const IconData tablet = const IconData(0xe32f);
  static const IconData tablet_android = const IconData(0xe330);
  static const IconData tablet_mac = const IconData(0xe331);
  static const IconData tag_faces = const IconData(0xe420);
  static const IconData tap_and_play = const IconData(0xe62b);
  static const IconData terrain = const IconData(0xe564);
  static const IconData text_fields = const IconData(0xe262);
  static const IconData text_format = const IconData(0xe165);
  static const IconData textsms = const IconData(0xe0d8);
  static const IconData texture = const IconData(0xe421);
  static const IconData theaters = const IconData(0xe8da);
  static const IconData thumb_down = const IconData(0xe8db);
  static const IconData thumb_up = const IconData(0xe8dc);
  static const IconData thumbs_up_down = const IconData(0xe8dd);
  static const IconData time_to_leave = const IconData(0xe62c);
  static const IconData timelapse = const IconData(0xe422);
  static const IconData timeline = const IconData(0xe922);
  static const IconData timer = const IconData(0xe425);
  static const IconData timer_10 = const IconData(0xe423);
  static const IconData timer_3 = const IconData(0xe424);
  static const IconData timer_off = const IconData(0xe426);
  static const IconData title = const IconData(0xe264);
  static const IconData toc = const IconData(0xe8de);
  static const IconData today = const IconData(0xe8df);
  static const IconData toll = const IconData(0xe8e0);
  static const IconData tonality = const IconData(0xe427);
  static const IconData touch_app = const IconData(0xe913);
  static const IconData toys = const IconData(0xe332);
  static const IconData track_changes = const IconData(0xe8e1);
  static const IconData traffic = const IconData(0xe565);
  static const IconData train = const IconData(0xe570);
  static const IconData tram = const IconData(0xe571);
  static const IconData transfer_within_a_station = const IconData(0xe572);
  static const IconData transform = const IconData(0xe428);
  static const IconData translate = const IconData(0xe8e2);
  static const IconData trending_down = const IconData(0xe8e3);
  static const IconData trending_flat = const IconData(0xe8e4);
  static const IconData trending_up = const IconData(0xe8e5);
  static const IconData tune = const IconData(0xe429);
  static const IconData turned_in = const IconData(0xe8e6);
  static const IconData turned_in_not = const IconData(0xe8e7);
  static const IconData tv = const IconData(0xe333);
  static const IconData unarchive = const IconData(0xe169);
  static const IconData undo = const IconData(0xe166);
  static const IconData unfold_less = const IconData(0xe5d6);
  static const IconData unfold_more = const IconData(0xe5d7);
  static const IconData update = const IconData(0xe923);
  static const IconData usb = const IconData(0xe1e0);
  static const IconData verified_user = const IconData(0xe8e8);
  static const IconData vertical_align_bottom = const IconData(0xe258);
  static const IconData vertical_align_center = const IconData(0xe259);
  static const IconData vertical_align_top = const IconData(0xe25a);
  static const IconData vibration = const IconData(0xe62d);
  static const IconData video_call = const IconData(0xe070);
  static const IconData video_label = const IconData(0xe071);
  static const IconData video_library = const IconData(0xe04a);
  static const IconData videocam = const IconData(0xe04b);
  static const IconData videocam_off = const IconData(0xe04c);
  static const IconData videogame_asset = const IconData(0xe338);
  static const IconData view_agenda = const IconData(0xe8e9);
  static const IconData view_array = const IconData(0xe8ea);
  static const IconData view_carousel = const IconData(0xe8eb);
  static const IconData view_column = const IconData(0xe8ec);
  static const IconData view_comfy = const IconData(0xe42a);
  static const IconData view_compact = const IconData(0xe42b);
  static const IconData view_day = const IconData(0xe8ed);
  static const IconData view_headline = const IconData(0xe8ee);
  static const IconData view_list = const IconData(0xe8ef);
  static const IconData view_module = const IconData(0xe8f0);
  static const IconData view_quilt = const IconData(0xe8f1);
  static const IconData view_stream = const IconData(0xe8f2);
  static const IconData view_week = const IconData(0xe8f3);
  static const IconData vignette = const IconData(0xe435);
  static const IconData visibility = const IconData(0xe8f4);
  static const IconData visibility_off = const IconData(0xe8f5);
  static const IconData voice_chat = const IconData(0xe62e);
  static const IconData voicemail = const IconData(0xe0d9);
  static const IconData volume_down = const IconData(0xe04d);
  static const IconData volume_mute = const IconData(0xe04e);
  static const IconData volume_off = const IconData(0xe04f);
  static const IconData volume_up = const IconData(0xe050);
  static const IconData vpn_key = const IconData(0xe0da);
  static const IconData vpn_lock = const IconData(0xe62f);
  static const IconData wallpaper = const IconData(0xe1bc);
  static const IconData warning = const IconData(0xe002);
  static const IconData watch = const IconData(0xe334);
  static const IconData watch_later = const IconData(0xe924);
  static const IconData wb_auto = const IconData(0xe42c);
  static const IconData wb_cloudy = const IconData(0xe42d);
  static const IconData wb_incandescent = const IconData(0xe42e);
  static const IconData wb_iridescent = const IconData(0xe436);
  static const IconData wb_sunny = const IconData(0xe430);
  static const IconData wc = const IconData(0xe63d);
  static const IconData web = const IconData(0xe051);
  static const IconData web_asset = const IconData(0xe069);
  static const IconData weekend = const IconData(0xe16b);
  static const IconData whatshot = const IconData(0xe80e);
  static const IconData widgets = const IconData(0xe1bd);
  static const IconData wifi = const IconData(0xe63e);
  static const IconData wifi_lock = const IconData(0xe1e1);
  static const IconData wifi_tethering = const IconData(0xe1e2);
  static const IconData work = const IconData(0xe8f9);
  static const IconData wrap_text = const IconData(0xe25b);
  static const IconData youtube_searched_for = const IconData(0xe8fa);
  static const IconData zoom_in = const IconData(0xe8ff);
  static const IconData zoom_out = const IconData(0xe900);
  static const IconData zoom_out_map = const IconData(0xe56b);
}
