// Copyright 2014 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// @dart = 2.8

import 'package:flutter/widgets.dart';

/// Identifiers for the supported material design icons.
///
/// Use with the [Icon] class to show specific icons.
///
/// Icons are identified by their name as listed below.
///
/// To use this class, make sure you set `uses-material-design: true` in your
/// project's `pubspec.yaml` file in the `flutter` section. This ensures that
/// the MaterialIcons font is included in your application. This font is used to
/// display the icons. For example:
///
/// ```yaml
/// name: my_awesome_application
/// flutter:
///   uses-material-design: true
/// ```
///
/// {@tool snippet}
/// This example shows how to create a [Row] of [Icon]s in different colors and
/// sizes. The first [Icon] uses a [Icon.semanticLabel] to announce in accessibility
/// modes like TalkBack and VoiceOver.
///
/// ![A row of icons representing a pink heart, a green musical note, and a blue umbrella](https://flutter.github.io/assets-for-api-docs/assets/widgets/icon.png)
///
/// ```dart
/// Row(
///   mainAxisAlignment: MainAxisAlignment.spaceAround,
///   children: const <Widget>[
///     Icon(
///       Icons.favorite,
///       color: Colors.pink,
///       size: 24.0,
///       semanticLabel: 'Text to announce in accessibility modes',
///     ),
///     Icon(
///       Icons.audiotrack,
///       color: Colors.green,
///       size: 30.0,
///     ),
///     Icon(
///       Icons.beach_access,
///       color: Colors.blue,
///       size: 36.0,
///     ),
///   ],
/// )
/// ```
/// {@end-tool}
///
/// See also:
///
///  * [Icon]
///  * [IconButton]
///  * <https://design.google.com/icons/>
class Icons {
  // This class is not meant to be instantiated or extended; this constructor
  // prevents instantiation and extension.
  // ignore: unused_element
  Icons._();

  // Generated code: do not hand-edit.
  // See https://github.com/flutter/flutter/wiki/Updating-Material-Design-Fonts
  // BEGIN GENERATED

  /// <i class="material-icons md-36">360</i> &#x2014; material icon named "360".
  static const IconData threesixty = IconData(0xe577, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3d_rotation</i> &#x2014; material icon named "3d rotation".
  static const IconData threed_rotation = IconData(0xe84d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">4k</i> &#x2014; material icon named "4k".
  static const IconData four_k = IconData(0xe072, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ac_unit</i> &#x2014; material icon named "ac unit".
  static const IconData ac_unit = IconData(0xeb3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_alarm</i> &#x2014; material icon named "access alarm".
  static const IconData access_alarm = IconData(0xe190, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_alarms</i> &#x2014; material icon named "access alarms".
  static const IconData access_alarms = IconData(0xe191, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_time</i> &#x2014; material icon named "access time".
  static const IconData access_time = IconData(0xe192, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessibility</i> &#x2014; material icon named "accessibility".
  static const IconData accessibility = IconData(0xe84e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessibility_new</i> &#x2014; material icon named "accessibility new".
  static const IconData accessibility_new = IconData(0xe92c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessible</i> &#x2014; material icon named "accessible".
  static const IconData accessible = IconData(0xe914, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessible_forward</i> &#x2014; material icon named "accessible forward".
  static const IconData accessible_forward = IconData(0xe934, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_balance</i> &#x2014; material icon named "account balance".
  static const IconData account_balance = IconData(0xe84f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_balance_wallet</i> &#x2014; material icon named "account balance wallet".
  static const IconData account_balance_wallet = IconData(0xe850, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_box</i> &#x2014; material icon named "account box".
  static const IconData account_box = IconData(0xe851, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_circle</i> &#x2014; material icon named "account circle".
  static const IconData account_circle = IconData(0xe853, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">adb</i> &#x2014; material icon named "adb".
  static const IconData adb = IconData(0xe60e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add</i> &#x2014; material icon named "add".
  static const IconData add = IconData(0xe145, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_a_photo</i> &#x2014; material icon named "add a photo".
  static const IconData add_a_photo = IconData(0xe439, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_alarm</i> &#x2014; material icon named "add alarm".
  static const IconData add_alarm = IconData(0xe193, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_alert</i> &#x2014; material icon named "add alert".
  static const IconData add_alert = IconData(0xe003, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_box</i> &#x2014; material icon named "add box".
  static const IconData add_box = IconData(0xe146, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_call</i> &#x2014; material icon named "add call".
  static const IconData add_call = IconData(0xe0e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_circle</i> &#x2014; material icon named "add circle".
  static const IconData add_circle = IconData(0xe147, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_circle_outline</i> &#x2014; material icon named "add circle outline".
  static const IconData add_circle_outline = IconData(0xe148, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_comment</i> &#x2014; material icon named "add comment".
  static const IconData add_comment = IconData(0xe266, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_location</i> &#x2014; material icon named "add location".
  static const IconData add_location = IconData(0xe567, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_photo_alternate</i> &#x2014; material icon named "add photo alternate".
  static const IconData add_photo_alternate = IconData(0xe43e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_shopping_cart</i> &#x2014; material icon named "add shopping cart".
  static const IconData add_shopping_cart = IconData(0xe854, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_home_screen</i> &#x2014; material icon named "add to home screen".
  static const IconData add_to_home_screen = IconData(0xe1fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_photos</i> &#x2014; material icon named "add to photos".
  static const IconData add_to_photos = IconData(0xe39d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_queue</i> &#x2014; material icon named "add to queue".
  static const IconData add_to_queue = IconData(0xe05c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">adjust</i> &#x2014; material icon named "adjust".
  static const IconData adjust = IconData(0xe39e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_flat</i> &#x2014; material icon named "airline seat flat".
  static const IconData airline_seat_flat = IconData(0xe630, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_flat_angled</i> &#x2014; material icon named "airline seat flat angled".
  static const IconData airline_seat_flat_angled = IconData(0xe631, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_individual_suite</i> &#x2014; material icon named "airline seat individual suite".
  static const IconData airline_seat_individual_suite = IconData(0xe632, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_legroom_extra</i> &#x2014; material icon named "airline seat legroom extra".
  static const IconData airline_seat_legroom_extra = IconData(0xe633, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_legroom_normal</i> &#x2014; material icon named "airline seat legroom normal".
  static const IconData airline_seat_legroom_normal = IconData(0xe634, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_legroom_reduced</i> &#x2014; material icon named "airline seat legroom reduced".
  static const IconData airline_seat_legroom_reduced = IconData(0xe635, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_recline_extra</i> &#x2014; material icon named "airline seat recline extra".
  static const IconData airline_seat_recline_extra = IconData(0xe636, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_recline_normal</i> &#x2014; material icon named "airline seat recline normal".
  static const IconData airline_seat_recline_normal = IconData(0xe637, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_active</i> &#x2014; material icon named "airplanemode active".
  static const IconData airplanemode_active = IconData(0xe195, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_inactive</i> &#x2014; material icon named "airplanemode inactive".
  static const IconData airplanemode_inactive = IconData(0xe194, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplay</i> &#x2014; material icon named "airplay".
  static const IconData airplay = IconData(0xe055, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airport_shuttle</i> &#x2014; material icon named "airport shuttle".
  static const IconData airport_shuttle = IconData(0xeb3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm</i> &#x2014; material icon named "alarm".
  static const IconData alarm = IconData(0xe855, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm_add</i> &#x2014; material icon named "alarm add".
  static const IconData alarm_add = IconData(0xe856, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm_off</i> &#x2014; material icon named "alarm off".
  static const IconData alarm_off = IconData(0xe857, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm_on</i> &#x2014; material icon named "alarm on".
  static const IconData alarm_on = IconData(0xe858, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">album</i> &#x2014; material icon named "album".
  static const IconData album = IconData(0xe019, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">all_inclusive</i> &#x2014; material icon named "all inclusive".
  static const IconData all_inclusive = IconData(0xeb3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">all_out</i> &#x2014; material icon named "all out".
  static const IconData all_out = IconData(0xe90b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alternate_email</i> &#x2014; material icon named "alternate email".
  static const IconData alternate_email = IconData(0xe0e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">android</i> &#x2014; material icon named "android".
  static const IconData android = IconData(0xe859, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">announcement</i> &#x2014; material icon named "announcement".
  static const IconData announcement = IconData(0xe85a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">apps</i> &#x2014; material icon named "apps".
  static const IconData apps = IconData(0xe5c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">archive</i> &#x2014; material icon named "archive".
  static const IconData archive = IconData(0xe149, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_back</i> &#x2014; material icon named "arrow back".
  static const IconData arrow_back = IconData(0xe5c4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios".
  static const IconData arrow_back_ios = IconData(0xe5e0, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_downward</i> &#x2014; material icon named "arrow downward".
  static const IconData arrow_downward = IconData(0xe5db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_drop_down</i> &#x2014; material icon named "arrow drop down".
  static const IconData arrow_drop_down = IconData(0xe5c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_drop_down_circle</i> &#x2014; material icon named "arrow drop down circle".
  static const IconData arrow_drop_down_circle = IconData(0xe5c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_drop_up</i> &#x2014; material icon named "arrow drop up".
  static const IconData arrow_drop_up = IconData(0xe5c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_forward</i> &#x2014; material icon named "arrow forward".
  static const IconData arrow_forward = IconData(0xe5c8, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios".
  static const IconData arrow_forward_ios = IconData(0xe5e1, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_left</i> &#x2014; material icon named "arrow left".
  static const IconData arrow_left = IconData(0xe5de, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_right</i> &#x2014; material icon named "arrow right".
  static const IconData arrow_right = IconData(0xe5df, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_upward</i> &#x2014; material icon named "arrow upward".
  static const IconData arrow_upward = IconData(0xe5d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">art_track</i> &#x2014; material icon named "art track".
  static const IconData art_track = IconData(0xe060, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">aspect_ratio</i> &#x2014; material icon named "aspect ratio".
  static const IconData aspect_ratio = IconData(0xe85b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assessment</i> &#x2014; material icon named "assessment".
  static const IconData assessment = IconData(0xe85c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment</i> &#x2014; material icon named "assignment".
  static const IconData assignment = IconData(0xe85d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">assignment_ind</i> &#x2014; material icon named "assignment ind".
  static const IconData assignment_ind = IconData(0xe85e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_late</i> &#x2014; material icon named "assignment late".
  static const IconData assignment_late = IconData(0xe85f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_return</i> &#x2014; material icon named "assignment return".
  static const IconData assignment_return = IconData(0xe860, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">assignment_returned</i> &#x2014; material icon named "assignment returned".
  static const IconData assignment_returned = IconData(0xe861, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_turned_in</i> &#x2014; material icon named "assignment turned in".
  static const IconData assignment_turned_in = IconData(0xe862, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant</i> &#x2014; material icon named "assistant".
  static const IconData assistant = IconData(0xe39f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant_photo</i> &#x2014; material icon named "assistant photo".
  static const IconData assistant_photo = IconData(0xe3a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">atm</i> &#x2014; material icon named "atm".
  static const IconData atm = IconData(0xe573, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attach_file</i> &#x2014; material icon named "attach file".
  static const IconData attach_file = IconData(0xe226, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attach_money</i> &#x2014; material icon named "attach money".
  static const IconData attach_money = IconData(0xe227, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attachment</i> &#x2014; material icon named "attachment".
  static const IconData attachment = IconData(0xe2bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">audiotrack</i> &#x2014; material icon named "audiotrack".
  static const IconData audiotrack = IconData(0xe3a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">autorenew</i> &#x2014; material icon named "autorenew".
  static const IconData autorenew = IconData(0xe863, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">av_timer</i> &#x2014; material icon named "av timer".
  static const IconData av_timer = IconData(0xe01b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">backspace</i> &#x2014; material icon named "backspace".
  static const IconData backspace = IconData(0xe14a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">backup</i> &#x2014; material icon named "backup".
  static const IconData backup = IconData(0xe864, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_alert</i> &#x2014; material icon named "battery alert".
  static const IconData battery_alert = IconData(0xe19c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_charging_full</i> &#x2014; material icon named "battery charging full".
  static const IconData battery_charging_full = IconData(0xe1a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_full</i> &#x2014; material icon named "battery full".
  static const IconData battery_full = IconData(0xe1a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_std</i> &#x2014; material icon named "battery std".
  static const IconData battery_std = IconData(0xe1a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_unknown</i> &#x2014; material icon named "battery unknown".
  static const IconData battery_unknown = IconData(0xe1a6, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">beach_access</i> &#x2014; material icon named "beach access".
  static const IconData beach_access = IconData(0xeb3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">beenhere</i> &#x2014; material icon named "beenhere".
  static const IconData beenhere = IconData(0xe52d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">block</i> &#x2014; material icon named "block".
  static const IconData block = IconData(0xe14b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth</i> &#x2014; material icon named "bluetooth".
  static const IconData bluetooth = IconData(0xe1a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_audio</i> &#x2014; material icon named "bluetooth audio".
  static const IconData bluetooth_audio = IconData(0xe60f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_connected</i> &#x2014; material icon named "bluetooth connected".
  static const IconData bluetooth_connected = IconData(0xe1a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_disabled</i> &#x2014; material icon named "bluetooth disabled".
  static const IconData bluetooth_disabled = IconData(0xe1a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_searching</i> &#x2014; material icon named "bluetooth searching".
  static const IconData bluetooth_searching = IconData(0xe1aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_circular</i> &#x2014; material icon named "blur circular".
  static const IconData blur_circular = IconData(0xe3a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_linear</i> &#x2014; material icon named "blur linear".
  static const IconData blur_linear = IconData(0xe3a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_off</i> &#x2014; material icon named "blur off".
  static const IconData blur_off = IconData(0xe3a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_on</i> &#x2014; material icon named "blur on".
  static const IconData blur_on = IconData(0xe3a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">book</i> &#x2014; material icon named "book".
  static const IconData book = IconData(0xe865, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark</i> &#x2014; material icon named "bookmark".
  static const IconData bookmark = IconData(0xe866, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark_border</i> &#x2014; material icon named "bookmark border".
  static const IconData bookmark_border = IconData(0xe867, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_all</i> &#x2014; material icon named "border all".
  static const IconData border_all = IconData(0xe228, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_bottom</i> &#x2014; material icon named "border bottom".
  static const IconData border_bottom = IconData(0xe229, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_clear</i> &#x2014; material icon named "border clear".
  static const IconData border_clear = IconData(0xe22a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_color</i> &#x2014; material icon named "border color".
  static const IconData border_color = IconData(0xe22b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_horizontal</i> &#x2014; material icon named "border horizontal".
  static const IconData border_horizontal = IconData(0xe22c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_inner</i> &#x2014; material icon named "border inner".
  static const IconData border_inner = IconData(0xe22d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_left</i> &#x2014; material icon named "border left".
  static const IconData border_left = IconData(0xe22e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_outer</i> &#x2014; material icon named "border outer".
  static const IconData border_outer = IconData(0xe22f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_right</i> &#x2014; material icon named "border right".
  static const IconData border_right = IconData(0xe230, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_style</i> &#x2014; material icon named "border style".
  static const IconData border_style = IconData(0xe231, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_top</i> &#x2014; material icon named "border top".
  static const IconData border_top = IconData(0xe232, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_vertical</i> &#x2014; material icon named "border vertical".
  static const IconData border_vertical = IconData(0xe233, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">branding_watermark</i> &#x2014; material icon named "branding watermark".
  static const IconData branding_watermark = IconData(0xe06b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_1</i> &#x2014; material icon named "brightness 1".
  static const IconData brightness_1 = IconData(0xe3a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_2</i> &#x2014; material icon named "brightness 2".
  static const IconData brightness_2 = IconData(0xe3a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_3</i> &#x2014; material icon named "brightness 3".
  static const IconData brightness_3 = IconData(0xe3a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_4</i> &#x2014; material icon named "brightness 4".
  static const IconData brightness_4 = IconData(0xe3a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_5</i> &#x2014; material icon named "brightness 5".
  static const IconData brightness_5 = IconData(0xe3aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_6</i> &#x2014; material icon named "brightness 6".
  static const IconData brightness_6 = IconData(0xe3ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_7</i> &#x2014; material icon named "brightness 7".
  static const IconData brightness_7 = IconData(0xe3ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_auto</i> &#x2014; material icon named "brightness auto".
  static const IconData brightness_auto = IconData(0xe1ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_high</i> &#x2014; material icon named "brightness high".
  static const IconData brightness_high = IconData(0xe1ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_low</i> &#x2014; material icon named "brightness low".
  static const IconData brightness_low = IconData(0xe1ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_medium</i> &#x2014; material icon named "brightness medium".
  static const IconData brightness_medium = IconData(0xe1ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">broken_image</i> &#x2014; material icon named "broken image".
  static const IconData broken_image = IconData(0xe3ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brush</i> &#x2014; material icon named "brush".
  static const IconData brush = IconData(0xe3ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bubble_chart</i> &#x2014; material icon named "bubble chart".
  static const IconData bubble_chart = IconData(0xe6dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bug_report</i> &#x2014; material icon named "bug report".
  static const IconData bug_report = IconData(0xe868, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">build</i> &#x2014; material icon named "build".
  static const IconData build = IconData(0xe869, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">burst_mode</i> &#x2014; material icon named "burst mode".
  static const IconData burst_mode = IconData(0xe43c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">business</i> &#x2014; material icon named "business".
  static const IconData business = IconData(0xe0af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">business_center</i> &#x2014; material icon named "business center".
  static const IconData business_center = IconData(0xeb3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cached</i> &#x2014; material icon named "cached".
  static const IconData cached = IconData(0xe86a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cake</i> &#x2014; material icon named "cake".
  static const IconData cake = IconData(0xe7e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calendar_today</i> &#x2014; material icon named "calendar today".
  static const IconData calendar_today = IconData(0xe935, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calendar_view_day</i> &#x2014; material icon named "calendar view day".
  static const IconData calendar_view_day = IconData(0xe936, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call</i> &#x2014; material icon named "call".
  static const IconData call = IconData(0xe0b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_end</i> &#x2014; material icon named "call end".
  static const IconData call_end = IconData(0xe0b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_made</i> &#x2014; material icon named "call made".
  static const IconData call_made = IconData(0xe0b2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_merge</i> &#x2014; material icon named "call merge".
  static const IconData call_merge = IconData(0xe0b3, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_missed</i> &#x2014; material icon named "call missed".
  static const IconData call_missed = IconData(0xe0b4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_missed_outgoing</i> &#x2014; material icon named "call missed outgoing".
  static const IconData call_missed_outgoing = IconData(0xe0e4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_received</i> &#x2014; material icon named "call received".
  static const IconData call_received = IconData(0xe0b5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_split</i> &#x2014; material icon named "call split".
  static const IconData call_split = IconData(0xe0b6, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_to_action</i> &#x2014; material icon named "call to action".
  static const IconData call_to_action = IconData(0xe06c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera</i> &#x2014; material icon named "camera".
  static const IconData camera = IconData(0xe3af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_alt</i> &#x2014; material icon named "camera alt".
  static const IconData camera_alt = IconData(0xe3b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_enhance</i> &#x2014; material icon named "camera enhance".
  static const IconData camera_enhance = IconData(0xe8fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_front</i> &#x2014; material icon named "camera front".
  static const IconData camera_front = IconData(0xe3b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_rear</i> &#x2014; material icon named "camera rear".
  static const IconData camera_rear = IconData(0xe3b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_roll</i> &#x2014; material icon named "camera roll".
  static const IconData camera_roll = IconData(0xe3b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cancel</i> &#x2014; material icon named "cancel".
  static const IconData cancel = IconData(0xe5c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">card_giftcard</i> &#x2014; material icon named "card giftcard".
  static const IconData card_giftcard = IconData(0xe8f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">card_membership</i> &#x2014; material icon named "card membership".
  static const IconData card_membership = IconData(0xe8f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">card_travel</i> &#x2014; material icon named "card travel".
  static const IconData card_travel = IconData(0xe8f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">casino</i> &#x2014; material icon named "casino".
  static const IconData casino = IconData(0xeb40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cast</i> &#x2014; material icon named "cast".
  static const IconData cast = IconData(0xe307, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cast_connected</i> &#x2014; material icon named "cast connected".
  static const IconData cast_connected = IconData(0xe308, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">category</i> &#x2014; material icon named "category".
  static const IconData category = IconData(0xe574, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">center_focus_strong</i> &#x2014; material icon named "center focus strong".
  static const IconData center_focus_strong = IconData(0xe3b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">center_focus_weak</i> &#x2014; material icon named "center focus weak".
  static const IconData center_focus_weak = IconData(0xe3b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">change_history</i> &#x2014; material icon named "change history".
  static const IconData change_history = IconData(0xe86b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chat</i> &#x2014; material icon named "chat".
  static const IconData chat = IconData(0xe0b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chat_bubble</i> &#x2014; material icon named "chat bubble".
  static const IconData chat_bubble = IconData(0xe0ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chat_bubble_outline</i> &#x2014; material icon named "chat bubble outline".
  static const IconData chat_bubble_outline = IconData(0xe0cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check</i> &#x2014; material icon named "check".
  static const IconData check = IconData(0xe5ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_box</i> &#x2014; material icon named "check box".
  static const IconData check_box = IconData(0xe834, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_box_outline_blank</i> &#x2014; material icon named "check box outline blank".
  static const IconData check_box_outline_blank = IconData(0xe835, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_circle</i> &#x2014; material icon named "check circle".
  static const IconData check_circle = IconData(0xe86c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_circle_outline</i> &#x2014; material icon named "check circle outline".
  static const IconData check_circle_outline = IconData(0xe92d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chevron_left</i> &#x2014; material icon named "chevron left".
  static const IconData chevron_left = IconData(0xe5cb, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">chevron_right</i> &#x2014; material icon named "chevron right".
  static const IconData chevron_right = IconData(0xe5cc, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">child_care</i> &#x2014; material icon named "child care".
  static const IconData child_care = IconData(0xeb41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">child_friendly</i> &#x2014; material icon named "child friendly".
  static const IconData child_friendly = IconData(0xeb42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chrome_reader_mode</i> &#x2014; material icon named "chrome reader mode".
  static const IconData chrome_reader_mode = IconData(0xe86d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">class</i> &#x2014; material icon named "class".
  static const IconData class_ = IconData(0xe86e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">clear</i> &#x2014; material icon named "clear".
  static const IconData clear = IconData(0xe14c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">clear_all</i> &#x2014; material icon named "clear all".
  static const IconData clear_all = IconData(0xe0b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">close</i> &#x2014; material icon named "close".
  static const IconData close = IconData(0xe5cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">closed_caption</i> &#x2014; material icon named "closed caption".
  static const IconData closed_caption = IconData(0xe01c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud</i> &#x2014; material icon named "cloud".
  static const IconData cloud = IconData(0xe2bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_circle</i> &#x2014; material icon named "cloud circle".
  static const IconData cloud_circle = IconData(0xe2be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_done</i> &#x2014; material icon named "cloud done".
  static const IconData cloud_done = IconData(0xe2bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_download</i> &#x2014; material icon named "cloud download".
  static const IconData cloud_download = IconData(0xe2c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_off</i> &#x2014; material icon named "cloud off".
  static const IconData cloud_off = IconData(0xe2c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_queue</i> &#x2014; material icon named "cloud queue".
  static const IconData cloud_queue = IconData(0xe2c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_upload</i> &#x2014; material icon named "cloud upload".
  static const IconData cloud_upload = IconData(0xe2c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">code</i> &#x2014; material icon named "code".
  static const IconData code = IconData(0xe86f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">collections</i> &#x2014; material icon named "collections".
  static const IconData collections = IconData(0xe3b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">collections_bookmark</i> &#x2014; material icon named "collections bookmark".
  static const IconData collections_bookmark = IconData(0xe431, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">color_lens</i> &#x2014; material icon named "color lens".
  static const IconData color_lens = IconData(0xe3b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">colorize</i> &#x2014; material icon named "colorize".
  static const IconData colorize = IconData(0xe3b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">comment</i> &#x2014; material icon named "comment".
  static const IconData comment = IconData(0xe0b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compare</i> &#x2014; material icon named "compare".
  static const IconData compare = IconData(0xe3b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compare_arrows</i> &#x2014; material icon named "compare arrows".
  static const IconData compare_arrows = IconData(0xe915, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">computer</i> &#x2014; material icon named "computer".
  static const IconData computer = IconData(0xe30a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">confirmation_number</i> &#x2014; material icon named "confirmation number".
  static const IconData confirmation_number = IconData(0xe638, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_mail</i> &#x2014; material icon named "contact mail".
  static const IconData contact_mail = IconData(0xe0d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_phone</i> &#x2014; material icon named "contact phone".
  static const IconData contact_phone = IconData(0xe0cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contacts</i> &#x2014; material icon named "contacts".
  static const IconData contacts = IconData(0xe0ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_copy</i> &#x2014; material icon named "content copy".
  static const IconData content_copy = IconData(0xe14d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_cut</i> &#x2014; material icon named "content cut".
  static const IconData content_cut = IconData(0xe14e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_paste</i> &#x2014; material icon named "content paste".
  static const IconData content_paste = IconData(0xe14f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">control_point</i> &#x2014; material icon named "control point".
  static const IconData control_point = IconData(0xe3ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">control_point_duplicate</i> &#x2014; material icon named "control point duplicate".
  static const IconData control_point_duplicate = IconData(0xe3bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">copyright</i> &#x2014; material icon named "copyright".
  static const IconData copyright = IconData(0xe90c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">create</i> &#x2014; material icon named "create".
  static const IconData create = IconData(0xe150, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">create_new_folder</i> &#x2014; material icon named "create new folder".
  static const IconData create_new_folder = IconData(0xe2cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">credit_card</i> &#x2014; material icon named "credit card".
  static const IconData credit_card = IconData(0xe870, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop</i> &#x2014; material icon named "crop".
  static const IconData crop = IconData(0xe3be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_16_9</i> &#x2014; material icon named "crop 16 9".
  static const IconData crop_16_9 = IconData(0xe3bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_3_2</i> &#x2014; material icon named "crop 3 2".
  static const IconData crop_3_2 = IconData(0xe3bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_5_4</i> &#x2014; material icon named "crop 5 4".
  static const IconData crop_5_4 = IconData(0xe3bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_7_5</i> &#x2014; material icon named "crop 7 5".
  static const IconData crop_7_5 = IconData(0xe3c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_din</i> &#x2014; material icon named "crop din".
  static const IconData crop_din = IconData(0xe3c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_free</i> &#x2014; material icon named "crop free".
  static const IconData crop_free = IconData(0xe3c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_landscape</i> &#x2014; material icon named "crop landscape".
  static const IconData crop_landscape = IconData(0xe3c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_original</i> &#x2014; material icon named "crop original".
  static const IconData crop_original = IconData(0xe3c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_portrait</i> &#x2014; material icon named "crop portrait".
  static const IconData crop_portrait = IconData(0xe3c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_rotate</i> &#x2014; material icon named "crop rotate".
  static const IconData crop_rotate = IconData(0xe437, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_square</i> &#x2014; material icon named "crop square".
  static const IconData crop_square = IconData(0xe3c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dashboard</i> &#x2014; material icon named "dashboard".
  static const IconData dashboard = IconData(0xe871, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">data_usage</i> &#x2014; material icon named "data usage".
  static const IconData data_usage = IconData(0xe1af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">date_range</i> &#x2014; material icon named "date range".
  static const IconData date_range = IconData(0xe916, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dehaze</i> &#x2014; material icon named "dehaze".
  static const IconData dehaze = IconData(0xe3c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete</i> &#x2014; material icon named "delete".
  static const IconData delete = IconData(0xe872, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete_forever</i> &#x2014; material icon named "delete forever".
  static const IconData delete_forever = IconData(0xe92b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete_outline</i> &#x2014; material icon named "delete outline".
  static const IconData delete_outline = IconData(0xe92e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete_sweep</i> &#x2014; material icon named "delete sweep".
  static const IconData delete_sweep = IconData(0xe16c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">departure_board</i> &#x2014; material icon named "departure board".
  static const IconData departure_board = IconData(0xe576, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">description</i> &#x2014; material icon named "description".
  static const IconData description = IconData(0xe873, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">desktop_mac</i> &#x2014; material icon named "desktop mac".
  static const IconData desktop_mac = IconData(0xe30b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">desktop_windows</i> &#x2014; material icon named "desktop windows".
  static const IconData desktop_windows = IconData(0xe30c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">details</i> &#x2014; material icon named "details".
  static const IconData details = IconData(0xe3c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">developer_board</i> &#x2014; material icon named "developer board".
  static const IconData developer_board = IconData(0xe30d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">developer_mode</i> &#x2014; material icon named "developer mode".
  static const IconData developer_mode = IconData(0xe1b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">device_hub</i> &#x2014; material icon named "device hub".
  static const IconData device_hub = IconData(0xe335, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">device_unknown</i> &#x2014; material icon named "device unknown".
  static const IconData device_unknown = IconData(0xe339, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">devices</i> &#x2014; material icon named "devices".
  static const IconData devices = IconData(0xe1b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">devices_other</i> &#x2014; material icon named "devices other".
  static const IconData devices_other = IconData(0xe337, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dialer_sip</i> &#x2014; material icon named "dialer sip".
  static const IconData dialer_sip = IconData(0xe0bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dialpad</i> &#x2014; material icon named "dialpad".
  static const IconData dialpad = IconData(0xe0bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions</i> &#x2014; material icon named "directions".
  static const IconData directions = IconData(0xe52e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_bike</i> &#x2014; material icon named "directions bike".
  static const IconData directions_bike = IconData(0xe52f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_boat</i> &#x2014; material icon named "directions boat".
  static const IconData directions_boat = IconData(0xe532, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_bus</i> &#x2014; material icon named "directions bus".
  static const IconData directions_bus = IconData(0xe530, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_car</i> &#x2014; material icon named "directions car".
  static const IconData directions_car = IconData(0xe531, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_railway</i> &#x2014; material icon named "directions railway".
  static const IconData directions_railway = IconData(0xe534, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_run</i> &#x2014; material icon named "directions run".
  static const IconData directions_run = IconData(0xe566, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_subway</i> &#x2014; material icon named "directions subway".
  static const IconData directions_subway = IconData(0xe533, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_transit</i> &#x2014; material icon named "directions transit".
  static const IconData directions_transit = IconData(0xe535, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_walk</i> &#x2014; material icon named "directions walk".
  static const IconData directions_walk = IconData(0xe536, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">disc_full</i> &#x2014; material icon named "disc full".
  static const IconData disc_full = IconData(0xe610, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dns</i> &#x2014; material icon named "dns".
  static const IconData dns = IconData(0xe875, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb</i> &#x2014; material icon named "do not disturb".
  static const IconData do_not_disturb = IconData(0xe612, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_alt</i> &#x2014; material icon named "do not disturb alt".
  static const IconData do_not_disturb_alt = IconData(0xe611, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_off</i> &#x2014; material icon named "do not disturb off".
  static const IconData do_not_disturb_off = IconData(0xe643, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_on</i> &#x2014; material icon named "do not disturb on".
  static const IconData do_not_disturb_on = IconData(0xe644, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dock</i> &#x2014; material icon named "dock".
  static const IconData dock = IconData(0xe30e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">domain</i> &#x2014; material icon named "domain".
  static const IconData domain = IconData(0xe7ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">done</i> &#x2014; material icon named "done".
  static const IconData done = IconData(0xe876, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">done_all</i> &#x2014; material icon named "done all".
  static const IconData done_all = IconData(0xe877, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">done_outline</i> &#x2014; material icon named "done outline".
  static const IconData done_outline = IconData(0xe92f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">donut_large</i> &#x2014; material icon named "donut large".
  static const IconData donut_large = IconData(0xe917, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">donut_small</i> &#x2014; material icon named "donut small".
  static const IconData donut_small = IconData(0xe918, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drafts</i> &#x2014; material icon named "drafts".
  static const IconData drafts = IconData(0xe151, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drag_handle</i> &#x2014; material icon named "drag handle".
  static const IconData drag_handle = IconData(0xe25d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_eta</i> &#x2014; material icon named "drive eta".
  static const IconData drive_eta = IconData(0xe613, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dvr</i> &#x2014; material icon named "dvr".
  static const IconData dvr = IconData(0xe1b2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">edit</i> &#x2014; material icon named "edit".
  static const IconData edit = IconData(0xe3c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_attributes</i> &#x2014; material icon named "edit attributes".
  static const IconData edit_attributes = IconData(0xe578, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_location</i> &#x2014; material icon named "edit location".
  static const IconData edit_location = IconData(0xe568, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">eject</i> &#x2014; material icon named "eject".
  static const IconData eject = IconData(0xe8fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">email</i> &#x2014; material icon named "email".
  static const IconData email = IconData(0xe0be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">enhanced_encryption</i> &#x2014; material icon named "enhanced encryption".
  static const IconData enhanced_encryption = IconData(0xe63f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">equalizer</i> &#x2014; material icon named "equalizer".
  static const IconData equalizer = IconData(0xe01d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">error</i> &#x2014; material icon named "error".
  static const IconData error = IconData(0xe000, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">error_outline</i> &#x2014; material icon named "error outline".
  static const IconData error_outline = IconData(0xe001, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">euro_symbol</i> &#x2014; material icon named "euro symbol".
  static const IconData euro_symbol = IconData(0xe926, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ev_station</i> &#x2014; material icon named "ev station".
  static const IconData ev_station = IconData(0xe56d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event</i> &#x2014; material icon named "event".
  static const IconData event = IconData(0xe878, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_available</i> &#x2014; material icon named "event available".
  static const IconData event_available = IconData(0xe614, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_busy</i> &#x2014; material icon named "event busy".
  static const IconData event_busy = IconData(0xe615, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_note</i> &#x2014; material icon named "event note".
  static const IconData event_note = IconData(0xe616, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">event_seat</i> &#x2014; material icon named "event seat".
  static const IconData event_seat = IconData(0xe903, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exit_to_app</i> &#x2014; material icon named "exit to app".
  static const IconData exit_to_app = IconData(0xe879, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">expand_less</i> &#x2014; material icon named "expand less".
  static const IconData expand_less = IconData(0xe5ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">expand_more</i> &#x2014; material icon named "expand more".
  static const IconData expand_more = IconData(0xe5cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">explicit</i> &#x2014; material icon named "explicit".
  static const IconData explicit = IconData(0xe01e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">explore</i> &#x2014; material icon named "explore".
  static const IconData explore = IconData(0xe87a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure</i> &#x2014; material icon named "exposure".
  static const IconData exposure = IconData(0xe3ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_neg_1</i> &#x2014; material icon named "exposure neg 1".
  static const IconData exposure_neg_1 = IconData(0xe3cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_neg_2</i> &#x2014; material icon named "exposure neg 2".
  static const IconData exposure_neg_2 = IconData(0xe3cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_plus_1</i> &#x2014; material icon named "exposure plus 1".
  static const IconData exposure_plus_1 = IconData(0xe3cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_plus_2</i> &#x2014; material icon named "exposure plus 2".
  static const IconData exposure_plus_2 = IconData(0xe3ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_zero</i> &#x2014; material icon named "exposure zero".
  static const IconData exposure_zero = IconData(0xe3cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">extension</i> &#x2014; material icon named "extension".
  static const IconData extension = IconData(0xe87b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">face</i> &#x2014; material icon named "face".
  static const IconData face = IconData(0xe87c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fast_forward</i> &#x2014; material icon named "fast forward".
  static const IconData fast_forward = IconData(0xe01f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fast_rewind</i> &#x2014; material icon named "fast rewind".
  static const IconData fast_rewind = IconData(0xe020, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fastfood</i> &#x2014; material icon named "fastfood".
  static const IconData fastfood = IconData(0xe57a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">favorite</i> &#x2014; material icon named "favorite".
  static const IconData favorite = IconData(0xe87d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">favorite_border</i> &#x2014; material icon named "favorite border".
  static const IconData favorite_border = IconData(0xe87e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">featured_play_list</i> &#x2014; material icon named "featured play list".
  static const IconData featured_play_list = IconData(0xe06d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">featured_video</i> &#x2014; material icon named "featured video".
  static const IconData featured_video = IconData(0xe06e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">feedback</i> &#x2014; material icon named "feedback".
  static const IconData feedback = IconData(0xe87f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_dvr</i> &#x2014; material icon named "fiber dvr".
  static const IconData fiber_dvr = IconData(0xe05d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_manual_record</i> &#x2014; material icon named "fiber manual record".
  static const IconData fiber_manual_record = IconData(0xe061, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_new</i> &#x2014; material icon named "fiber new".
  static const IconData fiber_new = IconData(0xe05e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_pin</i> &#x2014; material icon named "fiber pin".
  static const IconData fiber_pin = IconData(0xe06a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_smart_record</i> &#x2014; material icon named "fiber smart record".
  static const IconData fiber_smart_record = IconData(0xe062, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_download</i> &#x2014; material icon named "file download".
  static const IconData file_download = IconData(0xe2c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_upload</i> &#x2014; material icon named "file upload".
  static const IconData file_upload = IconData(0xe2c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter</i> &#x2014; material icon named "filter".
  static const IconData filter = IconData(0xe3d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_1</i> &#x2014; material icon named "filter 1".
  static const IconData filter_1 = IconData(0xe3d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_2</i> &#x2014; material icon named "filter 2".
  static const IconData filter_2 = IconData(0xe3d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_3</i> &#x2014; material icon named "filter 3".
  static const IconData filter_3 = IconData(0xe3d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_4</i> &#x2014; material icon named "filter 4".
  static const IconData filter_4 = IconData(0xe3d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_5</i> &#x2014; material icon named "filter 5".
  static const IconData filter_5 = IconData(0xe3d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_6</i> &#x2014; material icon named "filter 6".
  static const IconData filter_6 = IconData(0xe3d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_7</i> &#x2014; material icon named "filter 7".
  static const IconData filter_7 = IconData(0xe3d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_8</i> &#x2014; material icon named "filter 8".
  static const IconData filter_8 = IconData(0xe3d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_9</i> &#x2014; material icon named "filter 9".
  static const IconData filter_9 = IconData(0xe3d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_9_plus</i> &#x2014; material icon named "filter 9 plus".
  static const IconData filter_9_plus = IconData(0xe3da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_b_and_w</i> &#x2014; material icon named "filter b and w".
  static const IconData filter_b_and_w = IconData(0xe3db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_center_focus</i> &#x2014; material icon named "filter center focus".
  static const IconData filter_center_focus = IconData(0xe3dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_drama</i> &#x2014; material icon named "filter drama".
  static const IconData filter_drama = IconData(0xe3dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_frames</i> &#x2014; material icon named "filter frames".
  static const IconData filter_frames = IconData(0xe3de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_hdr</i> &#x2014; material icon named "filter hdr".
  static const IconData filter_hdr = IconData(0xe3df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_list</i> &#x2014; material icon named "filter list".
  static const IconData filter_list = IconData(0xe152, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_none</i> &#x2014; material icon named "filter none".
  static const IconData filter_none = IconData(0xe3e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_tilt_shift</i> &#x2014; material icon named "filter tilt shift".
  static const IconData filter_tilt_shift = IconData(0xe3e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_vintage</i> &#x2014; material icon named "filter vintage".
  static const IconData filter_vintage = IconData(0xe3e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">find_in_page</i> &#x2014; material icon named "find in page".
  static const IconData find_in_page = IconData(0xe880, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">find_replace</i> &#x2014; material icon named "find replace".
  static const IconData find_replace = IconData(0xe881, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fingerprint</i> &#x2014; material icon named "fingerprint".
  static const IconData fingerprint = IconData(0xe90d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">first_page</i> &#x2014; material icon named "first page".
  static const IconData first_page = IconData(0xe5dc, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">fitness_center</i> &#x2014; material icon named "fitness center".
  static const IconData fitness_center = IconData(0xeb43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flag</i> &#x2014; material icon named "flag".
  static const IconData flag = IconData(0xe153, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flare</i> &#x2014; material icon named "flare".
  static const IconData flare = IconData(0xe3e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flash_auto</i> &#x2014; material icon named "flash auto".
  static const IconData flash_auto = IconData(0xe3e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flash_off</i> &#x2014; material icon named "flash off".
  static const IconData flash_off = IconData(0xe3e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flash_on</i> &#x2014; material icon named "flash on".
  static const IconData flash_on = IconData(0xe3e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flight</i> &#x2014; material icon named "flight".
  static const IconData flight = IconData(0xe539, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flight_land</i> &#x2014; material icon named "flight land".
  static const IconData flight_land = IconData(0xe904, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">flight_takeoff</i> &#x2014; material icon named "flight takeoff".
  static const IconData flight_takeoff = IconData(0xe905, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">flip</i> &#x2014; material icon named "flip".
  static const IconData flip = IconData(0xe3e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_to_back</i> &#x2014; material icon named "flip to back".
  static const IconData flip_to_back = IconData(0xe882, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_to_front</i> &#x2014; material icon named "flip to front".
  static const IconData flip_to_front = IconData(0xe883, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder</i> &#x2014; material icon named "folder".
  static const IconData folder = IconData(0xe2c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder_open</i> &#x2014; material icon named "folder open".
  static const IconData folder_open = IconData(0xe2c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder_shared</i> &#x2014; material icon named "folder shared".
  static const IconData folder_shared = IconData(0xe2c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder_special</i> &#x2014; material icon named "folder special".
  static const IconData folder_special = IconData(0xe617, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">font_download</i> &#x2014; material icon named "font download".
  static const IconData font_download = IconData(0xe167, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_center</i> &#x2014; material icon named "format align center".
  static const IconData format_align_center = IconData(0xe234, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_justify</i> &#x2014; material icon named "format align justify".
  static const IconData format_align_justify = IconData(0xe235, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_left</i> &#x2014; material icon named "format align left".
  static const IconData format_align_left = IconData(0xe236, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_right</i> &#x2014; material icon named "format align right".
  static const IconData format_align_right = IconData(0xe237, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_bold</i> &#x2014; material icon named "format bold".
  static const IconData format_bold = IconData(0xe238, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_clear</i> &#x2014; material icon named "format clear".
  static const IconData format_clear = IconData(0xe239, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_color_fill</i> &#x2014; material icon named "format color fill".
  static const IconData format_color_fill = IconData(0xe23a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_color_reset</i> &#x2014; material icon named "format color reset".
  static const IconData format_color_reset = IconData(0xe23b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_color_text</i> &#x2014; material icon named "format color text".
  static const IconData format_color_text = IconData(0xe23c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_indent_decrease</i> &#x2014; material icon named "format indent decrease".
  static const IconData format_indent_decrease = IconData(0xe23d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">format_indent_increase</i> &#x2014; material icon named "format indent increase".
  static const IconData format_indent_increase = IconData(0xe23e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">format_italic</i> &#x2014; material icon named "format italic".
  static const IconData format_italic = IconData(0xe23f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_line_spacing</i> &#x2014; material icon named "format line spacing".
  static const IconData format_line_spacing = IconData(0xe240, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_list_bulleted</i> &#x2014; material icon named "format list bulleted".
  static const IconData format_list_bulleted = IconData(0xe241, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">format_list_numbered</i> &#x2014; material icon named "format list numbered".
  static const IconData format_list_numbered = IconData(0xe242, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_list_numbered_rtl</i> &#x2014; material icon named "format list numbered rtl".
  static const IconData format_list_numbered_rtl = IconData(0xe267, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_paint</i> &#x2014; material icon named "format paint".
  static const IconData format_paint = IconData(0xe243, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_quote</i> &#x2014; material icon named "format quote".
  static const IconData format_quote = IconData(0xe244, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_shapes</i> &#x2014; material icon named "format shapes".
  static const IconData format_shapes = IconData(0xe25e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_size</i> &#x2014; material icon named "format size".
  static const IconData format_size = IconData(0xe245, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_strikethrough</i> &#x2014; material icon named "format strikethrough".
  static const IconData format_strikethrough = IconData(0xe246, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_textdirection_l_to_r</i> &#x2014; material icon named "format textdirection l to r".
  static const IconData format_textdirection_l_to_r = IconData(0xe247, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_textdirection_r_to_l</i> &#x2014; material icon named "format textdirection r to l".
  static const IconData format_textdirection_r_to_l = IconData(0xe248, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_underlined</i> &#x2014; material icon named "format underlined".
  static const IconData format_underlined = IconData(0xe249, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forum</i> &#x2014; material icon named "forum".
  static const IconData forum = IconData(0xe0bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward</i> &#x2014; material icon named "forward".
  static const IconData forward = IconData(0xe154, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">forward_10</i> &#x2014; material icon named "forward 10".
  static const IconData forward_10 = IconData(0xe056, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward_30</i> &#x2014; material icon named "forward 30".
  static const IconData forward_30 = IconData(0xe057, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward_5</i> &#x2014; material icon named "forward 5".
  static const IconData forward_5 = IconData(0xe058, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">free_breakfast</i> &#x2014; material icon named "free breakfast".
  static const IconData free_breakfast = IconData(0xeb44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fullscreen</i> &#x2014; material icon named "fullscreen".
  static const IconData fullscreen = IconData(0xe5d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fullscreen_exit</i> &#x2014; material icon named "fullscreen exit".
  static const IconData fullscreen_exit = IconData(0xe5d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">functions</i> &#x2014; material icon named "functions".
  static const IconData functions = IconData(0xe24a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">g_translate</i> &#x2014; material icon named "g translate".
  static const IconData g_translate = IconData(0xe927, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gamepad</i> &#x2014; material icon named "gamepad".
  static const IconData gamepad = IconData(0xe30f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">games</i> &#x2014; material icon named "games".
  static const IconData games = IconData(0xe021, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gavel</i> &#x2014; material icon named "gavel".
  static const IconData gavel = IconData(0xe90e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gesture</i> &#x2014; material icon named "gesture".
  static const IconData gesture = IconData(0xe155, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">get_app</i> &#x2014; material icon named "get app".
  static const IconData get_app = IconData(0xe884, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gif</i> &#x2014; material icon named "gif".
  static const IconData gif = IconData(0xe908, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">golf_course</i> &#x2014; material icon named "golf course".
  static const IconData golf_course = IconData(0xeb45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gps_fixed</i> &#x2014; material icon named "gps fixed".
  static const IconData gps_fixed = IconData(0xe1b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gps_not_fixed</i> &#x2014; material icon named "gps not fixed".
  static const IconData gps_not_fixed = IconData(0xe1b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gps_off</i> &#x2014; material icon named "gps off".
  static const IconData gps_off = IconData(0xe1b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grade</i> &#x2014; material icon named "grade".
  static const IconData grade = IconData(0xe885, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gradient</i> &#x2014; material icon named "gradient".
  static const IconData gradient = IconData(0xe3e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grain</i> &#x2014; material icon named "grain".
  static const IconData grain = IconData(0xe3ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">graphic_eq</i> &#x2014; material icon named "graphic eq".
  static const IconData graphic_eq = IconData(0xe1b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_off</i> &#x2014; material icon named "grid off".
  static const IconData grid_off = IconData(0xe3eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_on</i> &#x2014; material icon named "grid on".
  static const IconData grid_on = IconData(0xe3ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">group</i> &#x2014; material icon named "group".
  static const IconData group = IconData(0xe7ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">group_add</i> &#x2014; material icon named "group add".
  static const IconData group_add = IconData(0xe7f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">group_work</i> &#x2014; material icon named "group work".
  static const IconData group_work = IconData(0xe886, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hd</i> &#x2014; material icon named "hd".
  static const IconData hd = IconData(0xe052, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_off</i> &#x2014; material icon named "hdr off".
  static const IconData hdr_off = IconData(0xe3ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_on</i> &#x2014; material icon named "hdr on".
  static const IconData hdr_on = IconData(0xe3ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_strong</i> &#x2014; material icon named "hdr strong".
  static const IconData hdr_strong = IconData(0xe3f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_weak</i> &#x2014; material icon named "hdr weak".
  static const IconData hdr_weak = IconData(0xe3f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headset</i> &#x2014; material icon named "headset".
  static const IconData headset = IconData(0xe310, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headset_mic</i> &#x2014; material icon named "headset mic".
  static const IconData headset_mic = IconData(0xe311, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headset_off</i> &#x2014; material icon named "headset off".
  static const IconData headset_off = IconData(0xe33a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">healing</i> &#x2014; material icon named "healing".
  static const IconData healing = IconData(0xe3f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hearing</i> &#x2014; material icon named "hearing".
  static const IconData hearing = IconData(0xe023, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">help</i> &#x2014; material icon named "help".
  static const IconData help = IconData(0xe887, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">help_outline</i> &#x2014; material icon named "help outline".
  static const IconData help_outline = IconData(0xe8fd, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">high_quality</i> &#x2014; material icon named "high quality".
  static const IconData high_quality = IconData(0xe024, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight</i> &#x2014; material icon named "highlight".
  static const IconData highlight = IconData(0xe25f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight_off</i> &#x2014; material icon named "highlight off".
  static const IconData highlight_off = IconData(0xe888, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">history</i> &#x2014; material icon named "history".
  static const IconData history = IconData(0xe889, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home</i> &#x2014; material icon named "home".
  static const IconData home = IconData(0xe88a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hot_tub</i> &#x2014; material icon named "hot tub".
  static const IconData hot_tub = IconData(0xeb46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hotel</i> &#x2014; material icon named "hotel".
  static const IconData hotel = IconData(0xe53a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_empty</i> &#x2014; material icon named "hourglass empty".
  static const IconData hourglass_empty = IconData(0xe88b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_full</i> &#x2014; material icon named "hourglass full".
  static const IconData hourglass_full = IconData(0xe88c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">http</i> &#x2014; material icon named "http".
  static const IconData http = IconData(0xe902, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">https</i> &#x2014; material icon named "https".
  static const IconData https = IconData(0xe88d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image</i> &#x2014; material icon named "image".
  static const IconData image = IconData(0xe3f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image_aspect_ratio</i> &#x2014; material icon named "image aspect ratio".
  static const IconData image_aspect_ratio = IconData(0xe3f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">import_contacts</i> &#x2014; material icon named "import contacts".
  static const IconData import_contacts = IconData(0xe0e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">import_export</i> &#x2014; material icon named "import export".
  static const IconData import_export = IconData(0xe0c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">important_devices</i> &#x2014; material icon named "important devices".
  static const IconData important_devices = IconData(0xe912, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">inbox</i> &#x2014; material icon named "inbox".
  static const IconData inbox = IconData(0xe156, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">indeterminate_check_box</i> &#x2014; material icon named "indeterminate check box".
  static const IconData indeterminate_check_box = IconData(0xe909, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">info</i> &#x2014; material icon named "info".
  static const IconData info = IconData(0xe88e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">info_outline</i> &#x2014; material icon named "info outline".
  static const IconData info_outline = IconData(0xe88f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">input</i> &#x2014; material icon named "input".
  static const IconData input = IconData(0xe890, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">insert_chart</i> &#x2014; material icon named "insert chart".
  static const IconData insert_chart = IconData(0xe24b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_comment</i> &#x2014; material icon named "insert comment".
  static const IconData insert_comment = IconData(0xe24c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_drive_file</i> &#x2014; material icon named "insert drive file".
  static const IconData insert_drive_file = IconData(0xe24d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_emoticon</i> &#x2014; material icon named "insert emoticon".
  static const IconData insert_emoticon = IconData(0xe24e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_invitation</i> &#x2014; material icon named "insert invitation".
  static const IconData insert_invitation = IconData(0xe24f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_link</i> &#x2014; material icon named "insert link".
  static const IconData insert_link = IconData(0xe250, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_photo</i> &#x2014; material icon named "insert photo".
  static const IconData insert_photo = IconData(0xe251, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">invert_colors</i> &#x2014; material icon named "invert colors".
  static const IconData invert_colors = IconData(0xe891, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">invert_colors_off</i> &#x2014; material icon named "invert colors off".
  static const IconData invert_colors_off = IconData(0xe0c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">iso</i> &#x2014; material icon named "iso".
  static const IconData iso = IconData(0xe3f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard</i> &#x2014; material icon named "keyboard".
  static const IconData keyboard = IconData(0xe312, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_down</i> &#x2014; material icon named "keyboard arrow down".
  static const IconData keyboard_arrow_down = IconData(0xe313, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_left</i> &#x2014; material icon named "keyboard arrow left".
  static const IconData keyboard_arrow_left = IconData(0xe314, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_right</i> &#x2014; material icon named "keyboard arrow right".
  static const IconData keyboard_arrow_right = IconData(0xe315, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_up</i> &#x2014; material icon named "keyboard arrow up".
  static const IconData keyboard_arrow_up = IconData(0xe316, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_backspace</i> &#x2014; material icon named "keyboard backspace".
  static const IconData keyboard_backspace = IconData(0xe317, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">keyboard_capslock</i> &#x2014; material icon named "keyboard capslock".
  static const IconData keyboard_capslock = IconData(0xe318, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_hide</i> &#x2014; material icon named "keyboard hide".
  static const IconData keyboard_hide = IconData(0xe31a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_return</i> &#x2014; material icon named "keyboard return".
  static const IconData keyboard_return = IconData(0xe31b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_tab</i> &#x2014; material icon named "keyboard tab".
  static const IconData keyboard_tab = IconData(0xe31c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">keyboard_voice</i> &#x2014; material icon named "keyboard voice".
  static const IconData keyboard_voice = IconData(0xe31d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">kitchen</i> &#x2014; material icon named "kitchen".
  static const IconData kitchen = IconData(0xeb47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">label</i> &#x2014; material icon named "label".
  static const IconData label = IconData(0xe892, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">label_important</i> &#x2014; material icon named "label important".
  static const IconData label_important = IconData(0xe937, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">label_outline</i> &#x2014; material icon named "label outline".
  static const IconData label_outline = IconData(0xe893, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">landscape</i> &#x2014; material icon named "landscape".
  static const IconData landscape = IconData(0xe3f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">language</i> &#x2014; material icon named "language".
  static const IconData language = IconData(0xe894, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop</i> &#x2014; material icon named "laptop".
  static const IconData laptop = IconData(0xe31e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop_chromebook</i> &#x2014; material icon named "laptop chromebook".
  static const IconData laptop_chromebook = IconData(0xe31f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop_mac</i> &#x2014; material icon named "laptop mac".
  static const IconData laptop_mac = IconData(0xe320, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop_windows</i> &#x2014; material icon named "laptop windows".
  static const IconData laptop_windows = IconData(0xe321, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">last_page</i> &#x2014; material icon named "last page".
  static const IconData last_page = IconData(0xe5dd, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">launch</i> &#x2014; material icon named "launch".
  static const IconData launch = IconData(0xe895, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">layers</i> &#x2014; material icon named "layers".
  static const IconData layers = IconData(0xe53b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">layers_clear</i> &#x2014; material icon named "layers clear".
  static const IconData layers_clear = IconData(0xe53c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leak_add</i> &#x2014; material icon named "leak add".
  static const IconData leak_add = IconData(0xe3f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leak_remove</i> &#x2014; material icon named "leak remove".
  static const IconData leak_remove = IconData(0xe3f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lens</i> &#x2014; material icon named "lens".
  static const IconData lens = IconData(0xe3fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_add</i> &#x2014; material icon named "library add".
  static const IconData library_add = IconData(0xe02e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_books</i> &#x2014; material icon named "library books".
  static const IconData library_books = IconData(0xe02f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_music</i> &#x2014; material icon named "library music".
  static const IconData library_music = IconData(0xe030, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lightbulb_outline</i> &#x2014; material icon named "lightbulb outline".
  static const IconData lightbulb_outline = IconData(0xe90f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">line_style</i> &#x2014; material icon named "line style".
  static const IconData line_style = IconData(0xe919, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">line_weight</i> &#x2014; material icon named "line weight".
  static const IconData line_weight = IconData(0xe91a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">linear_scale</i> &#x2014; material icon named "linear scale".
  static const IconData linear_scale = IconData(0xe260, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">link</i> &#x2014; material icon named "link".
  static const IconData link = IconData(0xe157, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">link_off</i> &#x2014; material icon named "link off".
  static const IconData link_off = IconData(0xe16f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">linked_camera</i> &#x2014; material icon named "linked camera".
  static const IconData linked_camera = IconData(0xe438, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">list</i> &#x2014; material icon named "list".
  static const IconData list = IconData(0xe896, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">live_help</i> &#x2014; material icon named "live help".
  static const IconData live_help = IconData(0xe0c6, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">live_tv</i> &#x2014; material icon named "live tv".
  static const IconData live_tv = IconData(0xe639, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_activity</i> &#x2014; material icon named "local activity".
  static const IconData local_activity = IconData(0xe53f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_airport</i> &#x2014; material icon named "local airport".
  static const IconData local_airport = IconData(0xe53d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_atm</i> &#x2014; material icon named "local atm".
  static const IconData local_atm = IconData(0xe53e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_bar</i> &#x2014; material icon named "local bar".
  static const IconData local_bar = IconData(0xe540, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_cafe</i> &#x2014; material icon named "local cafe".
  static const IconData local_cafe = IconData(0xe541, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_car_wash</i> &#x2014; material icon named "local car wash".
  static const IconData local_car_wash = IconData(0xe542, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_convenience_store</i> &#x2014; material icon named "local convenience store".
  static const IconData local_convenience_store = IconData(0xe543, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_dining</i> &#x2014; material icon named "local dining".
  static const IconData local_dining = IconData(0xe556, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_drink</i> &#x2014; material icon named "local drink".
  static const IconData local_drink = IconData(0xe544, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_florist</i> &#x2014; material icon named "local florist".
  static const IconData local_florist = IconData(0xe545, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_gas_station</i> &#x2014; material icon named "local gas station".
  static const IconData local_gas_station = IconData(0xe546, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_grocery_store</i> &#x2014; material icon named "local grocery store".
  static const IconData local_grocery_store = IconData(0xe547, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_hospital</i> &#x2014; material icon named "local hospital".
  static const IconData local_hospital = IconData(0xe548, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_hotel</i> &#x2014; material icon named "local hotel".
  static const IconData local_hotel = IconData(0xe549, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_laundry_service</i> &#x2014; material icon named "local laundry service".
  static const IconData local_laundry_service = IconData(0xe54a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_library</i> &#x2014; material icon named "local library".
  static const IconData local_library = IconData(0xe54b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_mall</i> &#x2014; material icon named "local mall".
  static const IconData local_mall = IconData(0xe54c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_movies</i> &#x2014; material icon named "local movies".
  static const IconData local_movies = IconData(0xe54d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_offer</i> &#x2014; material icon named "local offer".
  static const IconData local_offer = IconData(0xe54e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_parking</i> &#x2014; material icon named "local parking".
  static const IconData local_parking = IconData(0xe54f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_pharmacy</i> &#x2014; material icon named "local pharmacy".
  static const IconData local_pharmacy = IconData(0xe550, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_phone</i> &#x2014; material icon named "local phone".
  static const IconData local_phone = IconData(0xe551, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_pizza</i> &#x2014; material icon named "local pizza".
  static const IconData local_pizza = IconData(0xe552, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_play</i> &#x2014; material icon named "local play".
  static const IconData local_play = IconData(0xe553, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_post_office</i> &#x2014; material icon named "local post office".
  static const IconData local_post_office = IconData(0xe554, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_printshop</i> &#x2014; material icon named "local printshop".
  static const IconData local_printshop = IconData(0xe555, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_see</i> &#x2014; material icon named "local see".
  static const IconData local_see = IconData(0xe557, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_shipping</i> &#x2014; material icon named "local shipping".
  static const IconData local_shipping = IconData(0xe558, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_taxi</i> &#x2014; material icon named "local taxi".
  static const IconData local_taxi = IconData(0xe559, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_city</i> &#x2014; material icon named "location city".
  static const IconData location_city = IconData(0xe7f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_disabled</i> &#x2014; material icon named "location disabled".
  static const IconData location_disabled = IconData(0xe1b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_off</i> &#x2014; material icon named "location off".
  static const IconData location_off = IconData(0xe0c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_on</i> &#x2014; material icon named "location on".
  static const IconData location_on = IconData(0xe0c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_searching</i> &#x2014; material icon named "location searching".
  static const IconData location_searching = IconData(0xe1b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock</i> &#x2014; material icon named "lock".
  static const IconData lock = IconData(0xe897, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock_open</i> &#x2014; material icon named "lock open".
  static const IconData lock_open = IconData(0xe898, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock_outline</i> &#x2014; material icon named "lock outline".
  static const IconData lock_outline = IconData(0xe899, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks</i> &#x2014; material icon named "looks".
  static const IconData looks = IconData(0xe3fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_3</i> &#x2014; material icon named "looks 3".
  static const IconData looks_3 = IconData(0xe3fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_4</i> &#x2014; material icon named "looks 4".
  static const IconData looks_4 = IconData(0xe3fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_5</i> &#x2014; material icon named "looks 5".
  static const IconData looks_5 = IconData(0xe3fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_6</i> &#x2014; material icon named "looks 6".
  static const IconData looks_6 = IconData(0xe3ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_one</i> &#x2014; material icon named "looks one".
  static const IconData looks_one = IconData(0xe400, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_two</i> &#x2014; material icon named "looks two".
  static const IconData looks_two = IconData(0xe401, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">loop</i> &#x2014; material icon named "loop".
  static const IconData loop = IconData(0xe028, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">loupe</i> &#x2014; material icon named "loupe".
  static const IconData loupe = IconData(0xe402, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">low_priority</i> &#x2014; material icon named "low priority".
  static const IconData low_priority = IconData(0xe16d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">loyalty</i> &#x2014; material icon named "loyalty".
  static const IconData loyalty = IconData(0xe89a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mail</i> &#x2014; material icon named "mail".
  static const IconData mail = IconData(0xe158, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mail_outline</i> &#x2014; material icon named "mail outline".
  static const IconData mail_outline = IconData(0xe0e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">map</i> &#x2014; material icon named "map".
  static const IconData map = IconData(0xe55b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">markunread</i> &#x2014; material icon named "markunread".
  static const IconData markunread = IconData(0xe159, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">markunread_mailbox</i> &#x2014; material icon named "markunread mailbox".
  static const IconData markunread_mailbox = IconData(0xe89b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">maximize</i> &#x2014; material icon named "maximize".
  static const IconData maximize = IconData(0xe930, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">memory</i> &#x2014; material icon named "memory".
  static const IconData memory = IconData(0xe322, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">menu</i> &#x2014; material icon named "menu".
  static const IconData menu = IconData(0xe5d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">merge_type</i> &#x2014; material icon named "merge type".
  static const IconData merge_type = IconData(0xe252, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">message</i> &#x2014; material icon named "message".
  static const IconData message = IconData(0xe0c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic</i> &#x2014; material icon named "mic".
  static const IconData mic = IconData(0xe029, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_none</i> &#x2014; material icon named "mic none".
  static const IconData mic_none = IconData(0xe02a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_off</i> &#x2014; material icon named "mic off".
  static const IconData mic_off = IconData(0xe02b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">minimize</i> &#x2014; material icon named "minimize".
  static const IconData minimize = IconData(0xe931, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">missed_video_call</i> &#x2014; material icon named "missed video call".
  static const IconData missed_video_call = IconData(0xe073, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mms</i> &#x2014; material icon named "mms".
  static const IconData mms = IconData(0xe618, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mobile_screen_share</i> &#x2014; material icon named "mobile screen share".
  static const IconData mobile_screen_share = IconData(0xe0e7, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">mode_comment</i> &#x2014; material icon named "mode comment".
  static const IconData mode_comment = IconData(0xe253, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mode_edit</i> &#x2014; material icon named "mode edit".
  static const IconData mode_edit = IconData(0xe254, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">monetization_on</i> &#x2014; material icon named "monetization on".
  static const IconData monetization_on = IconData(0xe263, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">money_off</i> &#x2014; material icon named "money off".
  static const IconData money_off = IconData(0xe25c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">monochrome_photos</i> &#x2014; material icon named "monochrome photos".
  static const IconData monochrome_photos = IconData(0xe403, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mood</i> &#x2014; material icon named "mood".
  static const IconData mood = IconData(0xe7f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mood_bad</i> &#x2014; material icon named "mood bad".
  static const IconData mood_bad = IconData(0xe7f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more</i> &#x2014; material icon named "more".
  static const IconData more = IconData(0xe619, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more_horiz</i> &#x2014; material icon named "more horiz".
  static const IconData more_horiz = IconData(0xe5d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more_vert</i> &#x2014; material icon named "more vert".
  static const IconData more_vert = IconData(0xe5d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motorcycle</i> &#x2014; material icon named "motorcycle".
  static const IconData motorcycle = IconData(0xe91b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mouse</i> &#x2014; material icon named "mouse".
  static const IconData mouse = IconData(0xe323, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">move_to_inbox</i> &#x2014; material icon named "move to inbox".
  static const IconData move_to_inbox = IconData(0xe168, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">movie</i> &#x2014; material icon named "movie".
  static const IconData movie = IconData(0xe02c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">movie_creation</i> &#x2014; material icon named "movie creation".
  static const IconData movie_creation = IconData(0xe404, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">movie_filter</i> &#x2014; material icon named "movie filter".
  static const IconData movie_filter = IconData(0xe43a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">multiline_chart</i> &#x2014; material icon named "multiline chart".
  static const IconData multiline_chart = IconData(0xe6df, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">music_note</i> &#x2014; material icon named "music note".
  static const IconData music_note = IconData(0xe405, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">music_video</i> &#x2014; material icon named "music video".
  static const IconData music_video = IconData(0xe063, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">my_location</i> &#x2014; material icon named "my location".
  static const IconData my_location = IconData(0xe55c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nature</i> &#x2014; material icon named "nature".
  static const IconData nature = IconData(0xe406, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nature_people</i> &#x2014; material icon named "nature people".
  static const IconData nature_people = IconData(0xe407, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">navigate_before</i> &#x2014; material icon named "navigate before".
  static const IconData navigate_before = IconData(0xe408, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">navigate_next</i> &#x2014; material icon named "navigate next".
  static const IconData navigate_next = IconData(0xe409, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">navigation</i> &#x2014; material icon named "navigation".
  static const IconData navigation = IconData(0xe55d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">near_me</i> &#x2014; material icon named "near me".
  static const IconData near_me = IconData(0xe569, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_cell</i> &#x2014; material icon named "network cell".
  static const IconData network_cell = IconData(0xe1b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_check</i> &#x2014; material icon named "network check".
  static const IconData network_check = IconData(0xe640, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_locked</i> &#x2014; material icon named "network locked".
  static const IconData network_locked = IconData(0xe61a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_wifi</i> &#x2014; material icon named "network wifi".
  static const IconData network_wifi = IconData(0xe1ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">new_releases</i> &#x2014; material icon named "new releases".
  static const IconData new_releases = IconData(0xe031, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">next_week</i> &#x2014; material icon named "next week".
  static const IconData next_week = IconData(0xe16a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">nfc</i> &#x2014; material icon named "nfc".
  static const IconData nfc = IconData(0xe1bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_encryption</i> &#x2014; material icon named "no encryption".
  static const IconData no_encryption = IconData(0xe641, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_sim</i> &#x2014; material icon named "no sim".
  static const IconData no_sim = IconData(0xe0cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_interested</i> &#x2014; material icon named "not interested".
  static const IconData not_interested = IconData(0xe033, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_listed_location</i> &#x2014; material icon named "not listed location".
  static const IconData not_listed_location = IconData(0xe575, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">note</i> &#x2014; material icon named "note".
  static const IconData note = IconData(0xe06f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">note_add</i> &#x2014; material icon named "note add".
  static const IconData note_add = IconData(0xe89c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notification_important</i> &#x2014; material icon named "notification important".
  static const IconData notification_important = IconData(0xe004, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications</i> &#x2014; material icon named "notifications".
  static const IconData notifications = IconData(0xe7f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_active</i> &#x2014; material icon named "notifications active".
  static const IconData notifications_active = IconData(0xe7f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_none</i> &#x2014; material icon named "notifications none".
  static const IconData notifications_none = IconData(0xe7f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_off</i> &#x2014; material icon named "notifications off".
  static const IconData notifications_off = IconData(0xe7f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_paused</i> &#x2014; material icon named "notifications paused".
  static const IconData notifications_paused = IconData(0xe7f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">offline_bolt</i> &#x2014; material icon named "offline bolt".
  static const IconData offline_bolt = IconData(0xe932, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">offline_pin</i> &#x2014; material icon named "offline pin".
  static const IconData offline_pin = IconData(0xe90a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ondemand_video</i> &#x2014; material icon named "ondemand video".
  static const IconData ondemand_video = IconData(0xe63a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">opacity</i> &#x2014; material icon named "opacity".
  static const IconData opacity = IconData(0xe91c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_in_browser</i> &#x2014; material icon named "open in browser".
  static const IconData open_in_browser = IconData(0xe89d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_in_new</i> &#x2014; material icon named "open in new".
  static const IconData open_in_new = IconData(0xe89e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">open_with</i> &#x2014; material icon named "open with".
  static const IconData open_with = IconData(0xe89f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outlined_flag</i> &#x2014; material icon named "outlined flag".
  static const IconData outlined_flag = IconData(0xe16e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pages</i> &#x2014; material icon named "pages".
  static const IconData pages = IconData(0xe7f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pageview</i> &#x2014; material icon named "pageview".
  static const IconData pageview = IconData(0xe8a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">palette</i> &#x2014; material icon named "palette".
  static const IconData palette = IconData(0xe40a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pan_tool</i> &#x2014; material icon named "pan tool".
  static const IconData pan_tool = IconData(0xe925, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama</i> &#x2014; material icon named "panorama".
  static const IconData panorama = IconData(0xe40b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_fish_eye</i> &#x2014; material icon named "panorama fish eye".
  static const IconData panorama_fish_eye = IconData(0xe40c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_horizontal</i> &#x2014; material icon named "panorama horizontal".
  static const IconData panorama_horizontal = IconData(0xe40d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_vertical</i> &#x2014; material icon named "panorama vertical".
  static const IconData panorama_vertical = IconData(0xe40e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_wide_angle</i> &#x2014; material icon named "panorama wide angle".
  static const IconData panorama_wide_angle = IconData(0xe40f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">party_mode</i> &#x2014; material icon named "party mode".
  static const IconData party_mode = IconData(0xe7fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause</i> &#x2014; material icon named "pause".
  static const IconData pause = IconData(0xe034, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause_circle_filled</i> &#x2014; material icon named "pause circle filled".
  static const IconData pause_circle_filled = IconData(0xe035, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause_circle_outline</i> &#x2014; material icon named "pause circle outline".
  static const IconData pause_circle_outline = IconData(0xe036, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">payment</i> &#x2014; material icon named "payment".
  static const IconData payment = IconData(0xe8a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">people</i> &#x2014; material icon named "people".
  static const IconData people = IconData(0xe7fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">people_outline</i> &#x2014; material icon named "people outline".
  static const IconData people_outline = IconData(0xe7fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_camera_mic</i> &#x2014; material icon named "perm camera mic".
  static const IconData perm_camera_mic = IconData(0xe8a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_contact_calendar</i> &#x2014; material icon named "perm contact calendar".
  static const IconData perm_contact_calendar = IconData(0xe8a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_data_setting</i> &#x2014; material icon named "perm data setting".
  static const IconData perm_data_setting = IconData(0xe8a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_device_information</i> &#x2014; material icon named "perm device information".
  static const IconData perm_device_information = IconData(0xe8a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_identity</i> &#x2014; material icon named "perm identity".
  static const IconData perm_identity = IconData(0xe8a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_media</i> &#x2014; material icon named "perm media".
  static const IconData perm_media = IconData(0xe8a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_phone_msg</i> &#x2014; material icon named "perm phone msg".
  static const IconData perm_phone_msg = IconData(0xe8a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_scan_wifi</i> &#x2014; material icon named "perm scan wifi".
  static const IconData perm_scan_wifi = IconData(0xe8a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person</i> &#x2014; material icon named "person".
  static const IconData person = IconData(0xe7fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_add</i> &#x2014; material icon named "person add".
  static const IconData person_add = IconData(0xe7fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_outline</i> &#x2014; material icon named "person outline".
  static const IconData person_outline = IconData(0xe7ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_pin</i> &#x2014; material icon named "person pin".
  static const IconData person_pin = IconData(0xe55a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_pin_circle</i> &#x2014; material icon named "person pin circle".
  static const IconData person_pin_circle = IconData(0xe56a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">personal_video</i> &#x2014; material icon named "personal video".
  static const IconData personal_video = IconData(0xe63b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pets</i> &#x2014; material icon named "pets".
  static const IconData pets = IconData(0xe91d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone</i> &#x2014; material icon named "phone".
  static const IconData phone = IconData(0xe0cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_android</i> &#x2014; material icon named "phone android".
  static const IconData phone_android = IconData(0xe324, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_bluetooth_speaker</i> &#x2014; material icon named "phone bluetooth speaker".
  static const IconData phone_bluetooth_speaker = IconData(0xe61b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_forwarded</i> &#x2014; material icon named "phone forwarded".
  static const IconData phone_forwarded = IconData(0xe61c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_in_talk</i> &#x2014; material icon named "phone in talk".
  static const IconData phone_in_talk = IconData(0xe61d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_iphone</i> &#x2014; material icon named "phone iphone".
  static const IconData phone_iphone = IconData(0xe325, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_locked</i> &#x2014; material icon named "phone locked".
  static const IconData phone_locked = IconData(0xe61e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_missed</i> &#x2014; material icon named "phone missed".
  static const IconData phone_missed = IconData(0xe61f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phone_paused</i> &#x2014; material icon named "phone paused".
  static const IconData phone_paused = IconData(0xe620, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink</i> &#x2014; material icon named "phonelink".
  static const IconData phonelink = IconData(0xe326, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_erase</i> &#x2014; material icon named "phonelink erase".
  static const IconData phonelink_erase = IconData(0xe0db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_lock</i> &#x2014; material icon named "phonelink lock".
  static const IconData phonelink_lock = IconData(0xe0dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_off</i> &#x2014; material icon named "phonelink off".
  static const IconData phonelink_off = IconData(0xe327, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_ring</i> &#x2014; material icon named "phonelink ring".
  static const IconData phonelink_ring = IconData(0xe0dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">phonelink_setup</i> &#x2014; material icon named "phonelink setup".
  static const IconData phonelink_setup = IconData(0xe0de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo</i> &#x2014; material icon named "photo".
  static const IconData photo = IconData(0xe410, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_album</i> &#x2014; material icon named "photo album".
  static const IconData photo_album = IconData(0xe411, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_camera</i> &#x2014; material icon named "photo camera".
  static const IconData photo_camera = IconData(0xe412, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_filter</i> &#x2014; material icon named "photo filter".
  static const IconData photo_filter = IconData(0xe43b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_library</i> &#x2014; material icon named "photo library".
  static const IconData photo_library = IconData(0xe413, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_size_select_actual</i> &#x2014; material icon named "photo size select actual".
  static const IconData photo_size_select_actual = IconData(0xe432, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_size_select_large</i> &#x2014; material icon named "photo size select large".
  static const IconData photo_size_select_large = IconData(0xe433, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">photo_size_select_small</i> &#x2014; material icon named "photo size select small".
  static const IconData photo_size_select_small = IconData(0xe434, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">picture_as_pdf</i> &#x2014; material icon named "picture as pdf".
  static const IconData picture_as_pdf = IconData(0xe415, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">picture_in_picture</i> &#x2014; material icon named "picture in picture".
  static const IconData picture_in_picture = IconData(0xe8aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">picture_in_picture_alt</i> &#x2014; material icon named "picture in picture alt".
  static const IconData picture_in_picture_alt = IconData(0xe911, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pie_chart</i> &#x2014; material icon named "pie chart".
  static const IconData pie_chart = IconData(0xe6c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pie_chart_outlined</i> &#x2014; material icon named "pie chart outlined".
  static const IconData pie_chart_outlined = IconData(0xe6c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pin_drop</i> &#x2014; material icon named "pin drop".
  static const IconData pin_drop = IconData(0xe55e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">place</i> &#x2014; material icon named "place".
  static const IconData place = IconData(0xe55f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_arrow</i> &#x2014; material icon named "play arrow".
  static const IconData play_arrow = IconData(0xe037, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_circle_filled</i> &#x2014; material icon named "play circle filled".
  static const IconData play_circle_filled = IconData(0xe038, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_circle_outline</i> &#x2014; material icon named "play circle outline".
  static const IconData play_circle_outline = IconData(0xe039, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">play_for_work</i> &#x2014; material icon named "play for work".
  static const IconData play_for_work = IconData(0xe906, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">playlist_add</i> &#x2014; material icon named "playlist add".
  static const IconData playlist_add = IconData(0xe03b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">playlist_add_check</i> &#x2014; material icon named "playlist add check".
  static const IconData playlist_add_check = IconData(0xe065, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">playlist_play</i> &#x2014; material icon named "playlist play".
  static const IconData playlist_play = IconData(0xe05f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">plus_one</i> &#x2014; material icon named "plus one".
  static const IconData plus_one = IconData(0xe800, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">poll</i> &#x2014; material icon named "poll".
  static const IconData poll = IconData(0xe801, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">polymer</i> &#x2014; material icon named "polymer".
  static const IconData polymer = IconData(0xe8ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pool</i> &#x2014; material icon named "pool".
  static const IconData pool = IconData(0xeb48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">portable_wifi_off</i> &#x2014; material icon named "portable wifi off".
  static const IconData portable_wifi_off = IconData(0xe0ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">portrait</i> &#x2014; material icon named "portrait".
  static const IconData portrait = IconData(0xe416, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">power</i> &#x2014; material icon named "power".
  static const IconData power = IconData(0xe63c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">power_input</i> &#x2014; material icon named "power input".
  static const IconData power_input = IconData(0xe336, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">power_settings_new</i> &#x2014; material icon named "power settings new".
  static const IconData power_settings_new = IconData(0xe8ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pregnant_woman</i> &#x2014; material icon named "pregnant woman".
  static const IconData pregnant_woman = IconData(0xe91e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">present_to_all</i> &#x2014; material icon named "present to all".
  static const IconData present_to_all = IconData(0xe0df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">print</i> &#x2014; material icon named "print".
  static const IconData print = IconData(0xe8ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">priority_high</i> &#x2014; material icon named "priority high".
  static const IconData priority_high = IconData(0xe645, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">public</i> &#x2014; material icon named "public".
  static const IconData public = IconData(0xe80b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">publish</i> &#x2014; material icon named "publish".
  static const IconData publish = IconData(0xe255, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">query_builder</i> &#x2014; material icon named "query builder".
  static const IconData query_builder = IconData(0xe8ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">question_answer</i> &#x2014; material icon named "question answer".
  static const IconData question_answer = IconData(0xe8af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">queue</i> &#x2014; material icon named "queue".
  static const IconData queue = IconData(0xe03c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">queue_music</i> &#x2014; material icon named "queue music".
  static const IconData queue_music = IconData(0xe03d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">queue_play_next</i> &#x2014; material icon named "queue play next".
  static const IconData queue_play_next = IconData(0xe066, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">radio</i> &#x2014; material icon named "radio".
  static const IconData radio = IconData(0xe03e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">radio_button_checked</i> &#x2014; material icon named "radio button checked".
  static const IconData radio_button_checked = IconData(0xe837, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">radio_button_unchecked</i> &#x2014; material icon named "radio button unchecked".
  static const IconData radio_button_unchecked = IconData(0xe836, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rate_review</i> &#x2014; material icon named "rate review".
  static const IconData rate_review = IconData(0xe560, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">receipt</i> &#x2014; material icon named "receipt".
  static const IconData receipt = IconData(0xe8b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">recent_actors</i> &#x2014; material icon named "recent actors".
  static const IconData recent_actors = IconData(0xe03f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">record_voice_over</i> &#x2014; material icon named "record voice over".
  static const IconData record_voice_over = IconData(0xe91f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">redeem</i> &#x2014; material icon named "redeem".
  static const IconData redeem = IconData(0xe8b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">redo</i> &#x2014; material icon named "redo".
  static const IconData redo = IconData(0xe15a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">refresh</i> &#x2014; material icon named "refresh".
  static const IconData refresh = IconData(0xe5d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove</i> &#x2014; material icon named "remove".
  static const IconData remove = IconData(0xe15b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_circle</i> &#x2014; material icon named "remove circle".
  static const IconData remove_circle = IconData(0xe15c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_circle_outline</i> &#x2014; material icon named "remove circle outline".
  static const IconData remove_circle_outline = IconData(0xe15d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_from_queue</i> &#x2014; material icon named "remove from queue".
  static const IconData remove_from_queue = IconData(0xe067, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_red_eye</i> &#x2014; material icon named "remove red eye".
  static const IconData remove_red_eye = IconData(0xe417, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">remove_shopping_cart</i> &#x2014; material icon named "remove shopping cart".
  static const IconData remove_shopping_cart = IconData(0xe928, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">reorder</i> &#x2014; material icon named "reorder".
  static const IconData reorder = IconData(0xe8fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">repeat</i> &#x2014; material icon named "repeat".
  static const IconData repeat = IconData(0xe040, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">repeat_one</i> &#x2014; material icon named "repeat one".
  static const IconData repeat_one = IconData(0xe041, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">replay</i> &#x2014; material icon named "replay".
  static const IconData replay = IconData(0xe042, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">replay_10</i> &#x2014; material icon named "replay 10".
  static const IconData replay_10 = IconData(0xe059, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">replay_30</i> &#x2014; material icon named "replay 30".
  static const IconData replay_30 = IconData(0xe05a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">replay_5</i> &#x2014; material icon named "replay 5".
  static const IconData replay_5 = IconData(0xe05b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">reply</i> &#x2014; material icon named "reply".
  static const IconData reply = IconData(0xe15e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">reply_all</i> &#x2014; material icon named "reply all".
  static const IconData reply_all = IconData(0xe15f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">report</i> &#x2014; material icon named "report".
  static const IconData report = IconData(0xe160, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">report_off</i> &#x2014; material icon named "report off".
  static const IconData report_off = IconData(0xe170, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">report_problem</i> &#x2014; material icon named "report problem".
  static const IconData report_problem = IconData(0xe8b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restaurant</i> &#x2014; material icon named "restaurant".
  static const IconData restaurant = IconData(0xe56c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restaurant_menu</i> &#x2014; material icon named "restaurant menu".
  static const IconData restaurant_menu = IconData(0xe561, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restore</i> &#x2014; material icon named "restore".
  static const IconData restore = IconData(0xe8b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restore_from_trash</i> &#x2014; material icon named "restore from trash".
  static const IconData restore_from_trash = IconData(0xe938, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">restore_page</i> &#x2014; material icon named "restore page".
  static const IconData restore_page = IconData(0xe929, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ring_volume</i> &#x2014; material icon named "ring volume".
  static const IconData ring_volume = IconData(0xe0d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">room</i> &#x2014; material icon named "room".
  static const IconData room = IconData(0xe8b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">room_service</i> &#x2014; material icon named "room service".
  static const IconData room_service = IconData(0xeb49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rotate_90_degrees_ccw</i> &#x2014; material icon named "rotate 90 degrees ccw".
  static const IconData rotate_90_degrees_ccw = IconData(0xe418, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rotate_left</i> &#x2014; material icon named "rotate left".
  static const IconData rotate_left = IconData(0xe419, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rotate_right</i> &#x2014; material icon named "rotate right".
  static const IconData rotate_right = IconData(0xe41a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rounded_corner</i> &#x2014; material icon named "rounded corner".
  static const IconData rounded_corner = IconData(0xe920, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">router</i> &#x2014; material icon named "router".
  static const IconData router = IconData(0xe328, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rowing</i> &#x2014; material icon named "rowing".
  static const IconData rowing = IconData(0xe921, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rss_feed</i> &#x2014; material icon named "rss feed".
  static const IconData rss_feed = IconData(0xe0e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">rv_hookup</i> &#x2014; material icon named "rv hookup".
  static const IconData rv_hookup = IconData(0xe642, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">satellite</i> &#x2014; material icon named "satellite".
  static const IconData satellite = IconData(0xe562, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">save</i> &#x2014; material icon named "save".
  static const IconData save = IconData(0xe161, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">save_alt</i> &#x2014; material icon named "save alt".
  static const IconData save_alt = IconData(0xe171, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">scanner</i> &#x2014; material icon named "scanner".
  static const IconData scanner = IconData(0xe329, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">scatter_plot</i> &#x2014; material icon named "scatter plot".
  static const IconData scatter_plot = IconData(0xe268, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">schedule</i> &#x2014; material icon named "schedule".
  static const IconData schedule = IconData(0xe8b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">school</i> &#x2014; material icon named "school".
  static const IconData school = IconData(0xe80c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">score</i> &#x2014; material icon named "score".
  static const IconData score = IconData(0xe269, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_lock_landscape</i> &#x2014; material icon named "screen lock landscape".
  static const IconData screen_lock_landscape = IconData(0xe1be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_lock_portrait</i> &#x2014; material icon named "screen lock portrait".
  static const IconData screen_lock_portrait = IconData(0xe1bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_lock_rotation</i> &#x2014; material icon named "screen lock rotation".
  static const IconData screen_lock_rotation = IconData(0xe1c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_rotation</i> &#x2014; material icon named "screen rotation".
  static const IconData screen_rotation = IconData(0xe1c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">screen_share</i> &#x2014; material icon named "screen share".
  static const IconData screen_share = IconData(0xe0e2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">sd_card</i> &#x2014; material icon named "sd card".
  static const IconData sd_card = IconData(0xe623, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sd_storage</i> &#x2014; material icon named "sd storage".
  static const IconData sd_storage = IconData(0xe1c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">search</i> &#x2014; material icon named "search".
  static const IconData search = IconData(0xe8b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">security</i> &#x2014; material icon named "security".
  static const IconData security = IconData(0xe32a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">select_all</i> &#x2014; material icon named "select all".
  static const IconData select_all = IconData(0xe162, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">send</i> &#x2014; material icon named "send".
  static const IconData send = IconData(0xe163, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">sentiment_dissatisfied</i> &#x2014; material icon named "sentiment dissatisfied".
  static const IconData sentiment_dissatisfied = IconData(0xe811, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_neutral</i> &#x2014; material icon named "sentiment neutral".
  static const IconData sentiment_neutral = IconData(0xe812, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_satisfied</i> &#x2014; material icon named "sentiment satisfied".
  static const IconData sentiment_satisfied = IconData(0xe813, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_very_dissatisfied</i> &#x2014; material icon named "sentiment very dissatisfied".
  static const IconData sentiment_very_dissatisfied = IconData(0xe814, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sentiment_very_satisfied</i> &#x2014; material icon named "sentiment very satisfied".
  static const IconData sentiment_very_satisfied = IconData(0xe815, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings</i> &#x2014; material icon named "settings".
  static const IconData settings = IconData(0xe8b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_applications</i> &#x2014; material icon named "settings applications".
  static const IconData settings_applications = IconData(0xe8b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_backup_restore</i> &#x2014; material icon named "settings backup restore".
  static const IconData settings_backup_restore = IconData(0xe8ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_bluetooth</i> &#x2014; material icon named "settings bluetooth".
  static const IconData settings_bluetooth = IconData(0xe8bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_brightness</i> &#x2014; material icon named "settings brightness".
  static const IconData settings_brightness = IconData(0xe8bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_cell</i> &#x2014; material icon named "settings cell".
  static const IconData settings_cell = IconData(0xe8bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_ethernet</i> &#x2014; material icon named "settings ethernet".
  static const IconData settings_ethernet = IconData(0xe8be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_antenna</i> &#x2014; material icon named "settings input antenna".
  static const IconData settings_input_antenna = IconData(0xe8bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_component</i> &#x2014; material icon named "settings input component".
  static const IconData settings_input_component = IconData(0xe8c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_composite</i> &#x2014; material icon named "settings input composite".
  static const IconData settings_input_composite = IconData(0xe8c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_hdmi</i> &#x2014; material icon named "settings input hdmi".
  static const IconData settings_input_hdmi = IconData(0xe8c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_input_svideo</i> &#x2014; material icon named "settings input svideo".
  static const IconData settings_input_svideo = IconData(0xe8c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_overscan</i> &#x2014; material icon named "settings overscan".
  static const IconData settings_overscan = IconData(0xe8c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_phone</i> &#x2014; material icon named "settings phone".
  static const IconData settings_phone = IconData(0xe8c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_power</i> &#x2014; material icon named "settings power".
  static const IconData settings_power = IconData(0xe8c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_remote</i> &#x2014; material icon named "settings remote".
  static const IconData settings_remote = IconData(0xe8c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_system_daydream</i> &#x2014; material icon named "settings system daydream".
  static const IconData settings_system_daydream = IconData(0xe1c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">settings_voice</i> &#x2014; material icon named "settings voice".
  static const IconData settings_voice = IconData(0xe8c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">share</i> &#x2014; material icon named "share".
  static const IconData share = IconData(0xe80d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shop</i> &#x2014; material icon named "shop".
  static const IconData shop = IconData(0xe8c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shop_two</i> &#x2014; material icon named "shop two".
  static const IconData shop_two = IconData(0xe8ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shopping_basket</i> &#x2014; material icon named "shopping basket".
  static const IconData shopping_basket = IconData(0xe8cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shopping_cart</i> &#x2014; material icon named "shopping cart".
  static const IconData shopping_cart = IconData(0xe8cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">short_text</i> &#x2014; material icon named "short text".
  static const IconData short_text = IconData(0xe261, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">show_chart</i> &#x2014; material icon named "show chart".
  static const IconData show_chart = IconData(0xe6e1, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">shuffle</i> &#x2014; material icon named "shuffle".
  static const IconData shuffle = IconData(0xe043, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">shutter_speed</i> &#x2014; material icon named "shutter speed".
  static const IconData shutter_speed = IconData(0xe43d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_4_bar</i> &#x2014; material icon named "signal cellular 4 bar".
  static const IconData signal_cellular_4_bar = IconData(0xe1c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_connected_no_internet_4_bar</i> &#x2014; material icon named "signal cellular connected no internet 4 bar".
  static const IconData signal_cellular_connected_no_internet_4_bar = IconData(0xe1cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_no_sim</i> &#x2014; material icon named "signal cellular no sim".
  static const IconData signal_cellular_no_sim = IconData(0xe1ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_null</i> &#x2014; material icon named "signal cellular null".
  static const IconData signal_cellular_null = IconData(0xe1cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_cellular_off</i> &#x2014; material icon named "signal cellular off".
  static const IconData signal_cellular_off = IconData(0xe1d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_wifi_4_bar</i> &#x2014; material icon named "signal wifi 4 bar".
  static const IconData signal_wifi_4_bar = IconData(0xe1d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_wifi_4_bar_lock</i> &#x2014; material icon named "signal wifi 4 bar lock".
  static const IconData signal_wifi_4_bar_lock = IconData(0xe1d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">signal_wifi_off</i> &#x2014; material icon named "signal wifi off".
  static const IconData signal_wifi_off = IconData(0xe1da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sim_card</i> &#x2014; material icon named "sim card".
  static const IconData sim_card = IconData(0xe32b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sim_card_alert</i> &#x2014; material icon named "sim card alert".
  static const IconData sim_card_alert = IconData(0xe624, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">skip_next</i> &#x2014; material icon named "skip next".
  static const IconData skip_next = IconData(0xe044, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">skip_previous</i> &#x2014; material icon named "skip previous".
  static const IconData skip_previous = IconData(0xe045, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">slideshow</i> &#x2014; material icon named "slideshow".
  static const IconData slideshow = IconData(0xe41b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">slow_motion_video</i> &#x2014; material icon named "slow motion video".
  static const IconData slow_motion_video = IconData(0xe068, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">smartphone</i> &#x2014; material icon named "smartphone".
  static const IconData smartphone = IconData(0xe32c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">smoke_free</i> &#x2014; material icon named "smoke free".
  static const IconData smoke_free = IconData(0xeb4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">smoking_rooms</i> &#x2014; material icon named "smoking rooms".
  static const IconData smoking_rooms = IconData(0xeb4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sms</i> &#x2014; material icon named "sms".
  static const IconData sms = IconData(0xe625, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sms_failed</i> &#x2014; material icon named "sms failed".
  static const IconData sms_failed = IconData(0xe626, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">snooze</i> &#x2014; material icon named "snooze".
  static const IconData snooze = IconData(0xe046, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sort</i> &#x2014; material icon named "sort".
  static const IconData sort = IconData(0xe164, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">sort_by_alpha</i> &#x2014; material icon named "sort by alpha".
  static const IconData sort_by_alpha = IconData(0xe053, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">spa</i> &#x2014; material icon named "spa".
  static const IconData spa = IconData(0xeb4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">space_bar</i> &#x2014; material icon named "space bar".
  static const IconData space_bar = IconData(0xe256, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker</i> &#x2014; material icon named "speaker".
  static const IconData speaker = IconData(0xe32d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker_group</i> &#x2014; material icon named "speaker group".
  static const IconData speaker_group = IconData(0xe32e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker_notes</i> &#x2014; material icon named "speaker notes".
  static const IconData speaker_notes = IconData(0xe8cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker_notes_off</i> &#x2014; material icon named "speaker notes off".
  static const IconData speaker_notes_off = IconData(0xe92a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">speaker_phone</i> &#x2014; material icon named "speaker phone".
  static const IconData speaker_phone = IconData(0xe0d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">spellcheck</i> &#x2014; material icon named "spellcheck".
  static const IconData spellcheck = IconData(0xe8ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">star</i> &#x2014; material icon named "star".
  static const IconData star = IconData(0xe838, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">star_border</i> &#x2014; material icon named "star border".
  static const IconData star_border = IconData(0xe83a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">star_half</i> &#x2014; material icon named "star half".
  static const IconData star_half = IconData(0xe839, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">stars</i> &#x2014; material icon named "stars".
  static const IconData stars = IconData(0xe8d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stay_current_landscape</i> &#x2014; material icon named "stay current landscape".
  static const IconData stay_current_landscape = IconData(0xe0d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stay_current_portrait</i> &#x2014; material icon named "stay current portrait".
  static const IconData stay_current_portrait = IconData(0xe0d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stay_primary_landscape</i> &#x2014; material icon named "stay primary landscape".
  static const IconData stay_primary_landscape = IconData(0xe0d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stay_primary_portrait</i> &#x2014; material icon named "stay primary portrait".
  static const IconData stay_primary_portrait = IconData(0xe0d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stop</i> &#x2014; material icon named "stop".
  static const IconData stop = IconData(0xe047, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">stop_screen_share</i> &#x2014; material icon named "stop screen share".
  static const IconData stop_screen_share = IconData(0xe0e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">storage</i> &#x2014; material icon named "storage".
  static const IconData storage = IconData(0xe1db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">store</i> &#x2014; material icon named "store".
  static const IconData store = IconData(0xe8d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">store_mall_directory</i> &#x2014; material icon named "store mall directory".
  static const IconData store_mall_directory = IconData(0xe563, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">straighten</i> &#x2014; material icon named "straighten".
  static const IconData straighten = IconData(0xe41c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">streetview</i> &#x2014; material icon named "streetview".
  static const IconData streetview = IconData(0xe56e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">strikethrough_s</i> &#x2014; material icon named "strikethrough s".
  static const IconData strikethrough_s = IconData(0xe257, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">style</i> &#x2014; material icon named "style".
  static const IconData style = IconData(0xe41d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">subdirectory_arrow_left</i> &#x2014; material icon named "subdirectory arrow left".
  static const IconData subdirectory_arrow_left = IconData(0xe5d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">subdirectory_arrow_right</i> &#x2014; material icon named "subdirectory arrow right".
  static const IconData subdirectory_arrow_right = IconData(0xe5da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">subject</i> &#x2014; material icon named "subject".
  static const IconData subject = IconData(0xe8d2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">subscriptions</i> &#x2014; material icon named "subscriptions".
  static const IconData subscriptions = IconData(0xe064, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">subtitles</i> &#x2014; material icon named "subtitles".
  static const IconData subtitles = IconData(0xe048, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">subway</i> &#x2014; material icon named "subway".
  static const IconData subway = IconData(0xe56f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">supervised_user_circle</i> &#x2014; material icon named "supervised user circle".
  static const IconData supervised_user_circle = IconData(0xe939, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">supervisor_account</i> &#x2014; material icon named "supervisor account".
  static const IconData supervisor_account = IconData(0xe8d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">surround_sound</i> &#x2014; material icon named "surround sound".
  static const IconData surround_sound = IconData(0xe049, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">swap_calls</i> &#x2014; material icon named "swap calls".
  static const IconData swap_calls = IconData(0xe0d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">swap_horiz</i> &#x2014; material icon named "swap horiz".
  static const IconData swap_horiz = IconData(0xe8d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">swap_horizontal_circle</i> &#x2014; material icon named "swap horizontal circle".
  static const IconData swap_horizontal_circle = IconData(0xe933, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">swap_vert</i> &#x2014; material icon named "swap vert".
  static const IconData swap_vert = IconData(0xe8d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">swap_vertical_circle</i> &#x2014; material icon named "swap vertical circle".
  static const IconData swap_vertical_circle = IconData(0xe8d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">switch_camera</i> &#x2014; material icon named "switch camera".
  static const IconData switch_camera = IconData(0xe41e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">switch_video</i> &#x2014; material icon named "switch video".
  static const IconData switch_video = IconData(0xe41f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sync</i> &#x2014; material icon named "sync".
  static const IconData sync = IconData(0xe627, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sync_disabled</i> &#x2014; material icon named "sync disabled".
  static const IconData sync_disabled = IconData(0xe628, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">sync_problem</i> &#x2014; material icon named "sync problem".
  static const IconData sync_problem = IconData(0xe629, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">system_update</i> &#x2014; material icon named "system update".
  static const IconData system_update = IconData(0xe62a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">system_update_alt</i> &#x2014; material icon named "system update alt".
  static const IconData system_update_alt = IconData(0xe8d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tab</i> &#x2014; material icon named "tab".
  static const IconData tab = IconData(0xe8d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tab_unselected</i> &#x2014; material icon named "tab unselected".
  static const IconData tab_unselected = IconData(0xe8d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">table_chart</i> &#x2014; material icon named "table chart".
  static const IconData table_chart = IconData(0xe265, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tablet</i> &#x2014; material icon named "tablet".
  static const IconData tablet = IconData(0xe32f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tablet_android</i> &#x2014; material icon named "tablet android".
  static const IconData tablet_android = IconData(0xe330, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tablet_mac</i> &#x2014; material icon named "tablet mac".
  static const IconData tablet_mac = IconData(0xe331, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tag_faces</i> &#x2014; material icon named "tag faces".
  static const IconData tag_faces = IconData(0xe420, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tap_and_play</i> &#x2014; material icon named "tap and play".
  static const IconData tap_and_play = IconData(0xe62b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">terrain</i> &#x2014; material icon named "terrain".
  static const IconData terrain = IconData(0xe564, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">text_fields</i> &#x2014; material icon named "text fields".
  static const IconData text_fields = IconData(0xe262, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">text_format</i> &#x2014; material icon named "text format".
  static const IconData text_format = IconData(0xe165, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">text_rotate_up</i> &#x2014; material icon named "text rotate up".
  static const IconData text_rotate_up = IconData(0xe93a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">text_rotate_vertical</i> &#x2014; material icon named "text rotate vertical".
  static const IconData text_rotate_vertical = IconData(0xe93b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">text_rotation_angledown</i> &#x2014; material icon named "text rotation angledown".
  static const IconData text_rotation_angledown = IconData(0xe93c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">text_rotation_angleup</i> &#x2014; material icon named "text rotation angleup".
  static const IconData text_rotation_angleup = IconData(0xe93d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">text_rotation_down</i> &#x2014; material icon named "text rotation down".
  static const IconData text_rotation_down = IconData(0xe93e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">text_rotation_none</i> &#x2014; material icon named "text rotation none".
  static const IconData text_rotation_none = IconData(0xe93f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">textsms</i> &#x2014; material icon named "textsms".
  static const IconData textsms = IconData(0xe0d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">texture</i> &#x2014; material icon named "texture".
  static const IconData texture = IconData(0xe421, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">theaters</i> &#x2014; material icon named "theaters".
  static const IconData theaters = IconData(0xe8da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">thumb_down</i> &#x2014; material icon named "thumb down".
  static const IconData thumb_down = IconData(0xe8db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">thumb_up</i> &#x2014; material icon named "thumb up".
  static const IconData thumb_up = IconData(0xe8dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">thumbs_up_down</i> &#x2014; material icon named "thumbs up down".
  static const IconData thumbs_up_down = IconData(0xe8dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">time_to_leave</i> &#x2014; material icon named "time to leave".
  static const IconData time_to_leave = IconData(0xe62c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">timelapse</i> &#x2014; material icon named "timelapse".
  static const IconData timelapse = IconData(0xe422, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">timeline</i> &#x2014; material icon named "timeline".
  static const IconData timeline = IconData(0xe922, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">timer</i> &#x2014; material icon named "timer".
  static const IconData timer = IconData(0xe425, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">timer_10</i> &#x2014; material icon named "timer 10".
  static const IconData timer_10 = IconData(0xe423, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">timer_3</i> &#x2014; material icon named "timer 3".
  static const IconData timer_3 = IconData(0xe424, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">timer_off</i> &#x2014; material icon named "timer off".
  static const IconData timer_off = IconData(0xe426, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">title</i> &#x2014; material icon named "title".
  static const IconData title = IconData(0xe264, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">toc</i> &#x2014; material icon named "toc".
  static const IconData toc = IconData(0xe8de, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">today</i> &#x2014; material icon named "today".
  static const IconData today = IconData(0xe8df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">toll</i> &#x2014; material icon named "toll".
  static const IconData toll = IconData(0xe8e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tonality</i> &#x2014; material icon named "tonality".
  static const IconData tonality = IconData(0xe427, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">touch_app</i> &#x2014; material icon named "touch app".
  static const IconData touch_app = IconData(0xe913, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">toys</i> &#x2014; material icon named "toys".
  static const IconData toys = IconData(0xe332, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">track_changes</i> &#x2014; material icon named "track changes".
  static const IconData track_changes = IconData(0xe8e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">traffic</i> &#x2014; material icon named "traffic".
  static const IconData traffic = IconData(0xe565, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">train</i> &#x2014; material icon named "train".
  static const IconData train = IconData(0xe570, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tram</i> &#x2014; material icon named "tram".
  static const IconData tram = IconData(0xe571, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">transfer_within_a_station</i> &#x2014; material icon named "transfer within a station".
  static const IconData transfer_within_a_station = IconData(0xe572, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">transform</i> &#x2014; material icon named "transform".
  static const IconData transform = IconData(0xe428, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">transit_enterexit</i> &#x2014; material icon named "transit enterexit".
  static const IconData transit_enterexit = IconData(0xe579, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">translate</i> &#x2014; material icon named "translate".
  static const IconData translate = IconData(0xe8e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">trending_down</i> &#x2014; material icon named "trending down".
  static const IconData trending_down = IconData(0xe8e3, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">trending_flat</i> &#x2014; material icon named "trending flat".
  static const IconData trending_flat = IconData(0xe8e4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">trending_up</i> &#x2014; material icon named "trending up".
  static const IconData trending_up = IconData(0xe8e5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">trip_origin</i> &#x2014; material icon named "trip origin".
  static const IconData trip_origin = IconData(0xe57b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tune</i> &#x2014; material icon named "tune".
  static const IconData tune = IconData(0xe429, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">turned_in</i> &#x2014; material icon named "turned in".
  static const IconData turned_in = IconData(0xe8e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">turned_in_not</i> &#x2014; material icon named "turned in not".
  static const IconData turned_in_not = IconData(0xe8e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">tv</i> &#x2014; material icon named "tv".
  static const IconData tv = IconData(0xe333, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">unarchive</i> &#x2014; material icon named "unarchive".
  static const IconData unarchive = IconData(0xe169, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">undo</i> &#x2014; material icon named "undo".
  static const IconData undo = IconData(0xe166, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">unfold_less</i> &#x2014; material icon named "unfold less".
  static const IconData unfold_less = IconData(0xe5d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">unfold_more</i> &#x2014; material icon named "unfold more".
  static const IconData unfold_more = IconData(0xe5d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">update</i> &#x2014; material icon named "update".
  static const IconData update = IconData(0xe923, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">usb</i> &#x2014; material icon named "usb".
  static const IconData usb = IconData(0xe1e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">verified_user</i> &#x2014; material icon named "verified user".
  static const IconData verified_user = IconData(0xe8e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">vertical_align_bottom</i> &#x2014; material icon named "vertical align bottom".
  static const IconData vertical_align_bottom = IconData(0xe258, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">vertical_align_center</i> &#x2014; material icon named "vertical align center".
  static const IconData vertical_align_center = IconData(0xe259, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">vertical_align_top</i> &#x2014; material icon named "vertical align top".
  static const IconData vertical_align_top = IconData(0xe25a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">vibration</i> &#x2014; material icon named "vibration".
  static const IconData vibration = IconData(0xe62d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">video_call</i> &#x2014; material icon named "video call".
  static const IconData video_call = IconData(0xe070, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">video_label</i> &#x2014; material icon named "video label".
  static const IconData video_label = IconData(0xe071, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">video_library</i> &#x2014; material icon named "video library".
  static const IconData video_library = IconData(0xe04a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">videocam</i> &#x2014; material icon named "videocam".
  static const IconData videocam = IconData(0xe04b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">videocam_off</i> &#x2014; material icon named "videocam off".
  static const IconData videocam_off = IconData(0xe04c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">videogame_asset</i> &#x2014; material icon named "videogame asset".
  static const IconData videogame_asset = IconData(0xe338, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_agenda</i> &#x2014; material icon named "view agenda".
  static const IconData view_agenda = IconData(0xe8e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_array</i> &#x2014; material icon named "view array".
  static const IconData view_array = IconData(0xe8ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_carousel</i> &#x2014; material icon named "view carousel".
  static const IconData view_carousel = IconData(0xe8eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_column</i> &#x2014; material icon named "view column".
  static const IconData view_column = IconData(0xe8ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_comfy</i> &#x2014; material icon named "view comfy".
  static const IconData view_comfy = IconData(0xe42a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_compact</i> &#x2014; material icon named "view compact".
  static const IconData view_compact = IconData(0xe42b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_day</i> &#x2014; material icon named "view day".
  static const IconData view_day = IconData(0xe8ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_headline</i> &#x2014; material icon named "view headline".
  static const IconData view_headline = IconData(0xe8ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_list</i> &#x2014; material icon named "view list".
  static const IconData view_list = IconData(0xe8ef, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">view_module</i> &#x2014; material icon named "view module".
  static const IconData view_module = IconData(0xe8f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_quilt</i> &#x2014; material icon named "view quilt".
  static const IconData view_quilt = IconData(0xe8f1, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">view_stream</i> &#x2014; material icon named "view stream".
  static const IconData view_stream = IconData(0xe8f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">view_week</i> &#x2014; material icon named "view week".
  static const IconData view_week = IconData(0xe8f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">vignette</i> &#x2014; material icon named "vignette".
  static const IconData vignette = IconData(0xe435, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">visibility</i> &#x2014; material icon named "visibility".
  static const IconData visibility = IconData(0xe8f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">visibility_off</i> &#x2014; material icon named "visibility off".
  static const IconData visibility_off = IconData(0xe8f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">voice_chat</i> &#x2014; material icon named "voice chat".
  static const IconData voice_chat = IconData(0xe62e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">voicemail</i> &#x2014; material icon named "voicemail".
  static const IconData voicemail = IconData(0xe0d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">volume_down</i> &#x2014; material icon named "volume down".
  static const IconData volume_down = IconData(0xe04d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">volume_mute</i> &#x2014; material icon named "volume mute".
  static const IconData volume_mute = IconData(0xe04e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">volume_off</i> &#x2014; material icon named "volume off".
  static const IconData volume_off = IconData(0xe04f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">volume_up</i> &#x2014; material icon named "volume up".
  static const IconData volume_up = IconData(0xe050, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">vpn_key</i> &#x2014; material icon named "vpn key".
  static const IconData vpn_key = IconData(0xe0da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">vpn_lock</i> &#x2014; material icon named "vpn lock".
  static const IconData vpn_lock = IconData(0xe62f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wallpaper</i> &#x2014; material icon named "wallpaper".
  static const IconData wallpaper = IconData(0xe1bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">warning</i> &#x2014; material icon named "warning".
  static const IconData warning = IconData(0xe002, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">watch</i> &#x2014; material icon named "watch".
  static const IconData watch = IconData(0xe334, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">watch_later</i> &#x2014; material icon named "watch later".
  static const IconData watch_later = IconData(0xe924, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wb_auto</i> &#x2014; material icon named "wb auto".
  static const IconData wb_auto = IconData(0xe42c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wb_cloudy</i> &#x2014; material icon named "wb cloudy".
  static const IconData wb_cloudy = IconData(0xe42d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wb_incandescent</i> &#x2014; material icon named "wb incandescent".
  static const IconData wb_incandescent = IconData(0xe42e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wb_iridescent</i> &#x2014; material icon named "wb iridescent".
  static const IconData wb_iridescent = IconData(0xe436, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wb_sunny</i> &#x2014; material icon named "wb sunny".
  static const IconData wb_sunny = IconData(0xe430, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wc</i> &#x2014; material icon named "wc".
  static const IconData wc = IconData(0xe63d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">web</i> &#x2014; material icon named "web".
  static const IconData web = IconData(0xe051, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">web_asset</i> &#x2014; material icon named "web asset".
  static const IconData web_asset = IconData(0xe069, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">weekend</i> &#x2014; material icon named "weekend".
  static const IconData weekend = IconData(0xe16b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">whatshot</i> &#x2014; material icon named "whatshot".
  static const IconData whatshot = IconData(0xe80e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">widgets</i> &#x2014; material icon named "widgets".
  static const IconData widgets = IconData(0xe1bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wifi</i> &#x2014; material icon named "wifi".
  static const IconData wifi = IconData(0xe63e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wifi_lock</i> &#x2014; material icon named "wifi lock".
  static const IconData wifi_lock = IconData(0xe1e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wifi_tethering</i> &#x2014; material icon named "wifi tethering".
  static const IconData wifi_tethering = IconData(0xe1e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">work</i> &#x2014; material icon named "work".
  static const IconData work = IconData(0xe8f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">wrap_text</i> &#x2014; material icon named "wrap text".
  static const IconData wrap_text = IconData(0xe25b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">youtube_searched_for</i> &#x2014; material icon named "youtube searched for".
  static const IconData youtube_searched_for = IconData(0xe8fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">zoom_in</i> &#x2014; material icon named "zoom in".
  static const IconData zoom_in = IconData(0xe8ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">zoom_out</i> &#x2014; material icon named "zoom out".
  static const IconData zoom_out = IconData(0xe900, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">zoom_out_map</i> &#x2014; material icon named "zoom out map".
  static const IconData zoom_out_map = IconData(0xe56b, fontFamily: 'MaterialIcons');
  // END GENERATED
}
