// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated.  Please do not edit it manually.
// To regenerate the file, use:
// dart dev/tools/gen_localizations.dart --overwrite

/// Maps from [Locale.languageCode] to a map that contains the localized strings
/// for that locale.
///
/// This variable is used by [MaterialLocalizations].
const Map<String, Map<String, String>> localizations = const <String, Map<String, String>> {
  'ar': const <String, String>{
    'selectedRowCountTitleOne': r'تم اختيار عنصر واحد',
    'selectedRowCountTitleZero': r'لم يتم اختيار أي عنصر',
    'selectedRowCountTitleTwo': r'تم اختيار عنصرين ($selectedRowCount)',
    'selectedRowCountTitleFew': r'تم اختيار $selectedRowCount عنصر',
    'selectedRowCountTitleMany': r'تم اختيار $selectedRowCount عنصرًا',
    'scriptCategory': r'tall',
    'timeOfDayFormat': r'h:mm a',
    'openAppDrawerTooltip': r'فتح قائمة التنقل',
    'backButtonTooltip': r'رجوع',
    'closeButtonTooltip': r'إغلاق',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'الشهر التالي',
    'previousMonthTooltip': r'الشهر السابق',
    'nextPageTooltip': r'الصفحة التالية',
    'previousPageTooltip': r'الصفحة السابقة',
    'showMenuTooltip': r'عرض القائمة',
    'aboutListTileTitle': r'حول "$applicationName"',
    'licensesPageTitle': r'التراخيص',
    'pageRowsInfoTitle': r'من $firstRow إلى $lastRow من إجمالي $rowCount',
    'pageRowsInfoTitleApproximate': r'من $firstRow إلى $lastRow من إجمالي $rowCount تقريبًا',
    'rowsPerPageTitle': r'عدد الصفوف في الصفحة:',
    'selectedRowCountTitleOther': r'تم اختيار $selectedRowCount عنصر',
    'cancelButtonLabel': r'إلغاء',
    'closeButtonLabel': r'إغلاق',
    'continueButtonLabel': r'متابعة',
    'copyButtonLabel': r'نسخ',
    'cutButtonLabel': r'قص',
    'okButtonLabel': r'حسنًا',
    'pasteButtonLabel': r'لصق',
    'selectAllButtonLabel': r'اختيار الكل',
    'viewLicensesButtonLabel': r'الاطّلاع على التراخيص',
    'anteMeridiemAbbreviation': r'ص',
    'postMeridiemAbbreviation': r'م',
  },
  'de': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'openAppDrawerTooltip': r'Navigationsmenü öffnen',
    'backButtonTooltip': r'Zurück',
    'closeButtonTooltip': r'Schließen',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Nächster Monat',
    'previousMonthTooltip': r'Vorheriger Monat',
    'nextPageTooltip': r'Nächste Seite',
    'previousPageTooltip': r'Vorherige Seite',
    'showMenuTooltip': r'Menü anzeigen',
    'aboutListTileTitle': r'Über $applicationName',
    'licensesPageTitle': r'Lizenzen',
    'pageRowsInfoTitle': r'$firstRow–$lastRow von $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow von etwa $rowCount',
    'rowsPerPageTitle': r'Zeilen pro Seite:',
    'selectedRowCountTitleZero': r'Keine Objekte ausgewählt',
    'selectedRowCountTitleOne': r'1 Element ausgewählt',
    'selectedRowCountTitleOther': r'$selectedRowCount Elemente ausgewählt',
    'cancelButtonLabel': r'ABBRECHEN',
    'closeButtonLabel': r'SCHLIEẞEN',
    'continueButtonLabel': r'WEITER',
    'copyButtonLabel': r'KOPIEREN',
    'cutButtonLabel': r'AUSSCHNEIDEN',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'EINFÜGEN',
    'selectAllButtonLabel': r'ALLE AUSWÄHLEN',
    'viewLicensesButtonLabel': r'LIZENZEN ANZEIGEN',
    'anteMeridiemAbbreviation': r'VORM.',
    'postMeridiemAbbreviation': r'NACHM.',
  },
  'de_CH': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'openAppDrawerTooltip': r'Navigationsmenü öffnen',
    'backButtonTooltip': r'Zurück',
    'closeButtonTooltip': r'Schliessen',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Nächster Monat',
    'previousMonthTooltip': r'Vorheriger Monat',
    'nextPageTooltip': r'Nächste Seite',
    'previousPageTooltip': r'Vorherige Seite',
    'showMenuTooltip': r'Menü anzeigen',
    'aboutListTileTitle': r'Über $applicationName',
    'licensesPageTitle': r'Lizenzen',
    'pageRowsInfoTitle': r'$firstRow–$lastRow von $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow von etwa $rowCount',
    'rowsPerPageTitle': r'Zeilen pro Seite:',
    'selectedRowCountTitleOne': r'1 Element ausgewählt',
    'selectedRowCountTitleOther': r'$selectedRowCount Elemente ausgewählt',
    'cancelButtonLabel': r'ABBRECHEN',
    'closeButtonLabel': r'SCHLIEẞEN',
    'continueButtonLabel': r'WEITER',
    'copyButtonLabel': r'KOPIEREN',
    'cutButtonLabel': r'AUSSCHNEIDEN',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'EINFÜGEN',
    'selectAllButtonLabel': r'ALLE AUSWÄHLEN',
    'viewLicensesButtonLabel': r'LIZENZEN ANZEIGEN',
    'anteMeridiemAbbreviation': r'VORM.',
    'postMeridiemAbbreviation': r'NACHM.',
  },
  'en': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'h:mm a',
    'openAppDrawerTooltip': r'Open navigation menu',
    'backButtonTooltip': r'Back',
    'closeButtonTooltip': r'Close',
    'deleteButtonTooltip': r'Delete',
    'nextMonthTooltip': r'Next month',
    'previousMonthTooltip': r'Previous month',
    'nextPageTooltip': r'Next page',
    'previousPageTooltip': r'Previous page',
    'showMenuTooltip': r'Show menu',
    'aboutListTileTitle': r'About $applicationName',
    'licensesPageTitle': r'Licenses',
    'pageRowsInfoTitle': r'$firstRow–$lastRow of $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow of about $rowCount',
    'rowsPerPageTitle': r'Rows per page:',
    'selectedRowCountTitleZero': r'No items selected',
    'selectedRowCountTitleOne': r'1 item selected',
    'selectedRowCountTitleOther': r'$selectedRowCount items selected',
    'cancelButtonLabel': r'CANCEL',
    'closeButtonLabel': r'CLOSE',
    'continueButtonLabel': r'CONTINUE',
    'copyButtonLabel': r'COPY',
    'cutButtonLabel': r'CUT',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'PASTE',
    'selectAllButtonLabel': r'SELECT ALL',
    'viewLicensesButtonLabel': r'VIEW LICENSES',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'en_AU': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'h:mm a',
    'openAppDrawerTooltip': r'Open navigation menu',
    'backButtonTooltip': r'Back',
    'closeButtonTooltip': r'Close',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Next month',
    'previousMonthTooltip': r'Previous month',
    'nextPageTooltip': r'Next page',
    'previousPageTooltip': r'Previous page',
    'showMenuTooltip': r'Show menu',
    'aboutListTileTitle': r'About $applicationName',
    'licensesPageTitle': r'Licences',
    'pageRowsInfoTitle': r'$firstRow–$lastRow of $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow of about $rowCount',
    'rowsPerPageTitle': r'Rows per page:',
    'selectedRowCountTitleOne': r'1 item selected',
    'selectedRowCountTitleOther': r'$selectedRowCount items selected',
    'cancelButtonLabel': r'CANCEL',
    'closeButtonLabel': r'CLOSE',
    'continueButtonLabel': r'CONTINUE',
    'copyButtonLabel': r'COPY',
    'cutButtonLabel': r'CUT',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'PASTE',
    'selectAllButtonLabel': r'SELECT ALL',
    'viewLicensesButtonLabel': r'VIEW LICENCES',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'en_CA': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'h:mm a',
    'openAppDrawerTooltip': r'Open navigation menu',
    'backButtonTooltip': r'Back',
    'closeButtonTooltip': r'Close',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Next month',
    'previousMonthTooltip': r'Previous month',
    'nextPageTooltip': r'Next page',
    'previousPageTooltip': r'Previous page',
    'showMenuTooltip': r'Show menu',
    'aboutListTileTitle': r'About $applicationName',
    'licensesPageTitle': r'Licences',
    'pageRowsInfoTitle': r'$firstRow–$lastRow of $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow of about $rowCount',
    'rowsPerPageTitle': r'Rows per page:',
    'selectedRowCountTitleOne': r'1 item selected',
    'selectedRowCountTitleOther': r'$selectedRowCount items selected',
    'cancelButtonLabel': r'CANCEL',
    'closeButtonLabel': r'CLOSE',
    'continueButtonLabel': r'CONTINUE',
    'copyButtonLabel': r'COPY',
    'cutButtonLabel': r'CUT',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'PASTE',
    'selectAllButtonLabel': r'SELECT ALL',
    'viewLicensesButtonLabel': r'VIEW LICENCES',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'en_GB': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'nextMonthTooltip': r'Next month',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow of about $rowCount',
    'copyButtonLabel': r'COPY',
    'closeButtonTooltip': r'Close',
    'deleteButtonTooltip': r'',
    'selectAllButtonLabel': r'SELECT ALL',
    'viewLicensesButtonLabel': r'VIEW LICENCES',
    'rowsPerPageTitle': r'Rows per page:',
    'aboutListTileTitle': r'About $applicationName',
    'backButtonTooltip': r'Back',
    'licensesPageTitle': r'Licences',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'PASTE',
    'previousMonthTooltip': r'Previous month',
    'closeButtonLabel': r'CLOSE',
    'cutButtonLabel': r'CUT',
    'continueButtonLabel': r'CONTINUE',
    'nextPageTooltip': r'Next page',
    'openAppDrawerTooltip': r'Open navigation menu',
    'previousPageTooltip': r'Previous page',
    'cancelButtonLabel': r'CANCEL',
    'pageRowsInfoTitle': r'$firstRow–$lastRow of $rowCount',
    'selectedRowCountTitleOne': r'1 item selected',
    'selectedRowCountTitleOther': r'$selectedRowCount items selected',
    'showMenuTooltip': r'Show menu',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'en_IE': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'nextMonthTooltip': r'Next month',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow of about $rowCount',
    'copyButtonLabel': r'COPY',
    'closeButtonTooltip': r'Close',
    'deleteButtonTooltip': r'',
    'selectAllButtonLabel': r'SELECT ALL',
    'viewLicensesButtonLabel': r'VIEW LICENCES',
    'rowsPerPageTitle': r'Rows per page:',
    'aboutListTileTitle': r'About $applicationName',
    'backButtonTooltip': r'Back',
    'licensesPageTitle': r'Licences',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'PASTE',
    'previousMonthTooltip': r'Previous month',
    'closeButtonLabel': r'CLOSE',
    'cutButtonLabel': r'CUT',
    'continueButtonLabel': r'CONTINUE',
    'nextPageTooltip': r'Next page',
    'openAppDrawerTooltip': r'Open navigation menu',
    'previousPageTooltip': r'Previous page',
    'cancelButtonLabel': r'CANCEL',
    'pageRowsInfoTitle': r'$firstRow–$lastRow of $rowCount',
    'selectedRowCountTitleOne': r'1 item selected',
    'selectedRowCountTitleOther': r'$selectedRowCount items selected',
    'showMenuTooltip': r'Show menu',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'en_IN': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'h:mm a',
    'openAppDrawerTooltip': r'Open navigation menu',
    'backButtonTooltip': r'Back',
    'closeButtonTooltip': r'Close',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Next month',
    'previousMonthTooltip': r'Previous month',
    'nextPageTooltip': r'Next page',
    'previousPageTooltip': r'Previous page',
    'showMenuTooltip': r'Show menu',
    'aboutListTileTitle': r'About $applicationName',
    'licensesPageTitle': r'Licences',
    'pageRowsInfoTitle': r'$firstRow–$lastRow of $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow of about $rowCount',
    'rowsPerPageTitle': r'Rows per page:',
    'selectedRowCountTitleOne': r'1 item selected',
    'selectedRowCountTitleOther': r'$selectedRowCount items selected',
    'cancelButtonLabel': r'CANCEL',
    'closeButtonLabel': r'CLOSE',
    'continueButtonLabel': r'CONTINUE',
    'copyButtonLabel': r'COPY',
    'cutButtonLabel': r'CUT',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'PASTE',
    'selectAllButtonLabel': r'SELECT ALL',
    'viewLicensesButtonLabel': r'VIEW LICENCES',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'en_SG': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'h:mm a',
    'openAppDrawerTooltip': r'Open navigation menu',
    'backButtonTooltip': r'Back',
    'closeButtonTooltip': r'Close',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Next month',
    'previousMonthTooltip': r'Previous month',
    'nextPageTooltip': r'Next page',
    'previousPageTooltip': r'Previous page',
    'showMenuTooltip': r'Show menu',
    'aboutListTileTitle': r'About $applicationName',
    'licensesPageTitle': r'Licences',
    'pageRowsInfoTitle': r'$firstRow–$lastRow of $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow of about $rowCount',
    'rowsPerPageTitle': r'Rows per page:',
    'selectedRowCountTitleOne': r'1 item selected',
    'selectedRowCountTitleOther': r'$selectedRowCount items selected',
    'cancelButtonLabel': r'CANCEL',
    'closeButtonLabel': r'CLOSE',
    'continueButtonLabel': r'CONTINUE',
    'copyButtonLabel': r'COPY',
    'cutButtonLabel': r'CUT',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'PASTE',
    'selectAllButtonLabel': r'SELECT ALL',
    'viewLicensesButtonLabel': r'VIEW LICENCES',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'en_ZA': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'nextMonthTooltip': r'Next month',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow of about $rowCount',
    'copyButtonLabel': r'COPY',
    'closeButtonTooltip': r'Close',
    'deleteButtonTooltip': r'',
    'selectAllButtonLabel': r'SELECT ALL',
    'viewLicensesButtonLabel': r'VIEW LICENCES',
    'rowsPerPageTitle': r'Rows per page:',
    'aboutListTileTitle': r'About $applicationName',
    'backButtonTooltip': r'Back',
    'licensesPageTitle': r'Licences',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'PASTE',
    'previousMonthTooltip': r'Previous month',
    'closeButtonLabel': r'CLOSE',
    'cutButtonLabel': r'CUT',
    'continueButtonLabel': r'CONTINUE',
    'nextPageTooltip': r'Next page',
    'openAppDrawerTooltip': r'Open navigation menu',
    'previousPageTooltip': r'Previous page',
    'cancelButtonLabel': r'CANCEL',
    'pageRowsInfoTitle': r'$firstRow–$lastRow of $rowCount',
    'selectedRowCountTitleOne': r'1 item selected',
    'selectedRowCountTitleOther': r'$selectedRowCount items selected',
    'showMenuTooltip': r'Show menu',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'es': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'H:mm',
    'openAppDrawerTooltip': r'Abrir el menú de navegación',
    'backButtonTooltip': r'Atrás',
    'closeButtonTooltip': r'Cerrar',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Mes siguiente',
    'previousMonthTooltip': r'Mes anterior',
    'nextPageTooltip': r'Página siguiente',
    'previousPageTooltip': r'Página anterior',
    'showMenuTooltip': r'Mostrar menú',
    'aboutListTileTitle': r'Sobre $applicationName',
    'licensesPageTitle': r'Licencias',
    'pageRowsInfoTitle': r'$firstRow‑$lastRow de $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow‑$lastRow de aproximadamente $rowCount',
    'rowsPerPageTitle': r'Filas por página:',
    'selectedRowCountTitleZero': r'No se han seleccionado elementos',
    'selectedRowCountTitleOne': r'1 elemento seleccionado',
    'selectedRowCountTitleOther': r'$selectedRowCount elementos seleccionados',
    'cancelButtonLabel': r'CANCELAR',
    'closeButtonLabel': r'CERRAR',
    'continueButtonLabel': r'CONTINUAR',
    'copyButtonLabel': r'COPIAR',
    'cutButtonLabel': r'CORTAR',
    'okButtonLabel': r'ACEPTAR',
    'pasteButtonLabel': r'PEGAR',
    'selectAllButtonLabel': r'SELECCIONAR TODO',
    'viewLicensesButtonLabel': r'VER LICENCIAS',
    'anteMeridiemAbbreviation': r'A.M.',
    'postMeridiemAbbreviation': r'P.M.',
  },
  'es_US': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'h:mm a',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'fa': const <String, String>{
    'scriptCategory': r'tall',
    'timeOfDayFormat': r'H:mm',
    'selectedRowCountTitleOne': r'۱ مورد انتخاب شد',
    'openAppDrawerTooltip': r'باز کردن منوی پیمایش',
    'backButtonTooltip': r'برگشت',
    'closeButtonTooltip': r'بستن',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'ماه بعد',
    'previousMonthTooltip': r'ماه قبل',
    'nextPageTooltip': r'صفحه بعد',
    'previousPageTooltip': r'صفحه قبل',
    'showMenuTooltip': r'نمایش منو',
    'aboutListTileTitle': r'درباره $applicationName',
    'licensesPageTitle': r'مجوزها',
    'pageRowsInfoTitle': r'$firstRow–$lastRow از $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow از حدود $rowCount',
    'rowsPerPageTitle': r'ردیف در هر صفحه:',
    'selectedRowCountTitleOther': r'$selectedRowCount مورد انتخاب شدند',
    'cancelButtonLabel': r'لغو',
    'closeButtonLabel': r'بستن',
    'continueButtonLabel': r'ادامه',
    'copyButtonLabel': r'کپی',
    'cutButtonLabel': r'برش',
    'okButtonLabel': r'تأیید',
    'pasteButtonLabel': r'جای‌گذاری',
    'selectAllButtonLabel': r'انتخاب همه',
    'viewLicensesButtonLabel': r'مشاهده مجوزها',
    'anteMeridiemAbbreviation': r'ق.ظ.',
    'postMeridiemAbbreviation': r'ب.ظ.',
  },
  'fr': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'openAppDrawerTooltip': r'Ouvrir le menu de navigation',
    'backButtonTooltip': r'Retour',
    'closeButtonTooltip': r'Fermer',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Mois suivant',
    'previousMonthTooltip': r'Mois précédent',
    'nextPageTooltip': r'Page suivante',
    'previousPageTooltip': r'Page précédente',
    'showMenuTooltip': r'Afficher le menu',
    'aboutListTileTitle': r'À propos de $applicationName',
    'licensesPageTitle': r'Licences',
    'pageRowsInfoTitle': r'$firstRow – $lastRow sur $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow – $lastRow sur environ $rowCount',
    'rowsPerPageTitle': r'Lignes par page :',
    'selectedRowCountTitleZero': r'Aucun élément sélectionné',
    'selectedRowCountTitleOne': r'1 élément sélectionné',
    'selectedRowCountTitleOther': r'$selectedRowCount éléments sélectionnés',
    'cancelButtonLabel': r'ANNULER',
    'closeButtonLabel': r'FERMER',
    'continueButtonLabel': r'CONTINUER',
    'copyButtonLabel': r'COPIER',
    'cutButtonLabel': r'COUPER',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'COLLER',
    'selectAllButtonLabel': r'TOUT SÉLECTIONNER',
    'viewLicensesButtonLabel': r'AFFICHER LES LICENCES',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'fr_CA': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH ' "'" r'h' "'" r' mm',
  },
  'gsw': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'openAppDrawerTooltip': r'Navigationsmenü öffnen',
    'backButtonTooltip': r'Zurück',
    'closeButtonTooltip': r'Schließen',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Nächster Monat',
    'previousMonthTooltip': r'Vorheriger Monat',
    'nextPageTooltip': r'Nächste Seite',
    'previousPageTooltip': r'Vorherige Seite',
    'showMenuTooltip': r'Menü anzeigen',
    'aboutListTileTitle': r'Über $applicationName',
    'licensesPageTitle': r'Lizenzen',
    'pageRowsInfoTitle': r'$firstRow–$lastRow von $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow von etwa $rowCount',
    'rowsPerPageTitle': r'Zeilen pro Seite:',
    'selectedRowCountTitleOne': r'1 Element ausgewählt',
    'selectedRowCountTitleOther': r'$selectedRowCount Elemente ausgewählt',
    'cancelButtonLabel': r'ABBRECHEN',
    'closeButtonLabel': r'SCHLIEẞEN',
    'continueButtonLabel': r'WEITER',
    'copyButtonLabel': r'KOPIEREN',
    'cutButtonLabel': r'AUSSCHNEIDEN',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'EINFÜGEN',
    'selectAllButtonLabel': r'ALLE AUSWÄHLEN',
    'viewLicensesButtonLabel': r'LIZENZEN ANZEIGEN',
    'anteMeridiemAbbreviation': r'VORM.',
    'postMeridiemAbbreviation': r'NACHM.',
  },
  'he': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'H:mm',
    'selectedRowCountTitleOne': r'פריט אחד נבחר',
    'selectedRowCountTitleTwo': r'$selectedRowCount פריטים נבחרו',
    'selectedRowCountTitleMany': r'$selectedRowCount פריטים נבחרו',
    'openAppDrawerTooltip': r'פתיחה של תפריט הניווט',
    'backButtonTooltip': r'הקודם',
    'closeButtonTooltip': r'סגירה',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'החודש הבא',
    'previousMonthTooltip': r'החודש הקודם',
    'nextPageTooltip': r'הדף הבא',
    'previousPageTooltip': r'הדף הקודם',
    'showMenuTooltip': r'הצגת התפריט',
    'aboutListTileTitle': r'מידע על $applicationName',
    'licensesPageTitle': r'רישיונות',
    'pageRowsInfoTitle': r'$lastRow–$firstRow מתוך $rowCount',
    'pageRowsInfoTitleApproximate': r'$lastRow–$firstRow מתוך כ-$rowCount',
    'rowsPerPageTitle': r'שורות בכל דף:',
    'selectedRowCountTitleOther': r'$selectedRowCount פריטים נבחרו',
    'cancelButtonLabel': r'ביטול',
    'closeButtonLabel': r'סגירה',
    'continueButtonLabel': r'המשך',
    'copyButtonLabel': r'העתקה',
    'cutButtonLabel': r'גזירה',
    'okButtonLabel': r'אישור',
    'pasteButtonLabel': r'הדבקה',
    'selectAllButtonLabel': r'בחירת הכול',
    'viewLicensesButtonLabel': r'הצגת הרישיונות',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'it': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'selectedRowCountTitleOne': r'1 elemento selezionato',
    'openAppDrawerTooltip': r'Apri il menu di navigazione',
    'backButtonTooltip': r'Indietro',
    'closeButtonTooltip': r'Chiudi',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Mese successivo',
    'previousMonthTooltip': r'Mese precedente',
    'nextPageTooltip': r'Pagina successiva',
    'previousPageTooltip': r'Pagina precedente',
    'showMenuTooltip': r'Mostra il menu',
    'aboutListTileTitle': r'Informazioni su $applicationName',
    'licensesPageTitle': r'Licenze',
    'pageRowsInfoTitle': r'$firstRow-$lastRow di $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow-$lastRow di circa $rowCount',
    'rowsPerPageTitle': r'Righe per pagina:',
    'selectedRowCountTitleOther': r'$selectedRowCount elementi selezionati',
    'cancelButtonLabel': r'ANNULLA',
    'closeButtonLabel': r'CHIUDI',
    'continueButtonLabel': r'CONTINUA',
    'copyButtonLabel': r'COPIA',
    'cutButtonLabel': r'TAGLIA',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'INCOLLA',
    'selectAllButtonLabel': r'SELEZIONA TUTTO',
    'viewLicensesButtonLabel': r'VISUALIZZA LICENZE',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'ja': const <String, String>{
    'scriptCategory': r'dense',
    'timeOfDayFormat': r'H:mm',
    'selectedRowCountTitleOne': r'1 件のアイテムを選択中',
    'openAppDrawerTooltip': r'ナビゲーション メニューを開く',
    'backButtonTooltip': r'戻る',
    'closeButtonTooltip': r'閉じる',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'来月',
    'previousMonthTooltip': r'前月',
    'nextPageTooltip': r'次のページ',
    'previousPageTooltip': r'前のページ',
    'showMenuTooltip': r'メニューを表示',
    'aboutListTileTitle': r'$applicationName について',
    'licensesPageTitle': r'ライセンス',
    'pageRowsInfoTitle': r'$firstRow - $lastRow 行（合計 $rowCount 行）',
    'pageRowsInfoTitleApproximate': r'$firstRow – $lastRow 行（合計約 $rowCount 行）',
    'rowsPerPageTitle': r'ページあたりの行数:',
    'selectedRowCountTitleOther': r'$selectedRowCount 件のアイテムを選択中',
    'cancelButtonLabel': r'キャンセル',
    'closeButtonLabel': r'閉じる',
    'continueButtonLabel': r'続行',
    'copyButtonLabel': r'コピー',
    'cutButtonLabel': r'切り取り',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'貼り付け',
    'selectAllButtonLabel': r'すべて選択',
    'viewLicensesButtonLabel': r'ライセンスを表示',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'ps': const <String, String>{
    'scriptCategory': r'tall',
    'timeOfDayFormat': r'HH:mm',
    'openAppDrawerTooltip': r'د پرانیستی نیینګ مینو',
    'backButtonTooltip': r'شاته',
    'closeButtonTooltip': r'بنده',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'بله میاشت',
    'previousMonthTooltip': r'تیره میاشت',
    'nextPageTooltip': r'بله پاڼه',
    'previousPageTooltip': r'مخکینی مخ',
    'showMenuTooltip': r'غورنۍ ښودل',
    'aboutListTileTitle': r'د $applicationName په اړه',
    'licensesPageTitle': r'جوازونه',
    'pageRowsInfoTitle': r'$firstRow–$lastRow د $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow څخه $rowCount د',
    'rowsPerPageTitle': r'د هرې پاڼې پاڼې:',
    'selectedRowCountTitleOther': r'$selectedRowCount توکي غوره شوي',
    'cancelButtonLabel': r'لغوه کول',
    'closeButtonLabel': r'تړل',
    'continueButtonLabel': r'منځپانګې',
    'copyButtonLabel': r'کاپی',
    'cutButtonLabel': r'کم کړئ',
    'okButtonLabel': r'سمه ده',
    'pasteButtonLabel': r'پیټ کړئ',
    'selectAllButtonLabel': r'غوره کړئ',
    'viewLicensesButtonLabel': r'لیدلس وګورئ',
  },
  'pt': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'openAppDrawerTooltip': r'Abrir menu de navegação',
    'backButtonTooltip': r'Costas',
    'closeButtonTooltip': r'Fechar',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Próximo mês',
    'previousMonthTooltip': r'Mês anterior',
    'nextPageTooltip': r'Próxima página',
    'previousPageTooltip': r'Página anterior',
    'showMenuTooltip': r'Mostrar menu',
    'aboutListTileTitle': r'Sobre $applicationName',
    'licensesPageTitle': r'Licenças',
    'pageRowsInfoTitle': r'$firstRow–$lastRow de $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow de cerca de $rowCount',
    'rowsPerPageTitle': r'Linhas por página:',
    'selectedRowCountTitleOther': r'$selectedRowCount selecionados',
    'cancelButtonLabel': r'CANCELAR',
    'closeButtonLabel': r'FECHAR',
    'continueButtonLabel': r'CONTINUAR',
    'copyButtonLabel': r'CÓPIA DE',
    'cutButtonLabel': r'CORTA',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'COLAR',
    'selectAllButtonLabel': r'SELECIONAR TUDO',
    'viewLicensesButtonLabel': r'VER LICENÇAS',
  },
  'pt_PT': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'HH:mm',
    'openAppDrawerTooltip': r'Abrir menu de navegação',
    'backButtonTooltip': r'Anterior',
    'closeButtonTooltip': r'Fechar',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Mês seguinte',
    'previousMonthTooltip': r'Mês anterior',
    'nextPageTooltip': r'Página seguinte',
    'previousPageTooltip': r'Página anterior',
    'showMenuTooltip': r'Mostrar menu',
    'aboutListTileTitle': r'Acerca de $applicationName',
    'licensesPageTitle': r'Licenças',
    'pageRowsInfoTitle': r'$firstRow a $lastRow de $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow a $lastRow de cerca de $rowCount',
    'rowsPerPageTitle': r'Linhas por página:',
    'selectedRowCountTitleOne': r'1 item selecionado',
    'selectedRowCountTitleOther': r'$selectedRowCount itens selecionados',
    'cancelButtonLabel': r'CANCELAR',
    'closeButtonLabel': r'FECHAR',
    'continueButtonLabel': r'CONTINUAR',
    'copyButtonLabel': r'COPIAR',
    'cutButtonLabel': r'CORTAR',
    'okButtonLabel': r'OK',
    'pasteButtonLabel': r'COLAR',
    'selectAllButtonLabel': r'SELECIONAR TUDO',
    'viewLicensesButtonLabel': r'VER LICENÇAS',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'ru': const <String, String>{
    'scriptCategory': r'English-like',
    'timeOfDayFormat': r'H:mm',
    'selectedRowCountTitleFew': r'Выбрано $selectedRowCount объекта',
    'selectedRowCountTitleMany': r'Выбрано $selectedRowCount объектов',
    'openAppDrawerTooltip': r'Открыть меню навигации',
    'backButtonTooltip': r'Назад',
    'closeButtonTooltip': r'Закрыть',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'Следующий месяц',
    'previousMonthTooltip': r'Предыдущий месяц',
    'nextPageTooltip': r'Следующая страница',
    'previousPageTooltip': r'Предыдущая страница',
    'showMenuTooltip': r'Показать меню',
    'pageRowsInfoTitle': r'$firstRow–$lastRow из $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow из примерно $rowCount',
    'rowsPerPageTitle': r'Строк на странице:',
    'aboutListTileTitle': r'$applicationName: сведения',
    'licensesPageTitle': r'Лицензии',
    'selectedRowCountTitleZero': r'Строки не выбраны',
    'selectedRowCountTitleOne': r'Выбран 1 объект',
    'selectedRowCountTitleOther': r'Выбрано $selectedRowCount объекта',
    'cancelButtonLabel': r'ОТМЕНА',
    'closeButtonLabel': r'ЗАКРЫТЬ',
    'continueButtonLabel': r'ПРОДОЛЖИТЬ',
    'copyButtonLabel': r'КОПИРОВАТЬ',
    'cutButtonLabel': r'ВЫРЕЗАТЬ',
    'okButtonLabel': r'ОК',
    'pasteButtonLabel': r'ВСТАВИТЬ',
    'selectAllButtonLabel': r'ВЫБРАТЬ ВСЕ',
    'viewLicensesButtonLabel': r'ЛИЦЕНЗИИ',
    'anteMeridiemAbbreviation': r'АМ',
    'postMeridiemAbbreviation': r'PM',
  },
  'ur': const <String, String>{
    'scriptCategory': r'tall',
    'timeOfDayFormat': r'h:mm a',
    'selectedRowCountTitleOne': r'1 آئٹم منتخب کیا گیا',
    'openAppDrawerTooltip': r'نیویگیشن مینو کھولیں',
    'backButtonTooltip': r'پیچھے',
    'closeButtonTooltip': r'بند کریں',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'اگلا مہینہ',
    'previousMonthTooltip': r'پچھلا مہینہ',
    'nextPageTooltip': r'اگلا صفحہ',
    'previousPageTooltip': r'گزشتہ صفحہ',
    'showMenuTooltip': r'مینو دکھائیں',
    'aboutListTileTitle': r'$applicationName کے بارے میں',
    'licensesPageTitle': r'لائسنسز',
    'pageRowsInfoTitle': r'$firstRow–$lastRow از $rowCount',
    'pageRowsInfoTitleApproximate': r'$firstRow–$lastRow $rowCount میں سے تقریباً',
    'rowsPerPageTitle': r'قطاریں فی صفحہ:',
    'selectedRowCountTitleOther': r'$selectedRowCount آئٹمز منتخب کیے گئے',
    'cancelButtonLabel': r'منسوخ کریں',
    'closeButtonLabel': r'بند کریں',
    'continueButtonLabel': r'جاری رکھیں',
    'copyButtonLabel': r'کاپی کریں',
    'cutButtonLabel': r'کٹ کریں',
    'okButtonLabel': r'ٹھیک ہے',
    'pasteButtonLabel': r'پیسٹ کریں',
    'selectAllButtonLabel': r'سبھی منتخب کریں',
    'viewLicensesButtonLabel': r'لائسنسز دیکھیں',
    'anteMeridiemAbbreviation': r'AM',
    'postMeridiemAbbreviation': r'PM',
  },
  'zh': const <String, String>{
    'scriptCategory': r'dense',
    'timeOfDayFormat': r'ah:mm',
    'selectedRowCountTitleOne': r'已选择 1 项内容',
    'openAppDrawerTooltip': r'打开导航菜单',
    'backButtonTooltip': r'返回',
    'nextPageTooltip': r'下一页',
    'previousPageTooltip': r'上一页',
    'showMenuTooltip': r'显示菜单',
    'aboutListTileTitle': r'关于$applicationName',
    'licensesPageTitle': r'许可',
    'pageRowsInfoTitle': r'第 $firstRow-$lastRow 行（共 $rowCount 行）',
    'pageRowsInfoTitleApproximate': r'第 $firstRow-$lastRow 行（共约 $rowCount 行）',
    'rowsPerPageTitle': r'每页行数：',
    'selectedRowCountTitleOther': r'已选择 $selectedRowCount 项内容',
    'cancelButtonLabel': r'取消',
    'continueButtonLabel': r'继续',
    'closeButtonLabel': r'关闭',
    'copyButtonLabel': r'复制',
    'cutButtonLabel': r'剪切',
    'okButtonLabel': r'确定',
    'pasteButtonLabel': r'粘贴',
    'selectAllButtonLabel': r'全选',
    'viewLicensesButtonLabel': r'查看许可',
    'closeButtonTooltip': r'关闭',
    'deleteButtonTooltip': r'',
    'nextMonthTooltip': r'下个月',
    'previousMonthTooltip': r'上个月',
    'anteMeridiemAbbreviation': r'上午',
    'postMeridiemAbbreviation': r'下午',
  },
};

