// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated. Please do not edit it manually.
// To regenerate run (omit --overwrite to print to console instead of the file):
// dart --enable-asserts dev/tools/localization/gen_date_localizations.dart --overwrite

/// The subset of date symbols supported by the intl package which are also
/// supported by flutter_localizations.
const Map<String, dynamic> dateSymbols = <String, dynamic>{
  'ar': <String, dynamic>{
    'NAME': r'''ar''',
    'ERAS': <dynamic>[r'''ق.م''', r'''م'''],
    'ERANAMES': <dynamic>[r'''قبل الميلاد''', r'''ميلادي'''],
    'NARROWMONTHS': <dynamic>[
      r'''ي''',
      r'''ف''',
      r'''م''',
      r'''أ''',
      r'''و''',
      r'''ن''',
      r'''ل''',
      r'''غ''',
      r'''س''',
      r'''ك''',
      r'''ب''',
      r'''د'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''ي''',
      r'''ف''',
      r'''م''',
      r'''أ''',
      r'''و''',
      r'''ن''',
      r'''ل''',
      r'''غ''',
      r'''س''',
      r'''ك''',
      r'''ب''',
      r'''د'''
    ],
    'MONTHS': <dynamic>[
      r'''يناير''',
      r'''فبراير''',
      r'''مارس''',
      r'''أبريل''',
      r'''مايو''',
      r'''يونيو''',
      r'''يوليو''',
      r'''أغسطس''',
      r'''سبتمبر''',
      r'''أكتوبر''',
      r'''نوفمبر''',
      r'''ديسمبر'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''يناير''',
      r'''فبراير''',
      r'''مارس''',
      r'''أبريل''',
      r'''مايو''',
      r'''يونيو''',
      r'''يوليو''',
      r'''أغسطس''',
      r'''سبتمبر''',
      r'''أكتوبر''',
      r'''نوفمبر''',
      r'''ديسمبر'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''يناير''',
      r'''فبراير''',
      r'''مارس''',
      r'''أبريل''',
      r'''مايو''',
      r'''يونيو''',
      r'''يوليو''',
      r'''أغسطس''',
      r'''سبتمبر''',
      r'''أكتوبر''',
      r'''نوفمبر''',
      r'''ديسمبر'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''يناير''',
      r'''فبراير''',
      r'''مارس''',
      r'''أبريل''',
      r'''مايو''',
      r'''يونيو''',
      r'''يوليو''',
      r'''أغسطس''',
      r'''سبتمبر''',
      r'''أكتوبر''',
      r'''نوفمبر''',
      r'''ديسمبر'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''الأحد''',
      r'''الاثنين''',
      r'''الثلاثاء''',
      r'''الأربعاء''',
      r'''الخميس''',
      r'''الجمعة''',
      r'''السبت'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''الأحد''',
      r'''الاثنين''',
      r'''الثلاثاء''',
      r'''الأربعاء''',
      r'''الخميس''',
      r'''الجمعة''',
      r'''السبت'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''الأحد''',
      r'''الاثنين''',
      r'''الثلاثاء''',
      r'''الأربعاء''',
      r'''الخميس''',
      r'''الجمعة''',
      r'''السبت'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''الأحد''',
      r'''الاثنين''',
      r'''الثلاثاء''',
      r'''الأربعاء''',
      r'''الخميس''',
      r'''الجمعة''',
      r'''السبت'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''ح''',
      r'''ن''',
      r'''ث''',
      r'''ر''',
      r'''خ''',
      r'''ج''',
      r'''س'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''ح''',
      r'''ن''',
      r'''ث''',
      r'''ر''',
      r'''خ''',
      r'''ج''',
      r'''س'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''الربع الأول''',
      r'''الربع الثاني''',
      r'''الربع الثالث''',
      r'''الربع الرابع'''
    ],
    'QUARTERS': <dynamic>[
      r'''الربع الأول''',
      r'''الربع الثاني''',
      r'''الربع الثالث''',
      r'''الربع الرابع'''
    ],
    'AMPMS': <dynamic>[r'''ص''', r'''م'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE، d MMMM y''',
      r'''d MMMM y''',
      r'''dd‏/MM‏/y''',
      r'''d‏/M‏/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 5,
    'WEEKENDRANGE': <dynamic>[4, 5],
    'FIRSTWEEKCUTOFFDAY': 4,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
    'ZERODIGIT': r'''٠''',
  },
  'bg': <String, dynamic>{
    'NAME': r'''bg''',
    'ERAS': <dynamic>[r'''пр.Хр.''', r'''сл.Хр.'''],
    'ERANAMES': <dynamic>[r'''преди Христа''', r'''след Христа'''],
    'NARROWMONTHS': <dynamic>[
      r'''я''',
      r'''ф''',
      r'''м''',
      r'''а''',
      r'''м''',
      r'''ю''',
      r'''ю''',
      r'''а''',
      r'''с''',
      r'''о''',
      r'''н''',
      r'''д'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''я''',
      r'''ф''',
      r'''м''',
      r'''а''',
      r'''м''',
      r'''ю''',
      r'''ю''',
      r'''а''',
      r'''с''',
      r'''о''',
      r'''н''',
      r'''д'''
    ],
    'MONTHS': <dynamic>[
      r'''януари''',
      r'''февруари''',
      r'''март''',
      r'''април''',
      r'''май''',
      r'''юни''',
      r'''юли''',
      r'''август''',
      r'''септември''',
      r'''октомври''',
      r'''ноември''',
      r'''декември'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''януари''',
      r'''февруари''',
      r'''март''',
      r'''април''',
      r'''май''',
      r'''юни''',
      r'''юли''',
      r'''август''',
      r'''септември''',
      r'''октомври''',
      r'''ноември''',
      r'''декември'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''яну''',
      r'''фев''',
      r'''март''',
      r'''апр''',
      r'''май''',
      r'''юни''',
      r'''юли''',
      r'''авг''',
      r'''сеп''',
      r'''окт''',
      r'''ное''',
      r'''дек'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''яну''',
      r'''фев''',
      r'''март''',
      r'''апр''',
      r'''май''',
      r'''юни''',
      r'''юли''',
      r'''авг''',
      r'''сеп''',
      r'''окт''',
      r'''ное''',
      r'''дек'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''неделя''',
      r'''понеделник''',
      r'''вторник''',
      r'''сряда''',
      r'''четвъртък''',
      r'''петък''',
      r'''събота'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''неделя''',
      r'''понеделник''',
      r'''вторник''',
      r'''сряда''',
      r'''четвъртък''',
      r'''петък''',
      r'''събота'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''нд''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''нд''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''н''',
      r'''п''',
      r'''в''',
      r'''с''',
      r'''ч''',
      r'''п''',
      r'''с'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''н''',
      r'''п''',
      r'''в''',
      r'''с''',
      r'''ч''',
      r'''п''',
      r'''с'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''1. трим.''',
      r'''2. трим.''',
      r'''3. трим.''',
      r'''4. трим.'''
    ],
    'QUARTERS': <dynamic>[
      r'''1. тримесечие''',
      r'''2. тримесечие''',
      r'''3. тримесечие''',
      r'''4. тримесечие'''
    ],
    'AMPMS': <dynamic>[r'''пр.об.''', r'''сл.об.'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d MMMM y 'г'.""",
      r"""d MMMM y 'г'.""",
      r"""d.MM.y 'г'.""",
      r"""d.MM.yy 'г'."""
    ],
    'TIMEFORMATS': <dynamic>[
      r"""H:mm:ss 'ч'. zzzz""",
      r"""H:mm:ss 'ч'. z""",
      r"""H:mm:ss 'ч'.""",
      r"""H:mm 'ч'."""
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'bs': <String, dynamic>{
    'NAME': r'''bs''',
    'ERAS': <dynamic>[r'''p. n. e.''', r'''n. e.'''],
    'ERANAMES': <dynamic>[r'''prije nove ere''', r'''nove ere'''],
    'NARROWMONTHS': <dynamic>[
      r'''j''',
      r'''f''',
      r'''m''',
      r'''a''',
      r'''m''',
      r'''j''',
      r'''j''',
      r'''a''',
      r'''s''',
      r'''o''',
      r'''n''',
      r'''d'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''j''',
      r'''f''',
      r'''m''',
      r'''a''',
      r'''m''',
      r'''j''',
      r'''j''',
      r'''a''',
      r'''s''',
      r'''o''',
      r'''n''',
      r'''d'''
    ],
    'MONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''mart''',
      r'''april''',
      r'''maj''',
      r'''juni''',
      r'''juli''',
      r'''avgust''',
      r'''septembar''',
      r'''oktobar''',
      r'''novembar''',
      r'''decembar'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''mart''',
      r'''april''',
      r'''maj''',
      r'''juni''',
      r'''juli''',
      r'''avgust''',
      r'''septembar''',
      r'''oktobar''',
      r'''novembar''',
      r'''decembar'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''maj''',
      r'''jun''',
      r'''jul''',
      r'''avg''',
      r'''sep''',
      r'''okt''',
      r'''nov''',
      r'''dec'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''maj''',
      r'''jun''',
      r'''jul''',
      r'''avg''',
      r'''sep''',
      r'''okt''',
      r'''nov''',
      r'''dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''nedjelja''',
      r'''ponedjeljak''',
      r'''utorak''',
      r'''srijeda''',
      r'''četvrtak''',
      r'''petak''',
      r'''subota'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''nedjelja''',
      r'''ponedjeljak''',
      r'''utorak''',
      r'''srijeda''',
      r'''četvrtak''',
      r'''petak''',
      r'''subota'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''ned''',
      r'''pon''',
      r'''uto''',
      r'''sri''',
      r'''čet''',
      r'''pet''',
      r'''sub'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''ned''',
      r'''pon''',
      r'''uto''',
      r'''sri''',
      r'''čet''',
      r'''pet''',
      r'''sub'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''N''',
      r'''P''',
      r'''U''',
      r'''S''',
      r'''Č''',
      r'''P''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''n''',
      r'''p''',
      r'''u''',
      r'''s''',
      r'''č''',
      r'''p''',
      r'''s'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''KV1''', r'''KV2''', r'''KV3''', r'''KV4'''],
    'QUARTERS': <dynamic>[
      r'''Prvi kvartal''',
      r'''Drugi kvartal''',
      r'''Treći kvartal''',
      r'''Četvrti kvartal'''
    ],
    'AMPMS': <dynamic>[r'''prijepodne''', r'''popodne'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d. MMMM y.''',
      r'''d. MMMM y.''',
      r'''d. MMM y.''',
      r'''d.M.yy.'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'u' {0}""",
      r"""{1} 'u' {0}""",
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'ca': <String, dynamic>{
    'NAME': r'''ca''',
    'ERAS': <dynamic>[r'''aC''', r'''dC'''],
    'ERANAMES': <dynamic>[r'''abans de Crist''', r'''després de Crist'''],
    'NARROWMONTHS': <dynamic>[
      r'''GN''',
      r'''FB''',
      r'''MÇ''',
      r'''AB''',
      r'''MG''',
      r'''JN''',
      r'''JL''',
      r'''AG''',
      r'''ST''',
      r'''OC''',
      r'''NV''',
      r'''DS'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''GN''',
      r'''FB''',
      r'''MÇ''',
      r'''AB''',
      r'''MG''',
      r'''JN''',
      r'''JL''',
      r'''AG''',
      r'''ST''',
      r'''OC''',
      r'''NV''',
      r'''DS'''
    ],
    'MONTHS': <dynamic>[
      r'''de gener''',
      r'''de febrer''',
      r'''de març''',
      r'''d’abril''',
      r'''de maig''',
      r'''de juny''',
      r'''de juliol''',
      r'''d’agost''',
      r'''de setembre''',
      r'''d’octubre''',
      r'''de novembre''',
      r'''de desembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''gener''',
      r'''febrer''',
      r'''març''',
      r'''abril''',
      r'''maig''',
      r'''juny''',
      r'''juliol''',
      r'''agost''',
      r'''setembre''',
      r'''octubre''',
      r'''novembre''',
      r'''desembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''de gen.''',
      r'''de febr.''',
      r'''de març''',
      r'''d’abr.''',
      r'''de maig''',
      r'''de juny''',
      r'''de jul.''',
      r'''d’ag.''',
      r'''de set.''',
      r'''d’oct.''',
      r'''de nov.''',
      r'''de des.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''gen.''',
      r'''febr.''',
      r'''març''',
      r'''abr.''',
      r'''maig''',
      r'''juny''',
      r'''jul.''',
      r'''ag.''',
      r'''set.''',
      r'''oct.''',
      r'''nov.''',
      r'''des.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''diumenge''',
      r'''dilluns''',
      r'''dimarts''',
      r'''dimecres''',
      r'''dijous''',
      r'''divendres''',
      r'''dissabte'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''diumenge''',
      r'''dilluns''',
      r'''dimarts''',
      r'''dimecres''',
      r'''dijous''',
      r'''divendres''',
      r'''dissabte'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dg.''',
      r'''dl.''',
      r'''dt.''',
      r'''dc.''',
      r'''dj.''',
      r'''dv.''',
      r'''ds.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dg.''',
      r'''dl.''',
      r'''dt.''',
      r'''dc.''',
      r'''dj.''',
      r'''dv.''',
      r'''ds.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''dg''',
      r'''dl''',
      r'''dt''',
      r'''dc''',
      r'''dj''',
      r'''dv''',
      r'''ds'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''dg''',
      r'''dl''',
      r'''dt''',
      r'''dc''',
      r'''dj''',
      r'''dv''',
      r'''ds'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''1T''', r'''2T''', r'''3T''', r'''4T'''],
    'QUARTERS': <dynamic>[
      r'''1r trimestre''',
      r'''2n trimestre''',
      r'''3r trimestre''',
      r'''4t trimestre'''
    ],
    'AMPMS': <dynamic>[r'''a. m.''', r'''p. m.'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d MMMM 'de' y""",
      r"""d MMMM 'de' y""",
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'a' 'les' {0}""",
      r"""{1} 'a' 'les' {0}""",
      r'''{1}, {0}''',
      r'''{1} {0}'''
    ],
  },
  'cs': <String, dynamic>{
    'NAME': r'''cs''',
    'ERAS': <dynamic>[r'''př. n. l.''', r'''n. l.'''],
    'ERANAMES': <dynamic>[
      r'''před naším letopočtem''',
      r'''našeho letopočtu'''
    ],
    'NARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': <dynamic>[
      r'''ledna''',
      r'''února''',
      r'''března''',
      r'''dubna''',
      r'''května''',
      r'''června''',
      r'''července''',
      r'''srpna''',
      r'''září''',
      r'''října''',
      r'''listopadu''',
      r'''prosince'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''leden''',
      r'''únor''',
      r'''březen''',
      r'''duben''',
      r'''květen''',
      r'''červen''',
      r'''červenec''',
      r'''srpen''',
      r'''září''',
      r'''říjen''',
      r'''listopad''',
      r'''prosinec'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''led''',
      r'''úno''',
      r'''bře''',
      r'''dub''',
      r'''kvě''',
      r'''čvn''',
      r'''čvc''',
      r'''srp''',
      r'''zář''',
      r'''říj''',
      r'''lis''',
      r'''pro'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''led''',
      r'''úno''',
      r'''bře''',
      r'''dub''',
      r'''kvě''',
      r'''čvn''',
      r'''čvc''',
      r'''srp''',
      r'''zář''',
      r'''říj''',
      r'''lis''',
      r'''pro'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''neděle''',
      r'''pondělí''',
      r'''úterý''',
      r'''středa''',
      r'''čtvrtek''',
      r'''pátek''',
      r'''sobota'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''neděle''',
      r'''pondělí''',
      r'''úterý''',
      r'''středa''',
      r'''čtvrtek''',
      r'''pátek''',
      r'''sobota'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''ne''',
      r'''po''',
      r'''út''',
      r'''st''',
      r'''čt''',
      r'''pá''',
      r'''so'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''ne''',
      r'''po''',
      r'''út''',
      r'''st''',
      r'''čt''',
      r'''pá''',
      r'''so'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''N''',
      r'''P''',
      r'''Ú''',
      r'''S''',
      r'''Č''',
      r'''P''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''N''',
      r'''P''',
      r'''Ú''',
      r'''S''',
      r'''Č''',
      r'''P''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1. čtvrtletí''',
      r'''2. čtvrtletí''',
      r'''3. čtvrtletí''',
      r'''4. čtvrtletí'''
    ],
    'AMPMS': <dynamic>[r'''dop.''', r'''odp.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d. MMMM y''',
      r'''d. MMMM y''',
      r'''d. M. y''',
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'da': <String, dynamic>{
    'NAME': r'''da''',
    'ERAS': <dynamic>[r'''f.Kr.''', r'''e.Kr.'''],
    'ERANAMES': <dynamic>[r'''f.Kr.''', r'''e.Kr.'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''marts''',
      r'''april''',
      r'''maj''',
      r'''juni''',
      r'''juli''',
      r'''august''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''marts''',
      r'''april''',
      r'''maj''',
      r'''juni''',
      r'''juli''',
      r'''august''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mar.''',
      r'''apr.''',
      r'''maj''',
      r'''jun.''',
      r'''jul.''',
      r'''aug.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mar.''',
      r'''apr.''',
      r'''maj''',
      r'''jun.''',
      r'''jul.''',
      r'''aug.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''søndag''',
      r'''mandag''',
      r'''tirsdag''',
      r'''onsdag''',
      r'''torsdag''',
      r'''fredag''',
      r'''lørdag'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''søndag''',
      r'''mandag''',
      r'''tirsdag''',
      r'''onsdag''',
      r'''torsdag''',
      r'''fredag''',
      r'''lørdag'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''søn.''',
      r'''man.''',
      r'''tir.''',
      r'''ons.''',
      r'''tor.''',
      r'''fre.''',
      r'''lør.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''søn''',
      r'''man''',
      r'''tir''',
      r'''ons''',
      r'''tor''',
      r'''fre''',
      r'''lør'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''O''',
      r'''T''',
      r'''F''',
      r'''L'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''O''',
      r'''T''',
      r'''F''',
      r'''L'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''1. kvt.''',
      r'''2. kvt.''',
      r'''3. kvt.''',
      r'''4. kvt.'''
    ],
    'QUARTERS': <dynamic>[
      r'''1. kvartal''',
      r'''2. kvartal''',
      r'''3. kvartal''',
      r'''4. kvartal'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE 'den' d. MMMM y""",
      r'''d. MMMM y''',
      r'''d. MMM y''',
      r'''dd/MM/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH.mm.ss zzzz''',
      r'''HH.mm.ss z''',
      r'''HH.mm.ss''',
      r'''HH.mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'kl'. {0}""",
      r"""{1} 'kl'. {0}""",
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'de': <String, dynamic>{
    'NAME': r'''de''',
    'ERAS': <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'ERANAMES': <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''August''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Dezember'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''August''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Dezember'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan.''',
      r'''Feb.''',
      r'''März''',
      r'''Apr.''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''Aug.''',
      r'''Sep.''',
      r'''Okt.''',
      r'''Nov.''',
      r'''Dez.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mär''',
      r'''Apr''',
      r'''Mai''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Dez'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sonntag''',
      r'''Montag''',
      r'''Dienstag''',
      r'''Mittwoch''',
      r'''Donnerstag''',
      r'''Freitag''',
      r'''Samstag'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sonntag''',
      r'''Montag''',
      r'''Dienstag''',
      r'''Mittwoch''',
      r'''Donnerstag''',
      r'''Freitag''',
      r'''Samstag'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''So.''',
      r'''Mo.''',
      r'''Di.''',
      r'''Mi.''',
      r'''Do.''',
      r'''Fr.''',
      r'''Sa.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''So''',
      r'''Mo''',
      r'''Di''',
      r'''Mi''',
      r'''Do''',
      r'''Fr''',
      r'''Sa'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1. Quartal''',
      r'''2. Quartal''',
      r'''3. Quartal''',
      r'''4. Quartal'''
    ],
    'AMPMS': <dynamic>[r'''vorm.''', r'''nachm.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d. MMMM y''',
      r'''d. MMMM y''',
      r'''dd.MM.y''',
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'um' {0}""",
      r"""{1} 'um' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'de_CH': <String, dynamic>{
    'NAME': r'''de_CH''',
    'ERAS': <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'ERANAMES': <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''August''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Dezember'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''August''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Dezember'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan.''',
      r'''Feb.''',
      r'''März''',
      r'''Apr.''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''Aug.''',
      r'''Sep.''',
      r'''Okt.''',
      r'''Nov.''',
      r'''Dez.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mär''',
      r'''Apr''',
      r'''Mai''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Dez'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sonntag''',
      r'''Montag''',
      r'''Dienstag''',
      r'''Mittwoch''',
      r'''Donnerstag''',
      r'''Freitag''',
      r'''Samstag'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sonntag''',
      r'''Montag''',
      r'''Dienstag''',
      r'''Mittwoch''',
      r'''Donnerstag''',
      r'''Freitag''',
      r'''Samstag'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''So.''',
      r'''Mo.''',
      r'''Di.''',
      r'''Mi.''',
      r'''Do.''',
      r'''Fr.''',
      r'''Sa.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''So''',
      r'''Mo''',
      r'''Di''',
      r'''Mi''',
      r'''Do''',
      r'''Fr''',
      r'''Sa'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1. Quartal''',
      r'''2. Quartal''',
      r'''3. Quartal''',
      r'''4. Quartal'''
    ],
    'AMPMS': <dynamic>[r'''vorm.''', r'''nachm.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d. MMMM y''',
      r'''d. MMMM y''',
      r'''dd.MM.y''',
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'um' {0}""",
      r"""{1} 'um' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'el': <String, dynamic>{
    'NAME': r'''el''',
    'ERAS': <dynamic>[r'''π.Χ.''', r'''μ.Χ.'''],
    'ERANAMES': <dynamic>[r'''προ Χριστού''', r'''μετά Χριστόν'''],
    'NARROWMONTHS': <dynamic>[
      r'''Ι''',
      r'''Φ''',
      r'''Μ''',
      r'''Α''',
      r'''Μ''',
      r'''Ι''',
      r'''Ι''',
      r'''Α''',
      r'''Σ''',
      r'''Ο''',
      r'''Ν''',
      r'''Δ'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''Ι''',
      r'''Φ''',
      r'''Μ''',
      r'''Α''',
      r'''Μ''',
      r'''Ι''',
      r'''Ι''',
      r'''Α''',
      r'''Σ''',
      r'''Ο''',
      r'''Ν''',
      r'''Δ'''
    ],
    'MONTHS': <dynamic>[
      r'''Ιανουαρίου''',
      r'''Φεβρουαρίου''',
      r'''Μαρτίου''',
      r'''Απριλίου''',
      r'''Μαΐου''',
      r'''Ιουνίου''',
      r'''Ιουλίου''',
      r'''Αυγούστου''',
      r'''Σεπτεμβρίου''',
      r'''Οκτωβρίου''',
      r'''Νοεμβρίου''',
      r'''Δεκεμβρίου'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Ιανουάριος''',
      r'''Φεβρουάριος''',
      r'''Μάρτιος''',
      r'''Απρίλιος''',
      r'''Μάιος''',
      r'''Ιούνιος''',
      r'''Ιούλιος''',
      r'''Αύγουστος''',
      r'''Σεπτέμβριος''',
      r'''Οκτώβριος''',
      r'''Νοέμβριος''',
      r'''Δεκέμβριος'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Ιαν''',
      r'''Φεβ''',
      r'''Μαρ''',
      r'''Απρ''',
      r'''Μαΐ''',
      r'''Ιουν''',
      r'''Ιουλ''',
      r'''Αυγ''',
      r'''Σεπ''',
      r'''Οκτ''',
      r'''Νοε''',
      r'''Δεκ'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Ιαν''',
      r'''Φεβ''',
      r'''Μάρ''',
      r'''Απρ''',
      r'''Μάι''',
      r'''Ιούν''',
      r'''Ιούλ''',
      r'''Αύγ''',
      r'''Σεπ''',
      r'''Οκτ''',
      r'''Νοέ''',
      r'''Δεκ'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Κυριακή''',
      r'''Δευτέρα''',
      r'''Τρίτη''',
      r'''Τετάρτη''',
      r'''Πέμπτη''',
      r'''Παρασκευή''',
      r'''Σάββατο'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Κυριακή''',
      r'''Δευτέρα''',
      r'''Τρίτη''',
      r'''Τετάρτη''',
      r'''Πέμπτη''',
      r'''Παρασκευή''',
      r'''Σάββατο'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Κυρ''',
      r'''Δευ''',
      r'''Τρί''',
      r'''Τετ''',
      r'''Πέμ''',
      r'''Παρ''',
      r'''Σάβ'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Κυρ''',
      r'''Δευ''',
      r'''Τρί''',
      r'''Τετ''',
      r'''Πέμ''',
      r'''Παρ''',
      r'''Σάβ'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''Κ''',
      r'''Δ''',
      r'''Τ''',
      r'''Τ''',
      r'''Π''',
      r'''Π''',
      r'''Σ'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''Κ''',
      r'''Δ''',
      r'''Τ''',
      r'''Τ''',
      r'''Π''',
      r'''Π''',
      r'''Σ'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Τ1''', r'''Τ2''', r'''Τ3''', r'''Τ4'''],
    'QUARTERS': <dynamic>[
      r'''1ο τρίμηνο''',
      r'''2ο τρίμηνο''',
      r'''3ο τρίμηνο''',
      r'''4ο τρίμηνο'''
    ],
    'AMPMS': <dynamic>[r'''π.μ.''', r'''μ.μ.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} - {0}''',
      r'''{1} - {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'en': <String, dynamic>{
    'NAME': r'''en''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1st quarter''',
      r'''2nd quarter''',
      r'''3rd quarter''',
      r'''4th quarter'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, MMMM d, y''',
      r'''MMMM d, y''',
      r'''MMM d, y''',
      r'''M/d/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'at' {0}""",
      r"""{1} 'at' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'en_AU': <String, dynamic>{
    'NAME': r'''en_AU''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan.''',
      r'''Feb.''',
      r'''Mar.''',
      r'''Apr.''',
      r'''May''',
      r'''Jun.''',
      r'''Jul.''',
      r'''Aug.''',
      r'''Sep.''',
      r'''Oct.''',
      r'''Nov.''',
      r'''Dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan.''',
      r'''Feb.''',
      r'''Mar.''',
      r'''Apr.''',
      r'''May''',
      r'''Jun.''',
      r'''Jul.''',
      r'''Aug.''',
      r'''Sep.''',
      r'''Oct.''',
      r'''Nov.''',
      r'''Dec.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Sun.''',
      r'''Mon.''',
      r'''Tue.''',
      r'''Wed.''',
      r'''Thu.''',
      r'''Fri.''',
      r'''Sat.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Sun.''',
      r'''Mon.''',
      r'''Tue.''',
      r'''Wed.''',
      r'''Thu.''',
      r'''Fri.''',
      r'''Sat.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''Su.''',
      r'''M.''',
      r'''Tu.''',
      r'''W.''',
      r'''Th.''',
      r'''F.''',
      r'''Sa.'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''Su.''',
      r'''M.''',
      r'''Tu.''',
      r'''W.''',
      r'''Th.''',
      r'''F.''',
      r'''Sa.'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1st quarter''',
      r'''2nd quarter''',
      r'''3rd quarter''',
      r'''4th quarter'''
    ],
    'AMPMS': <dynamic>[r'''am''', r'''pm'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'at' {0}""",
      r"""{1} 'at' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'en_CA': <String, dynamic>{
    'NAME': r'''en_CA''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan.''',
      r'''Feb.''',
      r'''Mar.''',
      r'''Apr.''',
      r'''May''',
      r'''Jun.''',
      r'''Jul.''',
      r'''Aug.''',
      r'''Sep.''',
      r'''Oct.''',
      r'''Nov.''',
      r'''Dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Sun.''',
      r'''Mon.''',
      r'''Tue.''',
      r'''Wed.''',
      r'''Thu.''',
      r'''Fri.''',
      r'''Sat.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Sun.''',
      r'''Mon.''',
      r'''Tue.''',
      r'''Wed.''',
      r'''Thu.''',
      r'''Fri.''',
      r'''Sat.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1st quarter''',
      r'''2nd quarter''',
      r'''3rd quarter''',
      r'''4th quarter'''
    ],
    'AMPMS': <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, MMMM d, y''',
      r'''MMMM d, y''',
      r'''MMM d, y''',
      r'''y-MM-dd'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'at' {0}""",
      r"""{1} 'at' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'en_GB': <String, dynamic>{
    'NAME': r'''en_GB''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1st quarter''',
      r'''2nd quarter''',
      r'''3rd quarter''',
      r'''4th quarter'''
    ],
    'AMPMS': <dynamic>[r'''am''', r'''pm'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd/MM/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'at' {0}""",
      r"""{1} 'at' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'en_IE': <String, dynamic>{
    'NAME': r'''en_IE''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1st quarter''',
      r'''2nd quarter''',
      r'''3rd quarter''',
      r'''4th quarter'''
    ],
    'AMPMS': <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd/MM/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 2,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'at' {0}""",
      r"""{1} 'at' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'en_IN': <String, dynamic>{
    'NAME': r'''en_IN''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1st quarter''',
      r'''2nd quarter''',
      r'''3rd quarter''',
      r'''4th quarter'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM, y''',
      r'''d MMMM y''',
      r'''dd-MMM-y''',
      r'''dd/MM/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[6, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'at' {0}""",
      r"""{1} 'at' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'en_SG': <String, dynamic>{
    'NAME': r'''en_SG''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1st quarter''',
      r'''2nd quarter''',
      r'''3rd quarter''',
      r'''4th quarter'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'at' {0}""",
      r"""{1} 'at' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'en_ZA': <String, dynamic>{
    'NAME': r'''en_ZA''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''January''',
      r'''February''',
      r'''March''',
      r'''April''',
      r'''May''',
      r'''June''',
      r'''July''',
      r'''August''',
      r'''September''',
      r'''October''',
      r'''November''',
      r'''December'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''May''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Oct''',
      r'''Nov''',
      r'''Dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sunday''',
      r'''Monday''',
      r'''Tuesday''',
      r'''Wednesday''',
      r'''Thursday''',
      r'''Friday''',
      r'''Saturday'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Sun''',
      r'''Mon''',
      r'''Tue''',
      r'''Wed''',
      r'''Thu''',
      r'''Fri''',
      r'''Sat'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1st quarter''',
      r'''2nd quarter''',
      r'''3rd quarter''',
      r'''4th quarter'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, dd MMMM y''',
      r'''dd MMMM y''',
      r'''dd MMM y''',
      r'''y/MM/dd'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'at' {0}""",
      r"""{1} 'at' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'es': <String, dynamic>{
    'NAME': r'''es''',
    'ERAS': <dynamic>[r'''a. C.''', r'''d. C.'''],
    'ERANAMES': <dynamic>[r'''antes de Cristo''', r'''después de Cristo'''],
    'NARROWMONTHS': <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''ene.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''may.''',
      r'''jun.''',
      r'''jul.''',
      r'''ago.''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''dic.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''ene.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''may.''',
      r'''jun.''',
      r'''jul.''',
      r'''ago.''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''dic.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''X''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''X''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''T1''', r'''T2''', r'''T3''', r'''T4'''],
    'QUARTERS': <dynamic>[
      r'''1.er trimestre''',
      r'''2.º trimestre''',
      r'''3.er trimestre''',
      r'''4.º trimestre'''
    ],
    'AMPMS': <dynamic>[r'''a. m.''', r'''p. m.'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d 'de' MMMM 'de' y""",
      r"""d 'de' MMMM 'de' y""",
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss (zzzz)''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'es_419': <String, dynamic>{
    'NAME': r'''es_419''',
    'ERAS': <dynamic>[r'''a. C.''', r'''d. C.'''],
    'ERANAMES': <dynamic>[r'''antes de Cristo''', r'''después de Cristo'''],
    'NARROWMONTHS': <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''ene.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''may.''',
      r'''jun.''',
      r'''jul.''',
      r'''ago.''',
      r'''sep.''',
      r'''oct.''',
      r'''nov.''',
      r'''dic.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''ene.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''may.''',
      r'''jun.''',
      r'''jul.''',
      r'''ago.''',
      r'''sep.''',
      r'''oct.''',
      r'''nov.''',
      r'''dic.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''d''',
      r'''l''',
      r'''m''',
      r'''m''',
      r'''j''',
      r'''v''',
      r'''s'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''T1''', r'''T2''', r'''T3''', r'''T4'''],
    'QUARTERS': <dynamic>[
      r'''1.º trimestre''',
      r'''2.º trimestre''',
      r'''3.º trimestre''',
      r'''4.º trimestre'''
    ],
    'AMPMS': <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d 'de' MMMM 'de' y""",
      r"""d 'de' MMMM 'de' y""",
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'es_MX': <String, dynamic>{
    'NAME': r'''es_MX''',
    'ERAS': <dynamic>[r'''a. C.''', r'''d. C.'''],
    'ERANAMES': <dynamic>[r'''antes de Cristo''', r'''después de Cristo'''],
    'NARROWMONTHS': <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''ene''',
      r'''feb''',
      r'''mar''',
      r'''abr''',
      r'''may''',
      r'''jun''',
      r'''jul''',
      r'''ago''',
      r'''sep''',
      r'''oct''',
      r'''nov''',
      r'''dic'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''ene.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''may.''',
      r'''jun.''',
      r'''jul.''',
      r'''ago.''',
      r'''sep.''',
      r'''oct.''',
      r'''nov.''',
      r'''dic.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''1er. trim.''',
      r'''2º. trim.''',
      r'''3er. trim.''',
      r'''4º trim.'''
    ],
    'QUARTERS': <dynamic>[
      r'''1.er trimestre''',
      r'''2º. trimestre''',
      r'''3.er trimestre''',
      r'''4o. trimestre'''
    ],
    'AMPMS': <dynamic>[r'''a. m.''', r'''p. m.'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d 'de' MMMM 'de' y""",
      r"""d 'de' MMMM 'de' y""",
      r'''d MMM y''',
      r'''dd/MM/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'es_US': <String, dynamic>{
    'NAME': r'''es_US''',
    'ERAS': <dynamic>[r'''a. C.''', r'''d. C.'''],
    'ERANAMES': <dynamic>[r'''antes de Cristo''', r'''después de Cristo'''],
    'NARROWMONTHS': <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''E''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''enero''',
      r'''febrero''',
      r'''marzo''',
      r'''abril''',
      r'''mayo''',
      r'''junio''',
      r'''julio''',
      r'''agosto''',
      r'''septiembre''',
      r'''octubre''',
      r'''noviembre''',
      r'''diciembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''ene.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''may.''',
      r'''jun.''',
      r'''jul.''',
      r'''ago.''',
      r'''sep.''',
      r'''oct.''',
      r'''nov.''',
      r'''dic.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''ene.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''may.''',
      r'''jun.''',
      r'''jul.''',
      r'''ago.''',
      r'''sep.''',
      r'''oct.''',
      r'''nov.''',
      r'''dic.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''lunes''',
      r'''martes''',
      r'''miércoles''',
      r'''jueves''',
      r'''viernes''',
      r'''sábado'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dom.''',
      r'''lun.''',
      r'''mar.''',
      r'''mié.''',
      r'''jue.''',
      r'''vie.''',
      r'''sáb.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''T1''', r'''T2''', r'''T3''', r'''T4'''],
    'QUARTERS': <dynamic>[
      r'''1.er trimestre''',
      r'''2.º trimestre''',
      r'''3.er trimestre''',
      r'''4.º trimestre'''
    ],
    'AMPMS': <dynamic>[r'''a. m.''', r'''p. m.'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d 'de' MMMM 'de' y""",
      r"""d 'de' MMMM 'de' y""",
      r'''d MMM y''',
      r'''d/M/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'et': <String, dynamic>{
    'NAME': r'''et''',
    'ERAS': <dynamic>[r'''eKr''', r'''pKr'''],
    'ERANAMES': <dynamic>[r'''enne Kristust''', r'''pärast Kristust'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''V''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''V''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''jaanuar''',
      r'''veebruar''',
      r'''märts''',
      r'''aprill''',
      r'''mai''',
      r'''juuni''',
      r'''juuli''',
      r'''august''',
      r'''september''',
      r'''oktoober''',
      r'''november''',
      r'''detsember'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''jaanuar''',
      r'''veebruar''',
      r'''märts''',
      r'''aprill''',
      r'''mai''',
      r'''juuni''',
      r'''juuli''',
      r'''august''',
      r'''september''',
      r'''oktoober''',
      r'''november''',
      r'''detsember'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jaan''',
      r'''veebr''',
      r'''märts''',
      r'''apr''',
      r'''mai''',
      r'''juuni''',
      r'''juuli''',
      r'''aug''',
      r'''sept''',
      r'''okt''',
      r'''nov''',
      r'''dets'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jaan''',
      r'''veebr''',
      r'''märts''',
      r'''apr''',
      r'''mai''',
      r'''juuni''',
      r'''juuli''',
      r'''aug''',
      r'''sept''',
      r'''okt''',
      r'''nov''',
      r'''dets'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''pühapäev''',
      r'''esmaspäev''',
      r'''teisipäev''',
      r'''kolmapäev''',
      r'''neljapäev''',
      r'''reede''',
      r'''laupäev'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''pühapäev''',
      r'''esmaspäev''',
      r'''teisipäev''',
      r'''kolmapäev''',
      r'''neljapäev''',
      r'''reede''',
      r'''laupäev'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''P''',
      r'''E''',
      r'''T''',
      r'''K''',
      r'''N''',
      r'''R''',
      r'''L'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''P''',
      r'''E''',
      r'''T''',
      r'''K''',
      r'''N''',
      r'''R''',
      r'''L'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''P''',
      r'''E''',
      r'''T''',
      r'''K''',
      r'''N''',
      r'''R''',
      r'''L'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''P''',
      r'''E''',
      r'''T''',
      r'''K''',
      r'''N''',
      r'''R''',
      r'''L'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''K1''', r'''K2''', r'''K3''', r'''K4'''],
    'QUARTERS': <dynamic>[
      r'''1. kvartal''',
      r'''2. kvartal''',
      r'''3. kvartal''',
      r'''4. kvartal'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d. MMMM y''',
      r'''d. MMMM y''',
      r'''d. MMM y''',
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'fa': <String, dynamic>{
    'NAME': r'''fa''',
    'ERAS': <dynamic>[r'''ق.م.''', r'''م.'''],
    'ERANAMES': <dynamic>[r'''قبل از میلاد''', r'''میلادی'''],
    'NARROWMONTHS': <dynamic>[
      r'''ژ''',
      r'''ف''',
      r'''م''',
      r'''آ''',
      r'''م''',
      r'''ژ''',
      r'''ژ''',
      r'''ا''',
      r'''س''',
      r'''ا''',
      r'''ن''',
      r'''د'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''ژ''',
      r'''ف''',
      r'''م''',
      r'''آ''',
      r'''م''',
      r'''ژ''',
      r'''ژ''',
      r'''ا''',
      r'''س''',
      r'''ا''',
      r'''ن''',
      r'''د'''
    ],
    'MONTHS': <dynamic>[
      r'''ژانویهٔ''',
      r'''فوریهٔ''',
      r'''مارس''',
      r'''آوریل''',
      r'''مهٔ''',
      r'''ژوئن''',
      r'''ژوئیهٔ''',
      r'''اوت''',
      r'''سپتامبر''',
      r'''اکتبر''',
      r'''نوامبر''',
      r'''دسامبر'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''ژانویه''',
      r'''فوریه''',
      r'''مارس''',
      r'''آوریل''',
      r'''مه''',
      r'''ژوئن''',
      r'''ژوئیه''',
      r'''اوت''',
      r'''سپتامبر''',
      r'''اکتبر''',
      r'''نوامبر''',
      r'''دسامبر'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''ژانویهٔ''',
      r'''فوریهٔ''',
      r'''مارس''',
      r'''آوریل''',
      r'''مهٔ''',
      r'''ژوئن''',
      r'''ژوئیهٔ''',
      r'''اوت''',
      r'''سپتامبر''',
      r'''اکتبر''',
      r'''نوامبر''',
      r'''دسامبر'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''ژانویه''',
      r'''فوریه''',
      r'''مارس''',
      r'''آوریل''',
      r'''مه''',
      r'''ژوئن''',
      r'''ژوئیه''',
      r'''اوت''',
      r'''سپتامبر''',
      r'''اکتبر''',
      r'''نوامبر''',
      r'''دسامبر'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''یکشنبه''',
      r'''دوشنبه''',
      r'''سه‌شنبه''',
      r'''چهارشنبه''',
      r'''پنجشنبه''',
      r'''جمعه''',
      r'''شنبه'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''ی''',
      r'''د''',
      r'''س''',
      r'''چ''',
      r'''پ''',
      r'''ج''',
      r'''ش'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''ی''',
      r'''د''',
      r'''س''',
      r'''چ''',
      r'''پ''',
      r'''ج''',
      r'''ش'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''س‌م۱''',
      r'''س‌م۲''',
      r'''س‌م۳''',
      r'''س‌م۴'''
    ],
    'QUARTERS': <dynamic>[
      r'''سه‌ماههٔ اول''',
      r'''سه‌ماههٔ دوم''',
      r'''سه‌ماههٔ سوم''',
      r'''سه‌ماههٔ چهارم'''
    ],
    'AMPMS': <dynamic>[r'''قبل‌ازظهر''', r'''بعدازظهر'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''y/M/d'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss (zzzz)''',
      r'''H:mm:ss (z)''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 5,
    'WEEKENDRANGE': <dynamic>[4, 4],
    'FIRSTWEEKCUTOFFDAY': 4,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}، ساعت {0}''',
      r'''{1}، ساعت {0}''',
      r'''{1}،‏ {0}''',
      r'''{1}،‏ {0}'''
    ],
    'ZERODIGIT': r'''۰''',
  },
  'fi': <String, dynamic>{
    'NAME': r'''fi''',
    'ERAS': <dynamic>[r'''eKr.''', r'''jKr.'''],
    'ERANAMES': <dynamic>[
      r'''ennen Kristuksen syntymää''',
      r'''jälkeen Kristuksen syntymän'''
    ],
    'NARROWMONTHS': <dynamic>[
      r'''T''',
      r'''H''',
      r'''M''',
      r'''H''',
      r'''T''',
      r'''K''',
      r'''H''',
      r'''E''',
      r'''S''',
      r'''L''',
      r'''M''',
      r'''J'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''T''',
      r'''H''',
      r'''M''',
      r'''H''',
      r'''T''',
      r'''K''',
      r'''H''',
      r'''E''',
      r'''S''',
      r'''L''',
      r'''M''',
      r'''J'''
    ],
    'MONTHS': <dynamic>[
      r'''tammikuuta''',
      r'''helmikuuta''',
      r'''maaliskuuta''',
      r'''huhtikuuta''',
      r'''toukokuuta''',
      r'''kesäkuuta''',
      r'''heinäkuuta''',
      r'''elokuuta''',
      r'''syyskuuta''',
      r'''lokakuuta''',
      r'''marraskuuta''',
      r'''joulukuuta'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''tammikuu''',
      r'''helmikuu''',
      r'''maaliskuu''',
      r'''huhtikuu''',
      r'''toukokuu''',
      r'''kesäkuu''',
      r'''heinäkuu''',
      r'''elokuu''',
      r'''syyskuu''',
      r'''lokakuu''',
      r'''marraskuu''',
      r'''joulukuu'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''tammik.''',
      r'''helmik.''',
      r'''maalisk.''',
      r'''huhtik.''',
      r'''toukok.''',
      r'''kesäk.''',
      r'''heinäk.''',
      r'''elok.''',
      r'''syysk.''',
      r'''lokak.''',
      r'''marrask.''',
      r'''jouluk.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''tammi''',
      r'''helmi''',
      r'''maalis''',
      r'''huhti''',
      r'''touko''',
      r'''kesä''',
      r'''heinä''',
      r'''elo''',
      r'''syys''',
      r'''loka''',
      r'''marras''',
      r'''joulu'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''sunnuntaina''',
      r'''maanantaina''',
      r'''tiistaina''',
      r'''keskiviikkona''',
      r'''torstaina''',
      r'''perjantaina''',
      r'''lauantaina'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''sunnuntai''',
      r'''maanantai''',
      r'''tiistai''',
      r'''keskiviikko''',
      r'''torstai''',
      r'''perjantai''',
      r'''lauantai'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''su''',
      r'''ma''',
      r'''ti''',
      r'''ke''',
      r'''to''',
      r'''pe''',
      r'''la'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''su''',
      r'''ma''',
      r'''ti''',
      r'''ke''',
      r'''to''',
      r'''pe''',
      r'''la'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''K''',
      r'''T''',
      r'''P''',
      r'''L'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''K''',
      r'''T''',
      r'''P''',
      r'''L'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''1. nelj.''',
      r'''2. nelj.''',
      r'''3. nelj.''',
      r'''4. nelj.'''
    ],
    'QUARTERS': <dynamic>[
      r'''1. neljännes''',
      r'''2. neljännes''',
      r'''3. neljännes''',
      r'''4. neljännes'''
    ],
    'AMPMS': <dynamic>[r'''ap.''', r'''ip.'''],
    'DATEFORMATS': <dynamic>[
      r'''cccc d. MMMM y''',
      r'''d. MMMM y''',
      r'''d.M.y''',
      r'''d.M.y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H.mm.ss zzzz''',
      r'''H.mm.ss z''',
      r'''H.mm.ss''',
      r'''H.mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'klo' {0}""",
      r"""{1} 'klo' {0}""",
      r"""{1} 'klo' {0}""",
      r'''{1} {0}'''
    ],
  },
  'fil': <String, dynamic>{
    'NAME': r'''fil''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''Ene''',
      r'''Peb''',
      r'''Mar''',
      r'''Abr''',
      r'''May''',
      r'''Hun''',
      r'''Hul''',
      r'''Ago''',
      r'''Set''',
      r'''Okt''',
      r'''Nob''',
      r'''Dis'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''E''',
      r'''P''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''Hun''',
      r'''Hul''',
      r'''Ago''',
      r'''Set''',
      r'''Okt''',
      r'''Nob''',
      r'''Dis'''
    ],
    'MONTHS': <dynamic>[
      r'''Enero''',
      r'''Pebrero''',
      r'''Marso''',
      r'''Abril''',
      r'''Mayo''',
      r'''Hunyo''',
      r'''Hulyo''',
      r'''Agosto''',
      r'''Setyembre''',
      r'''Oktubre''',
      r'''Nobyembre''',
      r'''Disyembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Enero''',
      r'''Pebrero''',
      r'''Marso''',
      r'''Abril''',
      r'''Mayo''',
      r'''Hunyo''',
      r'''Hulyo''',
      r'''Agosto''',
      r'''Setyembre''',
      r'''Oktubre''',
      r'''Nobyembre''',
      r'''Disyembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Ene''',
      r'''Peb''',
      r'''Mar''',
      r'''Abr''',
      r'''May''',
      r'''Hun''',
      r'''Hul''',
      r'''Ago''',
      r'''Set''',
      r'''Okt''',
      r'''Nob''',
      r'''Dis'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Ene''',
      r'''Peb''',
      r'''Mar''',
      r'''Abr''',
      r'''May''',
      r'''Hun''',
      r'''Hul''',
      r'''Ago''',
      r'''Set''',
      r'''Okt''',
      r'''Nob''',
      r'''Dis'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Linggo''',
      r'''Lunes''',
      r'''Martes''',
      r'''Miyerkules''',
      r'''Huwebes''',
      r'''Biyernes''',
      r'''Sabado'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Linggo''',
      r'''Lunes''',
      r'''Martes''',
      r'''Miyerkules''',
      r'''Huwebes''',
      r'''Biyernes''',
      r'''Sabado'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Lin''',
      r'''Lun''',
      r'''Mar''',
      r'''Miy''',
      r'''Huw''',
      r'''Biy''',
      r'''Sab'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Lin''',
      r'''Lun''',
      r'''Mar''',
      r'''Miy''',
      r'''Huw''',
      r'''Biy''',
      r'''Sab'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''Lin''',
      r'''Lun''',
      r'''Mar''',
      r'''Miy''',
      r'''Huw''',
      r'''Biy''',
      r'''Sab'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''Lin''',
      r'''Lun''',
      r'''Mar''',
      r'''Miy''',
      r'''Huw''',
      r'''Biy''',
      r'''Sab'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''ika-1 quarter''',
      r'''ika-2 quarter''',
      r'''ika-3 quarter''',
      r'''ika-4 na quarter'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, MMMM d, y''',
      r'''MMMM d, y''',
      r'''MMM d, y''',
      r'''M/d/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'nang' {0}""",
      r"""{1} 'nang' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'fr': <String, dynamic>{
    'NAME': r'''fr''',
    'ERAS': <dynamic>[r'''av. J.-C.''', r'''ap. J.-C.'''],
    'ERANAMES': <dynamic>[r'''avant Jésus-Christ''', r'''après Jésus-Christ'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''janvier''',
      r'''février''',
      r'''mars''',
      r'''avril''',
      r'''mai''',
      r'''juin''',
      r'''juillet''',
      r'''août''',
      r'''septembre''',
      r'''octobre''',
      r'''novembre''',
      r'''décembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''janvier''',
      r'''février''',
      r'''mars''',
      r'''avril''',
      r'''mai''',
      r'''juin''',
      r'''juillet''',
      r'''août''',
      r'''septembre''',
      r'''octobre''',
      r'''novembre''',
      r'''décembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''janv.''',
      r'''févr.''',
      r'''mars''',
      r'''avr.''',
      r'''mai''',
      r'''juin''',
      r'''juil.''',
      r'''août''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''déc.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''janv.''',
      r'''févr.''',
      r'''mars''',
      r'''avr.''',
      r'''mai''',
      r'''juin''',
      r'''juil.''',
      r'''août''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''déc.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''dimanche''',
      r'''lundi''',
      r'''mardi''',
      r'''mercredi''',
      r'''jeudi''',
      r'''vendredi''',
      r'''samedi'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''dimanche''',
      r'''lundi''',
      r'''mardi''',
      r'''mercredi''',
      r'''jeudi''',
      r'''vendredi''',
      r'''samedi'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dim.''',
      r'''lun.''',
      r'''mar.''',
      r'''mer.''',
      r'''jeu.''',
      r'''ven.''',
      r'''sam.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dim.''',
      r'''lun.''',
      r'''mar.''',
      r'''mer.''',
      r'''jeu.''',
      r'''ven.''',
      r'''sam.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''T1''', r'''T2''', r'''T3''', r'''T4'''],
    'QUARTERS': <dynamic>[
      r'''1er trimestre''',
      r'''2e trimestre''',
      r'''3e trimestre''',
      r'''4e trimestre'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd/MM/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'à' {0}""",
      r"""{1} 'à' {0}""",
      r"""{1} 'à' {0}""",
      r'''{1} {0}'''
    ],
  },
  'fr_CA': <String, dynamic>{
    'NAME': r'''fr_CA''',
    'ERAS': <dynamic>[r'''av. J.-C.''', r'''ap. J.-C.'''],
    'ERANAMES': <dynamic>[r'''avant Jésus-Christ''', r'''après Jésus-Christ'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''janvier''',
      r'''février''',
      r'''mars''',
      r'''avril''',
      r'''mai''',
      r'''juin''',
      r'''juillet''',
      r'''août''',
      r'''septembre''',
      r'''octobre''',
      r'''novembre''',
      r'''décembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''janvier''',
      r'''février''',
      r'''mars''',
      r'''avril''',
      r'''mai''',
      r'''juin''',
      r'''juillet''',
      r'''août''',
      r'''septembre''',
      r'''octobre''',
      r'''novembre''',
      r'''décembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''janv.''',
      r'''févr.''',
      r'''mars''',
      r'''avr.''',
      r'''mai''',
      r'''juin''',
      r'''juill.''',
      r'''août''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''déc.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''janv.''',
      r'''févr.''',
      r'''mars''',
      r'''avr.''',
      r'''mai''',
      r'''juin''',
      r'''juill.''',
      r'''août''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''déc.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''dimanche''',
      r'''lundi''',
      r'''mardi''',
      r'''mercredi''',
      r'''jeudi''',
      r'''vendredi''',
      r'''samedi'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''dimanche''',
      r'''lundi''',
      r'''mardi''',
      r'''mercredi''',
      r'''jeudi''',
      r'''vendredi''',
      r'''samedi'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dim.''',
      r'''lun.''',
      r'''mar.''',
      r'''mer.''',
      r'''jeu.''',
      r'''ven.''',
      r'''sam.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dim.''',
      r'''lun.''',
      r'''mar.''',
      r'''mer.''',
      r'''jeu.''',
      r'''ven.''',
      r'''sam.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''T1''', r'''T2''', r'''T3''', r'''T4'''],
    'QUARTERS': <dynamic>[
      r'''1er trimestre''',
      r'''2e trimestre''',
      r'''3e trimestre''',
      r'''4e trimestre'''
    ],
    'AMPMS': <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''yy-MM-dd'''
    ],
    'TIMEFORMATS': <dynamic>[
      r"""HH 'h' mm 'min' ss 's' zzzz""",
      r"""HH 'h' mm 'min' ss 's' z""",
      r"""HH 'h' mm 'min' ss 's'""",
      r"""HH 'h' mm"""
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'à' {0}""",
      r"""{1} 'à' {0}""",
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'gl': <String, dynamic>{
    'NAME': r'''gl''',
    'ERAS': <dynamic>[r'''a.C.''', r'''d.C.'''],
    'ERANAMES': <dynamic>[r'''antes de Cristo''', r'''despois de Cristo'''],
    'NARROWMONTHS': <dynamic>[
      r'''x.''',
      r'''f.''',
      r'''m.''',
      r'''a.''',
      r'''m.''',
      r'''x.''',
      r'''x.''',
      r'''a.''',
      r'''s.''',
      r'''o.''',
      r'''n.''',
      r'''d.'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''X''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''X''',
      r'''X''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''xaneiro''',
      r'''febreiro''',
      r'''marzo''',
      r'''abril''',
      r'''maio''',
      r'''xuño''',
      r'''xullo''',
      r'''agosto''',
      r'''setembro''',
      r'''outubro''',
      r'''novembro''',
      r'''decembro'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Xaneiro''',
      r'''Febreiro''',
      r'''Marzo''',
      r'''Abril''',
      r'''Maio''',
      r'''Xuño''',
      r'''Xullo''',
      r'''Agosto''',
      r'''Setembro''',
      r'''Outubro''',
      r'''Novembro''',
      r'''Decembro'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''xan.''',
      r'''feb.''',
      r'''mar.''',
      r'''abr.''',
      r'''maio''',
      r'''xuño''',
      r'''xul.''',
      r'''ago.''',
      r'''set.''',
      r'''out.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Xan.''',
      r'''Feb.''',
      r'''Mar.''',
      r'''Abr.''',
      r'''Maio''',
      r'''Xuño''',
      r'''Xul.''',
      r'''Ago.''',
      r'''Set.''',
      r'''Out.''',
      r'''Nov.''',
      r'''Dec.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''luns''',
      r'''martes''',
      r'''mércores''',
      r'''xoves''',
      r'''venres''',
      r'''sábado'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Domingo''',
      r'''Luns''',
      r'''Martes''',
      r'''Mércores''',
      r'''Xoves''',
      r'''Venres''',
      r'''Sábado'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dom.''',
      r'''luns''',
      r'''mar.''',
      r'''mér.''',
      r'''xov.''',
      r'''ven.''',
      r'''sáb.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Dom.''',
      r'''Luns''',
      r'''Mar.''',
      r'''Mér.''',
      r'''Xov.''',
      r'''Ven.''',
      r'''Sáb.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''d.''',
      r'''l.''',
      r'''m.''',
      r'''m.''',
      r'''x.''',
      r'''v.''',
      r'''s.'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''X''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''T1''', r'''T2''', r'''T3''', r'''T4'''],
    'QUARTERS': <dynamic>[
      r'''1.º trimestre''',
      r'''2.º trimestre''',
      r'''3.º trimestre''',
      r'''4.º trimestre'''
    ],
    'AMPMS': <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d 'de' MMMM 'de' y""",
      r"""d 'de' MMMM 'de' y""",
      r'''dd/MM/y''',
      r'''dd/MM/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{0} 'do' {1}""",
      r"""{0} 'do' {1}""",
      r'''{0}, {1}''',
      r'''{0}, {1}'''
    ],
  },
  'gsw': <String, dynamic>{
    'NAME': r'''gsw''',
    'ERAS': <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'ERANAMES': <dynamic>[r'''v. Chr.''', r'''n. Chr.'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''Auguscht''',
      r'''Septämber''',
      r'''Oktoober''',
      r'''Novämber''',
      r'''Dezämber'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Januar''',
      r'''Februar''',
      r'''März''',
      r'''April''',
      r'''Mai''',
      r'''Juni''',
      r'''Juli''',
      r'''Auguscht''',
      r'''Septämber''',
      r'''Oktoober''',
      r'''Novämber''',
      r'''Dezämber'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mär''',
      r'''Apr''',
      r'''Mai''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Dez'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mär''',
      r'''Apr''',
      r'''Mai''',
      r'''Jun''',
      r'''Jul''',
      r'''Aug''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Dez'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Sunntig''',
      r'''Määntig''',
      r'''Ziischtig''',
      r'''Mittwuch''',
      r'''Dunschtig''',
      r'''Friitig''',
      r'''Samschtig'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Sunntig''',
      r'''Määntig''',
      r'''Ziischtig''',
      r'''Mittwuch''',
      r'''Dunschtig''',
      r'''Friitig''',
      r'''Samschtig'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Su.''',
      r'''Mä.''',
      r'''Zi.''',
      r'''Mi.''',
      r'''Du.''',
      r'''Fr.''',
      r'''Sa.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Su.''',
      r'''Mä.''',
      r'''Zi.''',
      r'''Mi.''',
      r'''Du.''',
      r'''Fr.''',
      r'''Sa.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''D''',
      r'''M''',
      r'''D''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1. Quartal''',
      r'''2. Quartal''',
      r'''3. Quartal''',
      r'''4. Quartal'''
    ],
    'AMPMS': <dynamic>[r'''am Vormittag''', r'''am Namittag'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d. MMMM y''',
      r'''d. MMMM y''',
      r'''dd.MM.y''',
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'he': <String, dynamic>{
    'NAME': r'''he''',
    'ERAS': <dynamic>[r'''לפנה״ס''', r'''לספירה'''],
    'ERANAMES': <dynamic>[r'''לפני הספירה''', r'''לספירה'''],
    'NARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': <dynamic>[
      r'''ינואר''',
      r'''פברואר''',
      r'''מרץ''',
      r'''אפריל''',
      r'''מאי''',
      r'''יוני''',
      r'''יולי''',
      r'''אוגוסט''',
      r'''ספטמבר''',
      r'''אוקטובר''',
      r'''נובמבר''',
      r'''דצמבר'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''ינואר''',
      r'''פברואר''',
      r'''מרץ''',
      r'''אפריל''',
      r'''מאי''',
      r'''יוני''',
      r'''יולי''',
      r'''אוגוסט''',
      r'''ספטמבר''',
      r'''אוקטובר''',
      r'''נובמבר''',
      r'''דצמבר'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''ינו׳''',
      r'''פבר׳''',
      r'''מרץ''',
      r'''אפר׳''',
      r'''מאי''',
      r'''יוני''',
      r'''יולי''',
      r'''אוג׳''',
      r'''ספט׳''',
      r'''אוק׳''',
      r'''נוב׳''',
      r'''דצמ׳'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''ינו׳''',
      r'''פבר׳''',
      r'''מרץ''',
      r'''אפר׳''',
      r'''מאי''',
      r'''יוני''',
      r'''יולי''',
      r'''אוג׳''',
      r'''ספט׳''',
      r'''אוק׳''',
      r'''נוב׳''',
      r'''דצמ׳'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''יום ראשון''',
      r'''יום שני''',
      r'''יום שלישי''',
      r'''יום רביעי''',
      r'''יום חמישי''',
      r'''יום שישי''',
      r'''יום שבת'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''יום ראשון''',
      r'''יום שני''',
      r'''יום שלישי''',
      r'''יום רביעי''',
      r'''יום חמישי''',
      r'''יום שישי''',
      r'''יום שבת'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''יום א׳''',
      r'''יום ב׳''',
      r'''יום ג׳''',
      r'''יום ד׳''',
      r'''יום ה׳''',
      r'''יום ו׳''',
      r'''שבת'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''יום א׳''',
      r'''יום ב׳''',
      r'''יום ג׳''',
      r'''יום ד׳''',
      r'''יום ה׳''',
      r'''יום ו׳''',
      r'''שבת'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''א׳''',
      r'''ב׳''',
      r'''ג׳''',
      r'''ד׳''',
      r'''ה׳''',
      r'''ו׳''',
      r'''ש׳'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''א׳''',
      r'''ב׳''',
      r'''ג׳''',
      r'''ד׳''',
      r'''ה׳''',
      r'''ו׳''',
      r'''ש׳'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''רבעון 1''',
      r'''רבעון 2''',
      r'''רבעון 3''',
      r'''רבעון 4'''
    ],
    'AMPMS': <dynamic>[r'''לפנה״צ''', r'''אחה״צ'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d בMMMM y''',
      r'''d בMMMM y''',
      r'''d בMMM y''',
      r'''d.M.y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[4, 5],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} בשעה {0}''',
      r'''{1} בשעה {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'hi': <String, dynamic>{
    'NAME': r'''hi''',
    'ERAS': <dynamic>[r'''ईसा-पूर्व''', r'''ईस्वी'''],
    'ERANAMES': <dynamic>[r'''ईसा-पूर्व''', r'''ईसवी सन'''],
    'NARROWMONTHS': <dynamic>[
      r'''ज''',
      r'''फ़''',
      r'''मा''',
      r'''अ''',
      r'''म''',
      r'''जू''',
      r'''जु''',
      r'''अ''',
      r'''सि''',
      r'''अ''',
      r'''न''',
      r'''दि'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''ज''',
      r'''फ़''',
      r'''मा''',
      r'''अ''',
      r'''म''',
      r'''जू''',
      r'''जु''',
      r'''अ''',
      r'''सि''',
      r'''अ''',
      r'''न''',
      r'''दि'''
    ],
    'MONTHS': <dynamic>[
      r'''जनवरी''',
      r'''फ़रवरी''',
      r'''मार्च''',
      r'''अप्रैल''',
      r'''मई''',
      r'''जून''',
      r'''जुलाई''',
      r'''अगस्त''',
      r'''सितंबर''',
      r'''अक्तूबर''',
      r'''नवंबर''',
      r'''दिसंबर'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''जनवरी''',
      r'''फ़रवरी''',
      r'''मार्च''',
      r'''अप्रैल''',
      r'''मई''',
      r'''जून''',
      r'''जुलाई''',
      r'''अगस्त''',
      r'''सितंबर''',
      r'''अक्तूबर''',
      r'''नवंबर''',
      r'''दिसंबर'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''जन॰''',
      r'''फ़र॰''',
      r'''मार्च''',
      r'''अप्रैल''',
      r'''मई''',
      r'''जून''',
      r'''जुल॰''',
      r'''अग॰''',
      r'''सित॰''',
      r'''अक्तू॰''',
      r'''नव॰''',
      r'''दिस॰'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''जन॰''',
      r'''फ़र॰''',
      r'''मार्च''',
      r'''अप्रैल''',
      r'''मई''',
      r'''जून''',
      r'''जुल॰''',
      r'''अग॰''',
      r'''सित॰''',
      r'''अक्तू॰''',
      r'''नव॰''',
      r'''दिस॰'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''रविवार''',
      r'''सोमवार''',
      r'''मंगलवार''',
      r'''बुधवार''',
      r'''गुरुवार''',
      r'''शुक्रवार''',
      r'''शनिवार'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''रविवार''',
      r'''सोमवार''',
      r'''मंगलवार''',
      r'''बुधवार''',
      r'''गुरुवार''',
      r'''शुक्रवार''',
      r'''शनिवार'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''रवि''',
      r'''सोम''',
      r'''मंगल''',
      r'''बुध''',
      r'''गुरु''',
      r'''शुक्र''',
      r'''शनि'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''रवि''',
      r'''सोम''',
      r'''मंगल''',
      r'''बुध''',
      r'''गुरु''',
      r'''शुक्र''',
      r'''शनि'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''र''',
      r'''सो''',
      r'''मं''',
      r'''बु''',
      r'''गु''',
      r'''शु''',
      r'''श'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''र''',
      r'''सो''',
      r'''मं''',
      r'''बु''',
      r'''गु''',
      r'''शु''',
      r'''श'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''ति1''', r'''ति2''', r'''ति3''', r'''ति4'''],
    'QUARTERS': <dynamic>[
      r'''पहली तिमाही''',
      r'''दूसरी तिमाही''',
      r'''तीसरी तिमाही''',
      r'''चौथी तिमाही'''
    ],
    'AMPMS': <dynamic>[r'''am''', r'''pm'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[6, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} को {0}''',
      r'''{1} को {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'hr': <String, dynamic>{
    'NAME': r'''hr''',
    'ERAS': <dynamic>[r'''pr. Kr.''', r'''po. Kr.'''],
    'ERANAMES': <dynamic>[r'''prije Krista''', r'''poslije Krista'''],
    'NARROWMONTHS': <dynamic>[
      r'''1.''',
      r'''2.''',
      r'''3.''',
      r'''4.''',
      r'''5.''',
      r'''6.''',
      r'''7.''',
      r'''8.''',
      r'''9.''',
      r'''10.''',
      r'''11.''',
      r'''12.'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1.''',
      r'''2.''',
      r'''3.''',
      r'''4.''',
      r'''5.''',
      r'''6.''',
      r'''7.''',
      r'''8.''',
      r'''9.''',
      r'''10.''',
      r'''11.''',
      r'''12.'''
    ],
    'MONTHS': <dynamic>[
      r'''siječnja''',
      r'''veljače''',
      r'''ožujka''',
      r'''travnja''',
      r'''svibnja''',
      r'''lipnja''',
      r'''srpnja''',
      r'''kolovoza''',
      r'''rujna''',
      r'''listopada''',
      r'''studenoga''',
      r'''prosinca'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''siječanj''',
      r'''veljača''',
      r'''ožujak''',
      r'''travanj''',
      r'''svibanj''',
      r'''lipanj''',
      r'''srpanj''',
      r'''kolovoz''',
      r'''rujan''',
      r'''listopad''',
      r'''studeni''',
      r'''prosinac'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''sij''',
      r'''velj''',
      r'''ožu''',
      r'''tra''',
      r'''svi''',
      r'''lip''',
      r'''srp''',
      r'''kol''',
      r'''ruj''',
      r'''lis''',
      r'''stu''',
      r'''pro'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''sij''',
      r'''velj''',
      r'''ožu''',
      r'''tra''',
      r'''svi''',
      r'''lip''',
      r'''srp''',
      r'''kol''',
      r'''ruj''',
      r'''lis''',
      r'''stu''',
      r'''pro'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''nedjelja''',
      r'''ponedjeljak''',
      r'''utorak''',
      r'''srijeda''',
      r'''četvrtak''',
      r'''petak''',
      r'''subota'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''nedjelja''',
      r'''ponedjeljak''',
      r'''utorak''',
      r'''srijeda''',
      r'''četvrtak''',
      r'''petak''',
      r'''subota'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''ned''',
      r'''pon''',
      r'''uto''',
      r'''sri''',
      r'''čet''',
      r'''pet''',
      r'''sub'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''ned''',
      r'''pon''',
      r'''uto''',
      r'''sri''',
      r'''čet''',
      r'''pet''',
      r'''sub'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''N''',
      r'''P''',
      r'''U''',
      r'''S''',
      r'''Č''',
      r'''P''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''n''',
      r'''p''',
      r'''u''',
      r'''s''',
      r'''č''',
      r'''p''',
      r'''s'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''1kv''', r'''2kv''', r'''3kv''', r'''4kv'''],
    'QUARTERS': <dynamic>[
      r'''1. kvartal''',
      r'''2. kvartal''',
      r'''3. kvartal''',
      r'''4. kvartal'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d. MMMM y.''',
      r'''d. MMMM y.''',
      r'''d. MMM y.''',
      r'''dd. MM. y.'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss (zzzz)''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'u' {0}""",
      r"""{1} 'u' {0}""",
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'hu': <String, dynamic>{
    'NAME': r'''hu''',
    'ERAS': <dynamic>[r'''i. e.''', r'''i. sz.'''],
    'ERANAMES': <dynamic>[r'''Krisztus előtt''', r'''időszámításunk szerint'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''Á''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''Sz''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''Á''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''Sz''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''január''',
      r'''február''',
      r'''március''',
      r'''április''',
      r'''május''',
      r'''június''',
      r'''július''',
      r'''augusztus''',
      r'''szeptember''',
      r'''október''',
      r'''november''',
      r'''december'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''január''',
      r'''február''',
      r'''március''',
      r'''április''',
      r'''május''',
      r'''június''',
      r'''július''',
      r'''augusztus''',
      r'''szeptember''',
      r'''október''',
      r'''november''',
      r'''december'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''febr.''',
      r'''márc.''',
      r'''ápr.''',
      r'''máj.''',
      r'''jún.''',
      r'''júl.''',
      r'''aug.''',
      r'''szept.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''febr.''',
      r'''márc.''',
      r'''ápr.''',
      r'''máj.''',
      r'''jún.''',
      r'''júl.''',
      r'''aug.''',
      r'''szept.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''vasárnap''',
      r'''hétfő''',
      r'''kedd''',
      r'''szerda''',
      r'''csütörtök''',
      r'''péntek''',
      r'''szombat'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''vasárnap''',
      r'''hétfő''',
      r'''kedd''',
      r'''szerda''',
      r'''csütörtök''',
      r'''péntek''',
      r'''szombat'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''V''',
      r'''H''',
      r'''K''',
      r'''Sze''',
      r'''Cs''',
      r'''P''',
      r'''Szo'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''V''',
      r'''H''',
      r'''K''',
      r'''Sze''',
      r'''Cs''',
      r'''P''',
      r'''Szo'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''V''',
      r'''H''',
      r'''K''',
      r'''Sz''',
      r'''Cs''',
      r'''P''',
      r'''Sz'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''V''',
      r'''H''',
      r'''K''',
      r'''Sz''',
      r'''Cs''',
      r'''P''',
      r'''Sz'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''I. n.év''',
      r'''II. n.év''',
      r'''III. n.év''',
      r'''IV. n.év'''
    ],
    'QUARTERS': <dynamic>[
      r'''I. negyedév''',
      r'''II. negyedév''',
      r'''III. negyedév''',
      r'''IV. negyedév'''
    ],
    'AMPMS': <dynamic>[r'''de.''', r'''du.'''],
    'DATEFORMATS': <dynamic>[
      r'''y. MMMM d., EEEE''',
      r'''y. MMMM d.''',
      r'''y. MMM d.''',
      r'''y. MM. dd.'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'hy': <String, dynamic>{
    'NAME': r'''hy''',
    'ERAS': <dynamic>[r'''մ.թ.ա.''', r'''մ.թ.'''],
    'ERANAMES': <dynamic>[r'''Քրիստոսից առաջ''', r'''Քրիստոսից հետո'''],
    'NARROWMONTHS': <dynamic>[
      r'''Հ''',
      r'''Փ''',
      r'''Մ''',
      r'''Ա''',
      r'''Մ''',
      r'''Հ''',
      r'''Հ''',
      r'''Օ''',
      r'''Ս''',
      r'''Հ''',
      r'''Ն''',
      r'''Դ'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''Հ''',
      r'''Փ''',
      r'''Մ''',
      r'''Ա''',
      r'''Մ''',
      r'''Հ''',
      r'''Հ''',
      r'''Օ''',
      r'''Ս''',
      r'''Հ''',
      r'''Ն''',
      r'''Դ'''
    ],
    'MONTHS': <dynamic>[
      r'''հունվարի''',
      r'''փետրվարի''',
      r'''մարտի''',
      r'''ապրիլի''',
      r'''մայիսի''',
      r'''հունիսի''',
      r'''հուլիսի''',
      r'''օգոստոսի''',
      r'''սեպտեմբերի''',
      r'''հոկտեմբերի''',
      r'''նոյեմբերի''',
      r'''դեկտեմբերի'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''հունվար''',
      r'''փետրվար''',
      r'''մարտ''',
      r'''ապրիլ''',
      r'''մայիս''',
      r'''հունիս''',
      r'''հուլիս''',
      r'''օգոստոս''',
      r'''սեպտեմբեր''',
      r'''հոկտեմբեր''',
      r'''նոյեմբեր''',
      r'''դեկտեմբեր'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''հնվ''',
      r'''փտվ''',
      r'''մրտ''',
      r'''ապր''',
      r'''մյս''',
      r'''հնս''',
      r'''հլս''',
      r'''օգս''',
      r'''սեպ''',
      r'''հոկ''',
      r'''նոյ''',
      r'''դեկ'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''հնվ''',
      r'''փտվ''',
      r'''մրտ''',
      r'''ապր''',
      r'''մյս''',
      r'''հնս''',
      r'''հլս''',
      r'''օգս''',
      r'''սեպ''',
      r'''հոկ''',
      r'''նոյ''',
      r'''դեկ'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''կիրակի''',
      r'''երկուշաբթի''',
      r'''երեքշաբթի''',
      r'''չորեքշաբթի''',
      r'''հինգշաբթի''',
      r'''ուրբաթ''',
      r'''շաբաթ'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''կիրակի''',
      r'''երկուշաբթի''',
      r'''երեքշաբթի''',
      r'''չորեքշաբթի''',
      r'''հինգշաբթի''',
      r'''ուրբաթ''',
      r'''շաբաթ'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''կիր''',
      r'''երկ''',
      r'''երք''',
      r'''չրք''',
      r'''հնգ''',
      r'''ուր''',
      r'''շբթ'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''կիր''',
      r'''երկ''',
      r'''երք''',
      r'''չրք''',
      r'''հնգ''',
      r'''ուր''',
      r'''շբթ'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''Կ''',
      r'''Ե''',
      r'''Ե''',
      r'''Չ''',
      r'''Հ''',
      r'''Ո''',
      r'''Շ'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''Կ''',
      r'''Ե''',
      r'''Ե''',
      r'''Չ''',
      r'''Հ''',
      r'''Ո''',
      r'''Շ'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''1-ին եռմս.''',
      r'''2-րդ եռմս.''',
      r'''3-րդ եռմս.''',
      r'''4-րդ եռմս.'''
    ],
    'QUARTERS': <dynamic>[
      r'''1-ին եռամսյակ''',
      r'''2-րդ եռամսյակ''',
      r'''3-րդ եռամսյակ''',
      r'''4-րդ եռամսյակ'''
    ],
    'AMPMS': <dynamic>[r'''ԿԱ''', r'''ԿՀ'''],
    'DATEFORMATS': <dynamic>[
      r'''y թ. MMMM d, EEEE''',
      r'''dd MMMM, y թ.''',
      r'''dd MMM, y թ.''',
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'id': <String, dynamic>{
    'NAME': r'''id''',
    'ERAS': <dynamic>[r'''SM''', r'''M'''],
    'ERANAMES': <dynamic>[r'''Sebelum Masehi''', r'''Masehi'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''Januari''',
      r'''Februari''',
      r'''Maret''',
      r'''April''',
      r'''Mei''',
      r'''Juni''',
      r'''Juli''',
      r'''Agustus''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Desember'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Januari''',
      r'''Februari''',
      r'''Maret''',
      r'''April''',
      r'''Mei''',
      r'''Juni''',
      r'''Juli''',
      r'''Agustus''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Desember'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''Mei''',
      r'''Jun''',
      r'''Jul''',
      r'''Agt''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Des'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mar''',
      r'''Apr''',
      r'''Mei''',
      r'''Jun''',
      r'''Jul''',
      r'''Agt''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Des'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Minggu''',
      r'''Senin''',
      r'''Selasa''',
      r'''Rabu''',
      r'''Kamis''',
      r'''Jumat''',
      r'''Sabtu'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Minggu''',
      r'''Senin''',
      r'''Selasa''',
      r'''Rabu''',
      r'''Kamis''',
      r'''Jumat''',
      r'''Sabtu'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Min''',
      r'''Sen''',
      r'''Sel''',
      r'''Rab''',
      r'''Kam''',
      r'''Jum''',
      r'''Sab'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Min''',
      r'''Sen''',
      r'''Sel''',
      r'''Rab''',
      r'''Kam''',
      r'''Jum''',
      r'''Sab'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''M''',
      r'''S''',
      r'''S''',
      r'''R''',
      r'''K''',
      r'''J''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''M''',
      r'''S''',
      r'''S''',
      r'''R''',
      r'''K''',
      r'''J''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''K1''', r'''K2''', r'''K3''', r'''K4'''],
    'QUARTERS': <dynamic>[
      r'''Kuartal ke-1''',
      r'''Kuartal ke-2''',
      r'''Kuartal ke-3''',
      r'''Kuartal ke-4'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, dd MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd/MM/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH.mm.ss zzzz''',
      r'''HH.mm.ss z''',
      r'''HH.mm.ss''',
      r'''HH.mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'it': <String, dynamic>{
    'NAME': r'''it''',
    'ERAS': <dynamic>[r'''a.C.''', r'''d.C.'''],
    'ERANAMES': <dynamic>[r'''avanti Cristo''', r'''dopo Cristo'''],
    'NARROWMONTHS': <dynamic>[
      r'''G''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''G''',
      r'''L''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''G''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''G''',
      r'''L''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''gennaio''',
      r'''febbraio''',
      r'''marzo''',
      r'''aprile''',
      r'''maggio''',
      r'''giugno''',
      r'''luglio''',
      r'''agosto''',
      r'''settembre''',
      r'''ottobre''',
      r'''novembre''',
      r'''dicembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''gennaio''',
      r'''febbraio''',
      r'''marzo''',
      r'''aprile''',
      r'''maggio''',
      r'''giugno''',
      r'''luglio''',
      r'''agosto''',
      r'''settembre''',
      r'''ottobre''',
      r'''novembre''',
      r'''dicembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''gen''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''mag''',
      r'''giu''',
      r'''lug''',
      r'''ago''',
      r'''set''',
      r'''ott''',
      r'''nov''',
      r'''dic'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''gen''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''mag''',
      r'''giu''',
      r'''lug''',
      r'''ago''',
      r'''set''',
      r'''ott''',
      r'''nov''',
      r'''dic'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''domenica''',
      r'''lunedì''',
      r'''martedì''',
      r'''mercoledì''',
      r'''giovedì''',
      r'''venerdì''',
      r'''sabato'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''domenica''',
      r'''lunedì''',
      r'''martedì''',
      r'''mercoledì''',
      r'''giovedì''',
      r'''venerdì''',
      r'''sabato'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dom''',
      r'''lun''',
      r'''mar''',
      r'''mer''',
      r'''gio''',
      r'''ven''',
      r'''sab'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dom''',
      r'''lun''',
      r'''mar''',
      r'''mer''',
      r'''gio''',
      r'''ven''',
      r'''sab'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''G''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''G''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''T1''', r'''T2''', r'''T3''', r'''T4'''],
    'QUARTERS': <dynamic>[
      r'''1º trimestre''',
      r'''2º trimestre''',
      r'''3º trimestre''',
      r'''4º trimestre'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd/MM/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'ja': <String, dynamic>{
    'NAME': r'''ja''',
    'ERAS': <dynamic>[r'''紀元前''', r'''西暦'''],
    'ERANAMES': <dynamic>[r'''紀元前''', r'''西暦'''],
    'NARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''日曜日''',
      r'''月曜日''',
      r'''火曜日''',
      r'''水曜日''',
      r'''木曜日''',
      r'''金曜日''',
      r'''土曜日'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''日曜日''',
      r'''月曜日''',
      r'''火曜日''',
      r'''水曜日''',
      r'''木曜日''',
      r'''金曜日''',
      r'''土曜日'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''日''',
      r'''月''',
      r'''火''',
      r'''水''',
      r'''木''',
      r'''金''',
      r'''土'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''日''',
      r'''月''',
      r'''火''',
      r'''水''',
      r'''木''',
      r'''金''',
      r'''土'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''日''',
      r'''月''',
      r'''火''',
      r'''水''',
      r'''木''',
      r'''金''',
      r'''土'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''日''',
      r'''月''',
      r'''火''',
      r'''水''',
      r'''木''',
      r'''金''',
      r'''土'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''第1四半期''',
      r'''第2四半期''',
      r'''第3四半期''',
      r'''第4四半期'''
    ],
    'AMPMS': <dynamic>[r'''午前''', r'''午後'''],
    'DATEFORMATS': <dynamic>[
      r'''y年M月d日EEEE''',
      r'''y年M月d日''',
      r'''y/MM/dd''',
      r'''y/MM/dd'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H時mm分ss秒 zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'kk': <String, dynamic>{
    'NAME': r'''kk''',
    'ERAS': <dynamic>[r'''б.з.д.''', r'''б.з.'''],
    'ERANAMES': <dynamic>[
      r'''Біздің заманымызға дейін''',
      r'''біздің заманымыз'''
    ],
    'NARROWMONTHS': <dynamic>[
      r'''Қ''',
      r'''А''',
      r'''Н''',
      r'''С''',
      r'''М''',
      r'''М''',
      r'''Ш''',
      r'''Т''',
      r'''Қ''',
      r'''Қ''',
      r'''Қ''',
      r'''Ж'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''Қ''',
      r'''А''',
      r'''Н''',
      r'''С''',
      r'''М''',
      r'''М''',
      r'''Ш''',
      r'''Т''',
      r'''Қ''',
      r'''Қ''',
      r'''Қ''',
      r'''Ж'''
    ],
    'MONTHS': <dynamic>[
      r'''қаңтар''',
      r'''ақпан''',
      r'''наурыз''',
      r'''сәуір''',
      r'''мамыр''',
      r'''маусым''',
      r'''шілде''',
      r'''тамыз''',
      r'''қыркүйек''',
      r'''қазан''',
      r'''қараша''',
      r'''желтоқсан'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Қаңтар''',
      r'''Ақпан''',
      r'''Наурыз''',
      r'''Сәуір''',
      r'''Мамыр''',
      r'''Маусым''',
      r'''Шілде''',
      r'''Тамыз''',
      r'''Қыркүйек''',
      r'''Қазан''',
      r'''Қараша''',
      r'''Желтоқсан'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''қаң.''',
      r'''ақп.''',
      r'''нау.''',
      r'''сәу.''',
      r'''мам.''',
      r'''мау.''',
      r'''шіл.''',
      r'''там.''',
      r'''қыр.''',
      r'''қаз.''',
      r'''қар.''',
      r'''жел.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Қаң.''',
      r'''Ақп.''',
      r'''Нау.''',
      r'''Сәу.''',
      r'''Мам.''',
      r'''Мау.''',
      r'''Шіл.''',
      r'''Там.''',
      r'''Қыр.''',
      r'''Қаз.''',
      r'''Қар.''',
      r'''Жел.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''жексенбі''',
      r'''дүйсенбі''',
      r'''сейсенбі''',
      r'''сәрсенбі''',
      r'''бейсенбі''',
      r'''жұма''',
      r'''сенбі'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Жексенбі''',
      r'''Дүйсенбі''',
      r'''Сейсенбі''',
      r'''Сәрсенбі''',
      r'''Бейсенбі''',
      r'''Жұма''',
      r'''Сенбі'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Жс''',
      r'''Дс''',
      r'''Сс''',
      r'''Ср''',
      r'''Бс''',
      r'''Жм''',
      r'''Сб'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Жс''',
      r'''Дс''',
      r'''Сс''',
      r'''Ср''',
      r'''Бс''',
      r'''Жм''',
      r'''Сб'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''Ж''',
      r'''Д''',
      r'''С''',
      r'''С''',
      r'''Б''',
      r'''Ж''',
      r'''С'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''Ж''',
      r'''Д''',
      r'''С''',
      r'''С''',
      r'''Б''',
      r'''Ж''',
      r'''С'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''І тқс.''',
      r'''ІІ тқс.''',
      r'''ІІІ тқс.''',
      r'''IV тқс.'''
    ],
    'QUARTERS': <dynamic>[
      r'''І тоқсан''',
      r'''ІІ тоқсан''',
      r'''ІІІ тоқсан''',
      r'''IV тоқсан'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r"""y 'ж'. d MMMM, EEEE""",
      r"""y 'ж'. d MMMM""",
      r"""y 'ж'. dd MMM""",
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'km': <String, dynamic>{
    'NAME': r'''km''',
    'ERAS': <dynamic>[r'''មុន គ.ស.''', r'''គ.ស.'''],
    'ERANAMES': <dynamic>[r'''មុន​គ្រិស្តសករាជ''', r'''គ្រិស្តសករាជ'''],
    'NARROWMONTHS': <dynamic>[
      r'''ម''',
      r'''ក''',
      r'''ម''',
      r'''ម''',
      r'''ឧ''',
      r'''ម''',
      r'''ក''',
      r'''ស''',
      r'''ក''',
      r'''ត''',
      r'''វ''',
      r'''ធ'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''ម''',
      r'''ក''',
      r'''ម''',
      r'''ម''',
      r'''ឧ''',
      r'''ម''',
      r'''ក''',
      r'''ស''',
      r'''ក''',
      r'''ត''',
      r'''វ''',
      r'''ធ'''
    ],
    'MONTHS': <dynamic>[
      r'''មករា''',
      r'''កុម្ភៈ''',
      r'''មីនា''',
      r'''មេសា''',
      r'''ឧសភា''',
      r'''មិថុនា''',
      r'''កក្កដា''',
      r'''សីហា''',
      r'''កញ្ញា''',
      r'''តុលា''',
      r'''វិច្ឆិកា''',
      r'''ធ្នូ'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''មករា''',
      r'''កុម្ភៈ''',
      r'''មីនា''',
      r'''មេសា''',
      r'''ឧសភា''',
      r'''មិថុនា''',
      r'''កក្កដា''',
      r'''សីហា''',
      r'''កញ្ញា''',
      r'''តុលា''',
      r'''វិច្ឆិកា''',
      r'''ធ្នូ'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''មករា''',
      r'''កុម្ភៈ''',
      r'''មីនា''',
      r'''មេសា''',
      r'''ឧសភា''',
      r'''មិថុនា''',
      r'''កក្កដា''',
      r'''សីហា''',
      r'''កញ្ញា''',
      r'''តុលា''',
      r'''វិច្ឆិកា''',
      r'''ធ្នូ'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''មករា''',
      r'''កុម្ភៈ''',
      r'''មីនា''',
      r'''មេសា''',
      r'''ឧសភា''',
      r'''មិថុនា''',
      r'''កក្កដា''',
      r'''សីហា''',
      r'''កញ្ញា''',
      r'''តុលា''',
      r'''វិច្ឆិកា''',
      r'''ធ្នូ'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''អាទិត្យ''',
      r'''ច័ន្ទ''',
      r'''អង្គារ''',
      r'''ពុធ''',
      r'''ព្រហស្បតិ៍''',
      r'''សុក្រ''',
      r'''សៅរ៍'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''អាទិត្យ''',
      r'''ច័ន្ទ''',
      r'''អង្គារ''',
      r'''ពុធ''',
      r'''ព្រហស្បតិ៍''',
      r'''សុក្រ''',
      r'''សៅរ៍'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''អាទិត្យ''',
      r'''ច័ន្ទ''',
      r'''អង្គារ''',
      r'''ពុធ''',
      r'''ព្រហស្បតិ៍''',
      r'''សុក្រ''',
      r'''សៅរ៍'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''អាទិត្យ''',
      r'''ច័ន្ទ''',
      r'''អង្គារ''',
      r'''ពុធ''',
      r'''ព្រហស្បតិ៍''',
      r'''សុក្រ''',
      r'''សៅរ៍'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''អ''',
      r'''ច''',
      r'''អ''',
      r'''ព''',
      r'''ព''',
      r'''ស''',
      r'''ស'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''អ''',
      r'''ច''',
      r'''អ''',
      r'''ព''',
      r'''ព''',
      r'''ស''',
      r'''ស'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''ត្រីមាសទី 1''',
      r'''ត្រីមាសទី 2''',
      r'''ត្រីមាសទី 3''',
      r'''ត្រីមាសទី 4'''
    ],
    'QUARTERS': <dynamic>[
      r'''ត្រីមាសទី 1''',
      r'''ត្រីមាសទី 2''',
      r'''ត្រីមាសទី 3''',
      r'''ត្រីមាសទី 4'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} នៅ​ម៉ោង {0}''',
      r'''{1} នៅ​ម៉ោង {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'ko': <String, dynamic>{
    'NAME': r'''ko''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''기원전''', r'''서기'''],
    'NARROWMONTHS': <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'MONTHS': <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''1월''',
      r'''2월''',
      r'''3월''',
      r'''4월''',
      r'''5월''',
      r'''6월''',
      r'''7월''',
      r'''8월''',
      r'''9월''',
      r'''10월''',
      r'''11월''',
      r'''12월'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''일요일''',
      r'''월요일''',
      r'''화요일''',
      r'''수요일''',
      r'''목요일''',
      r'''금요일''',
      r'''토요일'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''일요일''',
      r'''월요일''',
      r'''화요일''',
      r'''수요일''',
      r'''목요일''',
      r'''금요일''',
      r'''토요일'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''일''',
      r'''월''',
      r'''화''',
      r'''수''',
      r'''목''',
      r'''금''',
      r'''토'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''일''',
      r'''월''',
      r'''화''',
      r'''수''',
      r'''목''',
      r'''금''',
      r'''토'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''일''',
      r'''월''',
      r'''화''',
      r'''수''',
      r'''목''',
      r'''금''',
      r'''토'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''일''',
      r'''월''',
      r'''화''',
      r'''수''',
      r'''목''',
      r'''금''',
      r'''토'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''1분기''', r'''2분기''', r'''3분기''', r'''4분기'''],
    'QUARTERS': <dynamic>[
      r'''제 1/4분기''',
      r'''제 2/4분기''',
      r'''제 3/4분기''',
      r'''제 4/4분기'''
    ],
    'AMPMS': <dynamic>[r'''오전''', r'''오후'''],
    'DATEFORMATS': <dynamic>[
      r'''y년 M월 d일 EEEE''',
      r'''y년 M월 d일''',
      r'''y. M. d.''',
      r'''yy. M. d.'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''a h시 m분 s초 zzzz''',
      r'''a h시 m분 s초 z''',
      r'''a h:mm:ss''',
      r'''a h:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'lt': <String, dynamic>{
    'NAME': r'''lt''',
    'ERAS': <dynamic>[r'''pr. Kr.''', r'''po Kr.'''],
    'ERANAMES': <dynamic>[r'''prieš Kristų''', r'''po Kristaus'''],
    'NARROWMONTHS': <dynamic>[
      r'''S''',
      r'''V''',
      r'''K''',
      r'''B''',
      r'''G''',
      r'''B''',
      r'''L''',
      r'''R''',
      r'''R''',
      r'''S''',
      r'''L''',
      r'''G'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''S''',
      r'''V''',
      r'''K''',
      r'''B''',
      r'''G''',
      r'''B''',
      r'''L''',
      r'''R''',
      r'''R''',
      r'''S''',
      r'''L''',
      r'''G'''
    ],
    'MONTHS': <dynamic>[
      r'''sausio''',
      r'''vasario''',
      r'''kovo''',
      r'''balandžio''',
      r'''gegužės''',
      r'''birželio''',
      r'''liepos''',
      r'''rugpjūčio''',
      r'''rugsėjo''',
      r'''spalio''',
      r'''lapkričio''',
      r'''gruodžio'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''sausis''',
      r'''vasaris''',
      r'''kovas''',
      r'''balandis''',
      r'''gegužė''',
      r'''birželis''',
      r'''liepa''',
      r'''rugpjūtis''',
      r'''rugsėjis''',
      r'''spalis''',
      r'''lapkritis''',
      r'''gruodis'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''saus.''',
      r'''vas.''',
      r'''kov.''',
      r'''bal.''',
      r'''geg.''',
      r'''birž.''',
      r'''liep.''',
      r'''rugp.''',
      r'''rugs.''',
      r'''spal.''',
      r'''lapkr.''',
      r'''gruod.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''saus.''',
      r'''vas.''',
      r'''kov.''',
      r'''bal.''',
      r'''geg.''',
      r'''birž.''',
      r'''liep.''',
      r'''rugp.''',
      r'''rugs.''',
      r'''spal.''',
      r'''lapkr.''',
      r'''gruod.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''sekmadienis''',
      r'''pirmadienis''',
      r'''antradienis''',
      r'''trečiadienis''',
      r'''ketvirtadienis''',
      r'''penktadienis''',
      r'''šeštadienis'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''sekmadienis''',
      r'''pirmadienis''',
      r'''antradienis''',
      r'''trečiadienis''',
      r'''ketvirtadienis''',
      r'''penktadienis''',
      r'''šeštadienis'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''sk''',
      r'''pr''',
      r'''an''',
      r'''tr''',
      r'''kt''',
      r'''pn''',
      r'''št'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''sk''',
      r'''pr''',
      r'''an''',
      r'''tr''',
      r'''kt''',
      r'''pn''',
      r'''št'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''P''',
      r'''A''',
      r'''T''',
      r'''K''',
      r'''P''',
      r'''Š'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''P''',
      r'''A''',
      r'''T''',
      r'''K''',
      r'''P''',
      r'''Š'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''I k.''',
      r'''II k.''',
      r'''III k.''',
      r'''IV k.'''
    ],
    'QUARTERS': <dynamic>[
      r'''I ketvirtis''',
      r'''II ketvirtis''',
      r'''III ketvirtis''',
      r'''IV ketvirtis'''
    ],
    'AMPMS': <dynamic>[r'''priešpiet''', r'''popiet'''],
    'DATEFORMATS': <dynamic>[
      r"""y 'm'. MMMM d 'd'., EEEE""",
      r"""y 'm'. MMMM d 'd'.""",
      r'''y-MM-dd''',
      r'''y-MM-dd'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'lv': <String, dynamic>{
    'NAME': r'''lv''',
    'ERAS': <dynamic>[r'''p.m.ē.''', r'''m.ē.'''],
    'ERANAMES': <dynamic>[r'''pirms mūsu ēras''', r'''mūsu ērā'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''janvāris''',
      r'''februāris''',
      r'''marts''',
      r'''aprīlis''',
      r'''maijs''',
      r'''jūnijs''',
      r'''jūlijs''',
      r'''augusts''',
      r'''septembris''',
      r'''oktobris''',
      r'''novembris''',
      r'''decembris'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''janvāris''',
      r'''februāris''',
      r'''marts''',
      r'''aprīlis''',
      r'''maijs''',
      r'''jūnijs''',
      r'''jūlijs''',
      r'''augusts''',
      r'''septembris''',
      r'''oktobris''',
      r'''novembris''',
      r'''decembris'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''janv.''',
      r'''febr.''',
      r'''marts''',
      r'''apr.''',
      r'''maijs''',
      r'''jūn.''',
      r'''jūl.''',
      r'''aug.''',
      r'''sept.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''janv.''',
      r'''febr.''',
      r'''marts''',
      r'''apr.''',
      r'''maijs''',
      r'''jūn.''',
      r'''jūl.''',
      r'''aug.''',
      r'''sept.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''svētdiena''',
      r'''pirmdiena''',
      r'''otrdiena''',
      r'''trešdiena''',
      r'''ceturtdiena''',
      r'''piektdiena''',
      r'''sestdiena'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Svētdiena''',
      r'''Pirmdiena''',
      r'''Otrdiena''',
      r'''Trešdiena''',
      r'''Ceturtdiena''',
      r'''Piektdiena''',
      r'''Sestdiena'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''svētd.''',
      r'''pirmd.''',
      r'''otrd.''',
      r'''trešd.''',
      r'''ceturtd.''',
      r'''piektd.''',
      r'''sestd.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Svētd.''',
      r'''Pirmd.''',
      r'''Otrd.''',
      r'''Trešd.''',
      r'''Ceturtd.''',
      r'''Piektd.''',
      r'''Sestd.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''P''',
      r'''O''',
      r'''T''',
      r'''C''',
      r'''P''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''P''',
      r'''O''',
      r'''T''',
      r'''C''',
      r'''P''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''1. cet.''',
      r'''2. cet.''',
      r'''3. cet.''',
      r'''4. cet.'''
    ],
    'QUARTERS': <dynamic>[
      r'''1. ceturksnis''',
      r'''2. ceturksnis''',
      r'''3. ceturksnis''',
      r'''4. ceturksnis'''
    ],
    'AMPMS': <dynamic>[r'''priekšpusdienā''', r'''pēcpusdienā'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, y. 'gada' d. MMMM""",
      r"""y. 'gada' d. MMMM""",
      r"""y. 'gada' d. MMM""",
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'mn': <String, dynamic>{
    'NAME': r'''mn''',
    'ERAS': <dynamic>[r'''МЭӨ''', r'''МЭ'''],
    'ERANAMES': <dynamic>[r'''манай эриний өмнөх''', r'''манай эриний'''],
    'NARROWMONTHS': <dynamic>[
      r'''I''',
      r'''II''',
      r'''III''',
      r'''IV''',
      r'''V''',
      r'''VI''',
      r'''VII''',
      r'''VIII''',
      r'''IX''',
      r'''X''',
      r'''XI''',
      r'''XII'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''I''',
      r'''II''',
      r'''III''',
      r'''IV''',
      r'''V''',
      r'''VI''',
      r'''VII''',
      r'''VIII''',
      r'''IX''',
      r'''X''',
      r'''XI''',
      r'''XII'''
    ],
    'MONTHS': <dynamic>[
      r'''Нэгдүгээр сар''',
      r'''Хоёрдугаар сар''',
      r'''Гуравдугаар сар''',
      r'''Дөрөвдүгээр сар''',
      r'''Тавдугаар сар''',
      r'''Зургаадугаар сар''',
      r'''Долдугаар сар''',
      r'''Наймдугаар сар''',
      r'''Есдүгээр сар''',
      r'''Аравдугаар сар''',
      r'''Арван нэгдүгээр сар''',
      r'''Арван хоёрдугаар сар'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Нэгдүгээр сар''',
      r'''Хоёрдугаар сар''',
      r'''Гуравдугаар сар''',
      r'''Дөрөвдүгээр сар''',
      r'''Тавдугаар сар''',
      r'''Зургаадугаар сар''',
      r'''Долдугаар сар''',
      r'''Наймдугаар сар''',
      r'''Есдүгээр сар''',
      r'''Аравдугаар сар''',
      r'''Арван нэгдүгээр сар''',
      r'''Арван хоёрдугаар сар'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''1-р сар''',
      r'''2-р сар''',
      r'''3-р сар''',
      r'''4-р сар''',
      r'''5-р сар''',
      r'''6-р сар''',
      r'''7-р сар''',
      r'''8-р сар''',
      r'''9-р сар''',
      r'''10-р сар''',
      r'''11-р сар''',
      r'''12-р сар'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''1-р сар''',
      r'''2-р сар''',
      r'''3-р сар''',
      r'''4-р сар''',
      r'''5-р сар''',
      r'''6-р сар''',
      r'''7-р сар''',
      r'''8-р сар''',
      r'''9-р сар''',
      r'''10-р сар''',
      r'''11-р сар''',
      r'''12-р сар'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''ням''',
      r'''даваа''',
      r'''мягмар''',
      r'''лхагва''',
      r'''пүрэв''',
      r'''баасан''',
      r'''бямба'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''ням''',
      r'''даваа''',
      r'''мягмар''',
      r'''лхагва''',
      r'''пүрэв''',
      r'''баасан''',
      r'''бямба'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Ня''',
      r'''Да''',
      r'''Мя''',
      r'''Лх''',
      r'''Пү''',
      r'''Ба''',
      r'''Бя'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Ня''',
      r'''Да''',
      r'''Мя''',
      r'''Лх''',
      r'''Пү''',
      r'''Ба''',
      r'''Бя'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''Ня''',
      r'''Да''',
      r'''Мя''',
      r'''Лх''',
      r'''Пү''',
      r'''Ба''',
      r'''Бя'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''Ня''',
      r'''Да''',
      r'''Мя''',
      r'''Лх''',
      r'''Пү''',
      r'''Ба''',
      r'''Бя'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''I улирал''',
      r'''II улирал''',
      r'''III улирал''',
      r'''IV улирал'''
    ],
    'QUARTERS': <dynamic>[
      r'''1-р улирал''',
      r'''2-р улирал''',
      r'''3-р улирал''',
      r'''4-р улирал'''
    ],
    'AMPMS': <dynamic>[r'''ү.ө''', r'''ү.х'''],
    'DATEFORMATS': <dynamic>[
      r'''y.MM.dd, EEEE''',
      r'''y.MM.dd''',
      r'''y.MM.dd''',
      r'''y.MM.dd'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss (zzzz)''',
      r'''HH:mm:ss (z)''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'mr': <String, dynamic>{
    'NAME': r'''mr''',
    'ERAS': <dynamic>[r'''इ. स. पू.''', r'''इ. स.'''],
    'ERANAMES': <dynamic>[r'''ईसवीसनपूर्व''', r'''ईसवीसन'''],
    'NARROWMONTHS': <dynamic>[
      r'''जा''',
      r'''फे''',
      r'''मा''',
      r'''ए''',
      r'''मे''',
      r'''जू''',
      r'''जु''',
      r'''ऑ''',
      r'''स''',
      r'''ऑ''',
      r'''नो''',
      r'''डि'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''जा''',
      r'''फे''',
      r'''मा''',
      r'''ए''',
      r'''मे''',
      r'''जू''',
      r'''जु''',
      r'''ऑ''',
      r'''स''',
      r'''ऑ''',
      r'''नो''',
      r'''डि'''
    ],
    'MONTHS': <dynamic>[
      r'''जानेवारी''',
      r'''फेब्रुवारी''',
      r'''मार्च''',
      r'''एप्रिल''',
      r'''मे''',
      r'''जून''',
      r'''जुलै''',
      r'''ऑगस्ट''',
      r'''सप्टेंबर''',
      r'''ऑक्टोबर''',
      r'''नोव्हेंबर''',
      r'''डिसेंबर'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''जानेवारी''',
      r'''फेब्रुवारी''',
      r'''मार्च''',
      r'''एप्रिल''',
      r'''मे''',
      r'''जून''',
      r'''जुलै''',
      r'''ऑगस्ट''',
      r'''सप्टेंबर''',
      r'''ऑक्टोबर''',
      r'''नोव्हेंबर''',
      r'''डिसेंबर'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''जाने''',
      r'''फेब्रु''',
      r'''मार्च''',
      r'''एप्रि''',
      r'''मे''',
      r'''जून''',
      r'''जुलै''',
      r'''ऑग''',
      r'''सप्टें''',
      r'''ऑक्टो''',
      r'''नोव्हें''',
      r'''डिसें'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''जाने''',
      r'''फेब्रु''',
      r'''मार्च''',
      r'''एप्रि''',
      r'''मे''',
      r'''जून''',
      r'''जुलै''',
      r'''ऑग''',
      r'''सप्टें''',
      r'''ऑक्टो''',
      r'''नोव्हें''',
      r'''डिसें'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''रविवार''',
      r'''सोमवार''',
      r'''मंगळवार''',
      r'''बुधवार''',
      r'''गुरुवार''',
      r'''शुक्रवार''',
      r'''शनिवार'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''रविवार''',
      r'''सोमवार''',
      r'''मंगळवार''',
      r'''बुधवार''',
      r'''गुरुवार''',
      r'''शुक्रवार''',
      r'''शनिवार'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''रवि''',
      r'''सोम''',
      r'''मंगळ''',
      r'''बुध''',
      r'''गुरु''',
      r'''शुक्र''',
      r'''शनि'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''रवि''',
      r'''सोम''',
      r'''मंगळ''',
      r'''बुध''',
      r'''गुरु''',
      r'''शुक्र''',
      r'''शनि'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''र''',
      r'''सो''',
      r'''मं''',
      r'''बु''',
      r'''गु''',
      r'''शु''',
      r'''श'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''र''',
      r'''सो''',
      r'''मं''',
      r'''बु''',
      r'''गु''',
      r'''शु''',
      r'''श'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''ति१''', r'''ति२''', r'''ति३''', r'''ति४'''],
    'QUARTERS': <dynamic>[
      r'''प्रथम तिमाही''',
      r'''द्वितीय तिमाही''',
      r'''तृतीय तिमाही''',
      r'''चतुर्थ तिमाही'''
    ],
    'AMPMS': <dynamic>[r'''म.पू.''', r'''म.उ.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM, y''',
      r'''d MMMM, y''',
      r'''d MMM, y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[6, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} रोजी {0}''',
      r'''{1} रोजी {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
    'ZERODIGIT': r'''०''',
  },
  'ms': <String, dynamic>{
    'NAME': r'''ms''',
    'ERAS': <dynamic>[r'''S.M.''', r'''TM'''],
    'ERANAMES': <dynamic>[r'''S.M.''', r'''TM'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''O''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''O''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''Januari''',
      r'''Februari''',
      r'''Mac''',
      r'''April''',
      r'''Mei''',
      r'''Jun''',
      r'''Julai''',
      r'''Ogos''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Disember'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Januari''',
      r'''Februari''',
      r'''Mac''',
      r'''April''',
      r'''Mei''',
      r'''Jun''',
      r'''Julai''',
      r'''Ogos''',
      r'''September''',
      r'''Oktober''',
      r'''November''',
      r'''Disember'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mac''',
      r'''Apr''',
      r'''Mei''',
      r'''Jun''',
      r'''Jul''',
      r'''Ogo''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Dis'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mac''',
      r'''Apr''',
      r'''Mei''',
      r'''Jun''',
      r'''Jul''',
      r'''Ogo''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Dis'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Ahad''',
      r'''Isnin''',
      r'''Selasa''',
      r'''Rabu''',
      r'''Khamis''',
      r'''Jumaat''',
      r'''Sabtu'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Ahad''',
      r'''Isnin''',
      r'''Selasa''',
      r'''Rabu''',
      r'''Khamis''',
      r'''Jumaat''',
      r'''Sabtu'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Ahd''',
      r'''Isn''',
      r'''Sel''',
      r'''Rab''',
      r'''Kha''',
      r'''Jum''',
      r'''Sab'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Ahd''',
      r'''Isn''',
      r'''Sel''',
      r'''Rab''',
      r'''Kha''',
      r'''Jum''',
      r'''Sab'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''A''',
      r'''I''',
      r'''S''',
      r'''R''',
      r'''K''',
      r'''J''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''A''',
      r'''I''',
      r'''S''',
      r'''R''',
      r'''K''',
      r'''J''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''S1''', r'''S2''', r'''S3''', r'''S4'''],
    'QUARTERS': <dynamic>[
      r'''Suku pertama''',
      r'''Suku Ke-2''',
      r'''Suku Ke-3''',
      r'''Suku Ke-4'''
    ],
    'AMPMS': <dynamic>[r'''PG''', r'''PTG'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''d/MM/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'nb': <String, dynamic>{
    'NAME': r'''nb''',
    'ERAS': <dynamic>[r'''f.Kr.''', r'''e.Kr.'''],
    'ERANAMES': <dynamic>[r'''før Kristus''', r'''etter Kristus'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''mars''',
      r'''april''',
      r'''mai''',
      r'''juni''',
      r'''juli''',
      r'''august''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''desember'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''mars''',
      r'''april''',
      r'''mai''',
      r'''juni''',
      r'''juli''',
      r'''august''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''desember'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mar.''',
      r'''apr.''',
      r'''mai''',
      r'''jun.''',
      r'''jul.''',
      r'''aug.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''des.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''mai''',
      r'''jun''',
      r'''jul''',
      r'''aug''',
      r'''sep''',
      r'''okt''',
      r'''nov''',
      r'''des'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''søndag''',
      r'''mandag''',
      r'''tirsdag''',
      r'''onsdag''',
      r'''torsdag''',
      r'''fredag''',
      r'''lørdag'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''søndag''',
      r'''mandag''',
      r'''tirsdag''',
      r'''onsdag''',
      r'''torsdag''',
      r'''fredag''',
      r'''lørdag'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''søn.''',
      r'''man.''',
      r'''tir.''',
      r'''ons.''',
      r'''tor.''',
      r'''fre.''',
      r'''lør.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''søn.''',
      r'''man.''',
      r'''tir.''',
      r'''ons.''',
      r'''tor.''',
      r'''fre.''',
      r'''lør.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''O''',
      r'''T''',
      r'''F''',
      r'''L'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''O''',
      r'''T''',
      r'''F''',
      r'''L'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''K1''', r'''K2''', r'''K3''', r'''K4'''],
    'QUARTERS': <dynamic>[
      r'''1. kvartal''',
      r'''2. kvartal''',
      r'''3. kvartal''',
      r'''4. kvartal'''
    ],
    'AMPMS': <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d. MMMM y''',
      r'''d. MMMM y''',
      r'''d. MMM y''',
      r'''dd.MM.y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r"""{1} 'kl'. {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'nl': <String, dynamic>{
    'NAME': r'''nl''',
    'ERAS': <dynamic>[r'''v.Chr.''', r'''n.Chr.'''],
    'ERANAMES': <dynamic>[r'''voor Christus''', r'''na Christus'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''januari''',
      r'''februari''',
      r'''maart''',
      r'''april''',
      r'''mei''',
      r'''juni''',
      r'''juli''',
      r'''augustus''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''januari''',
      r'''februari''',
      r'''maart''',
      r'''april''',
      r'''mei''',
      r'''juni''',
      r'''juli''',
      r'''augustus''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mrt.''',
      r'''apr.''',
      r'''mei''',
      r'''jun.''',
      r'''jul.''',
      r'''aug.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mrt.''',
      r'''apr.''',
      r'''mei''',
      r'''jun.''',
      r'''jul.''',
      r'''aug.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''zondag''',
      r'''maandag''',
      r'''dinsdag''',
      r'''woensdag''',
      r'''donderdag''',
      r'''vrijdag''',
      r'''zaterdag'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''zondag''',
      r'''maandag''',
      r'''dinsdag''',
      r'''woensdag''',
      r'''donderdag''',
      r'''vrijdag''',
      r'''zaterdag'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''zo''',
      r'''ma''',
      r'''di''',
      r'''wo''',
      r'''do''',
      r'''vr''',
      r'''za'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''zo''',
      r'''ma''',
      r'''di''',
      r'''wo''',
      r'''do''',
      r'''vr''',
      r'''za'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''Z''',
      r'''M''',
      r'''D''',
      r'''W''',
      r'''D''',
      r'''V''',
      r'''Z'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''Z''',
      r'''M''',
      r'''D''',
      r'''W''',
      r'''D''',
      r'''V''',
      r'''Z'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''K1''', r'''K2''', r'''K3''', r'''K4'''],
    'QUARTERS': <dynamic>[
      r'''1e kwartaal''',
      r'''2e kwartaal''',
      r'''3e kwartaal''',
      r'''4e kwartaal'''
    ],
    'AMPMS': <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd-MM-yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'om' {0}""",
      r"""{1} 'om' {0}""",
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'pl': <String, dynamic>{
    'NAME': r'''pl''',
    'ERAS': <dynamic>[r'''p.n.e.''', r'''n.e.'''],
    'ERANAMES': <dynamic>[r'''przed naszą erą''', r'''naszej ery'''],
    'NARROWMONTHS': <dynamic>[
      r'''s''',
      r'''l''',
      r'''m''',
      r'''k''',
      r'''m''',
      r'''c''',
      r'''l''',
      r'''s''',
      r'''w''',
      r'''p''',
      r'''l''',
      r'''g'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''S''',
      r'''L''',
      r'''M''',
      r'''K''',
      r'''M''',
      r'''C''',
      r'''L''',
      r'''S''',
      r'''W''',
      r'''P''',
      r'''L''',
      r'''G'''
    ],
    'MONTHS': <dynamic>[
      r'''stycznia''',
      r'''lutego''',
      r'''marca''',
      r'''kwietnia''',
      r'''maja''',
      r'''czerwca''',
      r'''lipca''',
      r'''sierpnia''',
      r'''września''',
      r'''października''',
      r'''listopada''',
      r'''grudnia'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''styczeń''',
      r'''luty''',
      r'''marzec''',
      r'''kwiecień''',
      r'''maj''',
      r'''czerwiec''',
      r'''lipiec''',
      r'''sierpień''',
      r'''wrzesień''',
      r'''październik''',
      r'''listopad''',
      r'''grudzień'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''sty''',
      r'''lut''',
      r'''mar''',
      r'''kwi''',
      r'''maj''',
      r'''cze''',
      r'''lip''',
      r'''sie''',
      r'''wrz''',
      r'''paź''',
      r'''lis''',
      r'''gru'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''sty''',
      r'''lut''',
      r'''mar''',
      r'''kwi''',
      r'''maj''',
      r'''cze''',
      r'''lip''',
      r'''sie''',
      r'''wrz''',
      r'''paź''',
      r'''lis''',
      r'''gru'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''niedziela''',
      r'''poniedziałek''',
      r'''wtorek''',
      r'''środa''',
      r'''czwartek''',
      r'''piątek''',
      r'''sobota'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''niedziela''',
      r'''poniedziałek''',
      r'''wtorek''',
      r'''środa''',
      r'''czwartek''',
      r'''piątek''',
      r'''sobota'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''niedz.''',
      r'''pon.''',
      r'''wt.''',
      r'''śr.''',
      r'''czw.''',
      r'''pt.''',
      r'''sob.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''niedz.''',
      r'''pon.''',
      r'''wt.''',
      r'''śr.''',
      r'''czw.''',
      r'''pt.''',
      r'''sob.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''n''',
      r'''p''',
      r'''w''',
      r'''ś''',
      r'''c''',
      r'''p''',
      r'''s'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''N''',
      r'''P''',
      r'''W''',
      r'''Ś''',
      r'''C''',
      r'''P''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''I kw.''',
      r'''II kw.''',
      r'''III kw.''',
      r'''IV kw.'''
    ],
    'QUARTERS': <dynamic>[
      r'''I kwartał''',
      r'''II kwartał''',
      r'''III kwartał''',
      r'''IV kwartał'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd.MM.y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'ps': <String, dynamic>{
    'NAME': r'''ps''',
    'ERAS': <dynamic>[r'''له میلاد وړاندې''', r'''م.'''],
    'ERANAMES': <dynamic>[
      r'''له میلاد څخه وړاندې''',
      r'''له میلاد څخه وروسته'''
    ],
    'NARROWMONTHS': <dynamic>[
      r'''ج''',
      r'''ف''',
      r'''م''',
      r'''ا''',
      r'''م''',
      r'''ج''',
      r'''ج''',
      r'''ا''',
      r'''س''',
      r'''ا''',
      r'''ن''',
      r'''د'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': <dynamic>[
      r'''جنوري''',
      r'''فبروري''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مۍ''',
      r'''جون''',
      r'''جولای''',
      r'''اگست''',
      r'''سېپتمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''جنوري''',
      r'''فېبروري''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مۍ''',
      r'''جون''',
      r'''جولای''',
      r'''اگست''',
      r'''سپتمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''جنوري''',
      r'''فبروري''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مۍ''',
      r'''جون''',
      r'''جولای''',
      r'''اگست''',
      r'''سېپتمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''جنوري''',
      r'''فبروري''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مۍ''',
      r'''جون''',
      r'''جولای''',
      r'''اگست''',
      r'''سپتمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''يونۍ''',
      r'''دونۍ''',
      r'''درېنۍ''',
      r'''څلرنۍ''',
      r'''پينځنۍ''',
      r'''جمعه''',
      r'''اونۍ'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''يونۍ''',
      r'''دونۍ''',
      r'''درېنۍ''',
      r'''څلرنۍ''',
      r'''پينځنۍ''',
      r'''جمعه''',
      r'''اونۍ'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''يونۍ''',
      r'''دونۍ''',
      r'''درېنۍ''',
      r'''څلرنۍ''',
      r'''پينځنۍ''',
      r'''جمعه''',
      r'''اونۍ'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''يونۍ''',
      r'''دونۍ''',
      r'''درېنۍ''',
      r'''څلرنۍ''',
      r'''پينځنۍ''',
      r'''جمعه''',
      r'''اونۍ'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''لومړۍ ربعه''',
      r'''۲مه ربعه''',
      r'''۳مه ربعه''',
      r'''۴مه ربعه'''
    ],
    'QUARTERS': <dynamic>[
      r'''لومړۍ ربعه''',
      r'''۲مه ربعه''',
      r'''۳مه ربعه''',
      r'''۴مه ربعه'''
    ],
    'AMPMS': <dynamic>[r'''غ.م.''', r'''غ.و.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE د y د MMMM d''',
      r'''د y د MMMM d''',
      r'''y MMM d''',
      r'''y/M/d'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss (zzzz)''',
      r'''H:mm:ss (z)''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 5,
    'WEEKENDRANGE': <dynamic>[3, 4],
    'FIRSTWEEKCUTOFFDAY': 4,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
    'ZERODIGIT': r'''۰''',
  },
  'pt': <String, dynamic>{
    'NAME': r'''pt''',
    'ERAS': <dynamic>[r'''a.C.''', r'''d.C.'''],
    'ERANAMES': <dynamic>[r'''antes de Cristo''', r'''depois de Cristo'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''janeiro''',
      r'''fevereiro''',
      r'''março''',
      r'''abril''',
      r'''maio''',
      r'''junho''',
      r'''julho''',
      r'''agosto''',
      r'''setembro''',
      r'''outubro''',
      r'''novembro''',
      r'''dezembro'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''janeiro''',
      r'''fevereiro''',
      r'''março''',
      r'''abril''',
      r'''maio''',
      r'''junho''',
      r'''julho''',
      r'''agosto''',
      r'''setembro''',
      r'''outubro''',
      r'''novembro''',
      r'''dezembro'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''fev''',
      r'''mar''',
      r'''abr''',
      r'''mai''',
      r'''jun''',
      r'''jul''',
      r'''ago''',
      r'''set''',
      r'''out''',
      r'''nov''',
      r'''dez'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''fev''',
      r'''mar''',
      r'''abr''',
      r'''mai''',
      r'''jun''',
      r'''jul''',
      r'''ago''',
      r'''set''',
      r'''out''',
      r'''nov''',
      r'''dez'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''segunda-feira''',
      r'''terça-feira''',
      r'''quarta-feira''',
      r'''quinta-feira''',
      r'''sexta-feira''',
      r'''sábado'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''segunda-feira''',
      r'''terça-feira''',
      r'''quarta-feira''',
      r'''quinta-feira''',
      r'''sexta-feira''',
      r'''sábado'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dom''',
      r'''seg''',
      r'''ter''',
      r'''qua''',
      r'''qui''',
      r'''sex''',
      r'''sáb'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dom''',
      r'''seg''',
      r'''ter''',
      r'''qua''',
      r'''qui''',
      r'''sex''',
      r'''sáb'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''S''',
      r'''T''',
      r'''Q''',
      r'''Q''',
      r'''S''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''S''',
      r'''T''',
      r'''Q''',
      r'''Q''',
      r'''S''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''T1''', r'''T2''', r'''T3''', r'''T4'''],
    'QUARTERS': <dynamic>[
      r'''1º trimestre''',
      r'''2º trimestre''',
      r'''3º trimestre''',
      r'''4º trimestre'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d 'de' MMMM 'de' y""",
      r"""d 'de' MMMM 'de' y""",
      r"""d 'de' MMM 'de' y""",
      r'''dd/MM/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'pt_PT': <String, dynamic>{
    'NAME': r'''pt_PT''',
    'ERAS': <dynamic>[r'''a.C.''', r'''d.C.'''],
    'ERANAMES': <dynamic>[r'''antes de Cristo''', r'''depois de Cristo'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''janeiro''',
      r'''fevereiro''',
      r'''março''',
      r'''abril''',
      r'''maio''',
      r'''junho''',
      r'''julho''',
      r'''agosto''',
      r'''setembro''',
      r'''outubro''',
      r'''novembro''',
      r'''dezembro'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''janeiro''',
      r'''fevereiro''',
      r'''março''',
      r'''abril''',
      r'''maio''',
      r'''junho''',
      r'''julho''',
      r'''agosto''',
      r'''setembro''',
      r'''outubro''',
      r'''novembro''',
      r'''dezembro'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''fev''',
      r'''mar''',
      r'''abr''',
      r'''mai''',
      r'''jun''',
      r'''jul''',
      r'''ago''',
      r'''set''',
      r'''out''',
      r'''nov''',
      r'''dez'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''fev''',
      r'''mar''',
      r'''abr''',
      r'''mai''',
      r'''jun''',
      r'''jul''',
      r'''ago''',
      r'''set''',
      r'''out''',
      r'''nov''',
      r'''dez'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''segunda-feira''',
      r'''terça-feira''',
      r'''quarta-feira''',
      r'''quinta-feira''',
      r'''sexta-feira''',
      r'''sábado'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''segunda-feira''',
      r'''terça-feira''',
      r'''quarta-feira''',
      r'''quinta-feira''',
      r'''sexta-feira''',
      r'''sábado'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''segunda''',
      r'''terça''',
      r'''quarta''',
      r'''quinta''',
      r'''sexta''',
      r'''sábado'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''domingo''',
      r'''segunda''',
      r'''terça''',
      r'''quarta''',
      r'''quinta''',
      r'''sexta''',
      r'''sábado'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''S''',
      r'''T''',
      r'''Q''',
      r'''Q''',
      r'''S''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''S''',
      r'''T''',
      r'''Q''',
      r'''Q''',
      r'''S''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''T1''', r'''T2''', r'''T3''', r'''T4'''],
    'QUARTERS': <dynamic>[
      r'''1.º trimestre''',
      r'''2.º trimestre''',
      r'''3.º trimestre''',
      r'''4.º trimestre'''
    ],
    'AMPMS': <dynamic>[r'''da manhã''', r'''da tarde'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d 'de' MMMM 'de' y""",
      r"""d 'de' MMMM 'de' y""",
      r'''dd/MM/y''',
      r'''dd/MM/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'às' {0}""",
      r"""{1} 'às' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'ro': <String, dynamic>{
    'NAME': r'''ro''',
    'ERAS': <dynamic>[r'''î.Hr.''', r'''d.Hr.'''],
    'ERANAMES': <dynamic>[r'''înainte de Hristos''', r'''după Hristos'''],
    'NARROWMONTHS': <dynamic>[
      r'''I''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''I''',
      r'''I''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''I''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''I''',
      r'''I''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''ianuarie''',
      r'''februarie''',
      r'''martie''',
      r'''aprilie''',
      r'''mai''',
      r'''iunie''',
      r'''iulie''',
      r'''august''',
      r'''septembrie''',
      r'''octombrie''',
      r'''noiembrie''',
      r'''decembrie'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''ianuarie''',
      r'''februarie''',
      r'''martie''',
      r'''aprilie''',
      r'''mai''',
      r'''iunie''',
      r'''iulie''',
      r'''august''',
      r'''septembrie''',
      r'''octombrie''',
      r'''noiembrie''',
      r'''decembrie'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''ian.''',
      r'''feb.''',
      r'''mar.''',
      r'''apr.''',
      r'''mai''',
      r'''iun.''',
      r'''iul.''',
      r'''aug.''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''ian.''',
      r'''feb.''',
      r'''mar.''',
      r'''apr.''',
      r'''mai''',
      r'''iun.''',
      r'''iul.''',
      r'''aug.''',
      r'''sept.''',
      r'''oct.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''duminică''',
      r'''luni''',
      r'''marți''',
      r'''miercuri''',
      r'''joi''',
      r'''vineri''',
      r'''sâmbătă'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''duminică''',
      r'''luni''',
      r'''marți''',
      r'''miercuri''',
      r'''joi''',
      r'''vineri''',
      r'''sâmbătă'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''dum.''',
      r'''lun.''',
      r'''mar.''',
      r'''mie.''',
      r'''joi''',
      r'''vin.''',
      r'''sâm.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''dum.''',
      r'''lun.''',
      r'''mar.''',
      r'''mie.''',
      r'''joi''',
      r'''vin.''',
      r'''sâm.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''D''',
      r'''L''',
      r'''M''',
      r'''M''',
      r'''J''',
      r'''V''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''trim. I''',
      r'''trim. II''',
      r'''trim. III''',
      r'''trim. IV'''
    ],
    'QUARTERS': <dynamic>[
      r'''trimestrul I''',
      r'''trimestrul al II-lea''',
      r'''trimestrul al III-lea''',
      r'''trimestrul al IV-lea'''
    ],
    'AMPMS': <dynamic>[r'''a.m.''', r'''p.m.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd.MM.y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'ru': <String, dynamic>{
    'NAME': r'''ru''',
    'ERAS': <dynamic>[r'''до н. э.''', r'''н. э.'''],
    'ERANAMES': <dynamic>[
      r'''до Рождества Христова''',
      r'''от Рождества Христова'''
    ],
    'NARROWMONTHS': <dynamic>[
      r'''Я''',
      r'''Ф''',
      r'''М''',
      r'''А''',
      r'''М''',
      r'''И''',
      r'''И''',
      r'''А''',
      r'''С''',
      r'''О''',
      r'''Н''',
      r'''Д'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''Я''',
      r'''Ф''',
      r'''М''',
      r'''А''',
      r'''М''',
      r'''И''',
      r'''И''',
      r'''А''',
      r'''С''',
      r'''О''',
      r'''Н''',
      r'''Д'''
    ],
    'MONTHS': <dynamic>[
      r'''января''',
      r'''февраля''',
      r'''марта''',
      r'''апреля''',
      r'''мая''',
      r'''июня''',
      r'''июля''',
      r'''августа''',
      r'''сентября''',
      r'''октября''',
      r'''ноября''',
      r'''декабря'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''январь''',
      r'''февраль''',
      r'''март''',
      r'''апрель''',
      r'''май''',
      r'''июнь''',
      r'''июль''',
      r'''август''',
      r'''сентябрь''',
      r'''октябрь''',
      r'''ноябрь''',
      r'''декабрь'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''янв.''',
      r'''февр.''',
      r'''мар.''',
      r'''апр.''',
      r'''мая''',
      r'''июн.''',
      r'''июл.''',
      r'''авг.''',
      r'''сент.''',
      r'''окт.''',
      r'''нояб.''',
      r'''дек.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''янв.''',
      r'''февр.''',
      r'''март''',
      r'''апр.''',
      r'''май''',
      r'''июнь''',
      r'''июль''',
      r'''авг.''',
      r'''сент.''',
      r'''окт.''',
      r'''нояб.''',
      r'''дек.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''воскресенье''',
      r'''понедельник''',
      r'''вторник''',
      r'''среда''',
      r'''четверг''',
      r'''пятница''',
      r'''суббота'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''воскресенье''',
      r'''понедельник''',
      r'''вторник''',
      r'''среда''',
      r'''четверг''',
      r'''пятница''',
      r'''суббота'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''вс''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''вс''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''вс''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''В''',
      r'''П''',
      r'''В''',
      r'''С''',
      r'''Ч''',
      r'''П''',
      r'''С'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''1-й кв.''',
      r'''2-й кв.''',
      r'''3-й кв.''',
      r'''4-й кв.'''
    ],
    'QUARTERS': <dynamic>[
      r'''1-й квартал''',
      r'''2-й квартал''',
      r'''3-й квартал''',
      r'''4-й квартал'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d MMMM y 'г'.""",
      r"""d MMMM y 'г'.""",
      r"""d MMM y 'г'.""",
      r'''dd.MM.y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'sk': <String, dynamic>{
    'NAME': r'''sk''',
    'ERAS': <dynamic>[r'''pred Kr.''', r'''po Kr.'''],
    'ERANAMES': <dynamic>[r'''pred Kristom''', r'''po Kristovi'''],
    'NARROWMONTHS': <dynamic>[
      r'''j''',
      r'''f''',
      r'''m''',
      r'''a''',
      r'''m''',
      r'''j''',
      r'''j''',
      r'''a''',
      r'''s''',
      r'''o''',
      r'''n''',
      r'''d'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''j''',
      r'''f''',
      r'''m''',
      r'''a''',
      r'''m''',
      r'''j''',
      r'''j''',
      r'''a''',
      r'''s''',
      r'''o''',
      r'''n''',
      r'''d'''
    ],
    'MONTHS': <dynamic>[
      r'''januára''',
      r'''februára''',
      r'''marca''',
      r'''apríla''',
      r'''mája''',
      r'''júna''',
      r'''júla''',
      r'''augusta''',
      r'''septembra''',
      r'''októbra''',
      r'''novembra''',
      r'''decembra'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''január''',
      r'''február''',
      r'''marec''',
      r'''apríl''',
      r'''máj''',
      r'''jún''',
      r'''júl''',
      r'''august''',
      r'''september''',
      r'''október''',
      r'''november''',
      r'''december'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''máj''',
      r'''jún''',
      r'''júl''',
      r'''aug''',
      r'''sep''',
      r'''okt''',
      r'''nov''',
      r'''dec'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''máj''',
      r'''jún''',
      r'''júl''',
      r'''aug''',
      r'''sep''',
      r'''okt''',
      r'''nov''',
      r'''dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''nedeľa''',
      r'''pondelok''',
      r'''utorok''',
      r'''streda''',
      r'''štvrtok''',
      r'''piatok''',
      r'''sobota'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''nedeľa''',
      r'''pondelok''',
      r'''utorok''',
      r'''streda''',
      r'''štvrtok''',
      r'''piatok''',
      r'''sobota'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''ne''',
      r'''po''',
      r'''ut''',
      r'''st''',
      r'''št''',
      r'''pi''',
      r'''so'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''ne''',
      r'''po''',
      r'''ut''',
      r'''st''',
      r'''št''',
      r'''pi''',
      r'''so'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''n''',
      r'''p''',
      r'''u''',
      r'''s''',
      r'''š''',
      r'''p''',
      r'''s'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''n''',
      r'''p''',
      r'''u''',
      r'''s''',
      r'''š''',
      r'''p''',
      r'''s'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''1. štvrťrok''',
      r'''2. štvrťrok''',
      r'''3. štvrťrok''',
      r'''4. štvrťrok'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d. MMMM y''',
      r'''d. MMMM y''',
      r'''d. M. y''',
      r'''d. M. y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H:mm:ss zzzz''',
      r'''H:mm:ss z''',
      r'''H:mm:ss''',
      r'''H:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}''',
      r'''{1} {0}'''
    ],
  },
  'sl': <String, dynamic>{
    'NAME': r'''sl''',
    'ERAS': <dynamic>[r'''pr. Kr.''', r'''po Kr.'''],
    'ERANAMES': <dynamic>[r'''pred Kristusom''', r'''po Kristusu'''],
    'NARROWMONTHS': <dynamic>[
      r'''j''',
      r'''f''',
      r'''m''',
      r'''a''',
      r'''m''',
      r'''j''',
      r'''j''',
      r'''a''',
      r'''s''',
      r'''o''',
      r'''n''',
      r'''d'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''j''',
      r'''f''',
      r'''m''',
      r'''a''',
      r'''m''',
      r'''j''',
      r'''j''',
      r'''a''',
      r'''s''',
      r'''o''',
      r'''n''',
      r'''d'''
    ],
    'MONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''marec''',
      r'''april''',
      r'''maj''',
      r'''junij''',
      r'''julij''',
      r'''avgust''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''marec''',
      r'''april''',
      r'''maj''',
      r'''junij''',
      r'''julij''',
      r'''avgust''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mar.''',
      r'''apr.''',
      r'''maj''',
      r'''jun.''',
      r'''jul.''',
      r'''avg.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mar.''',
      r'''apr.''',
      r'''maj''',
      r'''jun.''',
      r'''jul.''',
      r'''avg.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''nedelja''',
      r'''ponedeljek''',
      r'''torek''',
      r'''sreda''',
      r'''četrtek''',
      r'''petek''',
      r'''sobota'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''nedelja''',
      r'''ponedeljek''',
      r'''torek''',
      r'''sreda''',
      r'''četrtek''',
      r'''petek''',
      r'''sobota'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''ned.''',
      r'''pon.''',
      r'''tor.''',
      r'''sre.''',
      r'''čet.''',
      r'''pet.''',
      r'''sob.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''ned.''',
      r'''pon.''',
      r'''tor.''',
      r'''sre.''',
      r'''čet.''',
      r'''pet.''',
      r'''sob.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''n''',
      r'''p''',
      r'''t''',
      r'''s''',
      r'''č''',
      r'''p''',
      r'''s'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''n''',
      r'''p''',
      r'''t''',
      r'''s''',
      r'''č''',
      r'''p''',
      r'''s'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''1. čet.''',
      r'''2. čet.''',
      r'''3. čet.''',
      r'''4. čet.'''
    ],
    'QUARTERS': <dynamic>[
      r'''1. četrtletje''',
      r'''2. četrtletje''',
      r'''3. četrtletje''',
      r'''4. četrtletje'''
    ],
    'AMPMS': <dynamic>[r'''dop.''', r'''pop.'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, dd. MMMM y''',
      r'''dd. MMMM y''',
      r'''d. MMM y''',
      r'''d. MM. yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'sr': <String, dynamic>{
    'NAME': r'''sr''',
    'ERAS': <dynamic>[r'''п. н. е.''', r'''н. е.'''],
    'ERANAMES': <dynamic>[r'''пре нове ере''', r'''нове ере'''],
    'NARROWMONTHS': <dynamic>[
      r'''ј''',
      r'''ф''',
      r'''м''',
      r'''а''',
      r'''м''',
      r'''ј''',
      r'''ј''',
      r'''а''',
      r'''с''',
      r'''о''',
      r'''н''',
      r'''д'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''ј''',
      r'''ф''',
      r'''м''',
      r'''а''',
      r'''м''',
      r'''ј''',
      r'''ј''',
      r'''а''',
      r'''с''',
      r'''о''',
      r'''н''',
      r'''д'''
    ],
    'MONTHS': <dynamic>[
      r'''јануар''',
      r'''фебруар''',
      r'''март''',
      r'''април''',
      r'''мај''',
      r'''јун''',
      r'''јул''',
      r'''август''',
      r'''септембар''',
      r'''октобар''',
      r'''новембар''',
      r'''децембар'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''јануар''',
      r'''фебруар''',
      r'''март''',
      r'''април''',
      r'''мај''',
      r'''јун''',
      r'''јул''',
      r'''август''',
      r'''септембар''',
      r'''октобар''',
      r'''новембар''',
      r'''децембар'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''јан''',
      r'''феб''',
      r'''мар''',
      r'''апр''',
      r'''мај''',
      r'''јун''',
      r'''јул''',
      r'''авг''',
      r'''сеп''',
      r'''окт''',
      r'''нов''',
      r'''дец'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''јан''',
      r'''феб''',
      r'''мар''',
      r'''апр''',
      r'''мај''',
      r'''јун''',
      r'''јул''',
      r'''авг''',
      r'''сеп''',
      r'''окт''',
      r'''нов''',
      r'''дец'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''недеља''',
      r'''понедељак''',
      r'''уторак''',
      r'''среда''',
      r'''четвртак''',
      r'''петак''',
      r'''субота'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''недеља''',
      r'''понедељак''',
      r'''уторак''',
      r'''среда''',
      r'''четвртак''',
      r'''петак''',
      r'''субота'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''нед''',
      r'''пон''',
      r'''уто''',
      r'''сре''',
      r'''чет''',
      r'''пет''',
      r'''суб'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''нед''',
      r'''пон''',
      r'''уто''',
      r'''сре''',
      r'''чет''',
      r'''пет''',
      r'''суб'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''н''',
      r'''п''',
      r'''у''',
      r'''с''',
      r'''ч''',
      r'''п''',
      r'''с'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''н''',
      r'''п''',
      r'''у''',
      r'''с''',
      r'''ч''',
      r'''п''',
      r'''с'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''К1''', r'''К2''', r'''К3''', r'''К4'''],
    'QUARTERS': <dynamic>[
      r'''први квартал''',
      r'''други квартал''',
      r'''трећи квартал''',
      r'''четврти квартал'''
    ],
    'AMPMS': <dynamic>[r'''пре подне''', r'''по подне'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, dd. MMMM y.''',
      r'''dd. MMMM y.''',
      r'''dd.MM.y.''',
      r'''d.M.yy.'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'sr_Latn': <String, dynamic>{
    'NAME': r'''sr_Latn''',
    'ERAS': <dynamic>[r'''p. n. e.''', r'''n. e.'''],
    'ERANAMES': <dynamic>[r'''pre nove ere''', r'''nove ere'''],
    'NARROWMONTHS': <dynamic>[
      r'''j''',
      r'''f''',
      r'''m''',
      r'''a''',
      r'''m''',
      r'''j''',
      r'''j''',
      r'''a''',
      r'''s''',
      r'''o''',
      r'''n''',
      r'''d'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''j''',
      r'''f''',
      r'''m''',
      r'''a''',
      r'''m''',
      r'''j''',
      r'''j''',
      r'''a''',
      r'''s''',
      r'''o''',
      r'''n''',
      r'''d'''
    ],
    'MONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''mart''',
      r'''april''',
      r'''maj''',
      r'''jun''',
      r'''jul''',
      r'''avgust''',
      r'''septembar''',
      r'''oktobar''',
      r'''novembar''',
      r'''decembar'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''januar''',
      r'''februar''',
      r'''mart''',
      r'''april''',
      r'''maj''',
      r'''jun''',
      r'''jul''',
      r'''avgust''',
      r'''septembar''',
      r'''oktobar''',
      r'''novembar''',
      r'''decembar'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''maj''',
      r'''jun''',
      r'''jul''',
      r'''avg''',
      r'''sep''',
      r'''okt''',
      r'''nov''',
      r'''dec'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan''',
      r'''feb''',
      r'''mar''',
      r'''apr''',
      r'''maj''',
      r'''jun''',
      r'''jul''',
      r'''avg''',
      r'''sep''',
      r'''okt''',
      r'''nov''',
      r'''dec'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''nedelja''',
      r'''ponedeljak''',
      r'''utorak''',
      r'''sreda''',
      r'''četvrtak''',
      r'''petak''',
      r'''subota'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''nedelja''',
      r'''ponedeljak''',
      r'''utorak''',
      r'''sreda''',
      r'''četvrtak''',
      r'''petak''',
      r'''subota'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''ned''',
      r'''pon''',
      r'''uto''',
      r'''sre''',
      r'''čet''',
      r'''pet''',
      r'''sub'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''ned''',
      r'''pon''',
      r'''uto''',
      r'''sre''',
      r'''čet''',
      r'''pet''',
      r'''sub'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''n''',
      r'''p''',
      r'''u''',
      r'''s''',
      r'''č''',
      r'''p''',
      r'''s'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''n''',
      r'''p''',
      r'''u''',
      r'''s''',
      r'''č''',
      r'''p''',
      r'''s'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''K1''', r'''K2''', r'''K3''', r'''K4'''],
    'QUARTERS': <dynamic>[
      r'''prvi kvartal''',
      r'''drugi kvartal''',
      r'''treći kvartal''',
      r'''četvrti kvartal'''
    ],
    'AMPMS': <dynamic>[r'''pre podne''', r'''po podne'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, dd. MMMM y.''',
      r'''dd. MMMM y.''',
      r'''dd.MM.y.''',
      r'''d.M.yy.'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'sv': <String, dynamic>{
    'NAME': r'''sv''',
    'ERAS': <dynamic>[r'''f.Kr.''', r'''e.Kr.'''],
    'ERANAMES': <dynamic>[r'''före Kristus''', r'''efter Kristus'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''januari''',
      r'''februari''',
      r'''mars''',
      r'''april''',
      r'''maj''',
      r'''juni''',
      r'''juli''',
      r'''augusti''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''januari''',
      r'''februari''',
      r'''mars''',
      r'''april''',
      r'''maj''',
      r'''juni''',
      r'''juli''',
      r'''augusti''',
      r'''september''',
      r'''oktober''',
      r'''november''',
      r'''december'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mars''',
      r'''apr.''',
      r'''maj''',
      r'''juni''',
      r'''juli''',
      r'''aug.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''jan.''',
      r'''feb.''',
      r'''mars''',
      r'''apr.''',
      r'''maj''',
      r'''juni''',
      r'''juli''',
      r'''aug.''',
      r'''sep.''',
      r'''okt.''',
      r'''nov.''',
      r'''dec.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''söndag''',
      r'''måndag''',
      r'''tisdag''',
      r'''onsdag''',
      r'''torsdag''',
      r'''fredag''',
      r'''lördag'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''söndag''',
      r'''måndag''',
      r'''tisdag''',
      r'''onsdag''',
      r'''torsdag''',
      r'''fredag''',
      r'''lördag'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''sön''',
      r'''mån''',
      r'''tis''',
      r'''ons''',
      r'''tors''',
      r'''fre''',
      r'''lör'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''sön''',
      r'''mån''',
      r'''tis''',
      r'''ons''',
      r'''tors''',
      r'''fre''',
      r'''lör'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''O''',
      r'''T''',
      r'''F''',
      r'''L'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''O''',
      r'''T''',
      r'''F''',
      r'''L'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''K1''', r'''K2''', r'''K3''', r'''K4'''],
    'QUARTERS': <dynamic>[
      r'''1:a kvartalet''',
      r'''2:a kvartalet''',
      r'''3:e kvartalet''',
      r'''4:e kvartalet'''
    ],
    'AMPMS': <dynamic>[r'''fm''', r'''em'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''y-MM-dd'''
    ],
    'TIMEFORMATS': <dynamic>[
      r"""'kl'. HH:mm:ss zzzz""",
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'sw': <String, dynamic>{
    'NAME': r'''sw''',
    'ERAS': <dynamic>[r'''KK''', r'''BK'''],
    'ERANAMES': <dynamic>[r'''Kabla ya Kristo''', r'''Baada ya Kristo'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''Januari''',
      r'''Februari''',
      r'''Machi''',
      r'''Aprili''',
      r'''Mei''',
      r'''Juni''',
      r'''Julai''',
      r'''Agosti''',
      r'''Septemba''',
      r'''Oktoba''',
      r'''Novemba''',
      r'''Desemba'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Januari''',
      r'''Februari''',
      r'''Machi''',
      r'''Aprili''',
      r'''Mei''',
      r'''Juni''',
      r'''Julai''',
      r'''Agosti''',
      r'''Septemba''',
      r'''Oktoba''',
      r'''Novemba''',
      r'''Desemba'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mac''',
      r'''Apr''',
      r'''Mei''',
      r'''Jun''',
      r'''Jul''',
      r'''Ago''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Des'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Jan''',
      r'''Feb''',
      r'''Mac''',
      r'''Apr''',
      r'''Mei''',
      r'''Jun''',
      r'''Jul''',
      r'''Ago''',
      r'''Sep''',
      r'''Okt''',
      r'''Nov''',
      r'''Des'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Jumapili''',
      r'''Jumatatu''',
      r'''Jumanne''',
      r'''Jumatano''',
      r'''Alhamisi''',
      r'''Ijumaa''',
      r'''Jumamosi'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Jumapili''',
      r'''Jumatatu''',
      r'''Jumanne''',
      r'''Jumatano''',
      r'''Alhamisi''',
      r'''Ijumaa''',
      r'''Jumamosi'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Jumapili''',
      r'''Jumatatu''',
      r'''Jumanne''',
      r'''Jumatano''',
      r'''Alhamisi''',
      r'''Ijumaa''',
      r'''Jumamosi'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Jumapili''',
      r'''Jumatatu''',
      r'''Jumanne''',
      r'''Jumatano''',
      r'''Alhamisi''',
      r'''Ijumaa''',
      r'''Jumamosi'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''Robo ya 1''',
      r'''Robo ya 2''',
      r'''Robo ya 3''',
      r'''Robo ya 4'''
    ],
    'QUARTERS': <dynamic>[
      r'''Robo ya 1''',
      r'''Robo ya 2''',
      r'''Robo ya 3''',
      r'''Robo ya 4'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM y''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''dd/MM/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'ta': <String, dynamic>{
    'NAME': r'''ta''',
    'ERAS': <dynamic>[r'''கி.மு.''', r'''கி.பி.'''],
    'ERANAMES': <dynamic>[r'''கிறிஸ்துவுக்கு முன்''', r'''அன்னோ டோமினி'''],
    'NARROWMONTHS': <dynamic>[
      r'''ஜ''',
      r'''பி''',
      r'''மா''',
      r'''ஏ''',
      r'''மே''',
      r'''ஜூ''',
      r'''ஜூ''',
      r'''ஆ''',
      r'''செ''',
      r'''அ''',
      r'''ந''',
      r'''டி'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''ஜ''',
      r'''பி''',
      r'''மா''',
      r'''ஏ''',
      r'''மே''',
      r'''ஜூ''',
      r'''ஜூ''',
      r'''ஆ''',
      r'''செ''',
      r'''அ''',
      r'''ந''',
      r'''டி'''
    ],
    'MONTHS': <dynamic>[
      r'''ஜனவரி''',
      r'''பிப்ரவரி''',
      r'''மார்ச்''',
      r'''ஏப்ரல்''',
      r'''மே''',
      r'''ஜூன்''',
      r'''ஜூலை''',
      r'''ஆகஸ்ட்''',
      r'''செப்டம்பர்''',
      r'''அக்டோபர்''',
      r'''நவம்பர்''',
      r'''டிசம்பர்'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''ஜனவரி''',
      r'''பிப்ரவரி''',
      r'''மார்ச்''',
      r'''ஏப்ரல்''',
      r'''மே''',
      r'''ஜூன்''',
      r'''ஜூலை''',
      r'''ஆகஸ்ட்''',
      r'''செப்டம்பர்''',
      r'''அக்டோபர்''',
      r'''நவம்பர்''',
      r'''டிசம்பர்'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''ஜன.''',
      r'''பிப்.''',
      r'''மார்.''',
      r'''ஏப்.''',
      r'''மே''',
      r'''ஜூன்''',
      r'''ஜூலை''',
      r'''ஆக.''',
      r'''செப்.''',
      r'''அக்.''',
      r'''நவ.''',
      r'''டிச.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''ஜன.''',
      r'''பிப்.''',
      r'''மார்.''',
      r'''ஏப்.''',
      r'''மே''',
      r'''ஜூன்''',
      r'''ஜூலை''',
      r'''ஆக.''',
      r'''செப்.''',
      r'''அக்.''',
      r'''நவ.''',
      r'''டிச.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''ஞாயிறு''',
      r'''திங்கள்''',
      r'''செவ்வாய்''',
      r'''புதன்''',
      r'''வியாழன்''',
      r'''வெள்ளி''',
      r'''சனி'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''ஞாயிறு''',
      r'''திங்கள்''',
      r'''செவ்வாய்''',
      r'''புதன்''',
      r'''வியாழன்''',
      r'''வெள்ளி''',
      r'''சனி'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''ஞாயி.''',
      r'''திங்.''',
      r'''செவ்.''',
      r'''புத.''',
      r'''வியா.''',
      r'''வெள்.''',
      r'''சனி'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''ஞாயி.''',
      r'''திங்.''',
      r'''செவ்.''',
      r'''புத.''',
      r'''வியா.''',
      r'''வெள்.''',
      r'''சனி'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''ஞா''',
      r'''தி''',
      r'''செ''',
      r'''பு''',
      r'''வி''',
      r'''வெ''',
      r'''ச'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''ஞா''',
      r'''தி''',
      r'''செ''',
      r'''பு''',
      r'''வி''',
      r'''வெ''',
      r'''ச'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''காலா.1''',
      r'''காலா.2''',
      r'''காலா.3''',
      r'''காலா.4'''
    ],
    'QUARTERS': <dynamic>[
      r'''ஒன்றாம் காலாண்டு''',
      r'''இரண்டாம் காலாண்டு''',
      r'''மூன்றாம் காலாண்டு''',
      r'''நான்காம் காலாண்டு'''
    ],
    'AMPMS': <dynamic>[r'''முற்பகல்''', r'''பிற்பகல்'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM, y''',
      r'''d MMMM, y''',
      r'''d MMM, y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''a h:mm:ss zzzz''',
      r'''a h:mm:ss z''',
      r'''a h:mm:ss''',
      r'''a h:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[6, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} ’அன்று’ {0}''',
      r'''{1} ’அன்று’ {0}''',
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'th': <String, dynamic>{
    'NAME': r'''th''',
    'ERAS': <dynamic>[r'''ปีก่อน ค.ศ.''', r'''ค.ศ.'''],
    'ERANAMES': <dynamic>[r'''ปีก่อนคริสต์ศักราช''', r'''คริสต์ศักราช'''],
    'NARROWMONTHS': <dynamic>[
      r'''ม.ค.''',
      r'''ก.พ.''',
      r'''มี.ค.''',
      r'''เม.ย.''',
      r'''พ.ค.''',
      r'''มิ.ย.''',
      r'''ก.ค.''',
      r'''ส.ค.''',
      r'''ก.ย.''',
      r'''ต.ค.''',
      r'''พ.ย.''',
      r'''ธ.ค.'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''ม.ค.''',
      r'''ก.พ.''',
      r'''มี.ค.''',
      r'''เม.ย.''',
      r'''พ.ค.''',
      r'''มิ.ย.''',
      r'''ก.ค.''',
      r'''ส.ค.''',
      r'''ก.ย.''',
      r'''ต.ค.''',
      r'''พ.ย.''',
      r'''ธ.ค.'''
    ],
    'MONTHS': <dynamic>[
      r'''มกราคม''',
      r'''กุมภาพันธ์''',
      r'''มีนาคม''',
      r'''เมษายน''',
      r'''พฤษภาคม''',
      r'''มิถุนายน''',
      r'''กรกฎาคม''',
      r'''สิงหาคม''',
      r'''กันยายน''',
      r'''ตุลาคม''',
      r'''พฤศจิกายน''',
      r'''ธันวาคม'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''มกราคม''',
      r'''กุมภาพันธ์''',
      r'''มีนาคม''',
      r'''เมษายน''',
      r'''พฤษภาคม''',
      r'''มิถุนายน''',
      r'''กรกฎาคม''',
      r'''สิงหาคม''',
      r'''กันยายน''',
      r'''ตุลาคม''',
      r'''พฤศจิกายน''',
      r'''ธันวาคม'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''ม.ค.''',
      r'''ก.พ.''',
      r'''มี.ค.''',
      r'''เม.ย.''',
      r'''พ.ค.''',
      r'''มิ.ย.''',
      r'''ก.ค.''',
      r'''ส.ค.''',
      r'''ก.ย.''',
      r'''ต.ค.''',
      r'''พ.ย.''',
      r'''ธ.ค.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''ม.ค.''',
      r'''ก.พ.''',
      r'''มี.ค.''',
      r'''เม.ย.''',
      r'''พ.ค.''',
      r'''มิ.ย.''',
      r'''ก.ค.''',
      r'''ส.ค.''',
      r'''ก.ย.''',
      r'''ต.ค.''',
      r'''พ.ย.''',
      r'''ธ.ค.'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''วันอาทิตย์''',
      r'''วันจันทร์''',
      r'''วันอังคาร''',
      r'''วันพุธ''',
      r'''วันพฤหัสบดี''',
      r'''วันศุกร์''',
      r'''วันเสาร์'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''วันอาทิตย์''',
      r'''วันจันทร์''',
      r'''วันอังคาร''',
      r'''วันพุธ''',
      r'''วันพฤหัสบดี''',
      r'''วันศุกร์''',
      r'''วันเสาร์'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''อา.''',
      r'''จ.''',
      r'''อ.''',
      r'''พ.''',
      r'''พฤ.''',
      r'''ศ.''',
      r'''ส.'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''อา.''',
      r'''จ.''',
      r'''อ.''',
      r'''พ.''',
      r'''พฤ.''',
      r'''ศ.''',
      r'''ส.'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''อา''',
      r'''จ''',
      r'''อ''',
      r'''พ''',
      r'''พฤ''',
      r'''ศ''',
      r'''ส'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''อา''',
      r'''จ''',
      r'''อ''',
      r'''พ''',
      r'''พฤ''',
      r'''ศ''',
      r'''ส'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''ไตรมาส 1''',
      r'''ไตรมาส 2''',
      r'''ไตรมาส 3''',
      r'''ไตรมาส 4'''
    ],
    'QUARTERS': <dynamic>[
      r'''ไตรมาส 1''',
      r'''ไตรมาส 2''',
      r'''ไตรมาส 3''',
      r'''ไตรมาส 4'''
    ],
    'AMPMS': <dynamic>[r'''ก่อนเที่ยง''', r'''หลังเที่ยง'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEEที่ d MMMM G y''',
      r'''d MMMM G y''',
      r'''d MMM y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''H นาฬิกา mm นาที ss วินาที zzzz''',
      r'''H นาฬิกา mm นาที ss วินาที z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'tl': <String, dynamic>{
    'NAME': r'''tl''',
    'ERAS': <dynamic>[r'''BC''', r'''AD'''],
    'ERANAMES': <dynamic>[r'''Before Christ''', r'''Anno Domini'''],
    'NARROWMONTHS': <dynamic>[
      r'''Ene''',
      r'''Peb''',
      r'''Mar''',
      r'''Abr''',
      r'''May''',
      r'''Hun''',
      r'''Hul''',
      r'''Ago''',
      r'''Set''',
      r'''Okt''',
      r'''Nob''',
      r'''Dis'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''E''',
      r'''P''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''Hun''',
      r'''Hul''',
      r'''Ago''',
      r'''Set''',
      r'''Okt''',
      r'''Nob''',
      r'''Dis'''
    ],
    'MONTHS': <dynamic>[
      r'''Enero''',
      r'''Pebrero''',
      r'''Marso''',
      r'''Abril''',
      r'''Mayo''',
      r'''Hunyo''',
      r'''Hulyo''',
      r'''Agosto''',
      r'''Setyembre''',
      r'''Oktubre''',
      r'''Nobyembre''',
      r'''Disyembre'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Enero''',
      r'''Pebrero''',
      r'''Marso''',
      r'''Abril''',
      r'''Mayo''',
      r'''Hunyo''',
      r'''Hulyo''',
      r'''Agosto''',
      r'''Setyembre''',
      r'''Oktubre''',
      r'''Nobyembre''',
      r'''Disyembre'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Ene''',
      r'''Peb''',
      r'''Mar''',
      r'''Abr''',
      r'''May''',
      r'''Hun''',
      r'''Hul''',
      r'''Ago''',
      r'''Set''',
      r'''Okt''',
      r'''Nob''',
      r'''Dis'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Ene''',
      r'''Peb''',
      r'''Mar''',
      r'''Abr''',
      r'''May''',
      r'''Hun''',
      r'''Hul''',
      r'''Ago''',
      r'''Set''',
      r'''Okt''',
      r'''Nob''',
      r'''Dis'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Linggo''',
      r'''Lunes''',
      r'''Martes''',
      r'''Miyerkules''',
      r'''Huwebes''',
      r'''Biyernes''',
      r'''Sabado'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Linggo''',
      r'''Lunes''',
      r'''Martes''',
      r'''Miyerkules''',
      r'''Huwebes''',
      r'''Biyernes''',
      r'''Sabado'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Lin''',
      r'''Lun''',
      r'''Mar''',
      r'''Miy''',
      r'''Huw''',
      r'''Biy''',
      r'''Sab'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Lin''',
      r'''Lun''',
      r'''Mar''',
      r'''Miy''',
      r'''Huw''',
      r'''Biy''',
      r'''Sab'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''Lin''',
      r'''Lun''',
      r'''Mar''',
      r'''Miy''',
      r'''Huw''',
      r'''Biy''',
      r'''Sab'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''Lin''',
      r'''Lun''',
      r'''Mar''',
      r'''Miy''',
      r'''Huw''',
      r'''Biy''',
      r'''Sab'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''ika-1 quarter''',
      r'''ika-2 quarter''',
      r'''ika-3 quarter''',
      r'''ika-4 na quarter'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, MMMM d, y''',
      r'''MMMM d, y''',
      r'''MMM d, y''',
      r'''M/d/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'nang' {0}""",
      r"""{1} 'nang' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'tr': <String, dynamic>{
    'NAME': r'''tr''',
    'ERAS': <dynamic>[r'''MÖ''', r'''MS'''],
    'ERANAMES': <dynamic>[r'''Milattan Önce''', r'''Milattan Sonra'''],
    'NARROWMONTHS': <dynamic>[
      r'''O''',
      r'''Ş''',
      r'''M''',
      r'''N''',
      r'''M''',
      r'''H''',
      r'''T''',
      r'''A''',
      r'''E''',
      r'''E''',
      r'''K''',
      r'''A'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''O''',
      r'''Ş''',
      r'''M''',
      r'''N''',
      r'''M''',
      r'''H''',
      r'''T''',
      r'''A''',
      r'''E''',
      r'''E''',
      r'''K''',
      r'''A'''
    ],
    'MONTHS': <dynamic>[
      r'''Ocak''',
      r'''Şubat''',
      r'''Mart''',
      r'''Nisan''',
      r'''Mayıs''',
      r'''Haziran''',
      r'''Temmuz''',
      r'''Ağustos''',
      r'''Eylül''',
      r'''Ekim''',
      r'''Kasım''',
      r'''Aralık'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Ocak''',
      r'''Şubat''',
      r'''Mart''',
      r'''Nisan''',
      r'''Mayıs''',
      r'''Haziran''',
      r'''Temmuz''',
      r'''Ağustos''',
      r'''Eylül''',
      r'''Ekim''',
      r'''Kasım''',
      r'''Aralık'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''Oca''',
      r'''Şub''',
      r'''Mar''',
      r'''Nis''',
      r'''May''',
      r'''Haz''',
      r'''Tem''',
      r'''Ağu''',
      r'''Eyl''',
      r'''Eki''',
      r'''Kas''',
      r'''Ara'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Oca''',
      r'''Şub''',
      r'''Mar''',
      r'''Nis''',
      r'''May''',
      r'''Haz''',
      r'''Tem''',
      r'''Ağu''',
      r'''Eyl''',
      r'''Eki''',
      r'''Kas''',
      r'''Ara'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Pazar''',
      r'''Pazartesi''',
      r'''Salı''',
      r'''Çarşamba''',
      r'''Perşembe''',
      r'''Cuma''',
      r'''Cumartesi'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Pazar''',
      r'''Pazartesi''',
      r'''Salı''',
      r'''Çarşamba''',
      r'''Perşembe''',
      r'''Cuma''',
      r'''Cumartesi'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''Paz''',
      r'''Pzt''',
      r'''Sal''',
      r'''Çar''',
      r'''Per''',
      r'''Cum''',
      r'''Cmt'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''Paz''',
      r'''Pzt''',
      r'''Sal''',
      r'''Çar''',
      r'''Per''',
      r'''Cum''',
      r'''Cmt'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''P''',
      r'''P''',
      r'''S''',
      r'''Ç''',
      r'''P''',
      r'''C''',
      r'''C'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''P''',
      r'''P''',
      r'''S''',
      r'''Ç''',
      r'''P''',
      r'''C''',
      r'''C'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Ç1''', r'''Ç2''', r'''Ç3''', r'''Ç4'''],
    'QUARTERS': <dynamic>[
      r'''1. çeyrek''',
      r'''2. çeyrek''',
      r'''3. çeyrek''',
      r'''4. çeyrek'''
    ],
    'AMPMS': <dynamic>[r'''ÖÖ''', r'''ÖS'''],
    'DATEFORMATS': <dynamic>[
      r'''d MMMM y EEEE''',
      r'''d MMMM y''',
      r'''d MMM y''',
      r'''d.MM.y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'uk': <String, dynamic>{
    'NAME': r'''uk''',
    'ERAS': <dynamic>[r'''до н. е.''', r'''н. е.'''],
    'ERANAMES': <dynamic>[r'''до нашої ери''', r'''нашої ери'''],
    'NARROWMONTHS': <dynamic>[
      r'''с''',
      r'''л''',
      r'''б''',
      r'''к''',
      r'''т''',
      r'''ч''',
      r'''л''',
      r'''с''',
      r'''в''',
      r'''ж''',
      r'''л''',
      r'''г'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''С''',
      r'''Л''',
      r'''Б''',
      r'''К''',
      r'''Т''',
      r'''Ч''',
      r'''Л''',
      r'''С''',
      r'''В''',
      r'''Ж''',
      r'''Л''',
      r'''Г'''
    ],
    'MONTHS': <dynamic>[
      r'''січня''',
      r'''лютого''',
      r'''березня''',
      r'''квітня''',
      r'''травня''',
      r'''червня''',
      r'''липня''',
      r'''серпня''',
      r'''вересня''',
      r'''жовтня''',
      r'''листопада''',
      r'''грудня'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''січень''',
      r'''лютий''',
      r'''березень''',
      r'''квітень''',
      r'''травень''',
      r'''червень''',
      r'''липень''',
      r'''серпень''',
      r'''вересень''',
      r'''жовтень''',
      r'''листопад''',
      r'''грудень'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''січ.''',
      r'''лют.''',
      r'''бер.''',
      r'''квіт.''',
      r'''трав.''',
      r'''черв.''',
      r'''лип.''',
      r'''серп.''',
      r'''вер.''',
      r'''жовт.''',
      r'''лист.''',
      r'''груд.'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''січ''',
      r'''лют''',
      r'''бер''',
      r'''кві''',
      r'''тра''',
      r'''чер''',
      r'''лип''',
      r'''сер''',
      r'''вер''',
      r'''жов''',
      r'''лис''',
      r'''гру'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''неділя''',
      r'''понеділок''',
      r'''вівторок''',
      r'''середа''',
      r'''четвер''',
      r'''пʼятниця''',
      r'''субота'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''неділя''',
      r'''понеділок''',
      r'''вівторок''',
      r'''середа''',
      r'''четвер''',
      r'''пʼятниця''',
      r'''субота'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''нд''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''нд''',
      r'''пн''',
      r'''вт''',
      r'''ср''',
      r'''чт''',
      r'''пт''',
      r'''сб'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''Н''',
      r'''П''',
      r'''В''',
      r'''С''',
      r'''Ч''',
      r'''П''',
      r'''С'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''Н''',
      r'''П''',
      r'''В''',
      r'''С''',
      r'''Ч''',
      r'''П''',
      r'''С'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''1-й кв.''',
      r'''2-й кв.''',
      r'''3-й кв.''',
      r'''4-й кв.'''
    ],
    'QUARTERS': <dynamic>[
      r'''1-й квартал''',
      r'''2-й квартал''',
      r'''3-й квартал''',
      r'''4-й квартал'''
    ],
    'AMPMS': <dynamic>[r'''дп''', r'''пп'''],
    'DATEFORMATS': <dynamic>[
      r"""EEEE, d MMMM y 'р'.""",
      r"""d MMMM y 'р'.""",
      r"""d MMM y 'р'.""",
      r'''dd.MM.yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r"""{1} 'о' {0}""",
      r"""{1} 'о' {0}""",
      r'''{1}, {0}''',
      r'''{1}, {0}'''
    ],
  },
  'ur': <String, dynamic>{
    'NAME': r'''ur''',
    'ERAS': <dynamic>[r'''قبل مسیح''', r'''عیسوی'''],
    'ERANAMES': <dynamic>[r'''قبل مسیح''', r'''عیسوی'''],
    'NARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''J''',
      r'''F''',
      r'''M''',
      r'''A''',
      r'''M''',
      r'''J''',
      r'''J''',
      r'''A''',
      r'''S''',
      r'''O''',
      r'''N''',
      r'''D'''
    ],
    'MONTHS': <dynamic>[
      r'''جنوری''',
      r'''فروری''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مئی''',
      r'''جون''',
      r'''جولائی''',
      r'''اگست''',
      r'''ستمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''جنوری''',
      r'''فروری''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مئی''',
      r'''جون''',
      r'''جولائی''',
      r'''اگست''',
      r'''ستمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''جنوری''',
      r'''فروری''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مئی''',
      r'''جون''',
      r'''جولائی''',
      r'''اگست''',
      r'''ستمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''جنوری''',
      r'''فروری''',
      r'''مارچ''',
      r'''اپریل''',
      r'''مئی''',
      r'''جون''',
      r'''جولائی''',
      r'''اگست''',
      r'''ستمبر''',
      r'''اکتوبر''',
      r'''نومبر''',
      r'''دسمبر'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''اتوار''',
      r'''پیر''',
      r'''منگل''',
      r'''بدھ''',
      r'''جمعرات''',
      r'''جمعہ''',
      r'''ہفتہ'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''اتوار''',
      r'''پیر''',
      r'''منگل''',
      r'''بدھ''',
      r'''جمعرات''',
      r'''جمعہ''',
      r'''ہفتہ'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''اتوار''',
      r'''پیر''',
      r'''منگل''',
      r'''بدھ''',
      r'''جمعرات''',
      r'''جمعہ''',
      r'''ہفتہ'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''اتوار''',
      r'''پیر''',
      r'''منگل''',
      r'''بدھ''',
      r'''جمعرات''',
      r'''جمعہ''',
      r'''ہفتہ'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''S''',
      r'''M''',
      r'''T''',
      r'''W''',
      r'''T''',
      r'''F''',
      r'''S'''
    ],
    'SHORTQUARTERS': <dynamic>[
      r'''پہلی سہ ماہی''',
      r'''دوسری سہ ماہی''',
      r'''تیسری سہ ماہی''',
      r'''چوتهی سہ ماہی'''
    ],
    'QUARTERS': <dynamic>[
      r'''پہلی سہ ماہی''',
      r'''دوسری سہ ماہی''',
      r'''تیسری سہ ماہی''',
      r'''چوتهی سہ ماہی'''
    ],
    'AMPMS': <dynamic>[r'''AM''', r'''PM'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE، d MMMM، y''',
      r'''d MMMM، y''',
      r'''d MMM، y''',
      r'''d/M/yy'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''h:mm:ss a zzzz''',
      r'''h:mm:ss a z''',
      r'''h:mm:ss a''',
      r'''h:mm a'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'vi': <String, dynamic>{
    'NAME': r'''vi''',
    'ERAS': <dynamic>[r'''Trước CN''', r'''sau CN'''],
    'ERANAMES': <dynamic>[r'''Trước CN''', r'''sau CN'''],
    'NARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': <dynamic>[
      r'''tháng 1''',
      r'''tháng 2''',
      r'''tháng 3''',
      r'''tháng 4''',
      r'''tháng 5''',
      r'''tháng 6''',
      r'''tháng 7''',
      r'''tháng 8''',
      r'''tháng 9''',
      r'''tháng 10''',
      r'''tháng 11''',
      r'''tháng 12'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''Tháng 1''',
      r'''Tháng 2''',
      r'''Tháng 3''',
      r'''Tháng 4''',
      r'''Tháng 5''',
      r'''Tháng 6''',
      r'''Tháng 7''',
      r'''Tháng 8''',
      r'''Tháng 9''',
      r'''Tháng 10''',
      r'''Tháng 11''',
      r'''Tháng 12'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''thg 1''',
      r'''thg 2''',
      r'''thg 3''',
      r'''thg 4''',
      r'''thg 5''',
      r'''thg 6''',
      r'''thg 7''',
      r'''thg 8''',
      r'''thg 9''',
      r'''thg 10''',
      r'''thg 11''',
      r'''thg 12'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''Thg 1''',
      r'''Thg 2''',
      r'''Thg 3''',
      r'''Thg 4''',
      r'''Thg 5''',
      r'''Thg 6''',
      r'''Thg 7''',
      r'''Thg 8''',
      r'''Thg 9''',
      r'''Thg 10''',
      r'''Thg 11''',
      r'''Thg 12'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''Chủ Nhật''',
      r'''Thứ Hai''',
      r'''Thứ Ba''',
      r'''Thứ Tư''',
      r'''Thứ Năm''',
      r'''Thứ Sáu''',
      r'''Thứ Bảy'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''Chủ Nhật''',
      r'''Thứ Hai''',
      r'''Thứ Ba''',
      r'''Thứ Tư''',
      r'''Thứ Năm''',
      r'''Thứ Sáu''',
      r'''Thứ Bảy'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''CN''',
      r'''Th 2''',
      r'''Th 3''',
      r'''Th 4''',
      r'''Th 5''',
      r'''Th 6''',
      r'''Th 7'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''CN''',
      r'''Th 2''',
      r'''Th 3''',
      r'''Th 4''',
      r'''Th 5''',
      r'''Th 6''',
      r'''Th 7'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''CN''',
      r'''T2''',
      r'''T3''',
      r'''T4''',
      r'''T5''',
      r'''T6''',
      r'''T7'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''CN''',
      r'''T2''',
      r'''T3''',
      r'''T4''',
      r'''T5''',
      r'''T6''',
      r'''T7'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[
      r'''Quý 1''',
      r'''Quý 2''',
      r'''Quý 3''',
      r'''Quý 4'''
    ],
    'AMPMS': <dynamic>[r'''SA''', r'''CH'''],
    'DATEFORMATS': <dynamic>[
      r'''EEEE, d MMMM, y''',
      r'''d MMMM, y''',
      r'''d MMM, y''',
      r'''dd/MM/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''HH:mm:ss zzzz''',
      r'''HH:mm:ss z''',
      r'''HH:mm:ss''',
      r'''HH:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      r'''{0} {1}''',
      r'''{0} {1}''',
      r'''{0}, {1}''',
      r'''{0}, {1}'''
    ],
  },
  'zh': <String, dynamic>{
    'NAME': r'''zh''',
    'ERAS': <dynamic>[r'''公元前''', r'''公元'''],
    'ERANAMES': <dynamic>[r'''公元前''', r'''公元'''],
    'NARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': <dynamic>[
      r'''一月''',
      r'''二月''',
      r'''三月''',
      r'''四月''',
      r'''五月''',
      r'''六月''',
      r'''七月''',
      r'''八月''',
      r'''九月''',
      r'''十月''',
      r'''十一月''',
      r'''十二月'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''一月''',
      r'''二月''',
      r'''三月''',
      r'''四月''',
      r'''五月''',
      r'''六月''',
      r'''七月''',
      r'''八月''',
      r'''九月''',
      r'''十月''',
      r'''十一月''',
      r'''十二月'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''星期日''',
      r'''星期一''',
      r'''星期二''',
      r'''星期三''',
      r'''星期四''',
      r'''星期五''',
      r'''星期六'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''星期日''',
      r'''星期一''',
      r'''星期二''',
      r'''星期三''',
      r'''星期四''',
      r'''星期五''',
      r'''星期六'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''周日''',
      r'''周一''',
      r'''周二''',
      r'''周三''',
      r'''周四''',
      r'''周五''',
      r'''周六'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''周日''',
      r'''周一''',
      r'''周二''',
      r'''周三''',
      r'''周四''',
      r'''周五''',
      r'''周六'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''日''',
      r'''一''',
      r'''二''',
      r'''三''',
      r'''四''',
      r'''五''',
      r'''六'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''日''',
      r'''一''',
      r'''二''',
      r'''三''',
      r'''四''',
      r'''五''',
      r'''六'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''1季度''', r'''2季度''', r'''3季度''', r'''4季度'''],
    'QUARTERS': <dynamic>[r'''第一季度''', r'''第二季度''', r'''第三季度''', r'''第四季度'''],
    'AMPMS': <dynamic>[r'''上午''', r'''下午'''],
    'DATEFORMATS': <dynamic>[
      r'''y年M月d日EEEE''',
      r'''y年M月d日''',
      r'''y年M月d日''',
      r'''y/M/d'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''zzzz ah:mm:ss''',
      r'''z ah:mm:ss''',
      r'''ah:mm:ss''',
      r'''ah:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'zh_HK': <String, dynamic>{
    'NAME': r'''zh_HK''',
    'ERAS': <dynamic>[r'''公元前''', r'''公元'''],
    'ERANAMES': <dynamic>[r'''公元前''', r'''公元'''],
    'NARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''星期日''',
      r'''星期一''',
      r'''星期二''',
      r'''星期三''',
      r'''星期四''',
      r'''星期五''',
      r'''星期六'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''星期日''',
      r'''星期一''',
      r'''星期二''',
      r'''星期三''',
      r'''星期四''',
      r'''星期五''',
      r'''星期六'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''週日''',
      r'''週一''',
      r'''週二''',
      r'''週三''',
      r'''週四''',
      r'''週五''',
      r'''週六'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''週日''',
      r'''週一''',
      r'''週二''',
      r'''週三''',
      r'''週四''',
      r'''週五''',
      r'''週六'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''日''',
      r'''一''',
      r'''二''',
      r'''三''',
      r'''四''',
      r'''五''',
      r'''六'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''日''',
      r'''一''',
      r'''二''',
      r'''三''',
      r'''四''',
      r'''五''',
      r'''六'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''Q1''', r'''Q2''', r'''Q3''', r'''Q4'''],
    'QUARTERS': <dynamic>[r'''第1季''', r'''第2季''', r'''第3季''', r'''第4季'''],
    'AMPMS': <dynamic>[r'''上午''', r'''下午'''],
    'DATEFORMATS': <dynamic>[
      r'''y年M月d日EEEE''',
      r'''y年M月d日''',
      r'''y年M月d日''',
      r'''d/M/y'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''ah:mm:ss [zzzz]''',
      r'''ah:mm:ss [z]''',
      r'''ah:mm:ss''',
      r'''ah:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
  'zh_TW': <String, dynamic>{
    'NAME': r'''zh_TW''',
    'ERAS': <dynamic>[r'''西元前''', r'''西元'''],
    'ERANAMES': <dynamic>[r'''西元前''', r'''西元'''],
    'NARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      r'''1''',
      r'''2''',
      r'''3''',
      r'''4''',
      r'''5''',
      r'''6''',
      r'''7''',
      r'''8''',
      r'''9''',
      r'''10''',
      r'''11''',
      r'''12'''
    ],
    'MONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONEMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'SHORTMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      r'''1月''',
      r'''2月''',
      r'''3月''',
      r'''4月''',
      r'''5月''',
      r'''6月''',
      r'''7月''',
      r'''8月''',
      r'''9月''',
      r'''10月''',
      r'''11月''',
      r'''12月'''
    ],
    'WEEKDAYS': <dynamic>[
      r'''星期日''',
      r'''星期一''',
      r'''星期二''',
      r'''星期三''',
      r'''星期四''',
      r'''星期五''',
      r'''星期六'''
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      r'''星期日''',
      r'''星期一''',
      r'''星期二''',
      r'''星期三''',
      r'''星期四''',
      r'''星期五''',
      r'''星期六'''
    ],
    'SHORTWEEKDAYS': <dynamic>[
      r'''週日''',
      r'''週一''',
      r'''週二''',
      r'''週三''',
      r'''週四''',
      r'''週五''',
      r'''週六'''
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      r'''週日''',
      r'''週一''',
      r'''週二''',
      r'''週三''',
      r'''週四''',
      r'''週五''',
      r'''週六'''
    ],
    'NARROWWEEKDAYS': <dynamic>[
      r'''日''',
      r'''一''',
      r'''二''',
      r'''三''',
      r'''四''',
      r'''五''',
      r'''六'''
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      r'''日''',
      r'''一''',
      r'''二''',
      r'''三''',
      r'''四''',
      r'''五''',
      r'''六'''
    ],
    'SHORTQUARTERS': <dynamic>[r'''第1季''', r'''第2季''', r'''第3季''', r'''第4季'''],
    'QUARTERS': <dynamic>[r'''第1季''', r'''第2季''', r'''第3季''', r'''第4季'''],
    'AMPMS': <dynamic>[r'''上午''', r'''下午'''],
    'DATEFORMATS': <dynamic>[
      r'''y年M月d日 EEEE''',
      r'''y年M月d日''',
      r'''y年M月d日''',
      r'''y/M/d'''
    ],
    'TIMEFORMATS': <dynamic>[
      r'''ah:mm:ss [zzzz]''',
      r'''ah:mm:ss [z]''',
      r'''ah:mm:ss''',
      r'''ah:mm'''
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[5, 6],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}''',
      r'''{1} {0}'''
    ],
  },
};

/// The subset of date patterns supported by the intl package which are also
/// supported by flutter_localizations.
const Map<String, Map<String, String>> datePatterns =
    <String, Map<String, String>>{
  'ar': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/‏M''',
    'MEd': r'''EEE، d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE، d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE، d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M‏/y''',
    'yMd': r'''d‏/M‏/y''',
    'yMEd': r'''EEE، d/‏M/‏y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE، d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE، d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'bg': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.MM''',
    'MEd': r'''EEE, d.MM''',
    'MMM': r'''MM''',
    'MMMd': r'''d.MM''',
    'MMMEd': r'''EEE, d.MM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r"""y 'г'.""",
    'yM': r"""MM.y 'г'.""",
    'yMd': r"""d.MM.y 'г'.""",
    'yMEd': r"""EEE, d.MM.y 'г'.""",
    'yMMM': r"""MM.y 'г'.""",
    'yMMMd': r"""d.MM.y 'г'.""",
    'yMMMEd': r"""EEE, d.MM.y 'г'.""",
    'yMMMM': r"""MMMM y 'г'.""",
    'yMMMMd': r"""d MMMM y 'г'.""",
    'yMMMMEEEEd': r"""EEEE, d MMMM y 'г'.""",
    'yQQQ': r"""QQQ y 'г'.""",
    'yQQQQ': r"""QQQQ y 'г'.""",
    'H': r"""H 'ч'.""",
    'Hm': r"""H:mm 'ч'.""",
    'Hms': r"""H:mm:ss 'ч'.""",
    'j': r"""H 'ч'.""",
    'jm': r"""H:mm 'ч'.""",
    'jms': r"""H:mm:ss 'ч'.""",
    'jmv': r"""HH:mm 'ч'. v""",
    'jmz': r"""HH:mm 'ч'. z""",
    'jz': r"""H 'ч'. z""",
    'm': r'''m''',
    'ms': r'''m:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'bs': <String, String>{
    'd': r'''d.''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE, d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE, d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y.''',
    'yM': r'''MM/y''',
    'yMd': r'''d.M.y.''',
    'yMEd': r'''EEE, d.M.y.''',
    'yMMM': r'''MMM y.''',
    'yMMMd': r'''d. MMM y.''',
    'yMMMEd': r'''EEE, d. MMM y.''',
    'yMMMM': r'''LLLL y.''',
    'yMMMMd': r'''d. MMMM y.''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y.''',
    'yQQQ': r'''QQQ y.''',
    'yQQQQ': r'''QQQQ y.''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm (v)''',
    'jmz': r'''HH:mm (z)''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ca': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r"""LLL 'de' y""",
    'yMMMd': r"""d MMM 'de' y""",
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r"""LLLL 'de' y""",
    'yMMMMd': r"""d MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d MMMM 'de' y""",
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'cs': <String, String>{
    'd': r'''d.''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d. M.''',
    'MEd': r'''EEE d. M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. M.''',
    'MMMEd': r'''EEE d. M.''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d. M. y''',
    'yMEd': r'''EEE d. M. y''',
    'yMMM': r'''LLLL y''',
    'yMMMd': r'''d. M. y''',
    'yMMMEd': r'''EEE d. M. y''',
    'yMMMM': r'''LLLL y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'da': <String, String>{
    'd': r'''d.''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''MMM''',
    'LLLL': r'''MMMM''',
    'M': r'''M''',
    'Md': r'''d/M''',
    'MEd': r'''EEE d/M''',
    'MMM': r'''MMM''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE d. MMM''',
    'MMMM': r'''MMMM''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d. MMM y''',
    'yMMMEd': r'''EEE d. MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r"""EEEE 'den' d. MMMM y""",
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH.mm''',
    'Hms': r'''HH.mm.ss''',
    'j': r'''HH''',
    'jm': r'''HH.mm''',
    'jms': r'''HH.mm.ss''',
    'jmv': r'''HH.mm v''',
    'jmz': r'''HH.mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm.ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'de': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE, d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE, d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M.y''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE, d.M.y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d. MMM y''',
    'yMMMEd': r'''EEE, d. MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r"""HH 'Uhr'""",
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r"""HH 'Uhr'""",
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r"""HH 'Uhr' z""",
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'de_CH': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE, d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE, d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M.y''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE, d.M.y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d. MMM y''',
    'yMMMEd': r'''EEE, d. MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r"""HH 'Uhr'""",
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r"""HH 'Uhr'""",
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r"""HH 'Uhr' z""",
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'el': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''MMM''',
    'LLLL': r'''MMMM''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''MMM''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''MMMM''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''LLLL y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''y QQQ''',
    'yQQQQ': r'''y QQQQ''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'en': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''M/d''',
    'MEd': r'''EEE, M/d''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d''',
    'MMMEd': r'''EEE, MMM d''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d''',
    'MMMMEEEEd': r'''EEEE, MMMM d''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''M/d/y''',
    'yMEd': r'''EEE, M/d/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''MMM d, y''',
    'yMMMEd': r'''EEE, MMM d, y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''MMMM d, y''',
    'yMMMMEEEEd': r'''EEEE, MMMM d, y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'en_AU': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd/MM/y''',
    'yMEd': r'''EEE, dd/MM/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'en_CA': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''MM-dd''',
    'MEd': r'''EEE, MM-dd''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d''',
    'MMMEd': r'''EEE, MMM d''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d''',
    'MMMMEEEEd': r'''EEEE, MMMM d''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y-MM''',
    'yMd': r'''y-MM-dd''',
    'yMEd': r'''EEE, y-MM-dd''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''MMM d, y''',
    'yMMMEd': r'''EEE, MMM d, y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''MMMM d, y''',
    'yMMMMEEEEd': r'''EEEE, MMMM d, y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'en_GB': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd/MM''',
    'MEd': r'''EEE dd/MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd/MM/y''',
    'yMEd': r'''EEE, dd/MM/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'en_IE': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'en_IN': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd/MM''',
    'MEd': r'''EEE, dd/MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM, y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM, y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'en_SG': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd/MM''',
    'MEd': r'''EEE, dd/MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd/MM/y''',
    'yMEd': r'''EEE, dd/MM/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'en_ZA': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''MM/dd''',
    'MEd': r'''EEE, MM/dd''',
    'MMM': r'''LLL''',
    'MMMd': r'''dd MMM''',
    'MMMEd': r'''EEE, dd MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, dd MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''y/MM/dd''',
    'yMEd': r'''EEE, y/MM/dd''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''dd MMM y''',
    'yMMMEd': r'''EEE, dd MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'es': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r"""d 'de' MMMM""",
    'MMMMEEEEd': r"""EEEE, d 'de' MMMM""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r"""MMMM 'de' y""",
    'yMMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d 'de' MMMM 'de' y""",
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r"""QQQQ 'de' y""",
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'es_419': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r"""d 'de' MMMM""",
    'MMMMEEEEd': r"""EEEE, d 'de' MMMM""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE d/M/y''',
    'yMMM': r"""MMMM 'de' y""",
    'yMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMEd': r"""EEE, d 'de' MMM 'de' y""",
    'yMMMM': r"""MMMM 'de' y""",
    'yMMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d 'de' MMMM 'de' y""",
    'yQQQ': r"""QQQ 'de' y""",
    'yQQQQ': r"""QQQQ 'de' y""",
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'es_MX': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r"""EEE d 'de' MMM""",
    'MMMM': r'''LLLL''',
    'MMMMd': r"""d 'de' MMMM""",
    'MMMMEEEEd': r"""EEEE, d 'de' MMMM""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r"""MMMM 'de' y""",
    'yMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMEd': r"""EEE, d 'de' MMMM 'de' y""",
    'yMMMM': r"""MMMM 'de' y""",
    'yMMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d 'de' MMMM 'de' y""",
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r"""QQQQ 'de' y""",
    'H': r'''HH''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''HH''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'es_US': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r"""EEE, d 'de' MMM""",
    'MMMM': r'''LLLL''',
    'MMMMd': r"""d 'de' MMMM""",
    'MMMMEEEEd': r"""EEEE, d 'de' MMMM""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r"""MMMM 'de' y""",
    'yMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMEd': r"""EEE, d 'de' MMMM 'de' y""",
    'yMMMM': r"""MMMM 'de' y""",
    'yMMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d 'de' MMMM 'de' y""",
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r"""QQQQ 'de' y""",
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'et': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''MMMM''',
    'LLLL': r'''MMMM''',
    'M': r'''M''',
    'Md': r'''d.M''',
    'MEd': r'''EEE, d.M''',
    'MMM': r'''MMMM''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE, d. MMM''',
    'MMMM': r'''MMMM''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M.y''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE, d.M.y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d. MMM y''',
    'yMMMEd': r'''EEE, d. MMMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'fa': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''M/d''',
    'MEd': r'''EEE M/d''',
    'MMM': r'''LLL''',
    'MMMd': r'''d LLL''',
    'MMMEd': r'''EEE d LLL''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d LLLL''',
    'MMMMEEEEd': r'''EEEE d LLLL''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y/M''',
    'yMd': r'''y/M/d''',
    'yMEd': r'''EEE y/M/d''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm (z)''',
    'jz': r'''H (z)''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'fi': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''ccc d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''cccc d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''L.y''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE d.M.y''',
    'yMMM': r'''LLL y''',
    'yMMMd': r'''d. MMM y''',
    'yMMMEd': r'''EEE d. MMM y''',
    'yMMMM': r'''LLLL y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''H.mm''',
    'Hms': r'''H.mm.ss''',
    'j': r'''H''',
    'jm': r'''H.mm''',
    'jms': r'''H.mm.ss''',
    'jmv': r'''H.mm v''',
    'jmz': r'''H.mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''m.ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'fil': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''M/d''',
    'MEd': r'''EEE, M/d''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d''',
    'MMMEd': r'''EEE, MMM d''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d''',
    'MMMMEEEEd': r'''EEEE, MMMM d''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''M/d/y''',
    'yMEd': r'''EEE, M/d/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''MMM d, y''',
    'yMMMEd': r'''EEE, MMM d, y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''MMMM d, y''',
    'yMMMMEEEEd': r'''EEEE, MMMM d, y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'fr': <String, String>{
    'd': r'''d''',
    'E': r'''EEE''',
    'EEEE': r'''EEEE''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd/MM''',
    'MEd': r'''EEE dd/MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd/MM/y''',
    'yMEd': r'''EEE dd/MM/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r"""HH 'h'""",
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r"""HH 'h'""",
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r"""HH 'h' z""",
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'fr_CA': <String, String>{
    'd': r'''d''',
    'E': r'''EEE''',
    'EEEE': r'''EEEE''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''M-d''',
    'MEd': r'''EEE M-d''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y-MM''',
    'yMd': r'''y-MM-dd''',
    'yMEd': r'''EEE y-MM-dd''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r"""HH 'h'""",
    'Hm': r"""HH 'h' mm""",
    'Hms': r"""HH 'h' mm 'min' ss 's'""",
    'j': r"""HH 'h'""",
    'jm': r"""HH 'h' mm""",
    'jms': r"""HH 'h' mm 'min' ss 's'""",
    'jmv': r"""HH 'h' mm v""",
    'jmz': r"""HH 'h' mm z""",
    'jz': r"""HH 'h' z""",
    'm': r'''m''',
    'ms': r"""mm 'min' ss 's'""",
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'gl': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r"""d 'de' MMM""",
    'MMMEd': r"""EEE, d 'de' MMM""",
    'MMMM': r'''LLLL''',
    'MMMMd': r"""d 'de' MMMM""",
    'MMMMEEEEd': r"""EEEE, d 'de' MMMM""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r"""MMM 'de' y""",
    'yMMMd': r'''d/MM/y''',
    'yMMMEd': r'''EEE, d/MM/y''',
    'yMMMM': r"""MMMM 'de' y""",
    'yMMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d 'de' MMMM 'de' y""",
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r"""QQQQ 'de' y""",
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'gsw': <String, String>{
    'd': r'''d''',
    'E': r'''EEE''',
    'EEEE': r'''EEEE''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE, d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y-M''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE, y-M-d''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''y MMM d''',
    'yMMMEd': r'''EEE, d. MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''H''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'he': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M''',
    'MEd': r'''EEE, d.M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d בMMM''',
    'MMMEd': r'''EEE, d בMMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d בMMMM''',
    'MMMMEEEEd': r'''EEEE, d בMMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M.y''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE, d.M.y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d בMMM y''',
    'yMMMEd': r'''EEE, d בMMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d בMMMM y''',
    'yMMMMEEEEd': r'''EEEE, d בMMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'hi': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'hr': <String, String>{
    'd': r'''d.''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L.''',
    'Md': r'''dd. MM.''',
    'MEd': r'''EEE, dd. MM.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE, d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y.''',
    'yM': r'''MM. y.''',
    'yMd': r'''dd. MM. y.''',
    'yMEd': r'''EEE, dd. MM. y.''',
    'yMMM': r'''LLL y.''',
    'yMMMd': r'''d. MMM y.''',
    'yMMMEd': r'''EEE, d. MMM y.''',
    'yMMMM': r'''LLLL y.''',
    'yMMMMd': r'''d. MMMM y.''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y.''',
    'yQQQ': r'''QQQ y.''',
    'yQQQQ': r'''QQQQ y.''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH (z)''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'hu': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''M. d.''',
    'MEd': r'''M. d., EEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d.''',
    'MMMEd': r'''MMM d., EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d.''',
    'MMMMEEEEd': r'''MMMM d., EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y.''',
    'yM': r'''y. M.''',
    'yMd': r'''y. MM. dd.''',
    'yMEd': r'''y. MM. dd., EEE''',
    'yMMM': r'''y. MMM''',
    'yMMMd': r'''y. MMM d.''',
    'yMMMEd': r'''y. MMM d., EEE''',
    'yMMMM': r'''y. MMMM''',
    'yMMMMd': r'''y. MMMM d.''',
    'yMMMMEEEEd': r'''y. MMMM d., EEEE''',
    'yQQQ': r'''y. QQQ''',
    'yQQQQ': r'''y. QQQQ''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'hy': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd.MM''',
    'MEd': r'''dd.MM, EEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''d MMM, EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d''',
    'MMMMEEEEd': r'''d MMMM, EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM.y''',
    'yMd': r'''dd.MM.y''',
    'yMEd': r'''d.MM.y թ., EEE''',
    'yMMM': r'''y թ. LLL''',
    'yMMMd': r'''d MMM, y թ.''',
    'yMMMEd': r'''y թ. MMM d, EEE''',
    'yMMMM': r'''y թ․ LLLL''',
    'yMMMMd': r'''d MMMM, y թ.''',
    'yMMMMEEEEd': r'''y թ. MMMM d, EEEE''',
    'yQQQ': r'''y թ. QQQ''',
    'yQQQQ': r'''y թ. QQQQ''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'id': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH.mm''',
    'Hms': r'''HH.mm.ss''',
    'j': r'''HH''',
    'jm': r'''HH.mm''',
    'jms': r'''HH.mm.ss''',
    'jmv': r'''HH.mm v''',
    'jmz': r'''HH.mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm.ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'it': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ja': <String, String>{
    'd': r'''d日''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''M月''',
    'LLLL': r'''M月''',
    'M': r'''M月''',
    'Md': r'''M/d''',
    'MEd': r'''M/d(EEE)''',
    'MMM': r'''M月''',
    'MMMd': r'''M月d日''',
    'MMMEd': r'''M月d日(EEE)''',
    'MMMM': r'''M月''',
    'MMMMd': r'''M月d日''',
    'MMMMEEEEd': r'''M月d日EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y年''',
    'yM': r'''y/M''',
    'yMd': r'''y/M/d''',
    'yMEd': r'''y/M/d(EEE)''',
    'yMMM': r'''y年M月''',
    'yMMMd': r'''y年M月d日''',
    'yMMMEd': r'''y年M月d日(EEE)''',
    'yMMMM': r'''y年M月''',
    'yMMMMd': r'''y年M月d日''',
    'yMMMMEEEEd': r'''y年M月d日EEEE''',
    'yQQQ': r'''y/QQQ''',
    'yQQQQ': r'''y年QQQQ''',
    'H': r'''H時''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H時''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''H時 z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'kk': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd.MM''',
    'MEd': r'''dd.MM, EEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''d MMM, EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''d MMMM, EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM.y''',
    'yMd': r'''dd.MM.y''',
    'yMEd': r'''dd.MM.y, EEE''',
    'yMMM': r"""y 'ж'. MMM""",
    'yMMMd': r"""y 'ж'. d MMM""",
    'yMMMEd': r"""y 'ж'. d MMM, EEE""",
    'yMMMM': r"""y 'ж'. MMMM""",
    'yMMMMd': r"""y 'ж'. d MMMM""",
    'yMMMMEEEEd': r"""y 'ж'. d MMMM, EEEE""",
    'yQQQ': r"""y 'ж'. QQQ""",
    'yQQQQ': r"""y 'ж'. QQQQ""",
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'km': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ko': <String, String>{
    'd': r'''d일''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''M월''',
    'Md': r'''M. d.''',
    'MEd': r'''M. d. (EEE)''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d일''',
    'MMMEd': r'''MMM d일 (EEE)''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d일''',
    'MMMMEEEEd': r'''MMMM d일 EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y년''',
    'yM': r'''y. M.''',
    'yMd': r'''y. M. d.''',
    'yMEd': r'''y. M. d. (EEE)''',
    'yMMM': r'''y년 MMM''',
    'yMMMd': r'''y년 MMM d일''',
    'yMMMEd': r'''y년 MMM d일 (EEE)''',
    'yMMMM': r'''y년 MMMM''',
    'yMMMMd': r'''y년 MMMM d일''',
    'yMMMMEEEEd': r'''y년 MMMM d일 EEEE''',
    'yQQQ': r'''y년 QQQ''',
    'yQQQQ': r'''y년 QQQQ''',
    'H': r'''H시''',
    'Hm': r'''HH:mm''',
    'Hms': r'''H시 m분 s초''',
    'j': r'''a h시''',
    'jm': r'''a h:mm''',
    'jms': r'''a h:mm:ss''',
    'jmv': r'''a h:mm v''',
    'jmz': r'''a h:mm z''',
    'jz': r'''a h시 z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'lt': <String, String>{
    'd': r'''dd''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''MM''',
    'Md': r'''MM-d''',
    'MEd': r'''MM-dd, EEE''',
    'MMM': r'''MM''',
    'MMMd': r'''MM-dd''',
    'MMMEd': r'''MM-dd, EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r"""MMMM d 'd'.""",
    'MMMMEEEEd': r"""MMMM d 'd'., EEEE""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y-MM''',
    'yMd': r'''y-MM-dd''',
    'yMEd': r'''y-MM-dd, EEE''',
    'yMMM': r'''y-MM''',
    'yMMMd': r'''y-MM-dd''',
    'yMMMEd': r'''y-MM-dd, EEE''',
    'yMMMM': r"""y 'm'. LLLL""",
    'yMMMMd': r"""y 'm'. MMMM d 'd'.""",
    'yMMMMEEEEd': r"""y 'm'. MMMM d 'd'., EEEE""",
    'yQQQ': r'''y QQQ''',
    'yQQQQ': r'''y QQQQ''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm; v''',
    'jmz': r'''HH:mm; z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'lv': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd.MM.''',
    'MEd': r'''EEE, dd.MM.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE, d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r"""y. 'g'.""",
    'yM': r'''MM.y.''',
    'yMd': r'''y.MM.d.''',
    'yMEd': r'''EEE, d.M.y.''',
    'yMMM': r"""y. 'g'. MMM""",
    'yMMMd': r"""y. 'g'. d. MMM""",
    'yMMMEd': r"""EEE, y. 'g'. d. MMM""",
    'yMMMM': r"""y. 'g'. MMMM""",
    'yMMMMd': r"""y. 'gada' d. MMMM""",
    'yMMMMEEEEd': r"""EEEE, y. 'gada' d. MMMM""",
    'yQQQ': r"""y. 'g'. QQQ""",
    'yQQQQ': r"""y. 'g'. QQQQ""",
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'mn': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''MM/dd''',
    'MEd': r'''MM/dd, EEE''',
    'MMM': r'''LLL''',
    'MMMd': r"""MMM'ын' d""",
    'MMMEd': r"""MMM'ын' d, EEE""",
    'MMMM': r'''LLLL''',
    'MMMMd': r"""MMM'ын' d""",
    'MMMMEEEEd': r"""MMMM'ын' d, EEEE""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y M''',
    'yMd': r'''y.MM.dd''',
    'yMEd': r'''y.MM.dd, EEE''',
    'yMMM': r"""y 'оны' MMM""",
    'yMMMd': r'''y.MM.dd''',
    'yMMMEd': r'''y.MM.dd, EEE''',
    'yMMMM': r"""y 'оны' MMM""",
    'yMMMMd': r'''y.MM.dd''',
    'yMMMMEEEEd': r'''y.MM.dd, EEEE''',
    'yQQQ': r'''y QQQ''',
    'yQQQQ': r"""y 'оны' QQQQ""",
    'H': r"""HH 'ц'""",
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r"""HH 'ц'""",
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r"""HH 'ц' z""",
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'mr': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM, y''',
    'yMMMEd': r'''EEE, d, MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM, y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM, y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ms': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d-M''',
    'MEd': r'''EEE, d-M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M-y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'nb': <String, String>{
    'd': r'''d.''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L.''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M.y''',
    'yMd': r'''d.M.y''',
    'yMEd': r'''EEE d.MM.y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d. MMM y''',
    'yMMMEd': r'''EEE d. MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'nl': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d-M''',
    'MEd': r'''EEE d-M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M-y''',
    'yMd': r'''d-M-y''',
    'yMEd': r'''EEE d-M-y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'pl': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.MM''',
    'MEd': r'''EEE, d.MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM.y''',
    'yMd': r'''d.MM.y''',
    'yMEd': r'''EEE, d.MM.y''',
    'yMMM': r'''LLL y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''LLLL y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ps': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''MM-dd''',
    'MEd': r'''MM-dd, EEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d''',
    'MMMEd': r'''MMM d, EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d''',
    'MMMMEEEEd': r'''MMMM d, EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y-MM''',
    'yMd': r'''y-MM-dd''',
    'yMEd': r'''y-MM-dd, EEE''',
    'yMMM': r'''y MMM''',
    'yMMMd': r'''y MMM d''',
    'yMMMEd': r'''y MMM d, EEE''',
    'yMMMM': r'''y MMMM''',
    'yMMMMd': r'''د y د MMMM d''',
    'yMMMMEEEEd': r'''EEEE د y د MMMM d''',
    'yQQQ': r'''y QQQ''',
    'yQQQQ': r'''y QQQQ''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH (z)''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'pt': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, dd/MM''',
    'MMM': r'''LLL''',
    'MMMd': r"""d 'de' MMM""",
    'MMMEd': r"""EEE, d 'de' MMM""",
    'MMMM': r'''LLLL''',
    'MMMMd': r"""d 'de' MMMM""",
    'MMMMEEEEd': r"""EEEE, d 'de' MMMM""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd/MM/y''',
    'yMEd': r'''EEE, dd/MM/y''',
    'yMMM': r"""MMM 'de' y""",
    'yMMMd': r"""d 'de' MMM 'de' y""",
    'yMMMEd': r"""EEE, d 'de' MMM 'de' y""",
    'yMMMM': r"""MMMM 'de' y""",
    'yMMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d 'de' MMMM 'de' y""",
    'yQQQ': r"""QQQ 'de' y""",
    'yQQQQ': r"""QQQQ 'de' y""",
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'pt_PT': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd/MM''',
    'MEd': r'''EEE, dd/MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d/MM''',
    'MMMEd': r'''EEE, d/MM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r"""d 'de' MMMM""",
    'MMMMEEEEd': r"""cccc, d 'de' MMMM""",
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd/MM/y''',
    'yMEd': r'''EEE, dd/MM/y''',
    'yMMM': r'''MM/y''',
    'yMMMd': r'''d/MM/y''',
    'yMMMEd': r'''EEE, d/MM/y''',
    'yMMMM': r"""MMMM 'de' y""",
    'yMMMMd': r"""d 'de' MMMM 'de' y""",
    'yMMMMEEEEd': r"""EEEE, d 'de' MMMM 'de' y""",
    'yQQQ': r"""QQQQ 'de' y""",
    'yQQQQ': r"""QQQQ 'de' y""",
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ro': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd.MM''',
    'MEd': r'''EEE, dd.MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM.y''',
    'yMd': r'''dd.MM.y''',
    'yMEd': r'''EEE, dd.MM.y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ru': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd.MM''',
    'MEd': r'''EEE, dd.MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''ccc, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''cccc, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM.y''',
    'yMd': r'''dd.MM.y''',
    'yMEd': r"""ccc, dd.MM.y 'г'.""",
    'yMMM': r"""LLL y 'г'.""",
    'yMMMd': r"""d MMM y 'г'.""",
    'yMMMEd': r"""EEE, d MMM y 'г'.""",
    'yMMMM': r"""LLLL y 'г'.""",
    'yMMMMd': r"""d MMMM y 'г'.""",
    'yMMMMEEEEd': r"""EEEE, d MMMM y 'г'.""",
    'yQQQ': r"""QQQ y 'г'.""",
    'yQQQQ': r"""QQQQ y 'г'.""",
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'sk': <String, String>{
    'd': r'''d.''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L.''',
    'Md': r'''d. M.''',
    'MEd': r'''EEE d. M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. M.''',
    'MMMEd': r'''EEE d. M.''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d. M. y''',
    'yMEd': r'''EEE d. M. y''',
    'yMMM': r'''M/y''',
    'yMMMd': r'''d. M. y''',
    'yMMMEd': r'''EEE d. M. y''',
    'yMMMM': r'''LLLL y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''H''',
    'Hm': r'''H:mm''',
    'Hms': r'''H:mm:ss''',
    'j': r'''H''',
    'jm': r'''H:mm''',
    'jms': r'''H:mm:ss''',
    'jmv': r'''H:mm v''',
    'jmz': r'''H:mm z''',
    'jz': r'''H z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'sl': <String, String>{
    'd': r'''d.''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d. M.''',
    'MEd': r'''EEE, d. M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE, d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d. M. y''',
    'yMEd': r'''EEE, d. M. y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d. MMM y''',
    'yMMMEd': r'''EEE, d. MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d. MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r"""HH'h'""",
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r"""HH'h'""",
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r"""HH'h' z""",
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'sr': <String, String>{
    'd': r'''d''',
    'E': r'''EEE''',
    'EEEE': r'''EEEE''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE, d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y.''',
    'yM': r'''M.y.''',
    'yMd': r'''d.M.y.''',
    'yMEd': r'''EEE, d.M.y.''',
    'yMMM': r'''MMM y.''',
    'yMMMd': r'''d. MMM y.''',
    'yMMMEd': r'''EEE, d. MMM y.''',
    'yMMMM': r'''MMMM y.''',
    'yMMMMd': r'''d. MMMM y.''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y.''',
    'yQQQ': r'''QQQ y.''',
    'yQQQQ': r'''QQQQ y.''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'sr_Latn': <String, String>{
    'd': r'''d''',
    'E': r'''EEE''',
    'EEEE': r'''EEEE''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d.M.''',
    'MEd': r'''EEE, d.M.''',
    'MMM': r'''LLL''',
    'MMMd': r'''d. MMM''',
    'MMMEd': r'''EEE d. MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d. MMMM''',
    'MMMMEEEEd': r'''EEEE, d. MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y.''',
    'yM': r'''M.y.''',
    'yMd': r'''d.M.y.''',
    'yMEd': r'''EEE, d.M.y.''',
    'yMMM': r'''MMM y.''',
    'yMMMd': r'''d. MMM y.''',
    'yMMMEd': r'''EEE, d. MMM y.''',
    'yMMMM': r'''MMMM y.''',
    'yMMMMd': r'''d. MMMM y.''',
    'yMMMMEEEEd': r'''EEEE, d. MMMM y.''',
    'yQQQ': r'''QQQ y.''',
    'yQQQQ': r'''QQQQ y.''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'sv': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''y-MM''',
    'yMd': r'''y-MM-dd''',
    'yMEd': r'''EEE, y-MM-dd''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE d MMMM y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'sw': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE, d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, MMM d, y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM y''',
    'yQQQ': r'''y QQQ''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ta': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''dd-MM, EEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d''',
    'MMMEd': r'''MMM d, EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''MMMM d, EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM, y''',
    'yMMMEd': r'''EEE, d MMM, y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM, y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM, y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''a h''',
    'jm': r'''a h:mm''',
    'jms': r'''a h:mm:ss''',
    'jmv': r'''a h:mm v''',
    'jmz': r'''a h:mm z''',
    'jz': r'''a h z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'th': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEEที่ d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE d MMM y''',
    'yMMMM': r'''MMMM G y''',
    'yMMMMd': r'''d MMMM G y''',
    'yMMMMEEEEd': r'''EEEEที่ d MMMM G y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ G y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm น.''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm น.''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'tl': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''M/d''',
    'MEd': r'''EEE, M/d''',
    'MMM': r'''LLL''',
    'MMMd': r'''MMM d''',
    'MMMEd': r'''EEE, MMM d''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''MMMM d''',
    'MMMMEEEEd': r'''EEEE, MMMM d''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''M/d/y''',
    'yMEd': r'''EEE, M/d/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''MMM d, y''',
    'yMMMEd': r'''EEE, MMM d, y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''MMMM d, y''',
    'yMMMMEEEEd': r'''EEEE, MMMM d, y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'tr': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''d/MM EEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''d MMMM EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''d MMMM EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM/y''',
    'yMd': r'''dd.MM.y''',
    'yMEd': r'''d.M.y EEE''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''d MMM y EEE''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM y''',
    'yMMMMEEEEd': r'''d MMMM y EEEE''',
    'yQQQ': r'''y QQQ''',
    'yQQQQ': r'''y QQQQ''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'uk': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''LL''',
    'Md': r'''dd.MM''',
    'MEd': r'''EEE, dd.MM''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''MM.y''',
    'yMd': r'''dd.MM.y''',
    'yMEd': r'''EEE, dd.MM.y''',
    'yMMM': r'''LLL y''',
    'yMMMd': r'''d MMM y''',
    'yMMMEd': r'''EEE, d MMM y''',
    'yMMMM': r'''LLLL y''',
    'yMMMMd': r"""d MMMM y 'р'.""",
    'yMMMMEEEEd': r"""EEEE, d MMMM y 'р'.""",
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r"""QQQQ y 'р'.""",
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''HH:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'ur': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''d/M''',
    'MEd': r'''EEE، d/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE، d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE، d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE، d/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM، y''',
    'yMMMEd': r'''EEE، d MMM، y''',
    'yMMMM': r'''MMMM y''',
    'yMMMMd': r'''d MMMM، y''',
    'yMMMMEEEEd': r'''EEEE، d MMMM، y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r'''QQQQ y''',
    'H': r'''HH''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''h a''',
    'jm': r'''h:mm a''',
    'jms': r'''h:mm:ss a''',
    'jmv': r'''h:mm a v''',
    'jmz': r'''h:mm a z''',
    'jz': r'''h a z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'vi': <String, String>{
    'd': r'''d''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''L''',
    'Md': r'''dd/M''',
    'MEd': r'''EEE, dd/M''',
    'MMM': r'''LLL''',
    'MMMd': r'''d MMM''',
    'MMMEd': r'''EEE, d MMM''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''d MMMM''',
    'MMMMEEEEd': r'''EEEE, d MMMM''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''EEE, dd/M/y''',
    'yMMM': r'''MMM y''',
    'yMMMd': r'''d MMM, y''',
    'yMMMEd': r'''EEE, d MMM, y''',
    'yMMMM': r"""MMMM 'năm' y""",
    'yMMMMd': r'''d MMMM, y''',
    'yMMMMEEEEd': r'''EEEE, d MMMM, y''',
    'yQQQ': r'''QQQ y''',
    'yQQQQ': r"""QQQQ 'năm' y""",
    'H': r'''HH''',
    'Hm': r'''H:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''HH''',
    'jm': r'''H:mm''',
    'jms': r'''HH:mm:ss''',
    'jmv': r'''HH:mm v''',
    'jmz': r'''HH:mm z''',
    'jz': r'''HH z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'zh': <String, String>{
    'd': r'''d日''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''M月''',
    'Md': r'''M/d''',
    'MEd': r'''M/dEEE''',
    'MMM': r'''LLL''',
    'MMMd': r'''M月d日''',
    'MMMEd': r'''M月d日EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''M月d日''',
    'MMMMEEEEd': r'''M月d日EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y年''',
    'yM': r'''y年M月''',
    'yMd': r'''y/M/d''',
    'yMEd': r'''y/M/dEEE''',
    'yMMM': r'''y年M月''',
    'yMMMd': r'''y年M月d日''',
    'yMMMEd': r'''y年M月d日EEE''',
    'yMMMM': r'''y年M月''',
    'yMMMMd': r'''y年M月d日''',
    'yMMMMEEEEd': r'''y年M月d日EEEE''',
    'yQQQ': r'''y年第Q季度''',
    'yQQQQ': r'''y年第Q季度''',
    'H': r'''H时''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''ah时''',
    'jm': r'''ah:mm''',
    'jms': r'''ah:mm:ss''',
    'jmv': r'''v ah:mm''',
    'jmz': r'''z ah:mm''',
    'jz': r'''zah时''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'zh_HK': <String, String>{
    'd': r'''d日''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''M月''',
    'Md': r'''d/M''',
    'MEd': r'''d/M（EEE）''',
    'MMM': r'''LLL''',
    'MMMd': r'''M月d日''',
    'MMMEd': r'''M月d日EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''M月d日''',
    'MMMMEEEEd': r'''M月d日EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y年''',
    'yM': r'''M/y''',
    'yMd': r'''d/M/y''',
    'yMEd': r'''d/M/y（EEE）''',
    'yMMM': r'''y年M月''',
    'yMMMd': r'''y年M月d日''',
    'yMMMEd': r'''y年M月d日EEE''',
    'yMMMM': r'''y年M月''',
    'yMMMMd': r'''y年M月d日''',
    'yMMMMEEEEd': r'''y年M月d日EEEE''',
    'yQQQ': r'''y年QQQ''',
    'yQQQQ': r'''y年QQQQ''',
    'H': r'''H時''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''ah時''',
    'jm': r'''ah:mm''',
    'jms': r'''ah:mm:ss''',
    'jmv': r'''ah:mm [v]''',
    'jmz': r'''ah:mm [z]''',
    'jz': r'''ah時 z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
  'zh_TW': <String, String>{
    'd': r'''d日''',
    'E': r'''ccc''',
    'EEEE': r'''cccc''',
    'LLL': r'''LLL''',
    'LLLL': r'''LLLL''',
    'M': r'''M月''',
    'Md': r'''M/d''',
    'MEd': r'''M/d（EEE）''',
    'MMM': r'''LLL''',
    'MMMd': r'''M月d日''',
    'MMMEd': r'''M月d日 EEE''',
    'MMMM': r'''LLLL''',
    'MMMMd': r'''M月d日''',
    'MMMMEEEEd': r'''M月d日 EEEE''',
    'QQQ': r'''QQQ''',
    'QQQQ': r'''QQQQ''',
    'y': r'''y年''',
    'yM': r'''y/M''',
    'yMd': r'''y/M/d''',
    'yMEd': r'''y/M/d（EEE）''',
    'yMMM': r'''y年M月''',
    'yMMMd': r'''y年M月d日''',
    'yMMMEd': r'''y年M月d日 EEE''',
    'yMMMM': r'''y年M月''',
    'yMMMMd': r'''y年M月d日''',
    'yMMMMEEEEd': r'''y年M月d日 EEEE''',
    'yQQQ': r'''y年QQQ''',
    'yQQQQ': r'''y年QQQQ''',
    'H': r'''H時''',
    'Hm': r'''HH:mm''',
    'Hms': r'''HH:mm:ss''',
    'j': r'''ah時''',
    'jm': r'''ah:mm''',
    'jms': r'''ah:mm:ss''',
    'jmv': r'''ah:mm [v]''',
    'jmz': r'''ah:mm [z]''',
    'jz': r'''ah時 z''',
    'm': r'''m''',
    'ms': r'''mm:ss''',
    's': r'''s''',
    'v': r'''v''',
    'z': r'''z''',
    'zzzz': r'''zzzz''',
    'ZZZZ': r'''ZZZZ''',
  },
};
