// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated. Please do not edit it manually.
// To regenerate the file, use:
// dart dev/tools/localization/gen_localizations.dart --overwrite

import 'dart:collection';

import 'package:flutter/foundation.dart';
import 'package:flutter/cupertino.dart';
import 'package:intl/intl.dart' as intl;

import '../cupertino_localizations.dart';

// The classes defined here encode all of the translations found in the
// `flutter_localizations/lib/src/l10n/*.arb` files.
//
// These classes are constructed by the [getCupertinoTranslation] method at the
// bottom of this file, and used by the [_GlobalCupertinoLocalizationsDelegate.load]
// method defined in `flutter_localizations/lib/src/cupertino_localizations.dart`.

/// The translations for English (`en`).
class CupertinoLocalizationEn extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for English.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationEn({
    String localeName = 'en',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alert';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Copy';

  @override
  String get cutButtonLabel => r'Cut';

  @override
  String get datePickerDateOrderString => r'mdy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelOne => r'$hour o' "'" r'clock';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour o' "'" r'clock';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'1 minute';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutes';

  @override
  String get pasteButtonLabel => r'Paste';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Select All';

  @override
  String get timerPickerHourLabelOne => r'hour';

  @override
  String get timerPickerHourLabelOther => r'hours';

  @override
  String get timerPickerMinuteLabelOne => r'min.';

  @override
  String get timerPickerMinuteLabelOther => r'min.';

  @override
  String get timerPickerSecondLabelOne => r'sec.';

  @override
  String get timerPickerSecondLabelOther => r'sec.';

  @override
  String get todayLabel => r'Today';
}

/// The translations for French (`fr`).
class CupertinoLocalizationFr extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for French.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationFr({
    String localeName = 'fr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Alerte';

  @override
  String get anteMeridiemAbbreviation => r'AM';

  @override
  String get copyButtonLabel => r'Copier';

  @override
  String get cutButtonLabel => r'Couper';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelOne => r'une heure';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour heures';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'une minute';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute minutes';

  @override
  String get pasteButtonLabel => r'Coller';

  @override
  String get postMeridiemAbbreviation => r'PM';

  @override
  String get selectAllButtonLabel => r'Tout sélect.';

  @override
  String get timerPickerHourLabelOne => r'heure';

  @override
  String get timerPickerHourLabelOther => r'heures';

  @override
  String get timerPickerMinuteLabelOne => r'minute';

  @override
  String get timerPickerMinuteLabelOther => r'minutes';

  @override
  String get timerPickerSecondLabelOne => null;

  @override
  String get timerPickerSecondLabelOther => r's';

  @override
  String get todayLabel => r'aujourd' "'" r'hui';
}

/// The translations for Turkish (`tr`).
class CupertinoLocalizationTr extends GlobalCupertinoLocalizations {
  /// Create an instance of the translation bundle for Turkish.
  ///
  /// For details on the meaning of the arguments, see [GlobalCupertinoLocalizations].
  const CupertinoLocalizationTr({
    String localeName = 'tr',
    @required intl.DateFormat fullYearFormat,
    @required intl.DateFormat dayFormat,
    @required intl.DateFormat mediumDateFormat,
    @required intl.DateFormat singleDigitHourFormat,
    @required intl.DateFormat singleDigitMinuteFormat,
    @required intl.DateFormat doubleDigitMinuteFormat,
    @required intl.DateFormat singleDigitSecondFormat,
    @required intl.NumberFormat decimalFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    dayFormat: dayFormat,
    mediumDateFormat: mediumDateFormat,
    singleDigitHourFormat: singleDigitHourFormat,
    singleDigitMinuteFormat: singleDigitMinuteFormat,
    doubleDigitMinuteFormat: doubleDigitMinuteFormat,
    singleDigitSecondFormat: singleDigitSecondFormat,
    decimalFormat: decimalFormat,
  );

  @override
  String get alertDialogLabel => r'Uyarı';

  @override
  String get anteMeridiemAbbreviation => r'ÖÖ';

  @override
  String get copyButtonLabel => r'Kopyala';

  @override
  String get cutButtonLabel => r'Kes';

  @override
  String get datePickerDateOrderString => r'dmy';

  @override
  String get datePickerDateTimeOrderString => r'date_time_dayPeriod';

  @override
  String get datePickerHourSemanticsLabelOne => r'bir saat';

  @override
  String get datePickerHourSemanticsLabelOther => r'$hour saat';

  @override
  String get datePickerMinuteSemanticsLabelOne => r'bir dakika';

  @override
  String get datePickerMinuteSemanticsLabelOther => r'$minute dakika';

  @override
  String get pasteButtonLabel => r'Yapıştır';

  @override
  String get postMeridiemAbbreviation => r'ÖS';

  @override
  String get selectAllButtonLabel => r'Tümünü Seç';

  @override
  String get timerPickerHourLabelOne => r'saat';

  @override
  String get timerPickerHourLabelOther => r'saat';

  @override
  String get timerPickerMinuteLabelOne => r'dk.';

  @override
  String get timerPickerMinuteLabelOther => r'dk.';

  @override
  String get timerPickerSecondLabelOne => r'sn.';

  @override
  String get timerPickerSecondLabelOther => r'sn.';

  @override
  String get todayLabel => r'Bugün';
}

/// The set of supported languages, as language code strings.
///
/// The [GlobalCupertinoLocalizations.delegate] can generate localizations for
/// any [Locale] with a language code from this set, regardless of the region.
/// Some regions have specific support (e.g. `de` covers all forms of German,
/// but there is support for `de-CH` specifically to override some of the
/// translations for Switzerland).
///
/// See also:
///
///  * [getCupertinoTranslation], whose documentation describes these values.
final Set<String> kCupertinoSupportedLanguages = HashSet<String>.from(const <String>[
  'en', // English
  'fr', // French
  'tr', // Turkish
]);

/// Creates a [GlobalCupertinoLocalizations] instance for the given `locale`.
///
/// All of the function's arguments except `locale` will be passed to the [
/// GlobalCupertinoLocalizations] constructor. (The `localeName` argument of that
/// constructor is specified by the actual subclass constructor by this
/// function.)
///
/// The following locales are supported by this package:
///
/// {@template flutter.localizations.cupertino.languages}
///  * `en` - English
///  * `fr` - French
///  * `tr` - Turkish
/// {@endtemplate}
///
/// Generally speaking, this method is only intended to be used by
/// [GlobalCupertinoLocalizations.delegate].
GlobalCupertinoLocalizations getCupertinoTranslation(
  Locale locale,
  intl.DateFormat fullYearFormat,
  intl.DateFormat dayFormat,
  intl.DateFormat mediumDateFormat,
  intl.DateFormat singleDigitHourFormat,
  intl.DateFormat singleDigitMinuteFormat,
  intl.DateFormat doubleDigitMinuteFormat,
  intl.DateFormat singleDigitSecondFormat,
  intl.NumberFormat decimalFormat,
) {
  switch (locale.languageCode) {
    case 'en':
      return CupertinoLocalizationEn(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'fr':
      return CupertinoLocalizationFr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
    case 'tr':
      return CupertinoLocalizationTr(fullYearFormat: fullYearFormat, dayFormat: dayFormat, mediumDateFormat: mediumDateFormat, singleDigitHourFormat: singleDigitHourFormat, singleDigitMinuteFormat: singleDigitMinuteFormat, doubleDigitMinuteFormat: doubleDigitMinuteFormat, singleDigitSecondFormat: singleDigitSecondFormat, decimalFormat: decimalFormat);
  }
  assert(false, 'getCupertinoTranslation() called for unsupported locale "$locale"');
  return null;
}
