package configuration;

import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MQConfig {

    public static final String EXCHANGE = "req_exchange";

    public static final String SeasonInfoReqQueue = "seasonReq_queue";
    public static final String SeasonInfoRespQueue = "seasonResp_queue";

    public static final String SEA_REQ_ROUTING_KEY = "SEA_REQ_RK";
    public static final String SEA_RES_ROUTING_KEY = "SEA_RES_RK";


    @Bean
    public Queue SeasonInfoReqQueue() {
        return new Queue(SeasonInfoReqQueue);
    }
    @Bean
    public Queue SeasonInfoRespQueue() {
        return new Queue(SeasonInfoRespQueue);
    }
    @Bean
    public TopicExchange topicExchange() {
        return new TopicExchange(EXCHANGE);
    }

    @Bean
    public Binding reqBinding() {
        return BindingBuilder.bind(SeasonInfoReqQueue()).to(topicExchange()).with(SEA_REQ_ROUTING_KEY);
    }
    @Bean
    public Binding respBinding(){
        return BindingBuilder.bind(SeasonInfoRespQueue()).to(topicExchange()).with(SEA_RES_ROUTING_KEY);
    }
    @Bean
    public MessageConverter messageConverter() {
        return new Jackson2JsonMessageConverter();
    }

    @Bean
    public AmqpTemplate amqpTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate template = new RabbitTemplate(connectionFactory);
        template.setMessageConverter(messageConverter());
        return template;
    }
}
