/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.servlet.handler.RequestMatchResult;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

class PathPatternMatchableHandlerMapping
implements MatchableHandlerMapping {
    private static final int MAX_PATTERNS = 1024;
    private final MatchableHandlerMapping delegate;
    private final PathPatternParser parser;
    private final Map<String, PathPattern> pathPatternCache = new ConcurrentHashMap<String, PathPattern>();

    public PathPatternMatchableHandlerMapping(MatchableHandlerMapping delegate) {
        Assert.notNull((Object)delegate, "HandlerMapping to delegate to is required.");
        Assert.notNull((Object)delegate.getPatternParser(), "Expected HandlerMapping configured to use PatternParser.");
        this.delegate = delegate;
        this.parser = delegate.getPatternParser();
    }

    @Override
    @Nullable
    public RequestMatchResult match(HttpServletRequest request, String pattern) {
        PathContainer path;
        PathPattern pathPattern = this.pathPatternCache.computeIfAbsent(pattern, value -> {
            Assert.state(this.pathPatternCache.size() < 1024, "Max size for pattern cache exceeded.");
            return this.parser.parse(pattern);
        });
        return pathPattern.matches(path = ServletRequestPathUtils.getParsedRequestPath(request).pathWithinApplication()) ? new RequestMatchResult(pathPattern, path) : null;
    }

    @Override
    @Nullable
    public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        return this.delegate.getHandler(request);
    }
}

