/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.Conventions;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.validation.method.MethodValidator;
import org.springframework.validation.method.ParameterErrors;
import org.springframework.validation.method.ParameterValidationResult;

public class MethodValidationAdapter
implements MethodValidator {
    private static final MethodValidationResult emptyValidationResult = MethodValidationResult.emptyResult();
    private static final ObjectNameResolver defaultObjectNameResolver = new DefaultObjectNameResolver();
    private static final Comparator<ParameterValidationResult> resultComparator = new ResultComparator();
    private final Supplier<Validator> validator;
    private final Supplier<SpringValidatorAdapter> validatorAdapter;
    private MessageCodesResolver messageCodesResolver = new DefaultMessageCodesResolver();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private ObjectNameResolver objectNameResolver = defaultObjectNameResolver;

    public MethodValidationAdapter() {
        this.validator = SingletonSupplier.of(() -> Validation.buildDefaultValidatorFactory().getValidator());
        this.validatorAdapter = MethodValidationAdapter.initValidatorAdapter(this.validator);
    }

    public MethodValidationAdapter(ValidatorFactory validatorFactory) {
        if (validatorFactory instanceof SpringValidatorAdapter) {
            SpringValidatorAdapter adapter = (SpringValidatorAdapter)validatorFactory;
            this.validator = () -> adapter;
            this.validatorAdapter = () -> adapter;
        } else {
            this.validator = SingletonSupplier.of(() -> ((ValidatorFactory)validatorFactory).getValidator());
            this.validatorAdapter = SingletonSupplier.of(() -> new SpringValidatorAdapter(this.validator.get()));
        }
    }

    public MethodValidationAdapter(Validator validator) {
        this.validator = () -> validator;
        this.validatorAdapter = MethodValidationAdapter.initValidatorAdapter(this.validator);
    }

    public MethodValidationAdapter(Supplier<Validator> validator) {
        this.validator = validator;
        this.validatorAdapter = MethodValidationAdapter.initValidatorAdapter(validator);
    }

    private static Supplier<SpringValidatorAdapter> initValidatorAdapter(Supplier<Validator> validatorSupplier) {
        return SingletonSupplier.of(() -> {
            SpringValidatorAdapter sva;
            Validator validator = (Validator)validatorSupplier.get();
            return validator instanceof SpringValidatorAdapter ? (sva = (SpringValidatorAdapter)validator) : new SpringValidatorAdapter(validator);
        });
    }

    public Supplier<SpringValidatorAdapter> getSpringValidatorAdapter() {
        return this.validatorAdapter;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    public void setObjectNameResolver(ObjectNameResolver nameResolver) {
        this.objectNameResolver = nameResolver;
    }

    @Override
    public Class<?>[] determineValidationGroups(Object target, Method method) {
        Validated validatedAnn = AnnotationUtils.findAnnotation(method, Validated.class);
        if (validatedAnn == null) {
            if (AopUtils.isAopProxy(target)) {
                Class<?> type;
                Class<?>[] classArray = AopProxyUtils.proxiedUserInterfaces(target);
                int n = classArray.length;
                for (int j = 0; j < n && (validatedAnn = AnnotationUtils.findAnnotation(type = classArray[j], Validated.class)) == null; ++j) {
                }
            } else {
                validatedAnn = AnnotationUtils.findAnnotation(target.getClass(), Validated.class);
            }
        }
        return validatedAnn != null ? validatedAnn.value() : new Class[]{};
    }

    @Override
    public final MethodValidationResult validateArguments(Object target, Method method, @Nullable MethodParameter[] parameters, Object[] arguments, Class<?>[] groups) {
        Set<ConstraintViolation<Object>> violations = this.invokeValidatorForArguments(target, method, arguments, groups);
        if (violations.isEmpty()) {
            return emptyValidationResult;
        }
        return this.adaptViolations(target, method, violations, i2 -> parameters != null ? parameters[i2] : this.initMethodParameter(method, (int)i2), i2 -> arguments[i2]);
    }

    public final Set<ConstraintViolation<Object>> invokeValidatorForArguments(Object target, Method method, Object[] arguments, Class<?>[] groups) {
        Set violations;
        ExecutableValidator execVal = this.validator.get().forExecutables();
        try {
            violations = execVal.validateParameters(target, method, arguments, (Class[])groups);
        }
        catch (IllegalArgumentException ex) {
            Method bridgedMethod = BridgeMethodResolver.getMostSpecificMethod(method, target.getClass());
            violations = execVal.validateParameters(target, bridgedMethod, arguments, (Class[])groups);
        }
        return violations;
    }

    @Override
    public final MethodValidationResult validateReturnValue(Object target, Method method, @Nullable MethodParameter returnType, @Nullable Object returnValue, Class<?>[] groups) {
        Set<ConstraintViolation<Object>> violations = this.invokeValidatorForReturnValue(target, method, returnValue, groups);
        if (violations.isEmpty()) {
            return emptyValidationResult;
        }
        return this.adaptViolations(target, method, violations, i2 -> returnType != null ? returnType : this.initMethodParameter(method, -1), i2 -> returnValue);
    }

    public final Set<ConstraintViolation<Object>> invokeValidatorForReturnValue(Object target, Method method, @Nullable Object returnValue, Class<?>[] groups) {
        ExecutableValidator execVal = this.validator.get().forExecutables();
        return execVal.validateReturnValue(target, method, returnValue, (Class[])groups);
    }

    private MethodValidationResult adaptViolations(Object target, Method method, Set<ConstraintViolation<Object>> violations, Function<Integer, MethodParameter> parameterFunction, Function<Integer, Object> argumentFunction) {
        LinkedHashMap<Path.Node, ParamValidationResultBuilder> paramViolations = new LinkedHashMap<Path.Node, ParamValidationResultBuilder>();
        LinkedHashMap<Path.Node, ParamErrorsBuilder> nestedViolations = new LinkedHashMap<Path.Node, ParamErrorsBuilder>();
        block0: for (ConstraintViolation<Object> violation : violations) {
            Iterator itr = violation.getPropertyPath().iterator();
            while (itr.hasNext()) {
                Object container;
                Object value;
                MethodParameter parameter;
                Path.Node node = (Path.Node)itr.next();
                if (node.getKind().equals((Object)ElementKind.PARAMETER)) {
                    int index = ((Path.ParameterNode)node.as(Path.ParameterNode.class)).getParameterIndex();
                    parameter = parameterFunction.apply(index);
                } else {
                    if (!node.getKind().equals((Object)ElementKind.RETURN_VALUE)) continue;
                    parameter = parameterFunction.apply(-1);
                }
                Object arg = argumentFunction.apply(parameter.getParameterIndex());
                Path.Node parameterNode = node;
                if (itr.hasNext()) {
                    node = (Path.Node)itr.next();
                }
                Integer index = node.getIndex();
                Object key2 = node.getKey();
                if (index != null && arg instanceof List) {
                    Object[] list = (Object[])arg;
                    value = list.get(index);
                    container = list;
                } else if (index != null && arg instanceof Object[]) {
                    Object[] array = (Object[])arg;
                    value = array[index];
                    container = array;
                } else if (key2 != null && arg instanceof Map) {
                    Map map = (Map)arg;
                    value = map.get(key2);
                    container = map;
                } else if (arg instanceof Optional) {
                    Optional optional = (Optional)arg;
                    value = optional.orElse(null);
                    container = optional;
                } else {
                    Assert.state(!node.isInIterable(), "No way to unwrap Iterable without index");
                    value = arg;
                    container = null;
                }
                if (node.getKind().equals((Object)ElementKind.PROPERTY)) {
                    nestedViolations.computeIfAbsent(parameterNode, k -> new ParamErrorsBuilder(parameter, value, container, index, key2)).addViolation(violation);
                    continue block0;
                }
                paramViolations.computeIfAbsent(parameterNode, p -> new ParamValidationResultBuilder(target, parameter, value, container, index, key2)).addViolation(violation);
                continue block0;
            }
        }
        ArrayList<ParameterValidationResult> resultList = new ArrayList<ParameterValidationResult>();
        paramViolations.forEach((param, builder) -> resultList.add(builder.build()));
        nestedViolations.forEach((key, builder) -> resultList.add(builder.build()));
        resultList.sort(resultComparator);
        return MethodValidationResult.create(target, method, resultList);
    }

    private MethodParameter initMethodParameter(Method method, int index) {
        MethodParameter parameter = new MethodParameter(method, index);
        parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
        return parameter;
    }

    private MessageSourceResolvable createMessageSourceResolvable(Object target, MethodParameter parameter, ConstraintViolation<Object> violation) {
        String objectName = Conventions.getVariableName(target) + "#" + parameter.getExecutable().getName();
        String paramName = parameter.getParameterName() != null ? parameter.getParameterName() : "";
        Class<?> parameterType = parameter.getParameterType();
        ConstraintDescriptor descriptor = violation.getConstraintDescriptor();
        String code = descriptor.getAnnotation().annotationType().getSimpleName();
        String[] codes = this.messageCodesResolver.resolveMessageCodes(code, objectName, paramName, parameterType);
        Object[] arguments = this.validatorAdapter.get().getArgumentsForConstraint(objectName, paramName, descriptor);
        return new DefaultMessageSourceResolvable(codes, arguments, violation.getMessage());
    }

    private BindingResult createBindingResult(MethodParameter parameter, @Nullable Object argument) {
        String objectName = this.objectNameResolver.resolveName(parameter, argument);
        BeanPropertyBindingResult result = new BeanPropertyBindingResult(argument, objectName);
        result.setMessageCodesResolver(this.messageCodesResolver);
        return result;
    }

    public static interface ObjectNameResolver {
        public String resolveName(MethodParameter var1, @Nullable Object var2);
    }

    private final class ParamErrorsBuilder {
        private final MethodParameter parameter;
        @Nullable
        private final Object bean;
        @Nullable
        private final Object container;
        @Nullable
        private final Integer containerIndex;
        @Nullable
        private final Object containerKey;
        private final Errors errors;
        private final Set<ConstraintViolation<Object>> violations = new LinkedHashSet<ConstraintViolation<Object>>();

        public ParamErrorsBuilder(@Nullable MethodParameter param, @Nullable Object bean2, @Nullable Object container, @Nullable Integer containerIndex, Object containerKey) {
            this.parameter = param;
            this.bean = bean2;
            this.container = container;
            this.containerIndex = containerIndex;
            this.containerKey = containerKey;
            this.errors = MethodValidationAdapter.this.createBindingResult(param, this.bean);
        }

        public void addViolation(ConstraintViolation<Object> violation) {
            this.violations.add(violation);
        }

        public ParameterErrors build() {
            MethodValidationAdapter.this.validatorAdapter.get().processConstraintViolations(this.violations, this.errors);
            return new ParameterErrors(this.parameter, this.bean, this.errors, this.container, this.containerIndex, this.containerKey);
        }
    }

    private final class ParamValidationResultBuilder {
        private final Object target;
        private final MethodParameter parameter;
        @Nullable
        private final Object value;
        @Nullable
        private final Object container;
        @Nullable
        private final Integer containerIndex;
        @Nullable
        private final Object containerKey;
        private final List<MessageSourceResolvable> resolvableErrors = new ArrayList<MessageSourceResolvable>();

        public ParamValidationResultBuilder(Object target, @Nullable MethodParameter parameter, @Nullable Object value, @Nullable Object container, @Nullable Integer containerIndex, Object containerKey) {
            this.target = target;
            this.parameter = parameter;
            this.value = value;
            this.container = container;
            this.containerIndex = containerIndex;
            this.containerKey = containerKey;
        }

        public void addViolation(ConstraintViolation<Object> violation) {
            this.resolvableErrors.add(MethodValidationAdapter.this.createMessageSourceResolvable(this.target, this.parameter, violation));
        }

        public ParameterValidationResult build() {
            return new ParameterValidationResult(this.parameter, this.value, this.resolvableErrors, this.container, this.containerIndex, this.containerKey);
        }
    }

    private static class DefaultObjectNameResolver
    implements ObjectNameResolver {
        private DefaultObjectNameResolver() {
        }

        @Override
        public String resolveName(MethodParameter parameter, @Nullable Object value) {
            Object objectName = null;
            if (parameter.getParameterIndex() != -1) {
                objectName = parameter.getParameterName();
            } else {
                try {
                    Method method = parameter.getMethod();
                    if (method != null) {
                        Class<?> containingClass = parameter.getContainingClass();
                        Class<?> resolvedType = GenericTypeResolver.resolveReturnType(method, containingClass);
                        objectName = Conventions.getVariableNameForReturnType(method, resolvedType, value);
                    }
                }
                catch (IllegalArgumentException method) {
                    // empty catch block
                }
            }
            if (objectName == null) {
                int index = parameter.getParameterIndex();
                objectName = parameter.getExecutable().getName() + (String)(index != -1 ? ".arg" + index : ".returnValue");
            }
            return objectName;
        }
    }

    private static final class ResultComparator
    implements Comparator<ParameterValidationResult> {
        private ResultComparator() {
        }

        @Override
        public int compare(ParameterValidationResult result1, ParameterValidationResult result2) {
            int index2;
            int index1 = result1.getMethodParameter().getParameterIndex();
            int i2 = Integer.compare(index1, index2 = result2.getMethodParameter().getParameterIndex());
            if (i2 != 0) {
                return i2;
            }
            if (result1 instanceof ParameterErrors) {
                ParameterErrors errors1 = (ParameterErrors)result1;
                if (result2 instanceof ParameterErrors) {
                    ParameterErrors errors2 = (ParameterErrors)result2;
                    Integer containerIndex1 = errors1.getContainerIndex();
                    Integer containerIndex2 = errors2.getContainerIndex();
                    if (containerIndex1 != null && containerIndex2 != null && (i2 = Integer.compare(containerIndex1, containerIndex2)) != 0) {
                        return i2;
                    }
                    i2 = this.compareKeys(errors1, errors2);
                    return i2;
                }
            }
            return 0;
        }

        private <E> int compareKeys(ParameterErrors errors1, ParameterErrors errors2) {
            Object key1 = errors1.getContainerKey();
            Object key2 = errors2.getContainerKey();
            if (key1 instanceof Comparable && key2 instanceof Comparable) {
                return ((Comparable)key1).compareTo(key2);
            }
            return 0;
        }
    }
}

